/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage;

import com.eucalyptus.auth.principal.User;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.objectstorage.BucketFactory;
import com.eucalyptus.objectstorage.BucketLifecycleManagers;
import com.eucalyptus.objectstorage.BucketMetadataManagers;
import com.eucalyptus.objectstorage.BucketState;
import com.eucalyptus.objectstorage.BucketTaggingManagers;
import com.eucalyptus.objectstorage.MpuPartMetadataManagers;
import com.eucalyptus.objectstorage.ObjectMetadataManagers;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.exceptions.IllegalResourceStateException;
import com.eucalyptus.objectstorage.exceptions.MetadataOperationFailureException;
import com.eucalyptus.objectstorage.exceptions.NoSuchEntityException;
import com.eucalyptus.objectstorage.exceptions.s3.BucketAlreadyExistsException;
import com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.NoSuchBucketException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.msgs.CreateBucketResponseType;
import com.eucalyptus.objectstorage.msgs.CreateBucketType;
import com.eucalyptus.objectstorage.msgs.DeleteBucketType;
import com.eucalyptus.objectstorage.providers.ObjectStorageProviderClient;
import com.eucalyptus.storage.msgs.s3.AccessControlList;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class BucketFactoryImpl
implements BucketFactory {
    private static final Logger LOG = Logger.getLogger(BucketFactoryImpl.class);

    @Override
    public Bucket createBucket(@Nonnull ObjectStorageProviderClient backendProvider, @Nonnull Bucket bucket, @Nullable String correlationId, @Nullable User requestUser) throws S3Exception {
        if (correlationId == null) {
            correlationId = "unknown";
        }
        try {
            bucket = BucketMetadataManagers.getInstance().transitionBucketToState(bucket, BucketState.creating);
        }
        catch (IllegalResourceStateException e) {
            throw new BucketAlreadyExistsException(bucket.getBucketName());
        }
        catch (MetadataOperationFailureException | ConstraintViolationException e) {
            throw new BucketAlreadyExistsException(bucket.getBucketName());
        }
        catch (Exception e) {
            LOG.error((Object)"Error initiating bucket creation in metadata. Failing operation", (Throwable)e);
            InternalErrorException ex = new InternalErrorException(bucket.getBucketName());
            ex.initCause((Throwable)e);
            throw ex;
        }
        if (bucket == null) {
            LOG.error((Object)("CorrelationId: " + correlationId + "Unexpected internal error. Got null bucket when not expected. Cannot continue bucket creation for " + bucket.getBucketName()));
            throw new InternalErrorException("Internal error.");
        }
        if (BucketState.creating.equals((Object)bucket.getState())) {
            CreateBucketResponseType backendResponse = null;
            try {
                CreateBucketType request = new CreateBucketType();
                request.setAccessControlList(new AccessControlList());
                request.setBucket(bucket.getBucketUuid());
                request.setUser(requestUser);
                backendResponse = backendProvider.createBucket(request);
                return BucketMetadataManagers.getInstance().transitionBucketToState(bucket, BucketState.extant);
            }
            catch (EucalyptusCloudException e) {
                LOG.error((Object)"Bucket creation failed due to error response from backend.", (Throwable)e);
                if (e instanceof S3Exception) {
                    LOG.error((Object)("Error creating bucket " + bucket.getBucketName()), (Throwable)e);
                    throw (S3Exception)((Object)e);
                }
                InternalErrorException ex = new InternalErrorException();
                ex.initCause((Throwable)e);
                throw ex;
            }
            catch (Exception e) {
                LOG.warn((Object)("Unknown exception caused failure of CreateBucket for bucket " + bucket.getBucketName()), (Throwable)e);
                InternalErrorException ex = new InternalErrorException(bucket.getBucketName());
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
        throw new BucketAlreadyExistsException(bucket.getBucketName());
    }

    @Override
    public void deleteBucket(final @Nonnull ObjectStorageProviderClient backendProvider, @Nonnull Bucket bucketToDelete, @Nullable String correlationId, @Nullable User requestUser) throws S3Exception {
        Bucket deletingBucket;
        try {
            deletingBucket = BucketMetadataManagers.getInstance().transitionBucketToState(bucketToDelete, BucketState.deleting);
        }
        catch (IllegalResourceStateException e) {
            LOG.trace((Object)("CorrelationId: " + correlationId + " Unexpected resource state on delete update."), (Throwable)e);
            throw e;
        }
        catch (MetadataOperationFailureException e) {
            LOG.trace((Object)("CorrelationId: " + correlationId + " Could not transition bucket " + bucketToDelete.toString() + " to 'deleting' state."), (Throwable)e);
            throw e;
        }
        try {
            ObjectMetadataManagers.getInstance().flushUploads(bucketToDelete);
            MpuPartMetadataManagers.getInstance().flushAllParts(bucketToDelete);
            BucketLifecycleManagers.getInstance().deleteLifecycleRules(bucketToDelete.getBucketUuid());
            BucketTaggingManagers.getInstance().deleteBucketTagging(bucketToDelete.getBucketUuid());
        }
        catch (Exception e) {
            LOG.warn((Object)"Error flushing MPU parts during bucket deletion operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        Predicate<Bucket> deleteBucket = new Predicate<Bucket>(){

            public boolean apply(Bucket bucket) {
                block5: {
                    DeleteBucketType deleteRequest = new DeleteBucketType();
                    deleteRequest.setBucket(bucket.getBucketUuid());
                    try {
                        backendProvider.deleteBucket(deleteRequest);
                    }
                    catch (NoSuchEntityException | NoSuchBucketException throwable) {
                    }
                    catch (S3Exception e) {
                        if (HttpResponseStatus.NOT_FOUND.equals((Object)e.getStatus())) break block5;
                        LOG.warn((Object)"Got error during bucket cleanup. Will retry", (Throwable)e);
                        return false;
                    }
                }
                try {
                    BucketMetadataManagers.getInstance().deleteBucketMetadata(bucket);
                    return true;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error removing bucket metadata for bucket " + bucket.getBucketUuid() + " Will retry later"), (Throwable)e);
                    return false;
                }
            }
        };
        try {
            Entities.asTransaction(Bucket.class, (Predicate)deleteBucket).apply((Object)deletingBucket);
        }
        catch (Exception e) {
            try {
                Bucket foundBucket = BucketMetadataManagers.getInstance().lookupBucket(bucketToDelete.getBucketName());
                LOG.trace((Object)("CorrelationId: " + correlationId + " Error deleting bucket " + bucketToDelete.toString()), (Throwable)e);
                throw new InternalErrorException(bucketToDelete.getBucketName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

