/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vmtypes;

import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.cluster.ResourceState;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.VmTypeDetails;
import com.eucalyptus.compute.common.VmTypeEphemeralDisk;
import com.eucalyptus.compute.common.VmTypeZoneStatus;
import com.eucalyptus.compute.common.backend.DescribeInstanceTypesResponseType;
import com.eucalyptus.compute.common.backend.DescribeInstanceTypesType;
import com.eucalyptus.compute.common.backend.ModifyInstanceTypeAttributeResponseType;
import com.eucalyptus.compute.common.backend.ModifyInstanceTypeAttributeType;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.vmtypes.EphemeralDisk;
import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.annotation.Nullable;

public class VmTypesManager {
    public DescribeInstanceTypesResponseType DescribeInstanceTypes(final DescribeInstanceTypesType request) {
        DescribeInstanceTypesResponseType reply = (DescribeInstanceTypesResponseType)request.getReply();
        for (final VmType v : Iterables.filter(VmTypes.list(), (Predicate)CloudMetadatas.filteringFor(VmType.class).byId((Collection)request.getInstanceTypes()).byPrivileges().buildPredicate())) {
            VmTypeDetails vmTypeDetails = new VmTypeDetails(){
                {
                    this.setName(v.getName());
                    this.setDisk(v.getDisk());
                    this.setCpu(v.getCpu());
                    this.setMemory(v.getMemory());
                    if (request.getVerbose().booleanValue()) {
                        for (EphemeralDisk e : v.getEpehemeralDisks()) {
                            this.getEphemeralDisk().add(new VmTypeEphemeralDisk(e.getDiskName(), e.getDeviceName(), e.getSize(), e.getFormat().name()));
                        }
                    }
                    if (request.getAvailability().booleanValue()) {
                        for (ServiceConfiguration cc : Topology.enabledServices(ClusterController.class)) {
                            ResourceState.VmTypeAvailability available = Clusters.lookup(cc).getNodeState().getAvailability(v.getName());
                            VmTypeZoneStatus status = VmAvailabilityToZoneStatus.INSTANCE.apply(available);
                            status.setZoneName(cc.getPartition());
                            this.getAvailability().add(status);
                        }
                    }
                }
            };
            reply.getInstanceTypeDetails().add(vmTypeDetails);
        }
        return reply;
    }

    public ModifyInstanceTypeAttributeResponseType modifyVmType(final ModifyInstanceTypeAttributeType request) throws EucalyptusCloudException {
        ModifyInstanceTypeAttributeResponseType reply = (ModifyInstanceTypeAttributeResponseType)request.getReply();
        if (Contexts.lookup().isAdministrator()) {
            Function<String, VmType> modifyFunc = new Function<String, VmType>(){

                public VmType apply(String vmTypeName) {
                    try {
                        VmType vmType = VmTypes.lookup(vmTypeName);
                        if (request.getReset().booleanValue()) {
                            VmTypes.PredefinedTypes defaultVmType = VmTypes.PredefinedTypes.valueOf(vmTypeName.toUpperCase().replace(".", ""));
                            vmType.setCpu(defaultVmType.getCpu());
                            vmType.setDisk(defaultVmType.getDisk());
                            vmType.setMemory(defaultVmType.getMemory());
                        } else {
                            vmType.setCpu((Integer)Objects.firstNonNull((Object)request.getCpu(), (Object)vmType.getCpu()));
                            vmType.setDisk((Integer)Objects.firstNonNull((Object)request.getDisk(), (Object)vmType.getDisk()));
                            vmType.setMemory((Integer)Objects.firstNonNull((Object)request.getMemory(), (Object)vmType.getMemory()));
                        }
                        VmTypes.update(vmType);
                        return vmType;
                    }
                    catch (NoSuchMetadataException ex) {
                        throw Exceptions.toUndeclared((Throwable)ex);
                    }
                }
            };
            try {
                VmType before = VmTypes.lookup(request.getName());
                if (!RestrictedTypes.filterPrivileged().apply((Object)before)) {
                    throw new EucalyptusCloudException("Authorization failed.");
                }
                VmType after = (VmType)((Object)Entities.asTransaction((Function)modifyFunc).apply((Object)request.getName()));
                reply.setPreviousInstanceType((VmTypeDetails)TypeMappers.transform((Object)((Object)before), VmTypeDetails.class));
                reply.setInstanceType((VmTypeDetails)TypeMappers.transform((Object)((Object)after), VmTypeDetails.class));
            }
            catch (NoSuchMetadataException ex) {
                throw new EucalyptusCloudException("Failed to lookup the requested instance type: " + request.getName(), (Throwable)ex);
            }
        } else {
            throw new EucalyptusCloudException("Authorization failed.");
        }
        return reply;
    }

    static enum VmAvailabilityToZoneStatus implements Function<ResourceState.VmTypeAvailability, VmTypeZoneStatus>
    {
        INSTANCE;


        public VmTypeZoneStatus apply(final @Nullable ResourceState.VmTypeAvailability input) {
            return new VmTypeZoneStatus(){
                {
                    this.setName(input.getType().getName());
                    this.setMax(input.getMax());
                    this.setAvailable(input.getAvailable());
                }
            };
        }
    }
}

