/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vmtypes;

import com.eucalyptus.cloud.util.InvalidMetadataException;
import com.eucalyptus.cloud.util.MetadataException;
import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.VmTypeDetails;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.images.BlockStorageImageInfo;
import com.eucalyptus.images.BootableImageInfo;
import com.eucalyptus.images.ImageManager;
import com.eucalyptus.images.MachineImageInfo;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.LockResource;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.vmtypes.EphemeralDisk;
import com.eucalyptus.vmtypes.VmType;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ForwardingConcurrentMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.msgs.VmTypeInfo;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

@ConfigurableClass(root="cloud.vmtypes", description="Parameters controlling the definition of virtual machine types.")
public class VmTypes {
    private static Logger LOG = Logger.getLogger(VmTypes.class);
    @ConfigurableField(description="Default type used when no instance type is specified for run instances.", initial="m1.small")
    public static String DEFAULT_TYPE_NAME = "m1.small";
    @Deprecated
    protected static final Long SWAP_SIZE_BYTES = 0x20000000L;
    @Deprecated
    private static final long MIN_EPHEMERAL_SIZE_BYTES = 61440L;
    private static final Integer GB = 1024;
    private static final Integer ROOTFS = 10;

    public static boolean isUnorderedType(VmType vmType) {
        return Iterables.any(VmTypes.list(), vmType.orderedPredicate());
    }

    public static VmType update(VmType newVmType) throws NoSuchMetadataException {
        VmType vmType;
        VmType resultType = vmType = VmTypes.lookup(newVmType.getName());
        if (vmType != null) {
            Registry.INSTANCE.replace(newVmType);
            resultType = Registry.get(newVmType.getDisplayName());
        } else {
            Registry.INSTANCE.putIfAbsent(newVmType);
            resultType = Registry.get(newVmType.getDisplayName());
        }
        ClusterAvailability.reset();
        return resultType;
    }

    public static synchronized VmType lookup(String name) throws NoSuchMetadataException {
        return Registry.get(name);
    }

    public static synchronized NavigableSet<VmType> list() {
        return Registry.list();
    }

    public static String defaultTypeName() {
        return DEFAULT_TYPE_NAME;
    }

    public static VmTypeInfo asVmTypeInfo(VmType vmType, BootableImageInfo img) throws MetadataException {
        Long imgSize = img.getImageSizeBytes();
        Long diskSize = (long)vmType.getDisk().intValue() * 1024L * 1024L * 1024L;
        if (!(img instanceof BlockStorageImageInfo) && imgSize > diskSize) {
            throw new InvalidMetadataException("image too large [size=" + imgSize / 0x100000L + "MB] for instance type " + vmType.getName() + " [disk=" + (long)vmType.getDisk().intValue() * 1024L + "MB]");
        }
        VmTypeInfo vmTypeInfo = null;
        if (img instanceof MachineImageInfo) {
            if (ImageMetadata.Platform.windows.equals((Object)img.getPlatform())) {
                vmTypeInfo = InstanceStoreWindowsVmTypeInfoMapper.INSTANCE.apply(vmType);
                vmTypeInfo.setEphemeral(Integer.valueOf(0), "sdb", Long.valueOf(diskSize - imgSize), "none");
            } else if (!ImageManager.isPathAPartition(img.getRootDeviceName())) {
                vmTypeInfo = InstanceStoreLinuxHvmVmTypeInfoMapper.INSTANCE.apply(vmType);
                vmTypeInfo.setEphemeral(Integer.valueOf(0), "sdb", Long.valueOf(diskSize - imgSize), "ext3");
            } else {
                vmTypeInfo = InstanceStoreVmTypeInfoMapper.INSTANCE.apply(vmType);
                long ephemeralSize = diskSize - imgSize - SWAP_SIZE_BYTES;
                if (ephemeralSize < 61440L) {
                    throw new InvalidMetadataException("image too large to accommodate swap and ephemeral [size=" + imgSize / 0x100000L + "MB] for instance type " + vmType.getName() + " [disk=" + (long)vmType.getDisk().intValue() * 1024L + "MB]");
                }
                vmTypeInfo.setEphemeral(Integer.valueOf(0), "sda2", Long.valueOf(ephemeralSize), "ext3");
            }
        } else if (img instanceof BlockStorageImageInfo) {
            vmTypeInfo = BlockStorageVmTypeInfoMapper.INSTANCE.apply(vmType);
            vmTypeInfo.setRootDeviceName(img.getRootDeviceName());
            vmTypeInfo.setEbsRoot(img.getDisplayName(), null, imgSize);
        } else {
            throw new InvalidMetadataException("Failed to identify the root machine image type: " + img);
        }
        return vmTypeInfo;
    }

    static /* synthetic */ Integer access$300() {
        return ROOTFS;
    }

    static /* synthetic */ Integer access$400() {
        return GB;
    }

    @TypeMapper
    public static enum VmTypeToVmTypeDetails implements Function<VmType, VmTypeDetails>
    {
        INSTANCE;


        @Nonnull
        public VmTypeDetails apply(VmType vmType) {
            VmTypeDetails vmTypeDetails = new VmTypeDetails();
            vmTypeDetails.setName(vmType.getName());
            vmTypeDetails.setCpu(vmType.getCpu());
            vmTypeDetails.setDisk(vmType.getDisk());
            vmTypeDetails.setMemory(vmType.getMemory());
            return vmTypeDetails;
        }
    }

    private static enum BlockStorageVmTypeInfoMapper implements Function<VmType, VmTypeInfo>
    {
        INSTANCE;


        public VmTypeInfo apply(VmType arg0) {
            return new VmTypeInfo(arg0.getName(), arg0.getMemory(), arg0.getDisk(), arg0.getCpu(), "sda");
        }
    }

    private static enum InstanceStoreLinuxHvmVmTypeInfoMapper implements Function<VmType, VmTypeInfo>
    {
        INSTANCE;


        public VmTypeInfo apply(VmType arg0) {
            return new VmTypeInfo(arg0.getName(), arg0.getMemory(), arg0.getDisk(), arg0.getCpu(), "sda");
        }
    }

    private static enum InstanceStoreWindowsVmTypeInfoMapper implements Function<VmType, VmTypeInfo>
    {
        INSTANCE;


        public VmTypeInfo apply(VmType arg0) {
            return new VmTypeInfo(arg0.getName(), arg0.getMemory(), arg0.getDisk(), arg0.getCpu(), "sda");
        }
    }

    private static enum InstanceStoreVmTypeInfoMapper implements Function<VmType, VmTypeInfo>
    {
        INSTANCE;


        public VmTypeInfo apply(VmType arg0) {
            return new VmTypeInfo(arg0.getName(), arg0.getMemory(), arg0.getDisk(), arg0.getCpu(), "sda"){
                {
                    this.setSwap("sda3", SWAP_SIZE_BYTES);
                }
            };
        }
    }

    static enum PredefinedTypes {
        T1MICRO("t1.micro", (Integer)1, (Integer)(VmTypes.access$300() / 2), (Integer)(VmTypes.access$400() / 4), Attribute.ebsonly, new EphemeralDisk[0]),
        M1SMALL("m1.small", (Integer)1, (Integer)(VmTypes.access$300() / 2), (Integer)(VmTypes.access$400() / 4), VirtualDevice.ephemeral0.create("/dev/sda2", 10, Format.ext3), VirtualDevice.ephemeral1.create("/dev/sda3", 1, Format.swap)),
        M1MEDIUM("m1.medium", (Integer)1, VmTypes.access$300(), (Integer)(VmTypes.access$400() / 2), VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3)),
        C1MEDIUM("c1.medium", (Integer)2, VmTypes.access$300(), (Integer)(VmTypes.access$400() / 2), VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3)),
        M1LARGE("m1.large", (Integer)2, VmTypes.access$300(), (Integer)(VmTypes.access$400() / 2), VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3), VirtualDevice.ephemeral1.create("/dev/sdc", 20, Format.ext3)),
        M1XLARGE("m1.xlarge", (Integer)2, VmTypes.access$300(), VmTypes.access$400(), VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3), VirtualDevice.ephemeral1.create("/dev/sdc", 20, Format.ext3), VirtualDevice.ephemeral2.create("/dev/sdd", 20, Format.ext3), VirtualDevice.ephemeral3.create("/dev/sde", 20, Format.ext3)),
        M2XLARGE("m2.xlarge", (Integer)2, VmTypes.access$300(), (Integer)(2 * VmTypes.access$400()), VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3)),
        C1XLARGE("c1.xlarge", (Integer)2, VmTypes.access$300(), (Integer)(2 * VmTypes.access$400()), VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3), VirtualDevice.ephemeral1.create("/dev/sdc", 20, Format.ext3), VirtualDevice.ephemeral2.create("/dev/sdd", 20, Format.ext3), VirtualDevice.ephemeral3.create("/dev/sde", 20, Format.ext3)),
        M3XLARGE("m3.xlarge", (Integer)4, (Integer)(VmTypes.access$300() + VmTypes.access$300() / 2), (Integer)(2 * VmTypes.access$400()), Attribute.ebsonly, new EphemeralDisk[0]),
        M22XLARGE("m2.2xlarge", (Integer)2, (Integer)(3 * VmTypes.access$300()), (Integer)(4 * VmTypes.access$400()), VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3)),
        M32XLARGE("m3.2xlarge", (Integer)4, (Integer)(3 * VmTypes.access$300()), (Integer)(4 * VmTypes.access$400()), Attribute.ebsonly, new EphemeralDisk[0]),
        CC14XLARGE("cc1.4xlarge", (Integer)8, (Integer)(6 * VmTypes.access$300()), (Integer)(3 * VmTypes.access$400()), VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3), VirtualDevice.ephemeral1.create("/dev/sdc", 20, Format.ext3)),
        M24XLARGE("m2.4xlarge", (Integer)8, (Integer)(6 * VmTypes.access$300()), (Integer)(4 * VmTypes.access$400()), VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3), VirtualDevice.ephemeral1.create("/dev/sdc", 20, Format.ext3)),
        HI14XLARGE("hi1.4xlarge", (Integer)8, (Integer)(12 * VmTypes.access$300()), (Integer)(6 * VmTypes.access$400()), Attribute.ssd, VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3), VirtualDevice.ephemeral1.create("/dev/sdc", 20, Format.ext3)),
        CC28XLARGE("cc2.8xlarge", (Integer)16, (Integer)(12 * VmTypes.access$300()), (Integer)(6 * VmTypes.access$400()), VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3), VirtualDevice.ephemeral1.create("/dev/sdc", 20, Format.ext3), VirtualDevice.ephemeral2.create("/dev/sdd", 20, Format.ext3), VirtualDevice.ephemeral3.create("/dev/sde", 20, Format.ext3)),
        CG14XLARGE("cg1.4xlarge", (Integer)16, (Integer)(20 * VmTypes.access$300()), (Integer)(12 * VmTypes.access$400()), Attribute.gpu, VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3), VirtualDevice.ephemeral1.create("/dev/sdc", 20, Format.ext3)),
        CR18XLARGE("cr1.8xlarge", (Integer)16, (Integer)(24 * VmTypes.access$300()), (Integer)(16 * VmTypes.access$400()), Attribute.ssd, VirtualDevice.ephemeral0.create("/dev/sdb", 20, Format.ext3), VirtualDevice.ephemeral1.create("/dev/sdc", 20, Format.ext3)),
        HS18XLARGE("hs1.8xlarge", (Integer)48, (Integer)(2400 * VmTypes.access$300()), (Integer)(117 * VmTypes.access$400()), new EphemeralDisk[0]){
            {
                for (int i = 0; i < 24; ++i) {
                    this.getEphemeralDisks().add(VirtualDevice.create(i, "/dev/sdb", 20, Format.ext3));
                }
            }
        };

        private final String name;
        private final Integer cpu;
        private final Integer disk;
        private final Integer memory;
        private final Boolean ebsOnly;
        private final Integer ethernetInterfaceLimit;
        private final Set<EphemeralDisk> ephemeralDisks = Sets.newHashSet();

        private PredefinedTypes(String name, Integer cpu, Integer disk, Integer memory, EphemeralDisk ... disks) {
            this.name = name;
            this.cpu = cpu;
            this.disk = disk;
            this.memory = memory;
            this.ethernetInterfaceLimit = 1;
            this.ebsOnly = Boolean.FALSE;
        }

        private PredefinedTypes(String name, Integer cpu, Integer disk, Integer memory, Attribute attribute, EphemeralDisk ... disks) {
            this.name = name;
            this.cpu = cpu;
            this.disk = disk;
            this.memory = memory;
            this.ethernetInterfaceLimit = 1;
            this.ebsOnly = Attribute.ebsonly.equals((Object)attribute);
        }

        public String getName() {
            return this.name;
        }

        public Integer getCpu() {
            return this.cpu;
        }

        public Integer getDisk() {
            return this.disk;
        }

        public Integer getMemory() {
            return this.memory;
        }

        public Boolean getEbsOnly() {
            return this.ebsOnly;
        }

        public Integer getEthernetInterfaceLimit() {
            return this.ethernetInterfaceLimit;
        }

        public Set<EphemeralDisk> getEphemeralDisks() {
            return this.ephemeralDisks;
        }
    }

    static enum Attribute {
        ssd,
        gpu,
        ebsonly;

    }

    public static enum Format {
        swap,
        ext3,
        none;

    }

    static enum VirtualDevice {
        ephemeral0,
        ephemeral1,
        ephemeral2,
        ephemeral3;


        public EphemeralDisk create(String deviceName, Integer size) {
            return EphemeralDisk.create(this.name(), deviceName, size, Format.ext3);
        }

        public EphemeralDisk create(String deviceName, Integer size, Format format) {
            return EphemeralDisk.create(this.name(), deviceName, size, format);
        }

        private static EphemeralDisk create(Integer ephemeralIndex, String deviceName, Integer size, Format format) {
            return EphemeralDisk.create("ephemeral" + ephemeralIndex, deviceName, size, format);
        }
    }

    private static enum Registry {
        INSTANCE;

        private final ConcurrentMap<String, VmType> vmTypeMap = PersistentMap.create(VmTypeResolver.INSTANCE);
        private final AtomicMarkableReference<ConcurrentMap<String, VmType>> ref = new AtomicMarkableReference<Object>(null, false);

        private void initialize() {
            if (this.ref.compareAndSet(null, this.vmTypeMap, false, true) || this.vmTypeMap.size() != PredefinedTypes.values().length) {
                for (PredefinedTypes preDefVmType : PredefinedTypes.values()) {
                    VmType vmType = (VmType)((Object)this.vmTypeMap.get(preDefVmType.getName()));
                }
                this.ref.set(this.vmTypeMap, true);
            } else if (this.ref.compareAndSet(this.vmTypeMap, this.vmTypeMap, true, true) && this.vmTypeMap.size() != PredefinedTypes.values().length) {
                for (PredefinedTypes preDefVmType : PredefinedTypes.values()) {
                    if (this.vmTypeMap.containsKey(preDefVmType.getName())) continue;
                    this.vmTypeMap.putIfAbsent(preDefVmType.getName(), VmType.create(preDefVmType.getName(), preDefVmType.getCpu(), preDefVmType.getDisk(), preDefVmType.getMemory()));
                }
            }
        }

        public VmType putIfAbsent(VmType vmType) {
            INSTANCE.initialize();
            return Registry.INSTANCE.vmTypeMap.putIfAbsent(vmType.getDisplayName(), vmType);
        }

        public void replace(VmType newVmType) {
            INSTANCE.initialize();
            Registry.INSTANCE.vmTypeMap.replace(newVmType.getDisplayName(), newVmType);
        }

        static VmType get(String name) throws NoSuchMetadataException {
            INSTANCE.initialize();
            name = name == null ? DEFAULT_TYPE_NAME : name;
            Object ret = null;
            if (!Registry.INSTANCE.vmTypeMap.containsKey(name)) {
                throw new NoSuchMetadataException("Instance type does not exist: " + name);
            }
            return (VmType)((Object)Registry.INSTANCE.vmTypeMap.get(name));
        }

        public static NavigableSet<VmType> list() {
            INSTANCE.initialize();
            return Sets.newTreeSet(Registry.INSTANCE.vmTypeMap.values());
        }
    }

    private static class PersistentMap<K, V>
    extends ForwardingConcurrentMap<K, V> {
        private final ConcurrentNavigableMap<K, V> backingMap = new ConcurrentSkipListMap();
        private final Function<K, V> getFunction;
        private final Function<V, V> putFunction;
        private final Predicate<V> removeFunction;

        private PersistentMap(Function<K, V> getFunction) {
            Class valueType = (Class)Classes.genericsToClasses(getFunction).get(1);
            this.getFunction = Entities.asTransaction(getFunction);
            this.putFunction = Entities.asTransaction((Class)valueType, new Persister());
            this.removeFunction = Entities.asTransaction((Class)valueType, new Deleter());
        }

        public static <K, V> ConcurrentMap<K, V> create(Function<K, V> getFunction) {
            return new PersistentMap<K, V>(getFunction);
        }

        protected ConcurrentMap<K, V> delegate() {
            return this.backingMap;
        }

        public V remove(Object object) {
            V ret = null;
            Object v = this.delegate().remove(object);
            ret = v;
            if (v != null) {
                this.removeFunction.apply(object);
            }
            return ret;
        }

        public boolean remove(Object key, Object value) {
            if (this.delegate().containsKey(key) && this.delegate().get(key).equals(value) && this.removeFunction.apply(value)) {
                return this.delegate().remove(key, value);
            }
            return false;
        }

        public V get(Object key) {
            if (!this.delegate().containsKey(key)) {
                Object value = this.getFunction.apply(key);
                this.delegate().put(key, value);
            }
            return this.delegate().get(key);
        }

        public V put(K key, V value) {
            value = this.putFunction.apply(value);
            V oldValue = this.delegate().put(key, value);
            return oldValue;
        }

        public V putIfAbsent(K key, V value) {
            if (!this.delegate().containsKey(key)) {
                return this.put(key, value);
            }
            return this.get(key);
        }

        public V replace(K key, V value) {
            if (this.delegate().containsKey(key)) {
                return this.put(key, value);
            }
            return null;
        }

        public boolean replace(K key, V oldValue, V newValue) {
            if (this.containsKey(key) && this.get(key).equals(oldValue)) {
                this.put(key, newValue);
                return true;
            }
            return false;
        }

        private static class Deleter<V>
        implements Predicate<V> {
            private Deleter() {
            }

            public boolean apply(@Nullable V input) {
                try {
                    Entities.delete(input);
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }

        private static class Persister<V>
        implements Function<V, V> {
            private Persister() {
            }

            public V apply(@Nullable V input) {
                try {
                    return (V)Entities.mergeDirect(input);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
    }

    @RestrictedTypes.Resolver(value=CloudMetadata.VmTypeMetadata.class)
    private static enum VmTypeResolver implements Function<String, VmType>
    {
        INSTANCE;


        public VmType apply(@Nullable String input) {
            Entities.registerClose(VmType.class);
            try {
                VmType vmType = (VmType)((Object)Entities.uniqueResult((Object)((Object)VmType.named(input))));
                Iterators.size(vmType.getEpehemeralDisks().iterator());
                return vmType;
            }
            catch (Exception ex) {
                if (!(ex instanceof NoSuchElementException)) {
                    LOG.error((Object)ex);
                }
                LOG.debug((Object)ex, (Throwable)ex);
                PredefinedTypes t = PredefinedTypes.valueOf(input.toUpperCase().replace(".", ""));
                VmType vmType = VmType.create(input, t.getCpu(), t.getDisk(), t.getMemory());
                vmType = (VmType)((Object)Entities.persist((Object)((Object)vmType)));
                Iterators.size(vmType.getEpehemeralDisks().iterator());
                return vmType;
            }
        }
    }

    private static enum ClusterAvailability implements Predicate<ServiceConfiguration>
    {
        INSTANCE;


        public boolean apply(ServiceConfiguration input) {
            try {
                Cluster cluster = Clusters.lookup(input);
                try (LockResource lock = LockResource.tryLock((Lock)cluster.getGateLock().readLock(), (long)20L, (TimeUnit)TimeUnit.SECONDS);){
                    if (lock.isLocked()) {
                        cluster.refreshResources();
                    }
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to reset availability for cluster: " + input + " because of " + ex.getMessage()));
                LOG.debug((Object)("Failed to reset availability for cluster: " + input + " because of " + ex.getMessage()), (Throwable)ex);
            }
            return true;
        }

        public static void reset() {
            Iterables.all((Iterable)Topology.enabledServices(ClusterController.class), (Predicate)INSTANCE);
        }
    }
}

