/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vmtypes;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.HasFullName;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.vmtypes.EphemeralDisk;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="cloud_vm_type")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class VmType
extends AbstractPersistent
implements CloudMetadata.VmTypeMetadata,
HasFullName<CloudMetadata.VmTypeMetadata> {
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="config_vm_type_name")
    private String name;
    @Column(name="config_vm_type_cpu")
    private Integer cpu;
    @Column(name="config_vm_type_disk")
    private Integer disk;
    @Column(name="config_vm_type_memory")
    private Integer memory;
    @Column(name="config_vm_type_ebs_only")
    private Boolean ebsOnly;
    @Column(name="config_vm_type_ebs_iops")
    private Integer ebsIopsLimit;
    @Column(name="config_vm_type_64bit_only")
    private Boolean x86_64only;
    @ElementCollection
    @CollectionTable(name="config_vm_types_ephemeral_disks")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<EphemeralDisk> epehemeralDisks = Sets.newHashSet();

    private VmType() {
    }

    private VmType(String name) {
        this.name = name;
        this.setNaturalId(Crypto.getDigestBase64((String)name, (Digest)Digest.SHA1));
    }

    private VmType(String name, Integer cpu, Integer disk, Integer memory) {
        this(name);
        this.cpu = cpu;
        this.disk = disk;
        this.memory = memory;
    }

    public static VmType create() {
        return new VmType();
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCpu() {
        return this.cpu;
    }

    public void setCpu(Integer cpu) {
        this.cpu = cpu;
    }

    public Integer getDisk() {
        return this.disk;
    }

    public void setDisk(Integer disk) {
        this.disk = disk;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        VmType vmType = (VmType)((Object)o);
        if (!this.cpu.equals(vmType.cpu)) {
            return false;
        }
        if (!this.disk.equals(vmType.disk)) {
            return false;
        }
        if (!this.memory.equals(vmType.memory)) {
            return false;
        }
        return this.name.equals(vmType.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.cpu.hashCode();
        result = 31 * result + this.disk.hashCode();
        result = 31 * result + this.memory.hashCode();
        return result;
    }

    public int compareTo(CloudMetadata.VmTypeMetadata that) {
        if (this.equals(that)) {
            return 0;
        }
        if (this.getDisk() < that.getDisk()) {
            return -1;
        }
        if (this.getDisk() > that.getDisk()) {
            return 1;
        }
        if (this.getMemory() < that.getMemory()) {
            return -1;
        }
        if (this.getMemory() > that.getMemory()) {
            return 1;
        }
        if (this.getCpu() < that.getCpu()) {
            return -1;
        }
        if (this.getCpu() > that.getCpu()) {
            return 1;
        }
        return this.getDisplayName().compareTo(that.getDisplayName());
    }

    public String toString() {
        return "VmType " + this.name + " cores=" + this.cpu + " disk=" + this.disk + " mem=" + this.memory;
    }

    public String getPartition() {
        return ((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name();
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(Principals.systemFullName().getAccountNumber()).relativeId(new String[]{"vm-type", this.getName()});
    }

    public OwnerFullName getOwner() {
        return Principals.nobodyFullName();
    }

    public Supplier<VmType> allocator() {
        return new Supplier<VmType>(){

            public VmType get() {
                return VmType.this;
            }
        };
    }

    Boolean getEbsOnly() {
        return this.ebsOnly;
    }

    void setEbsOnly(Boolean ebsOnly) {
        this.ebsOnly = ebsOnly;
    }

    Integer getEbsIopsLimit() {
        return this.ebsIopsLimit;
    }

    void setEbsIopsLimit(Integer ebsIopsLimit) {
        this.ebsIopsLimit = ebsIopsLimit;
    }

    Boolean getX86_64only() {
        return this.x86_64only;
    }

    void setX86_64only(Boolean x86_64only) {
        this.x86_64only = x86_64only;
    }

    Set<EphemeralDisk> getEpehemeralDisks() {
        return this.epehemeralDisks;
    }

    public void addEphemeralDisks(EphemeralDisk ... disks) {
        EphemeralBuilder builder = this.withEphemeralDisks();
        for (EphemeralDisk d : disks) {
            builder.addDisk(d);
        }
    }

    public EphemeralBuilder withEphemeralDisks() {
        this.getEpehemeralDisks().clear();
        return new EphemeralBuilder(this);
    }

    public static VmType create(String name, Integer cpu, Integer disk, Integer memory) {
        return new VmType(name, cpu, disk, memory);
    }

    public static VmType named(String name) {
        return new VmType(name);
    }

    public Predicate<VmType> orderedPredicate() {
        return new Predicate<VmType>(){

            public boolean apply(VmType vm) {
                boolean gtcpu = vm.cpu > VmType.this.cpu;
                boolean eqcpu = vm.cpu == VmType.this.cpu;
                boolean ltcpu = vm.cpu < VmType.this.cpu;
                boolean gtdisk = vm.disk > VmType.this.disk;
                boolean eqdisk = vm.disk == VmType.this.disk;
                boolean ltdisk = vm.disk < VmType.this.disk;
                boolean gtmemory = vm.memory > VmType.this.memory;
                boolean eqmem = vm.memory == VmType.this.memory;
                boolean ltmem = vm.memory < VmType.this.memory;
                boolean singleOrder = gtcpu && gtdisk && ltmem || gtcpu && gtmemory && ltdisk || gtdisk && gtmemory && ltcpu;
                boolean doubleOrder = gtmemory && ltcpu && ltdisk || gtdisk && ltcpu && ltmem || gtcpu && ltdisk && ltmem;
                return !this.equals((Object)vm) && (singleOrder || doubleOrder);
            }
        };
    }

    public static class EphemeralBuilder {
        private Integer index = 0;
        private Map<Integer, String> deviceNames = Maps.newHashMap();
        private Set<EphemeralDisk> disks = Sets.newHashSet();
        private VmType parent;

        EphemeralBuilder(VmType parent) {
            this.parent = parent;
        }

        private String getDiskName(String deviceName) {
            if ("/dev/sda1".equals(deviceName)) {
                throw new IllegalArgumentException("Attempt to assign restricted device name: " + deviceName);
            }
            if (this.deviceNames.containsValue(deviceName)) {
                throw new IllegalArgumentException("Attempt to assign same device name to multiple devices: " + deviceName + " with " + this.deviceNames.entrySet());
            }
            Integer n = this.index;
            Integer n2 = this.index = Integer.valueOf(this.index + 1);
            int idx = n;
            this.deviceNames.put(idx, deviceName);
            return "ephemeral" + idx;
        }

        public EphemeralBuilder addDisk(EphemeralDisk disk) {
            String diskName = this.getDiskName(disk.getDeviceName());
            EphemeralDisk ephemeral = EphemeralDisk.create(this.parent, diskName, disk.getDeviceName(), disk.getSize(), disk.getFormat());
            this.disks.add(ephemeral);
            return this;
        }

        public VmType commit() {
            this.parent.getEpehemeralDisks().addAll(this.disks);
            return this.parent;
        }
    }

    public static enum SizeProperties implements Function<VmType, Integer>
    {
        Cpu{

            public Integer apply(VmType vmType) {
                return vmType.getCpu();
            }
        }
        ,
        Disk{

            public Integer apply(VmType vmType) {
                return vmType.getDisk();
            }
        }
        ,
        Memory{

            public Integer apply(VmType vmType) {
                return vmType.getMemory();
            }
        };

    }
}

