/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vmtypes;

import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.hibernate.annotations.Parent;

@Embeddable
public class EphemeralDisk
implements Comparable<EphemeralDisk> {
    @Parent
    private VmType parent;
    @Column(name="config_vm_type_ephemeral_disk_name")
    private String diskName;
    @Column(name="config_vm_type_ephemeral_device_name")
    private String deviceName;
    @Column(name="config_vm_type_ephemeral_size")
    private Integer size;
    @Enumerated(value=EnumType.STRING)
    @Column(name="config_vm_type_ephemeral_format")
    private VmTypes.Format format;

    protected EphemeralDisk() {
    }

    private EphemeralDisk(VmType parent, String diskName, String deviceName, Integer size) {
        this.parent = parent;
        this.diskName = diskName;
        this.deviceName = deviceName;
        this.size = size;
    }

    private EphemeralDisk(VmType parent, String diskName, String deviceName, Integer size, VmTypes.Format format) {
        this(parent, diskName, deviceName, size);
        this.format = format;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deviceName == null ? 0 : this.deviceName.hashCode());
        result = 31 * result + (this.diskName == null ? 0 : this.diskName.hashCode());
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EphemeralDisk other = (EphemeralDisk)obj;
        if (this.deviceName == null ? other.deviceName != null : !this.deviceName.equals(other.deviceName)) {
            return false;
        }
        if (this.diskName == null ? other.diskName != null : !this.diskName.equals(other.diskName)) {
            return false;
        }
        return !(this.size == null ? other.size != null : !this.size.equals(other.size));
    }

    @Override
    public int compareTo(EphemeralDisk o) {
        return this.equals(o) ? 0 : this.hashCode() - o.hashCode();
    }

    static EphemeralDisk create(VmType parent, String diskName, String deviceName, Integer size, VmTypes.Format format) {
        return new EphemeralDisk(parent, diskName, deviceName, size, format);
    }

    static EphemeralDisk create(String diskName, String deviceName, Integer size, VmTypes.Format format) {
        return new EphemeralDisk(null, diskName, deviceName, size, format);
    }

    VmType getParent() {
        return this.parent;
    }

    String getDiskName() {
        return this.diskName;
    }

    String getDeviceName() {
        return this.deviceName;
    }

    Integer getSize() {
        return this.size;
    }

    VmTypes.Format getFormat() {
        return this.format;
    }

    private void setParent(VmType parent) {
        this.parent = parent;
    }

    private void setDiskName(String diskName) {
        this.diskName = diskName;
    }

    private void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    private void setSize(Integer size) {
        this.size = size;
    }

    private void setFormat(VmTypes.Format format) {
        this.format = format;
    }
}

