/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm.dns;

import com.eucalyptus.address.Addresses;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.cluster.ClusterConfiguration;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.Subnets;
import com.eucalyptus.util.dns.DnsResolvers;
import com.eucalyptus.util.dns.DomainNameRecords;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.dns.InstanceDomainNames;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

@ConfigurableClass(root="dns.split_horizon", description="Options controlling Split-Horizon DNS resolution.")
public abstract class SplitHorizonResolver
implements DnsResolvers.DnsResolver {
    private static final Logger LOG = Logger.getLogger(SplitHorizonResolver.class);
    @ConfigurableField(description="Enable the split-horizon DNS resolution for internal instance public DNS name queries.  Note: dns.enable must also be 'true'")
    public static Boolean enabled = Boolean.TRUE;

    public DnsResolvers.DnsResponse lookupRecords(DnsResolvers.DnsRequest request) {
        InetAddress ip;
        Record query = request.getQuery();
        if (DnsResolvers.RequestType.PTR.apply(query) && InstanceDomainNames.isInstance(ip = DomainNameRecords.inAddrArpaToInetAddress((Name)query.getName()))) {
            String hostAddress = ip.getHostAddress();
            if (Addresses.getInstance().contains(hostAddress)) {
                VmInstances.lookupByPublicIp(hostAddress);
                Name dnsName = InstanceDomainNames.fromInetAddress(InstanceDomainNames.EXTERNAL, ip);
                return DnsResolvers.DnsResponse.forName((Name)query.getName()).answer(new Record[]{DomainNameRecords.ptrRecord((Name)dnsName, (InetAddress)ip)});
            }
            if (VmInstances.privateIpInUse(hostAddress)) {
                Name dnsName = InstanceDomainNames.fromInetAddress(InstanceDomainNames.INTERNAL, ip);
                return DnsResolvers.DnsResponse.forName((Name)query.getName()).answer(new Record[]{DomainNameRecords.ptrRecord((Name)dnsName, (InetAddress)ip)});
            }
        }
        return DnsResolvers.DnsResponse.forName((Name)query.getName()).nxdomain();
    }

    public boolean checkAccepts(DnsResolvers.DnsRequest request) {
        Record query = request.getQuery();
        if (!Bootstrap.isOperational().booleanValue() || !enabled.booleanValue()) {
            return false;
        }
        if (DnsResolvers.RequestType.A.apply(query) && InstanceDomainNames.isInstanceDomainName(query.getName())) {
            return true;
        }
        return DnsResolvers.RequestType.PTR.apply(query) && Subnets.isSystemManagedAddress((InetAddress)DomainNameRecords.inAddrArpaToInetAddress((Name)query.getName()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean equals(Object obj) {
        return this.getClass().equals(Objects.firstNonNull((Object)Classes.typeOf((Object)obj), Object.class));
    }

    public static class ExternalARecordResolver
    extends SplitHorizonResolver
    implements DnsResolvers.DnsResolver {
        @Override
        public boolean checkAccepts(DnsResolvers.DnsRequest request) {
            Record query = request.getQuery();
            InetAddress source = request.getRemoteAddress();
            return DnsResolvers.RequestType.PTR.apply(query) ? super.checkAccepts(request) : super.checkAccepts(request) && !Subnets.isSystemManagedAddress((InetAddress)source) && query.getName().subdomain(InstanceDomainNames.EXTERNAL.get());
        }

        @Override
        public DnsResolvers.DnsResponse lookupRecords(DnsResolvers.DnsRequest request) {
            Record query = request.getQuery();
            if (DnsResolvers.RequestType.A.apply(query)) {
                try {
                    Name name = query.getName();
                    InetAddress requestIp = InstanceDomainNames.toInetAddress(name.relativize(InstanceDomainNames.EXTERNAL.get()));
                    VmInstances.lookupByPublicIp(requestIp.getHostAddress());
                    Record instanceARecord = DomainNameRecords.addressRecord((Name)name, (InetAddress)requestIp);
                    return DnsResolvers.DnsResponse.forName((Name)name).answer(new Record[]{instanceARecord});
                }
                catch (Exception ex) {
                    LOG.debug((Object)ex);
                }
            }
            return super.lookupRecords(request);
        }
    }

    public static class HorizonARecordResolver
    extends SplitHorizonResolver
    implements DnsResolvers.DnsResolver {
        @Override
        public boolean checkAccepts(DnsResolvers.DnsRequest request) {
            Record query = request.getQuery();
            InetAddress source = request.getRemoteAddress();
            return DnsResolvers.RequestType.PTR.apply(query) ? super.checkAccepts(request) : super.checkAccepts(request) && Subnets.isSystemManagedAddress((InetAddress)source) && query.getName().subdomain(InstanceDomainNames.EXTERNAL.get());
        }

        @Override
        public DnsResolvers.DnsResponse lookupRecords(DnsResolvers.DnsRequest request) {
            Record query = request.getQuery();
            if (DnsResolvers.RequestType.A.apply(query)) {
                try {
                    Name name = query.getName();
                    InetAddress requestIp = InstanceDomainNames.toInetAddress(name.relativize(InstanceDomainNames.EXTERNAL.get()));
                    VmInstance vm = VmInstances.lookupByPublicIp(requestIp.getHostAddress());
                    InetAddress instanceAddress = InetAddresses.forString((String)vm.getPrivateAddress());
                    Record instanceARecord = DomainNameRecords.addressRecord((Name)name, (InetAddress)instanceAddress);
                    return DnsResolvers.DnsResponse.forName((Name)name).answer(new Record[]{instanceARecord});
                }
                catch (Exception ex) {
                    LOG.debug((Object)ex);
                }
            }
            return super.lookupRecords(request);
        }
    }

    public static class InternalARecordResolver
    extends SplitHorizonResolver
    implements DnsResolvers.DnsResolver {
        @Override
        public DnsResolvers.DnsResponse lookupRecords(DnsResolvers.DnsRequest request) {
            Record query = request.getQuery();
            if (DnsResolvers.RequestType.A.apply(query)) {
                try {
                    Name name = query.getName();
                    Name instanceDomain = InstanceDomainNames.lookupInstanceDomain(name);
                    InetAddress ip = InstanceDomainNames.toInetAddress(name.relativize(instanceDomain));
                    if (VmInstances.privateIpInUse(ip.getHostAddress())) {
                        Record aRecord = DomainNameRecords.addressRecord((Name)name, (InetAddress)ip);
                        return DnsResolvers.DnsResponse.forName((Name)name).answer(new Record[]{aRecord});
                    }
                }
                catch (Exception ex) {
                    LOG.debug((Object)ex);
                }
            }
            return super.lookupRecords(request);
        }

        @Override
        public boolean checkAccepts(DnsResolvers.DnsRequest request) {
            Record query = request.getQuery();
            return DnsResolvers.RequestType.PTR.apply(query) ? super.checkAccepts(request) : super.checkAccepts(request) && InstanceDomainNames.isInstanceSubdomain(query.getName()) && !query.getName().subdomain(InstanceDomainNames.EXTERNAL.get());
        }
    }

    @Subnets.SystemSubnetPredicate
    public static class SystemInternalSubnet
    implements Predicate<InetAddress> {
        public boolean apply(InetAddress input) {
            if (!Bootstrap.isOperational().booleanValue()) {
                return false;
            }
            if (Addresses.getInstance().contains(input.getHostAddress())) {
                return true;
            }
            try {
                VmInstances.lookupByPublicIp(input.getHostAddress());
                return true;
            }
            catch (NoSuchElementException ex1) {
                for (ServiceConfiguration clusterService : ServiceConfigurations.list(ClusterController.class)) {
                    ClusterConfiguration cluster = (ClusterConfiguration)clusterService;
                    try {
                        if (!Subnets.internalPredicate((String)cluster.getVnetSubnet(), (String)cluster.getVnetNetmask()).apply((Object)input)) continue;
                        return true;
                    }
                    catch (UnknownHostException ex) {
                        LOG.trace((Object)ex);
                    }
                }
                return false;
            }
        }
    }
}

