/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm.dns;

import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.dns.DomainNames;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbill.DNS.Name;

public enum InstanceDomainNames implements Function<Name, InetAddress>
{
    EXTERNAL{
        final Supplier<Name> externalInstanceSubdomain = Suppliers.memoizeWithExpiration((Supplier)new Supplier<Name>(){

            public Name get() {
                return DomainNames.absolute((Name)InstanceDomainNames.lookupInstanceSubdomainProperty(), (Name)DomainNames.externalSubdomain());
            }
        }, (long)30L, (TimeUnit)TimeUnit.SECONDS);

        @Override
        public Name get() {
            return (Name)this.externalInstanceSubdomain.get();
        }
    }
    ,
    INTERNAL{
        final Supplier<Name> internalInstanceSubdomain = Suppliers.memoizeWithExpiration((Supplier)new Supplier<Name>(){

            public Name get() {
                return DomainNames.absolute((Name)InstanceDomainNames.lookupInstanceSubdomainProperty(), (Name)DomainNames.internalSubdomain());
            }
        }, (long)30L, (TimeUnit)TimeUnit.SECONDS);

        @Override
        public Name get() {
            return (Name)this.internalInstanceSubdomain.get();
        }
    }
    ,
    CONFIGURABLEINTERNAL{
        final Supplier<Name> configurableSubdomain = Suppliers.memoizeWithExpiration((Supplier)new Supplier<Name>(){

            public Name get() {
                return DomainNames.absolute((Name)InstanceDomainNames.lookupInstanceSubdomainProperty());
            }
        }, (long)30L, (TimeUnit)TimeUnit.SECONDS);

        @Override
        public Name get() {
            return (Name)this.configurableSubdomain.get();
        }
    }
    ,
    DEFAULTINTERNAL{
        final Supplier<Name> defaultInternalSubdomain = Suppliers.memoizeWithExpiration((Supplier)new Supplier<Name>(){

            public Name get() {
                return DomainNames.internalSubdomain(Eucalyptus.class);
            }
        }, (long)30L, (TimeUnit)TimeUnit.SECONDS);

        @Override
        public Name get() {
            return (Name)this.defaultInternalSubdomain.get();
        }
    };

    private static final int INSTANCE_DOMAIN_REFRESH = 30;
    private static final String DNS_TO_IP_REGEX = "$1.$2.$3.$4";
    private static final String INSTANCE_DNS_REGEX = "euca-(.+{3})-(.+{3})-(.+{3})-(.+{3})";
    private static final Pattern PATTERN;
    private final Supplier<Pattern> instancePattern = new Supplier<Pattern>(){

        public Pattern get() {
            String DNS_SUFFIX = InstanceDomainNames.this.get().toString().replace(".", "\\.");
            return Pattern.compile("euca-(.+{3})-(.+{3})-(.+{3})-(.+{3})\\." + DNS_SUFFIX);
        }
    };

    private boolean matches(Name name) {
        return ((Pattern)this.instancePattern.get()).matcher(name.toString()).matches();
    }

    static Matcher matcher(Name name) {
        return PATTERN.matcher(name.toString());
    }

    static Name fromInetAddress(InstanceDomainNames instanceDomain, InetAddress ip) {
        String instancePart = "euca-" + ip.getHostAddress().replace('.', '-');
        return DomainNames.absolute((Name)Name.fromConstantString((String)instancePart), (Name)instanceDomain.get());
    }

    public static InetAddress toInetAddress(Name name) {
        return InetAddresses.forString((String)PATTERN.matcher(name.toString()).replaceAll(DNS_TO_IP_REGEX));
    }

    public InetAddress apply(Name input) {
        try {
            Matcher matcher = PATTERN.matcher(input.toString());
            String parsedIp = matcher.replaceAll(DNS_TO_IP_REGEX);
            return InetAddress.getByName(parsedIp);
        }
        catch (UnknownHostException ex) {
            return Internets.loopback();
        }
    }

    public abstract Name get();

    private static Name lookupInstanceSubdomainProperty() {
        return Name.fromConstantString((String)VmInstances.INSTANCE_SUBDOMAIN.replaceFirst("^\\.", ""));
    }

    public static boolean isInstance(InetAddress ip) {
        try {
            return VmInstances.privateIpInUse(ip.getHostAddress()) || VmInstances.lookupByPublicIp(ip.getHostAddress()) != null;
        }
        catch (NoSuchElementException ex1) {
            return false;
        }
    }

    public static Name lookupInstanceDomain(Name name) throws NoSuchElementException {
        if (PATTERN.matcher(name.toString()).matches()) {
            for (InstanceDomainNames dom : InstanceDomainNames.values()) {
                if (!name.subdomain(dom.get())) continue;
                return dom.get();
            }
        }
        throw new NoSuchElementException("Failed to lookup instance domain name matching " + name);
    }

    public static boolean isInstanceDomainName(Name name) {
        if (PATTERN.matcher(name.toString()).matches()) {
            for (InstanceDomainNames dom : InstanceDomainNames.values()) {
                if (!dom.matches(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInstanceSubdomain(Name name) {
        if (PATTERN.matcher(name.toString()).matches()) {
            for (InstanceDomainNames dom : InstanceDomainNames.values()) {
                if (!name.subdomain(dom.get())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        PATTERN = Pattern.compile("euca-(.+{3})-(.+{3})-(.+{3})-(.+{3}).*");
    }
}

