/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parent;

@Embeddable
public class VmVolumeState {
    @Transient
    private static Logger LOG = Logger.getLogger(VmVolumeState.class);
    @Parent
    private VmInstance vmInstance;
    @ElementCollection
    @CollectionTable(name="metadata_instances_volume_attachments")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private final Set<VmVolumeAttachment> attachments = Sets.newHashSet();

    VmVolumeState() {
        this.vmInstance = null;
    }

    VmVolumeState(VmInstance vmInstance) {
        this.vmInstance = vmInstance;
    }

    private VmVolumeAttachment resolveVolumeId(String volumeId) throws NoSuchElementException {
        VmVolumeAttachment v = (VmVolumeAttachment)Iterables.find(this.attachments, VmVolumeAttachment.volumeIdFilter(volumeId));
        if (v == null) {
            throw new NoSuchElementException("Failed to find volume attachment for instance " + this.getVmInstance().getInstanceId() + " and volume " + volumeId);
        }
        return v;
    }

    public VmVolumeAttachment removeVolumeAttachment(String volumeId) throws NoSuchElementException {
        VmVolumeAttachment v = (VmVolumeAttachment)Iterables.find(this.attachments, VmVolumeAttachment.volumeIdFilter(volumeId));
        if (v == null) {
            throw new NoSuchElementException("Failed to find volume attachment for instance " + this.getVmInstance().getInstanceId() + " and volume " + volumeId);
        }
        this.attachments.remove(v);
        return v;
    }

    public void updateVolumeAttachment(String volumeId, VmVolumeAttachment.AttachmentState state) throws NoSuchElementException {
        VmVolumeAttachment v = this.resolveVolumeId(volumeId);
        v.setStatus(state.name());
    }

    public VmVolumeAttachment lookupVolumeAttachment(String volumeId) throws NoSuchElementException {
        return this.resolveVolumeId(volumeId);
    }

    public <T> Iterable<T> transformVolumeAttachments(Function<? super VmVolumeAttachment, T> function) throws NoSuchElementException {
        return Iterables.transform(this.attachments, function);
    }

    public boolean eachVolumeAttachment(Predicate<VmVolumeAttachment> pred) throws NoSuchElementException {
        return Iterables.all(this.attachments, pred);
    }

    public void addVolumeAttachment(VmVolumeAttachment volume) {
        String volumeId = volume.getVolumeId();
        volume.setStatus(VmVolumeAttachment.AttachmentState.attaching.name());
        volume.setAttachTime(volume.getAttachTime() != null ? volume.getAttachTime() : new Date());
        volume.setInstanceId(this.getVmInstance().getInstanceId());
        if (!this.attachments.add(volume)) {
            Exceptions.trace((String)("Failed to add volume to attachment set: " + volume));
        }
    }

    private VmInstance getVmInstance() {
        return this.vmInstance;
    }

    public VmVolumeAttachment lookupVolumeAttachmentByDevice(String volumeDevice) {
        return (VmVolumeAttachment)Iterables.find(this.attachments, VmVolumeAttachment.volumeDeviceFilter(volumeDevice));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VmVolumeState:");
        if (Entities.isReadable(this.attachments)) {
            builder.append("attachments=").append(this.attachments);
        }
        return builder.toString();
    }

    public Set<VmVolumeAttachment> getAttachments() {
        return this.attachments;
    }

    private void setVmInstance(VmInstance vmInstance) {
        this.vmInstance = vmInstance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vmInstance == null ? 0 : this.vmInstance.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VmVolumeState other = (VmVolumeState)obj;
        return !(this.vmInstance == null ? other.vmInstance != null : !this.vmInstance.equals((Object)other.vmInstance));
    }

    public boolean isEmpty() {
        return this.attachments.isEmpty();
    }

    static enum VmVolumeAttachmentStateInfo implements Function<VmVolumeAttachment, String>
    {
        INSTANCE;


        public String apply(VmVolumeAttachment input) {
            return input.getVolumeId() + ":" + input.getAttachmentState().stateFlag();
        }
    }

    static enum VmVolumeAttachmentName implements Function<VmVolumeAttachment, String>
    {
        INSTANCE;


        public String apply(VmVolumeAttachment input) {
            return input.getVolumeId();
        }
    }
}

