/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.vm.VmInstance;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.ucsb.eucalyptus.msgs.AttachedVolume;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Lob;
import org.hibernate.annotations.Parent;
import org.hibernate.annotations.Type;

@Embeddable
public class VmVolumeAttachment
implements Comparable<VmVolumeAttachment> {
    @Parent
    private VmInstance vmInstance;
    @Column(name="metadata_vm_volume_id", unique=true)
    private String volumeId;
    @Column(name="metadata_vm_volume_device")
    private String device;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="metadata_vm_volume_remote_device", columnDefinition="TEXT default ''")
    private String remoteDevice;
    @Column(name="metadata_vm_volume_status")
    private String status;
    @Column(name="metadata_vm_volume_at_startup", columnDefinition="boolean default false")
    private Boolean attachedAtStartup;
    @Column(name="metadata_vm_volume_attach_time")
    private Date attachTime;
    @Column(name="metadata_vm_vol_delete_on_terminate")
    private Boolean deleteOnTerminate;
    @Column(name="metadata_vm_volume_is_root_device", columnDefinition="boolean default false")
    private Boolean isRootDevice;

    VmVolumeAttachment() {
    }

    VmVolumeAttachment(VmInstance vmInstance, String volumeId, String device, String remoteDevice, String status, Date attachTime, Boolean deleteOnTerminate, Boolean attachedAtStartup) {
        this(vmInstance, volumeId, device, remoteDevice, status, attachTime, deleteOnTerminate, Boolean.FALSE, attachedAtStartup);
    }

    public VmVolumeAttachment(VmInstance vmInstance, String volumeId, String device, String remoteDevice, String status, Date attachTime, Boolean deleteOnTerminate, Boolean rootDevice, Boolean attachedAtStartup) {
        this.vmInstance = vmInstance;
        this.volumeId = volumeId;
        this.device = device;
        this.remoteDevice = remoteDevice;
        this.status = status;
        this.attachTime = attachTime;
        this.deleteOnTerminate = deleteOnTerminate;
        this.isRootDevice = rootDevice;
        this.attachedAtStartup = attachedAtStartup;
    }

    public static Function<AttachedVolume, VmVolumeAttachment> fromAttachedVolume(final VmInstance vm) {
        return new Function<AttachedVolume, VmVolumeAttachment>(){

            public VmVolumeAttachment apply(AttachedVolume vol) {
                return new VmVolumeAttachment(vm, vol.getVolumeId(), vol.getDevice(), vol.getRemoteDevice(), vol.getStatus(), vol.getAttachTime(), false, Boolean.FALSE);
            }
        };
    }

    public static Function<VmVolumeAttachment, com.eucalyptus.compute.common.AttachedVolume> asAttachedVolume(final VmInstance vm) {
        return new Function<VmVolumeAttachment, com.eucalyptus.compute.common.AttachedVolume>(){

            public com.eucalyptus.compute.common.AttachedVolume apply(VmVolumeAttachment vol) {
                com.eucalyptus.compute.common.AttachedVolume attachment = null;
                if (vm == null && vol.getVmInstance() == null) {
                    throw new NoSuchElementException("Failed to transform volume attachment because it no longer exists: " + vol);
                }
                attachment = vm == null ? new com.eucalyptus.compute.common.AttachedVolume(vol.getVolumeId(), vol.getVmInstance().getInstanceId(), vol.getDevice()) : new com.eucalyptus.compute.common.AttachedVolume(vol.getVolumeId(), vm.getInstanceId(), vol.getDevice());
                attachment.setAttachTime(vol.getAttachTime());
                attachment.setStatus(vol.getStatus());
                if (!attachment.getDevice().replaceAll("unknown,requested:", "").startsWith("/dev/")) {
                    attachment.setDevice("/dev/" + attachment.getDevice().replaceAll("unknown,requested:", ""));
                }
                return attachment;
            }
        };
    }

    public VmInstance getVmInstance() {
        return this.vmInstance;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getDevice() {
        return this.device;
    }

    void setDevice(String device) {
        this.device = device;
    }

    public String getShortDeviceName() {
        return this.device.startsWith("/dev/") ? this.device.substring(5) : this.device;
    }

    public String getRemoteDevice() {
        return this.remoteDevice;
    }

    public void setRemoteDevice(String remoteDevice) {
        this.remoteDevice = remoteDevice;
    }

    public AttachmentState getAttachmentState() {
        return AttachmentState.parse(this.status);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getAttachTime() {
        return this.attachTime;
    }

    void setAttachTime(Date attachTime) {
        this.attachTime = attachTime;
    }

    public Boolean getDeleteOnTerminate() {
        return this.deleteOnTerminate;
    }

    void setDeleteOnTerminate(Boolean value) {
        this.deleteOnTerminate = value;
    }

    @Override
    public int compareTo(VmVolumeAttachment that) {
        return this.volumeId.compareTo(that.getVolumeId());
    }

    public void setInstanceId(String instanceId) {
    }

    void setVmInstance(VmInstance vmInstance) {
        this.vmInstance = vmInstance;
    }

    public Boolean getIsRootDevice() {
        return this.isRootDevice;
    }

    public void setIsRootDevice(Boolean isRootDevice) {
        this.isRootDevice = isRootDevice;
    }

    public Boolean getAttachedAtStartup() {
        return this.attachedAtStartup;
    }

    public void setAttachedAtStartup(Boolean attachedAtStartup) {
        this.attachedAtStartup = attachedAtStartup;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VmVolumeAttachment:");
        if (this.volumeId != null) {
            builder.append("volumeId=").append(this.volumeId).append(":");
        }
        if (this.device != null) {
            builder.append("device=").append(this.device).append(":");
        }
        if (this.remoteDevice != null) {
            builder.append("remoteDevice=").append(this.remoteDevice).append(":");
        }
        if (this.status != null) {
            builder.append("status=").append(this.status).append(":");
        }
        if (this.attachTime != null) {
            builder.append("attachTime=").append(this.attachTime);
        }
        return builder.toString();
    }

    public static VmVolumeAttachment exampleWithVolumeId(String volumeId) {
        VmVolumeAttachment ex = new VmVolumeAttachment();
        ex.setVolumeId(volumeId);
        return ex;
    }

    static Predicate<VmVolumeAttachment> volumeDeviceFilter(final String deviceName) {
        return new Predicate<VmVolumeAttachment>(){

            public boolean apply(VmVolumeAttachment input) {
                return input.getDevice().replaceAll("unknown,requested:", "").equals(deviceName);
            }
        };
    }

    static Predicate<VmVolumeAttachment> volumeIdFilter(final String volumeId) {
        return new Predicate<VmVolumeAttachment>(){

            public boolean apply(VmVolumeAttachment input) {
                return input.getVolumeId().equals(volumeId);
            }
        };
    }

    static Predicate<VmVolumeAttachment> deleteOnTerminateFilter(final Boolean deleteOnTerminate) {
        return new Predicate<VmVolumeAttachment>(){

            public boolean apply(VmVolumeAttachment input) {
                return Objects.equals(deleteOnTerminate, input.getDeleteOnTerminate());
            }
        };
    }

    static Function<VmVolumeAttachment, String> volumeId() {
        return VmVolumeAttachmentStringProperties.VOLUME_ID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.volumeId == null ? 0 : this.volumeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VmVolumeAttachment other = (VmVolumeAttachment)obj;
        return !(this.volumeId == null ? other.volumeId != null : !this.volumeId.equals(other.volumeId));
    }

    private static enum VmVolumeAttachmentStringProperties implements Function<VmVolumeAttachment, String>
    {
        VOLUME_ID{

            @Nullable
            public String apply(@Nullable VmVolumeAttachment volumeAttachment) {
                return volumeAttachment == null ? null : volumeAttachment.getVolumeId();
            }
        };

    }

    public static class NonTransientVolumeException
    extends NoSuchElementException {
        private static final long serialVersionUID = 1L;

        public NonTransientVolumeException(String s) {
            super(s);
        }
    }

    public static enum AttachmentState {
        attaching{

            @Override
            public boolean isVolatile() {
                return true;
            }

            @Override
            public String stateFlag() {
                return "a";
            }
        }
        ,
        attached{

            @Override
            public String stateFlag() {
                return "A";
            }
        }
        ,
        detaching{

            @Override
            public boolean isVolatile() {
                return true;
            }

            @Override
            public String stateFlag() {
                return "d";
            }
        }
        ,
        detached{

            @Override
            public String stateFlag() {
                return "D";
            }
        }
        ,
        detaching_failed{

            @Override
            public boolean isFailed() {
                return true;
            }

            @Override
            public String stateFlag() {
                return "df";
            }
        }
        ,
        attaching_failed{

            @Override
            public boolean isFailed() {
                return true;
            }

            @Override
            public String stateFlag() {
                return "af";
            }
        };


        public static AttachmentState parse(String stateName) {
            if (stateName != null && stateName.indexOf(" ") != -1) {
                stateName = stateName.replace(" ", "_");
            } else if (stateName == null) {
                return detached;
            }
            return AttachmentState.valueOf(stateName);
        }

        public boolean isVolatile() {
            return false;
        }

        public boolean isFailed() {
            return false;
        }

        public abstract String stateFlag();
    }
}

