/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.msgs.GetVolumeTokenResponseType;
import com.eucalyptus.blockstorage.msgs.GetVolumeTokenType;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.cluster.callback.StartInstanceCallback;
import com.eucalyptus.cluster.callback.StopInstanceCallback;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.DeleteResourceTag;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.ResourceTagMessage;
import com.eucalyptus.compute.common.backend.CreateTagsType;
import com.eucalyptus.compute.common.backend.DeleteTagsType;
import com.eucalyptus.compute.common.backend.StopInstancesType;
import com.eucalyptus.compute.common.backend.TerminateInstancesType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.system.tracking.MessageContexts;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.RemoteCallback;
import com.eucalyptus.vm.BundleRestartInstanceResponseType;
import com.eucalyptus.vm.BundleRestartInstanceType;
import com.eucalyptus.vm.Bundles;
import com.eucalyptus.vm.MigrationState;
import com.eucalyptus.vm.MigrationTags;
import com.eucalyptus.vm.VmBundleTask;
import com.eucalyptus.vm.VmCreateImageTask;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmMigrationTask;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.google.common.base.CaseFormat;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.ClusterAttachVolumeType;
import edu.ucsb.eucalyptus.msgs.StartInstanceType;
import edu.ucsb.eucalyptus.msgs.StopInstanceType;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.transaction.Synchronization;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parent;
import org.hibernate.annotations.Type;

@Embeddable
public class VmRuntimeState {
    private static final String VM_NC_HOST_TAG = "euca:node";
    private static final Logger LOG = Logger.getLogger(VmRuntimeState.class);
    @Parent
    private VmInstance vmInstance;
    @Embedded
    private VmBundleTask bundleTask;
    @Embedded
    private VmCreateImageTask createImageTask;
    @Column(name="metadata_vm_service_tag")
    private String serviceTag;
    @Enumerated(value=EnumType.STRING)
    @Column(name="metadata_vm_reason")
    private VmInstance.Reason reason;
    @ElementCollection
    @CollectionTable(name="metadata_instances_state_reasons")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<String> reasonDetails = Sets.newHashSet();
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="metadata_vm_password_data")
    private String passwordData;
    @Column(name="metadata_vm_pending")
    private Boolean pending;
    @Column(name="metadata_vm_zombie")
    private Boolean zombie;
    @Column(name="metadata_vm_guest_state")
    private String guestState;
    @Embedded
    private VmMigrationTask migrationTask;
    @Enumerated(value=EnumType.STRING)
    @Column(name="metadata_instance_status")
    private InstanceStatus instanceStatus;
    @Enumerated(value=EnumType.STRING)
    @Column(name="metadata_reachability_status")
    private ReachabilityStatus reachabilityStatus;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="metadata_instance_unreachable_timestamp")
    private Date unreachableTimestamp;

    VmRuntimeState(VmInstance vmInstance) {
        this.vmInstance = vmInstance;
        this.instanceStatus = InstanceStatus.Ok;
        this.reachabilityStatus = ReachabilityStatus.Passed;
    }

    VmRuntimeState() {
    }

    public String getReason() {
        if (this.reason == null) {
            this.reason = VmInstance.Reason.NORMAL;
        }
        return this.reason.name() + ": " + (Object)((Object)this.reason) + (this.reasonDetails != null ? " -- " + this.reasonDetails : "");
    }

    private void addReasonDetail(String ... extra) {
        for (String s : extra) {
            this.reasonDetails.add(s);
        }
    }

    public void setState(VmInstance.VmState newState, VmInstance.Reason reason, String ... extra) {
        VmInstance.VmState olderState = (VmInstance.VmState)this.getVmInstance().getLastState();
        VmInstance.VmState oldState = (VmInstance.VmState)this.getVmInstance().getState();
        final Callable<Boolean> action = !oldState.equals((Object)newState) ? this.handleStateTransition(newState, oldState, olderState) : null;
        if (action != null) {
            if (VmInstance.Reason.APPEND.equals((Object)reason)) {
                reason = this.reason;
            }
            this.addReasonDetail(extra);
            this.reason = reason;
            Entities.registerSynchronization(VmInstance.class, (Synchronization)new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    if (3 == status) {
                        try {
                            Threads.enqueue(Eucalyptus.class, VmInstance.class, (Integer)VmInstances.MAX_STATE_THREADS, (Callable)action);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex);
                            Logs.extreme().error((Object)ex, (Throwable)ex);
                        }
                    }
                }
            });
        }
    }

    public void reachable() {
        if (!((Boolean)Objects.firstNonNull((Object)this.getZombie(), (Object)Boolean.FALSE)).booleanValue()) {
            this.setUnreachableTimestamp(null);
            this.setInstanceStatus(InstanceStatus.Ok);
            this.setReachabilityStatus(ReachabilityStatus.Passed);
        }
    }

    public void zombie() {
        this.setZombie(true);
        this.setUnreachableTimestamp(new Date());
        this.setInstanceStatus(InstanceStatus.Impaired);
        this.setReachabilityStatus(ReachabilityStatus.Failed);
    }

    public Boolean getZombie() {
        return this.zombie;
    }

    public void setZombie(Boolean zombie) {
        this.zombie = zombie;
    }

    @Nullable
    public InstanceStatus getInstanceStatus() {
        return this.instanceStatus;
    }

    public void setInstanceStatus(InstanceStatus instanceStatus) {
        this.instanceStatus = instanceStatus;
    }

    @Nullable
    public ReachabilityStatus getReachabilityStatus() {
        return this.reachabilityStatus;
    }

    public void setReachabilityStatus(ReachabilityStatus reachabilityStatus) {
        this.reachabilityStatus = reachabilityStatus;
    }

    @Nullable
    public Date getUnreachableTimestamp() {
        return this.unreachableTimestamp;
    }

    public void setUnreachableTimestamp(Date unreachableTimestamp) {
        this.unreachableTimestamp = unreachableTimestamp;
    }

    private Callable<Boolean> handleStateTransition(VmInstance.VmState newState, VmInstance.VmState oldState, VmInstance.VmState olderState) {
        Callable<Boolean> action = null;
        LOG.info((Object)String.format("%s state change: %s -> %s (previously %s)", new Object[]{this.getVmInstance().getInstanceId(), oldState, newState, olderState}));
        if (VmInstance.VmStateSet.RUN.contains(oldState) && VmInstance.VmStateSet.NOT_RUNNING.contains(newState)) {
            this.getVmInstance().setState(newState);
            action = VmInstance.VmStateSet.EXPECTING_TEARDOWN.contains(newState) ? this.tryCleanUpRunnable() : this.cleanUpRunnable();
        } else if (VmInstance.VmState.PENDING.equals((Object)oldState) && VmInstance.VmState.RUNNING.equals((Object)newState)) {
            this.getVmInstance().setState(newState);
            if (VmInstance.VmState.STOPPED.equals((Object)olderState)) {
                this.restoreVolumeState();
            }
        } else if (VmInstance.VmState.PENDING.equals((Object)oldState) && VmInstance.VmState.TERMINATED.equals((Object)newState) && VmInstance.VmState.STOPPED.equals((Object)olderState)) {
            this.getVmInstance().setState(VmInstance.VmState.STOPPED);
            action = this.cleanUpRunnable();
        } else if (VmInstance.VmState.STOPPED.equals((Object)oldState) && VmInstance.VmState.TERMINATED.equals((Object)newState)) {
            this.getVmInstance().setState(VmInstance.VmState.TERMINATED);
            action = this.cleanUpRunnable();
        } else if (VmInstance.VmStateSet.EXPECTING_TEARDOWN.contains(oldState) && VmInstance.VmStateSet.RUN.contains(newState)) {
            this.getVmInstance().setState(oldState);
        } else if (VmInstance.VmStateSet.EXPECTING_TEARDOWN.contains(oldState) && VmInstance.VmStateSet.TORNDOWN.contains(newState)) {
            if (VmInstance.VmState.SHUTTING_DOWN.equals((Object)oldState)) {
                this.getVmInstance().setState(VmInstance.VmState.TERMINATED);
            } else {
                this.getVmInstance().setState(VmInstance.VmState.STOPPED);
            }
            action = this.cleanUpRunnable();
        } else if (VmInstance.VmState.STOPPED.equals((Object)oldState) && VmInstance.VmState.PENDING.equals((Object)newState)) {
            this.getVmInstance().setState(VmInstance.VmState.PENDING);
        } else {
            this.getVmInstance().setState(newState);
        }
        try {
            this.getVmInstance().store();
        }
        catch (Exception ex1) {
            LOG.error((Object)ex1, (Throwable)ex1);
        }
        return action;
    }

    private void restoreVolumeState() {
        VmInstance vm = this.getVmInstance();
        if (vm.isBlockStorage()) {
            final String vmId = vm.getInstanceId();
            final ServiceConfiguration scConfig = Topology.lookup(Storage.class, (Partition[])new Partition[]{vm.lookupPartition()});
            final ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{vm.lookupPartition()});
            Predicate<VmVolumeAttachment> attachVolumes = new Predicate<VmVolumeAttachment>(){

                public boolean apply(VmVolumeAttachment input) {
                    final String volumeId = input.getVolumeId();
                    final String vmDevice = input.getDevice();
                    try {
                        LOG.debug((Object)(vmId + ": attaching volume: " + input));
                        GetVolumeTokenType tokenRequest = new GetVolumeTokenType(volumeId);
                        final CheckedListenableFuture scGetTokenReplyFuture = AsyncRequests.dispatch((ServiceConfiguration)scConfig, (BaseMessage)tokenRequest);
                        Callable<Boolean> ncAttachRequest = new Callable<Boolean>(){

                            @Override
                            public Boolean call() {
                                try {
                                    LOG.debug((Object)(vmId + ": waiting for storage volume: " + volumeId));
                                    GetVolumeTokenResponseType scReply = (GetVolumeTokenResponseType)scGetTokenReplyFuture.get();
                                    String token = StorageProperties.formatVolumeAttachmentTokenForTransfer((String)scReply.getToken(), (String)volumeId);
                                    LOG.debug((Object)(vmId + ": " + volumeId + " => " + scGetTokenReplyFuture.get()));
                                    AsyncRequests.dispatch((ServiceConfiguration)ccConfig, (BaseMessage)new ClusterAttachVolumeType(volumeId, vmId, vmDevice, token));
                                }
                                catch (Exception ex) {
                                    Exceptions.maybeInterrupted((Throwable)ex);
                                    LOG.error((Object)(vmId + ": " + ex));
                                    Logs.extreme().error((Object)ex, (Throwable)ex);
                                }
                                return true;
                            }
                        };
                        Threads.enqueue(Eucalyptus.class, VmRuntimeState.class, (Callable)ncAttachRequest);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)(vmId + ": " + ex));
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                    }
                    return true;
                }
            };
            try {
                vm.getTransientVolumeState().eachVolumeAttachment(attachVolumes);
            }
            catch (Exception ex) {
                LOG.error((Object)(vm.getInstanceId() + ": " + ex));
                Logs.extreme().error((Object)(vm.getInstanceId() + ": " + ex), (Throwable)ex);
            }
        }
    }

    private Callable<Boolean> tryCleanUpRunnable() {
        return this.cleanUpRunnable(null, new Predicate<VmInstance>(){

            public boolean apply(VmInstance vmInstance) {
                VmInstances.tryCleanUp(vmInstance);
                return true;
            }
        });
    }

    private Callable<Boolean> cleanUpRunnable() {
        return this.cleanUpRunnable(null);
    }

    private Callable<Boolean> cleanUpRunnable(@Nullable String reason) {
        return this.cleanUpRunnable(reason, new Predicate<VmInstance>(){

            public boolean apply(VmInstance vmInstance) {
                VmInstances.cleanUp(vmInstance);
                return true;
            }
        });
    }

    private Callable<Boolean> cleanUpRunnable(final @Nullable String reason, final Predicate<VmInstance> cleaner) {
        Logs.extreme().info((Object)("Preparing to clean-up instance: " + this.getVmInstance().getInstanceId()), Exceptions.filterStackTrace((Throwable)new RuntimeException()));
        final String instanceId = this.getVmInstance().getInstanceId();
        return new Threads.EucaCallable<Boolean>(){

            public Boolean call() {
                cleaner.apply((Object)VmRuntimeState.this.getVmInstance());
                if (reason != null && !VmRuntimeState.this.reasonDetails.contains(reason)) {
                    VmRuntimeState.this.addReasonDetail(new String[]{reason});
                }
                return Boolean.TRUE;
            }

            public String getCorrelationId() {
                BaseMessage req = MessageContexts.lookupLast((String)instanceId, (Set)Sets.newHashSet((Object[])new Class[]{TerminateInstancesType.class, StopInstancesType.class}));
                return req == null ? null : req.getCorrelationId();
            }
        };
    }

    VmBundleTask resetBundleTask() {
        VmBundleTask oldTask = this.bundleTask;
        Bundles.putPreviousTask(oldTask);
        this.bundleTask = null;
        return oldTask;
    }

    String getServiceTag() {
        return this.serviceTag;
    }

    public void setServiceTag(String serviceTag) {
        if (!Strings.nullToEmpty((String)this.serviceTag).equals(serviceTag)) {
            this.serviceTag = serviceTag;
            this.setNodeTag(serviceTag);
        }
    }

    public void clearServiceTag() {
        if (this.serviceTag != null) {
            this.serviceTag = null;
            this.clearNodeTag();
        }
    }

    private void setNodeTag(String serviceTag2) {
        String host = URI.create(serviceTag2).getHost();
        VmInstance vm = this.getVmInstance();
        CreateTagsType createTags = new CreateTagsType();
        createTags.getTagSet().add(new ResourceTag(VM_NC_HOST_TAG, host));
        createTags.getResourcesSet().add(vm.getInstanceId());
        this.dispatchTagMessage((ResourceTagMessage)createTags);
    }

    private void clearNodeTag() {
        VmInstance vm = this.getVmInstance();
        DeleteTagsType deleteTags = new DeleteTagsType();
        deleteTags.getTagSet().add(new DeleteResourceTag(VM_NC_HOST_TAG));
        deleteTags.getResourcesSet().add(vm.getInstanceId());
        this.dispatchTagMessage((ResourceTagMessage)deleteTags);
    }

    private void dispatchTagMessage(ResourceTagMessage message) {
        try {
            message.setUserId(Accounts.lookupSystemAdmin().getUserId());
            message.markPrivileged();
            AsyncRequests.dispatch((ServiceConfiguration)Topology.lookup(Eucalyptus.class, (Partition[])new Partition[0]), (BaseMessage)message);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }

    void setReason(VmInstance.Reason reason) {
        this.reason = reason;
    }

    String getPasswordData() {
        return this.passwordData;
    }

    void setPasswordData(String passwordData) {
        this.passwordData = passwordData;
    }

    void setGuestState(String guestState) {
        this.guestState = guestState;
    }

    String getGuestState() {
        return this.guestState;
    }

    VmInstance getVmInstance() {
        return this.vmInstance;
    }

    VmBundleTask getBundleTask() {
        return this.bundleTask;
    }

    public Boolean isBundling() {
        return this.bundleTask != null && !VmBundleTask.BundleState.none.equals((Object)this.bundleTask.getState());
    }

    VmBundleTask.BundleState getBundleTaskState() {
        if (this.bundleTask != null) {
            return this.getBundleTask().getState();
        }
        return VmBundleTask.BundleState.none;
    }

    public Boolean cancelBundleTask() {
        if (this.getBundleTask() != null) {
            this.getBundleTask().setState(VmBundleTask.BundleState.canceling);
            EventRecord.here(VmRuntimeState.class, (EventType)EventType.BUNDLE_CANCELING, (String[])new String[]{this.vmInstance.getOwner().toString(), this.getBundleTask().getBundleId(), this.getVmInstance().getInstanceId(), "" + (Object)((Object)this.getBundleTask().getState())}).info();
            return true;
        }
        return false;
    }

    public Boolean restartBundleTask() {
        if (this.getBundleTask() != null) {
            this.getBundleTask().setState(VmBundleTask.BundleState.none);
            EventRecord.here(VmRuntimeState.class, (EventType)EventType.BUNDLE_RESTART, (String[])new String[]{this.vmInstance.getOwner().toString(), this.getBundleTask().getBundleId(), this.getVmInstance().getInstanceId(), "" + (Object)((Object)this.getBundleTask().getState())}).info();
            return true;
        }
        return false;
    }

    public Boolean submittedBundleTask() {
        if (this.getBundleTask() != null) {
            if (VmBundleTask.BundleState.cancelled.equals((Object)this.getBundleTaskState())) {
                EventRecord.here(VmRuntimeState.class, (EventType)EventType.BUNDLE_CANCELLED, (String[])new String[]{this.vmInstance.getOwner().toString(), this.getBundleTask().getBundleId(), this.getVmInstance().getInstanceId(), "" + (Object)((Object)this.getBundleTask().getState())}).info();
                this.resetBundleTask();
                return true;
            }
            if (this.getBundleTask().getState().ordinal() >= VmBundleTask.BundleState.storing.ordinal()) {
                this.getBundleTask().setState(VmBundleTask.BundleState.storing);
                EventRecord.here(VmRuntimeState.class, (EventType)EventType.BUNDLE_STARTING, (String[])new String[]{this.vmInstance.getOwner().toString(), this.getBundleTask().getBundleId(), this.getVmInstance().getInstanceId(), "" + (Object)((Object)this.getBundleTask().getState())}).info();
                return true;
            }
        }
        return false;
    }

    public Boolean startBundleTask(VmBundleTask task) {
        if (!this.isBundling().booleanValue()) {
            Bundles.putPreviousTask(this.bundleTask);
            this.bundleTask = task;
            return true;
        }
        if (this.getBundleTask() != null && (VmBundleTask.BundleState.failed.equals((Object)task.getState()) || VmBundleTask.BundleState.canceling.equals((Object)task.getState()) || VmBundleTask.BundleState.cancelled.equals((Object)task.getState()))) {
            this.resetBundleTask();
            this.bundleTask = task;
            return true;
        }
        return false;
    }

    void setBundleTask(VmBundleTask bundleTask) {
        Bundles.putPreviousTask(this.bundleTask);
        this.bundleTask = bundleTask;
    }

    VmMigrationTask getMigrationTask() {
        return this.migrationTask == null ? (this.migrationTask = VmMigrationTask.create(this.getVmInstance())) : this.migrationTask;
    }

    void setMigrationTask(VmMigrationTask migrationTask) {
        this.migrationTask = migrationTask;
    }

    public void startMigration() {
        this.getMigrationTask().updateMigrationTask(MigrationState.pending.name(), null, null);
        MigrationTags.update(this.getVmInstance());
    }

    public void abortMigration() {
        this.getMigrationTask().updateMigrationTask(MigrationState.none.name(), null, null);
        MigrationTags.update(this.getVmInstance());
    }

    public void setMigrationState(String stateName, String sourceHost, String destHost) {
        if (this.getMigrationTask().updateMigrationTask(stateName, sourceHost, destHost)) {
            MigrationTags.update(this.getVmInstance());
        }
    }

    private void setVmInstance(VmInstance vmInstance) {
        this.vmInstance = vmInstance;
    }

    public Boolean isCreatingImage() {
        return this.createImageTask != null && !VmCreateImageTask.CreateImageState.none.equals((Object)this.createImageTask.getState()) && !VmCreateImageTask.CreateImageState.complete.equals((Object)this.createImageTask.getState()) && !VmCreateImageTask.CreateImageState.failed.equals((Object)this.createImageTask.getState());
    }

    public void setCreateImageTaskState(VmCreateImageTask.CreateImageState state) {
        if (this.createImageTask == null) {
            throw Exceptions.toUndeclared((Throwable)new Exception("No VmCreateImage task is found for the instance"));
        }
        this.createImageTask.setState(state);
    }

    public VmCreateImageTask.CreateImageState getCreateImageTaskState() {
        if (this.createImageTask != null) {
            return this.createImageTask.getState();
        }
        throw Exceptions.toUndeclared((Throwable)new Exception("No VmCreateImageTask is found for the instance"));
    }

    public VmCreateImageTask getVmCreateImageTask() {
        return this.createImageTask;
    }

    public VmCreateImageTask resetCreateImageTask(VmCreateImageTask.CreateImageState state, String imageId, String snapshotId, Boolean noReboot) {
        VmCreateImageTask oldTask = this.createImageTask;
        this.createImageTask = new VmCreateImageTask(this.vmInstance, state.toString(), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), null, null, null, imageId, noReboot);
        return oldTask;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VmRuntimeState:");
        if (this.bundleTask != null) {
            builder.append("bundleTask=").append(this.bundleTask).append(":");
        }
        if (this.createImageTask != null) {
            builder.append("createImageTask=").append(this.createImageTask).append(":");
        }
        if (this.serviceTag != null) {
            builder.append("serviceTag=").append(this.serviceTag).append(":");
        }
        if (this.reason != null) {
            builder.append("reason=").append((Object)this.reason).append(":");
        }
        if (Entities.isReadable(this.reasonDetails)) {
            builder.append("reasonDetails=").append(this.reasonDetails).append(":");
        }
        if (this.passwordData != null) {
            builder.append("passwordData=").append(this.passwordData).append(":");
        }
        if (this.pending != null) {
            builder.append("pending=").append(this.pending);
        }
        if (this.zombie != null) {
            builder.append("zombie=").append(this.zombie);
        }
        if (this.instanceStatus != null) {
            builder.append("instanceStatus=").append((Object)this.instanceStatus);
        }
        if (this.reachabilityStatus != null) {
            builder.append("reachabilityStatus=").append((Object)this.reachabilityStatus);
        }
        return builder.toString();
    }

    @Nullable
    VmInstance.Reason reason() {
        return this.reason;
    }

    private VmCreateImageTask getCreateImageTask() {
        return this.createImageTask;
    }

    private void setCreateImageTask(VmCreateImageTask createImageTask) {
        this.createImageTask = createImageTask;
    }

    private Boolean getPending() {
        return this.pending;
    }

    private void setPending(Boolean pending) {
        this.pending = pending;
    }

    private Set<String> getReasonDetails() {
        return this.reasonDetails;
    }

    private void setReasonDetails(Set<String> reasonDetails) {
        this.reasonDetails = reasonDetails;
    }

    public void updateBundleTaskState(String state) {
        VmBundleTask.BundleState next = (VmBundleTask.BundleState)((Object)VmBundleTask.BundleState.mapper.apply((Object)state));
        this.updateBundleTaskState(next, 0.0);
    }

    public void bundleRestartInstance(VmBundleTask bundleTask) {
        VmBundleTask.BundleState state = bundleTask.getState();
        if (VmBundleTask.BundleState.complete.equals((Object)state) || VmBundleTask.BundleState.failed.equals((Object)state) || VmBundleTask.BundleState.cancelled.equals((Object)state)) {
            BundleRestartInstanceType request = new BundleRestartInstanceType();
            BundleRestartInstanceResponseType reply = (BundleRestartInstanceResponseType)request.getReply();
            reply.set_return(true);
            try {
                LOG.info((Object)EventRecord.here(Bundles.BundleCallback.class, (EventType)EventType.BUNDLE_RESTART, (String[])new String[]{this.vmInstance.getOwner().getUserName(), bundleTask.getBundleId(), this.vmInstance.getInstanceId()}));
                ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{this.vmInstance.lookupPartition()});
                Cluster cluster = Clusters.lookup(ccConfig);
                request.setInstanceId(this.vmInstance.getInstanceId());
                reply.setTask(Bundles.transform(bundleTask));
                AsyncRequests.newRequest((RemoteCallback)Bundles.bundleRestartInstanceCallback(request)).dispatch((ServiceConfiguration)cluster.getConfiguration());
            }
            catch (Exception e) {
                Logs.extreme().trace((Object)("Failed to find bundle task: " + bundleTask.getBundleId()));
            }
        }
    }

    public void stopVmInstance(StopInstanceCallback cb) {
        StopInstanceType request = new StopInstanceType();
        try {
            ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{this.vmInstance.lookupPartition()});
            Cluster cluster = Clusters.lookup(ccConfig);
            request.setInstanceId(this.vmInstance.getInstanceId());
            cb.setRequest(request);
            AsyncRequests.newRequest((RemoteCallback)cb).dispatch((ServiceConfiguration)cluster.getConfiguration());
        }
        catch (Exception e) {
            Exceptions.toUndeclared((Throwable)e);
        }
    }

    public void startVmInstance(StartInstanceCallback cb) {
        StartInstanceType request = new StartInstanceType();
        try {
            ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{this.vmInstance.lookupPartition()});
            Cluster cluster = Clusters.lookup(ccConfig);
            request.setInstanceId(this.vmInstance.getInstanceId());
            cb.setRequest(request);
            AsyncRequests.newRequest((RemoteCallback)cb).dispatch((ServiceConfiguration)cluster.getConfiguration());
        }
        catch (Exception e) {
            Exceptions.toUndeclared((Throwable)e);
        }
    }

    public void updateBundleTaskState(VmBundleTask.BundleState state, Double progress) {
        if (this.getBundleTask() != null) {
            VmBundleTask.BundleState current = this.getBundleTask().getState();
            VmBundleTask currentTask = this.getBundleTask();
            currentTask.setProgress((int)Math.round(progress * 100.0));
            if (VmBundleTask.BundleState.complete.equals((Object)state) && !VmBundleTask.BundleState.complete.equals((Object)current) && !VmBundleTask.BundleState.none.equals((Object)current)) {
                currentTask.setState(state);
                currentTask.setProgress(100);
                this.bundleRestartInstance(currentTask);
            } else if (VmBundleTask.BundleState.failed.equals((Object)state) && !VmBundleTask.BundleState.failed.equals((Object)current) && !VmBundleTask.BundleState.none.equals((Object)current)) {
                try {
                    Bundles.deleteBucketContent(Accounts.lookupAccountById((String)this.getVmInstance().getOwnerAccountNumber()).lookupAdmin(), currentTask.getBucket(), currentTask.getPrefix(), true);
                }
                catch (Exception ex) {
                    LOG.error((Object)"After bundle failure, failed to delete the bucket", (Throwable)ex);
                }
                currentTask.setState(state);
                this.bundleRestartInstance(currentTask);
            } else if (VmBundleTask.BundleState.cancelled.equals((Object)state) && !VmBundleTask.BundleState.cancelled.equals((Object)current) && !VmBundleTask.BundleState.none.equals((Object)current)) {
                try {
                    Bundles.deleteBucketContent(Accounts.lookupAccountById((String)this.getVmInstance().getOwnerAccountNumber()).lookupAdmin(), this.getBundleTask().getBucket(), this.getBundleTask().getPrefix(), true);
                }
                catch (Exception ex) {
                    LOG.error((Object)"After bundle cancellation, failed to delete the bucket", (Throwable)ex);
                }
                currentTask.setState(state);
                this.bundleRestartInstance(currentTask);
            } else if (!VmBundleTask.BundleState.canceling.equals((Object)state) && !VmBundleTask.BundleState.canceling.equals((Object)current)) {
                if (VmBundleTask.BundleState.pending.equals((Object)current) && !VmBundleTask.BundleState.none.equals((Object)state)) {
                    currentTask.setState(state);
                    currentTask.setUpdateTime(new Date());
                    EventRecord.here(VmRuntimeState.class, (EventType)EventType.BUNDLE_TRANSITION, (String[])new String[]{this.vmInstance.getOwner().toString(), "" + this.getBundleTask()}).info();
                } else if (VmBundleTask.BundleState.storing.equals((Object)state)) {
                    currentTask.setState(state);
                    currentTask.setUpdateTime(new Date());
                    EventRecord.here(VmRuntimeState.class, (EventType)EventType.BUNDLE_TRANSITION, (String[])new String[]{this.vmInstance.getOwner().toString(), "" + this.getBundleTask()}).info();
                }
            }
        } else {
            this.setBundleTask(new VmBundleTask(this.vmInstance, state.name(), new Date(), new Date(), (Integer)0, "unknown", "unknown", "unknown", "unknown"));
            Logs.extreme().trace((Object)("Unhandle bundle task state update: " + (Object)((Object)state)));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vmInstance == null ? 0 : this.vmInstance.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VmRuntimeState other = (VmRuntimeState)obj;
        return !(this.vmInstance == null ? other.vmInstance != null : !this.vmInstance.equals((Object)other.vmInstance));
    }

    public static enum ReachabilityStatus {
        Passed,
        Failed,
        Insufficient_Data;


        public String toString() {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public static Function<String, ReachabilityStatus> fromString() {
            return new Function<String, ReachabilityStatus>(){

                @Nullable
                public ReachabilityStatus apply(String value) {
                    return (ReachabilityStatus)((Object)Enums.getIfPresent(ReachabilityStatus.class, (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, value)).orNull());
                }
            };
        }
    }

    public static enum InstanceStatus implements Predicate<VmInstance>
    {
        Ok,
        Impaired,
        InsufficientData,
        NotApplicable;


        public String toString() {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public static Function<String, InstanceStatus> fromString() {
            return new Function<String, InstanceStatus>(){

                @Nullable
                public InstanceStatus apply(String value) {
                    return (InstanceStatus)((Object)Enums.getIfPresent(InstanceStatus.class, (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, value)).orNull());
                }
            };
        }

        public boolean apply(@Nullable VmInstance instance) {
            return instance != null && instance.getRuntimeState().getInstanceStatus() == this;
        }
    }
}

