/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.vm.VmInstance;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.hibernate.annotations.Parent;

@Embeddable
public class VmPlacement {
    @Parent
    private VmInstance vmInstance;
    @Column(name="metadata_vm_placement")
    private String placement;
    @Column(name="metadata_vm_cluster_name")
    private String clusterName;
    @Column(name="metadata_vm_partition_name")
    private String partitionName;

    VmPlacement(String clusterName, String partitionName) {
        this.clusterName = clusterName;
        this.partitionName = partitionName;
    }

    VmPlacement() {
    }

    VmInstance getVmInstance() {
        return this.vmInstance;
    }

    String getClusterName() {
        return this.clusterName;
    }

    String getPartitionName() {
        return this.partitionName;
    }

    public Partition lookupPartition() {
        return Partitions.lookupByName((String)this.partitionName);
    }

    private void setVmInstance(VmInstance vmInstance) {
        this.vmInstance = vmInstance;
    }

    private void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    private void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    private String getPlacement() {
        return this.placement;
    }

    private void setPlacement(String placement) {
        this.placement = placement;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VmPlacement:");
        if (this.clusterName != null) {
            builder.append("clusterName=").append(this.clusterName).append(":");
        }
        if (this.partitionName != null) {
            builder.append("partitionName=").append(this.partitionName);
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vmInstance == null ? 0 : this.vmInstance.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VmPlacement other = (VmPlacement)obj;
        return !(this.vmInstance == null ? other.vmInstance != null : !this.vmInstance.equals((Object)other.vmInstance));
    }
}

