/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Transient;
import org.hibernate.annotations.Parent;
import org.xbill.DNS.Name;

@Embeddable
public class VmNetworkConfig {
    @Parent
    private VmInstance parent;
    @OneToMany(mappedBy="instance")
    @OrderColumn(name="metadata_att_device_index", nullable=false, insertable=false, updatable=false)
    private List<NetworkInterface> networkInterfaces = Lists.newArrayList();
    @Column(name="metadata_vm_private_addressing")
    private Boolean usePrivateAddressing;
    @Column(name="metadata_vm_mac_address")
    private String macAddress;
    @Column(name="metadata_vm_private_address")
    private String privateAddress;
    @Column(name="metadata_vm_public_address")
    private String publicAddress;
    @Column(name="metadata_vm_private_dns")
    private String privateDnsName;
    @Column(name="metadata_vm_public_dns")
    private String publicDnsName;
    @Transient
    public static String DEFAULT_IP = "0.0.0.0";

    VmNetworkConfig(VmInstance parent) {
        this.usePrivateAddressing = false;
        this.parent = parent;
        this.privateAddress = DEFAULT_IP;
        this.publicAddress = DEFAULT_IP;
        this.privateDnsName = "";
        this.publicDnsName = "";
    }

    VmNetworkConfig(String ipAddress, String ignoredPublicIp) {
        this.privateAddress = ipAddress;
        this.publicAddress = ignoredPublicIp;
    }

    VmNetworkConfig() {
    }

    VmNetworkConfig(VmInstance vmInstance, Boolean usePrivateAddressing) {
        this(vmInstance);
        this.usePrivateAddressing = usePrivateAddressing;
    }

    public static String generateDnsName(String ip, Name domain) {
        return DEFAULT_IP.equals(ip) ? "" : VmInstances.dnsName(ip, domain);
    }

    private VmInstance getParent() {
        return this.parent;
    }

    void setParent(VmInstance parent) {
        this.parent = parent;
    }

    List<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    Boolean getUsePrivateAddressing() {
        return this.usePrivateAddressing;
    }

    void setUsePrivateAddressing(Boolean usePrivateAddressing) {
        this.usePrivateAddressing = usePrivateAddressing;
    }

    String getMacAddress() {
        return this.macAddress;
    }

    void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    String getPrivateAddress() {
        return this.privateAddress;
    }

    void setPrivateAddress(String privateAddress) {
        this.privateAddress = privateAddress;
    }

    String getPublicAddress() {
        return this.publicAddress;
    }

    void setPublicAddress(String publicAddress) {
        this.publicAddress = publicAddress;
    }

    String getPrivateDnsName() {
        return this.privateDnsName;
    }

    void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    String getPublicDnsName() {
        return this.publicDnsName;
    }

    void setPublicDnsName(String publicDnsName) {
        this.publicDnsName = publicDnsName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VmNetworkConfig:");
        if (this.usePrivateAddressing != null) {
            builder.append("usePrivateAddressing=").append(this.usePrivateAddressing).append(":");
        }
        if (this.macAddress != null) {
            builder.append("macAddress=").append(this.macAddress).append(":");
        }
        if (this.privateAddress != null) {
            builder.append("privateAddress=").append(this.privateAddress).append(":");
        }
        if (this.publicAddress != null) {
            builder.append("publicAddress=").append(this.publicAddress).append(":");
        }
        if (this.privateDnsName != null) {
            builder.append("privateDnsName=").append(this.privateDnsName).append(":");
        }
        if (this.publicDnsName != null) {
            builder.append("publicDnsName=").append(this.publicDnsName);
        }
        return builder.toString();
    }

    static String ipOrDefault(String ip) {
        return (String)Objects.firstNonNull((Object)Strings.emptyToNull((String)ip), (Object)DEFAULT_IP);
    }

    public static VmNetworkConfig exampleWithPrivateIp(String ip) {
        return VmNetworkConfig.exampleWithIps(ip, null);
    }

    public static VmNetworkConfig exampleWithPublicIp(String ip) {
        return VmNetworkConfig.exampleWithIps(null, ip);
    }

    public static VmNetworkConfig exampleWithIps(String privateIp, String publicIp) {
        return new VmNetworkConfig(privateIp, publicIp);
    }
}

