/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.vm.MigrationState;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Parent;

@Embeddable
public class VmMigrationTask {
    @Transient
    private static Logger LOG = Logger.getLogger(VmMigrationTask.class);
    @Parent
    private VmInstance vmInstance;
    @Enumerated(value=EnumType.STRING)
    @Column(name="metadata_vm_migration_state")
    private MigrationState state;
    @Column(name="metadata_vm_migration_source_host")
    private String sourceHost;
    @Column(name="metadata_vm_migration_dest_host")
    private String destinationHost;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="metadata_vm_migration_state_timer")
    private Date refreshTimer;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.state != null) {
            builder.append((Object)this.state);
        }
        if (this.sourceHost != null && this.destinationHost != null) {
            builder.append(" ").append(this.sourceHost).append("->").append(this.destinationHost);
        }
        return builder.toString();
    }

    private VmMigrationTask() {
    }

    private VmMigrationTask(VmInstance vmInstance, MigrationState state, String sourceHost, String destinationHost) {
        this.vmInstance = vmInstance;
        this.state = state;
        this.sourceHost = Strings.nullToEmpty((String)sourceHost);
        this.destinationHost = Strings.nullToEmpty((String)destinationHost);
        this.refreshTimer = new Date();
    }

    private VmMigrationTask(VmInstance vmInstance, String state, String sourceHost, String destinationHost) {
        this(vmInstance, MigrationState.defaultValueOf(state), sourceHost, destinationHost);
    }

    public static VmMigrationTask create(VmInstance vmInstance) {
        return new VmMigrationTask(vmInstance, MigrationState.none, null, null);
    }

    public static VmMigrationTask create(VmInstance vmInstance, String state, String sourceHost, String destinationHost) {
        return new VmMigrationTask(vmInstance, state, sourceHost, destinationHost);
    }

    boolean updateMigrationTask(String state, String sourceHost, String destinationHost) {
        boolean timerExpired;
        MigrationState migrationState = MigrationState.defaultValueOf(state);
        boolean bl = timerExpired = System.currentTimeMillis() - this.getRefreshTimer().getTime() > TimeUnit.SECONDS.toMillis(VmInstances.MIGRATION_REFRESH_TIME);
        if (!timerExpired && MigrationState.pending.equals((Object)this.getState()) && migrationState.ordinal() < MigrationState.preparing.ordinal()) {
            return false;
        }
        boolean updated = !this.getState().equals((Object)migrationState) || !this.getSourceHost().equals(sourceHost) || !this.getDestinationHost().equals(destinationHost);
        this.setState(migrationState);
        this.setSourceHost(sourceHost);
        this.setDestinationHost(destinationHost);
        if (MigrationState.none.equals((Object)this.getState())) {
            this.setRefreshTimer(null);
            return updated || timerExpired;
        }
        if (timerExpired) {
            this.updateRefreshTimer();
            return true;
        }
        return updated;
    }

    protected Date getRefreshTimer() {
        return this.refreshTimer == null ? (this.refreshTimer = new Date()) : this.refreshTimer;
    }

    protected void setRefreshTimer(Date refreshTimer) {
        this.refreshTimer = refreshTimer;
    }

    private void updateRefreshTimer() {
        this.setRefreshTimer(new Date());
    }

    protected VmInstance getVmInstance() {
        return this.vmInstance;
    }

    protected void setVmInstance(VmInstance vmInstance) {
        this.vmInstance = vmInstance;
    }

    public MigrationState getState() {
        return this.state;
    }

    protected void setState(MigrationState state) {
        if (!this.state.equals((Object)state)) {
            this.updateRefreshTimer();
            this.state = state;
        }
    }

    public String getSourceHost() {
        return this.sourceHost;
    }

    protected void setSourceHost(String sourceHost) {
        this.sourceHost = Strings.nullToEmpty((String)sourceHost);
    }

    public String getDestinationHost() {
        return this.destinationHost;
    }

    protected void setDestinationHost(String destinationHost) {
        this.destinationHost = Strings.nullToEmpty((String)destinationHost);
    }
}

