/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.address.Address;
import com.eucalyptus.address.Addresses;
import com.eucalyptus.address.AddressingDispatcher;
import com.eucalyptus.blockstorage.State;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.Volume;
import com.eucalyptus.blockstorage.Volumes;
import com.eucalyptus.blockstorage.msgs.DeleteStorageVolumeResponseType;
import com.eucalyptus.blockstorage.msgs.DeleteStorageVolumeType;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.cloud.VmInstanceLifecycleHelpers;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.cluster.ResourceState;
import com.eucalyptus.cluster.callback.TerminateCallback;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.BlockDeviceMappingItemType;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.InstanceStatusEventType;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.backend.StopInstancesType;
import com.eucalyptus.compute.common.backend.TerminateInstancesType;
import com.eucalyptus.compute.common.network.Networking;
import com.eucalyptus.compute.common.network.NetworkingFeature;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.compute.vpc.NetworkInterfaceAttachment;
import com.eucalyptus.compute.vpc.NetworkInterfaces;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.images.BlockStorageImageInfo;
import com.eucalyptus.images.BootableImageInfo;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.reporting.event.ResourceAvailabilityEvent;
import com.eucalyptus.system.tracking.MessageContexts;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.HasNaturalId;
import com.eucalyptus.util.Intervals;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.Strings;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.Callbacks;
import com.eucalyptus.util.async.DelegatingRemoteCallback;
import com.eucalyptus.util.async.MessageCallback;
import com.eucalyptus.util.async.RemoteCallback;
import com.eucalyptus.vm.VmBundleTask;
import com.eucalyptus.vm.VmEphemeralAttachment;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstanceTag;
import com.eucalyptus.vm.VmRuntimeState;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Restrictions;
import org.xbill.DNS.Name;

@ConfigurableClass(root="cloud.vmstate", description="Parameters controlling the lifecycle of virtual machines.")
public class VmInstances {
    @ConfigurableField(description="Max length (in KB) that the user data file can be for an instance (after base 64 decoding) ", initial="16", changeListener=UserDataMaxSizeChangeListener.class)
    public static String USER_DATA_MAX_SIZE_KB = "16";
    public static final Integer ABSOLUTE_USER_DATA_MAX_SIZE_KB = 64;
    @ConfigurableField(description="Number of times to retry transactions in the face of potential concurrent update conflicts.", initial="10")
    public static final int TX_RETRIES = 10;
    @ConfigurableField(description="Amount of time (default unit minutes) before a previously running instance which is not reported will be marked as terminated.", initial="180d")
    public static String INSTANCE_TIMEOUT = "180d";
    @ConfigurableField(description="Amount of time (in minutes) between updates for a running instance.", initial="15")
    public static Integer INSTANCE_TOUCH_INTERVAL = 15;
    @ConfigurableField(description="Amount of time (in minutes) before a VM which is not reported by a cluster will be marked as terminated.", initial="10")
    public static Integer SHUT_DOWN_TIME = 10;
    @ConfigurableField(description="Amount of time (in minutes) before a stopping VM which is not reported by a cluster will be marked as terminated.", initial="10")
    public static Integer STOPPING_TIME = 10;
    @ConfigurableField(description="Amount of time (in minutes) that a terminated VM will continue to be reported.", initial="60")
    public static Integer TERMINATED_TIME = 60;
    @ConfigurableField(description="Amount of time (in minutes) to retain unreported terminated instance data.", initial="60")
    public static Integer BURIED_TIME = 60;
    @ConfigurableField(description="Maximum amount of time (in seconds) that the network topology service takes to propagate state changes.", initial="3600000")
    public static Long NETWORK_METADATA_REFRESH_TIME = 15L;
    @ConfigurableField(description="Maximum amount of time (in seconds) that migration state will take to propagate state changes (e.g., to tags).", initial="60")
    public static Long MIGRATION_REFRESH_TIME = 60L;
    @ConfigurableField(description="Prefix to use for instance MAC addresses.", initial="d0:0d")
    public static String MAC_PREFIX = "d0:0d";
    @ConfigurableField(description="Subdomain to use for instance DNS.", initial=".eucalyptus", changeListener=SubdomainListener.class)
    public static String INSTANCE_SUBDOMAIN = ".eucalyptus";
    @ConfigurableField(description="Period (in seconds) between state updates for actively changing state.", initial="3")
    public static Long VOLATILE_STATE_INTERVAL_SEC = Long.MAX_VALUE;
    @ConfigurableField(description="Timeout (in seconds) before a requested instance terminate will be repeated.", initial="60")
    public static Long VOLATILE_STATE_TIMEOUT_SEC = 60L;
    @ConfigurableField(description="Maximum number of threads the system will use to service blocking state changes.", initial="16")
    public static Integer MAX_STATE_THREADS = 16;
    @ConfigurableField(description="Amount of time (in minutes) before a EBS volume backing the instance is created", initial="30")
    public static Integer EBS_VOLUME_CREATION_TIMEOUT = 30;
    @ConfigurableField(description="Name for root block device mapping", initial="emi")
    public static volatile String EBS_ROOT_DEVICE_NAME = "emi";
    @ConfigurableField(description="Amount of time (in seconds) to let instance state settle after a transition to either stopping or shutting-down.", initial="40")
    public static Integer VM_STATE_SETTLE_TIME = 40;
    @ConfigurableField(description="Amount of time (in seconds) since completion of the creating run instance operation that the new instance is treated as unreported if not... reported.", initial="300")
    public static Integer VM_INITIAL_REPORT_TIMEOUT = 300;
    @ConfigurableField(description="Amount of time (in minutes) before a VM which is not reported by a cluster will fail a reachability test.", initial="5")
    public static Integer INSTANCE_REACHABILITY_TIMEOUT = 5;
    @ConfigurableField(description="Comma separated list of handlers to use for unknown instances ('restore', 'restore-failed', 'terminate', 'terminate-done')", initial="restore-failed", changeListener=UnknownInstanceHandlerChangeListener.class)
    public static String UNKNOWN_INSTANCE_HANDLERS = "terminate-done, restore-failed, restore";
    @ConfigurableField(description="Instance metadata user data cache configuration.", initial="maximumSize=50, expireAfterWrite=5s, softValues", changeListener=CacheSpecListener.class)
    public static volatile String VM_METADATA_USER_DATA_CACHE = "maximumSize=50, expireAfterWrite=5s, softValues";
    @ConfigurableField(description="Instance metadata cache configuration.", initial="maximumSize=250, expireAfterWrite=5s", changeListener=CacheSpecListener.class)
    public static volatile String VM_METADATA_INSTANCE_CACHE = "maximumSize=250, expireAfterWrite=5s";
    @ConfigurableField(description="Instance metadata instance resolution cache configuration.", initial="maximumSize=250, expireAfterWrite=1s", changeListener=CacheSpecListener.class)
    public static volatile String VM_METADATA_REQUEST_CACHE = "maximumSize=250, expireAfterWrite=1s";
    private static final Logger LOG = Logger.getLogger(VmInstances.class);
    public static Function<VmEphemeralAttachment, BlockDeviceMappingItemType> EphemeralAttachmentToDevice = new Function<VmEphemeralAttachment, BlockDeviceMappingItemType>(){

        @Nullable
        public BlockDeviceMappingItemType apply(@Nullable VmEphemeralAttachment input) {
            BlockDeviceMappingItemType item = new BlockDeviceMappingItemType();
            item.setDeviceName(input.getDevice());
            item.setVirtualName(input.getEphemeralId());
            return item;
        }
    };

    public static String getId(Long rsvId, int launchIndex) {
        String vmId;
        while (VmInstances.contains(vmId = ResourceIdentifiers.generateString("i"))) {
        }
        return vmId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VmInstance lookupByPrivateIp(String ip) throws NoSuchElementException {
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            VmInstance vmExample = VmInstance.exampleWithPrivateIp(ip);
            VmInstance vm = (VmInstance)((Object)Entities.createCriteriaUnique(VmInstance.class).add((Criterion)Example.create((Object)((Object)vmExample))).add(Restrictions.in((String)"state", (Object[])new VmInstance.VmState[]{VmInstance.VmState.RUNNING, VmInstance.VmState.PENDING})).uniqueResult());
            if (vm == null) {
                throw new NoSuchElementException("VmInstance with private ip: " + ip);
            }
            db.commit();
            VmInstance vmInstance = vm;
            return vmInstance;
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new NoSuchElementException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean privateIpInUse(String ip) {
        try (TransactionResource tx = Entities.transactionFor(VmInstance.class);){
            VmInstance vmExample = VmInstance.exampleWithPrivateIp(ip);
            boolean bl = Entities.count((Object)((Object)vmExample), (Criterion)Restrictions.in((String)"state", (Object[])new VmInstance.VmState[]{VmInstance.VmState.RUNNING, VmInstance.VmState.PENDING}), Collections.emptyMap()) > 0L;
            return bl;
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VmVolumeAttachment lookupVolumeAttachment(String volumeId) {
        VmVolumeAttachment ret = null;
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            List vms = Entities.query((Object)((Object)VmInstance.create()));
            for (VmInstance vm : vms) {
                try {
                    ret = vm.lookupVolumeAttachment(volumeId);
                    if (ret.getVmInstance() != null) continue;
                    ret.setVmInstance(vm);
                }
                catch (NoSuchElementException ex) {}
            }
            if (ret == null) {
                throw new NoSuchElementException("VmVolumeAttachment: no volume attachment for " + volumeId);
            }
            db.commit();
            VmVolumeAttachment vmVolumeAttachment = ret;
            return vmVolumeAttachment;
        }
        catch (Exception ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }

    public static VmVolumeAttachment lookupVolumeAttachment(String volumeId, List<VmInstance> vms) {
        VmVolumeAttachment ret = null;
        try {
            for (VmInstance vm : vms) {
                try {
                    ret = vm.lookupVolumeAttachment(volumeId);
                    if (ret.getVmInstance() != null) continue;
                    ret.setVmInstance(vm);
                }
                catch (NoSuchElementException ex) {}
            }
            if (ret == null) {
                throw new NoSuchElementException("VmVolumeAttachment: no volume attachment for " + volumeId);
            }
            return ret;
        }
        catch (Exception ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<VmEphemeralAttachment> lookupEphemeralDevices(String instanceId) {
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(instanceId))));
            ArrayList ephemeralDisks = Lists.newArrayList(vm.getBootRecord().getEphemeralStorage());
            db.commit();
            ArrayList arrayList = ephemeralDisks;
            return arrayList;
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> lookupPersistentDeviceNames(String instanceId) {
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            ArrayList<String> deviceNames = new ArrayList<String>();
            VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(instanceId))));
            for (VmVolumeAttachment vol : vm.getBootRecord().getPersistentVolumes()) {
                deviceNames.add(vol.getDevice());
            }
            db.commit();
            ArrayList<String> arrayList = deviceNames;
            return arrayList;
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VmInstance lookupByPublicIp(String ip) throws NoSuchElementException {
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            VmInstance vmExample = VmInstance.exampleWithPublicIp(ip);
            VmInstance vm = (VmInstance)((Object)Entities.createCriteriaUnique(VmInstance.class).add((Criterion)Example.create((Object)((Object)vmExample))).add(VmInstances.criterion(VmInstance.VmState.RUNNING, VmInstance.VmState.PENDING)).uniqueResult());
            if (vm == null) {
                throw new NoSuchElementException("VmInstance with public ip: " + ip);
            }
            db.commit();
            VmInstance vmInstance = vm;
            return vmInstance;
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new NoSuchElementException(ex.getMessage());
        }
    }

    public static Predicate<VmInstance> withBundleId(final String bundleId) {
        return new Predicate<VmInstance>(){

            public boolean apply(VmInstance vm) {
                return vm.getRuntimeState().getBundleTask() != null && vm.getRuntimeState().getBundleTask().getBundleId().equals(bundleId);
            }
        };
    }

    static Criterion criterion(VmInstance.VmState ... state) {
        return Restrictions.in((String)"state", (Object[])state);
    }

    public static VmInstance lookupByBundleId(String bundleId) throws NoSuchElementException {
        return (VmInstance)((Object)Iterables.find(VmInstances.list(VmInstances.withBundleId(bundleId)), VmInstances.withBundleId(bundleId)));
    }

    public static void tryCleanUp(VmInstance vm) {
        VmInstances.cleanUp(vm, true);
    }

    public static void cleanUp(VmInstance vm) {
        VmInstances.cleanUp(vm, false);
    }

    private static void cleanUp(VmInstance vm, boolean rollbackNetworkingOnFailure) {
        Throwable throwable;
        TransactionResource db;
        VmInstance.VmState vmState;
        block45: {
            BaseMessage originReq = null;
            try {
                originReq = MessageContexts.lookupLast((String)vm.getInstanceId(), (Set)Sets.newHashSet((Object[])new Class[]{TerminateInstancesType.class, StopInstancesType.class}));
            }
            catch (Exception exception) {
                // empty catch block
            }
            VmInstance.VmState vmLastState = (VmInstance.VmState)vm.getLastState();
            vmState = (VmInstance.VmState)vm.getState();
            RuntimeException logEx = new RuntimeException("Cleaning up instance: " + vm.getInstanceId() + " " + (Object)((Object)vmLastState) + " -> " + (Object)((Object)vmState));
            LOG.debug((Object)logEx.getMessage());
            Logs.extreme().info((Object)logEx, (Throwable)logEx);
            try {
                if (!Networking.getInstance().supports(NetworkingFeature.ElasticIPs) || vm.getVpcId() != null) break block45;
                try {
                    Address address = (Address)Addresses.getInstance().lookup(vm.getPublicAddress());
                    if (address.isAssigned() && vm.getInstanceId().equals(address.getInstanceId()) || !address.isReallyAssigned() && address.isAssigned() && VmInstance.VmState.PENDING.equals((Object)vmLastState)) {
                        if (address.isSystemOwned()) {
                            EventRecord.caller(VmInstances.class, (EventType)EventType.VM_TERMINATING, (Object[])new Object[]{"SYSTEM_ADDRESS", address.toString()}).debug();
                        } else {
                            EventRecord.caller(VmInstances.class, (EventType)EventType.VM_TERMINATING, (Object[])new Object[]{"USER_ADDRESS", address.toString()}).debug();
                        }
                        VmInstances.unassignAddress(vm, address, rollbackNetworkingOnFailure);
                    }
                }
                catch (NoSuchElementException e) {
                    if (VmInstance.VmState.PENDING.equals((Object)vmLastState) || VmInstance.VmStateSet.DONE.contains(vmState)) {
                        for (Address addr : Addresses.getInstance().listValues()) {
                            if (!addr.getInstanceId().equals(vm.getInstanceId())) continue;
                            VmInstances.unassignAddress(vm, addr, rollbackNetworkingOnFailure);
                        }
                    }
                }
                catch (Exception e1) {
                    LOG.debug((Object)e1, (Throwable)e1);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
                Logs.extreme().error((Object)e, (Throwable)e);
            }
        }
        try {
            VmInstances.cleanUpAttachedVolumes(vm);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
        try {
            db = Entities.distinctTransactionFor(VmInstance.class);
            throwable = null;
            try {
                VmInstanceLifecycleHelpers.get().cleanUpInstance((VmInstance)((Object)Entities.merge((Object)((Object)vm))), vmState);
                db.commit();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (db != null) {
                    if (throwable != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        db.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
        if (!rollbackNetworkingOnFailure && VmInstance.VmStateSet.TORNDOWN.apply(vm)) {
            try {
                db = Entities.distinctTransactionFor(VmInstance.class);
                throwable = null;
                try {
                    if (VmInstance.VmStateSet.DONE.apply(vm)) {
                        ((VmInstance)((Object)Entities.merge((Object)((Object)vm)))).clearReferences();
                    } else {
                        ((VmInstance)((Object)Entities.merge((Object)((Object)vm)))).clearRunReferences();
                    }
                    db.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (db != null) {
                        if (throwable != null) {
                            try {
                                db.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            db.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
        }
        VmInstances.sendTerminate(vm.getInstanceId(), vm.getPartition());
    }

    static void sendTerminate(String instanceId, String partition) {
        try {
            TerminateCallback cb = new TerminateCallback(instanceId);
            AsyncRequests.newRequest((RemoteCallback)cb).dispatch(partition);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
    }

    private static void unassignAddress(final VmInstance vm, final Address address, boolean rollbackNetworkingOnFailure) {
        Callback.Failure failureHander;
        boolean wasPending = address.isPending();
        if (wasPending) {
            try {
                address.clearPending();
            }
            catch (IllegalStateException e) {
                wasPending = false;
            }
        }
        RemoteCallback callback = address.unassign().getCallback();
        if (rollbackNetworkingOnFailure && !wasPending && !VmInstance.VmStateSet.DONE.apply(vm)) {
            callback = DelegatingRemoteCallback.suppressException(callback);
            failureHander = new Callback.Failure<Object>(){

                public void fireException(Throwable t) {
                    LOG.info((Object)("Unable to assign address " + address.getName() + " for " + vm.getInstanceId() + ", will retry."));
                    if (address.isPending()) {
                        try {
                            address.clearPending();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        if (!address.isAllocated()) {
                            address.pendingAssignment();
                        }
                        address.assign(vm).clearPending();
                    }
                    catch (Exception e) {
                        LOG.error((Object)e, (Throwable)e);
                        LOG.warn((Object)("Address potentially in an inconsistent state: " + LogUtil.dumpObject((Object)((Object)address))));
                    }
                }
            };
        } else {
            failureHander = Callbacks.noopFailure();
        }
        AddressingDispatcher.dispatch(AsyncRequests.newRequest(callback).then(failureHander), vm.getPartition());
    }

    private static void cleanUpAttachedVolumes(String instanceId, String qualifier, Collection<VmVolumeAttachment> attachments, Predicate<? super VmVolumeAttachment> matching) {
        if (attachments != null) {
            for (VmVolumeAttachment attachment : Iterables.filter((Iterable)Lists.newArrayList(attachments), matching)) {
                try {
                    LOG.debug((Object)(instanceId + ": Marking " + qualifier + " volume EXTANT " + attachment.getVolumeId()));
                    Volume volume = Volumes.lookup(null, attachment.getVolumeId());
                    if (State.BUSY.equals(volume.getState())) {
                        volume.setState(State.EXTANT);
                    }
                    attachments.remove(attachment);
                }
                catch (NoSuchElementException e) {
                    LOG.debug((Object)(instanceId + ": Unable to find " + qualifier + " volume not found for cleanup " + attachment.getVolumeId()));
                }
                catch (Exception ex) {
                    LOG.error((Object)(instanceId + ": Failed to cleanup " + qualifier + " volume attachment for " + attachment.getVolumeId()), (Throwable)ex);
                }
            }
        }
    }

    private static void addMatchingVolumeIds(Collection<String> volumeIds, Collection<VmVolumeAttachment> attachments, Predicate<? super VmVolumeAttachment> matching) {
        CollectionUtils.fluent(attachments).filter(matching).transform(VmVolumeAttachment.volumeId()).copyInto(volumeIds);
    }

    private static void cleanUpAttachedVolumes(final VmInstance vm) {
        if (VmInstance.VmStateSet.DONE.apply(vm)) {
            TreeSet volumesToDelete = Sets.newTreeSet();
            try (TransactionResource db = Entities.distinctTransactionFor(VmInstance.class);){
                VmInstance instance = (VmInstance)((Object)Entities.merge((Object)((Object)vm)));
                if (instance.getTransientVolumeState() != null) {
                    VmInstances.cleanUpAttachedVolumes(instance.getInstanceId(), "transient", instance.getTransientVolumeState().getAttachments(), VmVolumeAttachment.deleteOnTerminateFilter(false));
                    VmInstances.addMatchingVolumeIds(volumesToDelete, instance.getTransientVolumeState().getAttachments(), VmVolumeAttachment.deleteOnTerminateFilter(true));
                }
                if (instance.getBootRecord() != null) {
                    VmInstances.cleanUpAttachedVolumes(instance.getInstanceId(), "persistent", instance.getBootRecord().getPersistentVolumes(), VmVolumeAttachment.deleteOnTerminateFilter(false));
                    VmInstances.addMatchingVolumeIds(volumesToDelete, instance.getBootRecord().getPersistentVolumes(), VmVolumeAttachment.deleteOnTerminateFilter(true));
                }
                db.commit();
            }
            catch (Exception ex) {
                LOG.error((Object)(vm.getInstanceId() + ": Failed to cleanup attached volumes"), (Throwable)ex);
            }
            try {
                if (!volumesToDelete.isEmpty()) {
                    LOG.debug((Object)(vm.getInstanceId() + ": Cleanup for delete on terminate volumes."));
                    for (final String volumeId : volumesToDelete) {
                        try {
                            LOG.debug((Object)(vm.getInstanceId() + ": Firing delete request for " + volumeId));
                            AsyncRequests.newRequest((RemoteCallback)new MessageCallback<DeleteStorageVolumeType, DeleteStorageVolumeResponseType>(new DeleteStorageVolumeType(volumeId)){

                                public void initialize(DeleteStorageVolumeType request) {
                                }

                                public void fire(final DeleteStorageVolumeResponseType response) {
                                    Function<DeleteStorageVolumeResponseType, Void> deleteVolume = new Function<DeleteStorageVolumeResponseType, Void>(){

                                        @Nullable
                                        public Void apply(DeleteStorageVolumeResponseType deleteStorageVolumeResponseType) {
                                            Volume volume = Volumes.lookup(null, volumeId);
                                            if (null != response && response.get_return().booleanValue()) {
                                                Volumes.annihilateStorageVolume(volume);
                                            } else {
                                                LOG.error((Object)(vm.getInstanceId() + ": Failed to delete volume " + volumeId));
                                            }
                                            VmInstance instance = (VmInstance)((Object)Entities.merge((Object)((Object)vm)));
                                            if (instance.getTransientVolumeState() != null && instance.getTransientVolumeState().getAttachments() != null) {
                                                Iterables.removeIf(instance.getTransientVolumeState().getAttachments(), VmVolumeAttachment.volumeIdFilter(volumeId));
                                            }
                                            if (instance.getBootRecord() != null && instance.getBootRecord().getPersistentVolumes() != null) {
                                                Iterables.removeIf(instance.getBootRecord().getPersistentVolumes(), VmVolumeAttachment.volumeIdFilter(volumeId));
                                            }
                                            return null;
                                        }
                                    };
                                    Entities.asTransaction(Volume.class, (Function)deleteVolume).apply((Object)response);
                                }

                                public void fireException(Throwable throwable) {
                                    LOG.error((Object)(vm.getInstanceId() + ": Failed to delete volume " + volumeId), throwable);
                                }
                            }).dispatch(Topology.lookup(Storage.class, (Partition[])new Partition[]{vm.lookupPartition()}));
                        }
                        catch (NoSuchElementException e) {
                            LOG.debug((Object)(vm.getInstanceId() + ": Persistent volume not found for cleanup " + volumeId));
                        }
                        catch (Exception ex) {
                            LOG.error((Object)(vm.getInstanceId() + ": Failed to cleanup persistent volume attachment for " + volumeId), (Throwable)ex);
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOG.error((Object)(vm.getInstanceId() + ": Failed to cleanup attached volumes"), (Throwable)ex);
            }
        }
    }

    @Nonnull
    public static VmInstance lookupAny(String name) throws NoSuchElementException {
        return PersistentLookup.INSTANCE.apply(name);
    }

    @Nonnull
    public static VmInstance lookup(String name) throws NoSuchElementException, TerminatedInstanceException {
        return (VmInstance)((Object)VmInstances.lookup().apply((Object)name));
    }

    public static Function<String, VmInstance> lookup() {
        return Functions.compose((Function)TerminatedInstanceCheck.INSTANCE, (Function)PersistentLookup.INSTANCE);
    }

    public static Predicate<VmInstance> initialize() {
        return InstanceInitialize.INSTANCE;
    }

    public static VmInstance delete(VmInstance vm) throws TransactionException {
        try {
            if (VmInstance.VmStateSet.DONE.apply(vm)) {
                VmInstances.delete(vm.getInstanceId());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        return vm;
    }

    public static void delete(final String instanceId) {
        try {
            Entities.asTransaction(VmInstance.class, (Function)new Function<String, String>(){

                public String apply(String input) {
                    try {
                        VmInstance entity = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(null, input))));
                        Entities.delete((Object)((Object)entity));
                    }
                    catch (NoSuchElementException ex) {
                        LOG.debug((Object)("Instance not found for deletion: " + instanceId));
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Error deleting instance: " + instanceId + "; " + ex));
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                    }
                    return input;
                }
            }, (int)10).apply((Object)instanceId);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
    }

    public static void buried(VmInstance vm) throws TransactionException {
        Entities.asTransaction(VmInstance.class, (Function)VmInstance.Transitions.BURIED, (int)10).apply((Object)vm);
    }

    public static void buried(String key) throws NoSuchElementException, TransactionException {
        VmInstances.buried(VmInstance.Lookup.INSTANCE.apply(key));
    }

    public static void terminated(VmInstance vm) throws TransactionException {
        Entities.asTransaction(VmInstance.class, (Function)VmInstance.Transitions.TERMINATED, (int)10).apply((Object)vm);
    }

    public static void terminated(String key) throws NoSuchElementException, TransactionException {
        VmInstances.terminated(VmInstance.Lookup.INSTANCE.apply(key));
    }

    public static void stopped(VmInstance vm) throws TransactionException {
        Entities.asTransaction(VmInstance.class, (Function)VmInstance.Transitions.STOPPED, (int)10).apply((Object)vm);
    }

    public static void stopped(String key) throws NoSuchElementException, TransactionException {
        VmInstance vm = VmInstance.Lookup.INSTANCE.apply(key);
        if (vm.getBootRecord().getMachine() instanceof BlockStorageImageInfo) {
            VmInstances.stopped(vm);
        }
    }

    public static void shutDown(VmInstance vm) throws TransactionException {
        if (!VmInstance.VmStateSet.DONE.apply(vm)) {
            Entities.asTransaction(VmInstance.class, (Function)VmInstance.Transitions.SHUTDOWN, (int)10).apply((Object)vm);
        }
    }

    public static void reachable(VmInstance vm) throws TransactionException {
        VmInstances.transactional(VmInstance.InstanceStatusUpdate.REACHABLE).apply((Object)vm);
    }

    public static void unreachable(VmInstance vm) throws TransactionException {
        VmInstances.transactional(VmInstance.InstanceStatusUpdate.UNREACHABLE).apply((Object)vm);
    }

    private static Function<VmInstance, VmInstance> transactional(Function<VmInstance, VmInstance> update) {
        return Entities.asTransaction(VmInstance.class, update, (int)10);
    }

    public static List<VmInstance> list(@Nullable Predicate<? super VmInstance> predicate) {
        return VmInstances.list((OwnerFullName)null, predicate);
    }

    public static List<VmInstance> list(@Nullable OwnerFullName ownerFullName, @Nullable Predicate<? super VmInstance> predicate) {
        return VmInstances.list(ownerFullName, Restrictions.not((Criterion)VmInstances.criterion(VmInstance.VmStateSet.DONE.array())), Collections.emptyMap(), (Predicate<? super VmInstance>)Predicates.and(VmInstance.VmStateSet.DONE.not(), predicate));
    }

    public static List<VmInstance> list(final @Nullable OwnerFullName ownerFullName, final Criterion criterion, final Map<String, String> aliases, @Nullable Predicate<? super VmInstance> predicate) {
        return VmInstances.list(new Supplier<List<VmInstance>>(){

            public List<VmInstance> get() {
                return Entities.query((Object)((Object)VmInstance.named(ownerFullName, null)), (boolean)false, (Criterion)criterion, (Map)aliases);
            }
        }, (Predicate<? super VmInstance>)Predicates.and((Predicate)RestrictedTypes.filterByOwner((OwnerFullName)ownerFullName), VmInstances.checkPredicate(predicate)));
    }

    public static List<VmInstance> listByClientToken(final @Nullable OwnerFullName ownerFullName, final @Nullable String clientToken, @Nullable Predicate<? super VmInstance> predicate) {
        return VmInstances.list(new Supplier<List<VmInstance>>(){

            public List<VmInstance> get() {
                return Entities.query((Object)((Object)VmInstance.withToken(ownerFullName, clientToken)));
            }
        }, (Predicate<? super VmInstance>)Predicates.and((Predicate[])new Predicate[]{CollectionUtils.propertyPredicate((Object)clientToken, (Function)VmInstanceFilterFunctions.CLIENT_TOKEN), RestrictedTypes.filterByOwner((OwnerFullName)ownerFullName), VmInstances.checkPredicate(predicate)}));
    }

    private static List<VmInstance> list(@Nonnull Supplier<List<VmInstance>> instancesSupplier, @Nullable Predicate<? super VmInstance> predicate) {
        predicate = VmInstances.checkPredicate(predicate);
        return VmInstances.listPersistent(instancesSupplier, predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<VmInstance> listPersistent(@Nonnull Supplier<List<VmInstance>> instancesSupplier, @Nonnull Predicate<? super VmInstance> predicate) {
        EntityTransaction db = Entities.get(VmInstance.class);
        try {
            Iterable vms = Iterables.filter((Iterable)((Iterable)instancesSupplier.get()), predicate);
            ArrayList instances = Lists.newArrayList((Iterable)vms);
            db.commit();
            ArrayList arrayList = instances;
            return arrayList;
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
            ArrayList arrayList = Lists.newArrayList();
            return arrayList;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    private static <T> Predicate<T> checkPredicate(Predicate<T> predicate) {
        return predicate == null ? Predicates.alwaysTrue() : predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(String name) {
        EntityTransaction db = Entities.get(VmInstance.class);
        try {
            VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(null, name))));
            db.commit();
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException ex) {
            boolean bl = false;
            return bl;
        }
        catch (TransactionException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public static RunningInstancesItemType transform(VmInstance vm) {
        return VmInstance.Transform.INSTANCE.apply(vm);
    }

    public static Function<VmInstance, String> toNodeHost() {
        return VmInstanceFilterFunctions.NODE_HOST;
    }

    public static Function<VmInstance, String> toInstanceUuid() {
        return Functions.compose((Function)HasNaturalId.Utils.toNaturalId(), (Function)Functions.identity());
    }

    public static String dnsName(String ip, Name domain) {
        String suffix = domain.relativize(Name.root).toString();
        return "euca-" + ip.replace('.', '-') + INSTANCE_SUBDOMAIN + "." + suffix;
    }

    public static RunningInstancesItemType transform(String name) {
        return VmInstance.Transform.INSTANCE.apply(VmInstances.lookup(name));
    }

    public static Function<VmInstance, VmBundleTask> bundleTask() {
        return VmInstanceToVmBundleTask.INSTANCE;
    }

    private static <T> Set<T> blockDeviceSet(VmInstance instance, Function<? super VmVolumeAttachment, T> transform) {
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.concat(instance.getBootRecord().getPersistentVolumes(), instance.getTransientVolumeState().getAttachments()), transform));
    }

    private static <T> Set<T> networkGroupSet(VmInstance instance, Function<? super NetworkGroup, T> transform) {
        return instance.getNetworkGroups() != null ? Sets.newHashSet((Iterable)Iterables.transform(instance.getNetworkGroups(), transform)) : Collections.emptySet();
    }

    private static <T> Set<T> networkInterfaceSet(VmInstance instance, Function<? super NetworkInterface, T> transform) {
        return instance.getNetworkInterfaces() != null ? Sets.newHashSet((Iterable)Iterables.transform(instance.getNetworkInterfaces(), transform)) : Collections.emptySet();
    }

    private static <T> Set<T> networkInterfaceSetSet(VmInstance instance, Function<? super NetworkInterface, Set<T>> transform) {
        return instance.getNetworkInterfaces() != null ? Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform(instance.getNetworkInterfaces(), transform))) : Collections.emptySet();
    }

    private static enum VmInstanceToVmBundleTask implements Function<VmInstance, VmBundleTask>
    {
        INSTANCE{

            public VmBundleTask apply(VmInstance vmInstance) {
                return vmInstance.getRuntimeState() == null ? null : vmInstance.getRuntimeState().getBundleTask();
            }
        };

    }

    private static enum VmInstanceFilterFunctions implements Function<VmInstance, String>
    {
        ARCHITECTURE{

            public String apply(VmInstance instance) {
                BootableImageInfo imageInfo = instance.getBootRecord().getMachine();
                return imageInfo instanceof ImageInfo ? Strings.toString((Object)((ImageInfo)((Object)imageInfo)).getArchitecture()) : null;
            }
        }
        ,
        AVAILABILITY_ZONE{

            public String apply(VmInstance instance) {
                return instance.getPartition();
            }
        }
        ,
        CLIENT_TOKEN{

            public String apply(VmInstance instance) {
                return instance.getClientToken();
            }
        }
        ,
        DNS_NAME{

            public String apply(VmInstance instance) {
                return instance.getDisplayPublicDnsName();
            }
        }
        ,
        IMAGE_ID{

            public String apply(VmInstance instance) {
                return instance.getImageId();
            }
        }
        ,
        INSTANCE_PROFILE_ARN{

            public String apply(VmInstance instance) {
                return instance.getIamInstanceProfileArn();
            }
        }
        ,
        INSTANCE_STATE_NAME{

            public String apply(VmInstance instance) {
                return instance.getDisplayState() == null ? null : instance.getDisplayState().getName();
            }
        }
        ,
        INSTANCE_STATUS{

            public String apply(VmInstance instance) {
                return ((VmRuntimeState.InstanceStatus)((Object)Objects.firstNonNull((Object)((Object)instance.getRuntimeState().getInstanceStatus()), (Object)((Object)VmRuntimeState.InstanceStatus.Ok)))).toString();
            }
        }
        ,
        INSTANCE_REACHABILITY_STATUS{

            public String apply(VmInstance instance) {
                return ((VmRuntimeState.ReachabilityStatus)((Object)Objects.firstNonNull((Object)((Object)instance.getRuntimeState().getReachabilityStatus()), (Object)((Object)VmRuntimeState.ReachabilityStatus.Passed)))).toString();
            }
        }
        ,
        INSTANCE_TYPE{

            public String apply(VmInstance instance) {
                return instance.getVmType() == null ? null : instance.getVmType().getName();
            }
        }
        ,
        IP_ADDRESS{

            public String apply(VmInstance instance) {
                return instance.getDisplayPublicAddress();
            }
        }
        ,
        KERNEL_ID{

            public String apply(VmInstance instance) {
                return instance.getKernelId();
            }
        }
        ,
        KEY_NAME{

            public String apply(VmInstance instance) {
                return (String)CloudMetadatas.toDisplayName().apply((Object)instance.getKeyPair());
            }
        }
        ,
        LAUNCH_INDEX{

            public String apply(VmInstance instance) {
                return Strings.toString((Object)instance.getLaunchRecord().getLaunchIndex());
            }
        }
        ,
        MONITORING_STATE{

            public String apply(VmInstance instance) {
                return instance.getMonitoring() != false ? "enabled" : "disabled";
            }
        }
        ,
        NODE_HOST{

            public String apply(VmInstance instance) {
                return instance.getServiceTag() == null ? null : URI.create(instance.getServiceTag()).getHost();
            }
        }
        ,
        OWNER_ID{

            public String apply(VmInstance instance) {
                return instance.getOwnerAccountNumber();
            }
        }
        ,
        PLATFORM{

            public String apply(VmInstance instance) {
                return "windows".equals(instance.getPlatform()) ? "windows" : "";
            }
        }
        ,
        PRIVATE_DNS_NAME{

            public String apply(VmInstance instance) {
                return instance.getDisplayPrivateDnsName();
            }
        }
        ,
        PRIVATE_IP_ADDRESS{

            public String apply(VmInstance instance) {
                return instance.getDisplayPrivateAddress();
            }
        }
        ,
        RAMDISK_ID{

            public String apply(VmInstance instance) {
                return instance.getRamdiskId();
            }
        }
        ,
        REASON{

            public String apply(VmInstance instance) {
                return instance.getRuntimeState() == null ? null : instance.getRuntimeState().getReason();
            }
        }
        ,
        RESERVATION_ID{

            public String apply(VmInstance instance) {
                return instance.getReservationId();
            }
        }
        ,
        ROOT_DEVICE_NAME{

            public String apply(VmInstance instance) {
                BootableImageInfo imageInfo = instance.getBootRecord().getMachine();
                return imageInfo == null ? null : imageInfo.getRootDeviceName();
            }
        }
        ,
        ROOT_DEVICE_TYPE{

            public String apply(VmInstance instance) {
                BootableImageInfo imageInfo = instance.getBootRecord().getMachine();
                return imageInfo == null ? null : imageInfo.getRootDeviceType();
            }
        }
        ,
        SUBNET_ID{

            public String apply(VmInstance instance) {
                return instance.getSubnetId();
            }
        }
        ,
        VIRTUALIZATION_TYPE{

            public String apply(VmInstance vmInstance) {
                return vmInstance.getVirtualizationType();
            }
        }
        ,
        VPC_ID{

            public String apply(VmInstance instance) {
                return instance.getVpcId();
            }
        };

    }

    private static enum VmInstanceIntegerSetFilterFunctions implements Function<VmInstance, Set<Integer>>
    {
        NETWORK_INTERFACE_ATTACHMENT_DEVICE_INDEX{

            public Set<Integer> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterIntegerFunctions.ATTACHMENT_DEVICE_INDEX);
            }
        };

    }

    private static enum VmInstanceIntegerFilterFunctions implements Function<VmInstance, Integer>
    {
        INSTANCE_STATE_CODE{

            public Integer apply(VmInstance instance) {
                return instance.getDisplayState().getCode();
            }
        };

    }

    private static enum VmInstanceDateSetFilterFunctions implements Function<VmInstance, Set<Date>>
    {
        BLOCK_DEVICE_MAPPING_ATTACH_TIME{

            public Set<Date> apply(VmInstance instance) {
                return VmInstances.blockDeviceSet(instance, VmVolumeAttachmentDateFilterFunctions.ATTACH_TIME);
            }
        }
        ,
        EVENT_NOT_AFTER{

            public Set<Date> apply(VmInstance instance) {
                Optional<InstanceStatusEventType> eventInfo = VmInstance.StatusTransform.getEventInfo(instance);
                return eventInfo.isPresent() ? Collections.singleton(((InstanceStatusEventType)eventInfo.get()).getNotAfter()) : Collections.emptySet();
            }
        }
        ,
        EVENT_NOT_BEFORE{

            public Set<Date> apply(VmInstance instance) {
                Optional<InstanceStatusEventType> eventInfo = VmInstance.StatusTransform.getEventInfo(instance);
                return eventInfo.isPresent() ? Collections.singleton(((InstanceStatusEventType)eventInfo.get()).getNotBefore()) : Collections.emptySet();
            }
        }
        ,
        NETWORK_INTERFACE_ATTACHMENT_ATTACH_TIME{

            public Set<Date> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterDateFunctions.ATTACHMENT_ATTACH_TIME);
            }
        };

    }

    private static enum VmInstanceDateFilterFunctions implements Function<VmInstance, Date>
    {
        LAUNCH_TIME{

            public Date apply(VmInstance instance) {
                return instance.getLaunchRecord().getLaunchTime();
            }
        };

    }

    private static enum VmInstanceBooleanSetFilterFunctions implements Function<VmInstance, Set<Boolean>>
    {
        BLOCK_DEVICE_MAPPING_DELETE_ON_TERMINATE{

            public Set<Boolean> apply(VmInstance instance) {
                return VmInstances.blockDeviceSet(instance, VmVolumeAttachmentBooleanFilterFunctions.DELETE_ON_TERMINATE);
            }
        }
        ,
        NETWORK_INTERFACE_ADDRESSES_PRIMARY{

            public Set<Boolean> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, Functions.forSupplier((Supplier)Suppliers.ofInstance((Object)true)));
            }
        }
        ,
        NETWORK_INTERFACE_ATTACHMENT_DELETE_ON_TERMINATION{

            public Set<Boolean> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterBooleanFunctions.ATTACHMENT_DELETE_ON_TERMINATION);
            }
        }
        ,
        NETWORK_INTERFACE_SOURCE_DEST_CHECK{

            public Set<Boolean> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterBooleanFunctions.SOURCE_DEST_CHECK);
            }
        };

    }

    private static enum VmInstanceStringSetFilterFunctions implements Function<VmInstance, Set<String>>
    {
        ASSOCIATION_PUBLIC_IP{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.ASSOCIATION_PUBLIC_IP);
            }
        }
        ,
        ASSOCIATION_IP_OWNER_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.ASSOCIATION_IP_OWNER_ID);
            }
        }
        ,
        ASSOCIATION_ALLOCATION_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.ASSOCIATION_ALLOCATION_ID);
            }
        }
        ,
        ASSOCIATION_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.ASSOCIATION_ID);
            }
        }
        ,
        BLOCK_DEVICE_MAPPING_DEVICE_NAME{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.blockDeviceSet(instance, VmVolumeAttachmentFilterFunctions.DEVICE_NAME);
            }
        }
        ,
        BLOCK_DEVICE_MAPPING_STATUS{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.blockDeviceSet(instance, VmVolumeAttachmentFilterFunctions.STATUS);
            }
        }
        ,
        BLOCK_DEVICE_MAPPING_VOLUME_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.blockDeviceSet(instance, VmVolumeAttachmentFilterFunctions.VOLUME_ID);
            }
        }
        ,
        EVENT_CODE{

            public Set<String> apply(VmInstance instance) {
                Optional<InstanceStatusEventType> eventInfo = VmInstance.StatusTransform.getEventInfo(instance);
                return eventInfo.isPresent() ? Collections.singleton(((InstanceStatusEventType)eventInfo.get()).getCode()) : Collections.emptySet();
            }
        }
        ,
        EVENT_DESCRIPTION{

            public Set<String> apply(VmInstance instance) {
                Optional<InstanceStatusEventType> eventInfo = VmInstance.StatusTransform.getEventInfo(instance);
                return eventInfo.isPresent() ? Collections.singleton(((InstanceStatusEventType)eventInfo.get()).getDescription()) : Collections.emptySet();
            }
        }
        ,
        GROUP_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkGroupSet(instance, NetworkGroups.groupId());
            }
        }
        ,
        GROUP_NAME{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkGroupSet(instance, CloudMetadatas.toDisplayName());
            }
        }
        ,
        NETWORK_INTERFACE_DESCRIPTION{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.DESCRIPTION);
            }
        }
        ,
        NETWORK_INTERFACE_SUBNET_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.SUBNET_ID);
            }
        }
        ,
        NETWORK_INTERFACE_VPC_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.VPC_ID);
            }
        }
        ,
        NETWORK_INTERFACE_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, CloudMetadatas.toDisplayName());
            }
        }
        ,
        NETWORK_INTERFACE_OWNER_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.OWNER_ID);
            }
        }
        ,
        NETWORK_INTERFACE_AVAILABILITY_ZONE{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.AVAILABILITY_ZONE);
            }
        }
        ,
        NETWORK_INTERFACE_STATUS{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.STATE);
            }
        }
        ,
        NETWORK_INTERFACE_MAC_ADDRESS{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.MAC_ADDRESS);
            }
        }
        ,
        NETWORK_INTERFACE_PRIVATE_IP{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.PRIVATE_IP);
            }
        }
        ,
        NETWORK_INTERFACE_PRIVATE_DNS_NAME{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.PRIVATE_DNS_NAME);
            }
        }
        ,
        NETWORK_INTERFACE_GROUP_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSetSet(instance, NetworkInterfaces.FilterStringSetFunctions.GROUP_ID);
            }
        }
        ,
        NETWORK_INTERFACE_GROUP_NAME{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSetSet(instance, NetworkInterfaces.FilterStringSetFunctions.GROUP_NAME);
            }
        }
        ,
        NETWORK_INTERFACE_ATTACHMENT_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.ATTACHMENT_ATTACHMENT_ID);
            }
        }
        ,
        NETWORK_INTERFACE_ATTACHMENT_INSTANCE_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.ATTACHMENT_INSTANCE_ID);
            }
        }
        ,
        NETWORK_INTERFACE_ATTACHMENT_INSTANCE_OWNER_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.ATTACHMENT_INSTANCE_OWNER_ID);
            }
        }
        ,
        NETWORK_INTERFACE_ATTACHMENT_STATUS{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.ATTACHMENT_STATUS);
            }
        }
        ,
        NETWORK_INTERFACE_ASSOCIATION_PUBLIC_IP{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.ASSOCIATION_PUBLIC_IP);
            }
        }
        ,
        NETWORK_INTERFACE_ASSOCIATION_IP_OWNER_ID{

            public Set<String> apply(VmInstance instance) {
                return VmInstances.networkInterfaceSet(instance, NetworkInterfaces.FilterStringFunctions.ASSOCIATION_IP_OWNER_ID);
            }
        };

    }

    private static enum VmVolumeAttachmentFilterFunctions implements Function<VmVolumeAttachment, String>
    {
        DEVICE_NAME{

            public String apply(VmVolumeAttachment volumeAttachment) {
                return volumeAttachment.getDevice();
            }
        }
        ,
        STATUS{

            public String apply(VmVolumeAttachment volumeAttachment) {
                return volumeAttachment.getStatus();
            }
        }
        ,
        VOLUME_ID{

            public String apply(VmVolumeAttachment volumeAttachment) {
                return volumeAttachment.getVolumeId();
            }
        };

    }

    private static enum VmVolumeAttachmentDateFilterFunctions implements Function<VmVolumeAttachment, Date>
    {
        ATTACH_TIME{

            public Date apply(VmVolumeAttachment volumeAttachment) {
                return volumeAttachment.getAttachTime();
            }
        };

    }

    private static enum VmVolumeAttachmentBooleanFilterFunctions implements Function<VmVolumeAttachment, Boolean>
    {
        DELETE_ON_TERMINATE{

            public Boolean apply(VmVolumeAttachment volumeAttachment) {
                return volumeAttachment.getDeleteOnTerminate();
            }
        };

    }

    private static enum BundleFilterFunctions implements Function<VmBundleTask, String>
    {
        BUNDLE_ID{

            public String apply(VmBundleTask bundleTask) {
                return bundleTask.getBundleId();
            }
        }
        ,
        ERROR_CODE{

            public String apply(VmBundleTask bundleTask) {
                return bundleTask.getErrorCode();
            }
        }
        ,
        ERROR_MESSAGE{

            public String apply(VmBundleTask bundleTask) {
                return bundleTask.getErrorMessage();
            }
        }
        ,
        INSTANCE_ID{

            public String apply(VmBundleTask bundleTask) {
                return bundleTask.getInstanceId();
            }
        }
        ,
        PROGRESS{

            public String apply(VmBundleTask bundleTask) {
                return bundleTask.getProgress() + "%";
            }
        }
        ,
        S3_BUCKET{

            public String apply(VmBundleTask bundleTask) {
                return bundleTask.getBucket();
            }
        }
        ,
        S3_PREFIX{

            public String apply(VmBundleTask bundleTask) {
                return bundleTask.getPrefix();
            }
        }
        ,
        STATE{

            public String apply(VmBundleTask bundleTask) {
                return bundleTask.getState().name();
            }
        };

    }

    private static enum BundleDateFilterFunctions implements Function<VmBundleTask, Date>
    {
        START_TIME{

            public Date apply(VmBundleTask bundleTask) {
                return bundleTask.getStartTime();
            }
        }
        ,
        UPDATE_TIME{

            public Date apply(VmBundleTask bundleTask) {
                return bundleTask.getUpdateTime();
            }
        };

    }

    public static class VmBundleTaskFilterSupport
    extends FilterSupport<VmBundleTask> {
        public VmBundleTaskFilterSupport() {
            super(VmBundleTaskFilterSupport.builderFor(VmBundleTask.class).withStringProperty("bundle-id", BundleFilterFunctions.BUNDLE_ID).withStringProperty("error-code", BundleFilterFunctions.ERROR_CODE).withStringProperty("error-message", BundleFilterFunctions.ERROR_MESSAGE).withStringProperty("instance-id", BundleFilterFunctions.INSTANCE_ID).withStringProperty("progress", BundleFilterFunctions.PROGRESS).withStringProperty("s3-bucket", BundleFilterFunctions.S3_BUCKET).withStringProperty("s3-prefix", BundleFilterFunctions.S3_PREFIX).withDateProperty("start-time", BundleDateFilterFunctions.START_TIME).withStringProperty("state", BundleFilterFunctions.STATE).withDateProperty("update-time", BundleDateFilterFunctions.UPDATE_TIME).withPersistenceFilter("error-code", "runtimeState.bundleTask.errorCode", Collections.emptySet()).withPersistenceFilter("error-message", "runtimeState.bundleTask.errorMessage", Collections.emptySet()).withPersistenceFilter("instance-id", "displayName").withPersistenceFilter("progress", "runtimeState.bundleTask.progress", Collections.emptySet(), ProgressToInteger.INSTANCE).withPersistenceFilter("s3-bucket", "runtimeState.bundleTask.bucket", Collections.emptySet()).withPersistenceFilter("s3-prefix", "runtimeState.bundleTask.prefix", Collections.emptySet()).withPersistenceFilter("start-time", "runtimeState.bundleTask.startTime", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Date).withPersistenceFilter("state", "runtimeState.bundleTask.state", Collections.emptySet(), Enums.valueOfFunction(VmBundleTask.BundleState.class)).withPersistenceFilter("update-time", "runtimeState.bundleTask.updateTime", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Date));
        }

        private static enum ProgressToInteger implements Function<String, Integer>
        {
            INSTANCE{

                public Integer apply(String textValue) {
                    String cleanedValue = textValue;
                    if (cleanedValue.endsWith("%")) {
                        cleanedValue = cleanedValue.substring(0, cleanedValue.length() - 1);
                    }
                    try {
                        return Integer.valueOf(cleanedValue);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            };

        }
    }

    public static class VmInstanceStatusFilterSupport
    extends FilterSupport<VmInstance> {
        public VmInstanceStatusFilterSupport() {
            super(VmInstanceStatusFilterSupport.qualifierBuilderFor(VmInstance.class, "status").withStringProperty("availability-zone", VmInstanceFilterFunctions.AVAILABILITY_ZONE).withStringSetProperty("event.code", VmInstanceStringSetFilterFunctions.EVENT_CODE).withStringSetProperty("event.description", VmInstanceStringSetFilterFunctions.EVENT_DESCRIPTION).withDateSetProperty("event.not-after", VmInstanceDateSetFilterFunctions.EVENT_NOT_AFTER).withDateSetProperty("event.not-before", VmInstanceDateSetFilterFunctions.EVENT_NOT_BEFORE).withInternalStringProperty("instance-id", (Function<VmInstance, String>)CloudMetadatas.toDisplayName()).withIntegerProperty("instance-state-code", VmInstanceIntegerFilterFunctions.INSTANCE_STATE_CODE).withStringProperty("instance-state-name", VmInstanceFilterFunctions.INSTANCE_STATE_NAME).withStringProperty("system-status.status", VmInstanceFilterFunctions.INSTANCE_STATUS).withStringProperty("system-status.reachability", VmInstanceFilterFunctions.INSTANCE_REACHABILITY_STATUS).withStringProperty("instance-status.status", VmInstanceFilterFunctions.INSTANCE_STATUS).withStringProperty("instance-status.reachability", VmInstanceFilterFunctions.INSTANCE_REACHABILITY_STATUS).withPersistenceFilter("availability-zone", "placement.partitionName", Collections.emptySet()).withPersistenceFilter("instance-id", "displayName").withPersistenceFilter("system-status.status", "runtimeState.instanceStatus", Collections.emptySet(), VmRuntimeState.InstanceStatus.fromString()).withPersistenceFilter("system-status.reachability", "runtimeState.reachabilityStatus", Collections.emptySet(), VmRuntimeState.ReachabilityStatus.fromString()).withPersistenceFilter("instance-status.status", "runtimeState.instanceStatus", Collections.emptySet(), VmRuntimeState.InstanceStatus.fromString()).withPersistenceFilter("instance-status.reachability", "runtimeState.reachabilityStatus", Collections.emptySet(), VmRuntimeState.ReachabilityStatus.fromString()));
        }
    }

    public static class VmInstanceFilterSupport
    extends FilterSupport<VmInstance> {
        public VmInstanceFilterSupport() {
            super(VmInstanceFilterSupport.builderFor(VmInstance.class).withTagFiltering(VmInstanceTag.class, "instance").withStringProperty("architecture", VmInstanceFilterFunctions.ARCHITECTURE).withStringProperty("availability-zone", VmInstanceFilterFunctions.AVAILABILITY_ZONE).withDateSetProperty("block-device-mapping.attach-time", VmInstanceDateSetFilterFunctions.BLOCK_DEVICE_MAPPING_ATTACH_TIME).withBooleanSetProperty("block-device-mapping.delete-on-termination", VmInstanceBooleanSetFilterFunctions.BLOCK_DEVICE_MAPPING_DELETE_ON_TERMINATE).withStringSetProperty("block-device-mapping.device-name", VmInstanceStringSetFilterFunctions.BLOCK_DEVICE_MAPPING_DEVICE_NAME).withStringSetProperty("block-device-mapping.status", VmInstanceStringSetFilterFunctions.BLOCK_DEVICE_MAPPING_STATUS).withStringSetProperty("block-device-mapping.volume-id", VmInstanceStringSetFilterFunctions.BLOCK_DEVICE_MAPPING_VOLUME_ID).withStringProperty("client-token", VmInstanceFilterFunctions.CLIENT_TOKEN).withStringProperty("dns-name", VmInstanceFilterFunctions.DNS_NAME).withStringSetProperty("group-id", VmInstanceStringSetFilterFunctions.GROUP_ID).withStringSetProperty("group-name", VmInstanceStringSetFilterFunctions.GROUP_NAME).withStringProperty("image-id", VmInstanceFilterFunctions.IMAGE_ID).withStringProperty("iam-instance-profile.arn", VmInstanceFilterFunctions.INSTANCE_PROFILE_ARN).withStringProperty("instance-id", (Function<VmInstance, String>)CloudMetadatas.toDisplayName()).withConstantProperty("instance-lifecycle", "").withIntegerProperty("instance-state-code", VmInstanceIntegerFilterFunctions.INSTANCE_STATE_CODE).withStringProperty("instance-state-name", VmInstanceFilterFunctions.INSTANCE_STATE_NAME).withStringProperty("instance-type", VmInstanceFilterFunctions.INSTANCE_TYPE).withStringSetProperty("instance.group-id", VmInstanceStringSetFilterFunctions.GROUP_ID).withStringSetProperty("instance.group-name", VmInstanceStringSetFilterFunctions.GROUP_NAME).withStringProperty("ip-address", VmInstanceFilterFunctions.IP_ADDRESS).withStringProperty("kernel-id", VmInstanceFilterFunctions.KERNEL_ID).withStringProperty("key-name", VmInstanceFilterFunctions.KEY_NAME).withStringProperty("launch-index", VmInstanceFilterFunctions.LAUNCH_INDEX).withDateProperty("launch-time", VmInstanceDateFilterFunctions.LAUNCH_TIME).withStringProperty("monitoring-state", VmInstanceFilterFunctions.MONITORING_STATE).withStringProperty("owner-id", VmInstanceFilterFunctions.OWNER_ID).withUnsupportedProperty("placement-group-name").withStringProperty("platform", VmInstanceFilterFunctions.PLATFORM).withStringProperty("private-dns-name", VmInstanceFilterFunctions.PRIVATE_DNS_NAME).withStringProperty("private-ip-address", VmInstanceFilterFunctions.PRIVATE_IP_ADDRESS).withUnsupportedProperty("product-code").withUnsupportedProperty("product-code.type").withStringProperty("ramdisk-id", VmInstanceFilterFunctions.RAMDISK_ID).withStringProperty("reason", VmInstanceFilterFunctions.REASON).withUnsupportedProperty("requester-id").withStringProperty("reservation-id", VmInstanceFilterFunctions.RESERVATION_ID).withStringProperty("root-device-name", VmInstanceFilterFunctions.ROOT_DEVICE_NAME).withStringProperty("root-device-type", VmInstanceFilterFunctions.ROOT_DEVICE_TYPE).withUnsupportedProperty("source-dest-check").withUnsupportedProperty("spot-instance-request-id").withUnsupportedProperty("state-reason-code").withUnsupportedProperty("state-reason-message").withStringProperty("subnet-id", VmInstanceFilterFunctions.SUBNET_ID).withConstantProperty("tenancy", "default").withStringProperty("virtualization-type", VmInstanceFilterFunctions.VIRTUALIZATION_TYPE).withStringProperty("vpc-id", VmInstanceFilterFunctions.VPC_ID).withUnsupportedProperty("hypervisor").withStringSetProperty("network-interface.description", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_DESCRIPTION).withStringSetProperty("network-interface.subnet-id", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_SUBNET_ID).withStringSetProperty("network-interface.vpc-id", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_VPC_ID).withStringSetProperty("network-interface.network-interface.id", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_ID).withStringSetProperty("network-interface.owner-id", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_OWNER_ID).withStringSetProperty("network-interface.availability-zone", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_AVAILABILITY_ZONE).withUnsupportedProperty("network-interface.requester-id").withUnsupportedProperty("network-interface.requester-managed").withStringSetProperty("network-interface.status", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_STATUS).withStringSetProperty("network-interface.mac-address", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_MAC_ADDRESS).withStringSetProperty("network-interface-private-dns-name", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_PRIVATE_DNS_NAME).withBooleanSetProperty("network-interface.source-destination-check", VmInstanceBooleanSetFilterFunctions.NETWORK_INTERFACE_SOURCE_DEST_CHECK).withStringSetProperty("network-interface.group-id", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_GROUP_ID).withStringSetProperty("network-interface.group-name", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_GROUP_NAME).withStringSetProperty("network-interface.addresses.private-ip-address", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_PRIVATE_IP).withBooleanSetProperty("network-interface.addresses.primary", VmInstanceBooleanSetFilterFunctions.NETWORK_INTERFACE_ADDRESSES_PRIMARY).withStringSetProperty("network-interface.addresses.association.public-ip", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_ASSOCIATION_PUBLIC_IP).withStringSetProperty("network-interface.addresses.association.ip-owner-id", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_ASSOCIATION_IP_OWNER_ID).withStringSetProperty("network-interface.attachment.attachment-id", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_ATTACHMENT_ID).withStringSetProperty("network-interface.attachment.instance-id", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_ATTACHMENT_INSTANCE_ID).withStringSetProperty("network-interface.attachment.instance-owner-id", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_ATTACHMENT_INSTANCE_OWNER_ID).withIntegerSetProperty("network-interface.attachment.device-index", VmInstanceIntegerSetFilterFunctions.NETWORK_INTERFACE_ATTACHMENT_DEVICE_INDEX).withStringSetProperty("network-interface.attachment.status", VmInstanceStringSetFilterFunctions.NETWORK_INTERFACE_ATTACHMENT_STATUS).withDateSetProperty("network-interface.attachment.attach-time", VmInstanceDateSetFilterFunctions.NETWORK_INTERFACE_ATTACHMENT_ATTACH_TIME).withBooleanSetProperty("network-interface.attachment.delete-on-termination", VmInstanceBooleanSetFilterFunctions.NETWORK_INTERFACE_ATTACHMENT_DELETE_ON_TERMINATION).withStringSetProperty("association.public-ip", VmInstanceStringSetFilterFunctions.ASSOCIATION_PUBLIC_IP).withStringSetProperty("association.ip-owner-id", VmInstanceStringSetFilterFunctions.ASSOCIATION_IP_OWNER_ID).withStringSetProperty("association.allocation-id", VmInstanceStringSetFilterFunctions.ASSOCIATION_ALLOCATION_ID).withStringSetProperty("association.association-id", VmInstanceStringSetFilterFunctions.ASSOCIATION_ID).withPersistenceAlias("bootRecord.machineImage", "image").withPersistenceAlias("networkGroups", "networkGroups").withPersistenceAlias("bootRecord.vmType", "vmType").withPersistenceAlias("networkConfig.networkInterfaces", "networkInterfaces").withPersistenceAlias("networkInterfaces.vpc", "vpc").withPersistenceAlias("networkInterfaces.subnet", "subnet").withPersistenceAlias("networkInterfaces.networkGroups", "networkInterfaceNetworkGroups").withPersistenceFilter("architecture", "image.architecture", (Set<String>)Sets.newHashSet((Object[])new String[]{"bootRecord.machineImage"}), Enums.valueOfFunction(ImageMetadata.Architecture.class)).withPersistenceFilter("availability-zone", "placement.partitionName", Collections.emptySet()).withPersistenceFilter("client-token", "vmId.clientToken", Collections.emptySet()).withPersistenceFilter("group-id", "networkGroups.groupId").withPersistenceFilter("group-name", "networkGroups.displayName").withPersistenceFilter("iam-instance-profile.arn", "bootRecord.iamInstanceProfileArn", Collections.emptySet()).withPersistenceFilter("image-id", "image.displayName", Sets.newHashSet((Object[])new String[]{"bootRecord.machineImage"})).withPersistenceFilter("instance-id", "displayName").withPersistenceFilter("instance-type", "vmType.name", Sets.newHashSet((Object[])new String[]{"bootRecord.vmType"})).withPersistenceFilter("instance.group-id", "networkGroups.groupId").withPersistenceFilter("instance.group-name", "networkGroups.displayName").withPersistenceFilter("kernel-id", "image.kernelId", Sets.newHashSet((Object[])new String[]{"bootRecord.machineImage"})).withPersistenceFilter("launch-index", "launchRecord.launchIndex", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("launch-time", "launchRecord.launchTime", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Date).withPersistenceFilter("owner-id", "ownerAccountNumber").withPersistenceFilter("ramdisk-id", "image.ramdiskId", Sets.newHashSet((Object[])new String[]{"bootRecord.machineImage"})).withPersistenceFilter("reservation-id", "vmId.reservationId", Collections.emptySet()).withPersistenceFilter("subnet-id", "bootRecord.subnetId", Collections.emptySet()).withPersistenceFilter("virtualization-type", "bootRecord.virtType", Collections.emptySet(), ImageMetadata.VirtualizationType.fromString()).withPersistenceFilter("vpc-id", "bootRecord.vpcId", Collections.emptySet()).withPersistenceFilter("network-interface.description", "networkInterfaces.description", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("network-interface.subnet-id", "subnet.displayName", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces", "networkInterfaces.subnet"})).withPersistenceFilter("network-interface.vpc-id", "vpc.displayName", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces", "networkInterfaces.vpc"})).withPersistenceFilter("network-interface.network-interface.id", "networkInterfaces.displayName", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("network-interface.owner-id", "networkInterfaces.ownerAccountNumber", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("network-interface.availability-zone", "networkInterfaces.availabilityZone", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("network-interface.status", "networkInterfaces.state", (Set<String>)Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"}), Enums.valueOfFunction(NetworkInterface.State.class)).withPersistenceFilter("network-interface.mac-address", "networkInterfaces.macAddress", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("network-interface-private-dns-name", "networkInterfaces.privateDnsName", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("network-interface.source-destination-check", "networkInterfaces.sourceDestCheck", (Set<String>)Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"}), FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("network-interface.group-id", "networkInterfaceNetworkGroups.groupId", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces", "networkInterfaces.networkGroups"})).withPersistenceFilter("network-interface.group-name", "networkInterfaceNetworkGroups.displayName", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces", "networkInterfaces.networkGroups"})).withPersistenceFilter("network-interface.addresses.private-ip-address", "networkInterfaces.privateIpAddress", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("network-interface.addresses.association.public-ip", "networkInterfaces.association.publicIp", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("network-interface.addresses.association.ip-owner-id", "networkInterfaces.association.ipOwnerId", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("network-interface.attachment.attachment-id", "networkInterfaces.attachment.attachmentId", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("network-interface.attachment.instance-id", "networkInterfaces.attachment.instanceId", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("network-interface.attachment.instance-owner-id", "networkInterfaces.attachment.instanceOwnerId", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("network-interface.attachment.device-index", "networkInterfaces.attachment.deviceIndex", (Set<String>)Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"}), FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("network-interface.attachment.status", "networkInterfaces.attachment.status", (Set<String>)Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"}), Enums.valueOfFunction(NetworkInterfaceAttachment.Status.class)).withPersistenceFilter("network-interface.attachment.attach-time", "networkInterfaces.attachment.attachTime", (Set<String>)Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"}), FilterSupport.PersistenceFilter.Type.Date).withPersistenceFilter("network-interface.attachment.delete-on-termination", "networkInterfaces.attachment.deleteOnTerminate", (Set<String>)Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"}), FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("association.public-ip", "networkInterfaces.association.publicIp", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("association.ip-owner-id", "networkInterfaces.association.ipOwnerId", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("association.allocation-id", "networkInterfaces.association.allocationId", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})).withPersistenceFilter("association.association-id", "networkInterfaces.association.associationId", Sets.newHashSet((Object[])new String[]{"networkConfig.networkInterfaces"})));
        }
    }

    public static class VmInstanceAvailabilityEventListener
    implements EventListener<ClockTick> {
        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new VmInstanceAvailabilityEventListener());
        }

        public void fireEvent(ClockTick event) {
            if (Bootstrap.isFinished().booleanValue() && Hosts.isCoordinator()) {
                ArrayList resourceAvailabilityEvents = Lists.newArrayList();
                EnumMap availabilities = Maps.newEnumMap(ResourceAvailabilityEvent.ResourceType.class);
                ArrayList vmTypes = Lists.newArrayList(VmTypes.list());
                for (Cluster cluster : Clusters.getInstance().listValues()) {
                    availabilities.put(ResourceAvailabilityEvent.ResourceType.Core, new AvailabilityAccumulator(VmType.SizeProperties.Cpu));
                    availabilities.put(ResourceAvailabilityEvent.ResourceType.Disk, new AvailabilityAccumulator(VmType.SizeProperties.Disk));
                    availabilities.put(ResourceAvailabilityEvent.ResourceType.Memory, new AvailabilityAccumulator(VmType.SizeProperties.Memory));
                    for (VmType vmType : vmTypes) {
                        ResourceState.VmTypeAvailability va = cluster.getNodeState().getAvailability(vmType.getName());
                        resourceAvailabilityEvents.add(new ResourceAvailabilityEvent(ResourceAvailabilityEvent.ResourceType.Instance, new ResourceAvailabilityEvent.Availability((long)va.getMax(), (long)va.getAvailable(), (Iterable)Lists.newArrayList((Object[])new ResourceAvailabilityEvent.Tag[]{new ResourceAvailabilityEvent.Dimension("availabilityZone", cluster.getPartition()), new ResourceAvailabilityEvent.Dimension("cluster", cluster.getName()), new ResourceAvailabilityEvent.Type("vm-type", vmType.getName())}))));
                        for (AvailabilityAccumulator availability : availabilities.values()) {
                            availability.total = Math.max(availability.total, (long)(va.getMax() * (Integer)availability.valueExtractor.apply((Object)vmType)));
                            availability.available = Math.max(availability.available, (long)(va.getAvailable() * (Integer)availability.valueExtractor.apply((Object)vmType)));
                        }
                    }
                    for (AvailabilityAccumulator availability : availabilities.values()) {
                        availability.rollUp(Lists.newArrayList((Object[])new ResourceAvailabilityEvent.Tag[]{new ResourceAvailabilityEvent.Dimension("availabilityZone", cluster.getPartition()), new ResourceAvailabilityEvent.Dimension("cluster", cluster.getName())}));
                    }
                }
                for (Map.Entry entry : availabilities.entrySet()) {
                    resourceAvailabilityEvents.add(new ResourceAvailabilityEvent((ResourceAvailabilityEvent.ResourceType)entry.getKey(), (Collection)((AvailabilityAccumulator)entry.getValue()).availabilities));
                }
                for (ResourceAvailabilityEvent resourceAvailabilityEvent : resourceAvailabilityEvents) {
                    try {
                        ListenerRegistry.getInstance().fireEvent((Event)resourceAvailabilityEvent);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            }
        }

        private static final class AvailabilityAccumulator {
            private long total;
            private long available;
            private final Function<VmType, Integer> valueExtractor;
            private final List<ResourceAvailabilityEvent.Availability> availabilities = Lists.newArrayList();

            private AvailabilityAccumulator(Function<VmType, Integer> valueExtractor) {
                this.valueExtractor = valueExtractor;
            }

            private void rollUp(Iterable<ResourceAvailabilityEvent.Tag> tags) {
                this.availabilities.add(new ResourceAvailabilityEvent.Availability(this.total, this.available, tags));
                this.total = 0L;
                this.available = 0L;
            }
        }
    }

    private static enum InstanceInitialize implements Predicate<VmInstance>
    {
        INSTANCE;


        public boolean apply(VmInstance input) {
            Entities.initialize(input.getNetworkGroups());
            Entities.initialize(input.getNetworkGroupIds());
            Entities.initialize(input.getTags());
            input.getRuntimeState().getReason();
            Entities.initialize(input.getBootRecord().getPersistentVolumes());
            Entities.initialize(input.getTransientVolumeState().getAttachments());
            return true;
        }
    }

    static enum TerminatedInstanceCheck implements Function<VmInstance, VmInstance>
    {
        INSTANCE;


        @Nullable
        public VmInstance apply(VmInstance instance) {
            if (instance != null && VmInstance.VmStateSet.DONE.apply(instance)) {
                throw new TerminatedInstanceException(instance.getDisplayName());
            }
            return instance;
        }
    }

    @RestrictedTypes.Resolver(value=CloudMetadata.VmInstanceMetadata.class)
    static enum PersistentLookup implements Function<String, VmInstance>
    {
        INSTANCE;


        @Nonnull
        public VmInstance apply(String name) {
            return VmInstance.Lookup.INSTANCE.apply(name);
        }
    }

    @RestrictedTypes.QuantityMetricFunction(value=CloudMetadata.VmInstanceMetadata.class)
    public static enum CountVmInstances implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        public Long apply(OwnerFullName ownerFullName) {
            return this.countPersistentInstances(ownerFullName) + this.countPendingInstances(ownerFullName);
        }

        private long countPersistentInstances(OwnerFullName ownerFullName) {
            try (TransactionResource tx = Entities.transactionFor(VmInstance.class);){
                long l = Entities.count((Object)((Object)VmInstance.named(ownerFullName, null)), (Criterion)Restrictions.not((Criterion)VmInstances.criterion(VmInstance.VmStateSet.DONE.array())), Collections.emptyMap());
                return l;
            }
        }

        private long countPendingInstances(OwnerFullName ownerFullName) {
            long pending = 0L;
            for (Cluster cluster : Clusters.getInstance().listValues()) {
                pending += (long)cluster.getNodeState().countUncommittedPendingInstances(ownerFullName);
            }
            return pending;
        }
    }

    public static class UnknownInstanceHandlerChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            Iterable<Optional<VmInstance.RestoreHandler>> handlers = VmInstance.RestoreHandler.parseList(String.valueOf(newValue));
            if (Iterables.size(handlers) != Iterables.size((Iterable)Optional.presentInstances(handlers))) {
                throw new ConfigurablePropertyException("Invalid unknown instance handler in " + newValue + "; valid values are 'restore', 'restore-failed', 'terminate', 'terminate-done'");
            }
        }
    }

    public static class SubdomainListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (!newValue.toString().startsWith(".") || newValue.toString().endsWith(".")) {
                throw new ConfigurablePropertyException("Subdomain must begin and cannot end with a '.' -- e.g., '." + newValue.toString().replaceAll("\\.$", "") + "' is correct." + t.getFieldName());
            }
        }
    }

    public static class CacheSpecListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                CacheBuilderSpec.parse((String)String.valueOf(newValue));
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException(e.getMessage());
            }
        }
    }

    public static class UserDataMaxSizeChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            int maxSizeKB;
            block9: {
                LOG.info((Object)"in fire change");
                maxSizeKB = -1;
                try {
                    if (newValue == null) {
                        throw new NullPointerException("newValue");
                    }
                    if (newValue instanceof String) {
                        maxSizeKB = Integer.parseInt((String)newValue);
                        break block9;
                    }
                    if (newValue instanceof Integer) {
                        maxSizeKB = (Integer)newValue;
                        break block9;
                    }
                    throw new ClassCastException("Expecting Integer or String for value, got " + newValue.getClass());
                }
                catch (Exception ex) {
                    throw new ConfigurablePropertyException("Invalid value " + newValue);
                }
            }
            if (maxSizeKB <= 0 || maxSizeKB > ABSOLUTE_USER_DATA_MAX_SIZE_KB) {
                throw new ConfigurablePropertyException("Invalid value " + newValue + ", must be between 1 and " + ABSOLUTE_USER_DATA_MAX_SIZE_KB);
            }
            try {
                t.getField().set(null, t.getTypeParser().apply(newValue));
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
                throw new ConfigurablePropertyException((Throwable)e1);
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
                throw new ConfigurablePropertyException((Throwable)e1);
            }
        }
    }

    public static class VmSpecialUserData {
        public static final String EUCAKEY_CRED_SETUP = "euca-" + B64.standard.encString((String)"setup-credential");
        private String key = null;
        private String payload = null;
        private String userData = null;
        private String expirationDays = null;

        public VmSpecialUserData(String userData) {
            if (userData == null || userData.isEmpty()) {
                return;
            }
            int i = userData.indexOf("\n");
            if (i < EUCAKEY_CRED_SETUP.length()) {
                return;
            }
            String[] firstLine = userData.substring(0, i).split(":");
            if (firstLine.length != 2) {
                LOG.error((Object)"Invalid credentials format");
                return;
            }
            this.key = firstLine[0];
            this.expirationDays = firstLine[1];
            this.payload = userData.substring(i + 1);
            this.userData = userData;
        }

        public String toString() {
            return this.userData;
        }

        public String getPayload() {
            return this.payload;
        }

        public String getKey() {
            return this.key;
        }

        public String getExpirationDays() {
            return this.expirationDays;
        }

        public static boolean apply(String userData) {
            if (userData == null || userData.length() < EUCAKEY_CRED_SETUP.length()) {
                return false;
            }
            return userData.startsWith(EUCAKEY_CRED_SETUP);
        }
    }

    public static enum Timeout implements Predicate<VmInstance>
    {
        EXPIRED(new VmInstance.VmState[]{VmInstance.VmState.RUNNING}){

            @Override
            public Integer getMinutes() {
                return 0;
            }

            @Override
            public boolean apply(VmInstance arg0) {
                return VmInstance.VmState.RUNNING.apply(arg0) && System.currentTimeMillis() > arg0.getExpiration().getTime();
            }
        }
        ,
        UNTOUCHED(new VmInstance.VmState[]{VmInstance.VmState.PENDING, VmInstance.VmState.RUNNING}){

            @Override
            public Integer getMinutes() {
                return INSTANCE_TOUCH_INTERVAL;
            }
        }
        ,
        UNREPORTED(new VmInstance.VmState[]{VmInstance.VmState.PENDING, VmInstance.VmState.RUNNING}){

            @Override
            public Integer getMinutes() {
                return (int)TimeUnit.MINUTES.convert(Intervals.parse((String)INSTANCE_TIMEOUT, (TimeUnit)TimeUnit.MINUTES, (long)TimeUnit.DAYS.toMillis(180L)), TimeUnit.MILLISECONDS);
            }
        }
        ,
        SHUTTING_DOWN(new VmInstance.VmState[]{VmInstance.VmState.SHUTTING_DOWN}){

            @Override
            public Integer getMinutes() {
                return SHUT_DOWN_TIME;
            }
        }
        ,
        STOPPING(new VmInstance.VmState[]{VmInstance.VmState.STOPPING}){

            @Override
            public Integer getMinutes() {
                return STOPPING_TIME;
            }
        }
        ,
        TERMINATED(new VmInstance.VmState[]{VmInstance.VmState.TERMINATED}){

            @Override
            public Integer getMinutes() {
                return TERMINATED_TIME;
            }
        }
        ,
        BURIED(new VmInstance.VmState[]{VmInstance.VmState.BURIED}){

            @Override
            public Integer getMinutes() {
                return BURIED_TIME;
            }
        };

        private final List<VmInstance.VmState> states;

        private Timeout(VmInstance.VmState ... states) {
            this.states = Arrays.asList(states);
        }

        public abstract Integer getMinutes();

        public Integer getSeconds() {
            return this.getMinutes() * 60;
        }

        public Long getMilliseconds() {
            return (long)this.getSeconds().intValue() * 1000L;
        }

        public boolean apply(VmInstance arg0) {
            return this.inState((VmInstance.VmState)arg0.getState()) && arg0.getSplitTime() > this.getMilliseconds();
        }

        protected boolean inState(VmInstance.VmState state) {
            return this.states.contains((Object)state);
        }
    }

    public static class TerminatedInstanceException
    extends NoSuchElementException {
        private static final long serialVersionUID = 1L;

        TerminatedInstanceException(String s) {
            super(s);
        }
    }
}

