/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.vm.VmInstance;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_tags_instances")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="instance")
public class VmInstanceTag
extends Tag<VmInstanceTag> {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="metadata_tag_resource_id", updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private VmInstance instance;

    protected VmInstanceTag() {
        super("instance", ResourceIdFunction.INSTANCE);
    }

    public VmInstanceTag(@Nonnull VmInstance instance, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        super("instance", ResourceIdFunction.INSTANCE, ownerFullName, key, value);
        this.setInstance(instance);
        this.init();
    }

    public VmInstance getInstance() {
        return this.instance;
    }

    public void setInstance(VmInstance instance) {
        this.instance = instance;
    }

    @Nonnull
    public static Tag named(@Nonnull VmInstance instance, @Nonnull OwnerFullName ownerFullName, @Nullable String key) {
        return VmInstanceTag.namedWithValue(instance, ownerFullName, key, null);
    }

    @Nonnull
    public static Tag namedWithValue(@Nonnull VmInstance instance, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)((Object)instance), (Object)"instance");
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new VmInstanceTag(instance, ownerFullName, key, value);
    }

    public static final class VmInstanceTagSupport
    extends TagSupport {
        public VmInstanceTagSupport() {
            super(VmInstance.class, "i", "displayName", "instance", "InvalidInstanceID.NotFound", "The instance ID '%s' does not exist");
        }

        @Override
        public Tag createOrUpdate(CloudMetadata metadata, OwnerFullName ownerFullName, String key, String value) {
            return Tags.createOrUpdate(new VmInstanceTag((VmInstance)metadata, ownerFullName, key, value));
        }

        @Override
        public Tag example(@Nonnull CloudMetadata metadata, @Nonnull OwnerFullName ownerFullName, String key, String value) {
            return VmInstanceTag.namedWithValue((VmInstance)metadata, ownerFullName, key, value);
        }

        @Override
        public Tag example(@Nonnull OwnerFullName ownerFullName) {
            return this.example(new VmInstanceTag(), ownerFullName);
        }

        @Override
        public CloudMetadata lookup(String identifier) throws TransactionException {
            return (CloudMetadata)Entities.uniqueResult((Object)((Object)VmInstance.named(identifier)));
        }
    }

    private static enum ResourceIdFunction implements Function<VmInstanceTag, String>
    {
        INSTANCE{

            public String apply(VmInstanceTag vmInstanceTag) {
                return vmInstanceTag.getInstance().getInstanceId();
            }
        };

    }
}

