/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.ern.Ern;
import com.eucalyptus.auth.policy.ern.EuareResourceName;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.InstanceProfile;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.blockstorage.State;
import com.eucalyptus.blockstorage.Volume;
import com.eucalyptus.blockstorage.Volumes;
import com.eucalyptus.cloud.ResourceToken;
import com.eucalyptus.cloud.VmInstanceLifecycleHelpers;
import com.eucalyptus.cloud.run.AdmissionControl;
import com.eucalyptus.cloud.run.Allocations;
import com.eucalyptus.cloud.util.MetadataException;
import com.eucalyptus.cloud.util.NoSuchImageIdException;
import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.cloud.util.ResourceAllocationException;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.component.id.Dns;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.component.id.Tokens;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.GroupItemType;
import com.eucalyptus.compute.common.GroupSetType;
import com.eucalyptus.compute.common.IamInstanceProfile;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.InstanceBlockDeviceMapping;
import com.eucalyptus.compute.common.InstanceNetworkInterfaceAssociationType;
import com.eucalyptus.compute.common.InstanceNetworkInterfaceAttachmentType;
import com.eucalyptus.compute.common.InstanceNetworkInterfaceSetItemType;
import com.eucalyptus.compute.common.InstanceNetworkInterfaceSetType;
import com.eucalyptus.compute.common.InstancePrivateIpAddressesSetItemType;
import com.eucalyptus.compute.common.InstancePrivateIpAddressesSetType;
import com.eucalyptus.compute.common.InstanceStateType;
import com.eucalyptus.compute.common.InstanceStatusDetailsSetItemType;
import com.eucalyptus.compute.common.InstanceStatusDetailsSetType;
import com.eucalyptus.compute.common.InstanceStatusEventType;
import com.eucalyptus.compute.common.InstanceStatusEventsSetType;
import com.eucalyptus.compute.common.InstanceStatusItemType;
import com.eucalyptus.compute.common.InstanceStatusType;
import com.eucalyptus.compute.common.ReservationInfoType;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.network.Networking;
import com.eucalyptus.compute.common.network.NetworkingFeature;
import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.compute.vpc.Subnet;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.util.Timestamps;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionExecutionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.TransientEntityException;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.images.BlockStorageImageInfo;
import com.eucalyptus.images.Emis;
import com.eucalyptus.images.ImageManager;
import com.eucalyptus.images.MachineImageInfo;
import com.eucalyptus.keys.KeyPairs;
import com.eucalyptus.keys.SshKeyPair;
import com.eucalyptus.network.EdgeNetworking;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.network.PrivateNetworkIndex;
import com.eucalyptus.records.Logs;
import com.eucalyptus.reporting.event.InstanceCreationEvent;
import com.eucalyptus.tokens.AssumeRoleResponseType;
import com.eucalyptus.tokens.AssumeRoleType;
import com.eucalyptus.tokens.CredentialsType;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.HasNaturalId;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Pair;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.dns.DomainNames;
import com.eucalyptus.vm.NetworkGroupId;
import com.eucalyptus.vm.VmBootRecord;
import com.eucalyptus.vm.VmBundleTask;
import com.eucalyptus.vm.VmEphemeralAttachment;
import com.eucalyptus.vm.VmId;
import com.eucalyptus.vm.VmInstanceTag;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmLaunchRecord;
import com.eucalyptus.vm.VmMigrationTask;
import com.eucalyptus.vm.VmNetworkConfig;
import com.eucalyptus.vm.VmPlacement;
import com.eucalyptus.vm.VmRuntimeState;
import com.eucalyptus.vm.VmUsageStats;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.eucalyptus.vm.VmVolumeState;
import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import com.eucalyptus.ws.StackConfiguration;
import com.google.common.base.CaseFormat;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import edu.ucsb.eucalyptus.cloud.VirtualBootRecord;
import edu.ucsb.eucalyptus.cloud.VmInfo;
import edu.ucsb.eucalyptus.msgs.AttachedVolume;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_instances")
@org.hibernate.annotations.Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class VmInstance
extends UserMetadata<VmState>
implements CloudMetadata.VmInstanceMetadata {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(VmInstance.class);
    private static final Cache<MetadataKey, ImmutableMap<String, String>> metadataCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
    public static final String DEFAULT_TYPE = "m1.small";
    public static final String ROOT_DEVICE_TYPE_EBS = "ebs";
    public static final String ROOT_DEVICE_TYPE_INSTANCE_STORE = "instance-store";
    public static final String ID_PREFIX = "i";
    @Embedded
    private VmNetworkConfig networkConfig;
    @Embedded
    private final VmId vmId;
    @Embedded
    private VmBootRecord bootRecord;
    @Embedded
    private final VmUsageStats usageStats;
    @Embedded
    private final VmLaunchRecord launchRecord;
    @Embedded
    private VmRuntimeState runtimeState;
    @Embedded
    private VmVolumeState transientVolumeState;
    @Embedded
    private final VmPlacement placement;
    @Column(name="metadata_vm_expiration")
    private final Date expiration;
    @Column(name="metadata_vm_private_networking")
    private final Boolean privateNetwork;
    @NotFound(action=NotFoundAction.IGNORE)
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @org.hibernate.annotations.Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<NetworkGroup> networkGroups = Sets.newHashSet();
    @ElementCollection
    @CollectionTable(name="metadata_vm_instance_groups")
    @JoinColumn(name="metadata_vm_instance_id")
    @org.hibernate.annotations.Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<NetworkGroupId> networkGroupIds = Sets.newHashSet();
    @NotFound(action=NotFoundAction.IGNORE)
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, optional=true)
    @JoinColumn(name="metadata_vm_network_index", nullable=true, insertable=true, updatable=true)
    @org.hibernate.annotations.Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private PrivateNetworkIndex networkIndex;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="instance")
    private Collection<VmInstanceTag> tags;

    @PreRemove
    private void cleanUp() {
        LOG.debug((Object)("Running cleanup for instance " + this.getDisplayName()));
        VmInstanceLifecycleHelpers.get().cleanUpInstance(this, VmState.BURIED);
    }

    private VmInstance(OwnerFullName owner, VmId vmId, VmBootRecord bootRecord, VmLaunchRecord launchRecord, VmPlacement placement, List<NetworkGroup> networkRulesGroups, Optional<PrivateNetworkIndex> networkIndex, Boolean usePrivateAddressing, Date expiration) throws ResourceAllocationException {
        super(owner, vmId.getInstanceId());
        this.setState(VmState.PENDING);
        this.vmId = vmId;
        this.expiration = expiration;
        this.bootRecord = bootRecord;
        this.launchRecord = launchRecord;
        this.placement = placement;
        this.privateNetwork = Boolean.FALSE;
        this.usageStats = new VmUsageStats(this);
        this.runtimeState = new VmRuntimeState(this);
        this.transientVolumeState = new VmVolumeState(this);
        this.networkConfig = new VmNetworkConfig(this, usePrivateAddressing);
        Function func = Entities.merge();
        this.networkGroups.addAll(Collections2.transform(networkRulesGroups, (Function)func));
        this.networkIndex = networkIndex.isPresent() ? (PrivateNetworkIndex)Entities.merge((Object)((PrivateNetworkIndex)networkIndex.get()).set((HasNaturalId)this)) : null;
        this.store();
    }

    private VmInstance(OwnerFullName owner, VmId vmId) {
        super(owner, null);
        this.vmId = vmId;
        this.expiration = null;
        this.runtimeState = null;
        this.bootRecord = null;
        this.launchRecord = null;
        this.placement = null;
        this.privateNetwork = null;
        this.usageStats = null;
        this.networkConfig = null;
        this.transientVolumeState = null;
    }

    protected VmInstance(OwnerFullName ownerFullName, String instanceId2) {
        super(ownerFullName, instanceId2);
        this.expiration = null;
        this.runtimeState = null;
        this.vmId = null;
        this.bootRecord = null;
        this.launchRecord = null;
        this.placement = null;
        this.privateNetwork = null;
        this.usageStats = null;
        this.networkConfig = null;
        this.transientVolumeState = null;
    }

    protected VmInstance() {
        this.expiration = null;
        this.vmId = null;
        this.bootRecord = null;
        this.launchRecord = null;
        this.placement = null;
        this.privateNetwork = null;
        this.networkIndex = null;
        this.usageStats = null;
        this.runtimeState = null;
        this.networkConfig = null;
        this.transientVolumeState = null;
    }

    public void clearReferences() {
        if (this.bootRecord.getArchitecture() == null) {
            this.bootRecord.setArchitecture(this.bootRecord.getMachine().getArchitecture());
        }
        this.bootRecord.setMachine();
        this.bootRecord.setKernel();
        this.bootRecord.setRamdisk();
        this.bootRecord.setVpc(null);
        this.bootRecord.setSubnet(null);
        this.clearRunReferences();
    }

    public void clearRunReferences() {
        this.runtimeState.clearServiceTag();
    }

    public void clearPublicAddress() {
        this.updatePublicAddress(null);
    }

    public void updateAddresses(String privateAddr, String publicAddr) {
        this.updatePrivateAddress(privateAddr);
        this.updatePublicAddress(publicAddr);
    }

    public void updatePublicAddress(String publicAddr) {
        String ip = VmNetworkConfig.ipOrDefault(publicAddr);
        this.getNetworkConfig().setPublicAddress(ip);
        this.getNetworkConfig().setPublicDnsName(this.dnsHostnamesEnabled() ? VmNetworkConfig.generateDnsName(ip, DomainNames.externalSubdomain()) : "");
    }

    public void updatePrivateAddress(String privateAddr) {
        String ip = VmNetworkConfig.ipOrDefault(privateAddr);
        this.getNetworkConfig().setPrivateAddress(ip);
        this.getNetworkConfig().setPrivateDnsName(VmNetworkConfig.generateDnsName(ip, DomainNames.internalSubdomain()));
    }

    public void updateMacAddress(String macAddress) {
        if (this.getMacAddress() == null) {
            this.getNetworkConfig().setMacAddress(macAddress);
        }
    }

    public VmRuntimeState getRuntimeState() {
        if (this.runtimeState == null) {
            this.runtimeState = new VmRuntimeState(this);
        }
        return this.runtimeState;
    }

    private void setRuntimeState(VmState state) {
        this.setState(state, Reason.NORMAL, new String[0]);
    }

    private boolean dnsHostnamesEnabled() {
        Vpc vpc = this.getBootRecord().getVpc();
        return vpc == null || (Boolean)Objects.firstNonNull((Object)vpc.getDnsHostnames(), (Object)Boolean.FALSE) != false;
    }

    void store() {
        this.updateTimeStamps();
        this.firePersist();
        this.fireUsageEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePersist() {
        EntityTransaction db = Entities.get(VmInstance.class);
        try {
            if (Entities.isPersistent((Object)((Object)this))) {
                try {
                    Entities.merge((Object)((Object)this));
                    db.commit();
                }
                catch (Exception ex) {
                    LOG.debug((Object)ex);
                }
            }
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    private void fireUsageEvent() {
        if (VmState.RUNNING.equals(this.getState())) {
            try {
                OwnerFullName owner = this.getOwner();
                String userId = owner.getUserId();
                String accountId = owner.getAccountNumber();
                ListenerRegistry.getInstance().fireEvent((Event)new InstanceCreationEvent(this.getInstanceUuid(), this.getDisplayName(), this.bootRecord.getVmType().getName(), userId, Accounts.lookupUserById((String)userId).getName(), accountId, Accounts.lookupAccountById((String)accountId).getName(), this.placement.getPartitionName()));
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    public String getByKey(String pathArg) {
        String path = (String)Objects.firstNonNull((Object)pathArg, (Object)"");
        LOG.debug((Object)("Servicing metadata request:" + path));
        String pathNoSlash = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        Optional groupOption = Optional.absent();
        for (MetadataGroup metadataGroup : MetadataGroup.values()) {
            if (!metadataGroup.providesPath(pathNoSlash) && !metadataGroup.providesPath(path)) continue;
            groupOption = Optional.of((Object)((Object)metadataGroup));
        }
        MetadataGroup group = (MetadataGroup)((Object)groupOption.or((Object)MetadataGroup.Core));
        Map metadataMap = (Map)Optional.fromNullable((Object)group.apply((Object)this)).or(Collections.emptyMap());
        String value = (String)metadataMap.get(path);
        return value == null ? (String)metadataMap.get(pathNoSlash) : value;
    }

    private Map<String, String> getCoreMetadataMap() {
        boolean dns = StackConfiguration.USE_INSTANCE_DNS != false && !((Dns)ComponentIds.lookup(Dns.class)).runLimitedServices();
        HashMap m = Maps.newHashMap();
        m.put("ami-id", this.getImageId());
        if (this.bootRecord.getMachine() != null && !this.bootRecord.getMachine().getProductCodes().isEmpty()) {
            m.put("product-codes", Joiner.on((char)'\n').join(this.bootRecord.getMachine().getProductCodes()));
        }
        m.put("ami-launch-index", "" + this.launchRecord.getLaunchIndex());
        if (this.bootRecord.getMachine() instanceof MachineImageInfo) {
            m.put("ami-manifest-path", ((MachineImageInfo)this.bootRecord.getMachine()).getManifestLocation());
        }
        if (dns) {
            m.put("hostname", this.getNetworkConfig().getPrivateDnsName());
        } else {
            m.put("hostname", this.getNetworkConfig().getPrivateAddress());
        }
        m.put("instance-id", this.getInstanceId());
        m.put("instance-type", this.getVmType().getName());
        if (dns) {
            m.put("local-hostname", this.getNetworkConfig().getPrivateDnsName());
        } else {
            m.put("local-hostname", this.getNetworkConfig().getPrivateAddress());
        }
        m.put("local-ipv4", this.getNetworkConfig().getPrivateAddress());
        m.put("mac", com.eucalyptus.util.Strings.upper().apply((Object)this.getNetworkConfig().getMacAddress()));
        if (dns) {
            m.put("public-hostname", this.getNetworkConfig().getPublicDnsName());
        } else {
            m.put("public-hostname", this.getPublicAddress());
        }
        m.put("public-ipv4", this.getPublicAddress());
        m.put("reservation-id", this.vmId.getReservationId());
        if (this.getKernelId() != null) {
            m.put("kernel-id", this.getKernelId());
        }
        if (this.getRamdiskId() != null) {
            m.put("ramdisk-id", this.getRamdiskId());
        }
        m.put("security-groups", Joiner.on((char)'\n').join((Iterable)Sets.newTreeSet((Iterable)Iterables.transform(this.getNetworkGroups(), (Function)CloudMetadatas.toDisplayName()))));
        m.put("placement/availability-zone", this.getPartition());
        return m;
    }

    private Map<String, String> getBlockDeviceMappingMetadataMap() {
        HashMap m = Maps.newHashMap();
        if (this.bootRecord.getMachine() instanceof BlockStorageImageInfo) {
            TreeSet<VmVolumeAttachment> volAttachments = new TreeSet<VmVolumeAttachment>(VolumeAttachmentComparator.INSTANCE);
            volAttachments.addAll(this.bootRecord.getPersistentVolumes());
            int ebsCount = 0;
            for (VmVolumeAttachment attachment : volAttachments) {
                if (attachment.getIsRootDevice().booleanValue()) {
                    m.put("block-device-mapping/ami", attachment.getShortDeviceName());
                    m.put("block-device-mapping/emi", attachment.getShortDeviceName());
                    m.put("block-device-mapping/root", attachment.getDevice());
                }
                if (!attachment.getAttachedAtStartup().booleanValue() || attachment.getIsRootDevice().booleanValue()) continue;
                m.put("block-device-mapping/ebs" + String.valueOf(++ebsCount), attachment.getShortDeviceName());
            }
            TreeSet<VmEphemeralAttachment> ephemeralAttachments = new TreeSet<VmEphemeralAttachment>(this.bootRecord.getEphemeralStorage());
            if (!ephemeralAttachments.isEmpty()) {
                for (VmEphemeralAttachment attachment : ephemeralAttachments) {
                    m.put("block-device-mapping/" + attachment.getEphemeralId(), attachment.getShortDeviceName());
                }
            }
        } else if (this.bootRecord.getMachine() instanceof MachineImageInfo) {
            MachineImageInfo mii = (MachineImageInfo)this.bootRecord.getMachine();
            String s = mii.getRootDeviceName();
            m.put("block-device-mapping/emi", mii.getShortRootDeviceName());
            m.put("block-device-mapping/ami", mii.getShortRootDeviceName());
            m.put("block-device-mapping/root", s);
            if (ImageManager.isPathAPartition(s)) {
                m.put("block-device-mapping/ephemeral0", "sda2");
                m.put("block-device-mapping/swap", "sda3");
            } else {
                m.put("block-device-mapping/ephemeral0", "sdb");
            }
        }
        return m;
    }

    private Map<String, String> getIamMetadataMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        String instanceProfileNameOrArn = this.getIamInstanceProfileArn();
        if (instanceProfileNameOrArn != null && !instanceProfileNameOrArn.isEmpty()) {
            InstanceProfile profile = null;
            String roleName = null;
            String roleArn = this.getIamRoleArn();
            String profileArn = this.getIamInstanceProfileArn();
            try {
                Account userAccount = Accounts.lookupAccountById((String)this.getOwnerAccountNumber());
                String profileName = instanceProfileNameOrArn.startsWith("arn:") ? instanceProfileNameOrArn.substring(instanceProfileNameOrArn.lastIndexOf(47) + 1) : instanceProfileNameOrArn;
                profile = userAccount.lookupInstanceProfileByName(profileName);
                profileArn = Accounts.getInstanceProfileArn((InstanceProfile)profile);
                if (roleArn == null) {
                    Role role = profile.getRole();
                    if (role != null) {
                        roleArn = Accounts.getRoleArn((Role)role);
                        roleName = role.getName();
                    }
                } else {
                    EuareResourceName ern = (EuareResourceName)Ern.parse((String)roleArn);
                    roleName = ern.getName();
                }
            }
            catch (AuthException e) {
                LOG.debug((Object)e);
            }
            CredentialsType credentials = null;
            if (roleArn != null) {
                AssumeRoleType assumeRoleType = new AssumeRoleType();
                assumeRoleType.setRoleArn(roleArn);
                assumeRoleType.setRoleSessionName(Crypto.generateId((String)this.getOwner().getUserId()));
                ServiceConfiguration serviceConfiguration = Topology.lookup(Tokens.class, (Partition[])new Partition[0]);
                try {
                    credentials = ((AssumeRoleResponseType)AsyncRequests.sendSync((ServiceConfiguration)serviceConfiguration, (BaseMessage)assumeRoleType)).getAssumeRoleResult().getCredentials();
                }
                catch (Exception e) {
                    LOG.debug((Object)"Unable to send assume role request to token service", (Throwable)e);
                }
            }
            if (profile != null) {
                m.put("iam/info/last-updated-date", Timestamps.formatIso8601Timestamp((Date)profile.getCreationTimestamp()));
                m.put("iam/info/instance-profile-arn", profileArn);
                m.put("iam/info/instance-profile-id", profile.getInstanceProfileId());
            }
            if (roleName != null && credentials != null) {
                String jsonCredentials = new JSONObject().element("Code", (Object)"Success").element("LastUpdated", (Object)Timestamps.formatIso8601Timestamp((Date)new Date())).element("Type", (Object)"AWS-HMAC").element("AccessKeyId", (Object)credentials.getAccessKeyId()).element("SecretAccessKey", (Object)credentials.getSecretAccessKey()).element("Token", (Object)credentials.getSessionToken()).element("Expiration", (Object)Timestamps.formatIso8601Timestamp((Date)credentials.getExpiration())).toString(2);
                m.put("iam/security-credentials/" + roleName + "/AccessKeyId", credentials.getAccessKeyId());
                m.put("iam/security-credentials/" + roleName + "/Expiration", Timestamps.formatIso8601Timestamp((Date)credentials.getExpiration()));
                m.put("iam/security-credentials/" + roleName + "/SecretAccessKey", credentials.getSecretAccessKey());
                m.put("iam/security-credentials/" + roleName + "/Token", credentials.getSessionToken());
                m.put("iam/security-credentials/" + roleName, jsonCredentials);
                m.put("iam/security-credentials", roleName);
                m.put("iam/security-credentials/", roleName);
            }
        }
        return m;
    }

    private Map<String, String> getPublicKeysMetadataMap() {
        HashMap m = Maps.newHashMap();
        if (this.bootRecord.getSshKeyPair() != null) {
            m.put("public-keys", "0=" + this.bootRecord.getSshKeyPair().getName());
            m.put("public-keys/", "0=" + this.bootRecord.getSshKeyPair().getName());
            m.put("public-keys/0/openssh-key", this.bootRecord.getSshKeyPair().getPublicKey());
        }
        return m;
    }

    public synchronized long getSplitTime() {
        long time = System.currentTimeMillis();
        long split = time - super.getLastUpdateTimestamp().getTime();
        return split;
    }

    public synchronized long getCreationSplitTime() {
        long time = System.currentTimeMillis();
        long split = time - super.getCreationTimestamp().getTime();
        return split;
    }

    public VmBundleTask resetBundleTask() {
        return this.getRuntimeState().resetBundleTask();
    }

    public String getImageId() {
        return this.bootRecord.getDisplayMachineImageId();
    }

    @Nullable
    public String getRamdiskId() {
        return this.bootRecord.getDisplayRamdiskImageId();
    }

    @Nullable
    public String getKernelId() {
        return this.bootRecord.getDisplayKernelImageId();
    }

    public boolean hasPublicAddress() {
        return this.networkConfig != null && !VmNetworkConfig.DEFAULT_IP.equals(this.getNetworkConfig().getPublicAddress()) && !this.getNetworkConfig().getPrivateAddress().equals(this.getNetworkConfig().getPublicAddress());
    }

    public String getInstanceId() {
        return super.getDisplayName();
    }

    public VmType getVmType() {
        return this.bootRecord.getVmType();
    }

    public boolean isUsePrivateAddressing() {
        return Boolean.TRUE.equals(this.getNetworkConfig().getUsePrivateAddressing());
    }

    public String getPrivateAddress() {
        return this.getNetworkConfig().getPrivateAddress();
    }

    public String getPublicAddress() {
        return this.getNetworkConfig().getPublicAddress();
    }

    public String getPrivateDnsName() {
        return this.getNetworkConfig().getPrivateDnsName();
    }

    public String getPublicDnsName() {
        return this.getNetworkConfig().getPublicDnsName();
    }

    public String getMacAddress() {
        return this.getNetworkConfig().getMacAddress();
    }

    public List<NetworkInterface> getNetworkInterfaces() {
        return this.getNetworkConfig().getNetworkInterfaces();
    }

    public String getPasswordData() {
        return this.getRuntimeState().getPasswordData();
    }

    public void updatePasswordData(String passwordData) {
        this.getRuntimeState().setPasswordData(passwordData);
    }

    public String getPlatform() {
        return this.bootRecord.getPlatform().toString();
    }

    public String getDisplayPlatform() {
        return ImageMetadata.Platform.windows == this.bootRecord.getPlatform() ? ImageMetadata.Platform.windows.name() : "";
    }

    @Nullable
    public String getSubnetId() {
        return this.bootRecord.getSubnetId();
    }

    @Nullable
    public String getVpcId() {
        return this.bootRecord.getVpcId();
    }

    public String getPartition() {
        return this.placement.getPartitionName();
    }

    public String getInstanceUuid() {
        return this.getNaturalId();
    }

    public static VmInstance named(String instanceId) {
        return new VmInstance(null, instanceId);
    }

    public static VmInstance named(OwnerFullName ownerFullName, String instanceId) {
        return new VmInstance(ownerFullName, instanceId);
    }

    public static VmInstance withToken(OwnerFullName ownerFullName, String clientToken) {
        return new VmInstance(ownerFullName, new VmId(null, null, clientToken, null));
    }

    public static VmInstance withUuid(String uuid) {
        VmInstance example = new VmInstance();
        example.setNaturalId(uuid);
        return example;
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"instance", this.getDisplayName()});
    }

    public PrivateNetworkIndex getNetworkIndex() {
        return this.networkIndex;
    }

    private Boolean getPrivateNetwork() {
        return this.privateNetwork;
    }

    public Collection<VmInstanceTag> getTags() {
        return this.tags;
    }

    public Set<NetworkGroup> getNetworkGroups() {
        return this.networkGroups != null ? this.networkGroups : Sets.newHashSet();
    }

    public Set<NetworkGroupId> getNetworkGroupIds() {
        this.updateGroups();
        return this.networkGroupIds;
    }

    static long getSerialversionuid() {
        return 1L;
    }

    static Logger getLOG() {
        return LOG;
    }

    static String getDEFAULT_IP() {
        return VmNetworkConfig.DEFAULT_IP;
    }

    static String getDEFAULT_TYPE() {
        return DEFAULT_TYPE;
    }

    VmId getVmId() {
        return this.vmId;
    }

    public VmBootRecord getBootRecord() {
        return this.bootRecord;
    }

    VmUsageStats getUsageStats() {
        return this.usageStats;
    }

    VmLaunchRecord getLaunchRecord() {
        return this.launchRecord;
    }

    VmPlacement getPlacement() {
        return this.placement;
    }

    public Partition lookupPartition() {
        return this.placement.lookupPartition();
    }

    public void setState(VmState newState, Reason reason, String ... extra) {
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            VmInstance entity = (VmInstance)((Object)Entities.merge((Object)((Object)this)));
            entity.runtimeState.setState(newState, reason, extra);
            db.commit();
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public VmVolumeAttachment lookupVolumeAttachmentByDevice(String volumeDevice) {
        EntityTransaction db = Entities.get(VmInstance.class);
        try {
            VmVolumeAttachment ret;
            VmInstance entity = (VmInstance)((Object)Entities.merge((Object)((Object)this)));
            try {
                ret = entity.getTransientVolumeState().lookupVolumeAttachmentByDevice(volumeDevice);
            }
            catch (Exception ex) {
                ret = (VmVolumeAttachment)Iterables.find(entity.getBootRecord().getPersistentVolumes(), VmVolumeAttachment.volumeDeviceFilter(volumeDevice));
            }
            db.commit();
            VmVolumeAttachment vmVolumeAttachment = ret;
            return vmVolumeAttachment;
        }
        catch (NoSuchElementException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw new NoSuchElementException("Failed to lookup volume with device: " + volumeDevice);
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public VmVolumeAttachment lookupVolumeAttachment(String volumeId) {
        EntityTransaction db = Entities.get(VmInstance.class);
        try {
            VmVolumeAttachment volumeAttachment;
            VmInstance entity = Entities.isPersistent((Object)((Object)this)) ? this : (VmInstance)((Object)Entities.uniqueResult((Object)((Object)this)));
            try {
                volumeAttachment = entity.getTransientVolumeState().lookupVolumeAttachment(volumeId);
            }
            catch (NoSuchElementException ex) {
                volumeAttachment = (VmVolumeAttachment)Iterables.find(entity.getBootRecord().getPersistentVolumes(), VmVolumeAttachment.volumeIdFilter(volumeId));
            }
            db.commit();
            VmVolumeAttachment vmVolumeAttachment = volumeAttachment;
            return vmVolumeAttachment;
        }
        catch (Exception ex) {
            throw new NoSuchElementException("Failed to lookup volume: " + volumeId);
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public void addTransientVolume(final String deviceName, final String remoteDevice, final Volume vol) {
        Function<Volume, Volume> attachmentFunction = new Function<Volume, Volume>(){

            public Volume apply(Volume input) {
                VmInstance entity = (VmInstance)((Object)Entities.merge((Object)((Object)VmInstance.this)));
                Volume volEntity = (Volume)((Object)Entities.merge((Object)((Object)vol)));
                VmVolumeAttachment attachVol = new VmVolumeAttachment(entity, volEntity.getDisplayName(), deviceName, remoteDevice, VmVolumeAttachment.AttachmentState.attaching.name(), new Date(), false, Boolean.FALSE);
                volEntity.setState(State.BUSY);
                entity.getTransientVolumeState().addVolumeAttachment(attachVol);
                return volEntity;
            }
        };
        Entities.asTransaction(VmInstance.class, (Function)attachmentFunction, (int)10).apply((Object)vol);
    }

    public void addPersistentVolume(final String deviceName, final Volume vol, final Boolean isRootDevice) {
        Function<Volume, Volume> attachmentFunction = new Function<Volume, Volume>(){

            public Volume apply(Volume input) {
                VmInstance entity = (VmInstance)((Object)Entities.merge((Object)((Object)VmInstance.this)));
                Volume volEntity = (Volume)((Object)Entities.merge((Object)((Object)vol)));
                VmVolumeAttachment volumeAttachment = new VmVolumeAttachment(entity, vol.getDisplayName(), deviceName, new String(), VmVolumeAttachment.AttachmentState.attached.name(), new Date(), true, isRootDevice, Boolean.TRUE);
                entity.bootRecord.getPersistentVolumes().add(volumeAttachment);
                return volEntity;
            }
        };
        Entities.asTransaction(VmInstance.class, (Function)attachmentFunction, (int)10).apply((Object)vol);
    }

    public void addPermanentVolume(final String deviceName, final Volume vol, final Boolean isRootDevice) {
        Function<Volume, Volume> attachmentFunction = new Function<Volume, Volume>(){

            public Volume apply(Volume input) {
                VmInstance entity = (VmInstance)((Object)Entities.merge((Object)((Object)VmInstance.this)));
                Volume volEntity = (Volume)((Object)Entities.merge((Object)((Object)vol)));
                VmVolumeAttachment volumeAttachment = new VmVolumeAttachment(entity, vol.getDisplayName(), deviceName, new String(), VmVolumeAttachment.AttachmentState.attached.name(), new Date(), false, isRootDevice, Boolean.TRUE);
                entity.bootRecord.getPersistentVolumes().add(volumeAttachment);
                return volEntity;
            }
        };
        Entities.asTransaction(VmInstance.class, (Function)attachmentFunction, (int)10).apply((Object)vol);
    }

    public void updateAttachmentToken(Map<String, String> volumeAttachmentTokenMap) {
        Function<Map<String, String>, String> updateFunction = new Function<Map<String, String>, String>(){

            public String apply(@Nonnull Map<String, String> arg0) {
                VmInstance entity = (VmInstance)((Object)Entities.merge((Object)((Object)VmInstance.this)));
                for (VmVolumeAttachment attachment : entity.getBootRecord().getPersistentVolumes()) {
                    if (arg0.containsKey(attachment.getVolumeId())) {
                        attachment.setRemoteDevice(arg0.get(attachment.getVolumeId()));
                        continue;
                    }
                    LOG.debug((Object)("No attachment token found for " + attachment.getVolumeId() + " and " + entity.getInstanceId()));
                }
                return null;
            }
        };
        if (volumeAttachmentTokenMap != null && !volumeAttachmentTokenMap.isEmpty()) {
            try {
                Entities.asTransaction(VmInstance.class, (Function)updateFunction, (int)10).apply(volumeAttachmentTokenMap);
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to update attachment tokens for run time EBS volumes of " + this.getInstanceId()), (Throwable)e);
            }
        }
    }

    public void addEphemeralAttachment(final String deviceName, final String ephemeralId) {
        Function<String, String> attachmentFunction = new Function<String, String>(){

            public String apply(String input) {
                VmInstance entity = (VmInstance)((Object)Entities.merge((Object)((Object)VmInstance.this)));
                VmEphemeralAttachment ephemeralAttachment = new VmEphemeralAttachment(entity, ephemeralId, deviceName);
                entity.bootRecord.getEphemeralStorage().add(ephemeralAttachment);
                return input;
            }
        };
        Entities.asTransaction(VmInstance.class, (Function)attachmentFunction, (int)10).apply((Object)ephemeralId);
    }

    public boolean eachVolumeAttachment(final Predicate<VmVolumeAttachment> predicate) {
        if (VmStateSet.DONE.contains((VmState)this.getState()) && !VmStateSet.EXPECTING_TEARDOWN.contains((VmState)this.getLastState())) {
            return false;
        }
        EntityTransaction db = Entities.get(VmInstance.class);
        try {
            VmInstance entity = (VmInstance)((Object)Entities.merge((Object)((Object)this)));
            HashSet persistentAttachments = Sets.newHashSet(entity.getBootRecord().getPersistentVolumes());
            boolean ret = Iterables.all((Iterable)persistentAttachments, (Predicate)new Predicate<VmVolumeAttachment>(){

                public boolean apply(VmVolumeAttachment arg0) {
                    return predicate.apply((Object)arg0);
                }
            });
            db.commit();
            return ret |= entity.getTransientVolumeState().eachVolumeAttachment(new Predicate<VmVolumeAttachment>(){

                public boolean apply(VmVolumeAttachment arg0) {
                    return predicate.apply((Object)arg0);
                }
            });
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            db.rollback();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VmVolumeAttachment removeVolumeAttachment(String volumeId) {
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            VmVolumeAttachment ret;
            VmInstance entity = (VmInstance)((Object)Entities.merge((Object)((Object)this)));
            Volume volEntity = Volumes.lookup(null, volumeId);
            try {
                ret = entity.transientVolumeState.removeVolumeAttachment(volumeId);
            }
            catch (NoSuchElementException ex) {
                ret = (VmVolumeAttachment)Iterables.find(entity.getBootRecord().getPersistentVolumes(), VmVolumeAttachment.volumeIdFilter(volumeId));
                entity.getBootRecord().getPersistentVolumes().remove(ret);
            }
            if (State.BUSY.equals(volEntity.getState())) {
                volEntity.setState(State.EXTANT);
            }
            db.commit();
            VmVolumeAttachment vmVolumeAttachment = ret;
            return vmVolumeAttachment;
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw new NoSuchElementException("Failed to lookup volume: " + volumeId);
        }
    }

    public String getServiceTag() {
        return this.getRuntimeState().getServiceTag();
    }

    public String getReservationId() {
        return this.vmId.getReservationId();
    }

    public byte[] getUserData() {
        return this.bootRecord.getUserData();
    }

    public void setUserDataAsString(String userData) {
        if (userData == null || userData.length() <= 0) {
            this.bootRecord.setUserData(new byte[0]);
        } else {
            this.bootRecord.setUserData(userData.getBytes());
        }
    }

    public void updateVolumeAttachment(String volumeId, VmVolumeAttachment.AttachmentState newState) {
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            VmInstance entity = (VmInstance)((Object)Entities.merge((Object)((Object)this)));
            try {
                entity.getTransientVolumeState().updateVolumeAttachment(volumeId, newState);
            }
            catch (NoSuchElementException ex) {
                VmVolumeAttachment ret = (VmVolumeAttachment)Iterables.find(entity.getBootRecord().getPersistentVolumes(), VmVolumeAttachment.volumeIdFilter(volumeId));
                ret.setStatus(newState.name());
            }
            db.commit();
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
    }

    public Predicate<VmInfo> doUpdate() {
        return new Predicate<VmInfo>(){

            public boolean apply(VmInfo runVm) {
                if (!Entities.isPersistent((Object)((Object)VmInstance.this))) {
                    throw new TransientEntityException(this.toString());
                }
                try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
                    VmState runVmState = VmState.Mapper.get(runVm.getStateName());
                    if (VmInstance.this.getRuntimeState().isBundling().booleanValue()) {
                        VmBundleTask.BundleState bundleState = (VmBundleTask.BundleState)((Object)VmBundleTask.BundleState.mapper.apply((Object)runVm.getBundleTaskStateName()));
                        VmInstance.this.getRuntimeState().updateBundleTaskState(bundleState, runVm.getBundleTaskProgress());
                    } else if (VmStateSet.RUN.apply(VmInstance.this) && VmStateSet.RUN.contains(runVmState)) {
                        VmInstance.this.setState(runVmState, Reason.APPEND, "UPDATE");
                        this.updateState(runVm);
                    } else if (VmState.SHUTTING_DOWN.apply(VmInstance.this) && VmState.SHUTTING_DOWN.equals((Object)runVmState)) {
                        VmInstance.this.setState(VmState.TERMINATED, Reason.APPEND, "DONE");
                    } else if (VmInstances.Timeout.SHUTTING_DOWN.apply(VmInstance.this)) {
                        VmInstance.this.setState(VmState.TERMINATED, Reason.EXPIRED, new String[0]);
                    } else if (VmInstances.Timeout.STOPPING.apply(VmInstance.this)) {
                        VmInstance.this.setState(VmState.STOPPED, Reason.EXPIRED, new String[0]);
                    } else if (VmStateSet.NOT_RUNNING.apply(VmInstance.this) && VmStateSet.RUN.contains(runVmState)) {
                        if (VmInstances.Timeout.SHUTTING_DOWN.apply(VmInstance.this)) {
                            VmInstances.terminated(VmInstance.this);
                        } else if (VmInstances.Timeout.STOPPING.apply(VmInstance.this)) {
                            VmInstances.stopped(VmInstance.this);
                        } else if (VmInstance.this.lastUpdateMillis() > VmInstances.VOLATILE_STATE_TIMEOUT_SEC * 1000L) {
                            VmInstances.sendTerminate(VmInstance.this.getInstanceId(), VmInstance.this.getPartition());
                            VmInstance.this.updateTimeStamps();
                        }
                    } else {
                        this.updateState(runVm);
                    }
                    db.commit();
                }
                catch (Exception ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
                return true;
            }

            private void updateState(VmInfo runVm) {
                VmInstance.this.getRuntimeState().updateBundleTaskState(runVm.getBundleTaskStateName());
                VmInstance.this.setServiceTag(runVm.getServiceTag());
                VmInstance.this.getRuntimeState().setGuestState(runVm.getGuestStateName());
                if (!Boolean.TRUE.equals(VmInstance.this.getRuntimeState().getZombie())) {
                    VmInstance.this.updateMacAddress(runVm.getNetParams().getMacAddress());
                    if (VmStateSet.RUN.apply(VmInstance.this)) {
                        if (!VmRuntimeState.InstanceStatus.Ok.apply(VmInstance.this)) {
                            VmInstance.this.getRuntimeState().reachable();
                        }
                        if (!EdgeNetworking.isEnabled()) {
                            VmInstance.this.updateAddresses(runVm.getNetParams().getIpAddress(), runVm.getNetParams().getIgnoredPublicIp());
                        }
                    }
                    if (VmState.RUNNING.apply(VmInstance.this)) {
                        VmInstance.this.updateVolumeAttachments(runVm.getVolumes());
                        VmInstance.this.updateMigrationTaskState(runVm.getMigrationStateName(), Strings.nullToEmpty((String)runVm.getMigrationSource()), Strings.nullToEmpty((String)runVm.getMigrationDestination()));
                    }
                }
                if (VmInstances.Timeout.UNTOUCHED.apply(VmInstance.this)) {
                    VmInstance.this.updateTimeStamps();
                }
            }
        };
    }

    protected void updateMigrationTaskState(String migrationStateName, String migrationSource, String migrationDestination) {
        this.getRuntimeState().setMigrationState(migrationStateName, migrationSource, migrationDestination);
    }

    private void updateVolumeAttachments(List<AttachedVolume> volumes) {
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            VmVolumeAttachment ncVolumeAttachment;
            VmInstance entity = (VmInstance)((Object)Entities.merge((Object)((Object)this)));
            final List ncAttachedVols = Lists.transform(volumes, VmVolumeAttachment.fromAttachedVolume(entity));
            HashSet remoteVolumes = Sets.newHashSet((Iterable)Collections2.transform((Collection)ncAttachedVols, (Function)VmVolumeState.VmVolumeAttachmentName.INSTANCE));
            HashSet localVolumes = Sets.newHashSet((Iterable)Collections2.transform(entity.getTransientVolumeState().getAttachments(), (Function)VmVolumeState.VmVolumeAttachmentName.INSTANCE));
            localVolumes.addAll(Collections2.transform(entity.getBootRecord().getPersistentVolumes(), (Function)VmVolumeState.VmVolumeAttachmentName.INSTANCE));
            Sets.SetView intersection = Sets.intersection((Set)remoteVolumes, (Set)localVolumes);
            Sets.SetView remoteOnly = Sets.difference((Set)remoteVolumes, (Set)localVolumes);
            Sets.SetView localOnly = Sets.difference((Set)localVolumes, (Set)remoteVolumes);
            if (!(intersection.isEmpty() && remoteOnly.isEmpty() && localOnly.isEmpty())) {
                LOG.debug((Object)("Updating volume attachments for: " + entity.getInstanceId() + " intersection=" + intersection + " local=" + localOnly + " remote=" + remoteOnly));
                LOG.debug((Object)("Reported state for: " + entity.getInstanceId() + Collections2.transform((Collection)ncAttachedVols, (Function)VmVolumeState.VmVolumeAttachmentStateInfo.INSTANCE)));
            }
            HashMap<String, VmVolumeAttachment> ncAttachedVolMap = new HashMap<String, VmVolumeAttachment>(){
                {
                    for (VmVolumeAttachment v : ncAttachedVols) {
                        this.put(v.getVolumeId(), v);
                    }
                }
            };
            for (String volId : intersection) {
                try {
                    ncVolumeAttachment = (VmVolumeAttachment)ncAttachedVolMap.get(volId);
                    VmVolumeAttachment localVolumeAttachment = this.lookupVolumeAttachment(volId);
                    VmVolumeAttachment.AttachmentState localState = localVolumeAttachment.getAttachmentState();
                    VmVolumeAttachment.AttachmentState remoteState = VmVolumeAttachment.AttachmentState.parse(ncVolumeAttachment.getStatus());
                    if (!localState.isVolatile()) {
                        if (VmVolumeAttachment.AttachmentState.detached.equals((Object)remoteState)) {
                            this.removeVolumeAttachment(volId);
                            continue;
                        }
                        if (VmVolumeAttachment.AttachmentState.attaching_failed.equals((Object)remoteState)) {
                            this.removeVolumeAttachment(volId);
                            continue;
                        }
                        if (VmVolumeAttachment.AttachmentState.detaching_failed.equals((Object)remoteState) && !VmVolumeAttachment.AttachmentState.attached.equals((Object)localState)) {
                            this.updateVolumeAttachment(volId, VmVolumeAttachment.AttachmentState.attached);
                            continue;
                        }
                        if (!VmVolumeAttachment.AttachmentState.attached.equals((Object)remoteState) || VmVolumeAttachment.AttachmentState.attached.equals((Object)localState)) continue;
                        this.updateVolumeAttachment(volId, VmVolumeAttachment.AttachmentState.attached);
                        continue;
                    }
                    if (VmVolumeAttachment.AttachmentState.detaching.equals((Object)localState) && VmVolumeAttachment.AttachmentState.detached.equals((Object)remoteState)) {
                        this.removeVolumeAttachment(volId);
                        continue;
                    }
                    if (VmVolumeAttachment.AttachmentState.attaching.equals((Object)localState) && VmVolumeAttachment.AttachmentState.attached.equals((Object)remoteState)) {
                        this.updateVolumeAttachment(volId, VmVolumeAttachment.AttachmentState.attached);
                        continue;
                    }
                    if (VmVolumeAttachment.AttachmentState.attaching.equals((Object)localState) && VmVolumeAttachment.AttachmentState.attaching_failed.equals((Object)remoteState)) {
                        this.removeVolumeAttachment(volId);
                        continue;
                    }
                    if (!VmVolumeAttachment.AttachmentState.detaching.equals((Object)localState) || !VmVolumeAttachment.AttachmentState.detaching_failed.equals((Object)remoteState)) continue;
                    this.updateVolumeAttachment(volId, VmVolumeAttachment.AttachmentState.attached);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            }
            for (String volId : remoteOnly) {
                try {
                    Volumes.lookup(null, volId);
                }
                catch (NoSuchElementException e) {
                    LOG.error((Object)("Invalid volume id " + volId + " passed from back-end"));
                    continue;
                }
                try {
                    ncVolumeAttachment = (VmVolumeAttachment)ncAttachedVolMap.get(volId);
                    VmVolumeAttachment.AttachmentState remoteState = VmVolumeAttachment.AttachmentState.parse(ncVolumeAttachment.getStatus());
                    if (!VmVolumeAttachment.AttachmentState.attached.equals((Object)remoteState) && !VmVolumeAttachment.AttachmentState.detaching_failed.equals((Object)remoteState)) continue;
                    LOG.warn((Object)("Restoring volume attachment state for " + entity.getInstanceId() + " with " + ncVolumeAttachment.toString()));
                    entity.getTransientVolumeState().addVolumeAttachment(ncVolumeAttachment);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            }
            for (String volId : localOnly) {
                try {
                    VmVolumeAttachment.AttachmentState localState = this.lookupVolumeAttachment(volId).getAttachmentState();
                    if (localState.isVolatile()) continue;
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            }
            db.commit();
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
    }

    public void setServiceTag(String serviceTag) {
        this.getRuntimeState().setServiceTag(serviceTag);
    }

    public void setNetworkIndex(PrivateNetworkIndex networkIndex) {
        this.networkIndex = networkIndex;
    }

    VmState getDisplayState() {
        return ((VmState)this.getState()).getDisplayState();
    }

    @Nonnull
    String getDisplayPublicDnsName() {
        return VmStateSet.TORNDOWN.apply(this) ? "" : (VmInstance.dns() ? this.getPublicDnsName() : this.getDisplayPublicAddress());
    }

    @Nonnull
    String getDisplayPublicAddress() {
        return VmStateSet.TORNDOWN.apply(this) ? "" : (VmNetworkConfig.DEFAULT_IP.equals(Objects.firstNonNull((Object)Strings.emptyToNull((String)this.getPublicAddress()), (Object)VmNetworkConfig.DEFAULT_IP)) ? this.getDisplayPrivateAddress() : this.getPublicAddress());
    }

    @Nonnull
    String getDisplayPrivateDnsName() {
        return VmStateSet.TORNDOWN.apply(this) ? "" : (VmInstance.dns() ? this.getPrivateDnsName() : this.getDisplayPrivateAddress());
    }

    @Nonnull
    String getDisplayPrivateAddress() {
        return VmStateSet.TORNDOWN.apply(this) ? "" : (VmNetworkConfig.DEFAULT_IP.equals(Objects.firstNonNull((Object)Strings.emptyToNull((String)this.getPrivateAddress()), (Object)VmNetworkConfig.DEFAULT_IP)) ? VmNetworkConfig.DEFAULT_IP : this.getPrivateAddress());
    }

    private static boolean dns() {
        return StackConfiguration.USE_INSTANCE_DNS != false && !((Dns)ComponentIds.lookup(Dns.class)).runLimitedServices();
    }

    public boolean isBlockStorage() {
        return this.bootRecord.isBlockStorage();
    }

    public boolean isEbsOptimized() {
        return false;
    }

    public String getInstanceType() {
        return this.getVmType().getName();
    }

    public void setNaturalId(String naturalId) {
        super.setNaturalId(naturalId);
    }

    public VmVolumeState getTransientVolumeState() {
        if (this.transientVolumeState == null) {
            this.transientVolumeState = new VmVolumeState(this);
        }
        return this.transientVolumeState;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("VmInstance:");
        if (this.networkConfig != null) {
            builder2.append("networkConfig=").append(this.getNetworkConfig()).append(":");
        }
        if (this.vmId != null) {
            builder2.append("vmId=").append(this.vmId).append(":");
        }
        if (this.bootRecord != null) {
            builder2.append("bootRecord=").append(this.bootRecord).append(":");
        }
        if (this.usageStats != null) {
            builder2.append("usageStats=").append(this.usageStats).append(":");
        }
        if (this.launchRecord != null) {
            builder2.append("launchRecord=").append(this.launchRecord).append(":");
        }
        if (this.runtimeState != null) {
            builder2.append("runtimeState=").append(this.runtimeState).append(":");
        }
        if (this.transientVolumeState != null) {
            builder2.append("transientVolumeState=").append(this.transientVolumeState).append(":");
        }
        if (this.placement != null) {
            builder2.append("placement=").append(this.placement).append(":");
        }
        if (this.privateNetwork != null) {
            builder2.append("privateNetwork=").append(this.privateNetwork).append(":");
        }
        if (Entities.isReadable(this.networkGroups)) {
            builder2.append("networkGroups=").append(this.networkGroups).append(":");
        }
        if (Entities.isReadable((Object)this.networkIndex)) {
            builder2.append("networkIndex=").append(this.networkIndex);
        }
        return builder2.toString();
    }

    private VmNetworkConfig getNetworkConfig() {
        if (this.networkConfig == null) {
            this.networkConfig = new VmNetworkConfig(this);
        }
        return this.networkConfig;
    }

    private void setNetworkGroups(Set<NetworkGroup> networkGroups) {
        this.networkGroups = networkGroups;
    }

    void setNetworkConfig(VmNetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public Integer getLaunchIndex() {
        return this.getLaunchRecord().getLaunchIndex();
    }

    @Nullable
    public String getClientToken() {
        return this.getVmId().getClientToken();
    }

    @Nullable
    public String getIamInstanceProfileArn() {
        return this.getBootRecord().getIamInstanceProfileArn();
    }

    @Nullable
    public String getIamInstanceProfileId() {
        return this.getBootRecord().getIamInstanceProfileId();
    }

    @Nullable
    public String getIamRoleArn() {
        return this.getBootRecord().getIamRoleArn();
    }

    public SshKeyPair getKeyPair() {
        return this.getBootRecord().getSshKeyPair();
    }

    public String getVirtualizationType() {
        return this.getBootRecord().getDisplayVirtualizationType().toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.vmId == null ? 0 : this.vmId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        VmInstance other = (VmInstance)((Object)obj);
        return !(this.vmId == null ? other.vmId != null : !this.vmId.equals(other.vmId));
    }

    public static VmInstance create() {
        return new VmInstance();
    }

    public static VmInstance exampleWithPublicIp(String ip) {
        VmInstance vmExample = VmInstance.create();
        vmExample.setNetworkConfig(VmNetworkConfig.exampleWithPublicIp(ip));
        return vmExample;
    }

    public static VmInstance exampleWithPrivateIp(String ip) {
        VmInstance vmExample = VmInstance.create();
        vmExample.setNetworkConfig(VmNetworkConfig.exampleWithPrivateIp(ip));
        return vmExample;
    }

    public static VmInstance exampleResource(OwnerFullName owner, final String availabilityZone, final String instanceProfileArn, final String instanceType, final boolean isBlockStorage) {
        return new VmInstance(owner, ""){

            @Override
            public String getIamInstanceProfileArn() {
                return instanceProfileArn;
            }

            @Override
            public String getInstanceType() {
                return instanceType;
            }

            @Override
            public String getPartition() {
                return availabilityZone;
            }

            @Override
            public boolean isBlockStorage() {
                return isBlockStorage;
            }
        };
    }

    private void setBootRecord(VmBootRecord bootRecord) {
        this.bootRecord = bootRecord;
    }

    public Boolean getMonitoring() {
        return this.getBootRecord().isMonitoring();
    }

    public void startMigration() {
        this.runtimeState.startMigration();
    }

    public void abortMigration() {
        this.runtimeState.abortMigration();
    }

    public VmMigrationTask getMigrationTask() {
        return this.runtimeState.getMigrationTask();
    }

    @PrePersist
    @PreUpdate
    private void updateGroups() {
        this.networkGroupIds.clear();
        CollectionUtils.fluent(this.networkGroups).transform(TypeMappers.lookup(NetworkGroup.class, NetworkGroupId.class)).copyInto(this.networkGroupIds);
    }

    @Upgrades.EntityUpgrade(entities={VmInstance.class}, since=Upgrades.Version.v3_3_0, value=Eucalyptus.class)
    public static enum VmInstanceUpgrade_3_3_0 implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(Class arg0) {
            EntityTransaction db = Entities.get(VmInstance.class);
            try {
                List instances = Entities.query((Object)((Object)new VmInstance()));
                for (VmInstance vm : instances) {
                    if (vm.getBootRecord().getMachine() instanceof BlockStorageImageInfo) {
                        LOG.info((Object)("Upgrading bfebs VmInstance: " + vm.toString()));
                        if (vm.getBootRecord().getEphemeralStorage().isEmpty()) {
                            LOG.info((Object)"Adding ephemeral disk at /dev/sdb");
                            vm.addEphemeralAttachment("/dev/sdb", "ephemeral0");
                        }
                        if (vm.getBootRecord().getPersistentVolumes().size() == 1) {
                            VmVolumeAttachment attachment = vm.getBootRecord().getPersistentVolumes().iterator().next();
                            LOG.info((Object)("Found the only VmVolumeAttachment: " + attachment.toString()));
                            LOG.info((Object)"Setting root device flag to true");
                            attachment.setIsRootDevice(Boolean.TRUE);
                            LOG.info((Object)"Changing the device name to /dev/sda");
                            attachment.setDevice("/dev/sda");
                        } else {
                            for (VmVolumeAttachment attachment : vm.getBootRecord().getPersistentVolumes()) {
                                LOG.info((Object)("Found VmVolumeAttachment: " + attachment.toString()));
                                if (!attachment.getDevice().equalsIgnoreCase("/dev/sda1")) continue;
                                LOG.info((Object)"Setting root device flag to true");
                                attachment.setIsRootDevice(Boolean.TRUE);
                                LOG.info((Object)"Changing the device name from /dev/sda1 to /dev/sda");
                                attachment.setDevice("/dev/sda");
                            }
                        }
                    }
                    Entities.persist((Object)((Object)vm));
                }
                db.commit();
                return true;
            }
            catch (Exception ex) {
                LOG.error((Object)"Error upgrading VmInstance: ", (Throwable)ex);
                db.rollback();
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        static {
            LOG = Logger.getLogger(VmInstanceUpgrade_3_3_0.class);
        }
    }

    private static final class MetadataKey {
        private final String id;
        private final MetadataGroup metadataGroup;

        private MetadataKey(String id, MetadataGroup metadataGroup) {
            this.id = id;
            this.metadataGroup = metadataGroup;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetadataKey that = (MetadataKey)o;
            if (!this.id.equals(that.id)) {
                return false;
            }
            return this.metadataGroup == that.metadataGroup;
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.metadataGroup.hashCode();
            return result;
        }
    }

    private static enum MetadataGroup implements Function<VmInstance, Map<String, String>>
    {
        Core{

            public Map<String, String> apply(VmInstance instance) {
                return MetadataGroup.addListingEntries(instance, instance.getCoreMetadataMap(), true);
            }
        }
        ,
        BlockDeviceMapping("block-device-mapping"){

            public Map<String, String> apply(VmInstance instance) {
                return MetadataGroup.addListingEntries(instance.getBlockDeviceMappingMetadataMap());
            }
        }
        ,
        Iam("iam"){

            public Map<String, String> apply(final VmInstance instance) {
                try {
                    return (Map)metadataCache.get((Object)new MetadataKey(instance.getId(), this), (Callable)new Callable<ImmutableMap<String, String>>(){

                        @Override
                        public ImmutableMap<String, String> call() throws Exception {
                            return ImmutableMap.copyOf((Map)MetadataGroup.addListingEntries(instance.getIamMetadataMap()));
                        }
                    });
                }
                catch (ExecutionException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }

            @Override
            protected boolean isPresent(VmInstance instance) {
                return !Strings.isNullOrEmpty((String)instance.getIamInstanceProfileArn());
            }
        }
        ,
        PublicKeys("public-keys"){

            public Map<String, String> apply(VmInstance instance) {
                return MetadataGroup.addListingEntries(instance.getPublicKeysMetadataMap());
            }

            @Override
            protected boolean isPresent(VmInstance instance) {
                return instance.bootRecord.getSshKeyPair() != null;
            }
        };

        private final Optional<String> prefix;

        private MetadataGroup() {
            this.prefix = Optional.absent();
        }

        private MetadataGroup(String path) {
            this.prefix = Optional.of((Object)path);
        }

        public boolean providesPath(String path) {
            return (Boolean)this.prefix.transform(Functions.forPredicate((Predicate)com.eucalyptus.util.Strings.isPrefixOf((String)path))).or((Object)Boolean.FALSE);
        }

        protected boolean isPresent(VmInstance instance) {
            return true;
        }

        private static Map<String, String> addListingEntries(Map<String, String> metadataMap) {
            return MetadataGroup.addListingEntries(null, metadataMap, false);
        }

        private static Map<String, String> addListingEntries(@Nullable VmInstance instance, Map<String, String> metadataMap, boolean addRoots) {
            TreeMultimap listingMap = TreeMultimap.create();
            Splitter pathSplitter = Splitter.on((char)'/');
            Joiner pathJoiner = Joiner.on((char)'/');
            for (String path : metadataMap.keySet()) {
                ArrayList pathSegments = Lists.newArrayList((Iterable)pathSplitter.split((CharSequence)path));
                for (int i = 0; i < pathSegments.size(); ++i) {
                    listingMap.put((Object)pathJoiner.join(pathSegments.subList(0, i)), (Object)((String)pathSegments.get(i) + (i < pathSegments.size() - 1 ? "/" : "")));
                }
            }
            if (addRoots && instance != null) {
                for (MetadataGroup group : MetadataGroup.values()) {
                    if (!group.isPresent(instance) || !group.prefix.isPresent()) continue;
                    listingMap.put((Object)"", (Object)((String)group.prefix.get() + "/"));
                }
            }
            Joiner listingJoiner = Joiner.on((String)"\n");
            for (String key : listingMap.keySet()) {
                NavigableSet values = listingMap.get((Object)key);
                Iterator valueIterator = values.iterator();
                while (valueIterator.hasNext()) {
                    String value = (String)valueIterator.next();
                    if (!values.contains(value + "/")) continue;
                    valueIterator.remove();
                }
                if (!metadataMap.containsKey(key)) {
                    metadataMap.put(key, listingJoiner.join((Iterable)values));
                    continue;
                }
                if (metadataMap.containsKey(key + "/")) continue;
                metadataMap.put(key + "/", listingJoiner.join((Iterable)values));
            }
            return metadataMap;
        }
    }

    @TypeMapper
    public static enum StatusTransform implements Function<VmInstance, InstanceStatusItemType>
    {
        INSTANCE;


        public InstanceStatusItemType apply(VmInstance instance) {
            InstanceStatusItemType instanceStatusItemType = new InstanceStatusItemType();
            VmState displayState = instance.getDisplayState();
            instanceStatusItemType.setInstanceId(instance.getInstanceId());
            instanceStatusItemType.setAvailabilityZone(instance.getPlacement().getPartitionName());
            instanceStatusItemType.setEventsSet(this.buildEventSet(instance));
            InstanceStateType state = new InstanceStateType();
            state.setCode(displayState.getCode());
            state.setName(displayState.getName());
            instanceStatusItemType.setInstanceState(state);
            instanceStatusItemType.setInstanceStatus(this.buildStatus((Optional<Pair<VmRuntimeState.InstanceStatus, Pair<VmRuntimeState.ReachabilityStatus, Optional<Date>>>>)Optional.of((Object)Pair.pair((Object)((Object)VmRuntimeState.InstanceStatus.Ok), (Object)Pair.pair((Object)((Object)VmRuntimeState.ReachabilityStatus.Passed), (Object)Optional.absent())))));
            instanceStatusItemType.setSystemStatus(this.buildStatus(instance));
            return instanceStatusItemType;
        }

        public static Optional<InstanceStatusEventType> getEventInfo(VmInstance instance) {
            Optional eventInfo = Optional.absent();
            if (VmState.RUNNING.apply(instance)) {
                VmRuntimeState vmRuntimeState = instance.getRuntimeState();
                Date unreachableTimestamp = vmRuntimeState.getUnreachableTimestamp();
                if (Boolean.TRUE.equals(vmRuntimeState.getZombie()) && unreachableTimestamp != null) {
                    InstanceStatusEventType event = new InstanceStatusEventType();
                    event.setCode("instance-retirement");
                    event.setDescription("Instance recovered with degraded functionality");
                    event.setNotAfter(new Date(unreachableTimestamp.getTime() + TimeUnit.DAYS.toMillis(365L)));
                    event.setNotBefore(unreachableTimestamp);
                    eventInfo = Optional.of((Object)event);
                }
            }
            return eventInfo;
        }

        private InstanceStatusEventsSetType buildEventSet(VmInstance instance) {
            InstanceStatusEventsSetType eventSet = null;
            Optional<InstanceStatusEventType> eventInfo = StatusTransform.getEventInfo(instance);
            if (eventInfo.isPresent()) {
                eventSet = new InstanceStatusEventsSetType();
                eventSet.getItem().add(eventInfo.get());
            }
            return eventSet;
        }

        private InstanceStatusType buildStatus(VmInstance instance) {
            if (VmState.RUNNING.apply(instance)) {
                VmRuntimeState vmRuntimeState = instance.getRuntimeState();
                VmRuntimeState.InstanceStatus instanceStatus = (VmRuntimeState.InstanceStatus)((Object)Objects.firstNonNull((Object)((Object)vmRuntimeState.getInstanceStatus()), (Object)((Object)VmRuntimeState.InstanceStatus.Ok)));
                VmRuntimeState.ReachabilityStatus reachabilityStatus = (VmRuntimeState.ReachabilityStatus)((Object)Objects.firstNonNull((Object)((Object)vmRuntimeState.getReachabilityStatus()), (Object)((Object)VmRuntimeState.ReachabilityStatus.Passed)));
                Date unreachabilityTimestamp = reachabilityStatus != VmRuntimeState.ReachabilityStatus.Passed ? vmRuntimeState.getUnreachableTimestamp() : null;
                return this.buildStatus((Optional<Pair<VmRuntimeState.InstanceStatus, Pair<VmRuntimeState.ReachabilityStatus, Optional<Date>>>>)Optional.of((Object)Pair.pair((Object)((Object)instanceStatus), (Object)Pair.ropair((Object)((Object)reachabilityStatus), (Object)unreachabilityTimestamp))));
            }
            return this.buildStatus((Optional<Pair<VmRuntimeState.InstanceStatus, Pair<VmRuntimeState.ReachabilityStatus, Optional<Date>>>>)Optional.absent());
        }

        private InstanceStatusType buildStatus(Optional<Pair<VmRuntimeState.InstanceStatus, Pair<VmRuntimeState.ReachabilityStatus, Optional<Date>>>> status) {
            InstanceStatusType instanceStatusType = new InstanceStatusType();
            if (status.isPresent()) {
                VmRuntimeState.InstanceStatus instanceStatus = (VmRuntimeState.InstanceStatus)((Object)((Pair)status.get()).getLeft());
                VmRuntimeState.ReachabilityStatus reachabilityStatus = (VmRuntimeState.ReachabilityStatus)((Object)((Pair)((Pair)status.get()).getRight()).getLeft());
                Optional unreachableTimestamp = (Optional)((Pair)((Pair)status.get()).getRight()).getRight();
                InstanceStatusDetailsSetItemType statusDetailsItem = new InstanceStatusDetailsSetItemType();
                statusDetailsItem.setName("reachability");
                statusDetailsItem.setStatus(reachabilityStatus.toString());
                statusDetailsItem.setImpairedSince((Date)unreachableTimestamp.orNull());
                InstanceStatusDetailsSetType statusDetails = new InstanceStatusDetailsSetType();
                statusDetails.getItem().add(statusDetailsItem);
                instanceStatusType.setStatus(instanceStatus.toString());
                instanceStatusType.setDetails(statusDetails);
            } else {
                instanceStatusType.setStatus("not-applicable");
            }
            return instanceStatusType;
        }
    }

    @TypeMapper
    public static enum NetworkGroupToGroupItemTypeTransform implements Function<NetworkGroup, GroupItemType>
    {
        INSTANCE;


        public GroupItemType apply(NetworkGroup networkGroupId) {
            return new GroupItemType(networkGroupId.getGroupId(), networkGroupId.getName());
        }
    }

    @TypeMapper
    public static enum NetworkGroupIdToGroupItemTypeTransform implements Function<NetworkGroupId, GroupItemType>
    {
        INSTANCE;


        public GroupItemType apply(NetworkGroupId networkGroupId) {
            return new GroupItemType(networkGroupId.getGroupId(), networkGroupId.getGroupName());
        }
    }

    @TypeMapper
    public static enum NetworkGroupIdTransform implements Function<NetworkGroup, NetworkGroupId>
    {
        INSTANCE;


        public NetworkGroupId apply(NetworkGroup networkGroup) {
            return new NetworkGroupId(networkGroup.getGroupId(), networkGroup.getName());
        }
    }

    @TypeMapper
    public static enum ReservationTransform implements Function<VmInstance, ReservationInfoType>
    {
        INSTANCE;


        public ReservationInfoType apply(VmInstance instance) {
            return new ReservationInfoType(instance.getReservationId(), instance.getOwner().getAccountNumber(), Collections2.transform(instance.getNetworkGroupIds(), (Function)TypeMappers.lookup(NetworkGroupId.class, GroupItemType.class)));
        }
    }

    @TypeMapper
    public static enum Transform implements Function<VmInstance, RunningInstancesItemType>
    {
        INSTANCE;


        public RunningInstancesItemType apply(VmInstance v) {
            if (!Entities.isPersistent((Object)((Object)v))) {
                throw new TransientEntityException(v.toString());
            }
            EntityTransaction db = Entities.get(VmInstance.class);
            try {
                VmInstance input = (VmInstance)((Object)Entities.merge((Object)((Object)v)));
                RunningInstancesItemType runningInstance = new RunningInstancesItemType();
                runningInstance.setAmiLaunchIndex(Integer.toString(input.getLaunchRecord().getLaunchIndex()));
                VmState displayState = input.getDisplayState();
                runningInstance.setStateCode(Integer.toString(displayState.getCode()));
                runningInstance.setStateName(displayState.getName());
                runningInstance.setPlatform(input.getPlatform());
                runningInstance.setInstanceId(input.getVmId().getInstanceId());
                runningInstance.setProductCodes(new ArrayList());
                runningInstance.setImageId(input.getImageId());
                runningInstance.setKernel(input.getKernelId());
                runningInstance.setRamdisk(input.getRamdiskId());
                runningInstance.setPlatform(Strings.emptyToNull((String)input.getDisplayPlatform()));
                runningInstance.setDnsName(input.getDisplayPublicDnsName());
                runningInstance.setIpAddress(Strings.emptyToNull((String)input.getDisplayPublicAddress()));
                runningInstance.setPrivateDnsName(input.getDisplayPrivateDnsName());
                runningInstance.setPrivateIpAddress(Strings.emptyToNull((String)input.getDisplayPrivateAddress()));
                if (input.getBootRecord() == null || input.getBootRecord().getArchitecture() == null) {
                    LOG.debug((Object)("WARNING: No architecture set for instance " + input.getInstanceId() + ", defaulting to x86_64"));
                    runningInstance.setArchitecture("x86_64");
                } else {
                    runningInstance.setArchitecture(input.getBootRecord().getArchitecture().toString());
                }
                runningInstance.setReason(input.runtimeState.getReason());
                if (input.getBootRecord().getSshKeyPair() != null) {
                    runningInstance.setKeyName(input.getBootRecord().getSshKeyPair().getName());
                    if (runningInstance.getKeyName() != null && runningInstance.getKeyName().isEmpty()) {
                        runningInstance.setKeyName(null);
                    }
                } else {
                    runningInstance.setKeyName("");
                }
                runningInstance.setInstanceType(input.getVmType().getName());
                runningInstance.setPlacement(input.getPlacement().getPartitionName());
                runningInstance.setLaunchTime(input.getLaunchRecord().getLaunchTime());
                runningInstance.setClientToken(input.getClientToken());
                runningInstance.setVpcId(input.getVpcId());
                runningInstance.setSubnetId(input.getSubnetId());
                if (!Strings.isNullOrEmpty((String)input.getIamInstanceProfileId())) {
                    runningInstance.setIamInstanceProfile(new IamInstanceProfile(input.getIamInstanceProfileArn(), input.getIamInstanceProfileId()));
                } else if (!Strings.isNullOrEmpty((String)input.getIamInstanceProfileArn()) && input.getIamInstanceProfileArn().startsWith("arn:")) {
                    String rawName = input.getIamInstanceProfileArn();
                    int nameIndex = input.getIamInstanceProfileArn().lastIndexOf(47);
                    String name = input.getIamInstanceProfileArn().substring(nameIndex + 1, rawName.length());
                    try {
                        InstanceProfile instanceProfile = Accounts.lookupAccountById((String)input.getOwnerAccountNumber()).lookupInstanceProfileByName(name);
                        String profileArn = Accounts.getInstanceProfileArn((InstanceProfile)instanceProfile);
                        IamInstanceProfile iamInstanceProfile = new IamInstanceProfile();
                        iamInstanceProfile.setArn(profileArn);
                        iamInstanceProfile.setId(instanceProfile.getInstanceProfileId());
                        runningInstance.setIamInstanceProfile(iamInstanceProfile);
                    }
                    catch (NoSuchElementException nsee) {
                        LOG.debug((Object)("profile arn : " + name), (Throwable)nsee);
                    }
                } else if (!Strings.isNullOrEmpty((String)input.getIamInstanceProfileArn()) && !input.getIamInstanceProfileArn().startsWith("arn:")) {
                    try {
                        InstanceProfile instanceProfile = Accounts.lookupAccountById((String)input.getOwnerAccountNumber()).lookupInstanceProfileByName(input.getIamInstanceProfileArn());
                        String profileArn = Accounts.getInstanceProfileArn((InstanceProfile)instanceProfile);
                        IamInstanceProfile iamInstanceProfile = new IamInstanceProfile();
                        iamInstanceProfile.setArn(profileArn);
                        iamInstanceProfile.setId(instanceProfile.getInstanceProfileId());
                        runningInstance.setIamInstanceProfile(iamInstanceProfile);
                    }
                    catch (NoSuchElementException nsee) {
                        LOG.debug((Object)("profile name : " + input.getIamInstanceProfileArn()), (Throwable)nsee);
                    }
                }
                if (input.getMonitoring().booleanValue()) {
                    runningInstance.setMonitoring("enabled");
                } else {
                    runningInstance.setMonitoring("disabled");
                }
                runningInstance.getGroupSet().addAll(Collections2.transform(input.getNetworkGroupIds(), (Function)TypeMappers.lookup(NetworkGroupId.class, GroupItemType.class)));
                Collections.sort(runningInstance.getGroupSet());
                runningInstance.setVirtualizationType(input.getVirtualizationType());
                if (input.isBlockStorage()) {
                    runningInstance.setRootDeviceType(VmInstance.ROOT_DEVICE_TYPE_EBS);
                }
                if (input.getBootRecord().hasPersistentVolumes()) {
                    for (VmVolumeAttachment attachedVol : input.getBootRecord().getPersistentVolumes()) {
                        runningInstance.getBlockDevices().add(new InstanceBlockDeviceMapping(attachedVol.getDevice(), attachedVol.getVolumeId(), attachedVol.getStatus(), attachedVol.getAttachTime(), attachedVol.getDeleteOnTerminate()));
                        if (!attachedVol.getIsRootDevice().booleanValue()) continue;
                        runningInstance.setRootDeviceName(attachedVol.getDevice());
                    }
                }
                for (VmVolumeAttachment attachedVol : input.getTransientVolumeState().getAttachments()) {
                    runningInstance.getBlockDevices().add(new InstanceBlockDeviceMapping(attachedVol.getDevice(), attachedVol.getVolumeId(), attachedVol.getStatus(), attachedVol.getAttachTime(), attachedVol.getDeleteOnTerminate()));
                }
                for (NetworkInterface networkInterface : input.getNetworkInterfaces()) {
                    if (runningInstance.getNetworkInterfaceSet() == null) {
                        runningInstance.setNetworkInterfaceSet(new InstanceNetworkInterfaceSetType());
                    }
                    runningInstance.getNetworkInterfaceSet().getItem().add(new InstanceNetworkInterfaceSetItemType(networkInterface.getDisplayName(), networkInterface.getSubnet().getDisplayName(), networkInterface.getVpc().getDisplayName(), networkInterface.getDescription(), networkInterface.getOwnerAccountNumber(), String.valueOf(networkInterface.getState()), networkInterface.getMacAddress(), networkInterface.getPrivateIpAddress(), networkInterface.getPrivateDnsName(), networkInterface.getSourceDestCheck(), new GroupSetType(Collections2.transform(networkInterface.getNetworkGroups(), (Function)TypeMappers.lookup(NetworkGroup.class, GroupItemType.class))), new InstanceNetworkInterfaceAttachmentType(networkInterface.getAttachment().getAttachmentId(), networkInterface.getAttachment().getDeviceIndex(), String.valueOf((Object)networkInterface.getAttachment().getStatus()), networkInterface.getAttachment().getAttachTime(), networkInterface.getAttachment().getDeleteOnTerminate()), networkInterface.isAssociated() ? new InstanceNetworkInterfaceAssociationType(networkInterface.getAssociation().getPublicIp(), networkInterface.getAssociation().getPublicDnsName(), networkInterface.getAssociation().getDisplayIpOwnerId()) : null, new InstancePrivateIpAddressesSetType((Collection)Lists.newArrayList((Object[])new InstancePrivateIpAddressesSetItemType[]{new InstancePrivateIpAddressesSetItemType(networkInterface.getPrivateIpAddress(), networkInterface.getPrivateDnsName(), Boolean.valueOf(true), networkInterface.isAssociated() ? new InstanceNetworkInterfaceAssociationType(networkInterface.getAssociation().getPublicIp(), networkInterface.getAssociation().getPublicDnsName(), networkInterface.getAssociation().getDisplayIpOwnerId()) : null)}))));
                }
                RunningInstancesItemType runningInstancesItemType = runningInstance;
                return runningInstancesItemType;
            }
            catch (NoSuchElementException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new NoSuchElementException("Failed to lookup vm instance: " + (Object)((Object)v));
            }
            finally {
                if (db.isActive()) {
                    db.rollback();
                }
            }
        }
    }

    public static enum Reason implements Predicate<VmInstance>
    {
        NORMAL("", new Object[0]),
        EXPIRED("Instance expired after not being reported for %s mins.", VmInstances.Timeout.UNREPORTED.getMinutes()),
        FAILED("The instance failed to start on the NC.", new Object[0]),
        USER_TERMINATED(true, "User terminated.", new Object[0]),
        USER_STOPPED(true, "User stopped.", new Object[0]),
        USER_STARTED(true, "User started.", new Object[0]),
        APPEND("", new Object[0]);

        private final boolean user;
        private final String message;
        private final Object[] args;

        private Reason(String message, Object ... args) {
            this(false, message, args);
        }

        private Reason(boolean user, String message, Object ... args) {
            this.user = user;
            this.message = message;
            this.args = args;
        }

        public boolean user() {
            return this.user;
        }

        public String toString() {
            return String.format(this.message.toString(), this.args);
        }

        public boolean apply(VmInstance vmInstance) {
            return this.equals((Object)vmInstance.getRuntimeState().reason());
        }
    }

    public static class Builder {
        private VmId vmId;
        private String uuid;
        private VmBootRecord vmBootRecord;
        private VmPlacement vmPlacement;
        private List<NetworkGroup> networkRulesGroups;
        private Optional<PrivateNetworkIndex> networkIndex = Optional.absent();
        private Boolean usePrivateAddressing;
        private Boolean zombie;
        private OwnerFullName owner;
        private Date expiration = new Date(32503708800000L);
        private List<Callback<VmInstance>> callbacks = Lists.newArrayList();

        public Builder owner(OwnerFullName owner) {
            this.owner = owner;
            return this;
        }

        public Builder expiresOn(Date expirationTime) {
            if (expirationTime != null) {
                this.expiration = expirationTime;
            }
            return this;
        }

        public Builder networkGroups(List<NetworkGroup> groups) {
            this.networkRulesGroups = groups;
            return this;
        }

        public Builder networkIndex(PrivateNetworkIndex index) {
            this.networkIndex = Optional.fromNullable((Object)index);
            return this;
        }

        public Builder addressing(Boolean usePrivate) {
            this.usePrivateAddressing = usePrivate;
            return this;
        }

        public Builder zombie(Boolean zombie) {
            this.zombie = zombie;
            return this;
        }

        public Builder withIds(@Nonnull String instanceId, @Nonnull String instanceUuid, @Nonnull String reservationId, @Nullable String clientToken, @Nullable String uniqueClientToken) {
            this.vmId = new VmId(reservationId, instanceId, clientToken, uniqueClientToken);
            this.uuid = instanceUuid;
            return this;
        }

        public Builder placement(Partition partition) {
            ServiceConfiguration config = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{partition});
            this.vmPlacement = new VmPlacement(config.getName(), config.getPartition());
            return this;
        }

        public Builder bootRecord(Emis.BootableSet bootSet, byte[] userData, SshKeyPair sshKeyPair, VmType vmType, Subnet subnet, boolean monitoring, @Nullable String iamInstanceProfileArn, @Nullable String iamInstanceProfileId, @Nullable String iamInstanceRoleArn) {
            this.vmBootRecord = new VmBootRecord(bootSet, userData, sshKeyPair, vmType, subnet, monitoring, iamInstanceProfileArn, iamInstanceProfileId, iamInstanceRoleArn);
            return this;
        }

        public Builder onBuild(Callback<VmInstance> callback) {
            this.callbacks.add(callback);
            return this;
        }

        public VmInstance build(Integer launchIndex) throws ResourceAllocationException {
            VmInstance instance = new VmInstance(this.owner, this.vmId, this.vmBootRecord, new VmLaunchRecord(launchIndex, new Date()), this.vmPlacement, this.networkRulesGroups, this.networkIndex, this.usePrivateAddressing, this.expiration);
            instance.setNaturalId(this.uuid);
            if (Boolean.TRUE.equals(this.zombie)) {
                instance.getRuntimeState().zombie();
            }
            for (Callback<VmInstance> callback : this.callbacks) {
                callback.fire((Object)instance);
            }
            return instance;
        }
    }

    private static enum VolumeAttachmentComparator implements Comparator<VmVolumeAttachment>
    {
        INSTANCE;


        @Override
        public int compare(VmVolumeAttachment arg0, VmVolumeAttachment arg1) {
            return arg0.getDevice().compareToIgnoreCase(arg1.getDevice());
        }
    }

    public static enum Create implements Function<ResourceToken, VmInstance>
    {
        INSTANCE;


        public VmInstance apply(ResourceToken token) {
            EntityTransaction db = Entities.get(VmInstance.class);
            try {
                try {
                    Entities.delete((Object)Entities.uniqueResult((Object)((Object)VmInstance.withUuid(token.getInstanceUuid()))));
                    Entities.flush(VmInstance.class);
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                Allocations.Allocation allocInfo = token.getAllocationInfo();
                Builder builder = new Builder();
                builder.onBuild(new Callback<VmInstance>(){

                    public void fire(VmInstance input) {
                        Entities.persist((Object)((Object)input));
                    }
                });
                VmInstanceLifecycleHelpers.get().prepareVmInstance(token, builder);
                VmInstance vmInst = builder.owner((OwnerFullName)allocInfo.getOwnerFullName()).withIds(token.getInstanceId(), token.getInstanceUuid(), allocInfo.getReservationId(), allocInfo.getClientToken(), allocInfo.getUniqueClientToken(token.getLaunchIndex())).bootRecord(allocInfo.getBootSet(), allocInfo.getUserData(), allocInfo.getSshKeyPair(), allocInfo.getVmType(), allocInfo.getSubnet(), allocInfo.isMonitoring(), allocInfo.getIamInstanceProfileArn(), allocInfo.getIamInstanceProfileId(), allocInfo.getIamRoleArn()).placement(allocInfo.getPartition()).networkGroups(allocInfo.getNetworkGroups()).addressing(allocInfo.isUsePrivateAddressing()).zombie(token.isZombie()).expiresOn(allocInfo.getExpiration()).build(token.getLaunchIndex());
                Entities.flush((Object)((Object)vmInst));
                db.commit();
                token.setVmInstance(vmInst);
                VmInstance vmInstance = vmInst;
                return vmInstance;
            }
            catch (ResourceAllocationException ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw Exceptions.toUndeclared((Throwable)ex);
            }
            catch (Exception ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw Exceptions.toUndeclared((Throwable)new TransactionExecutionException((Throwable)ex));
            }
            finally {
                if (db.isActive()) {
                    db.rollback();
                }
            }
        }
    }

    static enum InstanceStatusUpdate implements Function<VmInstance, VmInstance>
    {
        REACHABLE{

            public VmInstance apply(VmInstance v) {
                try {
                    VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(null, v.getInstanceId()))));
                    if (VmState.RUNNING.apply(vm)) {
                        vm.getRuntimeState().reachable();
                    }
                    return vm;
                }
                catch (Exception ex) {
                    Logs.extreme().trace((Object)ex, (Throwable)ex);
                    throw new NoSuchElementException("Failed to lookup instance: " + (Object)((Object)v));
                }
            }
        }
        ,
        UNREACHABLE{

            public VmInstance apply(VmInstance v) {
                try {
                    VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(null, v.getInstanceId()))));
                    if (VmState.RUNNING.apply(vm)) {
                        VmRuntimeState runtimeState = vm.getRuntimeState();
                        Date unreachableSince = runtimeState.getUnreachableTimestamp();
                        if (unreachableSince == null) {
                            runtimeState.setUnreachableTimestamp(new Date());
                        } else if (unreachableSince.getTime() + TimeUnit.MINUTES.toMillis(VmInstances.INSTANCE_REACHABILITY_TIMEOUT.intValue()) < System.currentTimeMillis()) {
                            runtimeState.setInstanceStatus(VmRuntimeState.InstanceStatus.Impaired);
                            runtimeState.setReachabilityStatus(VmRuntimeState.ReachabilityStatus.Failed);
                        }
                    }
                    return vm;
                }
                catch (Exception ex) {
                    Logs.extreme().trace((Object)ex, (Throwable)ex);
                    throw new NoSuchElementException("Failed to lookup instance: " + (Object)((Object)v));
                }
            }
        };

    }

    static enum Lookup implements Function<String, VmInstance>
    {
        INSTANCE{

            @Override
            @Nonnull
            public VmInstance apply(String arg0) {
                EntityTransaction db = Entities.get(VmInstance.class);
                try {
                    VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(null, arg0))));
                    if (vm == null) {
                        throw new NoSuchElementException("Failed to lookup vm instance: " + arg0);
                    }
                    db.commit();
                    VmInstance vmInstance = vm;
                    return vmInstance;
                }
                catch (NoSuchElementException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new NoSuchElementException("An error occurred while trying to lookup vm instance " + arg0 + ": " + ex.getMessage() + "\n" + Exceptions.causeString((Throwable)ex));
                }
                finally {
                    if (db.isActive()) {
                        db.rollback();
                    }
                }
            }
        };


        @Nonnull
        public abstract VmInstance apply(String var1);
    }

    static enum Transitions implements Function<VmInstance, VmInstance>
    {
        BURIED{

            @Override
            public VmInstance apply(VmInstance v) {
                try {
                    VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(null, v.getInstanceId()))));
                    if (VmState.TERMINATED.apply(vm)) {
                        vm.setState(VmState.BURIED);
                    }
                    return vm;
                }
                catch (Exception ex) {
                    Logs.extreme().trace((Object)ex, (Throwable)ex);
                    throw new NoSuchElementException("Failed to lookup instance: " + (Object)((Object)v));
                }
            }
        }
        ,
        TERMINATED{

            @Override
            public VmInstance apply(VmInstance v) {
                try {
                    VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(null, v.getInstanceId()))));
                    if (VmStateSet.RUN.apply(vm)) {
                        Reason reason = VmInstances.Timeout.UNREPORTED.apply(vm) ? Reason.EXPIRED : Reason.USER_TERMINATED;
                        vm.setState(VmState.SHUTTING_DOWN, reason, new String[0]);
                    } else if (VmState.SHUTTING_DOWN.equals(vm.getState())) {
                        Reason reason = VmInstances.Timeout.SHUTTING_DOWN.apply(vm) || Reason.EXPIRED.apply(vm) ? Reason.EXPIRED : Reason.USER_TERMINATED;
                        vm.setState(VmState.TERMINATED, reason, new String[0]);
                    } else if (VmState.STOPPED.equals(vm.getState())) {
                        vm.setState(VmState.TERMINATED, Reason.USER_TERMINATED, new String[0]);
                    }
                    return vm;
                }
                catch (Exception ex) {
                    Logs.extreme().trace((Object)ex, (Throwable)ex);
                    throw new NoSuchElementException("Failed to lookup instance: " + (Object)((Object)v));
                }
            }
        }
        ,
        STOPPED{

            @Override
            public VmInstance apply(VmInstance v) {
                try {
                    VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(null, v.getInstanceId()))));
                    if (VmStateSet.RUN.apply(vm)) {
                        vm.setState(VmState.STOPPING, Reason.USER_STOPPED, new String[0]);
                    } else if (VmState.STOPPING.equals(vm.getState())) {
                        vm.setState(VmState.STOPPED, Reason.USER_STOPPED, new String[0]);
                    }
                    return vm;
                }
                catch (Exception ex) {
                    Logs.extreme().debug((Object)ex, (Throwable)ex);
                    throw new NoSuchElementException("Failed to lookup instance: " + (Object)((Object)v));
                }
            }
        }
        ,
        DELETE{

            @Override
            public VmInstance apply(VmInstance v) {
                try {
                    VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(null, v.getInstanceId()))));
                    Entities.delete((Object)((Object)vm));
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
                v.setState(VmState.TERMINATED);
                return v;
            }
        }
        ,
        SHUTDOWN{

            @Override
            public VmInstance apply(VmInstance v) {
                try {
                    VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(null, v.getInstanceId()))));
                    if (VmStateSet.RUN.apply(vm)) {
                        Reason reason = VmInstances.Timeout.SHUTTING_DOWN.apply(vm) ? Reason.EXPIRED : Reason.USER_TERMINATED;
                        vm.setState(VmState.SHUTTING_DOWN, reason, new String[0]);
                    }
                    return vm;
                }
                catch (Exception ex) {
                    Logs.extreme().debug((Object)ex, (Throwable)ex);
                    throw new NoSuchElementException("Failed to lookup instance: " + (Object)((Object)v));
                }
            }
        };


        public abstract VmInstance apply(VmInstance var1);
    }

    public static enum RestoreHandler implements Predicate<VmInfo>
    {
        Restore{

            public boolean apply(VmInfo input) {
                if (Networking.getInstance().supports(NetworkingFeature.Vpc)) {
                    return false;
                }
                VmState inputState = VmState.Mapper.get(input.getStateName());
                if (!VmStateSet.RUN.contains(inputState)) {
                    return false;
                }
                if (!ValidateVmInfo.INSTANCE.apply(input)) {
                    return false;
                }
                UserFullName userFullName = UserFullName.getInstance((String)input.getOwnerId(), (String[])new String[0]);
                Allocations.Allocation allocation = null;
                try {
                    String imageId = RestoreHandler.restoreImage(input);
                    String kernelId = RestoreHandler.restoreKernel(input);
                    String ramdiskId = RestoreHandler.restoreRamdisk(input);
                    allocation = Allocations.restore(input, RestoreHandler.restoreLaunchIndex(input), RestoreHandler.restoreVmType(input), RestoreHandler.restoreBootSet(input, imageId, kernelId, ramdiskId), RestoreHandler.restorePartition(input), RestoreHandler.restoreSshKeyPair(input, userFullName), RestoreHandler.restoreUserData(input), userFullName);
                    List networks = RestoreHandler.restoreNetworks(input, userFullName);
                    allocation.setNetworkRules(CollectionUtils.putAll((Iterable)networks, (Map)Maps.newLinkedHashMap(), (Function)RestrictedTypes.toDisplayName(), (Function)Functions.identity()));
                    VmInstanceLifecycleHelpers.get().prepareAllocation(input, allocation);
                    AdmissionControl.restore().apply((Object)allocation);
                    allocation.commit();
                    ResourceToken token = (ResourceToken)Iterables.getOnlyElement(allocation.getAllocationTokens());
                    VmInstanceLifecycleHelpers.get().restoreInstanceResources(token, input);
                    return true;
                }
                catch (Exception ex) {
                    if (allocation != null) {
                        allocation.abort();
                    }
                    LOG.error((Object)("Failed to restore instance " + input.getInstanceId() + " because of: " + ex.getMessage()), (Throwable)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    return false;
                }
            }
        }
        ,
        RestoreFailed{

            public boolean apply(VmInfo input) {
                if (!Networking.getInstance().supports(NetworkingFeature.Consistent)) {
                    return false;
                }
                VmState inputState = VmState.Mapper.get(input.getStateName());
                if (!VmStateSet.RUN.contains(inputState)) {
                    return false;
                }
                if (!ValidateVmInfo.INSTANCE.apply(input)) {
                    return false;
                }
                UserFullName userFullName = UserFullName.getInstance((String)input.getOwnerId(), (String[])new String[0]);
                Allocations.Allocation allocation = null;
                try {
                    String imageId = RestoreHandler.restoreImage(input);
                    String kernelId = RestoreHandler.restoreKernel(input);
                    String ramdiskId = RestoreHandler.restoreRamdisk(input);
                    allocation = Allocations.restore(input, RestoreHandler.restoreLaunchIndex(input), RestoreHandler.restoreVmType(input), RestoreHandler.restoreBootSet(input, imageId, kernelId, ramdiskId), RestoreHandler.restorePartition(input), RestoreHandler.restoreSshKeyPair(input, userFullName), RestoreHandler.restoreUserData(input), userFullName);
                    ResourceToken token = (ResourceToken)Iterables.getOnlyElement(allocation.getAllocationTokens());
                    token.setZombie(true);
                    allocation.commit();
                    return true;
                }
                catch (Exception ex) {
                    if (allocation != null) {
                        allocation.abort();
                    }
                    LOG.error((Object)("Failed to restore instance " + input.getInstanceId() + " because of: " + ex.getMessage()), (Throwable)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    return false;
                }
            }
        }
        ,
        Terminate{

            public boolean apply(VmInfo input) {
                VmState inputState = VmState.Mapper.get(input.getStateName());
                if (VmStateSet.RUN.contains(inputState)) {
                    LOG.info((Object)("Terminating instance: " + input.getInstanceId()));
                    VmInstances.sendTerminate(input.getInstanceId(), input.getPlacement());
                }
                return true;
            }
        }
        ,
        TerminateDone{

            public boolean apply(VmInfo input) {
                try {
                    VmInstance instance = VmInstances.lookupAny(input.getInstanceId());
                    Reason reason = instance.getRuntimeState().reason();
                    if (instance.getNaturalId().equals(input.getUuid()) && VmStateSet.NOT_RUNNING.apply(instance) && reason != null && reason.user()) {
                        return Terminate.apply(input);
                    }
                }
                catch (NoSuchElementException instance) {
                }
                catch (Exception e) {
                    LOG.error((Object)("Error handing unknown instance: " + input.getInstanceId()), (Throwable)e);
                }
                return false;
            }
        };


        public static Iterable<Optional<RestoreHandler>> parseList(String handlers) {
            ArrayList handlerList = Lists.newArrayList();
            for (String handler : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)handlers)) {
                String handerEnum = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, handler);
                handlerList.add(Enums.getIfPresent(RestoreHandler.class, (String)handerEnum));
            }
            return handlerList;
        }

        private static Function<String, NetworkGroup> transformNetworkNames(final UserFullName userFullName) {
            return new Function<String, NetworkGroup>(){

                public NetworkGroup apply(String arg0) {
                    EntityTransaction db = Entities.get(NetworkGroup.class);
                    try {
                        SimpleExpression naturalId = Restrictions.like((String)"naturalId", (Object)(arg0.replace(userFullName.getAccountNumber() + "-", "") + "%"));
                        NetworkGroup result = (NetworkGroup)((Object)Entities.createCriteria(NetworkGroup.class).add((Criterion)naturalId).uniqueResult());
                        if (result == null) {
                            SimpleExpression displayName = Restrictions.like((String)"displayName", (Object)(arg0.replace(userFullName.getAccountNumber() + "-", "") + "%"));
                            result = (NetworkGroup)((Object)Entities.createCriteria(NetworkGroup.class).add((Criterion)displayName).uniqueResult());
                        }
                        db.commit();
                        NetworkGroup networkGroup = result;
                        return networkGroup;
                    }
                    catch (Exception ex) {
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                        throw Exceptions.toUndeclared((Throwable)ex);
                    }
                    finally {
                        if (db.isActive()) {
                            db.rollback();
                        }
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static List<NetworkGroup> restoreNetworks(VmInfo input, UserFullName userFullName) {
            ArrayList networks = Lists.newArrayList();
            networks.addAll(Lists.transform((List)input.getGroupNames(), RestoreHandler.transformNetworkNames(userFullName)));
            Iterables.removeIf((Iterable)networks, (Predicate)Predicates.isNull());
            if (networks.isEmpty()) {
                EntityTransaction restore = Entities.get(NetworkGroup.class);
                int index = ((String)input.getGroupNames().get(0)).lastIndexOf("-");
                String truncatedSecGroup = (String)((String)input.getGroupNames().get(0)).subSequence(0, index);
                String orphanedSecGrp = truncatedSecGroup.concat("-orphaned");
                try {
                    NetworkGroup found = NetworkGroups.lookup((OwnerFullName)userFullName, orphanedSecGrp);
                    networks.add(found);
                    restore.commit();
                }
                catch (NoSuchMetadataException ex) {
                    try {
                        NetworkGroup restoredGroup = NetworkGroups.create((OwnerFullName)userFullName, orphanedSecGrp, orphanedSecGrp);
                        networks.add(restoredGroup);
                    }
                    catch (Exception e) {
                        LOG.debug((Object)("Failed to restored security group : " + orphanedSecGrp));
                        restore.rollback();
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)("Failed to restore security group : " + orphanedSecGrp + " for InstanceID : " + input.getInstanceId() + " User Name  : " + userFullName + " because of: " + e.getMessage()));
                    restore.rollback();
                }
                finally {
                    if (restore.isActive()) {
                        restore.rollback();
                    }
                }
            }
            return networks;
        }

        private static byte[] restoreUserData(VmInfo input) {
            byte[] userData = new byte[]{};
            if (Strings.emptyToNull((String)input.getUserData()) != null) {
                try {
                    userData = Base64.decode((String)input.getUserData());
                }
                catch (Exception ex) {
                    LOG.error((Object)("Failed to restore user data for : " + input.getInstanceId() + " because of: " + ex.getMessage()));
                }
            }
            return userData;
        }

        private static SshKeyPair restoreSshKeyPair(VmInfo input, UserFullName userFullName) {
            String keyValue = input.getKeyValue();
            if (keyValue == null || keyValue.indexOf("@") == -1) {
                return KeyPairs.noKey();
            }
            String keyName = keyValue.replaceAll(".*@eucalyptus\\.", "");
            return SshKeyPair.withPublicKey(null, keyName, keyValue);
        }

        private static int restoreLaunchIndex(VmInfo input) {
            int launchIndex = 1;
            try {
                launchIndex = Integer.parseInt(input.getLaunchIndex());
            }
            catch (Exception ex1) {
                LOG.debug((Object)("Failed to get LaunchIndex setting it to '1' for: " + input.getInstanceId() + " because of: " + ex1.getMessage()));
                launchIndex = 1;
            }
            return launchIndex;
        }

        @Nonnull
        private static Emis.BootableSet restoreBootSet(@Nonnull VmInfo input, @Nullable String imageId, @Nullable String kernelId, @Nullable String ramdiskId) throws MetadataException {
            Emis.BootableSet bootSet;
            if (imageId == null) {
                throw new MetadataException("Missing image id for boot set restoration");
            }
            try {
                bootSet = Emis.recreateBootableSet(imageId, kernelId, ramdiskId);
            }
            catch (NoSuchImageIdException | NoSuchMetadataException e) {
                ImageMetadata.Platform platform;
                LOG.error((Object)("Using transient bootset in place of imageId " + imageId + ", kernelId " + kernelId + ", ramdiskId " + ramdiskId + " for " + input.getInstanceId() + " because of: " + e.getMessage()));
                try {
                    platform = ImageMetadata.Platform.valueOf((String)Strings.nullToEmpty((String)input.getPlatform()));
                }
                catch (IllegalArgumentException e2) {
                    platform = ImageMetadata.Platform.linux;
                }
                bootSet = Emis.unavailableBootableSet(platform);
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to recreate bootset with imageId " + imageId + ", kernelId " + kernelId + ", ramdiskId " + ramdiskId + " for " + input.getInstanceId() + " because of: " + ex.getMessage()));
                Logs.extreme().error((Object)ex, (Throwable)ex);
                if (ex instanceof MetadataException) {
                    throw (MetadataException)ex;
                }
                throw Exceptions.toUndeclared((Throwable)ex);
            }
            return bootSet;
        }

        private static String restoreRamdisk(VmInfo input) {
            String ramdiskId = null;
            try {
                ramdiskId = input.getInstanceType().lookupRamdisk().getId();
            }
            catch (NoSuchElementException ex) {
                LOG.debug((Object)("No ramdiskId " + input.getRamdiskId() + " for: " + input.getInstanceId() + " because vbr does not contain a ramdisk: " + input.getInstanceType().getVirtualBootRecord()));
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to lookup ramdiskId " + input.getRamdiskId() + " for: " + input.getInstanceId() + " because of: " + ex.getMessage()));
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            return ramdiskId;
        }

        private static String restoreKernel(VmInfo input) {
            String kernelId = null;
            try {
                kernelId = input.getInstanceType().lookupKernel().getId();
            }
            catch (NoSuchElementException ex) {
                LOG.debug((Object)("No kernelId " + input.getKernelId() + " for: " + input.getInstanceId() + " because vbr does not contain a kernel: " + input.getInstanceType().getVirtualBootRecord()));
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to lookup kernelId " + input.getKernelId() + " for: " + input.getInstanceId() + " because of: " + ex.getMessage()));
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            return kernelId;
        }

        private static String restoreImage(VmInfo input) {
            String imageId = null;
            try {
                imageId = input.getInstanceType().lookupRoot().getId();
            }
            catch (Exception ex2) {
                LOG.error((Object)("Failed to lookup imageId " + input.getImageId() + " for: " + input.getInstanceId() + " because of: " + ex2.getMessage()));
                Logs.extreme().error((Object)ex2, (Throwable)ex2);
            }
            return imageId;
        }

        private static Partition restorePartition(VmInfo input) {
            Partition partition = null;
            try {
                partition = Partitions.lookupByName((String)input.getPlacement());
            }
            catch (Exception ex2) {
                try {
                    partition = Partitions.lookupByName((String)((Cluster)Clusters.getInstance().lookup(input.getPlacement())).getPartition());
                }
                catch (Exception ex) {
                    LOG.error((Object)("Failed to lookup partition " + input.getPlacement() + " for: " + input.getInstanceId() + " because of: " + ex.getMessage()));
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }
            return partition;
        }

        private static VmType restoreVmType(VmInfo input) {
            VmType vmType = null;
            try {
                vmType = VmTypes.lookup(input.getInstanceType().getName());
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to lookup vm type " + input.getInstanceType().getName() + " for: " + input.getInstanceId() + " because of: " + ex.getMessage()));
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            return vmType;
        }
    }

    private static enum ValidateVmInfo implements Predicate<VmInfo>
    {
        INSTANCE;


        public boolean apply(VmInfo arg0) {
            if (arg0.getGroupNames().isEmpty()) {
                LOG.warn((Object)("Instance " + arg0.getInstanceId() + " reported no groups: " + arg0.getGroupNames()));
            }
            if (arg0.getInstanceType().getName() == null) {
                LOG.warn((Object)("Instance " + arg0.getInstanceId() + " reported no instance type: " + arg0.getInstanceType()));
            }
            if (arg0.getInstanceType().getVirtualBootRecord().isEmpty()) {
                LOG.warn((Object)("Instance " + arg0.getInstanceId() + " reported no vbr entries: " + arg0.getInstanceType().getVirtualBootRecord()));
                return false;
            }
            try {
                VirtualBootRecord virtualBootRecord = arg0.getInstanceType().lookupRoot();
            }
            catch (NoSuchElementException ex) {
                LOG.warn((Object)("Instance " + arg0.getInstanceId() + " reported no root vbr entry: " + arg0.getInstanceType().getVirtualBootRecord()));
                return false;
            }
            try {
                Topology.lookup(ClusterController.class, (Partition[])new Partition[]{((Cluster)Clusters.getInstance().lookup(arg0.getPlacement())).lookupPartition()});
            }
            catch (NoSuchElementException ex) {
                return false;
            }
            return true;
        }
    }

    public static enum VmState implements Predicate<VmInstance>
    {
        PENDING(0),
        RUNNING(16),
        SHUTTING_DOWN(32),
        TERMINATED(48),
        STOPPING(64),
        STOPPED(80),
        BURIED(128, TERMINATED);

        private final String name = this.name().toLowerCase().replace("_", "-");
        private final int code;
        private final VmState displayState;

        private VmState(int code) {
            this(code, null);
        }

        private VmState(int code, VmState displayState) {
            this.code = code;
            this.displayState = (VmState)((Object)Objects.firstNonNull((Object)((Object)displayState), (Object)((Object)this)));
        }

        public String getName() {
            return this.name;
        }

        public int getCode() {
            return this.code;
        }

        public VmState getDisplayState() {
            return this.displayState;
        }

        public boolean apply(VmInstance arg0) {
            return this.equals(arg0.getState());
        }

        public Predicate<VmInstance> not() {
            return Predicates.not((Predicate)this);
        }

        public static class Mapper {
            private static Map<String, VmState> stateMap = Mapper.getStateMap();

            private static Map<String, VmState> getStateMap() {
                HashMap<String, VmState> map = new HashMap<String, VmState>();
                map.put("Extant", RUNNING);
                map.put("Pending", PENDING);
                map.put("Teardown", SHUTTING_DOWN);
                return map;
            }

            public static VmState get(String stateName) {
                return stateMap.get(stateName);
            }
        }
    }

    public static enum VmStateSet implements Predicate<VmInstance>
    {
        RUN(VmState.PENDING, VmState.RUNNING),
        CHANGING(new VmState[]{VmState.PENDING, VmState.STOPPING, VmState.SHUTTING_DOWN}){

            @Override
            public boolean apply(VmInstance arg0) {
                return super.apply(arg0) || !arg0.eachVolumeAttachment(new Predicate<VmVolumeAttachment>(){

                    public boolean apply(VmVolumeAttachment input) {
                        return !input.getAttachmentState().isVolatile();
                    }
                });
            }
        }
        ,
        EXPECTING_TEARDOWN(VmState.STOPPING, VmState.SHUTTING_DOWN),
        TORNDOWN(VmState.STOPPED, VmState.TERMINATED, VmState.BURIED),
        STOP(VmState.STOPPING, VmState.STOPPED),
        NOT_RUNNING(VmState.STOPPING, VmState.STOPPED, VmState.SHUTTING_DOWN, VmState.TERMINATED, VmState.BURIED),
        DONE(VmState.TERMINATED, VmState.BURIED);

        private final Set<VmState> states;

        private VmStateSet(VmState ... states) {
            this.states = Collections.unmodifiableSet(EnumSet.copyOf(Sets.newHashSet((Object[])states)));
        }

        public boolean apply(VmInstance arg0) {
            return this.states.contains(arg0.getState());
        }

        public boolean contains(VmState state) {
            return this.states.contains((Object)state);
        }

        public Predicate<VmInstance> not() {
            return Predicates.not((Predicate)this);
        }

        public Set<VmState> set() {
            return this.states;
        }

        public VmState[] array() {
            return this.states.toArray(new VmState[this.states.size()]);
        }
    }

    public static enum Filters implements Predicate<VmInstance>
    {
        BUNDLING{

            public boolean apply(VmInstance arg0) {
                return arg0.getRuntimeState().isBundling();
            }
        };

    }
}

