/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.vm.VmInstance;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.hibernate.annotations.Parent;

@Embeddable
public class VmId {
    @Parent
    private VmInstance vmInstance;
    @Column(name="metadata_vm_reservation_id")
    private String reservationId;
    @Column(name="metadata_vm_client_token", updatable=false)
    private String clientToken;
    @Column(name="metadata_vm_client_token_unique", unique=true, updatable=false)
    private String uniqueClientToken;
    @Column(name="metadata_vm_instance_id")
    private String instanceId;

    VmId() {
    }

    VmId(String reservationId, String instanceId, String clientToken, String uniqueClientToken) {
        this.reservationId = reservationId;
        this.clientToken = clientToken;
        this.uniqueClientToken = uniqueClientToken;
        this.instanceId = instanceId;
    }

    private VmInstance getVmInstance() {
        return this.vmInstance;
    }

    public String getReservationId() {
        return this.reservationId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getUniqueClientToken() {
        return this.uniqueClientToken;
    }

    private void setVmInstance(VmInstance vmInstance) {
        this.vmInstance = vmInstance;
    }

    private void setReservationId(String reservationId) {
        this.reservationId = reservationId;
    }

    private void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    private void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    private void setUniqueClientToken(String uniqueClientToken) {
        this.uniqueClientToken = uniqueClientToken;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VmId:");
        if (this.reservationId != null) {
            builder.append("reservationId=").append(this.reservationId).append(":");
        }
        if (this.clientToken != null) {
            builder.append("clientToken=").append(this.clientToken).append(":");
        }
        if (this.instanceId != null) {
            builder.append("instanceId=").append(this.instanceId);
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VmId other = (VmId)obj;
        return !(this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId));
    }
}

