/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.vm.VmInstance;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.hibernate.annotations.Parent;

@Embeddable
public class VmEphemeralAttachment
implements Comparable<VmEphemeralAttachment> {
    @Parent
    private VmInstance vmInstance;
    @Column(name="metadata_vm_ephemeral_id")
    private String ephemeralId;
    @Column(name="metadata_vm_device")
    private String device;

    public VmInstance getVmInstance() {
        return this.vmInstance;
    }

    public void setVmInstance(VmInstance vmInstance) {
        this.vmInstance = vmInstance;
    }

    public String getEphemeralId() {
        return this.ephemeralId;
    }

    public void setEphemeralId(String ephemeralId) {
        this.ephemeralId = ephemeralId;
    }

    public String getDevice() {
        return this.device;
    }

    public String getShortDeviceName() {
        return this.device.startsWith("/dev/") ? this.device.substring(5) : this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    VmEphemeralAttachment() {
    }

    public VmEphemeralAttachment(VmInstance vmInstance, String ephemeralId, String device) {
        this.vmInstance = vmInstance;
        this.ephemeralId = ephemeralId;
        this.device = device;
    }

    @Override
    public int compareTo(VmEphemeralAttachment that) {
        return this.device.compareToIgnoreCase(that.device);
    }
}

