/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.vm.VmCreateImageSnapshot;
import com.eucalyptus.vm.VmInstance;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parent;

public class VmCreateImageTask {
    @Parent
    private VmInstance vmInstance;
    @Column(name="metadata_vm_createimage_state")
    private String state;
    @Column(name="metadata_vm_createimage_start_time")
    private Date startTime;
    @Column(name="metadata_vm_createimage_update_time")
    private Date updateTime;
    @Column(name="metadata_vm_createimage_progress")
    private String progress;
    @Column(name="metadata_vm_createimage_error_msg")
    private String errorMessage;
    @Column(name="metadata_vm_createimage_error_code")
    private String errorCode;
    @Column(name="metadata_vm_createimage_image_id")
    private String imageId;
    @ElementCollection
    @CollectionTable(name="metadata_instances_createimage_snapshots")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<VmCreateImageSnapshot> snapshots = Sets.newHashSet();
    @Column(name="metadata_vm_createimage_no_reboot")
    private Boolean noReboot;

    VmCreateImageTask() {
    }

    VmCreateImageTask(VmInstance vmInstance, String state, Date startTime, Date updateTime, String progress, String errorMessage, String errorCode, String imageId, Boolean noReboot) {
        this.vmInstance = vmInstance;
        this.state = state;
        this.startTime = startTime;
        this.updateTime = updateTime;
        this.progress = progress;
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
        this.imageId = imageId;
        this.noReboot = noReboot;
    }

    private VmInstance getVmInstance() {
        return this.vmInstance;
    }

    private void setVmInstance(VmInstance vmInstance) {
        this.vmInstance = vmInstance;
    }

    CreateImageState getState() {
        return (CreateImageState)((Object)CreateImageState.mapper.apply((Object)this.state));
    }

    void setState(CreateImageState state) {
        this.state = state.toString();
    }

    private Date getStartTime() {
        return this.startTime;
    }

    private void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    private Date getUpdateTime() {
        return this.updateTime;
    }

    void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    private String getProgress() {
        return this.progress;
    }

    private void setProgress(String progress) {
        this.progress = progress;
    }

    private String getErrorMessage() {
        return this.errorMessage;
    }

    private void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    private String getErrorCode() {
        return this.errorCode;
    }

    private void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public void addSnapshot(String deviceName, String snapshotId, Boolean isRootDevice, Boolean deleteOnTerminate) {
        VmCreateImageSnapshot newSnapshot = new VmCreateImageSnapshot(deviceName, snapshotId, isRootDevice, deleteOnTerminate);
        this.snapshots.add(newSnapshot);
    }

    public Set<VmCreateImageSnapshot> getSnapshots() {
        return this.snapshots;
    }

    public Boolean getNoReboot() {
        return this.noReboot;
    }

    public void setNoReboot(Boolean noReboot) {
        this.noReboot = noReboot;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vmInstance == null ? 0 : this.vmInstance.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VmCreateImageTask other = (VmCreateImageTask)obj;
        return !(this.vmInstance == null ? other.vmInstance != null : !this.vmInstance.equals((Object)other.vmInstance));
    }

    public static enum CreateImageState {
        none("none"),
        pending("pending"),
        guest_stopping("stopping"),
        creating_snapshot("snapshotting"),
        guest_starting("starting"),
        complete("complete"),
        failed("failed");

        private String strState = null;
        public static Function<String, CreateImageState> mapper;

        private CreateImageState(String state) {
            this.strState = state;
        }

        public String toString() {
            return this.strState;
        }

        static {
            mapper = new Function<String, CreateImageState>(){

                public CreateImageState apply(String input) {
                    for (CreateImageState s : CreateImageState.values()) {
                        if (s.toString() == null || !s.toString().equals(input)) continue;
                        return s;
                    }
                    return none;
                }
            };
        }
    }
}

