/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.auth.AccessKeys;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.blockstorage.Volumes;
import com.eucalyptus.cloud.ResourceToken;
import com.eucalyptus.cloud.VmInstanceLifecycleHelpers;
import com.eucalyptus.cloud.run.AdmissionControl;
import com.eucalyptus.cloud.run.Allocations;
import com.eucalyptus.cloud.run.ClusterAllocator;
import com.eucalyptus.cloud.run.ContractEnforcement;
import com.eucalyptus.cloud.run.VerifyMetadata;
import com.eucalyptus.cloud.util.IllegalMetadataAccessException;
import com.eucalyptus.cloud.util.InvalidMetadataException;
import com.eucalyptus.cloud.util.InvalidParameterCombinationMetadataException;
import com.eucalyptus.cloud.util.NoSuchImageIdException;
import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.cloud.util.NotEnoughResourcesException;
import com.eucalyptus.cloud.util.SecurityGroupLimitMetadataException;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.cluster.callback.RebootCallback;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.compute.ClientComputeException;
import com.eucalyptus.compute.ClientUnauthorizedComputeException;
import com.eucalyptus.compute.ComputeException;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.Filter;
import com.eucalyptus.compute.common.GroupItemType;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.InstanceBlockDeviceMapping;
import com.eucalyptus.compute.common.InstanceBlockDeviceMappingItemType;
import com.eucalyptus.compute.common.InstanceStatusItemType;
import com.eucalyptus.compute.common.MonitorInstanceState;
import com.eucalyptus.compute.common.ReservationInfoType;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.SecurityGroupIdSetItemType;
import com.eucalyptus.compute.common.TerminateInstancesItemType;
import com.eucalyptus.compute.common.backend.CreatePlacementGroupResponseType;
import com.eucalyptus.compute.common.backend.CreatePlacementGroupType;
import com.eucalyptus.compute.common.backend.DeletePlacementGroupResponseType;
import com.eucalyptus.compute.common.backend.DeletePlacementGroupType;
import com.eucalyptus.compute.common.backend.DescribeInstanceAttributeResponseType;
import com.eucalyptus.compute.common.backend.DescribeInstanceAttributeType;
import com.eucalyptus.compute.common.backend.DescribeInstanceStatusResponseType;
import com.eucalyptus.compute.common.backend.DescribeInstanceStatusType;
import com.eucalyptus.compute.common.backend.DescribeInstancesResponseType;
import com.eucalyptus.compute.common.backend.DescribeInstancesType;
import com.eucalyptus.compute.common.backend.DescribePlacementGroupsResponseType;
import com.eucalyptus.compute.common.backend.DescribePlacementGroupsType;
import com.eucalyptus.compute.common.backend.GetConsoleOutputResponseType;
import com.eucalyptus.compute.common.backend.GetConsoleOutputType;
import com.eucalyptus.compute.common.backend.GetPasswordDataResponseType;
import com.eucalyptus.compute.common.backend.GetPasswordDataType;
import com.eucalyptus.compute.common.backend.ModifyInstanceAttributeResponseType;
import com.eucalyptus.compute.common.backend.ModifyInstanceAttributeType;
import com.eucalyptus.compute.common.backend.MonitorInstancesResponseType;
import com.eucalyptus.compute.common.backend.MonitorInstancesType;
import com.eucalyptus.compute.common.backend.RebootInstancesResponseType;
import com.eucalyptus.compute.common.backend.RebootInstancesType;
import com.eucalyptus.compute.common.backend.ReportInstanceStatusResponseType;
import com.eucalyptus.compute.common.backend.ReportInstanceStatusType;
import com.eucalyptus.compute.common.backend.ResetInstanceAttributeResponseType;
import com.eucalyptus.compute.common.backend.ResetInstanceAttributeType;
import com.eucalyptus.compute.common.backend.RunInstancesResponseType;
import com.eucalyptus.compute.common.backend.RunInstancesType;
import com.eucalyptus.compute.common.backend.StartInstancesResponseType;
import com.eucalyptus.compute.common.backend.StartInstancesType;
import com.eucalyptus.compute.common.backend.StopInstancesResponseType;
import com.eucalyptus.compute.common.backend.StopInstancesType;
import com.eucalyptus.compute.common.backend.TerminateInstancesResponseType;
import com.eucalyptus.compute.common.backend.TerminateInstancesType;
import com.eucalyptus.compute.common.backend.UnmonitorInstancesResponseType;
import com.eucalyptus.compute.common.backend.UnmonitorInstancesType;
import com.eucalyptus.compute.identifier.InvalidResourceIdentifier;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.compute.vpc.NoSuchSubnetMetadataException;
import com.eucalyptus.compute.vpc.VpcRequiredMetadataException;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.crypto.Hmac;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.images.BlockStorageImageInfo;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.images.Images;
import com.eucalyptus.images.KernelImageInfo;
import com.eucalyptus.images.RamdiskImageInfo;
import com.eucalyptus.keys.NoSuchKeyMetadataException;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.tracking.MessageContexts;
import com.eucalyptus.tags.Filters;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.RemoteCallback;
import com.eucalyptus.util.async.Request;
import com.eucalyptus.vm.BundleInstanceResponseType;
import com.eucalyptus.vm.BundleInstanceType;
import com.eucalyptus.vm.Bundles;
import com.eucalyptus.vm.CancelBundleTaskResponseType;
import com.eucalyptus.vm.CancelBundleTaskType;
import com.eucalyptus.vm.DescribeBundleTasksResponseType;
import com.eucalyptus.vm.DescribeBundleTasksType;
import com.eucalyptus.vm.MigrationState;
import com.eucalyptus.vm.NetworkGroupId;
import com.eucalyptus.vm.VmBundleTask;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import com.eucalyptus.ws.util.HmacUtils;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.ClusterGetConsoleOutputResponseType;
import edu.ucsb.eucalyptus.msgs.ClusterGetConsoleOutputType;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.EntityTransaction;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class VmControl {
    private static Logger LOG = Logger.getLogger(VmControl.class);

    public static RunInstancesResponseType runInstances(RunInstancesType request) throws Exception {
        RunInstancesResponseType reply = (RunInstancesResponseType)request.getReply();
        Allocations.Allocation allocInfo = Allocations.run(request);
        EntityTransaction db = Entities.get(VmInstance.class);
        try {
            List<VmInstance> instances;
            if (!Strings.isNullOrEmpty((String)allocInfo.getClientToken()) && !(instances = VmInstances.listByClientToken((OwnerFullName)allocInfo.getOwnerFullName().asAccountFullName(), allocInfo.getClientToken(), (Predicate<? super VmInstance>)RestrictedTypes.filterPrivileged())).isEmpty()) {
                VmInstance vm = instances.get(0);
                ReservationInfoType reservationInfoType = (ReservationInfoType)TypeMappers.transform((Object)((Object)vm), ReservationInfoType.class);
                for (VmInstance instance : instances) {
                    reservationInfoType.getInstancesSet().add(VmInstances.transform(instance));
                }
                reply.setRsvInfo(reservationInfoType);
                RunInstancesResponseType i$ = reply;
                return i$;
            }
            Predicates.and((Predicate[])new Predicate[]{VerifyMetadata.getVerifiers(), AdmissionControl.run(), ContractEnforcement.run(), VerifyMetadata.getPostVerifiers()}).apply((Object)allocInfo);
            allocInfo.commit();
            ReservationInfoType reservation = new ReservationInfoType(allocInfo.getReservationId(), allocInfo.getOwnerFullName().getAccountNumber(), Collections2.transform(allocInfo.getNetworkGroups(), (Function)TypeMappers.lookup(NetworkGroup.class, GroupItemType.class)));
            reply.setRsvInfo(reservation);
            for (ResourceToken allocToken : allocInfo.getAllocationTokens()) {
                reservation.getInstancesSet().add(VmInstances.transform(allocToken.getVmInstance()));
            }
            db.commit();
        }
        catch (Exception ex) {
            allocInfo.abort();
            VerifyMetadata.ImageInstanceTypeVerificationException e1 = (VerifyMetadata.ImageInstanceTypeVerificationException)Exceptions.findCause((Throwable)ex, VerifyMetadata.ImageInstanceTypeVerificationException.class);
            if (e1 != null) {
                throw new ClientComputeException("InvalidParameterCombination", e1.getMessage());
            }
            NotEnoughResourcesException e2 = (NotEnoughResourcesException)Exceptions.findCause((Throwable)ex, NotEnoughResourcesException.class);
            if (e2 != null) {
                throw new ComputeException("InsufficientInstanceCapacity", e2.getMessage());
            }
            NoSuchKeyMetadataException e3 = (NoSuchKeyMetadataException)Exceptions.findCause((Throwable)ex, NoSuchKeyMetadataException.class);
            if (e3 != null) {
                throw new ClientComputeException("InvalidKeyPair.NotFound", e3.getMessage());
            }
            InvalidMetadataException e4 = (InvalidMetadataException)Exceptions.findCause((Throwable)ex, InvalidMetadataException.class);
            if (e4 instanceof VpcRequiredMetadataException) {
                throw new ClientComputeException("VPCIdNotSpecified", "Default VPC not found, please specify a subnet.");
            }
            if (e4 instanceof InvalidParameterCombinationMetadataException) {
                throw new ClientComputeException("InvalidParameterCombination", e4.getMessage());
            }
            if (e4 != null) {
                throw new ClientComputeException("InvalidParameterValue", e4.getMessage());
            }
            NoSuchImageIdException e5 = (NoSuchImageIdException)Exceptions.findCause((Throwable)ex, NoSuchImageIdException.class);
            if (e5 != null) {
                throw new ClientComputeException("InvalidAMIID.NotFound", e5.getMessage());
            }
            NoSuchSubnetMetadataException e6 = (NoSuchSubnetMetadataException)Exceptions.findCause((Throwable)ex, NoSuchSubnetMetadataException.class);
            if (e6 != null) {
                throw new ClientComputeException("InvalidSubnetID.NotFound", e6.getMessage());
            }
            IllegalMetadataAccessException e7 = (IllegalMetadataAccessException)Exceptions.findCause((Throwable)ex, IllegalMetadataAccessException.class);
            if (e7 != null) {
                throw new ClientUnauthorizedComputeException(e7.getMessage());
            }
            SecurityGroupLimitMetadataException e8 = (SecurityGroupLimitMetadataException)Exceptions.findCause((Throwable)ex, SecurityGroupLimitMetadataException.class);
            if (e8 != null) {
                throw new ClientComputeException("SecurityGroupLimitExceeded", "Security group limit exceeded");
            }
            LOG.error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
        MessageContexts.remember((String)allocInfo.getReservationId(), request.getClass(), (BaseMessage)request);
        for (ResourceToken allocToken : allocInfo.getAllocationTokens()) {
            MessageContexts.remember((String)allocToken.getInstanceId(), request.getClass(), (BaseMessage)request);
        }
        ClusterAllocator.get().apply((Object)allocInfo);
        return reply;
    }

    public DescribeInstancesResponseType describeInstances(DescribeInstancesType msg) throws EucalyptusCloudException {
        DescribeInstancesResponseType reply = (DescribeInstancesResponseType)msg.getReply();
        Context ctx = Contexts.lookup();
        boolean showAll = msg.getInstancesSet().remove("verbose") || !msg.getInstancesSet().isEmpty();
        TreeMultimap instanceMap = TreeMultimap.create();
        HashMap reservations = Maps.newHashMap();
        List<String> identifiers = VmControl.normalizeIdentifiers(msg.getInstancesSet());
        com.eucalyptus.tags.Filter filter = Filters.generateFor(msg.getFilterSet(), VmInstance.class).withOptionalInternalFilter("instance-id", identifiers).generate();
        Predicate requestedAndAccessible = CloudMetadatas.filteringFor(VmInstance.class).byId(identifiers).byPredicate(filter.asPredicate()).byPrivileges().buildPredicate();
        Criterion criterion = filter.asCriterionWithConjunction(Restrictions.not((Criterion)VmInstances.criterion(VmInstance.VmState.BURIED)));
        AccountFullName ownerFullName = ctx.isAdministrator() && showAll ? null : ctx.getUserFullName().asAccountFullName();
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            List<VmInstance> instances = VmInstances.list((OwnerFullName)ownerFullName, criterion, filter.getAliases(), (Predicate<? super VmInstance>)requestedAndAccessible);
            Map<String, List<Tag>> tagsMap = TagSupport.forResourceClass(VmInstance.class).getResourceTagMap((OwnerFullName)AccountFullName.getInstance((Account)ctx.getAccount(), (String[])new String[0]), Iterables.transform(instances, (Function)CloudMetadatas.toDisplayName()));
            for (VmInstance vm : instances) {
                if (!instanceMap.put((Object)vm.getReservationId(), (Object)VmInstances.transform(vm)) || reservations.containsKey(vm.getReservationId())) continue;
                reservations.put(vm.getReservationId(), TypeMappers.transform((Object)((Object)vm), ReservationInfoType.class));
            }
            ArrayList replyReservations = reply.getReservationSet();
            for (ReservationInfoType r : reservations.values()) {
                Collection instanceSet = instanceMap.get((Object)r.getReservationId());
                if (instanceSet.isEmpty()) continue;
                for (RunningInstancesItemType instancesItemType : instanceSet) {
                    Tags.addFromTags(instancesItemType.getTagSet(), ResourceTag.class, (Iterable<Tag>)tagsMap.get(instancesItemType.getInstanceId()));
                }
                r.getInstancesSet().addAll(instanceSet);
                replyReservations.add(r);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            LOG.debug((Object)e, (Throwable)e);
            throw new EucalyptusCloudException(e.getMessage());
        }
        return reply;
    }

    public DescribeInstanceStatusResponseType describeInstanceStatus(DescribeInstanceStatusType msg) throws EucalyptusCloudException {
        DescribeInstanceStatusResponseType reply = (DescribeInstanceStatusResponseType)msg.getReply();
        Context ctx = Contexts.lookup();
        boolean showAll = msg.getInstancesSet().remove("verbose") || !msg.getInstancesSet().isEmpty();
        boolean includeAllInstances = (Boolean)Objects.firstNonNull((Object)msg.getIncludeAllInstances(), (Object)Boolean.FALSE);
        List<String> identifiers = VmControl.normalizeIdentifiers(msg.getInstancesSet());
        com.eucalyptus.tags.Filter filter = Filters.generateFor(msg.getFilterSet(), VmInstance.class, "status").withOptionalInternalFilter("instance-id", identifiers).generate();
        Predicate requestedAndAccessible = CloudMetadatas.filteringFor(VmInstance.class).byId(identifiers).byPredicate((Predicate)(includeAllInstances ? Predicates.alwaysTrue() : VmInstance.VmState.RUNNING)).byPredicate(filter.asPredicate()).byPrivileges().buildPredicate();
        Criterion criterion = filter.asCriterionWithConjunction(Restrictions.not((Criterion)VmInstances.criterion(VmInstance.VmState.BURIED)));
        AccountFullName ownerFullName = ctx.isAdministrator() && showAll ? null : ctx.getUserFullName().asAccountFullName();
        try {
            List<VmInstance> instances = VmInstances.list((OwnerFullName)ownerFullName, criterion, filter.getAliases(), (Predicate<? super VmInstance>)requestedAndAccessible);
            Iterables.addAll((Collection)reply.getInstanceStatusSet().getItem(), (Iterable)Iterables.transform(instances, (Function)TypeMappers.lookup(VmInstance.class, InstanceStatusItemType.class)));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            LOG.debug((Object)e, (Throwable)e);
            throw new EucalyptusCloudException(e.getMessage());
        }
        return reply;
    }

    public ReportInstanceStatusResponseType reportInstanceStatus(ReportInstanceStatusType request) {
        return (ReportInstanceStatusResponseType)request.getReply();
    }

    public TerminateInstancesResponseType terminateInstances(final TerminateInstancesType request) throws EucalyptusCloudException {
        TerminateInstancesResponseType reply = (TerminateInstancesResponseType)request.getReply();
        ArrayList<String> failedVmList = new ArrayList<String>();
        ArrayList<VmInstance> vmList = new ArrayList<VmInstance>();
        List<String> identifiers = VmControl.normalizeIdentifiers(request.getInstancesSet());
        for (String requestedInstanceId : identifiers) {
            try {
                VmInstance vm = (VmInstance)RestrictedTypes.doPrivileged((String)requestedInstanceId, VmInstance.class);
                vmList.add(vm);
            }
            catch (AuthException | NoSuchElementException e) {
                failedVmList.add(requestedInstanceId);
            }
            catch (Exception e) {
                LOG.error((Object)("Error looking up instance for termination: " + requestedInstanceId), (Throwable)e);
                failedVmList.add(requestedInstanceId);
            }
        }
        if (!failedVmList.isEmpty()) {
            if (failedVmList.size() > 1) {
                throw new ClientComputeException("InvalidInstanceID.NotFound", "The instance IDs '" + Joiner.on((String)", ").join(failedVmList) + "' do not exist");
            }
            throw new ClientComputeException("InvalidInstanceID.NotFound", "The instance ID '" + Joiner.on((String)", ").join(failedVmList) + "' does not exist");
        }
        try {
            ArrayList results = reply.getInstancesSet();
            Function<VmInstance, TerminateInstancesItemType> terminateFunction = new Function<VmInstance, TerminateInstancesItemType>(){

                public TerminateInstancesItemType apply(VmInstance vm) {
                    String newState = null;
                    int newCode = 0;
                    TerminateInstancesItemType result = null;
                    try {
                        if (MigrationState.isMigrating(vm)) {
                            throw Exceptions.toUndeclared((String)("Cannot terminate an instance which is currently migrating: " + vm.getInstanceId() + " " + vm.getMigrationTask()), (Throwable[])new Throwable[0]);
                        }
                        int oldCode = ((VmInstance.VmState)vm.getState()).getCode();
                        String oldState = ((VmInstance.VmState)vm.getState()).getName();
                        if (VmInstance.VmState.STOPPED.apply(vm)) {
                            newCode = VmInstance.VmState.TERMINATED.getCode();
                            newState = VmInstance.VmState.TERMINATED.getName();
                            VmInstances.terminated(vm);
                        } else if (VmInstance.VmStateSet.RUN.apply(vm)) {
                            newCode = VmInstance.VmState.SHUTTING_DOWN.getCode();
                            newState = VmInstance.VmState.SHUTTING_DOWN.getName();
                            VmInstances.shutDown(vm);
                        } else if (VmInstance.VmState.SHUTTING_DOWN.apply(vm)) {
                            newCode = VmInstance.VmState.SHUTTING_DOWN.getCode();
                            newState = VmInstance.VmState.SHUTTING_DOWN.getName();
                        } else if (VmInstance.VmStateSet.DONE.apply(vm)) {
                            oldCode = newCode = VmInstance.VmState.TERMINATED.getCode();
                            oldState = newState = VmInstance.VmState.TERMINATED.getName();
                            VmInstances.buried(vm);
                        }
                        MessageContexts.remember((String)vm.getInstanceId(), request.getClass(), (BaseMessage)request);
                        result = new TerminateInstancesItemType((Object)vm.getInstanceId(), (Object)oldCode, (Object)oldState, (Object)newCode, (Object)newState);
                    }
                    catch (VmInstances.TerminatedInstanceException e) {
                        int oldCode = newCode = VmInstance.VmState.TERMINATED.getCode();
                        String oldState = newState = VmInstance.VmState.TERMINATED.getName();
                        try {
                            VmInstances.buried(vm.getInstanceId());
                        }
                        catch (TransactionException e1) {
                            throw Exceptions.toUndeclared((Throwable)e1);
                        }
                        result = new TerminateInstancesItemType((Object)vm.getInstanceId(), (Object)oldCode, (Object)oldState, (Object)newCode, (Object)newState);
                    }
                    catch (NoSuchElementException e) {
                        LOG.debug((Object)("Ignoring terminate request for non-existent instance: " + vm.getInstanceId()));
                    }
                    catch (Exception e) {
                        throw Exceptions.toUndeclared((Throwable)e);
                    }
                    return result;
                }
            };
            Function terminateTx = Entities.asTransaction(VmInstance.class, (Function)terminateFunction, (int)10);
            for (VmInstance vm : vmList) {
                try {
                    TerminateInstancesItemType termInstance = (TerminateInstancesItemType)terminateTx.apply((Object)vm);
                    if (termInstance == null) continue;
                    results.add(termInstance);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }
            reply.set_return(Boolean.valueOf(!reply.getInstancesSet().isEmpty()));
            return reply;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            LOG.debug((Object)e, e);
            throw new EucalyptusCloudException(e.getMessage());
        }
    }

    public RebootInstancesResponseType rebootInstances(RebootInstancesType request) throws EucalyptusCloudException {
        RebootInstancesResponseType reply = (RebootInstancesResponseType)request.getReply();
        try {
            List<String> instanceSet = VmControl.normalizeIdentifiers(request.getInstancesSet());
            ArrayList<String> noAccess = new ArrayList<String>();
            ArrayList<String> migrating = new ArrayList<String>();
            ArrayList<String> noSuchElement = new ArrayList<String>();
            for (int i = 0; i < instanceSet.size(); ++i) {
                String outList;
                String currentInstance = instanceSet.get(i);
                try {
                    VmInstance v = VmInstances.lookup(currentInstance);
                    if (!RestrictedTypes.filterPrivileged().apply((Object)v)) {
                        noAccess.add(currentInstance);
                    }
                    if (MigrationState.isMigrating(v)) {
                        migrating.add(currentInstance);
                    }
                }
                catch (NoSuchElementException nse) {
                    if (!(nse instanceof VmInstances.TerminatedInstanceException)) {
                        noSuchElement.add(currentInstance);
                    }
                    instanceSet.remove(i--);
                }
                if (i == instanceSet.size() - 1 && !noSuchElement.isEmpty()) {
                    outList = noSuchElement.toString();
                    throw new EucalyptusCloudException("No such instance(s): " + outList.substring(1, outList.length() - 1));
                }
                if (i == instanceSet.size() - 1 && !noAccess.isEmpty()) {
                    outList = noAccess.toString();
                    throw new EucalyptusCloudException("Permission denied for vm(s): " + outList.substring(1, outList.length() - 1));
                }
                if (i != instanceSet.size() - 1 || migrating.isEmpty()) continue;
                outList = noAccess.toString();
                throw new EucalyptusCloudException("Cannot reboot an instances which is currently migrating: " + outList.substring(1, outList.length() - 1));
            }
            boolean result = Iterables.all(instanceSet, (Predicate)new Predicate<String>(){

                public boolean apply(String instanceId) {
                    try {
                        VmInstance v = VmInstances.lookup(instanceId);
                        Request req = AsyncRequests.newRequest((RemoteCallback)new RebootCallback(v.getInstanceId()));
                        ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{v.lookupPartition()});
                        req.dispatch(ccConfig);
                        return true;
                    }
                    catch (NoSuchElementException e) {
                        return false;
                    }
                }
            });
            reply.set_return(Boolean.valueOf(result));
            return reply;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            LOG.debug((Object)e, (Throwable)e);
            throw new EucalyptusCloudException(e.getMessage());
        }
    }

    public GetConsoleOutputResponseType getConsoleOutput(GetConsoleOutputType request) throws EucalyptusCloudException {
        Cluster cluster;
        VmInstance v;
        String instanceId = VmControl.normalizeIdentifier(request.getInstanceId());
        try {
            v = VmInstances.lookup(instanceId);
        }
        catch (NoSuchElementException ex) {
            throw new ClientComputeException("InvalidInstanceID.NotFound", "The instance ID '" + instanceId + "' does not exist");
        }
        if (!RestrictedTypes.filterPrivileged().apply((Object)v)) {
            throw new EucalyptusCloudException("Permission denied for vm: " + instanceId);
        }
        if (!VmInstance.VmState.RUNNING.apply(v)) {
            throw new EucalyptusCloudException("Instance " + instanceId + " is not in a running state.");
        }
        try {
            ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{v.lookupPartition()});
            cluster = Clusters.lookup(ccConfig);
        }
        catch (NoSuchElementException e1) {
            throw new EucalyptusCloudException("Failed to find cluster info for '" + v.getPartition() + "' related to vm: " + instanceId);
        }
        try {
            ClusterGetConsoleOutputResponseType response = (ClusterGetConsoleOutputResponseType)AsyncRequests.sendSync((ServiceConfiguration)cluster.getConfiguration(), (BaseMessage)new ClusterGetConsoleOutputType(instanceId));
            GetConsoleOutputResponseType reply = (GetConsoleOutputResponseType)request.getReply();
            reply.setInstanceId(instanceId);
            reply.setTimestamp(response.getTimestamp());
            reply.setOutput(response.getOutput());
            return reply;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new ComputeException("InternalError", "Error processing request: " + e.getMessage());
        }
    }

    public DescribeBundleTasksResponseType describeBundleTasks(DescribeBundleTasksType request) throws EucalyptusCloudException {
        DescribeBundleTasksResponseType reply = (DescribeBundleTasksResponseType)request.getReply();
        boolean showAll = request.getBundleIds().remove("verbose") || !request.getBundleIds().isEmpty();
        com.eucalyptus.tags.Filter filter = Filters.generate(request.getFilterSet(), VmBundleTask.class);
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            Predicate filteredAndBundling = Predicates.and(filter.asPredicate(), (Predicate)VmBundleTask.Filters.BUNDLING);
            Collection<VmBundleTask> cachedValues = Bundles.getPreviousBundleTasks().values();
            Map<String, VmBundleTask> cachedBundles = VmControl.buildMap(Collections2.filter(cachedValues, (Predicate)filteredAndBundling));
            Predicate requestedAndAccessible = CloudMetadatas.filteringFor(VmInstance.class).byId(VmControl.toInstanceIds(request.getBundleIds())).byPrivileges().buildPredicate();
            Predicate filteredInstances = Predicates.compose(filter.asPredicate(), VmInstances.bundleTask());
            com.eucalyptus.tags.Filter noFilters = Filters.generate(new ArrayList<Filter>(), VmBundleTask.class);
            Context ctx = Contexts.lookup();
            AccountFullName ownerFullName = ctx.isAdministrator() && showAll ? null : ctx.getUserFullName().asAccountFullName();
            List<VmInstance> dbBundles = VmInstances.list((OwnerFullName)ownerFullName, noFilters.asCriterion(), noFilters.getAliases(), (Predicate<? super VmInstance>)requestedAndAccessible);
            for (VmInstance v : dbBundles) {
                if (filteredInstances.apply((Object)v) && VmInstance.Filters.BUNDLING.apply((Object)v)) {
                    LOG.debug((Object)("Getting current bundle for " + v.getInstanceId()));
                    reply.getBundleTasks().add(Bundles.transform(v.getRuntimeState().getBundleTask()));
                    continue;
                }
                if (VmInstance.Filters.BUNDLING.apply((Object)v) || !cachedBundles.containsKey(v.getInstanceId())) continue;
                LOG.debug((Object)("Getting previous bundle for " + v.getInstanceId()));
                reply.getBundleTasks().add(Bundles.transform(cachedBundles.get(v.getInstanceId())));
            }
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new EucalyptusCloudException((Throwable)ex);
        }
        return reply;
    }

    private static Map<String, VmBundleTask> buildMap(Collection<VmBundleTask> tasks) {
        HashMap map = Maps.newHashMap();
        for (VmBundleTask task : tasks) {
            map.put(task.getInstanceId(), task);
        }
        return map;
    }

    public UnmonitorInstancesResponseType unmonitorInstances(UnmonitorInstancesType request) throws EucalyptusCloudException {
        UnmonitorInstancesResponseType reply = (UnmonitorInstancesResponseType)request.getReply();
        List<String> instanceSet = VmControl.normalizeIdentifiers(request.getInstancesSet());
        ArrayList monitorFalseList = Lists.newArrayList();
        for (String inst : instanceSet) {
            MonitorInstanceState monitorInstanceState = new MonitorInstanceState();
            monitorInstanceState.setInstanceId(inst);
            monitorInstanceState.setMonitoringState("disabled");
            monitorFalseList.add(monitorInstanceState);
        }
        reply.setInstancesSet(SetMonitorFunction.INSTANCE.apply(monitorFalseList));
        return reply;
    }

    public StartInstancesResponseType startInstances(StartInstancesType request) throws Exception {
        StartInstancesResponseType reply = (StartInstancesResponseType)request.getReply();
        for (String instanceId : VmControl.normalizeIdentifiers(request.getInstancesSet())) {
            try {
                TransactionResource db = Entities.transactionFor(VmInstance.class);
                Throwable throwable = null;
                try {
                    VmInstance vm = (VmInstance)RestrictedTypes.doPrivileged((String)instanceId, VmInstance.class);
                    if (!VmInstance.VmState.STOPPED.equals(vm.getState())) continue;
                    Allocations.Allocation allocInfo = Allocations.start(vm);
                    VmInstanceLifecycleHelpers.get().prepareAllocation(vm, allocInfo);
                    try {
                        AdmissionControl.run().apply((Object)allocInfo);
                        for (ResourceToken resourceToken : allocInfo.getAllocationTokens()) {
                            VmInstanceLifecycleHelpers.get().startVmInstance(resourceToken, vm);
                        }
                        int oldCode = ((VmInstance.VmState)vm.getState()).getCode();
                        int newCode = VmInstance.VmState.PENDING.getCode();
                        String oldState = ((VmInstance.VmState)vm.getState()).getName();
                        String newState = VmInstance.VmState.PENDING.getName();
                        vm.setState(VmInstance.VmState.PENDING);
                        db.commit();
                        MessageContexts.remember((String)instanceId, request.getClass(), (BaseMessage)request);
                        ClusterAllocator.get().apply((Object)allocInfo);
                        reply.getInstancesSet().add(new TerminateInstancesItemType((Object)vm.getInstanceId(), (Object)oldCode, (Object)oldState, (Object)newCode, (Object)newState));
                    }
                    catch (Exception ex) {
                        db.rollback();
                        allocInfo.abort();
                        throw ex;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (db == null) continue;
                    if (throwable != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    db.close();
                }
            }
            catch (Exception ex1) {
                LOG.trace((Object)ex1, (Throwable)ex1);
                throw ex1;
            }
        }
        return reply;
    }

    public StopInstancesResponseType stopInstances(final StopInstancesType request) throws EucalyptusCloudException {
        StopInstancesResponseType reply = (StopInstancesResponseType)request.getReply();
        try {
            VmInstance vm;
            Context ctx = Contexts.lookup();
            final ArrayList results = reply.getInstancesSet();
            Predicate<String> stopPredicate = new Predicate<String>(){

                public boolean apply(String instanceId) {
                    try {
                        VmInstance v = VmInstances.lookup(instanceId);
                        if (RestrictedTypes.filterPrivileged().apply((Object)v) && !MigrationState.isMigrating(v) && v.getBootRecord().getMachine() instanceof BlockStorageImageInfo) {
                            int oldCode = ((VmInstance.VmState)v.getState()).getCode();
                            int newCode = VmInstance.VmState.STOPPING.getCode();
                            String oldState = ((VmInstance.VmState)v.getState()).getName();
                            String newState = VmInstance.VmState.STOPPING.getName();
                            TerminateInstancesItemType termInfo = new TerminateInstancesItemType((Object)v.getInstanceId(), (Object)oldCode, (Object)oldState, (Object)newCode, (Object)newState);
                            if (!results.contains(termInfo)) {
                                results.add(termInfo);
                            }
                            VmInstances.stopped(v);
                        }
                        MessageContexts.remember((String)instanceId, request.getClass(), (BaseMessage)request);
                        return true;
                    }
                    catch (NoSuchElementException e) {
                        try {
                            VmInstances.stopped(instanceId);
                            return true;
                        }
                        catch (NoSuchElementException e1) {
                            return true;
                        }
                        catch (TransactionException ex) {
                            Logs.extreme().error((Object)ex, (Throwable)ex);
                            return true;
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex);
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                        throw Exceptions.toUndeclared((Throwable)ex);
                    }
                }
            };
            List<String> identifiers = VmControl.normalizeIdentifiers(request.getInstancesSet());
            for (String instanceId : identifiers) {
                try {
                    vm = VmInstances.lookup(instanceId);
                    if (vm.isBlockStorage()) continue;
                    throw new ClientComputeException("UnsupportedOperation", String.format("The instance '%s' does not have an 'ebs' root device type and cannot be stopped.", instanceId));
                }
                catch (VmInstances.TerminatedInstanceException ex) {
                    throw new ClientComputeException("IncorrectInstanceState", String.format("This instance '%s' is not in a state from which it can be stopped.", instanceId));
                }
                catch (NoSuchElementException ex) {
                    throw new ClientComputeException("InvalidInstanceID.NotFound", String.format("The instance ID '%s' does not exist", instanceId));
                }
            }
            for (String instanceId : identifiers) {
                vm = VmInstances.lookup(instanceId);
                if (!ImageMetadata.Platform.windows.name().equals(vm.getPlatform())) continue;
                TransactionResource db = Entities.transactionFor(VmInstance.class);
                Throwable throwable = null;
                try {
                    try {
                        VmInstance updatedVm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)vm)));
                        updatedVm.updatePasswordData(null);
                        Entities.persist((Object)((Object)updatedVm));
                        db.commit();
                    }
                    catch (Exception ex) {
                        throw new EucalyptusCloudException("Failed to erase Windows password");
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (db == null) continue;
                    if (throwable != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    db.close();
                }
            }
            Predicate stopTx = Entities.asTransaction(VmInstance.class, (Predicate)stopPredicate);
            Iterables.all(identifiers, (Predicate)stopTx);
            reply.set_return(Boolean.valueOf(!reply.getInstancesSet().isEmpty()));
            return reply;
        }
        catch (EucalyptusCloudException ex) {
            throw ex;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            LOG.debug((Object)e, e);
            throw new EucalyptusCloudException(e.getMessage());
        }
    }

    public ResetInstanceAttributeResponseType resetInstanceAttribute(ResetInstanceAttributeType request) throws EucalyptusCloudException {
        ResetInstanceAttributeResponseType reply;
        block26: {
            reply = (ResetInstanceAttributeResponseType)request.getReply();
            String instanceId = VmControl.normalizeIdentifier(request.getInstanceId());
            try (TransactionResource tx = Entities.transactionFor(VmInstance.class);){
                VmInstance vm = (VmInstance)RestrictedTypes.doPrivileged((String)instanceId, VmInstance.class);
                if (VmInstance.VmState.STOPPED.equals(vm.getState())) {
                    if (request.getAttribute().equals("kernel")) {
                        String kernelId = vm.getKernelId();
                        if (kernelId == null) {
                            vm.getBootRecord().setKernel();
                        } else {
                            KernelImageInfo kernelImg = Images.lookupKernel(kernelId);
                            if (!ImageMetadata.State.available.equals((Object)kernelImg.getState())) {
                                throw new NoSuchElementException("InvalidAMIID.NotFound: Unable to start instance with deregistered/failed image : " + kernelImg.getImageName());
                            }
                            vm.getBootRecord().setKernel(kernelImg);
                        }
                        Entities.merge((Object)((Object)vm));
                        tx.commit();
                    } else if (request.getAttribute().equals("ramdisk")) {
                        String ramdiskId = vm.getRamdiskId();
                        if (ramdiskId == null) {
                            vm.getBootRecord().setRamdisk();
                        } else {
                            RamdiskImageInfo ramdiskImg = Images.lookupRamdisk(ramdiskId);
                            if (!ImageMetadata.State.available.equals((Object)ramdiskImg.getState())) {
                                throw new NoSuchElementException("InvalidAMIID.NotFound: Unable to start instance with deregistered/failed image : " + ramdiskImg.getImageName());
                            }
                            vm.getBootRecord().setRamdisk(ramdiskImg);
                        }
                        Entities.merge((Object)((Object)vm));
                        tx.commit();
                    }
                    reply.set_return(Boolean.valueOf(true));
                    break block26;
                }
                throw new EucalyptusCloudException("IncorrectInstanceState: The instance '" + instanceId + "' is not in the 'stopped' state.");
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                if (Exceptions.isCausedBy((Throwable)ex, EucalyptusCloudException.class)) {
                    throw new ClientComputeException("IncorrectInstanceState", "The instance '" + instanceId + "' is not in the 'stopped' state.");
                }
                if (Exceptions.isCausedBy((Throwable)ex, NoSuchElementException.class) && ex.toString().contains("InvalidAMIID.NotFound")) {
                    throw new ClientComputeException("InvalidAMIID.NotFound", "The default " + request.getAttribute() + " does not exist");
                }
                throw new ClientComputeException("InvalidInstanceID.NotFound", "The instance ID '" + instanceId + "' does not exist");
            }
        }
        return reply;
    }

    public MonitorInstancesResponseType monitorInstances(MonitorInstancesType request) throws EucalyptusCloudException {
        MonitorInstancesResponseType reply = (MonitorInstancesResponseType)request.getReply();
        List<String> instanceSet = VmControl.normalizeIdentifiers(request.getInstancesSet());
        ArrayList monitorTrueList = Lists.newArrayList();
        for (String inst : instanceSet) {
            MonitorInstanceState monitorInstanceState = new MonitorInstanceState();
            monitorInstanceState.setInstanceId(inst);
            monitorInstanceState.setMonitoringState("enabled");
            monitorTrueList.add(monitorInstanceState);
        }
        reply.setInstancesSet(SetMonitorFunction.INSTANCE.apply(monitorTrueList));
        return reply;
    }

    public ModifyInstanceAttributeResponseType modifyInstanceAttribute(ModifyInstanceAttributeType request) throws EucalyptusCloudException, NoSuchMetadataException {
        ModifyInstanceAttributeResponseType reply = (ModifyInstanceAttributeResponseType)request.getReply();
        String instanceId = VmControl.normalizeIdentifier(request.getInstanceId());
        Context ctx = Contexts.lookup();
        try (TransactionResource tx = Entities.transactionFor(VmInstance.class);){
            VmInstance vm;
            try {
                vm = (VmInstance)RestrictedTypes.doPrivileged((String)instanceId, VmInstance.class);
            }
            catch (AuthException | NoSuchElementException e) {
                throw new ClientComputeException("InvalidInstanceID.NotFound", "The instance ID '" + instanceId + "' does not exist");
            }
            if (request.getBlockDeviceMappingSet() != null && !request.getBlockDeviceMappingSet().getItem().isEmpty()) {
                block24: for (InstanceBlockDeviceMappingItemType mapping : request.getBlockDeviceMappingSet().getItem()) {
                    for (VmVolumeAttachment vmVolumeAttachment : Iterables.concat(vm.getBootRecord().getPersistentVolumes(), vm.getTransientVolumeState().getAttachments())) {
                        if (!vmVolumeAttachment.getDevice().equals(mapping.getDeviceName())) continue;
                        if (mapping.getEbs() != null && mapping.getEbs().getVolumeId() != null) {
                            if (mapping.getEbs().getVolumeId().equals(vmVolumeAttachment.getVolumeId())) {
                                try {
                                    Volumes.lookup((OwnerFullName)ctx.getUserFullName().asAccountFullName(), (String)ResourceIdentifiers.tryNormalize().apply((Object)mapping.getEbs().getVolumeId()));
                                }
                                catch (Exception e) {
                                    throw new ClientComputeException("InvalidInstanceAttributeValue", "Invalid volume (" + mapping.getEbs().getVolumeId() + ")");
                                }
                            } else {
                                throw new ClientComputeException("InvalidInstanceAttributeValue", "Invalid volume (" + mapping.getEbs().getVolumeId() + ")");
                            }
                        }
                        vmVolumeAttachment.setDeleteOnTerminate(mapping.getEbs() == null ? true : (Boolean)Objects.firstNonNull((Object)mapping.getEbs().getDeleteOnTermination(), (Object)true));
                        continue block24;
                    }
                    throw new ClientComputeException("InvalidInstanceAttributeValue", "No device is currently mapped at " + mapping.getDeviceName());
                }
                tx.commit();
            } else if (request.getDisableApiTermination() == null && request.getEbsOptimized() == null) {
                if (request.getGroupIdSet() != null && !request.getGroupIdSet().getItem().isEmpty()) {
                    ArrayList groups = Lists.newArrayList();
                    AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
                    for (SecurityGroupIdSetItemType groupIdItemType : request.getGroupIdSet().getItem()) {
                        try {
                            String groupId = (String)ResourceIdentifiers.tryNormalize().apply((Object)groupIdItemType.getGroupId());
                            NetworkGroup networkGroup = NetworkGroups.lookupByGroupId((OwnerFullName)accountFullName, groupId);
                            if (!RestrictedTypes.filterPrivileged().apply((Object)networkGroup)) {
                                throw new IllegalAccessException("Not authorized to access security group " + groupId + " for " + ctx.getUserFullName());
                            }
                            if (!((String)Objects.firstNonNull((Object)networkGroup.getVpcId(), (Object)"")).equals(vm.getVpcId())) {
                                throw new ClientComputeException("InvalidGroup.NotFound", "Security group (" + groupId + ") not found");
                            }
                            groups.add(networkGroup);
                        }
                        catch (NoSuchMetadataException e) {
                            throw new ClientComputeException("InvalidGroup.NotFound", "Security group (" + groupIdItemType.getGroupId() + ") not found");
                        }
                    }
                    vm.getNetworkGroups().clear();
                    vm.getNetworkGroups().addAll(groups);
                    if (vm.getNetworkInterfaces() != null) {
                        for (NetworkInterface networkInterface : vm.getNetworkInterfaces()) {
                            if (networkInterface.getAttachment().getDeviceIndex() != 0) continue;
                            networkInterface.getNetworkGroups().clear();
                            networkInterface.getNetworkGroups().addAll(groups);
                            break;
                        }
                    }
                    tx.commit();
                    NetworkGroups.flushRules();
                } else if (request.getInstanceInitiatedShutdownBehavior() == null && request.getSourceDestCheck() == null && request.getSriovNetSupport() == null) {
                    if (!VmInstance.VmState.STOPPED.apply(vm)) {
                        throw new ClientComputeException("IncorrectInstanceState", "The instance (" + instanceId + ") is not in the 'stopped' state.");
                    }
                    if (request.getInstanceType() != null) {
                        VmType vmType = VmTypes.lookup(request.getInstanceType().getValue());
                        if (!RestrictedTypes.filterPrivileged().apply((Object)vmType)) {
                            throw new IllegalAccessException("Not authorized to allocate vm type " + (Object)((Object)vmType) + " for " + ctx.getUserFullName());
                        }
                        vm.getBootRecord().setVmType(vmType);
                        tx.commit();
                    } else {
                        if (request.getKernel() != null) {
                            try {
                                KernelImageInfo kernelImg = Images.lookupKernel(request.getKernel().getValue());
                                if (Images.FilterPermissions.INSTANCE.apply(kernelImg) && ImageMetadata.State.available.equals((Object)kernelImg.getState())) {
                                    if (!RestrictedTypes.filterPrivilegedWithoutOwner().apply((Object)kernelImg)) {
                                        throw new IllegalAccessException("Not authorize to use image " + kernelImg.getName() + " for ModifyInstanceAttribute");
                                    }
                                } else {
                                    throw new ClientComputeException("InvalidAMIID.NotFound", "Image id (" + request.getRamdisk().getValue() + ") not found");
                                }
                                vm.getBootRecord().setKernel(kernelImg);
                                tx.commit();
                            }
                            catch (NoSuchElementException e) {
                                throw new ClientComputeException("InvalidAMIID.NotFound", "Image id (" + request.getRamdisk().getValue() + ") not found");
                            }
                        }
                        if (request.getRamdisk() != null) {
                            try {
                                RamdiskImageInfo ramdiskImg = Images.lookupRamdisk(request.getRamdisk().getValue());
                                if (Images.FilterPermissions.INSTANCE.apply(ramdiskImg) && ImageMetadata.State.available.equals((Object)ramdiskImg.getState())) {
                                    if (!RestrictedTypes.filterPrivilegedWithoutOwner().apply((Object)ramdiskImg)) {
                                        throw new IllegalAccessException("Not authorize to use image " + ramdiskImg.getName() + " for ModifyInstanceAttribute");
                                    }
                                } else {
                                    throw new ClientComputeException("InvalidAMIID.NotFound", "Image id (" + request.getRamdisk().getValue() + ") not found");
                                }
                                vm.getBootRecord().setRamdisk(ramdiskImg);
                                tx.commit();
                            }
                            catch (NoSuchElementException e) {
                                throw new ClientComputeException("InvalidAMIID.NotFound", "Image id (" + request.getRamdisk().getValue() + ") not found");
                            }
                        }
                        if (request.getUserData() != null) {
                            byte[] userData;
                            try {
                                userData = B64.standard.dec((String)request.getUserData().getValue());
                            }
                            catch (ArrayIndexOutOfBoundsException | StringIndexOutOfBoundsException | DecoderException e) {
                                throw new ClientComputeException("InvalidParameterValue", "User data decoding error.");
                            }
                            if (userData.length > Integer.parseInt(VmInstances.USER_DATA_MAX_SIZE_KB) * 1024) {
                                throw new InvalidMetadataException("User data may not exceed " + VmInstances.USER_DATA_MAX_SIZE_KB + " KB");
                            }
                            vm.getBootRecord().setUserData(userData);
                            tx.commit();
                        }
                    }
                }
            }
            reply.set_return(Boolean.valueOf(true));
        }
        catch (ComputeException e) {
            throw e;
        }
        catch (Exception ex) {
            if (Exceptions.isCausedBy((Throwable)ex, NoSuchMetadataException.class)) {
                throw new ClientComputeException("InvalidInstanceAttributeValue", "The instanceType '" + request.getInstanceType() + "' is invalid.");
            }
            if (Exceptions.isCausedBy((Throwable)ex, IllegalAccessException.class)) {
                throw new ClientComputeException("UnauthorizedOperation", "You are not authorized to perform this operation.");
            }
            if (Exceptions.isCausedBy((Throwable)ex, InvalidMetadataException.class)) {
                throw new ClientComputeException("InvalidParameterValue", "User data is limited to 16384 bytes");
            }
            LOG.error((Object)ex, (Throwable)ex);
            throw new ComputeException("InternalError", "Error processing request: " + ex.getMessage());
        }
        return reply;
    }

    public DescribePlacementGroupsResponseType describePlacementGroups(DescribePlacementGroupsType request) {
        DescribePlacementGroupsResponseType reply = (DescribePlacementGroupsResponseType)request.getReply();
        return reply;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DescribeInstanceAttributeResponseType describeInstanceAttribute(DescribeInstanceAttributeType request) throws EucalyptusCloudException {
        DescribeInstanceAttributeResponseType reply = (DescribeInstanceAttributeResponseType)request.getReply();
        String instanceId = VmControl.normalizeIdentifier(request.getInstanceId());
        String attribute = request.getAttribute();
        if (attribute == null) {
            throw new ClientComputeException(" MissingParameter", "Attribute parameter is required");
        }
        try (TransactionResource tx = Entities.transactionFor(VmInstance.class);){
            VmInstance vm = (VmInstance)RestrictedTypes.doPrivileged((String)instanceId, VmInstance.class);
            reply.setInstanceId(instanceId);
            switch (attribute) {
                case "blockDeviceMapping": {
                    if (!(vm.getBootRecord().getMachine() instanceof BlockStorageImageInfo)) return reply;
                    BlockStorageImageInfo bfebsInfo = (BlockStorageImageInfo)vm.getBootRecord().getMachine();
                    for (VmVolumeAttachment volumeAttachment : vm.getBootRecord().getPersistentVolumes()) {
                        reply.getBlockDeviceMapping().add(new InstanceBlockDeviceMapping(volumeAttachment.getIsRootDevice() != false ? bfebsInfo.getRootDeviceName() : volumeAttachment.getDevice(), volumeAttachment.getVolumeId(), volumeAttachment.getStatus(), volumeAttachment.getAttachTime(), volumeAttachment.getDeleteOnTerminate()));
                    }
                    return reply;
                }
                case "disableApiTermination": {
                    reply.setDisableApiTermination(Boolean.valueOf(false));
                    return reply;
                }
                case "ebsOptimized": {
                    reply.setEbsOptimized(Boolean.valueOf(false));
                    return reply;
                }
                case "groupSet": {
                    Iterables.addAll((Collection)reply.getGroupSet(), (Iterable)Iterables.transform(vm.getNetworkGroupIds(), (Function)TypeMappers.lookup(NetworkGroupId.class, GroupItemType.class)));
                    return reply;
                }
                case "instanceInitiatedShutdownBehavior": {
                    reply.setInstanceInitiatedShutdownBehavior("stop");
                    return reply;
                }
                case "instanceType": {
                    reply.setInstanceType(vm.getBootRecord().getVmType().getDisplayName());
                    return reply;
                }
                case "kernel": {
                    reply.setKernel(vm.getKernelId());
                    return reply;
                }
                case "productCodes": {
                    reply.setProductCodes(Boolean.valueOf(false));
                    return reply;
                }
                case "ramdisk": {
                    reply.setRamdisk(vm.getRamdiskId());
                    return reply;
                }
                case "rootDeviceName": {
                    reply.setRootDeviceName(vm.getBootRecord().getMachine() == null ? null : vm.getBootRecord().getMachine().getRootDeviceName());
                    return reply;
                }
                case "sourceDestCheck": {
                    reply.setSourceDestCheck(Boolean.valueOf(true));
                    return reply;
                }
                case "sriovNetSupport": {
                    reply.setSriovNetSupport(Boolean.valueOf(false));
                    return reply;
                }
                case "userData": {
                    reply.setUserData(vm.getUserData() == null ? null : Base64.toBase64String((byte[])vm.getUserData()));
                    return reply;
                }
                default: {
                    throw new ClientComputeException(" InvalidParameterValue", "Invalid value for attribute (" + attribute + ")");
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new ClientComputeException("InvalidInstanceID.NotFound", "The instance ID '" + instanceId + "' does not exist");
        }
    }

    public DeletePlacementGroupResponseType deletePlacementGroup(DeletePlacementGroupType request) {
        DeletePlacementGroupResponseType reply = (DeletePlacementGroupResponseType)request.getReply();
        return reply;
    }

    public CreatePlacementGroupResponseType createPlacementGroup(CreatePlacementGroupType request) {
        CreatePlacementGroupResponseType reply = (CreatePlacementGroupResponseType)request.getReply();
        return reply;
    }

    public CancelBundleTaskResponseType cancelBundleTask(CancelBundleTaskType request) throws EucalyptusCloudException {
        CancelBundleTaskResponseType reply = (CancelBundleTaskResponseType)request.getReply();
        reply.set_return(true);
        Context ctx = Contexts.lookup();
        try {
            VmInstance v = VmInstances.lookupByBundleId(VmControl.normalizeBundleIdentifier(request.getBundleId()));
            VmBundleTask.BundleState bundleState = v.getRuntimeState().getBundleTaskState();
            if (bundleState != VmBundleTask.BundleState.pending && bundleState != VmBundleTask.BundleState.storing) {
                throw new EucalyptusCloudException("Can't cancel bundle task when the bundle task is " + (Object)((Object)bundleState));
            }
            if (RestrictedTypes.filterPrivileged().apply((Object)v)) {
                v.getRuntimeState().updateBundleTaskState(VmBundleTask.BundleState.canceling, 0.0);
                LOG.info((Object)EventRecord.here(Bundles.BundleCallback.class, (EventType)EventType.BUNDLE_CANCELING, (String[])new String[]{ctx.getUserFullName().toString(), v.getRuntimeState().getBundleTask().getBundleId(), v.getInstanceId()}));
                ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{v.lookupPartition()});
                Cluster cluster = Clusters.lookup(ccConfig);
                request.setInstanceId(v.getInstanceId());
                reply.setTask(Bundles.transform(v.getRuntimeState().getBundleTask()));
                AsyncRequests.newRequest((RemoteCallback)Bundles.cancelCallback(request)).dispatch((ServiceConfiguration)cluster.getConfiguration());
                return reply;
            }
            throw new EucalyptusCloudException("Failed to find bundle task: " + request.getBundleId());
        }
        catch (NoSuchElementException e) {
            throw new EucalyptusCloudException("Failed to find bundle task: " + request.getBundleId());
        }
    }

    public BundleInstanceResponseType bundleInstance(final BundleInstanceType request) throws EucalyptusCloudException {
        VmInstance bundledVm;
        AccessKey accessKey;
        final Context ctx = Contexts.lookup();
        final BundleInstanceResponseType reply = (BundleInstanceResponseType)request.getReply();
        final String instanceId = VmControl.normalizeIdentifier(request.getInstanceId());
        if (!this.validBucketName(request.getBucket())) {
            throw new ClientComputeException(" InvalidParameterValue", "Value (" + request.getBucket() + ") for parameter Bucket is invalid.");
        }
        if (!this.validBucketName(request.getPrefix())) {
            throw new ClientComputeException(" InvalidParameterValue", "Value (" + request.getPrefix() + ") for parameter Prefix is invalid.");
        }
        if (request.getUploadPolicy() != null && request.getUploadPolicy().length() > 4096) {
            throw new ClientComputeException(" InvalidParameterValue", "Value for parameter UploadPolicy is invalid (too long)");
        }
        final String uploadPolicyJson = B64.standard.decString((String)request.getUploadPolicy());
        Bundles.checkAndCreateBucket(ctx.getUser(), request.getBucket(), request.getPrefix());
        Function<String, VmInstance> bundleFunc = new Function<String, VmInstance>(){

            public VmInstance apply(String input) {
                reply.set_return(false);
                try {
                    VmInstance v = (VmInstance)RestrictedTypes.doPrivileged((String)input, VmInstance.class);
                    if (!VmInstance.VmState.RUNNING.equals(v.getState())) {
                        throw new ClientComputeException("InvalidState", "Failed to bundle requested vm because it is not currently 'running': " + instanceId);
                    }
                    VmBundleTask bundleTask = Bundles.create(v, request.getBucket(), request.getPrefix(), uploadPolicyJson);
                    if (!v.getRuntimeState().startBundleTask(bundleTask).booleanValue()) {
                        throw new ClientComputeException("BundlingInProgress", "Instance is already being bundled: " + v.getRuntimeState().getBundleTask().getBundleId());
                    }
                    reply.setTask(Bundles.transform(bundleTask));
                    reply.markWinning();
                    EventRecord.here(VmControl.class, (EventType)EventType.BUNDLE_PENDING, (String[])new String[]{ctx.getUserFullName().toString(), v.getRuntimeState().getBundleTask().getBundleId(), v.getInstanceId()}).debug();
                    return v;
                }
                catch (ComputeException e) {
                    throw Exceptions.toUndeclared((Throwable)((Object)e));
                }
                catch (AuthException | NoSuchElementException e) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidInstanceID.NotFound", "The instance ID '" + instanceId + "' does not exist")));
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        };
        try {
            byte[] sig;
            String accessKeyId = request.getAwsAccessKeyId();
            JSONObject policyJsonObj = JSONObject.fromObject((Object)uploadPolicyJson);
            JSONArray conditions = policyJsonObj.getJSONArray("conditions");
            String securityToken = null;
            for (Object object : conditions) {
                if (!(object instanceof JSONObject) || !((JSONObject)object).has("x-amz-security-token")) continue;
                securityToken = ((JSONObject)object).getString("x-amz-security-token");
                break;
            }
            if (!MessageDigest.isEqual(sig = HmacUtils.getSignature((String)(accessKey = AccessKeys.lookupAccessKey((String)accessKeyId, securityToken)).getSecretKey(), (String)request.getUploadPolicy(), (Hmac)Hmac.HmacSHA1), B64.standard.dec((String)request.getUploadPolicySignature()))) {
                throw new ClientComputeException("InvalidParameterValue", "Value for UploadPolicySignature is invalid.");
            }
        }
        catch (JSONException e) {
            throw new ClientComputeException("InvalidParameterValue", "Value for UploadPolicy is invalid.");
        }
        catch (AuthException e) {
            throw new ClientComputeException("InvalidParameterValue", "Value (" + request.getAwsAccessKeyId() + ") for AWSAccessKeyId is invalid.");
        }
        catch (AuthenticationException e) {
            LOG.error((Object)"Error processing upload policy signature ", (Throwable)e);
            throw new ClientComputeException("InternalError", "Error processing request; upload policy signature error.");
        }
        try {
            bundledVm = (VmInstance)((Object)Entities.asTransaction(VmInstance.class, (Function)bundleFunc).apply((Object)instanceId));
        }
        catch (RuntimeException e) {
            LOG.error((Object)e, (Throwable)e);
            Exceptions.findAndRethrow((Throwable)e, ComputeException.class);
            throw e;
        }
        final ImageInfo imageInfo = Images.lookupImage(bundledVm.getImageId());
        final AccessKey accessKeyForPolicySignature = accessKey;
        try {
            ServiceConfiguration cluster = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{bundledVm.lookupPartition()});
            BundleInstanceType reqInternal = (BundleInstanceType)new BundleInstanceType(){
                {
                    this.setInstanceId(request.getInstanceId());
                    this.setBucket(request.getBucket());
                    this.setPrefix(request.getPrefix());
                    this.setAwsAccessKeyId(accessKeyForPolicySignature.getAccessKey());
                    this.setUploadPolicy(request.getUploadPolicy());
                    this.setUploadPolicySignature(request.getUploadPolicySignature());
                    this.setUrl(request.getUrl());
                    this.setUserKey(request.getUserKey());
                    this.setArchitecture(imageInfo != null ? imageInfo.getArchitecture().name() : "i386");
                }
            }.regardingUserRequest((BaseMessage)request);
            AsyncRequests.newRequest((RemoteCallback)Bundles.createCallback(reqInternal)).dispatch(cluster);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw Exceptions.toUndeclared((Throwable)ex);
        }
        return reply;
    }

    public GetPasswordDataResponseType getPasswordData(GetPasswordDataType request) throws Exception {
        VmInstance v;
        String instanceId = VmControl.normalizeIdentifier(request.getInstanceId());
        try {
            v = VmInstances.lookup(instanceId);
        }
        catch (NoSuchElementException e) {
            throw new ClientComputeException("InvalidInstanceID.NotFound", "The instance ID '" + instanceId + "' does not exist");
        }
        if (!RestrictedTypes.filterPrivileged().apply((Object)v)) {
            throw new EucalyptusCloudException("Instance " + instanceId + " does not exist.");
        }
        if (!VmInstance.VmState.RUNNING.equals(v.getState())) {
            throw new EucalyptusCloudException("Instance " + instanceId + " is not in a running state.");
        }
        if (!ImageMetadata.Platform.windows.name().equals(v.getPlatform())) {
            throw new ClientComputeException("OperationNotPermitted", "Instance's platform is not Windows");
        }
        if (Strings.isNullOrEmpty((String)v.getKeyPair().getPublicKey())) {
            throw new ClientComputeException("OperationNotPermitted", "Keypair is not found for the instance");
        }
        if (v.getPasswordData() == null) {
            try {
                GetConsoleOutputResponseType consoleOutput = this.getConsoleOutput(new GetConsoleOutputType(instanceId));
                String tempCo = B64.standard.decString((String)String.valueOf(consoleOutput.getOutput())).replaceAll("[\r\n]*", "");
                String passwordData = tempCo.replaceAll(".*<Password>", "").replaceAll("</Password>.*", "");
                if (tempCo.matches(".*<Password>[\\w=+/]*</Password>.*")) {
                    Entities.asTransaction(VmInstance.class, (Predicate)new Predicate<String>(){

                        public boolean apply(String passwordData) {
                            VmInstance vm = (VmInstance)((Object)Entities.merge((Object)((Object)v)));
                            vm.updatePasswordData(passwordData);
                            return true;
                        }
                    }).apply((Object)passwordData);
                    v.updatePasswordData(passwordData);
                }
            }
            catch (Exception e) {
                throw new ComputeException("InternalError", "Error processing request: " + e.getMessage());
            }
        }
        GetPasswordDataResponseType reply = (GetPasswordDataResponseType)request.getReply();
        reply.set_return(Boolean.valueOf(true));
        reply.setOutput(v.getPasswordData());
        reply.setTimestamp(new Date());
        reply.setInstanceId(v.getInstanceId());
        return reply;
    }

    private static Set<String> toInstanceIds(Iterable<String> ids) throws EucalyptusCloudException {
        HashSet result = Sets.newHashSet();
        if (ids != null) {
            for (String id : ids) {
                result.add(VmControl.normalizeBundleIdentifier(id).replace("bun-", "i-"));
            }
        }
        return result;
    }

    private boolean validBucketName(String name) {
        return Pattern.matches("^[a-zA-Z\\d\\.\\-_]{3,255}$", name);
    }

    private static String normalizeIdentifier(String identifier) throws EucalyptusCloudException {
        try {
            return ResourceIdentifiers.parse("i", identifier).getIdentifier();
        }
        catch (InvalidResourceIdentifier e) {
            throw new ClientComputeException("InvalidInstanceID.Malformed", "Invalid id: \"" + e.getIdentifier() + "\"");
        }
    }

    private static List<String> normalizeIdentifiers(List<String> identifiers) throws EucalyptusCloudException {
        try {
            return ResourceIdentifiers.normalize("i", identifiers);
        }
        catch (InvalidResourceIdentifier e) {
            throw new ClientComputeException("InvalidInstanceID.Malformed", "Invalid id: \"" + e.getIdentifier() + "\"");
        }
    }

    private static String normalizeBundleIdentifier(String identifier) throws EucalyptusCloudException {
        try {
            return ResourceIdentifiers.parse("bun", identifier).getIdentifier();
        }
        catch (InvalidResourceIdentifier e) {
            throw new ClientComputeException("InvalidInstanceID.Malformed", "Invalid id: \"" + e.getIdentifier() + "\"");
        }
    }

    private static enum SetMonitorFunction implements Function<List<MonitorInstanceState>, ArrayList<MonitorInstanceState>>
    {
        INSTANCE;


        public ArrayList<MonitorInstanceState> apply(List<MonitorInstanceState> monitorList) {
            ArrayList monitorInstanceSet = Lists.newArrayList();
            for (MonitorInstanceState monitorInst : monitorList) {
                try {
                    TransactionResource db = Entities.transactionFor(VmInstance.class);
                    Throwable throwable = null;
                    try {
                        VmInstance vmInst = VmInstances.lookup(monitorInst.getInstanceId());
                        if (!RestrictedTypes.filterPrivileged().apply((Object)vmInst)) continue;
                        vmInst.getBootRecord().setMonitoring("enabled".equals(monitorInst.getMonitoringState()));
                        monitorInstanceSet.add(monitorInst);
                        db.commit();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (db == null) continue;
                        if (throwable != null) {
                            try {
                                db.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        db.close();
                    }
                }
                catch (NoSuchElementException nse) {
                    LOG.debug((Object)("Unable to find instance : " + monitorInst.getInstanceId()));
                }
                catch (Exception ex) {
                    LOG.debug((Object)("Unable to set monitoring state for instance : " + monitorInst.getInstanceId()), (Throwable)ex);
                }
            }
            return monitorInstanceSet;
        }
    }
}

