/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.vm.BundleTask;
import com.eucalyptus.vm.Bundles;
import com.eucalyptus.vm.VmInstance;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import groovy.sql.Sql;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Parent;
import org.hibernate.annotations.Type;

@Embeddable
public class VmBundleTask {
    @Parent
    private VmInstance vmInstance;
    @Enumerated(value=EnumType.STRING)
    @Column(name="metadata_vm_bundle_state")
    private BundleState state;
    @Column(name="metadata_vm_bundle_start_time")
    private Date startTime;
    @Column(name="metadata_vm_bundle_update_time")
    private Date updateTime;
    @Column(name="metadata_vm_bundle_progress")
    private Integer progress;
    @Column(name="metadata_vm_bundle_bucket")
    private String bucket;
    @Column(name="metadata_vm_bundle_prefix")
    private String prefix;
    @Column(name="metadata_vm_bundle_policy")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String policy;
    @Column(name="metadata_vm_bundle_error_msg")
    private String errorMessage;
    @Column(name="metadata_vm_bundle_error_code")
    private String errorCode;

    VmBundleTask() {
    }

    VmBundleTask(VmInstance vmInstance, String state, Date startTime, Date updateTime, Integer progress, String bucket, String prefix, String errorMessage, String errorCode) {
        this.vmInstance = vmInstance;
        this.state = (BundleState)((Object)BundleState.mapper.apply((Object)state));
        this.startTime = startTime;
        this.updateTime = updateTime;
        this.progress = progress;
        this.bucket = bucket;
        this.prefix = prefix;
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
    }

    private VmBundleTask(VmInstance vm, String bucket, String prefix, String policy) {
        this.vmInstance = vm;
        this.state = BundleState.pending;
        this.startTime = new Date();
        this.updateTime = new Date();
        this.progress = 0;
        this.bucket = bucket;
        this.prefix = prefix;
        this.policy = policy;
        this.errorCode = null;
        this.errorMessage = null;
    }

    private VmBundleTask(VmInstance vmInstance, BundleState state, Date startTime, Date updateTime, Integer progress, String bucket, String prefix, String errorMessage, String errorCode) {
        this.vmInstance = vmInstance;
        this.state = state;
        this.startTime = startTime;
        this.updateTime = updateTime;
        this.progress = progress;
        this.bucket = bucket;
        this.prefix = prefix;
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
    }

    static VmBundleTask create(VmInstance vm, String bucket, String prefix, String policy) {
        return new VmBundleTask(vm, bucket, prefix, policy);
    }

    static VmBundleTask copyOf(VmBundleTask other) {
        if (other == null) {
            return null;
        }
        return new VmBundleTask(other.vmInstance, other.state, other.startTime, other.updateTime, other.progress, other.bucket, other.prefix, other.errorMessage, other.errorCode);
    }

    public static Function<BundleTask, VmBundleTask> fromBundleTask(final VmInstance vm) {
        return new Function<BundleTask, VmBundleTask>(){

            public VmBundleTask apply(BundleTask input) {
                return new VmBundleTask(vm, input.getState(), input.getStartTime(), input.getUpdateTime(), (Integer)(input.getProgress() != null ? Integer.parseInt(input.getProgress().replace("%", "")) : 0), input.getBucket(), input.getPrefix(), input.getErrorMessage(), input.getErrorCode());
            }
        };
    }

    public static Function<VmBundleTask, BundleTask> asBundleTask() {
        return new Function<VmBundleTask, BundleTask>(){

            public BundleTask apply(VmBundleTask input) {
                return new BundleTask(input.getInstanceId(), input.getBundleId(), input.getState().name(), input.getStartTime(), input.getUpdateTime(), "" + input.getProgress(), input.getBucket(), input.getPrefix(), input.getErrorMessage(), input.getErrorCode());
            }
        };
    }

    private VmInstance getVmInstance() {
        return this.vmInstance;
    }

    private void setVmInstance(VmInstance vmInstance) {
        this.vmInstance = vmInstance;
    }

    String getInstanceId() {
        return this.vmInstance.getInstanceId();
    }

    String getBundleId() {
        return this.getInstanceId().replaceFirst("i-", "bun-");
    }

    BundleState getState() {
        return this.state;
    }

    void setState(BundleState state) {
        if (this.state != null && this.state != state) {
            Bundles.putPreviousTask(this);
        }
        this.state = state;
    }

    Date getStartTime() {
        return this.startTime;
    }

    void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    Date getUpdateTime() {
        return this.updateTime;
    }

    void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    Integer getProgress() {
        return this.progress;
    }

    void setProgress(Integer progress) {
        this.progress = progress;
    }

    String getBucket() {
        return this.bucket;
    }

    void setBucket(String bucket) {
        this.bucket = bucket;
    }

    String getPrefix() {
        return this.prefix;
    }

    void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    String getErrorCode() {
        return this.errorCode;
    }

    private void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public int hashCode() {
        return this.vmInstance.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VmBundleTask other = (VmBundleTask)obj;
        return this.getVmInstance().equals((Object)other.getVmInstance());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VmBundleTask ");
        if (this.vmInstance != null) {
            builder.append(this.vmInstance.getInstanceId()).append(" ").append("bundleId=").append(this.getBundleId()).append(":");
        }
        if (this.state != null) {
            builder.append("state=").append((Object)this.state).append(":");
        }
        if (this.progress != null) {
            builder.append("progress=").append(this.progress);
        }
        return builder.toString();
    }

    @Upgrades.PostUpgrade(value=Eucalyptus.class, since=Upgrades.Version.v4_1_0)
    public static class VmBundleTaskPostUpgrade410
    implements Callable<Boolean> {
        private static Logger LOG = Logger.getLogger(VmBundleTaskPostUpgrade410.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try (Sql sql = null;){
                sql = Upgrades.DatabaseFilters.NEWVERSION.getConnection("eucalyptus_cloud");
                sql.execute("ALTER TABLE metadata_instances ALTER COLUMN metadata_vm_bundle_policy TYPE text");
                Boolean bl = true;
                return bl;
            }
        }
    }

    public static enum Filters implements Predicate<VmBundleTask>
    {
        BUNDLING{

            public boolean apply(VmBundleTask arg0) {
                return arg0 != null && !BundleState.none.equals((Object)arg0.getState());
            }
        };

    }

    public static enum BundleState {
        none("none"),
        pending(null),
        storing("bundling"),
        canceling(null),
        cancelled("cancelled"),
        complete("succeeded"),
        failed("failed");

        private String mappedState;
        public static Function<String, BundleState> mapper;

        private BundleState(String mappedState) {
            this.mappedState = mappedState;
        }

        public String getMappedState() {
            return this.mappedState;
        }

        static {
            mapper = new Function<String, BundleState>(){

                public BundleState apply(String input) {
                    for (BundleState s : BundleState.values()) {
                        if (s.getMappedState() == null || !s.getMappedState().equals(input)) continue;
                        return s;
                    }
                    return none;
                }
            };
        }
    }
}

