/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.compute.vpc.Subnet;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.images.BlockStorageImageInfo;
import com.eucalyptus.images.BootableImageInfo;
import com.eucalyptus.images.Emis;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.images.KernelImageInfo;
import com.eucalyptus.images.RamdiskImageInfo;
import com.eucalyptus.keys.KeyPairs;
import com.eucalyptus.keys.SshKeyPair;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.RestrictedType;
import com.eucalyptus.vm.VmEphemeralAttachment;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.eucalyptus.vmtypes.VmType;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.PreRemove;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parent;
import org.hibernate.annotations.Type;

@Embeddable
public class VmBootRecord {
    @Parent
    private VmInstance vmInstance;
    @ManyToOne
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private ImageInfo machineImage;
    @Column(name="metadata_vm_machine_image_id")
    private String machineImageId;
    @ManyToOne(fetch=FetchType.LAZY)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private KernelImageInfo kernel;
    @Column(name="metadata_vm_kernel_image_id")
    private String kernelImageId;
    @ManyToOne(fetch=FetchType.LAZY)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private RamdiskImageInfo ramdisk;
    @Column(name="metadata_vm_ramdisk_image_id")
    private String ramdiskImageId;
    @Column(name="metadata_vm_platform")
    @Enumerated(value=EnumType.STRING)
    private ImageMetadata.Platform platform;
    @Column(name="metadata_vm_virtualization_type")
    @Enumerated(value=EnumType.STRING)
    private ImageMetadata.VirtualizationType virtType;
    @Column(name="metadata_vm_architecture")
    @Enumerated(value=EnumType.STRING)
    private ImageMetadata.Architecture architecture;
    @ElementCollection
    @CollectionTable(name="metadata_instances_persistent_volumes")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<VmVolumeAttachment> persistentVolumes = Sets.newHashSet();
    @ElementCollection
    @CollectionTable(name="metadata_instances_ephemeral_storage")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<VmEphemeralAttachment> ephemeralStorage = Sets.newHashSet();
    @Column(name="metadata_vm_monitoring")
    private Boolean monitoring;
    @Column(name="metadata_vm_user_data")
    private byte[] userData;
    @Column(name="metadata_vm_nameorarn", updatable=false, length=2048)
    private String iamInstanceProfileArn;
    @Column(name="metadata_vm_iam_instance_profile_id", updatable=false)
    private String iamInstanceProfileId;
    @Column(name="metadata_vm_iam_role_arn", updatable=false, length=2048)
    private String iamRoleArn;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="metadata_vm_sshkey")
    private String sshKeyString;
    @ManyToOne
    @JoinColumn(name="metadata_vm_type_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private VmType vmType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="metadata_vpc")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Vpc vpc;
    @Column(name="metadata_vpc_id", updatable=false)
    private String vpcId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="metadata_vpc_subnet")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Subnet subnet;
    @Column(name="metadata_vpc_subnet_id", updatable=false)
    private String subnetId;

    VmBootRecord() {
    }

    VmBootRecord(Emis.BootableSet bootSet, byte[] userData, SshKeyPair sshKeyPair, VmType vmType, Subnet subnet, boolean monitoring, @Nullable String iamInstanceProfileArn, @Nullable String iamInstanceProfileId, @Nullable String iamRoleArn) {
        Parameters.checkParam((String)"Bootset must not be null", (Object)bootSet, (Matcher)Matchers.notNullValue());
        if (bootSet.getMachine() instanceof ImageInfo) {
            this.machineImage = (ImageInfo)((Object)bootSet.getMachine());
        }
        if (bootSet.hasKernel()) {
            this.kernel = bootSet.getKernel();
        }
        if (bootSet.hasRamdisk()) {
            this.ramdisk = bootSet.getRamdisk();
        }
        this.architecture = bootSet.getMachine() != null ? bootSet.getMachine().getArchitecture() : null;
        this.platform = bootSet.getMachine().getPlatform();
        this.virtType = this.getDisplayVirtualizationType();
        this.userData = userData;
        this.sshKeyString = sshKeyPair.getPublicKey();
        this.vmType = vmType;
        this.vpc = subnet == null ? null : subnet.getVpc();
        this.vpcId = (String)CloudMetadatas.toDisplayName().apply((Object)this.vpc);
        this.subnet = subnet;
        this.subnetId = (String)CloudMetadatas.toDisplayName().apply((Object)subnet);
        this.monitoring = monitoring;
        this.iamInstanceProfileArn = iamInstanceProfileArn;
        this.iamInstanceProfileId = iamInstanceProfileId;
        this.iamRoleArn = iamRoleArn;
        this.updateImageIdentifiers();
    }

    @PreRemove
    private void cleanUp() {
        this.persistentVolumes.clear();
    }

    private VmInstance getVmInstance() {
        return this.vmInstance;
    }

    @Nullable
    public BootableImageInfo getMachine() {
        return (BootableImageInfo)((Object)this.machineImage);
    }

    public void setMachine() {
        this.updateImageIdentifiers();
        this.virtType = this.getDisplayVirtualizationType();
        this.machineImage = null;
    }

    public String getMachineImageId() {
        return this.machineImageId;
    }

    public void setMachineImageId(String machineImageId) {
        this.machineImageId = machineImageId;
    }

    @Nonnull
    public String getDisplayMachineImageId() {
        return VmBootRecord.displayName(this.machineImageId, (RestrictedType)this.machineImage, (String)ResourceIdentifiers.tryNormalize().apply((Object)"emi-00000000"));
    }

    @Nullable
    public KernelImageInfo getKernel() {
        return this.kernel;
    }

    public void setKernel(KernelImageInfo kernel) {
        this.kernel = kernel;
        this.updateImageIdentifiers();
    }

    public void setKernel() {
        this.updateImageIdentifiers();
        this.kernel = null;
    }

    public String getKernelImageId() {
        return this.kernelImageId;
    }

    public void setKernelImageId(String kernelImageId) {
        this.kernelImageId = kernelImageId;
    }

    @Nullable
    public String getDisplayKernelImageId() {
        return VmBootRecord.displayName(this.kernelImageId, (RestrictedType)this.getKernel(), null);
    }

    @Nullable
    public RamdiskImageInfo getRamdisk() {
        return this.ramdisk;
    }

    public void setRamdisk(RamdiskImageInfo ramdisk) {
        this.ramdisk = ramdisk;
        this.updateImageIdentifiers();
    }

    public void setRamdisk() {
        this.updateImageIdentifiers();
        this.ramdisk = null;
    }

    public String getRamdiskImageId() {
        return this.ramdiskImageId;
    }

    public void setRamdiskImageId(String ramdiskImageId) {
        this.ramdiskImageId = ramdiskImageId;
    }

    @Nullable
    public String getDisplayRamdiskImageId() {
        return VmBootRecord.displayName(this.ramdiskImageId, (RestrictedType)this.getRamdisk(), null);
    }

    public ImageMetadata.Platform getPlatform() {
        return this.platform;
    }

    public ImageMetadata.VirtualizationType getVirtualizationType() {
        return this.virtType;
    }

    public ImageMetadata.VirtualizationType getDisplayVirtualizationType() {
        ImageMetadata.VirtualizationType virtType = this.getVirtualizationType();
        if (virtType == null) {
            BootableImageInfo machine = this.getMachine();
            if (machine != null) {
                virtType = machine.getVirtualizationType();
            }
            if (virtType == null) {
                virtType = machine instanceof BlockStorageImageInfo || ImageMetadata.Platform.windows == this.getPlatform() ? ImageMetadata.VirtualizationType.hvm : ImageMetadata.VirtualizationType.paravirtualized;
            }
        }
        return virtType;
    }

    public Set<VmVolumeAttachment> getPersistentVolumes() {
        return this.persistentVolumes;
    }

    public boolean hasPersistentVolumes() {
        return !this.persistentVolumes.isEmpty();
    }

    public Set<VmEphemeralAttachment> getEphemeralStorage() {
        return this.ephemeralStorage;
    }

    public void setEphemeralStorage(Set<VmEphemeralAttachment> ephemeralStorage) {
        this.ephemeralStorage = ephemeralStorage;
    }

    public boolean hasEphemeralStorage() {
        return !this.ephemeralStorage.isEmpty();
    }

    byte[] getUserData() {
        return this.userData;
    }

    @Nullable
    String getIamInstanceProfileArn() {
        return this.iamInstanceProfileArn;
    }

    @Nullable
    String getIamInstanceProfileId() {
        return this.iamInstanceProfileId;
    }

    @Nullable
    String getIamRoleArn() {
        return this.iamRoleArn;
    }

    SshKeyPair getSshKeyPair() {
        if (this.getSshKeyString() != null) {
            return SshKeyPair.withPublicKey(null, this.getSshKeyString().replaceAll(".*@eucalyptus\\.", ""), this.getSshKeyString());
        }
        return KeyPairs.noKey();
    }

    VmType getVmType() {
        return this.vmType;
    }

    void setVmType(VmType vmType) {
        this.vmType = vmType;
    }

    public Vpc getVpc() {
        return this.vpc;
    }

    void setVpc(Vpc vpc) {
        this.vpc = vpc;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public Subnet getSubnet() {
        return this.subnet;
    }

    void setSubnet(Subnet subnet) {
        this.subnet = subnet;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    void setPlatform(ImageMetadata.Platform platform) {
        this.platform = platform;
    }

    void setVirtualizationType(ImageMetadata.VirtualizationType virtType) {
        this.virtType = virtType;
    }

    public final void setMonitoring(Boolean monitoring) {
        this.monitoring = monitoring;
    }

    public final void setUserData(byte[] userData) {
        this.userData = userData;
    }

    public boolean isBlockStorage() {
        return this.getMachine() instanceof BlockStorageImageInfo;
    }

    public boolean isLinux() {
        return this.getMachine() == null || this.getPlatform() == null || ImageMetadata.Platform.linux.equals((Object)this.getPlatform());
    }

    private ImageInfo getMachineImage() {
        return this.machineImage;
    }

    public final Boolean isMonitoring() {
        return (Boolean)com.google.common.base.Objects.firstNonNull((Object)this.monitoring, (Object)Boolean.FALSE);
    }

    void setVmInstance(VmInstance vmInstance) {
        this.vmInstance = vmInstance;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VmBootRecord:");
        if (this.machineImage != null) {
            builder.append("machineImage=").append((Object)this.machineImage).append(":");
        }
        if (this.kernel != null) {
            builder.append("kernel=").append((Object)this.kernel).append(":");
        }
        if (this.ramdisk != null) {
            builder.append("ramdisk=").append((Object)this.ramdisk).append(":");
        }
        if (this.platform != null) {
            builder.append("platform=").append(this.platform).append(":");
        }
        if (Entities.isReadable(this.persistentVolumes)) {
            builder.append("persistentVolumes=").append(this.persistentVolumes).append(":");
        }
        if (this.userData != null) {
            builder.append("userData=").append(Arrays.toString(this.userData)).append(":");
        }
        if (this.sshKeyString != null) {
            builder.append("sshKeyPair=").append(this.sshKeyString.replaceAll(".*@eucalyptus\\.", "")).append(":");
        }
        if (this.vmType != null) {
            builder.append("vmType=").append((Object)this.vmType);
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vmInstance == null ? 0 : this.vmInstance.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VmBootRecord other = (VmBootRecord)obj;
        return !(this.vmInstance == null ? other.vmInstance != null : !this.vmInstance.equals((Object)other.vmInstance));
    }

    public ImageMetadata.Architecture getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(ImageMetadata.Architecture architecture) {
        this.architecture = architecture;
    }

    private String getSshKeyString() {
        return this.sshKeyString;
    }

    private void setSshKeyString(String sshKeyString) {
        this.sshKeyString = sshKeyString;
    }

    private void updateImageIdentifiers() {
        this.machineImageId = VmBootRecord.displayName(null, (RestrictedType)this.machineImage, this.machineImageId);
        this.kernelImageId = VmBootRecord.displayName(null, (RestrictedType)this.kernel, this.kernelImageId);
        this.ramdiskImageId = VmBootRecord.displayName(null, (RestrictedType)this.ramdisk, this.ramdiskImageId);
    }

    private static String displayName(@Nullable String preferred, @Nullable RestrictedType restrictedType, @Nullable String defaultName) {
        return Objects.toString(preferred, Objects.toString(CloudMetadatas.toDisplayName().apply((Object)restrictedType), defaultName));
    }
}

