/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.network.NetworkPeer;
import com.eucalyptus.network.NetworkRule;
import com.eucalyptus.util.ByteArray;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.vm.MetadataRequest;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public class NetworkGroupsMetadata
implements Function<MetadataRequest, ByteArray> {
    private static Logger LOG = Logger.getLogger(NetworkGroupsMetadata.class);
    private static Lock lock = new ReentrantLock();
    private static Long lastTime = 0L;
    private static AtomicReference<String> topoString = new AtomicReference<String>("");
    private static final Supplier<String> topoSupplier = new Supplier<String>(){

        public String get() {
            String ret = NetworkGroupsMetadata.generateTopology();
            topoString.set(ret);
            return ret;
        }
    };
    private static Supplier<String> topoMemoSupplier = Suppliers.memoizeWithExpiration(topoSupplier, (long)VmInstances.NETWORK_METADATA_REFRESH_TIME, (TimeUnit)TimeUnit.SECONDS);

    private String getNetworkTopology() {
        if (Databases.isVolatile().booleanValue()) {
            return topoString.get();
        }
        return (String)topoMemoSupplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateTopology() {
        StringBuilder buf = new StringBuilder();
        ArrayListMultimap networks = ArrayListMultimap.create();
        ArrayListMultimap rules = ArrayListMultimap.create();
        EntityTransaction db = Entities.get(VmInstance.class);
        try {
            Predicate<VmInstance> filter = VmInstance.VmStateSet.TORNDOWN.not();
            for (VmInstance vm : VmInstances.list(filter)) {
                try {
                    for (NetworkGroup ruleGroup : vm.getNetworkGroups()) {
                        try {
                            ruleGroup = (NetworkGroup)((Object)Entities.merge((Object)((Object)ruleGroup)));
                            networks.put((Object)ruleGroup.getClusterNetworkName(), (Object)vm.getPrivateAddress());
                            if (rules.containsKey((Object)ruleGroup.getNaturalId())) continue;
                            for (NetworkRule netRule : ruleGroup.getIngressNetworkRules()) {
                                if (netRule.isVpcOnly()) continue;
                                try {
                                    String rule = String.format("-P %s -%s %d%s%d ", new Object[]{netRule.getProtocol(), NetworkRule.Protocol.icmp.equals((Object)netRule.getProtocol()) ? "t" : "p", netRule.getLowPort(), NetworkRule.Protocol.icmp.equals((Object)netRule.getProtocol()) ? ":" : "-", netRule.getHighPort()});
                                    for (NetworkPeer peer : netRule.getNetworkPeers()) {
                                        try {
                                            Account groupAccount = Accounts.lookupAccountById((String)peer.getUserQueryKey());
                                            String groupId = NetworkGroups.lookup((OwnerFullName)AccountFullName.getInstance((Account)groupAccount, (String[])new String[0]), peer.getGroupName()).getNaturalId();
                                            String ruleString = String.format("%s -o %s -u %s", rule, groupId, groupAccount.getAccountNumber());
                                            if (rules.get((Object)ruleGroup.getClusterNetworkName()).contains(ruleString)) continue;
                                            rules.put((Object)ruleGroup.getClusterNetworkName(), (Object)ruleString);
                                        }
                                        catch (AuthException | NoSuchMetadataException e) {
                                            if (!LOG.isTraceEnabled()) continue;
                                            LOG.trace((Object)("Peer (" + peer.getUserQueryKey() + "/" + peer.getGroupName() + ") not found for network group (" + ruleGroup.getGroupId() + ")"));
                                        }
                                    }
                                    for (String cidr : netRule.getIpRanges()) {
                                        String ruleString = String.format("%s -s %s", rule, cidr);
                                        if (rules.get((Object)ruleGroup.getClusterNetworkName()).contains(ruleString)) continue;
                                        rules.put((Object)ruleGroup.getClusterNetworkName(), (Object)ruleString);
                                    }
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)ex, (Throwable)ex);
                                }
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            buf.append(NetworkGroupsMetadata.rulesToString((Multimap<String, String>)rules));
            buf.append(NetworkGroupsMetadata.groupsToString((Multimap<String, String>)networks));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        finally {
            db.rollback();
        }
        return buf.toString();
    }

    private static String groupsToString(Multimap<String, String> networks) {
        StringBuilder buf = new StringBuilder();
        for (String networkName : networks.keySet()) {
            buf.append("GROUP ").append(networkName);
            for (String ip : networks.get((Object)networkName)) {
                buf.append(" ").append(ip);
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    private static String rulesToString(Multimap<String, String> rules) {
        StringBuilder buf = new StringBuilder();
        for (String networkName : rules.keySet()) {
            for (String rule : rules.get((Object)networkName)) {
                buf.append("RULE ").append(networkName).append(" ").append(rule).append("\n");
            }
        }
        return buf.toString();
    }

    public ByteArray apply(MetadataRequest arg0) {
        return ByteArray.newInstance((String)this.getNetworkTopology());
    }
}

