/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.DeleteResourceTag;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.ResourceTagMessage;
import com.eucalyptus.compute.common.backend.CreateTagsType;
import com.eucalyptus.compute.common.backend.DeleteTagsType;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.vm.MigrationState;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmMigrationTask;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

enum MigrationTags implements Predicate<VmInstance>
{
    STATE,
    SOURCE,
    DESTINATION;

    private static Logger LOG;

    public String toString() {
        return "euca:node:migration:" + this.name().toLowerCase();
    }

    public static void deleteFor(VmInstance vm) {
        DeleteTagsType deleteTags = new DeleteTagsType();
        deleteTags.getTagSet().add(STATE.deleteTag());
        deleteTags.getTagSet().add(SOURCE.deleteTag());
        deleteTags.getTagSet().add(DESTINATION.deleteTag());
        deleteTags.getResourcesSet().add(vm.getInstanceId());
        try {
            deleteTags.setUserId(Accounts.lookupSystemAdmin().getUserId());
            deleteTags.markPrivileged();
        }
        catch (AuthException ex) {
            LOG.error((Object)ex);
        }
        MigrationTags.dispatch((ResourceTagMessage)deleteTags);
    }

    private static void dispatch(ResourceTagMessage tagMessage) {
        try {
            AsyncRequests.dispatch((ServiceConfiguration)Topology.lookup(Eucalyptus.class, (Partition[])new Partition[0]), (BaseMessage)tagMessage);
        }
        catch (Exception ex) {
            LOG.trace((Object)ex);
        }
    }

    public static void createFor(VmInstance vm) {
        VmMigrationTask migrationTask = vm.getRuntimeState().getMigrationTask();
        CreateTagsType createTags = new CreateTagsType();
        createTags.getTagSet().add(STATE.getTag(migrationTask.getState().name()));
        if (!Strings.isNullOrEmpty((String)migrationTask.getSourceHost())) {
            createTags.getTagSet().add(SOURCE.getTag(migrationTask.getSourceHost()));
        }
        if (!Strings.isNullOrEmpty((String)migrationTask.getDestinationHost())) {
            createTags.getTagSet().add(DESTINATION.getTag(migrationTask.getDestinationHost()));
        }
        createTags.getResourcesSet().add(vm.getInstanceId());
        try {
            createTags.setUserId(Accounts.lookupSystemAdmin().getUserId());
            createTags.markPrivileged();
        }
        catch (AuthException ex) {
            LOG.error((Object)ex);
        }
        MigrationTags.dispatch((ResourceTagMessage)createTags);
    }

    ResourceTag getTag(String value) {
        return new ResourceTag(this.toString(), value);
    }

    private DeleteResourceTag deleteTag() {
        DeleteResourceTag rsrcTag = new DeleteResourceTag();
        rsrcTag.setKey(this.toString());
        return rsrcTag;
    }

    public boolean apply(@Nullable VmInstance input) {
        VmMigrationTask task = input.getRuntimeState().getMigrationTask();
        if (MigrationState.none.equals((Object)task.getState())) {
            MigrationTags.deleteFor(input);
        } else {
            MigrationTags.createFor(input);
        }
        return true;
    }

    public static void update(VmInstance input) {
        SOURCE.apply(input);
    }

    static {
        LOG = Logger.getLogger(MigrationTags.class);
    }
}

