/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.vm.VmInstance;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public enum MigrationState {
    none{

        @Override
        public boolean isMigrating() {
            return false;
        }
    }
    ,
    pending,
    preparing,
    ready,
    migrating,
    cleaning;

    private static Logger LOG;

    public static boolean isMigrating(VmInstance vm) {
        return VmInstanceFilter.INSTANCE.apply(vm);
    }

    public boolean isMigrating() {
        return true;
    }

    public static MigrationState defaultValueOf(String state) {
        if (!Strings.isNullOrEmpty((String)state)) {
            try {
                return MigrationState.valueOf(state);
            }
            catch (IllegalArgumentException ex) {
                LOG.debug((Object)ex);
                return none;
            }
        }
        return none;
    }

    static {
        LOG = Logger.getLogger(MigrationState.class);
    }

    public static enum VmInstanceFilter implements Predicate<VmInstance>
    {
        INSTANCE;


        public boolean apply(@Nullable VmInstance input) {
            return VmInstance.VmState.RUNNING.apply(input) && input.getRuntimeState().getMigrationTask().getState().isMigrating();
        }
    }
}

