/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.cluster.ClusterConfiguration;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.entities.Entities;
import com.google.common.base.Optional;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public class MetadataRequest {
    private static Logger LOG = Logger.getLogger(MetadataRequest.class);
    private final String requestIp;
    private final String metadataName;
    private final String localPath;
    private final String vmId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataRequest(String requestIp, String requestUrl, Optional<String> vmId) {
        try {
            this.requestIp = requestIp;
            requestUrl = requestUrl.replaceAll("[/]+", "/");
            String[] path = requestUrl.split("/", 2);
            if (path.length > 0) {
                this.metadataName = path[0];
                this.localPath = path.length > 1 ? path[1].replaceFirst("^[/]*", "") : "";
            } else {
                this.metadataName = "";
                this.localPath = "";
            }
            this.vmId = (String)vmId.orNull();
            LOG.debug((Object)((this.vmId != null ? "Instance" : "External") + " Metadata: requestIp=" + this.requestIp + " metadataName=" + this.metadataName + " metadataPath=" + this.localPath + " requestUrl=" + requestUrl));
        }
        catch (Throwable throwable) {
            LOG.debug((Object)((this.vmId != null ? "Instance" : "External") + " Metadata: requestIp=" + this.requestIp + " metadataName=" + this.metadataName + " metadataPath=" + this.localPath + " requestUrl=" + requestUrl));
            throw throwable;
        }
    }

    public boolean isInstance() {
        return this.vmId != null;
    }

    public String getRequestIp() {
        return this.requestIp;
    }

    public String getMetadataName() {
        return this.metadataName;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String getVmInstanceId() {
        return this.vmId;
    }

    public boolean isSystem() {
        for (ServiceConfiguration config : Components.lookup(ClusterController.class).services()) {
            if (config.getHostName().equals(this.requestIp)) {
                return true;
            }
            if (!(config instanceof ClusterConfiguration) || !((ClusterConfiguration)config).getSourceHostName().equals(this.requestIp)) continue;
            return true;
        }
        if (!Databases.isVolatile().booleanValue()) {
            ClusterConfiguration cConfig = new ClusterConfiguration();
            cConfig.setSourceHostName(this.requestIp);
            EntityTransaction db = Entities.get(ClusterConfiguration.class);
            try {
                ClusterConfiguration ccAddresses = (ClusterConfiguration)Entities.uniqueResult((Object)cConfig);
                if (ccAddresses.getSourceHostName().equals(this.requestIp) || ccAddresses.getHostName().equals(this.requestIp)) {
                    db.commit();
                    return true;
                }
                db.commit();
            }
            catch (Exception e) {
                LOG.debug((Object)"Unable to find Cluster Controller request address.", (Throwable)e);
                db.rollback();
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataRequest that = (MetadataRequest)o;
        if (this.localPath != null ? !this.localPath.equals(that.localPath) : that.localPath != null) {
            return false;
        }
        if (this.metadataName != null ? !this.metadataName.equals(that.metadataName) : that.metadataName != null) {
            return false;
        }
        if (this.requestIp != null ? !this.requestIp.equals(that.requestIp) : that.requestIp != null) {
            return false;
        }
        return !(this.vmId != null ? !this.vmId.equals(that.vmId) : that.vmId != null);
    }

    public int hashCode() {
        int result = this.requestIp != null ? this.requestIp.hashCode() : 0;
        result = 31 * result + (this.metadataName != null ? this.metadataName.hashCode() : 0);
        result = 31 * result + (this.localPath != null ? this.localPath.hashCode() : 0);
        result = 31 * result + (this.vmId != null ? this.vmId.hashCode() : 0);
        return result;
    }
}

