/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.cluster.callback.StartInstanceCallback;
import com.eucalyptus.cluster.callback.StopInstanceCallback;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.BlockDeviceMappingItemType;
import com.eucalyptus.compute.common.ComputeMessage;
import com.eucalyptus.compute.common.EbsDeviceMapping;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.ReservationInfoType;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.Snapshot;
import com.eucalyptus.compute.common.backend.CreateSnapshotResponseType;
import com.eucalyptus.compute.common.backend.CreateSnapshotType;
import com.eucalyptus.compute.common.backend.DescribeInstancesResponseType;
import com.eucalyptus.compute.common.backend.DescribeInstancesType;
import com.eucalyptus.compute.common.backend.DescribeSnapshotsResponseType;
import com.eucalyptus.compute.common.backend.DescribeSnapshotsType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.images.BlockStorageImageInfo;
import com.eucalyptus.images.DeviceMapping;
import com.eucalyptus.images.Emis;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.images.Images;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Futures;
import com.eucalyptus.vm.VmCreateImageSnapshot;
import com.eucalyptus.vm.VmCreateImageTask;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmRuntimeState;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.StartInstanceResponseType;
import edu.ucsb.eucalyptus.msgs.StopInstanceResponseType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class CreateImageTask {
    private static Logger LOG = Logger.getLogger(CreateImageTask.class);
    private static Map<String, CreateImageTask> createImageTasks = new ConcurrentHashMap<String, CreateImageTask>();
    private String userId = null;
    private String accountAdminId = null;
    private String instanceId = null;
    private Boolean noReboot = null;
    private List<BlockDeviceMappingItemType> blockDevices = null;
    static Function<VmInstance, CreateImageTask> RESTORE = new Function<VmInstance, CreateImageTask>(){

        @Nullable
        public CreateImageTask apply(@Nullable VmInstance input) {
            String userId = input.getOwnerUserId();
            String instanceId = input.getDisplayName();
            Boolean noReboot = null;
            List deviceMaps = null;
            VmCreateImageTask vmTask = input.getRuntimeState().getVmCreateImageTask();
            if (vmTask == null) {
                throw Exceptions.toUndeclared((String)"Failed to find the VmCreateImageTask", (Throwable[])new Throwable[0]);
            }
            if (vmTask.getImageId() != null) {
                try {
                    deviceMaps = CreateImageTask.getDeviceMappingsFromImage(vmTask.getImageId());
                }
                catch (Exception ex) {
                    LOG.error((Object)"failed to pull device mapping information from the image", (Throwable)ex);
                }
            }
            noReboot = vmTask.getNoReboot();
            CreateImageTask newTask = new CreateImageTask(userId, instanceId, noReboot, deviceMaps);
            try {
                newTask.setAccountAdmin();
            }
            catch (AuthException ex) {
                throw Exceptions.toUndeclared((String)"Failed to set account admin", (Throwable[])new AuthException[]{ex});
            }
            try {
                String partition = input.getPartition();
                ServiceConfiguration sc = Topology.lookup(Storage.class, (Partition[])new Partition[]{Partitions.lookupByName((String)partition)});
                Collection enabledSCs = Topology.enabledServices(Storage.class);
                if (enabledSCs.contains(sc)) {
                    return newTask;
                }
                return null;
            }
            catch (Exception ex) {
                LOG.error((Object)"failed to check state of storage controller", (Throwable)ex);
                return null;
            }
        }
    };

    public CreateImageTask(String userId, String instanceId, Boolean noReboot, List<BlockDeviceMappingItemType> blockDevices) {
        this.userId = userId;
        this.instanceId = instanceId;
        this.noReboot = noReboot;
        this.blockDevices = blockDevices;
    }

    private void setVmCreateImageTaskState(VmCreateImageTask.CreateImageState state) {
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(this.instanceId))));
            vm.getRuntimeState().setCreateImageTaskState(state);
            Entities.persist((Object)((Object)vm));
            db.commit();
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VmInstance getVmInstance() {
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(this.instanceId))));
            db.commit();
            VmInstance vmInstance = vm;
            return vmInstance;
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<BlockDeviceMappingItemType> getDeviceMappingsFromImage(String imageId) {
        ArrayList deviceMaps = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            BlockStorageImageInfo image = (BlockStorageImageInfo)Entities.uniqueResult((Object)((Object)BlockStorageImageInfo.named(imageId)));
            List<DeviceMapping> dmSet = image.getDeviceMappings();
            for (DeviceMapping dm : dmSet) {
                BlockDeviceMappingItemType dmItem = Images.DeviceMappingDetails.INSTANCE.apply(dm);
                deviceMaps.add(dmItem);
            }
            db.commit();
            ArrayList arrayList = deviceMaps;
            return arrayList;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private VmCreateImageTask.CreateImageState getVmCreateImageTaskState() {
        VmInstance vm = this.getVmInstance();
        if (vm.getRuntimeState() != null) {
            return vm.getRuntimeState().getCreateImageTaskState();
        }
        throw Exceptions.toUndeclared((Throwable)new EucalyptusCloudException("No Runtime state found for the instance"));
    }

    private void validateVmInstance() throws Exception {
        VmInstance vm = this.getVmInstance();
        if (vm == null) {
            throw new EucalyptusCloudException("Unable to find the vm");
        }
        if (!VmInstance.VmState.RUNNING.equals(vm.getState()) && !VmInstance.VmState.STOPPED.equals(vm.getState())) {
            throw new EucalyptusCloudException("Instance is not in running or stopped state");
        }
        if (vm.getBootRecord() == null || !vm.getBootRecord().isBlockStorage()) {
            throw new EucalyptusCloudException("createImage can be performed only to EBS-backed instances");
        }
        VmRuntimeState runtime = vm.getRuntimeState();
        if (runtime != null && runtime.isCreatingImage().booleanValue()) {
            throw new EucalyptusCloudException("Existing CreateImage task is found for the instance");
        }
        if (createImageTasks.containsKey(this.instanceId)) {
            throw new EucalyptusCloudException("Existing CreateImageTask is found");
        }
    }

    public void create(String imageId) throws Exception {
        LOG.info((Object)String.format("Starting create image task for %s : %s", this.instanceId, imageId));
        this.setAccountAdmin();
        this.validateVmInstance();
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(this.instanceId))));
            if (VmInstance.VmState.STOPPED.equals(vm.getState()) && !this.noReboot.booleanValue()) {
                LOG.debug((Object)"Reboot is not possible for stopped instance");
                this.noReboot = true;
            }
            vm.getRuntimeState().resetCreateImageTask(VmCreateImageTask.CreateImageState.pending, imageId, null, this.noReboot);
            Entities.persist((Object)((Object)vm));
            db.commit();
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
        createImageTasks.put(this.instanceId, this);
        return;
    }

    private void setAccountAdmin() throws AuthException {
        User requestingUser = Accounts.lookupUserById((String)this.userId);
        Account account = requestingUser.getAccount();
        User adminUser = account.lookupAdmin();
        this.accountAdminId = adminUser.getUserId();
    }

    private String getInstanceImageId() {
        return this.getVmInstance().getImageId();
    }

    private String getInstanceArchitecture() {
        ImageInfo image = Emis.LookupImage.INSTANCE.apply(this.getInstanceImageId());
        return image.getArchitecture().name();
    }

    private Map.Entry<String, String> getInstanceRootVolume() {
        VmInstance vm = this.getVmInstance();
        final ArrayList rootVolumes = Lists.newArrayList();
        vm.eachVolumeAttachment(new Predicate<VmVolumeAttachment>(){

            public boolean apply(@Nullable VmVolumeAttachment input) {
                if (input.getIsRootDevice().booleanValue()) {
                    rootVolumes.add(new AbstractMap.SimpleEntry<String, String>(input.getDevice(), input.getVolumeId()));
                }
                return true;
            }
        });
        if (rootVolumes.size() > 0) {
            return (Map.Entry)rootVolumes.get(0);
        }
        throw Exceptions.toUndeclared((Throwable)new EucalyptusCloudException("Root volume is not found"));
    }

    private List<Map.Entry<String, String>> getInstanceNonRootVolumes() {
        VmInstance vm = this.getVmInstance();
        final ArrayList volumes = Lists.newArrayList();
        vm.eachVolumeAttachment(new Predicate<VmVolumeAttachment>(){

            public boolean apply(@Nullable VmVolumeAttachment input) {
                if (!input.getIsRootDevice().booleanValue()) {
                    volumes.add(new AbstractMap.SimpleEntry<String, String>(input.getDevice(), input.getVolumeId()));
                }
                return true;
            }
        });
        return volumes;
    }

    private Boolean isDeleteOnTerminate(String volumeId) {
        VmInstance vm = this.getVmInstance();
        final ArrayList deleteOnTerminates = Lists.newArrayList();
        vm.eachVolumeAttachment(new Predicate<VmVolumeAttachment>(){

            public boolean apply(@Nullable VmVolumeAttachment input) {
                if (input.getDeleteOnTerminate().booleanValue()) {
                    deleteOnTerminates.add(input.getVolumeId());
                }
                return true;
            }
        });
        return deleteOnTerminates.contains(volumeId);
    }

    private String getImageId() {
        VmInstance vm = this.getVmInstance();
        return vm.getRuntimeState().getVmCreateImageTask().getImageId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getSnapshotIds() {
        List snapshots = null;
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(this.instanceId))));
            snapshots = Lists.transform((List)Lists.newArrayList(vm.getRuntimeState().getVmCreateImageTask().getSnapshots()), (Function)new Function<VmCreateImageSnapshot, String>(){

                @Nullable
                public String apply(@Nullable VmCreateImageSnapshot input) {
                    return input.getSnapshotId();
                }
            });
            db.commit();
            List list = snapshots;
            return list;
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private List<String> getSnapshotStatus() {
        try {
            EucalyptusDescribeSnapshotTask task = new EucalyptusDescribeSnapshotTask(this.getSnapshotIds());
            CheckedListenableFuture<Boolean> result = task.dispatch();
            if (((Boolean)result.get()).booleanValue()) {
                List<Snapshot> snapshots = task.getSnapshots();
                ArrayList status = Lists.newArrayList();
                for (Snapshot s : snapshots) {
                    LOG.info((Object)String.format("snapshot creating - %s", s.getProgress()));
                    status.add(s.getStatus());
                }
                return status;
            }
            throw new EucalyptusCloudException("Unable to describe snapshots");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private void createSnapshot() {
        ArrayList volumesToSnapshot = Lists.newArrayList();
        volumesToSnapshot.add(this.getInstanceRootVolume());
        ArrayList<String> suppressedDevice = new ArrayList<String>();
        for (BlockDeviceMappingItemType blockDeviceMappingItemType : this.blockDevices) {
            if (blockDeviceMappingItemType.getNoDevice() == null || !blockDeviceMappingItemType.getNoDevice().booleanValue()) continue;
            suppressedDevice.add(blockDeviceMappingItemType.getDeviceName());
        }
        for (Map.Entry entry : this.getInstanceNonRootVolumes()) {
            if (suppressedDevice.contains(entry.getKey())) continue;
            volumesToSnapshot.add(entry);
        }
        Boolean isRootDevice = true;
        for (Map.Entry volume : volumesToSnapshot) {
            String deviceName = (String)volume.getKey();
            String volumeId = (String)volume.getValue();
            String snapshotId = null;
            try {
                EucalyptusCreateSnapshotTask task = new EucalyptusCreateSnapshotTask(volumeId, String.format("Created by CreateImage(%s) for %s from %s", this.instanceId, this.getImageId(), volumeId));
                CheckedListenableFuture<Boolean> result = task.dispatch();
                if (!((Boolean)result.get()).booleanValue()) {
                    throw new EucalyptusCloudException(String.format("Unable to create the snapshot from volume %s", volumeId));
                }
                snapshotId = task.getSnapshotId();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
            LOG.info((Object)String.format("Created snapshot %s from volume %s for device %s", snapshotId, volumeId, deviceName));
            try {
                TransactionResource db = Entities.transactionFor(VmInstance.class);
                Throwable throwable = null;
                try {
                    VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(this.instanceId))));
                    vm.getRuntimeState().getVmCreateImageTask().addSnapshot(deviceName, snapshotId, isRootDevice, this.isDeleteOnTerminate(volumeId));
                    isRootDevice = false;
                    Entities.persist((Object)((Object)vm));
                    db.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (db == null) continue;
                    if (throwable != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    db.close();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"failed to add new snapshot", (Throwable)ex);
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<VmCreateImageSnapshot> getSnapshots() {
        try (TransactionResource db = Entities.transactionFor(VmInstance.class);){
            VmInstance vm = (VmInstance)((Object)Entities.uniqueResult((Object)((Object)VmInstance.named(this.instanceId))));
            ArrayList snapshots = Lists.newArrayList(vm.getRuntimeState().getVmCreateImageTask().getSnapshots());
            db.commit();
            ArrayList arrayList = snapshots;
            return arrayList;
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to pull snapshot info", (Throwable)ex);
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private RunningInstancesItemType describeInstance() {
        try {
            EucalyptusDescribeInstanceTask task = new EucalyptusDescribeInstanceTask();
            CheckedListenableFuture<Boolean> result = task.dispatch();
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusCloudException(String.format("Failed to describe instance %s", this.instanceId));
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private void stopInstance() {
        VmInstance vm = this.getVmInstance();
        vm.getRuntimeState().stopVmInstance(new CreateImageStopInstanceCallback());
    }

    private void startInstance() {
        VmInstance vm = this.getVmInstance();
        vm.getRuntimeState().startVmInstance(new CreateImageStartInstanceCallback());
    }

    private void registerImage() {
        try {
            String imageId = this.getImageId();
            if (imageId == null) {
                throw new EucalyptusCloudException("Image Id should be available before full registration");
            }
            List<VmCreateImageSnapshot> snapshots = this.getSnapshots();
            ArrayList devices = Lists.newArrayList();
            String rootDeviceName = null;
            for (VmCreateImageSnapshot snapshot : snapshots) {
                if (snapshot.isRootDevice().booleanValue()) {
                    rootDeviceName = snapshot.getDeviceName();
                }
                BlockDeviceMappingItemType device = new BlockDeviceMappingItemType();
                device.setDeviceName(snapshot.getDeviceName());
                EbsDeviceMapping ebsMap = new EbsDeviceMapping();
                ebsMap.setSnapshotId(snapshot.getSnapshotId());
                device.setEbs(ebsMap);
                devices.add(device);
            }
            UserFullName accountAdmin = UserFullName.getInstance((String)this.accountAdminId, (String[])new String[0]);
            ImageInfo imageInfo = Images.updateWithDeviceMapping(imageId, accountAdmin, rootDeviceName, devices);
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private abstract class EucalyptusActivityTask<TM extends BaseMessage, TC extends ComponentId> {
        private volatile boolean dispatched = false;

        protected EucalyptusActivityTask() {
        }

        final CheckedListenableFuture<Boolean> dispatch() {
            try {
                final CheckedListenableFuture future = Futures.newGenericeFuture();
                this.dispatchInternal(new Callback.Checked<TM>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void fireException(Throwable throwable) {
                        try {
                            EucalyptusActivityTask.this.dispatchFailure(throwable);
                        }
                        finally {
                            future.set((Object)false);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void fire(TM response) {
                        try {
                            EucalyptusActivityTask.this.dispatchSuccess(response);
                        }
                        finally {
                            future.set((Object)true);
                        }
                    }
                });
                this.dispatched = true;
                return future;
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                return Futures.predestinedFuture((Object)false);
            }
        }

        abstract void dispatchInternal(Callback.Checked<TM> var1);

        void dispatchFailure(Throwable throwable) {
            LOG.error((Object)"CreateImage task error", throwable);
        }

        abstract void dispatchSuccess(TM var1);

        protected DispatchingClient<ComputeMessage, Eucalyptus> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(CreateImageTask.this.accountAdminId, Eucalyptus.class);
                client.init();
                return client;
            }
            catch (Exception e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }

    private class EucalyptusDescribeInstanceTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private RunningInstancesItemType result = null;

        private EucalyptusDescribeInstanceTask() {
        }

        private DescribeInstancesType describeInstances() {
            DescribeInstancesType req = new DescribeInstancesType();
            req.setInstancesSet(Lists.newArrayList((Object[])new String[]{CreateImageTask.this.instanceId}));
            return req;
        }

        @Override
        void dispatchInternal(Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = this.getClient();
            client.dispatch((BaseMessage)this.describeInstances(), callback);
        }

        @Override
        void dispatchSuccess(ComputeMessage response) {
            DescribeInstancesResponseType resp = (DescribeInstancesResponseType)response;
            ArrayList resultInstances = Lists.newArrayList();
            for (ReservationInfoType res : resp.getReservationSet()) {
                resultInstances.addAll(res.getInstancesSet());
            }
            if (resultInstances.size() > 0) {
                this.result = (RunningInstancesItemType)resultInstances.get(0);
            }
        }

        public RunningInstancesItemType getResult() {
            return this.result;
        }
    }

    private class EucalyptusCreateSnapshotTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String volumeId = null;
        private String snapshotId = null;
        private String description = null;

        private EucalyptusCreateSnapshotTask(String volumeId, String description) {
            this.volumeId = volumeId;
            this.description = description;
        }

        private CreateSnapshotType createSnapshot() {
            CreateSnapshotType req = new CreateSnapshotType();
            req.setVolumeId(this.volumeId);
            req.setDescription(this.description);
            return req;
        }

        @Override
        void dispatchInternal(Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = this.getClient();
            client.dispatch((BaseMessage)this.createSnapshot(), callback);
        }

        @Override
        void dispatchSuccess(ComputeMessage response) {
            CreateSnapshotResponseType resp = (CreateSnapshotResponseType)response;
            this.snapshotId = resp.getSnapshot().getSnapshotId();
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }
    }

    private class EucalyptusDescribeSnapshotTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private List<Snapshot> snapshots = null;
        private List<String> snapshotIds = null;

        private EucalyptusDescribeSnapshotTask(List<String> snapshotIds) {
            this.snapshotIds = snapshotIds;
        }

        private DescribeSnapshotsType describeSnapshots() {
            DescribeSnapshotsType req = new DescribeSnapshotsType();
            req.setSnapshotSet(Lists.newArrayList(this.snapshotIds));
            return req;
        }

        @Override
        void dispatchInternal(Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = this.getClient();
            client.dispatch((BaseMessage)this.describeSnapshots(), callback);
        }

        @Override
        void dispatchSuccess(ComputeMessage response) {
            DescribeSnapshotsResponseType resp = (DescribeSnapshotsResponseType)response;
            this.snapshots = resp.getSnapshotSet();
        }

        public List<Snapshot> getSnapshots() {
            return this.snapshots;
        }
    }

    private class CreateImageStartInstanceCallback
    extends StartInstanceCallback {
        private CreateImageStartInstanceCallback() {
        }

        public void fire(StartInstanceResponseType msg) {
            if (!msg.get_return().booleanValue()) {
                LOG.error((Object)String.format("failed to start instance %s", CreateImageTask.this.instanceId));
                CreateImageTask.this.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.failed);
            } else {
                VmCreateImageTask.CreateImageState lastState = CreateImageTask.this.getVmCreateImageTaskState();
                if (lastState != VmCreateImageTask.CreateImageState.failed && lastState != VmCreateImageTask.CreateImageState.complete) {
                    CreateImageTask.this.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.guest_starting);
                }
            }
        }
    }

    private class CreateImageStopInstanceCallback
    extends StopInstanceCallback {
        private CreateImageStopInstanceCallback() {
        }

        public void fire(StopInstanceResponseType msg) {
            if (!msg.get_return().booleanValue()) {
                LOG.error((Object)String.format("failed to stop instance %s", CreateImageTask.this.instanceId));
                CreateImageTask.this.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.failed);
            } else {
                CreateImageTask.this.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.guest_stopping);
            }
        }
    }

    public static class CreateImageTasksManager
    implements EventListener<ClockTick> {
        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new CreateImageTasksManager());
        }

        public void fireEvent(ClockTick event) {
            if (!Bootstrap.isFinished().booleanValue() || !Topology.isEnabledLocally(Eucalyptus.class)) {
                return;
            }
            List<VmInstance> candidates = VmInstances.list((Predicate<? super VmInstance>)new Predicate<VmInstance>(){

                public boolean apply(@Nullable VmInstance input) {
                    return (VmInstance.VmState.RUNNING.equals(input.getState()) || VmInstance.VmState.STOPPED.equals(input.getState())) && input.isBlockStorage() && input.getRuntimeState().isCreatingImage() != false;
                }
            });
            try {
                for (VmInstance candidate : candidates) {
                    if (createImageTasks.containsKey(candidate.getInstanceId())) continue;
                    LOG.info((Object)String.format("Restoring create image task for %s", candidate.getInstanceId()));
                    CreateImageTask task = (CreateImageTask)RESTORE.apply((Object)candidate);
                    if (task == null) continue;
                    createImageTasks.put(candidate.getInstanceId(), task);
                    LOG.info((Object)String.format("craete image task for %s restored", candidate.getInstanceId()));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"unable to retore create-image task", (Throwable)ex);
            }
            HashMap<VmCreateImageTask.CreateImageState, ArrayList> taskByState = new HashMap<VmCreateImageTask.CreateImageState, ArrayList>();
            for (String instId : createImageTasks.keySet()) {
                CreateImageTask task = (CreateImageTask)createImageTasks.get(instId);
                VmCreateImageTask.CreateImageState taskState = task.getVmCreateImageTaskState();
                if (!taskByState.containsKey((Object)taskState)) {
                    taskByState.put(taskState, Lists.newArrayList());
                }
                ((List)taskByState.get((Object)taskState)).add(task);
            }
            if (taskByState.containsKey((Object)VmCreateImageTask.CreateImageState.pending)) {
                try {
                    this.processPendingTasks((List)taskByState.get((Object)VmCreateImageTask.CreateImageState.pending));
                }
                catch (Exception ex) {
                    LOG.error((Object)"exception while processing pending CreateImageTask", (Throwable)ex);
                }
            }
            if (taskByState.containsKey((Object)VmCreateImageTask.CreateImageState.guest_stopping)) {
                try {
                    this.processStoppingTasks((List)taskByState.get((Object)VmCreateImageTask.CreateImageState.guest_stopping));
                }
                catch (Exception ex) {
                    LOG.error((Object)"exception while processing stopping CreateImageTask", (Throwable)ex);
                }
            }
            if (taskByState.containsKey((Object)VmCreateImageTask.CreateImageState.creating_snapshot)) {
                try {
                    this.processSnapshottingTasks((List)taskByState.get((Object)VmCreateImageTask.CreateImageState.creating_snapshot));
                }
                catch (Exception ex) {
                    LOG.error((Object)"exception while processing snapshotting CreateImageTask", (Throwable)ex);
                }
            }
            if (taskByState.containsKey((Object)VmCreateImageTask.CreateImageState.guest_starting)) {
                try {
                    this.processStartingTasks((List)taskByState.get((Object)VmCreateImageTask.CreateImageState.guest_starting));
                }
                catch (Exception ex) {
                    LOG.error((Object)"exception while processing snapshotting CreateImageTask", (Throwable)ex);
                }
            }
            if (taskByState.containsKey((Object)VmCreateImageTask.CreateImageState.complete)) {
                try {
                    this.processCompleteTasks((List)taskByState.get((Object)VmCreateImageTask.CreateImageState.complete));
                }
                catch (Exception ex) {
                    LOG.error((Object)"exception while processing complete CreateImageTask", (Throwable)ex);
                }
            }
            if (taskByState.containsKey((Object)VmCreateImageTask.CreateImageState.failed)) {
                try {
                    this.processFailedTasks((List)taskByState.get((Object)VmCreateImageTask.CreateImageState.failed));
                }
                catch (Exception ex) {
                    LOG.error((Object)"exception while processing failed CreateImageTask", (Throwable)ex);
                }
            }
        }

        private void processPendingTasks(List<CreateImageTask> tasks) {
            for (CreateImageTask task : tasks) {
                if (!task.noReboot.booleanValue()) {
                    try {
                        task.stopInstance();
                        LOG.info((Object)String.format("Stopping instance %s", task.instanceId));
                    }
                    catch (Exception ex) {
                        LOG.error((Object)String.format("failed to stop instance %s", task.instanceId), (Throwable)ex);
                        task.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.failed);
                    }
                    continue;
                }
                try {
                    task.createSnapshot();
                    task.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.creating_snapshot);
                }
                catch (Exception ex) {
                    LOG.error((Object)String.format("failed to create the snapshots from %s", task.instanceId), (Throwable)ex);
                    task.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.failed);
                }
            }
        }

        private void processStoppingTasks(List<CreateImageTask> tasks) {
            for (CreateImageTask task : tasks) {
                VmInstance vm = task.getVmInstance();
                if (vm.getRuntimeState() == null || !"poweredOff".equals(vm.getRuntimeState().getGuestState())) continue;
                try {
                    task.createSnapshot();
                    task.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.creating_snapshot);
                }
                catch (Exception ex) {
                    LOG.error((Object)String.format("failed to create the snapshot from %s", task.instanceId), (Throwable)ex);
                    task.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.failed);
                }
            }
        }

        private void processSnapshottingTasks(List<CreateImageTask> tasks) {
            for (CreateImageTask task : tasks) {
                try {
                    List status = task.getSnapshotStatus();
                    boolean allDone = true;
                    for (String s : status) {
                        if ("completed".equals(s)) continue;
                        if ("failed".equals(s)) {
                            throw new EucalyptusCloudException("Snapshot creation failed");
                        }
                        allDone = false;
                    }
                    if (!allDone) continue;
                    task.registerImage();
                    LOG.info((Object)String.format("Image %s is available", task.getImageId()));
                    if (task.noReboot.booleanValue()) {
                        task.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.complete);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"failed to register the image", (Throwable)ex);
                    task.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.failed);
                }
                if (task.noReboot.booleanValue()) continue;
                try {
                    VmInstance vm = task.getVmInstance();
                    if (vm.getRuntimeState() == null || !"poweredOff".equals(vm.getRuntimeState().getGuestState())) continue;
                    task.startInstance();
                    LOG.info((Object)String.format("Restarting instance %s", vm.getInstanceId()));
                }
                catch (Exception ex) {
                    LOG.error((Object)String.format("failed to start the instance %s", task.instanceId), (Throwable)ex);
                    task.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.failed);
                }
            }
        }

        private void processStartingTasks(List<CreateImageTask> tasks) {
            for (CreateImageTask task : tasks) {
                try {
                    VmInstance vm = task.getVmInstance();
                    if (vm.getRuntimeState() == null || !"poweredOn".equals(vm.getRuntimeState().getGuestState())) continue;
                    task.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.complete);
                }
                catch (Exception ex) {
                    LOG.error((Object)String.format("failed to check the guest state for %s", task.instanceId), (Throwable)ex);
                    task.setVmCreateImageTaskState(VmCreateImageTask.CreateImageState.failed);
                }
            }
        }

        private void processCompleteTasks(List<CreateImageTask> tasks) {
            for (CreateImageTask task : tasks) {
                LOG.info((Object)String.format("CreateImage is done for instance %s; Image %s registered", task.instanceId, task.getImageId()));
                createImageTasks.remove(task.instanceId);
            }
        }

        private void processFailedTasks(List<CreateImageTask> tasks) {
            for (CreateImageTask task : tasks) {
                LOG.error((Object)String.format("CreateImage has failed for instance %s", task.instanceId));
                try {
                    Images.setImageState(task.getImageId(), ImageMetadata.State.failed);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Unable to set image state as failed");
                }
                createImageTasks.remove(task.instanceId);
            }
        }
    }
}

