/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.vm;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.VersionListing;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.tokens.SecurityTokenAWSCredentialsProvider;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.ClientComputeException;
import com.eucalyptus.compute.ComputeException;
import com.eucalyptus.context.IllegalContextAccessException;
import com.eucalyptus.context.ServiceStateException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.client.EucaS3Client;
import com.eucalyptus.objectstorage.client.EucaS3ClientFactory;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.MessageCallback;
import com.eucalyptus.vm.BundleInstanceResponseType;
import com.eucalyptus.vm.BundleInstanceType;
import com.eucalyptus.vm.BundleRestartInstanceResponseType;
import com.eucalyptus.vm.BundleRestartInstanceType;
import com.eucalyptus.vm.BundleTask;
import com.eucalyptus.vm.CancelBundleTaskResponseType;
import com.eucalyptus.vm.CancelBundleTaskType;
import com.eucalyptus.vm.VmBundleTask;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public class Bundles {
    private static final Map<String, VmBundleTask> previousBundleTaskMap = Maps.newConcurrentMap();
    private static Logger LOG = Logger.getLogger(Bundles.class);

    public static synchronized void putPreviousTask(VmBundleTask previousTask) {
        if (previousTask != null) {
            previousBundleTaskMap.put(previousTask.getBundleId(), VmBundleTask.copyOf(previousTask));
        }
    }

    public static synchronized Map<String, VmBundleTask> getPreviousBundleTasks() {
        return ImmutableMap.copyOf(previousBundleTaskMap);
    }

    public static MessageCallback createCallback(BundleInstanceType request) throws AuthException, IllegalContextAccessException, ServiceStateException {
        String objectStorageUrl = ServiceUris.remote((ServiceConfiguration)Topology.lookup(ObjectStorage.class, (Partition[])new Partition[0]), (String[])new String[0]).toASCIIString();
        request.setUrl(objectStorageUrl);
        return new BundleCallback(request);
    }

    public static MessageCallback cancelCallback(CancelBundleTaskType request) {
        return new CancelBundleCallback(request);
    }

    public static MessageCallback bundleRestartInstanceCallback(BundleRestartInstanceType request) {
        return new BundleRestartInstanceCallback(request);
    }

    public static BundleTask transform(VmBundleTask bundleTask) {
        return (BundleTask)((Object)VmBundleTask.asBundleTask().apply((Object)bundleTask));
    }

    public static VmBundleTask create(VmInstance v, String bucket, String prefix, String policy) throws AuthException {
        Bundles.verifyPolicy(policy, bucket);
        return VmBundleTask.create(v, bucket, prefix, policy);
    }

    private static void verifyPolicy(String policy, String bucketName) {
        int idxOpenBracket = policy.indexOf("{");
        int idxClosingBracket = policy.lastIndexOf("}");
        if (idxOpenBracket < 0 || idxClosingBracket < 0 || idxOpenBracket >= idxClosingBracket) {
            throw new RuntimeException("Custom policy is not acceptable for bundle instance");
        }
        String bucketAndAcl = policy.substring(idxOpenBracket, idxClosingBracket - idxOpenBracket);
        if (!bucketAndAcl.contains(bucketName)) {
            throw new RuntimeException("Custom policy is not acceptable for bundle instance");
        }
        if (!bucketAndAcl.contains("ec2-bundle-read")) {
            throw new RuntimeException("Custom policy is not acceptable for bundle instance");
        }
    }

    static void checkAndCreateBucket(User user, String bucketName, String prefix) throws ComputeException {
        try (EucaS3Client s3c = EucaS3ClientFactory.getEucaS3Client((AWSCredentialsProvider)new SecurityTokenAWSCredentialsProvider(user));){
            boolean foundBucket = false;
            List buckets = s3c.listBuckets();
            for (Bucket bucket : buckets) {
                ObjectListing objects;
                foundBucket = bucketName.equals(bucket.getName());
                if (!foundBucket) continue;
                if (Strings.isNullOrEmpty((String)prefix) || (objects = s3c.listObjects(bucketName, Strings.emptyToNull((String)prefix))).getObjectSummaries().isEmpty()) break;
                throw new ClientComputeException("InvalidParameterValue", "Bucket prefix in use " + bucketName + "/" + prefix);
            }
            if (!foundBucket) {
                s3c.createBucket(bucketName);
            }
        }
        catch (Exception ex) {
            Exceptions.findAndRethrow((Throwable)ex, ComputeException.class);
            if (ex instanceof AmazonS3Exception && "BucketAlreadyExists".equals(((AmazonS3Exception)ex).getErrorCode())) {
                throw new ClientComputeException("InvalidParameterValue", "Bucket already exists " + bucketName);
            }
            LOG.debug((Object)("Unable to create bucket " + bucketName), (Throwable)ex);
            throw new ComputeException("InternalError", "Unable to create bucket " + bucketName);
        }
    }

    static void deleteBucketContent(User user, String bucketName, String prefix, boolean deleteEmptyBucket) throws ComputeException {
        try (EucaS3Client s3c = EucaS3ClientFactory.getEucaS3Client((AWSCredentialsProvider)new SecurityTokenAWSCredentialsProvider(user));){
            List buckets = s3c.listBuckets();
            boolean bucketFound = false;
            for (Bucket bucket : buckets) {
                if (!bucketName.equals(bucket.getName())) continue;
                bucketFound = true;
                break;
            }
            if (bucketFound) {
                VersionListing versions;
                ObjectListing objects = s3c.listObjects(bucketName, Strings.emptyToNull((String)prefix));
                for (S3ObjectSummary object : objects.getObjectSummaries()) {
                    s3c.deleteObject(bucketName, object.getKey());
                }
                if (deleteEmptyBucket && (versions = s3c.listVersions(bucketName, null)).getVersionSummaries().isEmpty()) {
                    s3c.deleteBucket(bucketName);
                }
            }
        }
        catch (Exception ex) {
            LOG.debug((Object)("Error deleting bucket (" + bucketName + ") " + (Strings.isNullOrEmpty((String)prefix) ? "" : "prefix (" + prefix + ") ") + "for user " + user.getUserId()), (Throwable)ex);
            throw new ComputeException("InternalError", "Unable to delete the bucket");
        }
    }

    public static class BundleCallback
    extends MessageCallback<BundleInstanceType, BundleInstanceResponseType> {
        private BundleCallback(BundleInstanceType request) {
            super((BaseMessage)request);
        }

        public void fire(BundleInstanceResponseType reply) {
            EntityTransaction db = Entities.get(VmInstance.class);
            try {
                if (!reply.get_return().booleanValue()) {
                    LOG.info((Object)("Attempt to bundle instance " + ((BundleInstanceType)this.getRequest()).getInstanceId() + " has failed."));
                } else {
                    VmInstance vm = VmInstances.lookup(((BundleInstanceType)this.getRequest()).getInstanceId());
                    vm.getRuntimeState().submittedBundleTask();
                    EventRecord.here(BundleCallback.class, (EventType)EventType.BUNDLE_STARTED, (String[])new String[]{((BundleInstanceType)this.getRequest()).toSimpleString(), "" + vm.getRuntimeState(), vm.getInstanceId()}).info();
                }
                db.commit();
            }
            catch (Exception ex) {
                Logs.exhaust().error((Object)ex, (Throwable)ex);
                db.rollback();
            }
        }
    }

    public static class BundleRestartInstanceCallback
    extends MessageCallback<BundleRestartInstanceType, BundleRestartInstanceResponseType> {
        private BundleRestartInstanceCallback(BundleRestartInstanceType request) {
            super((BaseMessage)request);
        }

        public void fire(BundleRestartInstanceResponseType reply) {
            if (!reply.get_return().booleanValue()) {
                LOG.info((Object)("Attempt to restart bundle instance " + ((BundleRestartInstanceType)this.getRequest()).getInstanceId() + " has failed."));
            } else {
                EntityTransaction db = Entities.get(VmInstance.class);
                try {
                    VmInstance vm = VmInstances.lookup(((BundleRestartInstanceType)this.getRequest()).getInstanceId());
                    vm.getRuntimeState().restartBundleTask();
                    EventRecord.here(CancelBundleCallback.class, (EventType)EventType.BUNDLE_RESTART, (String[])new String[]{((BundleRestartInstanceType)this.getRequest()).toSimpleString(), vm.getRuntimeState().getBundleTask().getBundleId(), vm.getInstanceId()}).info();
                    db.commit();
                }
                catch (Exception ex) {
                    Logs.exhaust().error((Object)ex, (Throwable)ex);
                    db.rollback();
                }
            }
        }
    }

    public static class CancelBundleCallback
    extends MessageCallback<CancelBundleTaskType, CancelBundleTaskResponseType> {
        private CancelBundleCallback(CancelBundleTaskType request) {
            super((BaseMessage)request);
        }

        public void fire(CancelBundleTaskResponseType reply) {
            if (!reply.get_return().booleanValue()) {
                LOG.info((Object)("Attempt to CancelBundleTask for instance " + ((CancelBundleTaskType)this.getRequest()).getBundleId() + " has failed."));
            } else {
                EntityTransaction db = Entities.get(VmInstance.class);
                try {
                    VmInstance vm = VmInstances.lookupByBundleId(((CancelBundleTaskType)this.getRequest()).getBundleId());
                    vm.getRuntimeState().cancelBundleTask();
                    EventRecord.here(CancelBundleCallback.class, (EventType)EventType.BUNDLE_CANCELLED, (String[])new String[]{((CancelBundleTaskType)this.getRequest()).toSimpleString(), vm.getRuntimeState().getBundleTask().getBundleId(), vm.getInstanceId()}).info();
                    db.commit();
                }
                catch (Exception ex) {
                    Logs.exhaust().error((Object)ex, (Throwable)ex);
                    db.rollback();
                }
            }
        }
    }
}

