/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.async;

import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.util.EucalyptusClusterException;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.BroadcastCallback;
import com.eucalyptus.util.async.RemoteCallback;
import com.eucalyptus.util.async.Request;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class StatefulMessageSet<E extends Enum<E>> {
    private static Logger LOG = Logger.getLogger(StatefulMessageSet.class);
    private final Multimap<E, Request> messages = ArrayListMultimap.create();
    private final List<Runnable> cleanupTasks = Lists.newArrayList();
    private final ConcurrentLinkedQueue<Request> pendingEvents = new ConcurrentLinkedQueue();
    private final E[] states;
    private E state;
    private final E endState;
    private final E failState;
    private final Cluster cluster;
    private final Long startTime;

    public StatefulMessageSet(Cluster cluster, E[] states) {
        this.cluster = cluster;
        this.states = states;
        this.state = states[0];
        this.endState = states[states.length - 2];
        this.failState = states[states.length - 1];
        this.startTime = System.currentTimeMillis();
    }

    private E rollback() {
        this.state = this.failState;
        return this.state;
    }

    public void addRequest(E state, Request asyncRequest) {
        EventRecord.caller(StatefulMessageSet.class, (EventType)EventType.VM_PREPARE, (Object[])new Object[]{((Enum)state).name(), asyncRequest.getCallback().getClass().getSimpleName()}).debug();
        this.messages.put(state, (Object)asyncRequest);
    }

    public void addCleanup(Runnable task) {
        this.cleanupTasks.add(task);
    }

    private void queueEvents(final E state) {
        for (final Request event : this.messages.get(state)) {
            try {
                EventRecord.caller(StatefulMessageSet.class, (EventType)EventType.VM_STARTING, (Object[])new Object[]{((Enum)state).name(), event.getCallback().toString()}).debug();
                if (event.getCallback() instanceof BroadcastCallback) {
                    final BroadcastCallback callback = (BroadcastCallback)event.getCallback();
                    this.pendingEvents.addAll(Lists.transform((List)Clusters.getInstance().listValues(), (Function)new Function<Cluster, Request>(){

                        public Request apply(Cluster c) {
                            LOG.debug((Object)("VM_STARTING: " + state.name() + " " + c.getName() + " " + event.getClass().getSimpleName() + " " + event.getCallback()));
                            Request request = AsyncRequests.newRequest((RemoteCallback)callback.newInstance());
                            request.getRequest().regardingUserRequest(callback.getRequest());
                            request.dispatch((ServiceConfiguration)c.getConfiguration());
                            return request;
                        }
                    }));
                    continue;
                }
                LOG.debug((Object)("VM_STARTING: " + ((Enum)state).name() + " " + this.cluster.getName() + " " + event.getClass().getSimpleName() + " " + event.getCallback()));
                event.dispatch((ServiceConfiguration)this.cluster.getConfiguration());
                this.pendingEvents.add(event);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    private E transition(E currentState) {
        Request request = null;
        E nextState = this.states[((Enum)currentState).ordinal() + 1];
        while ((request = this.pendingEvents.poll()) != null) {
            try {
                try {
                    Object o = request.getResponse().get(240L, TimeUnit.SECONDS);
                    if (o == null) continue;
                    EventRecord.here(StatefulMessageSet.class, (EventType)EventType.VM_STARTING, (String[])new String[]{((Enum)currentState).name(), this.cluster.getName(), o.getClass().getSimpleName()}).info();
                    EventRecord.here(StatefulMessageSet.class, (EventType)EventType.VM_STARTING, (String[])new String[]{((Enum)currentState).name(), this.cluster.getName(), o.toString()}).debug();
                }
                catch (TimeoutException ex1) {
                    request.getCallback().fireException((Throwable)ex1);
                }
            }
            catch (InterruptedException t) {
                Thread.currentThread().interrupt();
                EventRecord.here(StatefulMessageSet.class, (EventType)EventType.VM_STARTING, (String[])new String[]{"FAILED", ((Enum)currentState).name(), this.cluster.getName(), t.getClass().getSimpleName()}).info();
                LOG.error((Object)t, (Throwable)t);
                nextState = this.rollback();
                break;
            }
            catch (Exception t) {
                EventRecord.here(StatefulMessageSet.class, (EventType)EventType.VM_STARTING, (String[])new String[]{"FAILED", ((Enum)currentState).name(), this.cluster.getName(), t.getClass().getSimpleName()}).info();
                if (Throwables.getRootCause((Throwable)t) instanceof EucalyptusClusterException) {
                    LOG.warn((Object)t);
                } else {
                    LOG.error((Object)t, (Throwable)t);
                }
                nextState = this.rollback();
                break;
            }
        }
        EventRecord.here(StatefulMessageSet.class, (EventType)EventType.VM_STARTING, (String[])new String[]{((Enum)currentState).name(), EventType.TRANSITION.name(), ((Enum)nextState).name()}).info();
        return nextState;
    }

    private boolean isSuccessful() {
        return ((Enum)this.state).equals(this.endState);
    }

    private boolean isFinished() {
        return ((Enum)this.state).equals(this.failState) || ((Enum)this.state).equals(this.endState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            do {
                LOG.info((Object)EventRecord.here(StatefulMessageSet.class, (EventType)EventType.VM_STARTING, (String[])new String[]{((Enum)this.state).name(), (double)(System.currentTimeMillis() - this.startTime) / 1000.0 + "s"}));
                try {
                    this.queueEvents(this.state);
                    this.state = this.transition(this.state);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            } while (!this.isFinished());
            LOG.info((Object)EventRecord.here(StatefulMessageSet.class, (EventType)(this.isSuccessful() ? EventType.VM_START_COMPLETED : EventType.VM_START_ABORTED), (String[])new String[]{(double)(System.currentTimeMillis() - this.startTime) / 1000.0 + "s"}));
        }
        catch (Throwable throwable) {
            LOG.info((Object)EventRecord.here(StatefulMessageSet.class, (EventType)(this.isSuccessful() ? EventType.VM_START_COMPLETED : EventType.VM_START_ABORTED), (String[])new String[]{(double)(System.currentTimeMillis() - this.startTime) / 1000.0 + "s"}));
            if (!this.isSuccessful()) {
                for (Runnable cleanupTask : this.cleanupTasks) {
                    try {
                        cleanupTask.run();
                    }
                    catch (RuntimeException e) {
                        LOG.error((Object)("Error in cleanup task: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            throw throwable;
        }
        if (!this.isSuccessful()) {
            for (Runnable cleanupTask : this.cleanupTasks) {
                try {
                    cleanupTask.run();
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Error in cleanup task: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }
}

