/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.tags;

import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.TagInfo;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.records.Logs;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityTransaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;

public class Tags {
    public static List<Tag> list(OwnerFullName ownerFullName) throws NoSuchMetadataException {
        try {
            return Transactions.findAll((Object)((Object)Tag.withOwner(ownerFullName)));
        }
        catch (Exception e) {
            throw new NoSuchMetadataException("Failed to find tags for " + ownerFullName, e);
        }
    }

    public static List<Tag> list(OwnerFullName ownerFullName, Predicate<? super Tag> filter, Criterion criterion, Map<String, String> aliases) throws NoSuchMetadataException {
        return Tags.list(Tag.withOwner(ownerFullName), filter, criterion, aliases);
    }

    public static List<Tag> list(Tag example, Predicate<? super Tag> filter, Criterion criterion, Map<String, String> aliases) throws NoSuchMetadataException {
        try {
            return Transactions.filter((Object)((Object)example), filter, (Criterion)criterion, aliases);
        }
        catch (Exception e) {
            throw new NoSuchMetadataException("Failed to find tags for " + LogUtil.dumpObject((Object)((Object)example)), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(Tag example) {
        EntityTransaction transaction = Entities.get((Object)((Object)example));
        try {
            Disjunction reservedTagKey = Restrictions.disjunction();
            reservedTagKey.add((Criterion)Restrictions.like((String)"displayName", (Object)"aws:%"));
            reservedTagKey.add((Criterion)Restrictions.like((String)"displayName", (Object)"euca:%"));
            long l = Entities.count((Object)((Object)example), (Criterion)Restrictions.not((Criterion)reservedTagKey), Collections.emptyMap());
            return l;
        }
        finally {
            transaction.rollback();
        }
    }

    public static Function<Tag, String> resourceId() {
        return TagFunctions.RESOURCE_ID;
    }

    public static Function<Tag, String> key() {
        return TagFunctions.KEY;
    }

    public static Function<Tag, String> value() {
        return TagFunctions.VALUE;
    }

    public static void delete(Tag example) throws NoSuchMetadataException {
        EntityTransaction db = Entities.get(Tag.class);
        try {
            Tag entity = (Tag)((Object)Entities.uniqueResult((Object)((Object)example)));
            Entities.delete((Object)((Object)entity));
            db.commit();
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
            throw new NoSuchMetadataException("Failed to find tag: " + example.getKey() + " for " + example.getOwner(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tag createOrUpdate(Tag tag) {
        Tag result;
        String originalValue = tag.getValue();
        String originalUserId = tag.getOwnerUserId();
        String originalUserName = tag.getOwnerUserName();
        try {
            tag.setValue(null);
            tag.setOwnerUserId(null);
            tag.setOwnerUserName(null);
            tag.setValue(null);
            Tag existing = Tags.lookup(tag);
            existing.setValue(originalValue);
            result = existing;
        }
        catch (NoSuchMetadataException e) {
            tag.setValue(originalValue);
            tag.setOwnerUserId(originalUserId);
            tag.setOwnerUserName(originalUserName);
            Entities.persist((Object)((Object)tag));
            result = tag;
        }
        finally {
            tag.setValue(originalValue);
            tag.setOwnerUserId(originalUserId);
            tag.setOwnerUserName(originalUserName);
        }
        return result;
    }

    public static <T> void addFromTags(Collection<? super T> target, Class<T> targetItemType, Iterable<Tag> tags) {
        Iterables.addAll(target, (Iterable)Iterables.transform(tags, (Function)TypeMappers.lookup(Tag.class, targetItemType)));
    }

    private static Tag lookup(Tag example) throws NoSuchMetadataException {
        try {
            List result = Transactions.filter((Object)((Object)example), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)example.getResourceId()), Tags.resourceId()));
            if (result.size() == 1) {
                return (Tag)((Object)result.get(0));
            }
        }
        catch (Exception e) {
            throw new NoSuchMetadataException("Failed to find tag: " + example.getKey() + " for " + example.getOwner(), e);
        }
        throw new NoSuchMetadataException("Failed to find unique tag: " + example.getKey() + " for " + example.getOwner());
    }

    @TypeMapper
    public static enum TagToTagInfo implements Function<Tag, TagInfo>
    {
        INSTANCE;


        public TagInfo apply(Tag tag) {
            TagInfo info = new TagInfo();
            info.setKey(tag.getKey());
            info.setValue(tag.getValue());
            info.setResourceId(tag.getResourceId());
            info.setResourceType(tag.getResourceType());
            return info;
        }
    }

    @TypeMapper
    public static enum TagToResourceTag implements Function<Tag, ResourceTag>
    {
        INSTANCE;


        public ResourceTag apply(Tag tag) {
            return new ResourceTag(tag.getKey(), tag.getValue());
        }
    }

    private static enum TagFunctions implements Function<Tag, String>
    {
        KEY{

            public String apply(Tag tag) {
                return tag.getKey();
            }
        }
        ,
        RESOURCE_TYPE{

            public String apply(Tag tag) {
                return tag.getResourceType();
            }
        }
        ,
        RESOURCE_ID{

            public String apply(Tag tag) {
                return tag.getResourceId();
            }
        }
        ,
        VALUE{

            public String apply(Tag tag) {
                return tag.getValue();
            }
        };

    }

    public static class TagFilterSupport
    extends FilterSupport<Tag> {
        public TagFilterSupport() {
            super(TagFilterSupport.builderFor(Tag.class).withStringProperty("key", TagFunctions.KEY).withStringProperty("resource-id", TagFunctions.RESOURCE_ID).withStringProperty("resource-type", TagFunctions.RESOURCE_TYPE).withStringProperty("value", TagFunctions.VALUE).withPersistenceFilter("key", "displayName").withPersistenceFilter("value"));
        }
    }
}

