/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.tags;

import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public abstract class TagSupport {
    private static final Logger log = Logger.getLogger(TagSupport.class);
    private static final ConcurrentMap<String, TagSupport> supportByIdentifierPrefix = Maps.newConcurrentMap();
    private static final ConcurrentMap<Class<? extends CloudMetadata>, TagSupport> supportByClass = Maps.newConcurrentMap();
    private static final Splitter idSplitter = Splitter.on((char)'-').limit(2);
    private final Class<? extends AbstractPersistent> resourceClass;
    private final Class<? extends CloudMetadata> cloudMetadataClass;
    private final Set<String> identifierPrefixes;
    private final String resourceClassIdField;
    private final String tagClassResourceField;
    private final String notFoundErrorCode;
    private final String notFoundFormatString;
    private static final LoadingCache<Class, Class> metadataClassMap = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class, Class>(){

        public Class load(Class instanceClass) {
            ArrayList interfaces = Lists.newArrayList();
            for (Class clazz : (List)Classes.interfaceAncestors().apply((Object)instanceClass)) {
                interfaces.add(clazz);
            }
            Collections.reverse(interfaces);
            return (Class)Iterables.find((Iterable)interfaces, (Predicate)Predicates.and((Predicate)Predicates.not((Predicate)Predicates.equalTo(CloudMetadata.class)), (Predicate)Classes.subclassOf(CloudMetadata.class)));
        }
    });

    protected <T extends AbstractPersistent> TagSupport(@Nonnull Class<T> resourceClass, @Nonnull Set<String> identifierPrefixes, @Nonnull String resourceClassIdField, @Nonnull String tagClassResourceField, @Nonnull String notFoundErrorCode, @Nonnull String notFoundFormatString) {
        this.resourceClass = resourceClass;
        this.cloudMetadataClass = TagSupport.subclassFor(resourceClass);
        this.identifierPrefixes = ImmutableSet.copyOf(identifierPrefixes);
        this.resourceClassIdField = resourceClassIdField;
        this.tagClassResourceField = tagClassResourceField;
        this.notFoundErrorCode = notFoundErrorCode;
        this.notFoundFormatString = notFoundFormatString;
    }

    protected <T extends AbstractPersistent> TagSupport(@Nonnull Class<T> resourceClass, @Nonnull String identifierPrefix, @Nonnull String resourceClassIdField, @Nonnull String tagClassResourceField, @Nonnull String notFoundErrorCode, @Nonnull String notFoundFormatString) {
        this(resourceClass, Collections.singleton(identifierPrefix), resourceClassIdField, tagClassResourceField, notFoundErrorCode, notFoundFormatString);
    }

    public abstract Tag createOrUpdate(CloudMetadata var1, OwnerFullName var2, String var3, String var4);

    public abstract Tag example(@Nonnull CloudMetadata var1, @Nonnull OwnerFullName var2, @Nullable String var3, @Nullable String var4);

    public abstract Tag example(@Nonnull OwnerFullName var1);

    protected <T extends Tag> T example(@Nonnull T tag, @Nonnull OwnerFullName ownerFullName) {
        tag.setOwner(ownerFullName);
        return tag;
    }

    public final long count(@Nonnull CloudMetadata metadata, @Nonnull OwnerFullName ownerFullName) {
        Tag example = this.example(metadata, ownerFullName, null, null);
        return Tags.count(example);
    }

    public abstract CloudMetadata lookup(String var1) throws TransactionException;

    public final String getNotFoundErrorCode() {
        return this.notFoundErrorCode;
    }

    public final String getNotFoundFormatString() {
        return this.notFoundFormatString;
    }

    public Map<String, List<Tag>> getResourceTagMap(OwnerFullName owner, Iterable<String> identifiers) {
        HashMap tagMap = Maps.newHashMap();
        for (String id : identifiers) {
            tagMap.put(id, Lists.newArrayList());
        }
        if (!tagMap.isEmpty()) {
            Tag example = this.example(owner);
            DetachedCriteria detachedCriteria = DetachedCriteria.forClass(this.resourceClass).add(Restrictions.in((String)this.resourceClassIdField, (Collection)Lists.newArrayList(identifiers))).setProjection((Projection)Projections.id());
            Criterion idRestriction = Property.forName((String)this.tagClassResourceField).in(detachedCriteria);
            try {
                List<Tag> tags = Tags.list(example, (Predicate<? super Tag>)Predicates.alwaysTrue(), idRestriction, Collections.emptyMap());
                for (Tag tag : tags) {
                    ((List)tagMap.get(tag.getResourceId())).add(tag);
                }
            }
            catch (NoSuchMetadataException e) {
                log.error((Object)e, (Throwable)e);
            }
            Ordering order = Ordering.natural().onResultOf(Tags.key());
            for (String id : identifiers) {
                Collections.sort((List)tagMap.get(id), order);
            }
        }
        return tagMap;
    }

    @Nonnull
    public Class<? extends CloudMetadata> getCloudMetadataClass() {
        return this.cloudMetadataClass;
    }

    @Nonnull
    public Set<String> getIdentifierPrefixes() {
        return this.identifierPrefixes;
    }

    public static TagSupport forResourceClass(@Nonnull Class<? extends CloudMetadata> metadataClass) {
        return (TagSupport)supportByClass.get(TagSupport.subclassFor(metadataClass));
    }

    public static TagSupport fromResource(@Nonnull CloudMetadata metadata) {
        return (TagSupport)supportByClass.get(TagSupport.subclassFor(metadata.getClass()));
    }

    public static TagSupport fromIdentifier(@Nonnull String id) {
        return (TagSupport)supportByIdentifierPrefix.get(Iterables.getFirst((Iterable)idSplitter.split((CharSequence)id), (Object)""));
    }

    static void registerTagSupport(@Nonnull TagSupport tagSupport) {
        supportByClass.put(tagSupport.getCloudMetadataClass(), tagSupport);
        for (String idPrefix : tagSupport.getIdentifierPrefixes()) {
            supportByIdentifierPrefix.put(idPrefix, tagSupport);
        }
    }

    private static Class<? extends CloudMetadata> subclassFor(Class<? extends CloudMetadata> metadataInstance) {
        return (Class)metadataClassMap.getUnchecked(metadataInstance);
    }

    Class<? extends AbstractPersistent> getResourceClass() {
        return this.resourceClass;
    }

    String getResourceClassIdField() {
        return this.resourceClassIdField;
    }

    String getTagClassResourceField() {
        return this.tagClassResourceField;
    }
}

