/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.tags;

import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.compute.ClientComputeException;
import com.eucalyptus.compute.ComputeException;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.DeleteResourceTag;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.TagInfo;
import com.eucalyptus.compute.common.backend.CreateTagsResponseType;
import com.eucalyptus.compute.common.backend.CreateTagsType;
import com.eucalyptus.compute.common.backend.DeleteTagsResponseType;
import com.eucalyptus.compute.common.backend.DeleteTagsType;
import com.eucalyptus.compute.common.backend.DescribeTagsResponseType;
import com.eucalyptus.compute.common.backend.DescribeTagsType;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.images.Images;
import com.eucalyptus.tags.Filter;
import com.eucalyptus.tags.Filters;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedType;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import edu.ucsb.eucalyptus.cloud.InvalidParameterValueException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

@ConfigurableClass(root="tagging", description="Parameters controlling tagging")
public class TagManager {
    private static final Logger log = Logger.getLogger(TagManager.class);
    private static final Set<String> reservedPrefixes = ImmutableSet.builder().add((Object)"aws:").add((Object)"euca:").build();
    @ConfigurableField(initial="10", description="The maximum number of tags per resource for each account")
    public static long MAX_TAGS_PER_RESOURCE = 10L;

    public CreateTagsResponseType createTags(CreateTagsType request) throws EucalyptusCloudException {
        CreateTagsResponseType reply = (CreateTagsResponseType)request.getReply();
        reply.set_return(Boolean.valueOf(false));
        Context context = Contexts.lookup();
        final UserFullName userFullName = context.getUserFullName();
        final AccountFullName accountFullName = userFullName.asAccountFullName();
        final List resourceIds = (List)Objects.firstNonNull((Object)request.getResourcesSet(), Collections.emptyList());
        final List resourceTags = (List)Objects.firstNonNull((Object)request.getTagSet(), Collections.emptyList());
        for (ResourceTag resourceTag : resourceTags) {
            String key = resourceTag.getKey();
            String value = Strings.nullToEmpty((String)resourceTag.getValue()).trim();
            if (TagManager.isReserved(key)) {
                throw new ClientComputeException("InvalidParameterValue", "Tag keys starting with 'aws:' and 'euca:' are reserved for internal use");
            }
            if (Strings.isNullOrEmpty((String)key) || key.trim().length() > 127) {
                throw new ClientComputeException("InvalidParameterValue", "Tag key exceeds the maximum length of 127 characters");
            }
            if (value.length() <= 255) continue;
            throw new ClientComputeException("InvalidParameterValue", "Tag value exceeds the maximum length of 255 characters");
        }
        if (resourceTags.size() > 0 && resourceIds.size() > 0) {
            Predicate<Void> creator = new Predicate<Void>(){

                public boolean apply(Void v) {
                    List resources = Lists.transform((List)resourceIds, (Function)TagManager.resourceLookup(true));
                    if (!Iterables.all((Iterable)resources, (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.notNull(), TagManager.typeSpecificFilters(), TagManager.permissionsFilter()}))) {
                        return false;
                    }
                    for (CloudMetadata resource : resources) {
                        for (ResourceTag resourceTag : resourceTags) {
                            String key = Strings.nullToEmpty((String)resourceTag.getKey()).trim();
                            String value = Strings.nullToEmpty((String)resourceTag.getValue()).trim();
                            TagSupport.fromResource(resource).createOrUpdate(resource, (OwnerFullName)userFullName, key, value);
                        }
                        if (TagSupport.fromResource(resource).count(resource, (OwnerFullName)accountFullName) <= MAX_TAGS_PER_RESOURCE) continue;
                        throw new TagLimitException();
                    }
                    return true;
                }
            };
            try {
                reply.set_return(Boolean.valueOf(Entities.asTransaction(Tag.class, (Predicate)creator).apply(null)));
            }
            catch (TagLimitException e) {
                throw new ClientComputeException("TagLimitExceeded", "The maximum number of Tags for a resource has been reached.");
            }
            catch (RuntimeException e) {
                TagManager.handleException(e);
            }
        }
        return reply;
    }

    public DeleteTagsResponseType deleteTags(DeleteTagsType request) throws EucalyptusCloudException {
        DeleteTagsResponseType reply = (DeleteTagsResponseType)request.getReply();
        reply.set_return(Boolean.valueOf(false));
        Context context = Contexts.lookup();
        AccountFullName ownerFullName = context.getUserFullName().asAccountFullName();
        final List resourceIds = (List)Objects.firstNonNull((Object)request.getResourcesSet(), Collections.emptyList());
        final List resourceTags = (List)Objects.firstNonNull((Object)request.getTagSet(), Collections.emptyList());
        for (DeleteResourceTag resourceTag : resourceTags) {
            String key = resourceTag.getKey();
            if (!Strings.isNullOrEmpty((String)key) && key.trim().length() <= 128 && !TagManager.isReserved(key)) continue;
            throw new InvalidParameterValueException("Invalid key (max length 128, must not be empty, reserved prefixes " + reservedPrefixes + "): " + key);
        }
        if (resourceIds.size() > 0 && resourceIds.size() > 0) {
            Predicate<Void> delete = new Predicate<Void>((OwnerFullName)ownerFullName){
                final /* synthetic */ OwnerFullName val$ownerFullName;
                {
                    this.val$ownerFullName = ownerFullName;
                }

                public boolean apply(Void v) {
                    Iterable resources = Iterables.filter((Iterable)Iterables.transform((Iterable)resourceIds, (Function)TagManager.resourceLookup(false)), (Predicate)Predicates.notNull());
                    for (CloudMetadata resource : resources) {
                        for (DeleteResourceTag resourceTag : resourceTags) {
                            try {
                                Tag example = TagSupport.fromResource(resource).example(resource, this.val$ownerFullName, resourceTag.getKey(), resourceTag.getValue());
                                if (!RestrictedTypes.filterPrivileged().apply((Object)example)) continue;
                                Tags.delete(example);
                            }
                            catch (NoSuchMetadataException e) {
                                log.trace((Object)e);
                            }
                        }
                    }
                    return true;
                }
            };
            try {
                reply.set_return(Boolean.valueOf(Entities.asTransaction(Tag.class, (Predicate)delete).apply(null)));
            }
            catch (RuntimeException e) {
                TagManager.handleException(e);
            }
        }
        return reply;
    }

    public DescribeTagsResponseType describeTags(DescribeTagsType request) throws Exception {
        DescribeTagsResponseType reply = (DescribeTagsResponseType)request.getReply();
        Context context = Contexts.lookup();
        Filter filter = Filters.generate(request.getFilterSet(), Tag.class);
        Predicate requestedAndAccessible = CloudMetadatas.filteringFor(Tag.class).byPredicate(filter.asPredicate()).byPrivileges().buildPredicate();
        Ordering ordering = Ordering.natural().onResultOf(Tags.resourceId()).compound((Comparator)Ordering.natural().onResultOf(Tags.key())).compound((Comparator)Ordering.natural().onResultOf(Tags.value()));
        Iterables.addAll((Collection)reply.getTagSet(), (Iterable)Iterables.transform((Iterable)ordering.sortedCopy(Tags.list((OwnerFullName)context.getUserFullName().asAccountFullName(), (Predicate<? super Tag>)requestedAndAccessible, filter.asCriterion(), filter.getAliases())), (Function)TypeMappers.lookup(Tag.class, TagInfo.class)));
        return reply;
    }

    private static boolean isReserved(String text) {
        return !Contexts.lookup().isPrivileged() && Iterables.any(reservedPrefixes, TagManager.prefix(text));
    }

    private static Predicate<String> prefix(final String text) {
        return new Predicate<String>(){

            public boolean apply(String prefix) {
                return text != null && text.trim().startsWith(prefix);
            }
        };
    }

    private static Predicate<Object> typeSpecificFilters() {
        return TypeSpecificFilters.INSTANCE;
    }

    private static Predicate<RestrictedType> permissionsFilter() {
        return PermissionsFilter.INSTANCE;
    }

    private static Function<String, CloudMetadata> resourceLookup(final boolean required) {
        return new Function<String, CloudMetadata>(){

            public CloudMetadata apply(String resourceId) {
                TagSupport tagSupport = TagSupport.fromIdentifier(resourceId);
                try {
                    if (tagSupport != null && resourceId.matches("[a-z]{1,32}-[0-9a-fA-F]{8}")) {
                        return tagSupport.lookup((String)ResourceIdentifiers.tryNormalize().apply((Object)resourceId));
                    }
                    throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidID", String.format("The ID '%s' is not valid", resourceId))));
                }
                catch (TransactionException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
                catch (NoSuchElementException e) {
                    if (required) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException(tagSupport.getNotFoundErrorCode(), String.format(tagSupport.getNotFoundFormatString(), resourceId))));
                    }
                    return null;
                }
            }
        };
    }

    private static void handleException(RuntimeException e) throws EucalyptusCloudException {
        ComputeException computeException = (ComputeException)((Object)Exceptions.findCause((Throwable)e, ComputeException.class));
        if (computeException != null) {
            throw computeException;
        }
        throw e;
    }

    private static class TagLimitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private TagLimitException() {
        }
    }

    private static enum TypeSpecificFilters implements Predicate<Object>
    {
        INSTANCE;

        private List<Predicate<Object>> predicates = ImmutableList.of(this.typedPredicate(Images.FilterPermissions.INSTANCE, ImageInfo.class));

        private <PT> Predicate<Object> typedPredicate(final Predicate<? super PT> predicate, final Class<PT> predicateTarget) {
            return new Predicate<Object>(){

                public boolean apply(@Nullable Object object) {
                    return !predicateTarget.isInstance(object) || predicate.apply(predicateTarget.cast(object));
                }
            };
        }

        public boolean apply(Object object) {
            return Predicates.and(this.predicates).apply(object);
        }
    }

    private static enum PermissionsFilter implements Predicate<RestrictedType>
    {
        INSTANCE;


        public boolean apply(RestrictedType metadata) {
            if (metadata instanceof ImageMetadata) {
                return RestrictedTypes.filterPrivilegedWithoutOwner().apply((Object)metadata);
            }
            return RestrictedTypes.filterPrivileged().apply((Object)metadata);
        }
    }
}

