/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.tags;

import com.eucalyptus.tags.Filter;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.tags.InvalidFilterException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class Filters {
    public static final String DEFAULT_FILTERS = "default";

    @Nonnull
    public static Filter generate(Iterable<com.eucalyptus.compute.common.Filter> filters, Class<?> resourceType) throws InvalidFilterException {
        return Filters.generate(filters, resourceType, DEFAULT_FILTERS);
    }

    @Nonnull
    public static Filter generate(Iterable<com.eucalyptus.compute.common.Filter> filters, Class<?> resourceType, String qualifier) throws InvalidFilterException {
        return Filters.generateFor(filters, resourceType, qualifier).generate();
    }

    @Nonnull
    public static FiltersBuilder generateFor(Iterable<com.eucalyptus.compute.common.Filter> filters, Class<?> resourceType) {
        return Filters.generateFor(filters, resourceType, DEFAULT_FILTERS);
    }

    @Nonnull
    public static FiltersBuilder generateFor(Iterable<com.eucalyptus.compute.common.Filter> filters, Class<?> resourceType, String qualifier) {
        return new FiltersBuilder(filters, resourceType, qualifier);
    }

    private static Map<String, Set<String>> toMap(Iterable<com.eucalyptus.compute.common.Filter> filters) {
        ImmutableMap.Builder filterMapBuilder = ImmutableMap.builder();
        for (com.eucalyptus.compute.common.Filter filter : filters) {
            ImmutableSet values = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)filter.getValueSet(), (Function)NullToEmptyString.INSTANCE));
            filterMapBuilder.put((Object)filter.getName(), (Object)values);
        }
        return filterMapBuilder.build();
    }

    private static enum NullToEmptyString implements Function<String, String>
    {
        INSTANCE;


        public String apply(String text) {
            return text == null ? "" : text;
        }
    }

    public static class FiltersBuilder {
        private final Iterable<com.eucalyptus.compute.common.Filter> filters;
        private final Class<?> resourceType;
        private final String qualifier;
        private final Map<String, Set<String>> internalFilters = Maps.newHashMap();

        public FiltersBuilder(Iterable<com.eucalyptus.compute.common.Filter> filters, Class<?> resourceType, String qualifier) {
            this.filters = filters;
            this.resourceType = resourceType;
            this.qualifier = qualifier;
        }

        @Nonnull
        public FiltersBuilder withOptionalInternalFilter(String name, Iterable<String> values) {
            if (values.iterator().hasNext()) {
                this.internalFilters.put(name, (Set<String>)ImmutableSet.copyOf(values));
            }
            return this;
        }

        @Nonnull
        public Filter generate() throws InvalidFilterException {
            Filter filter;
            FilterSupport support = FilterSupport.forResource(this.resourceType, this.qualifier);
            if (support == null) {
                filter = Filter.alwaysTrue();
            } else {
                filter = support.generate(Filters.toMap(this.filters), false);
                if (!this.internalFilters.isEmpty()) {
                    filter = filter.and(support.generate(this.internalFilters, true));
                }
            }
            return filter;
        }
    }
}

