/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.tags;

import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.crypto.util.Timestamps;
import com.eucalyptus.tags.Filter;
import com.eucalyptus.tags.InvalidFilterException;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.util.Parameters;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEmptyString;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public abstract class FilterSupport<RT> {
    private static final ConcurrentMap<SupportKey, FilterSupport> supportMap = Maps.newConcurrentMap();
    private final Class<RT> resourceClass;
    private final String qualifier;
    private Class<? extends Tag> tagClass;
    private final String tagFieldName;
    private final String resourceFieldName;
    private final Set<String> internalFilters;
    private final Map<String, Function<? super String, Predicate<? super RT>>> predicateFunctions;
    private final Map<String, String> aliases;
    private final Map<String, PersistenceFilter> persistenceFilters;

    protected FilterSupport(@Nonnull Builder<RT> builder) {
        this.resourceClass = ((Builder)builder).resourceClass;
        this.qualifier = ((Builder)builder).qualifier;
        this.tagClass = ((Builder)builder).tagClass;
        this.tagFieldName = ((Builder)builder).tagFieldName;
        this.resourceFieldName = ((Builder)builder).resourceFieldName;
        this.internalFilters = ((Builder)builder).buildInternalFilters();
        this.predicateFunctions = ((Builder)builder).buildPredicateFunctions();
        this.aliases = ((Builder)builder).buildAliases();
        this.persistenceFilters = ((Builder)builder).buildPersistenceFilters();
    }

    protected static <RT> Builder<RT> builderFor(Class<RT> resourceClass) {
        return new Builder(resourceClass, "default");
    }

    protected static <RT> Builder<RT> qualifierBuilderFor(Class<RT> resourceClass, String qualifier) {
        return new Builder(resourceClass, qualifier);
    }

    @Nonnull
    public Class<RT> getResourceClass() {
        return this.resourceClass;
    }

    @Nonnull
    public String getQualifier() {
        return this.qualifier;
    }

    @Nullable
    public Class<? extends Tag> getTagClass() {
        return this.tagClass;
    }

    @Nullable
    public String getTagFieldName() {
        return this.tagFieldName;
    }

    @Nullable
    public String getResourceFieldName() {
        return this.resourceFieldName;
    }

    public Filter generate(Map<String, Set<String>> filters, boolean allowInternalFilters) throws InvalidFilterException {
        Context ctx = Contexts.lookup();
        String requestAccountId = ctx.getUserFullName().getAccountNumber();
        return this.generate(filters, allowInternalFilters, requestAccountId);
    }

    public Filter generate(Map<String, Set<String>> filters, boolean allowInternalFilters, String accountId) throws InvalidFilterException {
        ArrayList and = Lists.newArrayList();
        for (Map.Entry filter : Iterables.filter(filters.entrySet(), (Predicate)Predicates.not(this.isTagFilter()))) {
            ArrayList or = Lists.newArrayList();
            for (String value : (Set)filter.getValue()) {
                Function<? super String, Predicate<? super RT>> predicateFunction = this.predicateFunctions.get(filter.getKey());
                if (predicateFunction == null || !allowInternalFilters && this.internalFilters.contains(filter.getKey())) {
                    throw InvalidFilterException.forName((String)filter.getKey());
                }
                Predicate valuePredicate = (Predicate)predicateFunction.apply((Object)value);
                or.add(this.typedPredicate(valuePredicate));
            }
            and.add(Predicates.or((Iterable)or));
        }
        Conjunction conjunction = Restrictions.conjunction();
        HashMap aliases = Maps.newHashMap();
        for (Map.Entry filter : Iterables.filter(filters.entrySet(), (Predicate)Predicates.not(this.isTagFilter()))) {
            Disjunction disjunction = Restrictions.disjunction();
            for (String value : (Set)filter.getValue()) {
                Object persistentValue;
                PersistenceFilter persistenceFilter = this.persistenceFilters.get(filter.getKey());
                if (persistenceFilter == null || (persistentValue = persistenceFilter.value(value)) == null) continue;
                for (String alias : persistenceFilter.getAliases()) {
                    aliases.put(alias, this.aliases.get(alias));
                }
                disjunction.add(this.buildRestriction(persistenceFilter.getProperty(), persistentValue));
            }
            conjunction.add((Criterion)disjunction);
        }
        boolean tagPresent = false;
        ArrayList tagJunctions = Lists.newArrayList();
        for (Map.Entry filter : Iterables.filter(filters.entrySet(), this.isTagFilter())) {
            tagPresent = true;
            Disjunction disjunction = Restrictions.disjunction();
            String filterName = (String)filter.getKey();
            for (String value : (Set)filter.getValue()) {
                if ("tag-key".equals(filterName)) {
                    disjunction.add(this.buildTagRestriction(value, null, true));
                    continue;
                }
                if ("tag-value".equals(filterName)) {
                    disjunction.add(this.buildTagRestriction(null, value, true));
                    continue;
                }
                disjunction.add(this.buildTagRestriction(filterName.substring(4), value, false));
            }
            tagJunctions.add(disjunction);
        }
        if (tagPresent) {
            conjunction.add(this.tagCriterion(accountId, tagJunctions));
        }
        return new Filter(aliases, (Criterion)conjunction, (Predicate<Object>)Predicates.and((Iterable)and), tagPresent);
    }

    public static FilterSupport forResource(@Nonnull Class<?> metadataClass, @Nonnull String qualifier) {
        return (FilterSupport)supportMap.get(FilterSupport.supportKey(metadataClass, qualifier));
    }

    public static boolean isTotallyWildLikeExpression(String expression) {
        return expression.replace("%", "").isEmpty();
    }

    private static <T> Function<? super String, Predicate<? super T>> falseFilter() {
        return Functions.constant((Object)Predicates.alwaysFalse());
    }

    private static <T> Function<? super String, Predicate<? super T>> explodedLiteralFilter(final Function<? super T, ?> extractor, final Function<String, Collection> explodeFunction) {
        return new Function<String, Predicate<? super T>>(){

            public Predicate<T> apply(String filterValue) {
                Collection values = (Collection)explodeFunction.apply((Object)filterValue);
                return values == null ? Predicates.alwaysTrue() : Predicates.compose((Predicate)Predicates.in((Collection)values), (Function)Functions.compose((Function)extractor, (Function)Functions.identity()));
            }
        };
    }

    private static <T> Function<? super String, Predicate<? super T>> stringFilter(Function<? super T, String> extractor) {
        return FilterSupport.stringSetFilter(Functions.compose(FilterSupport.toSet(), extractor));
    }

    private static <T> Function<? super String, Predicate<? super T>> stringSetFilter(final Function<? super T, Set<String>> extractor) {
        return new Function<String, Predicate<? super T>>(){

            public Predicate<T> apply(String filterValue) {
                final Predicate resourceValuePredicate = FilterSupport.resourceValueMatcher(filterValue);
                return new Predicate<T>(){

                    public boolean apply(T resource) {
                        Set resourceValues = (Set)extractor.apply(resource);
                        return resourceValuePredicate.apply((Object)resourceValues);
                    }
                };
            }
        };
    }

    private static <T> Function<? super String, Predicate<? super T>> dateFilter(Function<? super T, Date> extractor) {
        return FilterSupport.dateSetFilter(Functions.compose(FilterSupport.toSet(), extractor));
    }

    private static <T> Function<? super String, Predicate<? super T>> dateSetFilter(Function<? super T, Set<Date>> extractor) {
        return FilterSupport.typedSetFilter(extractor, PersistenceFilter.Type.Date);
    }

    private static <T> Function<? super String, Predicate<? super T>> booleanFilter(Function<? super T, Boolean> extractor) {
        return FilterSupport.booleanSetFilter(Functions.compose(FilterSupport.toSet(), extractor));
    }

    private static <T> Function<? super String, Predicate<? super T>> booleanSetFilter(Function<? super T, Set<Boolean>> extractor) {
        return FilterSupport.typedSetFilter(extractor, PersistenceFilter.Type.Boolean);
    }

    private static <T> Function<? super String, Predicate<? super T>> intFilter(Function<? super T, Integer> extractor) {
        return FilterSupport.intSetFilter(Functions.compose(FilterSupport.toSet(), extractor));
    }

    private static <T> Function<? super String, Predicate<? super T>> intSetFilter(Function<? super T, Set<Integer>> extractor) {
        return FilterSupport.typedSetFilter(extractor, PersistenceFilter.Type.Integer);
    }

    private static <T> Function<? super String, Predicate<? super T>> intSetFilter(Function<? super T, Set<Integer>> extractor, Function<String, Integer> valueFunction) {
        return FilterSupport.typedSetFilter(extractor, PersistenceFilter.Type.Integer, valueFunction);
    }

    private static <T> Function<? super String, Predicate<? super T>> longFilter(Function<? super T, Long> extractor) {
        return FilterSupport.longSetFilter(Functions.compose(FilterSupport.toSet(), extractor));
    }

    private static <T> Function<? super String, Predicate<? super T>> longSetFilter(Function<? super T, Set<Long>> extractor) {
        return FilterSupport.typedSetFilter(extractor, PersistenceFilter.Type.Integer);
    }

    private static <T, VT> Function<? super String, Predicate<? super T>> typedSetFilter(Function<? super T, Set<VT>> extractor, PersistenceFilter.Type type) {
        return FilterSupport.typedSetFilter(extractor, type, type.valueFunction());
    }

    private static <T, VT> Function<? super String, Predicate<? super T>> typedSetFilter(final Function<? super T, Set<VT>> extractor, final PersistenceFilter.Type type, final Function<String, ?> valueFunction) {
        return new Function<String, Predicate<? super T>>(){

            public Predicate<T> apply(String filterValue) {
                final Predicate resourceValuePredicate = FilterSupport.resourceValueMatcher(filterValue, type, valueFunction);
                return new Predicate<T>(){

                    public boolean apply(T resource) {
                        Set resourceValues = (Set)extractor.apply(resource);
                        return resourceValuePredicate.apply((Object)resourceValues);
                    }
                };
            }
        };
    }

    static void registerFilterSupport(@Nonnull FilterSupport filterSupport) {
        supportMap.put(FilterSupport.supportKey(filterSupport.getResourceClass(), filterSupport.getQualifier()), filterSupport);
    }

    private static SupportKey supportKey(@Nonnull Class<?> resourceClass, @Nonnull String qualifier) {
        Parameters.checkParam((String)"Resource class", resourceClass, (org.hamcrest.Matcher)Matchers.notNullValue());
        Parameters.checkParam((String)"Qualifier", (Object)qualifier, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)IsEmptyString.isEmptyOrNullString()));
        return new SupportKey(resourceClass, qualifier);
    }

    private Predicate<Object> typedPredicate(final Predicate<? super RT> predicate) {
        return new Predicate<Object>(){

            public boolean apply(Object object) {
                return FilterSupport.this.getResourceClass().isInstance(object) && predicate != null && predicate.apply(FilterSupport.this.getResourceClass().cast(object));
            }
        };
    }

    private static <T> Function<T, Set<T>> toSet() {
        return new Function<T, Set<T>>(){

            public Set<T> apply(T value) {
                return value == null ? Collections.emptySet() : Collections.singleton(value);
            }
        };
    }

    private static <T> Function<String, T> likeWildFunction(final Function<String, T> delegate) {
        return new Function<String, T>(){

            public T apply(String expression) {
                StringBuilder likeValueBuilder = new StringBuilder();
                FilterSupport.translateWildcards(expression, likeValueBuilder, "_", "%", SyntaxEscape.Like);
                String likeExpression = likeValueBuilder.toString();
                if (FilterSupport.isTotallyWildLikeExpression(likeExpression)) {
                    return null;
                }
                return delegate.apply((Object)likeExpression);
            }
        };
    }

    private boolean isTagFilter(String filter) {
        return this.isTagFilteringEnabled() && (filter.startsWith("tag:") || "tag-key".equals(filter) || "tag-value".equals(filter));
    }

    private boolean isTagFilteringEnabled() {
        return this.tagFieldName != null;
    }

    private Predicate<Map.Entry<String, ?>> isTagFilter() {
        return !this.isTagFilteringEnabled() ? Predicates.alwaysFalse() : new Predicate<Map.Entry<String, ?>>(){

            public boolean apply(Map.Entry<String, ?> stringEntry) {
                return FilterSupport.this.isTagFilter(stringEntry.getKey());
            }
        };
    }

    private static <T> Predicate<Set<T>> resourceValueMatcher(String filterPattern, final PersistenceFilter.Type type, Function<String, ?> valueFunction) {
        final Object value = valueFunction.apply((Object)filterPattern);
        return value == null ? Predicates.alwaysFalse() : new Predicate<Set<T>>(){

            public boolean apply(Set<T> resourceValues) {
                boolean match = false;
                for (Object resourceValue : resourceValues) {
                    if (!type.matches(value, resourceValue)) continue;
                    match = true;
                    break;
                }
                return match;
            }
        };
    }

    private static Predicate<Set<String>> resourceValueMatcher(String filterPattern) {
        final StringBuilder regexBuilder = new StringBuilder();
        if (FilterSupport.translateWildcards(filterPattern, regexBuilder, ".", ".*", SyntaxEscape.Regex)) {
            return new Predicate<Set<String>>(){
                private final Pattern pattern;
                {
                    this.pattern = Pattern.compile(regexBuilder.toString());
                }

                public boolean apply(Set<String> values) {
                    return Iterables.any(values, (Predicate)new Predicate<String>(){

                        public boolean apply(String value) {
                            return value != null && pattern.matcher(value).matches();
                        }
                    });
                }
            };
        }
        final String processedFilterPattern = filterPattern.replaceAll("\\\\", Matcher.quoteReplacement("\\"));
        return new Predicate<Set<String>>(){

            public boolean apply(Set<String> values) {
                return values.contains(processedFilterPattern);
            }
        };
    }

    private Criterion buildRestriction(String property, Object persistentValue) {
        Object valueObject;
        if (persistentValue instanceof String) {
            String value = persistentValue.toString();
            StringBuilder likeValueBuilder = new StringBuilder();
            FilterSupport.translateWildcards(value, likeValueBuilder, "_", "%", SyntaxEscape.Like);
            String likeValue = likeValueBuilder.toString();
            if (!value.equals(likeValue)) {
                return Restrictions.like((String)property, (Object)likeValue);
            }
            valueObject = persistentValue;
        } else {
            valueObject = persistentValue;
        }
        if (persistentValue instanceof Collection) {
            if (((Collection)persistentValue).isEmpty()) {
                return Restrictions.not((Criterion)Restrictions.conjunction());
            }
            return Restrictions.in((String)property, (Collection)((Collection)persistentValue));
        }
        return Restrictions.eq((String)property, (Object)valueObject);
    }

    Map<String, PersistenceFilter> getPersistenceFilters() {
        return this.persistenceFilters;
    }

    Map<String, String> getAliases() {
        return this.aliases;
    }

    private Criterion tagCriterion(String accountId, List<Junction> junctions) {
        Conjunction conjunction = Restrictions.conjunction();
        for (Junction criterion : junctions) {
            DetachedCriteria criteria = DetachedCriteria.forClass(this.tagClass).add((Criterion)Restrictions.eq((String)"ownerAccountNumber", (Object)accountId)).add((Criterion)criterion).setProjection((Projection)Projections.property((String)this.resourceFieldName));
            conjunction.add(Property.forName((String)this.tagFieldName).in(criteria));
        }
        return conjunction;
    }

    private Criterion buildTagRestriction(@Nullable String key, @Nullable String value, boolean keyWildcards) {
        Conjunction criteria = Restrictions.conjunction();
        if (key != null) {
            criteria.add((Criterion)(keyWildcards ? this.buildRestriction("displayName", key) : Restrictions.eq((String)"displayName", (Object)key)));
        }
        if (value != null) {
            criteria.add(this.buildRestriction("value", value));
        }
        return criteria;
    }

    static boolean translateWildcards(String filterPattern, StringBuilder translated, String matchOne, String matchZeroOrMore, Function<String, String> escapeFunction) {
        boolean foundWildcard = false;
        CharMatcher syntaxMatcher = CharMatcher.anyOf((CharSequence)"\\*?");
        if (syntaxMatcher.matchesAnyOf((CharSequence)filterPattern)) {
            boolean escaped = false;
            block8: for (char character : filterPattern.toCharArray()) {
                switch (character) {
                    case '*': 
                    case '?': 
                    case '\\': {
                        if (!escaped) {
                            switch (character) {
                                case '\\': {
                                    escaped = true;
                                    break;
                                }
                                case '?': {
                                    foundWildcard = true;
                                    translated.append(matchOne);
                                    break;
                                }
                                case '*': {
                                    foundWildcard = true;
                                    translated.append(matchZeroOrMore);
                                }
                            }
                            continue block8;
                        }
                        escaped = false;
                    }
                    default: {
                        if (escaped) {
                            translated.append((String)escapeFunction.apply((Object)"\\"));
                        }
                        escaped = false;
                        translated.append((String)escapeFunction.apply((Object)Character.toString(character)));
                    }
                }
            }
            if (escaped) {
                translated.append((String)escapeFunction.apply((Object)"\\"));
            }
        } else {
            translated.append((String)escapeFunction.apply((Object)filterPattern));
        }
        return foundWildcard;
    }

    static String escapeLikeWildcards(String literalExpression) {
        String escaped;
        CharMatcher syntaxMatcher = CharMatcher.anyOf((CharSequence)"\\%_");
        if (syntaxMatcher.matchesAnyOf((CharSequence)literalExpression)) {
            StringBuilder escapedBuffer = new StringBuilder();
            for (char character : literalExpression.toCharArray()) {
                switch (character) {
                    case '%': 
                    case '\\': 
                    case '_': {
                        escapedBuffer.append('\\');
                    }
                }
                escapedBuffer.append(character);
            }
            escaped = escapedBuffer.toString();
        } else {
            escaped = literalExpression;
        }
        return escaped;
    }

    private static final class SupportKey {
        private final Class<?> resourceClass;
        private final String qualifier;

        private SupportKey(Class<?> resourceClass, String qualifier) {
            this.resourceClass = resourceClass;
            this.qualifier = qualifier;
        }

        public Class<?> getResourceClass() {
            return this.resourceClass;
        }

        public String getQualifier() {
            return this.qualifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SupportKey that = (SupportKey)o;
            if (!this.qualifier.equals(that.qualifier)) {
                return false;
            }
            return this.resourceClass.equals(that.resourceClass);
        }

        public int hashCode() {
            int result = this.resourceClass.hashCode();
            result = 31 * result + this.qualifier.hashCode();
            return result;
        }
    }

    static enum SyntaxEscape implements Function<String, String>
    {
        Regex{

            public String apply(String text) {
                return Pattern.quote(text);
            }
        }
        ,
        Like{

            public String apply(String text) {
                return FilterSupport.escapeLikeWildcards(text);
            }
        };

    }

    public static class PersistenceFilter {
        @Nonnull
        private final String property;
        @Nonnull
        private final Set<String> aliases;
        @Nonnull
        private final Function<String, ?> valueFunction;

        public static PersistenceFilter persistenceFilter(String property, Set<String> aliases) {
            return PersistenceFilter.persistenceFilter(property, aliases, Functions.identity());
        }

        public static PersistenceFilter persistenceFilter(String property, Set<String> aliases, Function<String, ?> valueFunction) {
            return new PersistenceFilter(property, aliases, valueFunction);
        }

        public static PersistenceFilter persistenceFilter(String property, Set<String> aliases, Type type) {
            return new PersistenceFilter(property, aliases, type.valueFunction());
        }

        @Nonnull
        public String getProperty() {
            return this.property;
        }

        @Nonnull
        public Set<String> getAliases() {
            return this.aliases;
        }

        @Nullable
        public Object value(String textValue) {
            return this.valueFunction.apply((Object)textValue);
        }

        @Nonnull
        Function<String, ?> getValueFunction() {
            return this.valueFunction;
        }

        private PersistenceFilter(@Nonnull String property, @Nonnull Set<String> aliases, @Nonnull Function<String, ?> valueFunction) {
            this.property = property;
            this.aliases = aliases;
            this.valueFunction = valueFunction;
        }

        public static enum Type {
            Integer{

                @Override
                public Function<String, ?> valueFunction() {
                    return new Function<String, Integer>(){

                        public Integer apply(String textValue) {
                            try {
                                return java.lang.Integer.valueOf(textValue);
                            }
                            catch (NumberFormatException e) {
                                return null;
                            }
                        }
                    };
                }
            }
            ,
            Long{

                @Override
                public Function<String, ?> valueFunction() {
                    return new Function<String, Long>(){

                        public Long apply(String textValue) {
                            try {
                                return java.lang.Long.valueOf(textValue);
                            }
                            catch (NumberFormatException e) {
                                return null;
                            }
                        }
                    };
                }
            }
            ,
            Date{

                @Override
                public Function<String, ?> valueFunction() {
                    return new Function<String, Date>(){

                        public Date apply(String textValue) {
                            try {
                                return Timestamps.parseIso8601Timestamp((String)textValue);
                            }
                            catch (AuthenticationException e) {
                                return null;
                            }
                        }
                    };
                }

                @Override
                boolean matches(Object targetValue, Object resourceValue) {
                    boolean match = false;
                    if (resourceValue instanceof Date && targetValue instanceof Date) {
                        match = ((Date)resourceValue).getTime() == ((Date)targetValue).getTime();
                    }
                    return match;
                }
            }
            ,
            Boolean{

                @Override
                public Function<String, ?> valueFunction() {
                    return new Function<String, Boolean>(){

                        public Boolean apply(String textValue) {
                            Boolean value = null;
                            if (java.lang.Boolean.TRUE.toString().equals(textValue)) {
                                value = java.lang.Boolean.TRUE;
                            } else if (java.lang.Boolean.FALSE.toString().equals(textValue)) {
                                value = java.lang.Boolean.FALSE;
                            }
                            return value;
                        }
                    };
                }
            };


            public abstract Function<String, ?> valueFunction();

            boolean matches(Object targetValue, Object resourceValue) {
                return targetValue.equals(resourceValue);
            }
        }
    }

    protected static class Builder<RT> {
        private final Class<RT> resourceClass;
        private final String qualifier;
        private final Set<String> internalFilters = Sets.newHashSet();
        private final Map<String, Function<? super String, Predicate<? super RT>>> predicateFunctions = Maps.newHashMap();
        private final Map<String, String> aliases = Maps.newHashMap();
        private final Map<String, PersistenceFilter> persistenceFilters = Maps.newHashMap();
        private Class<? extends Tag> tagClass;
        private String tagFieldName;
        private String resourceFieldName;

        private Builder(Class<RT> resourceClass, String qualifier) {
            Parameters.checkParam((String)"Resource class", resourceClass, (org.hamcrest.Matcher)Matchers.notNullValue());
            Parameters.checkParam((String)"Qualifier", (Object)qualifier, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)IsEmptyString.isEmptyOrNullString()));
            this.resourceClass = resourceClass;
            this.qualifier = qualifier;
        }

        public Builder<RT> withTagFiltering(Class<? extends Tag> tagClass, String resourceFieldName, String tagFieldName) {
            this.tagClass = tagClass;
            this.resourceFieldName = resourceFieldName;
            this.tagFieldName = tagFieldName;
            return this;
        }

        public Builder<RT> withTagFiltering(Class<? extends Tag> tagClass, String resourceFieldName) {
            return this.withTagFiltering(tagClass, resourceFieldName, "tags");
        }

        public Builder<RT> withBooleanProperty(String filterName, Function<? super RT, Boolean> booleanExtractor) {
            this.predicateFunctions.put(filterName, FilterSupport.booleanFilter(booleanExtractor));
            return this;
        }

        public Builder<RT> withBooleanSetProperty(String filterName, Function<? super RT, Set<Boolean>> booleanSetExtractor) {
            this.predicateFunctions.put(filterName, FilterSupport.booleanSetFilter(booleanSetExtractor));
            return this;
        }

        public Builder<RT> withDateProperty(String filterName, Function<? super RT, Date> dateExtractor) {
            this.predicateFunctions.put(filterName, FilterSupport.dateFilter(dateExtractor));
            return this;
        }

        public Builder<RT> withDateSetProperty(String filterName, Function<? super RT, Set<Date>> dateSetExtractor) {
            this.predicateFunctions.put(filterName, FilterSupport.dateSetFilter(dateSetExtractor));
            return this;
        }

        public Builder<RT> withIntegerProperty(String filterName, Function<? super RT, Integer> integerExtractor) {
            this.predicateFunctions.put(filterName, FilterSupport.intFilter(integerExtractor));
            return this;
        }

        public Builder<RT> withIntegerSetProperty(String filterName, Function<? super RT, Set<Integer>> integerSetExtractor) {
            this.predicateFunctions.put(filterName, FilterSupport.intSetFilter(integerSetExtractor));
            return this;
        }

        public Builder<RT> withIntegerSetProperty(String filterName, Function<? super RT, Set<Integer>> integerSetExtractor, Function<String, Integer> valueFunction) {
            this.predicateFunctions.put(filterName, FilterSupport.intSetFilter(integerSetExtractor, (Function<String, Integer>)valueFunction));
            return this;
        }

        public Builder<RT> withLongProperty(String filterName, Function<? super RT, Long> longExtractor) {
            this.predicateFunctions.put(filterName, FilterSupport.longFilter(longExtractor));
            return this;
        }

        public Builder<RT> withLongSetProperty(String filterName, Function<? super RT, Set<Long>> longSetExtractor) {
            this.predicateFunctions.put(filterName, FilterSupport.longSetFilter(longSetExtractor));
            return this;
        }

        public Builder<RT> withStringProperty(String filterName, Function<? super RT, String> stringExtractor) {
            this.predicateFunctions.put(filterName, FilterSupport.stringFilter(stringExtractor));
            return this;
        }

        public Builder<RT> withInternalStringProperty(String filterName, Function<? super RT, String> stringExtractor) {
            this.internalFilters.add(filterName);
            this.predicateFunctions.put(filterName, FilterSupport.stringFilter(stringExtractor));
            return this;
        }

        public Builder<RT> withStringSetProperty(String filterName, Function<? super RT, Set<String>> stringSetExtractor) {
            this.predicateFunctions.put(filterName, FilterSupport.stringSetFilter(stringSetExtractor));
            return this;
        }

        public Builder<RT> withLikeExplodedProperty(String filterName, Function<? super RT, ?> extractor, Function<String, Collection> explodeFunction) {
            this.predicateFunctions.put(filterName, FilterSupport.explodedLiteralFilter(extractor, (Function<String, Collection>)FilterSupport.likeWildFunction(explodeFunction)));
            return this;
        }

        public Builder<RT> withConstantProperty(String filterName, String value) {
            this.predicateFunctions.put(filterName, FilterSupport.stringFilter(Functions.compose((Function)Functions.constant((Object)value), (Function)Functions.identity())));
            return this;
        }

        public Builder<RT> withUnsupportedProperty(String filterName) {
            this.predicateFunctions.put(filterName, FilterSupport.falseFilter());
            return this;
        }

        public Builder<RT> withPersistenceAlias(String path, String alias) {
            this.aliases.put(path, alias);
            return this;
        }

        public Builder<RT> withPersistenceFilter(String name) {
            return this.withPersistenceFilter(name, name);
        }

        public Builder<RT> withPersistenceFilter(String filterName, String fieldName) {
            return this.withPersistenceFilter(filterName, fieldName, this.aliases(fieldName));
        }

        public Builder<RT> withPersistenceFilter(String filterName, String fieldName, Set<String> aliases) {
            this.persistenceFilters.put(filterName, PersistenceFilter.persistenceFilter(fieldName, aliases));
            return this;
        }

        public Builder<RT> withPersistenceFilter(String filterName, String fieldName, PersistenceFilter.Type type) {
            return this.withPersistenceFilter(filterName, fieldName, this.aliases(fieldName), type);
        }

        public Builder<RT> withPersistenceFilter(String filterName, String fieldName, Set<String> aliases, PersistenceFilter.Type type) {
            this.persistenceFilters.put(filterName, PersistenceFilter.persistenceFilter(fieldName, aliases, type));
            return this;
        }

        public Builder<RT> withPersistenceFilter(String filterName, String fieldName, Function<String, ?> valueFunction) {
            return this.withPersistenceFilter(filterName, fieldName, this.aliases(fieldName), valueFunction);
        }

        public Builder<RT> withPersistenceFilter(String filterName, String fieldName, Set<String> aliases, Function<String, ?> valueFunction) {
            this.persistenceFilters.put(filterName, PersistenceFilter.persistenceFilter(fieldName, aliases, valueFunction));
            return this;
        }

        public Builder<RT> withLikeExplodingPersistenceFilter(String filterName, String fieldName, Function<String, Collection> explodeFunction) {
            this.persistenceFilters.put(filterName, PersistenceFilter.persistenceFilter(fieldName, this.aliases(fieldName), FilterSupport.likeWildFunction(explodeFunction)));
            return this;
        }

        private Set<String> aliases(String fieldPath) {
            HashSet aliases = Sets.newHashSet();
            Iterator aliasIterator = Splitter.on((String)".").split((CharSequence)fieldPath).iterator();
            while (aliasIterator.hasNext()) {
                String value = (String)aliasIterator.next();
                if (!aliasIterator.hasNext()) continue;
                aliases.add(value);
            }
            return aliases;
        }

        private Map<String, Function<? super String, Predicate<? super RT>>> buildPredicateFunctions() {
            return ImmutableMap.copyOf(this.predicateFunctions);
        }

        private Set<String> buildInternalFilters() {
            return ImmutableSet.copyOf(this.internalFilters);
        }

        private Map<String, String> buildAliases() {
            return ImmutableMap.copyOf(this.aliases);
        }

        private Map<String, PersistenceFilter> buildPersistenceFilters() {
            return ImmutableMap.copyOf(this.persistenceFilters);
        }
    }
}

