/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.tags;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class Filter {
    @Nonnull
    private final Map<String, String> aliases;
    @Nonnull
    private final Criterion criterion;
    @Nonnull
    private final Predicate<Object> predicate;
    private final boolean filteringOnTags;

    Filter(@Nonnull Map<String, String> aliases, @Nonnull Criterion criterion, @Nonnull Predicate<Object> predicate, boolean filteringOnTags) {
        this.aliases = aliases;
        this.criterion = criterion;
        this.predicate = predicate;
        this.filteringOnTags = filteringOnTags;
    }

    Filter(@Nonnull Predicate<Object> predicate, boolean filteringOnTags) {
        this(Collections.emptyMap(), (Criterion)Restrictions.conjunction(), predicate, filteringOnTags);
    }

    private Filter() {
        this((Predicate<Object>)Predicates.alwaysTrue(), false);
    }

    @Nonnull
    public Map<String, String> getAliases() {
        return this.aliases;
    }

    @Nonnull
    public Criterion asCriterion() {
        return this.criterion;
    }

    @Nonnull
    public Criterion asCriterionWithConjunction(Criterion criterion) {
        return Restrictions.conjunction().add(criterion).add(this.asCriterion());
    }

    @Nonnull
    public Predicate<Object> asPredicate() {
        return this.predicate;
    }

    public boolean isFilteringOnTags() {
        return this.filteringOnTags;
    }

    static Filter alwaysTrue() {
        return new Filter();
    }

    public Filter and(Filter filter) {
        HashMap aliases = Maps.newHashMap();
        aliases.putAll(this.aliases);
        aliases.putAll(filter.aliases);
        Conjunction and = Restrictions.conjunction();
        and.add(this.criterion);
        and.add(filter.criterion);
        return new Filter(aliases, (Criterion)and, (Predicate<Object>)Predicates.and(this.predicate, filter.predicate), this.filteringOnTags || filter.filteringOnTags);
    }
}

