/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.node;

import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.ClusterConfiguration;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceBuilder;
import com.eucalyptus.component.ServiceBuilders;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.empyrean.DescribeServicesResponseType;
import com.eucalyptus.empyrean.DescribeServicesType;
import com.eucalyptus.empyrean.ServiceId;
import com.eucalyptus.empyrean.ServiceStatusType;
import com.eucalyptus.empyrean.ServiceTransitionType;
import com.eucalyptus.node.NodeController;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.fsm.TransitionRecord;
import com.eucalyptus.vm.VmInstance;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.cloud.NodeInfo;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.NodeType;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class Nodes {
    private static Logger LOG = Logger.getLogger(Nodes.class);
    public static Long REFRESH_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);

    static Function<String, NodeInfo> lookupNodeInfo(final ServiceConfiguration ccConfig) {
        return new Function<String, NodeInfo>(){

            public NodeInfo apply(@Nullable String ncHostOrTag) {
                Map<String, NodeInfo> map = Clusters.lookup(ccConfig).getNodeHostMap();
                if (map.containsKey(ncHostOrTag)) {
                    return map.get(ncHostOrTag);
                }
                throw new NoSuchElementException("Failed to lookup node using " + ncHostOrTag + ".  Available nodes are: " + Joiner.on((String)"\n").join(map.keySet()));
            }
        };
    }

    static Function<NodeInfo, ServiceConfiguration> transformNodeInfo(final ServiceConfiguration ccConfig) {
        return new Function<NodeInfo, ServiceConfiguration>(){

            public ServiceConfiguration apply(@Nullable NodeInfo input) {
                NodeController compId = (NodeController)ComponentIds.lookup(NodeController.class);
                Component comp = Components.lookup((ComponentId)compId);
                try {
                    return comp.lookup(input.getName());
                }
                catch (NoSuchElementException ex1) {
                    URI nodeUri = URI.create(input.getServiceTag());
                    ServiceBuilder builder = ServiceBuilders.lookup((ComponentId)comp.getComponentId());
                    ServiceConfiguration config = builder.newInstance(ccConfig.getPartition(), input.getName(), nodeUri.getHost(), Integer.valueOf(nodeUri.getPort()));
                    comp.setup(config);
                    return config;
                }
            }
        };
    }

    private static Function<String, ServiceConfiguration> lookupNodeServiceConfiguration(ServiceConfiguration ccConfig) {
        return Functions.compose(Nodes.transformNodeInfo(ccConfig), Nodes.lookupNodeInfo(ccConfig));
    }

    public static void updateNodeInfo(ServiceConfiguration ccConfig, List<NodeType> nodes) {
        block8: {
            ConcurrentNavigableMap<String, NodeInfo> clusterNodeMap = Clusters.lookup(ccConfig).getNodeMap();
            HashSet knownTags = Sets.newHashSet((Iterable)clusterNodeMap.keySet());
            HashSet reportedTags = Sets.newHashSet();
            for (NodeType node : nodes) {
                reportedTags.add(node.getServiceTag());
            }
            Sets.SetView unreportedTags = Sets.difference((Set)knownTags, (Set)reportedTags);
            Sets.SetView newTags = Sets.difference((Set)reportedTags, (Set)knownTags);
            Sets.SetView stillKnownTags = Sets.intersection((Set)knownTags, (Set)reportedTags);
            StringBuilder nodeLog = new StringBuilder();
            for (String unreportedTag : unreportedTags) {
                NodeInfo unreportedNode = (NodeInfo)clusterNodeMap.get(unreportedTag);
                if (unreportedNode == null || System.currentTimeMillis() - unreportedNode.getLastSeen().getTime() <= REFRESH_TIMEOUT) continue;
                Topology.destroy((ServiceConfiguration)Components.lookup(NodeController.class).lookup(unreportedNode.getName()));
                NodeInfo removed = (NodeInfo)clusterNodeMap.remove(unreportedTag);
                nodeLog.append("GONE:").append(removed.getName()).append(":").append(removed.getLastState()).append(" ");
            }
            HashSet nodesToUpdate = Sets.newHashSet();
            for (NodeType node : nodes) {
                try {
                    NodeInfo nodeInfo;
                    String serviceTag = node.getServiceTag();
                    if (newTags.contains(serviceTag)) {
                        clusterNodeMap.putIfAbsent(serviceTag, new NodeInfo(ccConfig.getPartition(), node));
                        nodeInfo = (NodeInfo)clusterNodeMap.get(serviceTag);
                        nodeLog.append("NEW:").append(nodeInfo.getName()).append(":").append(nodeInfo.getLastState()).append(" ");
                        nodesToUpdate.add(nodeInfo);
                        continue;
                    }
                    if (!stillKnownTags.contains(serviceTag)) continue;
                    nodeInfo = (NodeInfo)clusterNodeMap.get(serviceTag);
                    nodeInfo.setIqn(node.getIqn());
                    nodeLog.append("OLD:").append(nodeInfo.getName()).append(":").append(nodeInfo.getLastState()).append(" ");
                    nodesToUpdate.add(nodeInfo);
                }
                catch (NoSuchElementException e) {
                    LOG.error((Object)e);
                    LOG.debug((Object)e, (Throwable)e);
                }
            }
            LOG.debug((Object)("Updated node info map: " + nodeLog.toString()));
            try {
                Nodes.updateServiceConfiguration(ccConfig, nodesToUpdate);
            }
            catch (Exception e) {
                if (Component.State.ENABLED.apply(ccConfig)) break block8;
                LOG.debug((Object)("Error while updating nodes: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static ServiceConfiguration lookup(ServiceConfiguration ccConfig, NodeInfo nodeInfo) throws NoSuchElementException {
        return (ServiceConfiguration)Nodes.transformNodeInfo(ccConfig).apply((Object)nodeInfo);
    }

    public static ServiceConfiguration lookup(ServiceConfiguration ccConfig, String hostOrTag) throws NoSuchElementException {
        return (ServiceConfiguration)Nodes.lookupNodeServiceConfiguration(ccConfig).apply((Object)hostOrTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateServiceConfiguration(final ServiceConfiguration ccConfig, Set<NodeInfo> nodeInfoSet) throws NoSuchElementException {
        Function<NodeInfo, ServiceConfiguration> setupNode = new Function<NodeInfo, ServiceConfiguration>(){

            @Nullable
            public ServiceConfiguration apply(@Nullable NodeInfo input) {
                if (Component.State.ENABLED.apply(ccConfig) && !ccConfig.lookupStateMachine().isBusy()) {
                    ServiceConfiguration ncConfig = Nodes.lookup(ccConfig, input.getName());
                    Component component = Components.lookup(NodeController.class);
                    if (!component.hasService(ncConfig)) {
                        component.setup(ncConfig);
                        try {
                            Topology.disable((ServiceConfiguration)ncConfig);
                        }
                        catch (Exception e) {
                            LOG.debug((Object)e, (Throwable)e);
                        }
                    }
                    return ncConfig;
                }
                return Nodes.lookup(ccConfig, input.getName());
            }
        };
        Predicate<NodeInfo> disableNodes = new Predicate<NodeInfo>(){

            public boolean apply(@Nullable NodeInfo nodeInfo) {
                try {
                    Topology.disable((ServiceConfiguration)Nodes.lookup(ccConfig, nodeInfo.getName()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        };
        if (Component.State.DISABLED.ordinal() >= ccConfig.lookupState().ordinal()) {
            Iterables.filter(nodeInfoSet, (Predicate)disableNodes);
        }
        Function<ServiceStatusType, String> statusToName = new Function<ServiceStatusType, String>(){

            @Nullable
            public String apply(@Nullable ServiceStatusType status) {
                return status.getServiceId().getName();
            }
        };
        Iterable nodesConfigs = Iterables.transform(nodeInfoSet, (Function)setupNode);
        if (!nodeInfoSet.isEmpty()) {
            DescribeServicesResponseType reply = (DescribeServicesResponseType)Nodes.send((ServiceTransitionType)new DescribeServicesType(), (ServiceConfiguration[])Iterables.toArray((Iterable)nodesConfigs, ServiceConfiguration.class));
            ImmutableMap statusMap = Maps.uniqueIndex((Iterable)reply.getServiceStatuses(), (Function)statusToName);
            ImmutableMap nodeInfoMap = Maps.uniqueIndex(nodeInfoSet, (Function)new Function<NodeInfo, String>(){

                @Nullable
                public String apply(@Nullable NodeInfo nodeInfo) {
                    return nodeInfo.getName();
                }
            });
            for (ServiceConfiguration ncConfig : nodesConfigs) {
                TransitionRecord tr;
                Faults.CheckException checkException;
                String lastMessage;
                NodeInfo nodeInfo;
                Component.State reportedState;
                block16: {
                    reportedState = Component.State.ENABLED;
                    ServiceStatusType status = (ServiceStatusType)statusMap.get(ncConfig.getName());
                    nodeInfo = (NodeInfo)nodeInfoMap.get(ncConfig.getName());
                    lastMessage = null;
                    checkException = null;
                    tr = null;
                    try {
                        lastMessage = Joiner.on((String)"\n").join((Iterable)status.getDetails());
                        tr = ncConfig.lookupStateMachine().getTransitionRecord();
                        try {
                            reportedState = Component.State.valueOf((String)Strings.nullToEmpty((String)status.getLocalState()).toUpperCase());
                            lastMessage = Joiner.on((char)'\n').join((Object)lastMessage, (Object)("Found service status for " + ncConfig.getName() + ": " + reportedState), new Object[0]);
                        }
                        catch (IllegalArgumentException e) {
                            lastMessage = Joiner.on((char)'\n').join((Object)lastMessage, (Object)("Failed to get service status for " + ncConfig.getName() + "; got " + status.getLocalState()), new Object[0]);
                        }
                        if (ncConfig.lookupStateMachine().isBusy()) {
                            lastMessage = !ncConfig.lookupState().equals((Object)reportedState) ? Joiner.on((char)'\n').join((Object)lastMessage, (Object)("Found state mismatch for node " + ncConfig.getName() + ": reported=" + reportedState + " local=" + ncConfig.getStateMachine()), new Object[0]) : Joiner.on((char)'\n').join((Object)lastMessage, (Object)("Found state for node " + ncConfig.getName() + ": reported=" + reportedState + " local=" + ncConfig.getStateMachine()), new Object[0]);
                            break block16;
                        }
                        try {
                            if (Component.State.ENABLED.equals((Object)reportedState)) {
                                Topology.enable((ServiceConfiguration)ncConfig);
                            } else if (!Component.State.STOPPED.apply(ncConfig)) {
                                Topology.disable((ServiceConfiguration)ncConfig);
                                if (Component.State.NOTREADY.equals((Object)reportedState)) {
                                    checkException = Faults.failure((ServiceConfiguration)ncConfig, (String[])new String[]{Joiner.on((String)",").join((Iterable)status.getDetails())});
                                }
                            } else {
                                Topology.stop((ServiceConfiguration)ncConfig);
                            }
                        }
                        catch (Exception e) {
                            LOG.debug((Object)e, (Throwable)e);
                            if (checkException != null) {
                                LOG.debug((Object)checkException);
                            }
                            checkException = Faults.failure((ServiceConfiguration)ncConfig, (Throwable[])new Throwable[]{e, (Throwable)Objects.firstNonNull((Object)((Object)checkException), (Object)((Object)Faults.advisory((ServiceConfiguration)ncConfig, (String[])new String[]{lastMessage})))});
                        }
                    }
                    catch (Throwable throwable) {
                        checkException = (Faults.CheckException)((Object)Objects.firstNonNull(checkException, (Object)((Object)Faults.advisory((ServiceConfiguration)ncConfig, (String[])new String[]{lastMessage}))));
                        nodeInfo.touch(reportedState, lastMessage, checkException);
                        Faults.submit((ServiceConfiguration)ncConfig, (TransitionRecord)tr, (Faults.CheckException)checkException);
                        throw throwable;
                    }
                }
                checkException = (Faults.CheckException)((Object)Objects.firstNonNull((Object)((Object)checkException), (Object)((Object)Faults.advisory((ServiceConfiguration)ncConfig, (String[])new String[]{lastMessage}))));
                nodeInfo.touch(reportedState, lastMessage, checkException);
                Faults.submit((ServiceConfiguration)ncConfig, (TransitionRecord)tr, (Faults.CheckException)checkException);
            }
        }
    }

    public static List<String> lookupIqns(ServiceConfiguration ccConfig) {
        Cluster cluster = Clusters.lookup(ccConfig);
        HashSet ret = Sets.newHashSet();
        for (NodeInfo node : cluster.getNodeMap().values()) {
            if (node.getIqn() == null) continue;
            ret.add(node.getIqn());
        }
        return Lists.newArrayList((Iterable)ret);
    }

    public static List<String> lookupIqn(VmInstance vm) {
        ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{vm.lookupPartition()});
        Cluster cluster = Clusters.lookup(ccConfig);
        NodeInfo node = cluster.getNode(vm.getServiceTag());
        if (node == null) {
            throw new NoSuchElementException("Failed to look up node information for " + vm.getInstanceId() + " with service tag " + vm.getServiceTag());
        }
        if (node.getIqn() == null) {
            throw new NoSuchElementException("Error looking up iqn for node " + vm.getServiceTag() + " (" + vm.getInstanceId() + "): node does not have an iqn.");
        }
        return Lists.newArrayList((Object[])new String[]{node.getIqn()});
    }

    static <T extends BaseMessage> T send(ServiceTransitionType msg, ServiceConfiguration ... configsArr) throws RuntimeException {
        ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{configsArr[0].lookupPartition()});
        if (Component.State.ENABLED.apply(ccConfig)) {
            for (ServiceId serviceId : Iterables.transform(Arrays.asList(configsArr), (Function)ServiceConfigurations.ServiceConfigurationToServiceId.INSTANCE)) {
                msg.getServices().add(serviceId);
            }
            try {
                return (T)AsyncRequests.sendSync((ServiceConfiguration)ccConfig, (BaseMessage)msg);
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
        throw Exceptions.noSuchElement((String)("Failed to find cluster controller: " + ccConfig), (Throwable[])new Throwable[0]);
    }

    static ServiceConfiguration lookupClusterController(ServiceConfiguration config) {
        return Topology.lookup(ClusterController.class, (Partition[])new Partition[]{config.lookupPartition()});
    }

    public static void clusterCleanup(Cluster cluster, Exception e) {
        Threads.enqueue(NodeController.class, CleanupNodes.class, (Callable)new CleanupNodes(cluster, e));
    }

    public static class CleanupNodes
    implements Callable<Collection<NodeInfo>> {
        private Cluster cluster;
        private Exception e;

        private CleanupNodes(Cluster cluster, Exception e) {
            this.cluster = cluster;
            this.e = e;
        }

        @Override
        public Collection<NodeInfo> call() throws Exception {
            ClusterConfiguration config = this.cluster.getConfiguration();
            ConcurrentNavigableMap<String, NodeInfo> nodeMap = this.cluster.getNodeMap();
            for (NodeInfo nodeInfo : nodeMap.values()) {
                try {
                    ServiceConfiguration ncConfig = Nodes.lookup((ServiceConfiguration)config, nodeInfo);
                    String lastMessage = Joiner.on((char)'\n').join((Object)nodeInfo.getLastMessage(), (Object)this.e.getMessage(), new Object[0]);
                    Faults.CheckException ex = Faults.failure((ServiceConfiguration)ncConfig, (String[])new String[]{lastMessage});
                    nodeInfo.touch(Component.State.NOTREADY, lastMessage, ex);
                    if (!Component.State.ENABLED.apply(ncConfig)) continue;
                    Topology.disable((ServiceConfiguration)ncConfig);
                }
                catch (Exception e) {
                    LOG.debug((Object)e);
                }
            }
            return nodeMap.values();
        }
    }
}

