/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.node;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Handles;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceBuilder;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.empyrean.EnableServiceType;
import com.eucalyptus.empyrean.ServiceTransitionType;
import com.eucalyptus.empyrean.StopServiceType;
import com.eucalyptus.node.DeregisterNodeControllerType;
import com.eucalyptus.node.DescribeNodeControllersType;
import com.eucalyptus.node.ModifyNodeControllerAttributeType;
import com.eucalyptus.node.NodeController;
import com.eucalyptus.node.NodeControllerConfiguration;
import com.eucalyptus.node.Nodes;
import com.eucalyptus.node.RegisterNodeControllerType;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Joiner;
import edu.ucsb.eucalyptus.cloud.NodeInfo;
import org.apache.log4j.Logger;

@ComponentPart(value=NodeController.class)
@Handles(value={RegisterNodeControllerType.class, DeregisterNodeControllerType.class, DescribeNodeControllersType.class, ModifyNodeControllerAttributeType.class})
public class NodeControllerConfigurationBuilder
implements ServiceBuilder<NodeControllerConfiguration> {
    private static Logger LOG = Logger.getLogger(NodeControllerConfigurationBuilder.class);

    public ComponentId getComponentId() {
        return ComponentIds.lookup(NodeController.class);
    }

    public boolean checkAdd(String partition, String name, String host, Integer port) throws ServiceRegistrationException {
        throw this.failUnsupported();
    }

    public boolean checkUpdate(String partition, String name, String host, Integer port) throws ServiceRegistrationException {
        throw this.failUnsupported();
    }

    private ServiceRegistrationException failUnsupported() throws ServiceRegistrationException {
        throw new ServiceRegistrationException("Node Controllers must currently be registered on the Cluster Controllers for the partition.Apologies.  Please see the documentation.");
    }

    public void fireLoad(ServiceConfiguration parent) throws ServiceRegistrationException {
    }

    public void fireStart(ServiceConfiguration config) throws ServiceRegistrationException {
    }

    public void fireStop(ServiceConfiguration config) throws ServiceRegistrationException {
        if (Bootstrap.isOperational().booleanValue()) {
            Nodes.send((ServiceTransitionType)new StopServiceType(), config);
        }
    }

    public void fireEnable(ServiceConfiguration config) throws ServiceRegistrationException {
        try {
            ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{config.lookupPartition()});
            Nodes.send((ServiceTransitionType)new EnableServiceType(), config);
        }
        catch (RuntimeException e) {
            throw new ServiceRegistrationException("Failed to enable node controller " + config.getFullName() + " because: " + e.getMessage(), (Throwable)e);
        }
    }

    public void fireDisable(ServiceConfiguration config) throws ServiceRegistrationException {
    }

    public void fireCheck(ServiceConfiguration config) throws ServiceRegistrationException {
        ServiceConfiguration ccConfig = Nodes.lookupClusterController(config);
        if (!Component.State.ENABLED.apply(ccConfig) || Component.State.DISABLED.apply(ccConfig) && ccConfig.lookupStateMachine().isBusy()) {
            throw Faults.failure((ServiceConfiguration)config, (Throwable[])new Throwable[]{Exceptions.noSuchElement((String)("Failed to find ENABLED Cluster Controller for " + config), (Throwable[])new Throwable[0])});
        }
        NodeInfo nodeInfo = (NodeInfo)Nodes.lookupNodeInfo(ccConfig).apply((Object)config.getName());
        if (nodeInfo.getLastException() == null) {
            String checkMessage = Joiner.on((char)' ').useForNull("<null>").join((Object)nodeInfo.getLastSeen(), (Object)nodeInfo.getLastState(), new Object[]{nodeInfo.getLastMessage()});
            throw Faults.advisory((ServiceConfiguration)config, (String[])new String[]{checkMessage});
        }
        throw nodeInfo.getLastException();
    }

    public NodeControllerConfiguration newInstance(String partition, String name, String host, Integer port) {
        return new NodeControllerConfiguration(partition, host);
    }

    public NodeControllerConfiguration newInstance() {
        return new NodeControllerConfiguration();
    }
}

