/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.node;

import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.config.ComponentConfiguration;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableIdentifier;
import com.eucalyptus.node.NodeController;
import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_config")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ComponentPart(value=NodeController.class)
@ConfigurableClass(root="node", alias="basic", description="Node Controller Configuration.", singleton=false, deferred=true)
public class NodeControllerConfiguration
extends ComponentConfiguration
implements Serializable {
    @Transient
    private static String DEFAULT_SERVICE_PATH = "/axis2/services/EucalyptusNC";
    @Transient
    private static Integer DEFAULT_SERVICE_PORT = 8775;
    @Transient
    @ConfigurableIdentifier
    private String propertyPrefix;

    public NodeControllerConfiguration() {
    }

    public NodeControllerConfiguration(String partition, String hostName) {
        super(partition, hostName, hostName, DEFAULT_SERVICE_PORT, DEFAULT_SERVICE_PATH);
    }

    @PostLoad
    private void initOnLoad() {
        if (this.propertyPrefix == null) {
            this.propertyPrefix = this.getPartition().replace(".", "") + "." + this.getName();
        }
    }

    public Boolean isVmLocal() {
        return false;
    }

    public Boolean isHostLocal() {
        return BootstrapArgs.isCloudController();
    }

    public Integer getPort() {
        return DEFAULT_SERVICE_PORT;
    }

    public String getServicePath() {
        return DEFAULT_SERVICE_PATH;
    }

    public String getPropertyPrefix() {
        return this.getPartition();
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this.setPartition(propertyPrefix);
    }
}

