/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network.config;

import com.eucalyptus.address.Addresses;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.cluster.ClusterConfiguration;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.config.ComponentConfiguration;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.network.EdgeNetworking;
import com.eucalyptus.network.IPRange;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.network.PrivateAddresses;
import com.eucalyptus.network.config.Cluster;
import com.eucalyptus.network.config.NetworkConfiguration;
import com.eucalyptus.network.config.NetworkConfigurationException;
import com.eucalyptus.network.config.NetworkConfigurationValidator;
import com.eucalyptus.network.config.NetworkConfigurations;
import com.eucalyptus.network.config.Subnet;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.UpperCamelPropertyNamingStrategy;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.cloud.entities.SystemConfiguration;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkConfigurations
implements GroovyObject {
    private static final Logger logger;
    private static final Supplier<Optional<NetworkConfiguration>> networkConfigurationFromEnvironmentSupplier;
    private static final boolean validateConfiguration;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1453166323748;
    private static /* synthetic */ SoftReference $callSiteArray;

    public NetworkConfigurations() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Optional<NetworkConfiguration> getNetworkConfiguration() {
        return NetworkConfigurations.getNetworkConfigurationFromProperty().or((Optional)ScriptBytecodeAdapter.castToType((Object)networkConfigurationFromEnvironmentSupplier.get(), Optional.class));
    }

    public static Optional<NetworkConfiguration> getNetworkConfigurationFromProperty() {
        Optional configuration = Optional.absent();
        String configurationText = NetworkGroups.NETWORK_CONFIGURATION;
        if (!Strings.isNullOrEmpty((String)configurationText)) {
            try {
                Optional optional;
                configuration = optional = Optional.of((Object)NetworkConfigurations.parse(configurationText));
            }
            catch (NetworkConfigurationException e) {
                throw (Throwable)Exceptions.toUndeclared((Throwable)e);
            }
        }
        return configuration;
    }

    public static Optional<NetworkConfiguration> getNetworkConfigurationFromEnvironment() {
        return (Optional)ScriptBytecodeAdapter.castToType((Object)networkConfigurationFromEnvironmentSupplier.get(), Optional.class);
    }

    static List<String> loadSystemNameservers(List<String> fallback) {
        List list;
        String dnsServersProperty = SystemConfiguration.getSystemConfiguration().getNameserverAddress();
        return "127.0.0.1".equals(dnsServersProperty) ? fallback : (DefaultTypeTransformation.booleanUnbox((Object)(list = (List)ScriptBytecodeAdapter.asType((Object)Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)dnsServersProperty)), List.class))) ? list : fallback);
    }

    static Optional<NetworkConfiguration> loadNetworkConfigurationFromEnvironment() {
        return NetworkConfigurations.buildNetworkConfigurationFromProperties(NetworkConfigurations.loadSystemNameservers(ScriptBytecodeAdapter.createList((Object[])new Object[0])), DefaultGroovyMethods.collectEntries((Map)NetworkConfigurations.loadEucalyptusConf(), (Map)Maps.newHashMap(), (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Object key, Object value) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{String.valueOf(key), String.valueOf(value)});
            }

            public Object call(Object key, Object value) {
                return this.doCall(key, value);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadNetworkConfigurationFromEnvironment_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _loadNetworkConfigurationFromEnvironment_closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_loadNetworkConfigurationFromEnvironment_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _loadNetworkConfigurationFromEnvironment_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }));
    }

    static void process(NetworkConfiguration networkConfiguration) {
        Reference networkConfiguration2 = new Reference((Object)networkConfiguration);
        Addresses.getAddressManager().update(NetworkConfigurations.iterateRangesAsString(((NetworkConfiguration)networkConfiguration2.get()).getPublicIps()));
        Entities.transaction(ClusterConfiguration.class, (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class, networkConfiguration2){
            private /* synthetic */ Reference networkConfiguration;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.networkConfiguration = reference = networkConfiguration;
            }

            public Object doCall(EntityTransaction db) {
                DefaultGroovyMethods.each((Object)Components.lookup(ClusterController.class).services(), (Closure)new GeneratedClosure((Object)this, this.getThisObject(), this.networkConfiguration){
                    private /* synthetic */ Reference networkConfiguration;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        this.networkConfiguration = reference = networkConfiguration;
                    }

                    public Object doCall(ClusterConfiguration config) {
                        Reference config2 = new Reference((Object)config);
                        Object object = this.networkConfiguration.get();
                        List<Cluster> list = object != null ? ((NetworkConfiguration)object).getClusters() : null;
                        Object object2 = list != null ? DefaultGroovyMethods.find(list, (Closure)new GeneratedClosure((Object)((Object)this), this.getThisObject(), config2){
                            private /* synthetic */ Reference config;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;
                            {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.config = reference = config;
                            }

                            public Object doCall(Cluster cluster) {
                                return ScriptBytecodeAdapter.compareEqual((Object)cluster.getName(), (Object)((ComponentConfiguration)this.config.get()).getPartition());
                            }

                            public Object call(Cluster cluster) {
                                return this.doCall(cluster);
                            }

                            public ClusterConfiguration getConfig() {
                                return (ClusterConfiguration)ScriptBytecodeAdapter.castToType((Object)this.config.get(), ClusterConfiguration.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _process_closure2_closure17_closure18.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public static /* synthetic */ void __$swapInit() {
                            }

                            static {
                                _process_closure2_closure17_closure18.__$swapInit();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[]{};
                                return new CallSiteArray(_process_closure2_closure17_closure18.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _process_closure2_closure17_closure18.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }

                            static /* synthetic */ Class class$(String string) {
                                try {
                                    return Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                        }) : null;
                        Cluster cluster = (Cluster)ScriptBytecodeAdapter.castToType(object2, Cluster.class);
                        return DefaultGroovyMethods.with((Object)(DefaultTypeTransformation.booleanUnbox(object2) ? cluster : new Cluster()), (Closure)new GeneratedClosure((Object)((Object)this), this.getThisObject(), this.networkConfiguration, config2){
                            private /* synthetic */ Reference networkConfiguration;
                            private /* synthetic */ Reference config;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;
                            {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                this.networkConfiguration = reference2 = networkConfiguration;
                                this.config = reference = config;
                            }

                            public Object doCall(Object it) {
                                Subnet subnet;
                                Subnet subnet2;
                                ClusterConfiguration clusterConfiguration = (ClusterConfiguration)ScriptBytecodeAdapter.castToType((Object)Entities.uniqueResult((Object)this.config.get()), ClusterConfiguration.class);
                                String string = ((NetworkConfiguration)this.networkConfiguration.get()).getMode();
                                clusterConfiguration.setNetworkMode(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "EDGE");
                                clusterConfiguration.setAddressesPerNetwork(-1);
                                clusterConfiguration.setUseNetworkTags(false);
                                clusterConfiguration.setMinNetworkTag(-1);
                                clusterConfiguration.setMaxNetworkTag(-1);
                                clusterConfiguration.setMinNetworkIndex((Long)ScriptBytecodeAdapter.castToType((Object)-1, Long.class));
                                clusterConfiguration.setMaxNetworkIndex((Long)ScriptBytecodeAdapter.castToType((Object)-1, Long.class));
                                Subnet defaultSubnet = null;
                                if (DefaultTypeTransformation.booleanUnbox((Object)this.getProperty("subnet")) && DefaultTypeTransformation.booleanUnbox((Object)((Subnet)this.getProperty("subnet")).getName())) {
                                    List<Subnet> list = ((NetworkConfiguration)this.networkConfiguration.get()).getSubnets();
                                    Object object = list != null ? DefaultGroovyMethods.find(list, (Closure)new GeneratedClosure((Object)((Object)this), this.getThisObject()){
                                        private static /* synthetic */ ClassInfo $staticClassInfo;
                                        public static transient /* synthetic */ boolean __$stMC;
                                        private static /* synthetic */ SoftReference $callSiteArray;

                                        public Object doCall(Subnet s) {
                                            String string = s.getName();
                                            return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : Boolean.valueOf(ScriptBytecodeAdapter.compareEqual((Object)s.getSubnet(), (Object)((Subnet)this.getProperty("subnet")).getName()));
                                        }

                                        public Object call(Subnet s) {
                                            return this.doCall(s);
                                        }

                                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                            if (((Object)((Object)this)).getClass() != _process_closure2_closure17_closure19_closure20.class) {
                                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                            }
                                            ClassInfo classInfo = $staticClassInfo;
                                            if (classInfo == null) {
                                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                            }
                                            return classInfo.getMetaClass();
                                        }

                                        public static /* synthetic */ void __$swapInit() {
                                        }

                                        static {
                                            _process_closure2_closure17_closure19_closure20.__$swapInit();
                                        }

                                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                            String[] stringArray = new String[]{};
                                            return new CallSiteArray(_process_closure2_closure17_closure19_closure20.class, stringArray);
                                        }

                                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                            CallSiteArray callSiteArray;
                                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                                callSiteArray = _process_closure2_closure17_closure19_closure20.$createCallSiteArray();
                                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                            }
                                            return callSiteArray.array;
                                        }

                                        static /* synthetic */ Class class$(String string) {
                                            try {
                                                return Class.forName(string);
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                    }) : null;
                                    defaultSubnet = (Subnet)ScriptBytecodeAdapter.castToType(object, Subnet.class);
                                } else if (!DefaultTypeTransformation.booleanUnbox((Object)this.getProperty("subnet"))) {
                                    List<Subnet> list = ((NetworkConfiguration)this.networkConfiguration.get()).getSubnets();
                                    Object object = list != null ? DefaultGroovyMethods.getAt(list, (int)0) : null;
                                    defaultSubnet = (Subnet)ScriptBytecodeAdapter.castToType((Object)object, Subnet.class);
                                }
                                Object object = this.getProperty("subnet");
                                String string2 = object != null ? ((Subnet)object).getSubnet() : null;
                                clusterConfiguration.setVnetSubnet(DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : ((subnet2 = defaultSubnet) != null ? subnet2.getSubnet() : null));
                                Object object2 = this.getProperty("subnet");
                                String string3 = object2 != null ? ((Subnet)object2).getNetmask() : null;
                                clusterConfiguration.setVnetNetmask(DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : ((subnet = defaultSubnet) != null ? subnet.getNetmask() : null));
                                return null;
                            }

                            public NetworkConfiguration getNetworkConfiguration() {
                                return (NetworkConfiguration)ScriptBytecodeAdapter.castToType((Object)this.networkConfiguration.get(), NetworkConfiguration.class);
                            }

                            public ClusterConfiguration getConfig() {
                                return (ClusterConfiguration)ScriptBytecodeAdapter.castToType((Object)this.config.get(), ClusterConfiguration.class);
                            }

                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _process_closure2_closure17_closure19.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public static /* synthetic */ void __$swapInit() {
                            }

                            static {
                                _process_closure2_closure17_closure19.__$swapInit();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[]{};
                                return new CallSiteArray(_process_closure2_closure17_closure19.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _process_closure2_closure17_closure19.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }

                            static /* synthetic */ Class class$(String string) {
                                try {
                                    return Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                        });
                    }

                    public Object call(ClusterConfiguration config) {
                        Reference config2 = new Reference((Object)config);
                        return this.doCall((ClusterConfiguration)config2.get());
                    }

                    public NetworkConfiguration getNetworkConfiguration() {
                        return (NetworkConfiguration)ScriptBytecodeAdapter.castToType((Object)this.networkConfiguration.get(), NetworkConfiguration.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _process_closure2_closure17.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _process_closure2_closure17.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_process_closure2_closure17.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _process_closure2_closure17.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
                db.commit();
                return null;
            }

            public Object call(EntityTransaction db) {
                return this.doCall(db);
            }

            public NetworkConfiguration getNetworkConfiguration() {
                return (NetworkConfiguration)ScriptBytecodeAdapter.castToType((Object)this.networkConfiguration.get(), NetworkConfiguration.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _process_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _process_closure2.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_process_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _process_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    @Nullable
    public static Subnet getSubnetForCluster(NetworkConfiguration configuration, String clusterName) {
        Subnet subnet;
        Subnet subnet2;
        Subnet subnet3;
        Subnet subnet4;
        Subnet subnet5;
        Subnet subnet6;
        String string;
        Cluster cluster;
        Subnet subnet7;
        String string2;
        Subnet subnet8;
        NetworkConfiguration networkConfiguration;
        Reference clusterName2 = new Reference((Object)clusterName);
        NetworkConfiguration networkConfiguration2 = configuration;
        List<Subnet> list = networkConfiguration2 != null ? networkConfiguration2.getSubnets() : null;
        Integer n = list != null ? Integer.valueOf(list.size()) : null;
        Subnet defaultSubnet = (Subnet)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.compareEqual((Object)1, (Object)(DefaultTypeTransformation.booleanUnbox((Object)n) ? n : Integer.valueOf(0))) ? DefaultGroovyMethods.getAt((networkConfiguration = configuration) != null ? networkConfiguration.getSubnets() : null, (int)0) : null, Subnet.class);
        List<Cluster> list2 = configuration.getClusters();
        Reference cluster2 = new Reference((Object)((Cluster)ScriptBytecodeAdapter.castToType(list2 != null ? DefaultGroovyMethods.find(list2, (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class, clusterName2){
            private /* synthetic */ Reference clusterName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.clusterName = reference = clusterName;
            }

            public Object doCall(Cluster cluster) {
                return ScriptBytecodeAdapter.compareEqual((Object)this.clusterName.get(), (Object)cluster.getName());
            }

            public Object call(Cluster cluster) {
                return this.doCall(cluster);
            }

            public String getClusterName() {
                return (String)ScriptBytecodeAdapter.castToType((Object)this.clusterName.get(), String.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSubnetForCluster_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _getSubnetForCluster_closure3.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_getSubnetForCluster_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getSubnetForCluster_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }) : null, Cluster.class)));
        Cluster cluster3 = (Cluster)cluster2.get();
        Subnet subnet9 = cluster3 != null ? cluster3.getSubnet() : null;
        if (DefaultTypeTransformation.booleanUnbox((Object)(subnet9 != null ? subnet9.getName() : null))) {
            NetworkConfiguration networkConfiguration3 = configuration;
            List<Subnet> list3 = networkConfiguration3 != null ? networkConfiguration3.getSubnets() : null;
            Object object = list3 != null ? DefaultGroovyMethods.find(list3, (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class, cluster2){
                private /* synthetic */ Reference cluster;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    this.cluster = reference = cluster;
                }

                public Object doCall(Subnet subnet) {
                    String string = subnet.getName();
                    String string2 = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : subnet.getSubnet();
                    Object object = this.cluster.get();
                    Subnet subnet2 = object != null ? ((Cluster)object).getSubnet() : null;
                    return ScriptBytecodeAdapter.compareEqual((Object)string2, (Object)(subnet2 != null ? subnet2.getName() : null));
                }

                public Object call(Subnet subnet) {
                    return this.doCall(subnet);
                }

                public Cluster getCluster() {
                    return (Cluster)ScriptBytecodeAdapter.castToType((Object)this.cluster.get(), Cluster.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getSubnetForCluster_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _getSubnetForCluster_closure4.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_getSubnetForCluster_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getSubnetForCluster_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }) : null;
            Subnet subnet10 = (Subnet)ScriptBytecodeAdapter.castToType(object, Subnet.class);
            subnet8 = DefaultTypeTransformation.booleanUnbox(object) ? subnet10 : defaultSubnet;
        } else {
            subnet8 = defaultSubnet;
        }
        Subnet clusterSubnetFallback = subnet8;
        Cluster cluster4 = (Cluster)cluster2.get();
        Subnet subnet11 = cluster4 != null ? cluster4.getSubnet() : null;
        String string3 = subnet11 != null ? subnet11.getName() : null;
        String name = DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : (DefaultTypeTransformation.booleanUnbox((Object)(string2 = (subnet7 = (cluster = (Cluster)cluster2.get()) != null ? cluster.getSubnet() : null) != null ? subnet7.getSubnet() : null)) ? string2 : (DefaultTypeTransformation.booleanUnbox((Object)(string = (subnet6 = clusterSubnetFallback) != null ? subnet6.getName() : null)) ? string : ((subnet5 = clusterSubnetFallback) != null ? subnet5.getSubnet() : null)));
        Cluster cluster5 = (Cluster)cluster2.get();
        Subnet subnet12 = cluster5 != null ? cluster5.getSubnet() : null;
        String string4 = subnet12 != null ? subnet12.getSubnet() : null;
        String subnet13 = DefaultTypeTransformation.booleanUnbox((Object)string4) ? string4 : ((subnet4 = clusterSubnetFallback) != null ? subnet4.getSubnet() : null);
        Cluster cluster6 = (Cluster)cluster2.get();
        Subnet subnet14 = cluster6 != null ? cluster6.getSubnet() : null;
        String string5 = subnet14 != null ? subnet14.getNetmask() : null;
        String netmask = DefaultTypeTransformation.booleanUnbox((Object)string5) ? string5 : ((subnet3 = clusterSubnetFallback) != null ? subnet3.getNetmask() : null);
        Cluster cluster7 = (Cluster)cluster2.get();
        Subnet subnet15 = cluster7 != null ? cluster7.getSubnet() : null;
        String string6 = subnet15 != null ? subnet15.getGateway() : null;
        String gateway = DefaultTypeTransformation.booleanUnbox((Object)string6) ? string6 : ((subnet2 = clusterSubnetFallback) != null ? subnet2.getGateway() : null);
        if (DefaultTypeTransformation.booleanUnbox((Object)subnet13) && DefaultTypeTransformation.booleanUnbox((Object)netmask) && DefaultTypeTransformation.booleanUnbox((Object)gateway)) {
            Subnet subnet16 = new Subnet();
            subnet16.setName(name);
            subnet16.setSubnet(subnet13);
            subnet16.setNetmask(netmask);
            subnet16.setGateway(gateway);
            subnet = subnet16;
        } else {
            subnet = null;
        }
        return (Subnet)ScriptBytecodeAdapter.castToType(subnet, Subnet.class);
    }

    public static Collection<String> getPrivateAddressRanges(NetworkConfiguration configuration, String clusterName) {
        Reference clusterName2 = new Reference((Object)clusterName);
        return (Collection)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.with((Object)NetworkConfigurations.explode(configuration, ScriptBytecodeAdapter.createList((Object[])new Object[]{(String)clusterName2.get()})), (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class, clusterName2){
            private /* synthetic */ Reference clusterName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.clusterName = reference = clusterName;
            }

            public Object doCall(NetworkConfiguration exploded) {
                return DefaultGroovyMethods.with((Object)DefaultGroovyMethods.find(exploded.getClusters(), (Closure)new GeneratedClosure((Object)this, this.getThisObject(), this.clusterName){
                    private /* synthetic */ Reference clusterName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        this.clusterName = reference = clusterName;
                    }

                    public Object doCall(Cluster cluster) {
                        return ScriptBytecodeAdapter.compareEqual((Object)cluster.getName(), (Object)this.clusterName.get());
                    }

                    public Object call(Cluster cluster) {
                        return this.doCall(cluster);
                    }

                    public String getClusterName() {
                        return (String)ScriptBytecodeAdapter.castToType((Object)this.clusterName.get(), String.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getPrivateAddressRanges_closure5_closure21.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _getPrivateAddressRanges_closure5_closure21.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_getPrivateAddressRanges_closure5_closure21.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _getPrivateAddressRanges_closure5_closure21.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }), (Closure)new GeneratedClosure((Object)this, this.getThisObject(), this.clusterName){
                    private /* synthetic */ Reference clusterName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        this.clusterName = reference = clusterName;
                    }

                    public Object doCall(Cluster cluster) {
                        if (cluster.getSubnet() == null || !DefaultTypeTransformation.booleanUnbox(cluster.getPrivateIps())) {
                            throw (Throwable)new IllegalStateException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{this.clusterName.get()}, new String[]{"Networking configuration not found for cluster '", "'"}), String.class));
                        }
                        return cluster.getPrivateIps();
                    }

                    public Object call(Cluster cluster) {
                        return this.doCall(cluster);
                    }

                    public String getClusterName() {
                        return (String)ScriptBytecodeAdapter.castToType((Object)this.clusterName.get(), String.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getPrivateAddressRanges_closure5_closure22.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _getPrivateAddressRanges_closure5_closure22.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_getPrivateAddressRanges_closure5_closure22.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _getPrivateAddressRanges_closure5_closure22.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
            }

            public Object call(NetworkConfiguration exploded) {
                return this.doCall(exploded);
            }

            public String getClusterName() {
                return (String)ScriptBytecodeAdapter.castToType((Object)this.clusterName.get(), String.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPrivateAddressRanges_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _getPrivateAddressRanges_closure5.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_getPrivateAddressRanges_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getPrivateAddressRanges_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), Collection.class);
    }

    public static Iterable<Integer> getPrivateAddresses(NetworkConfiguration configuration, String clusterName) {
        return Lists.newArrayList(NetworkConfigurations.iterateRanges(NetworkConfigurations.getPrivateAddressRanges(configuration, clusterName)));
    }

    public static Iterable<Integer> getPrivateAddresses(String clusterName) {
        Optional<NetworkConfiguration> configuration = NetworkConfigurations.getNetworkConfiguration();
        if (!configuration.isPresent()) {
            throw (Throwable)new IllegalStateException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{clusterName}, new String[]{"Networking configuration not found for cluster '", "'"}), String.class));
        }
        return NetworkConfigurations.getPrivateAddresses((NetworkConfiguration)ScriptBytecodeAdapter.castToType((Object)configuration.get(), NetworkConfiguration.class), clusterName);
    }

    public static NetworkConfiguration parse(String configuration) throws NetworkConfigurationException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new UpperCamelPropertyNamingStrategy());
        NetworkConfiguration networkConfiguration = null;
        try {
            Object object = mapper.readValue((Reader)new GroovyObject(NetworkConfigurations.class, configuration){
                public /* synthetic */ Class this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    MetaClass metaClass;
                    Class clazz;
                    this.this$0 = clazz = p0;
                    super((String)ScriptBytecodeAdapter.castToType((Object)p2, String.class));
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                public String toString() {
                    return "property";
                }

                public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodOnCurrentN(1.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void this$dist$set$3(String name, Object value) {
                    Object object = value;
                    ScriptBytecodeAdapter.setGroovyObjectField((Object)object, 1.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
                }

                public /* synthetic */ Object this$dist$get$3(String name) {
                    return ScriptBytecodeAdapter.getGroovyObjectField(1.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, NetworkConfigurations.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    Object object = val;
                    ScriptBytecodeAdapter.setField((Object)object, 1.class, NetworkConfigurations.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getField(1.class, NetworkConfigurations.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != 1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                public /* synthetic */ Object invokeMethod(String string, Object object) {
                    return this.getMetaClass().invokeMethod((Object)this, string, object);
                }

                public /* synthetic */ Object getProperty(String string) {
                    return this.getMetaClass().getProperty((Object)this, string);
                }

                public /* synthetic */ void setProperty(String string, Object object) {
                    this.getMetaClass().setProperty((Object)this, string, object);
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    1.__$swapInit();
                }

                public /* synthetic */ void super$1$wait() {
                    super.wait();
                }

                public /* synthetic */ long super$3$skip(long l) {
                    return super.skip(l);
                }

                public /* synthetic */ String super$1$toString() {
                    return super.toString();
                }

                public /* synthetic */ void super$3$close() {
                    super.close();
                }

                public /* synthetic */ void super$1$wait(long l, int n) {
                    super.wait(l, n);
                }

                public /* synthetic */ void super$1$notify() {
                    super.notify();
                }

                public /* synthetic */ Class super$1$getClass() {
                    return super.getClass();
                }

                public /* synthetic */ void super$1$notifyAll() {
                    super.notifyAll();
                }

                public /* synthetic */ void super$3$mark(int n) {
                    super.mark(n);
                }

                public /* synthetic */ boolean super$3$markSupported() {
                    return super.markSupported();
                }

                public /* synthetic */ void super$1$finalize() {
                    super.finalize();
                }

                public /* synthetic */ boolean super$3$ready() {
                    return super.ready();
                }

                public /* synthetic */ int super$3$read() {
                    return super.read();
                }

                public /* synthetic */ void super$1$wait(long l) {
                    super.wait(l);
                }

                public /* synthetic */ int super$2$read(char[] cArray) {
                    return super.read(cArray);
                }

                public /* synthetic */ void super$3$reset() {
                    super.reset();
                }

                public /* synthetic */ boolean super$1$equals(Object object) {
                    return super.equals(object);
                }

                public /* synthetic */ Object super$1$clone() {
                    return super.clone();
                }

                public /* synthetic */ int super$3$read(char[] cArray, int n, int n2) {
                    return super.read(cArray, n, n2);
                }

                public /* synthetic */ int super$2$read(CharBuffer charBuffer) {
                    return super.read(charBuffer);
                }

                public /* synthetic */ int super$1$hashCode() {
                    return super.hashCode();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = 1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }, NetworkConfiguration.class);
            networkConfiguration = (NetworkConfiguration)ScriptBytecodeAdapter.castToType((Object)object, NetworkConfiguration.class);
        }
        catch (JsonProcessingException e) {
            throw (Throwable)new NetworkConfigurationException(e.getMessage());
        }
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult((Object)networkConfiguration, "NetworkConfiguration");
        ValidationUtils.invokeValidator((Validator)new NetworkConfigurationValidator((Errors)errors), (Object)networkConfiguration, (Errors)errors);
        if (validateConfiguration && errors.hasErrors()) {
            StaticMessageSource source = new StaticMessageSource();
            throw (Throwable)new NetworkConfigurationException(source.getMessage((MessageSourceResolvable)ScriptBytecodeAdapter.castToType(errors.getAllErrors().get(0), MessageSourceResolvable.class), Locale.getDefault()));
        }
        return networkConfiguration;
    }

    public static NetworkConfiguration copyOf(NetworkConfiguration configuration) {
        ObjectMapper mapper = new ObjectMapper();
        return (NetworkConfiguration)ScriptBytecodeAdapter.castToType((Object)mapper.readValue(mapper.valueToTree((Object)configuration), NetworkConfiguration.class), NetworkConfiguration.class);
    }

    public static NetworkConfiguration explode(NetworkConfiguration networkConfiguration, Iterable<String> clusterNames) {
        Reference clusterNames2 = new Reference(clusterNames);
        Reference configuration = new Reference((Object)NetworkConfigurations.copyOf(networkConfiguration));
        List list = ((NetworkConfiguration)configuration.get()).getClusters();
        Reference clusters = new Reference((Object)(DefaultTypeTransformation.booleanUnbox(list) ? list : ScriptBytecodeAdapter.createList((Object[])new Object[0])));
        ((NetworkConfiguration)configuration.get()).setClusters((List)clusters.get());
        DefaultGroovyMethods.with((Object)DefaultGroovyMethods.collect((Collection)((List)clusters.get()), (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Cluster cluster) {
                return cluster.getName();
            }

            public Object call(Cluster cluster) {
                return this.doCall(cluster);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _explode_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _explode_closure6.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_explode_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _explode_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class, clusterNames2, clusters){
            private /* synthetic */ Reference clusterNames;
            private /* synthetic */ Reference clusters;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                this.clusterNames = reference2 = clusterNames;
                this.clusters = reference = clusters;
            }

            public Object doCall(Collection<String> names) {
                Reference names2 = new Reference(names);
                return ((List)this.clusters.get()).addAll(DefaultGroovyMethods.findResults((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)this.clusterNames.get(), Iterable.class)), (Closure)new GeneratedClosure((Object)this, this.getThisObject(), names2){
                    private /* synthetic */ Reference names;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        this.names = reference = names;
                    }

                    public Object doCall(String requiredName) {
                        Cluster cluster;
                        if (((Collection)this.names.get()).contains(requiredName)) {
                            cluster = null;
                        } else {
                            Cluster cluster2 = new Cluster();
                            cluster2.setName(requiredName);
                            cluster = cluster2;
                        }
                        return cluster;
                    }

                    public Object call(String requiredName) {
                        return this.doCall(requiredName);
                    }

                    public Collection getNames() {
                        return (Collection)ScriptBytecodeAdapter.castToType((Object)this.names.get(), Collection.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _explode_closure7_closure23.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _explode_closure7_closure23.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_explode_closure7_closure23.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _explode_closure7_closure23.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }));
            }

            public Object call(Collection<String> names) {
                Reference names2 = new Reference(names);
                return this.doCall((Collection)names2.get());
            }

            public Iterable getClusterNames() {
                return (Iterable)ScriptBytecodeAdapter.castToType((Object)this.clusterNames.get(), Iterable.class);
            }

            public List getClusters() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.clusters.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _explode_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _explode_closure7.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_explode_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _explode_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        DefaultGroovyMethods.each((Object)((List)clusters.get()), (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class, configuration){
            private /* synthetic */ Reference configuration;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.configuration = reference = configuration;
            }

            public Object doCall(Cluster cluster) {
                Reference cluster2 = new Reference((Object)cluster);
                return DefaultGroovyMethods.with((Object)((Cluster)cluster2.get()), (Closure)new GeneratedClosure((Object)this, this.getThisObject(), cluster2, this.configuration){
                    private /* synthetic */ Reference cluster;
                    private /* synthetic */ Reference configuration;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        Reference reference2;
                        this.cluster = reference2 = cluster;
                        this.configuration = reference = configuration;
                    }

                    public Object doCall(Object it) {
                        if (!DefaultTypeTransformation.booleanUnbox((Object)this.getProperty("macPrefix"))) {
                            String string = ((NetworkConfiguration)this.configuration.get()).getMacPrefix();
                            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, _explode_closure8_closure24.class, (GroovyObject)this.getDelegate(), (String)"macPrefix");
                        }
                        if ((((NetworkConfiguration)this.configuration.get()).getMode() == null || ScriptBytecodeAdapter.compareEqual((Object)"EDGE", (Object)((NetworkConfiguration)this.configuration.get()).getMode())) && (this.getProperty("subnet") == null || DefaultTypeTransformation.booleanUnbox((Object)this.getProperty("subnet")) && DefaultTypeTransformation.booleanUnbox((Object)((Subnet)this.getProperty("subnet")).getName()) && !DefaultTypeTransformation.booleanUnbox((Object)((Subnet)this.getProperty("subnet")).getSubnet())) && DefaultTypeTransformation.booleanUnbox((Object)this.getProperty("name"))) {
                            Subnet subnet = NetworkConfigurations.getSubnetForCluster((NetworkConfiguration)ScriptBytecodeAdapter.castToType((Object)this.configuration.get(), NetworkConfiguration.class), (String)ScriptBytecodeAdapter.castToType((Object)this.getProperty("name"), String.class));
                            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)subnet, _explode_closure8_closure24.class, (GroovyObject)this.getDelegate(), (String)"subnet");
                        }
                        if (((Cluster)this.cluster.get()).getPrivateIps() == null && DefaultTypeTransformation.booleanUnbox(((NetworkConfiguration)this.configuration.get()).getPrivateIps())) {
                            ((Cluster)this.cluster.get()).setPrivateIps(((NetworkConfiguration)this.configuration.get()).getPrivateIps());
                        } else if (!DefaultTypeTransformation.booleanUnbox(((Cluster)this.cluster.get()).getPrivateIps()) && DefaultTypeTransformation.booleanUnbox((Object)this.getProperty("subnet"))) {
                            ((Cluster)this.cluster.get()).setPrivateIps((List)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.with((Object)this.getProperty("subnet"), (Closure)new GeneratedClosure((Object)((Object)this), this.getThisObject()){
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;
                                private static /* synthetic */ SoftReference $callSiteArray;

                                public Object doCall(Object it) {
                                    return DefaultGroovyMethods.collect(IPRange.fromSubnet((String)ScriptBytecodeAdapter.castToType((Object)this.getProperty("subnet"), String.class), (String)ScriptBytecodeAdapter.castToType((Object)this.getProperty("netmask"), String.class)).split((String)ScriptBytecodeAdapter.castToType((Object)this.getProperty("gateway"), String.class)), (Closure)new GeneratedClosure((Object)((Object)this), this.getThisObject()){
                                        private static /* synthetic */ ClassInfo $staticClassInfo;
                                        public static transient /* synthetic */ boolean __$stMC;
                                        private static /* synthetic */ SoftReference $callSiteArray;

                                        public Object doCall(IPRange range) {
                                            return range.toString();
                                        }

                                        public Object call(IPRange range) {
                                            return this.doCall(range);
                                        }

                                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                            if (((Object)((Object)this)).getClass() != _explode_closure8_closure24_closure25_closure26.class) {
                                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                            }
                                            ClassInfo classInfo = $staticClassInfo;
                                            if (classInfo == null) {
                                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                            }
                                            return classInfo.getMetaClass();
                                        }

                                        public static /* synthetic */ void __$swapInit() {
                                        }

                                        static {
                                            _explode_closure8_closure24_closure25_closure26.__$swapInit();
                                        }

                                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                            String[] stringArray = new String[]{};
                                            return new CallSiteArray(_explode_closure8_closure24_closure25_closure26.class, stringArray);
                                        }

                                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                            CallSiteArray callSiteArray;
                                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                                callSiteArray = _explode_closure8_closure24_closure25_closure26.$createCallSiteArray();
                                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                            }
                                            return callSiteArray.array;
                                        }

                                        static /* synthetic */ Class class$(String string) {
                                            try {
                                                return Class.forName(string);
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                    });
                                }

                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _explode_closure8_closure24_closure25.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public static /* synthetic */ void __$swapInit() {
                                }

                                static {
                                    _explode_closure8_closure24_closure25.__$swapInit();
                                }

                                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                    String[] stringArray = new String[]{};
                                    return new CallSiteArray(_explode_closure8_closure24_closure25.class, stringArray);
                                }

                                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                    CallSiteArray callSiteArray;
                                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                        callSiteArray = _explode_closure8_closure24_closure25.$createCallSiteArray();
                                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                    }
                                    return callSiteArray.array;
                                }

                                static /* synthetic */ Class class$(String string) {
                                    try {
                                        return Class.forName(string);
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                            }), List.class));
                        }
                        return Void.TYPE;
                    }

                    public Cluster getCluster() {
                        return (Cluster)ScriptBytecodeAdapter.castToType((Object)this.cluster.get(), Cluster.class);
                    }

                    public NetworkConfiguration getConfiguration() {
                        return (NetworkConfiguration)ScriptBytecodeAdapter.castToType((Object)this.configuration.get(), NetworkConfiguration.class);
                    }

                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _explode_closure8_closure24.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _explode_closure8_closure24.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_explode_closure8_closure24.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _explode_closure8_closure24.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
            }

            public Object call(Cluster cluster) {
                Reference cluster2 = new Reference((Object)cluster);
                return this.doCall((Cluster)cluster2.get());
            }

            public NetworkConfiguration getConfiguration() {
                return (NetworkConfiguration)ScriptBytecodeAdapter.castToType((Object)this.configuration.get(), NetworkConfiguration.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _explode_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _explode_closure8.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_explode_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _explode_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        Reference clusterSubnetsAndNetmasks = new Reference((Object)DefaultGroovyMethods.collect((Collection)((List)clusters.get()), (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Cluster cluster) {
                Object[] objectArray = new Object[2];
                Cluster cluster2 = cluster;
                Subnet subnet = cluster2 != null ? cluster2.getSubnet() : null;
                objectArray[0] = subnet != null ? subnet.getSubnet() : null;
                Cluster cluster3 = cluster;
                Subnet subnet2 = cluster3 != null ? cluster3.getSubnet() : null;
                objectArray[1] = subnet2 != null ? subnet2.getNetmask() : null;
                return new GStringImpl(objectArray, new String[]{"", "/", ""}).toString();
            }

            public Object call(Cluster cluster) {
                return this.doCall(cluster);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _explode_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _explode_closure9.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_explode_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _explode_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }));
        List<Subnet> list2 = ((NetworkConfiguration)configuration.get()).getSubnets();
        Boolean bl = list2 != null ? Boolean.valueOf(DefaultGroovyMethods.removeAll(list2, (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class, clusterSubnetsAndNetmasks){
            private /* synthetic */ Reference clusterSubnetsAndNetmasks;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.clusterSubnetsAndNetmasks = reference = clusterSubnetsAndNetmasks;
            }

            public Object doCall(Subnet subnet) {
                Object[] objectArray = new Object[2];
                Subnet subnet2 = subnet;
                objectArray[0] = subnet2 != null ? subnet2.getSubnet() : null;
                Subnet subnet3 = subnet;
                objectArray[1] = subnet3 != null ? subnet3.getNetmask() : null;
                return ((List)this.clusterSubnetsAndNetmasks.get()).contains(new GStringImpl(objectArray, new String[]{"", "/", ""}).toString());
            }

            public Object call(Subnet subnet) {
                return this.doCall(subnet);
            }

            public Collection getClusterSubnetsAndNetmasks() {
                return (Collection)ScriptBytecodeAdapter.castToType((Object)this.clusterSubnetsAndNetmasks.get(), Collection.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _explode_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _explode_closure10.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_explode_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _explode_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        })) : null;
        List<Subnet> list3 = ((NetworkConfiguration)configuration.get()).getSubnets();
        Boolean bl2 = list3 != null ? Boolean.valueOf(list3.isEmpty()) : null;
        if (bl2 == null ? false : bl2) {
            ((NetworkConfiguration)configuration.get()).setSubnets(null);
        }
        return (NetworkConfiguration)configuration.get();
    }

    public static void validate(NetworkConfiguration configuration) throws NetworkConfigurationException {
        Reference configuration2 = new Reference((Object)configuration);
        NetworkConfiguration networkConfiguration = (NetworkConfiguration)configuration2.get();
        Object object = networkConfiguration != null ? DefaultGroovyMethods.with((Object)networkConfiguration, (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class, configuration2){
            private /* synthetic */ Reference configuration;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.configuration = reference = configuration;
            }

            public Object doCall(Object it) {
                if (((NetworkConfiguration)this.configuration.get()).getMode() == null || ScriptBytecodeAdapter.compareEqual((Object)"EDGE", (Object)((NetworkConfiguration)this.configuration.get()).getMode())) {
                    if (DefaultTypeTransformation.booleanUnbox(((NetworkConfiguration)this.configuration.get()).getClusters())) {
                        DefaultGroovyMethods.each(((NetworkConfiguration)this.configuration.get()).getClusters(), (Closure)new GeneratedClosure((Object)this, this.getThisObject()){
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public Object doCall(Cluster cluster) {
                                if (DefaultTypeTransformation.booleanUnbox((Object)cluster.getSubnet()) && DefaultTypeTransformation.booleanUnbox(cluster.getPrivateIps())) {
                                    NetworkConfigurations.access$0(null, cluster.getSubnet(), cluster.getPrivateIps(), (String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{cluster.getName()}, new String[]{" for cluster ", ""}), String.class));
                                }
                                return Void.TYPE;
                            }

                            public Object call(Cluster cluster) {
                                return this.doCall(cluster);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _validate_closure11_closure27.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public static /* synthetic */ void __$swapInit() {
                            }

                            static {
                                _validate_closure11_closure27.__$swapInit();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[]{};
                                return new CallSiteArray(_validate_closure11_closure27.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _validate_closure11_closure27.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }

                            static /* synthetic */ Class class$(String string) {
                                try {
                                    return Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                        });
                    } else {
                        if (!DefaultTypeTransformation.booleanUnbox(((NetworkConfiguration)this.configuration.get()).getSubnets()) || ((NetworkConfiguration)this.configuration.get()).getSubnets().size() != 1) {
                            throw (Throwable)new NetworkConfigurationException("A single subnet must be configured when clusters are not specified.");
                        }
                        InvokerHelper.invokeStaticMethod(NetworkConfigurations.class, (String)"validateIPsForSubnet", (Object)new Object[]{DefaultGroovyMethods.getAt(((NetworkConfiguration)this.configuration.get()).getSubnets(), (int)0), ((NetworkConfiguration)this.configuration.get()).getPrivateIps()});
                    }
                } else if (ScriptBytecodeAdapter.compareEqual((Object)"VPCMIDO", (Object)((NetworkConfiguration)this.configuration.get()).getMode())) {
                    if (DefaultTypeTransformation.booleanUnbox(((NetworkConfiguration)this.configuration.get()).getClusters())) {
                        DefaultGroovyMethods.each(((NetworkConfiguration)this.configuration.get()).getClusters(), (Closure)new GeneratedClosure((Object)this, this.getThisObject()){
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public Object doCall(Cluster cluster) {
                                if (DefaultTypeTransformation.booleanUnbox(cluster.getPrivateIps())) {
                                    throw (Throwable)new NetworkConfigurationException("Private IP configuration not permitted for VPCMIDO.");
                                }
                                if (DefaultTypeTransformation.booleanUnbox((Object)cluster.getSubnet())) {
                                    throw (Throwable)new NetworkConfigurationException("Subnet configuration not permitted for VPCMIDO.");
                                }
                                return Void.TYPE;
                            }

                            public Object call(Cluster cluster) {
                                return this.doCall(cluster);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _validate_closure11_closure28.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public static /* synthetic */ void __$swapInit() {
                            }

                            static {
                                _validate_closure11_closure28.__$swapInit();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[]{};
                                return new CallSiteArray(_validate_closure11_closure28.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _validate_closure11_closure28.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }

                            static /* synthetic */ Class class$(String string) {
                                try {
                                    return Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                        });
                    }
                    if (DefaultTypeTransformation.booleanUnbox(((NetworkConfiguration)this.configuration.get()).getPrivateIps())) {
                        throw (Throwable)new NetworkConfigurationException("Private IP configuration not permitted for VPCMIDO.");
                    }
                    if (DefaultTypeTransformation.booleanUnbox(((NetworkConfiguration)this.configuration.get()).getSubnets())) {
                        throw (Throwable)new NetworkConfigurationException("Subnet configuration not permitted for VPCMIDO.");
                    }
                }
                return Void.TYPE;
            }

            public NetworkConfiguration getConfiguration() {
                return (NetworkConfiguration)ScriptBytecodeAdapter.castToType((Object)this.configuration.get(), NetworkConfiguration.class);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validate_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _validate_closure11.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_validate_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validate_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }) : null;
    }

    private static void validateIPsForSubnet(Subnet net, List<String> ipRanges, String desc) {
        Reference desc2 = new Reference((Object)desc);
        Reference subnet = new Reference((Object)net.getSubnet());
        Reference netmask = new Reference((Object)net.getNetmask());
        Reference subnetRange = new Reference((Object)IPRange.fromSubnet((String)subnet.get(), (String)netmask.get()));
        List<String> list = ipRanges;
        List list2 = list != null ? DefaultGroovyMethods.collect(list, (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(String range) {
                return IPRange.parse().apply((Object)range);
            }

            public Object call(String range) {
                return this.doCall(range);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateIPsForSubnet_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _validateIPsForSubnet_closure12.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_validateIPsForSubnet_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateIPsForSubnet_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }) : null;
        Collection collection = list2 != null ? DefaultGroovyMethods.findResults((Iterable)list2, (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Optional<IPRange> range) {
                return range.orNull();
            }

            public Object call(Optional<IPRange> range) {
                return this.doCall(range);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateIPsForSubnet_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _validateIPsForSubnet_closure13.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_validateIPsForSubnet_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateIPsForSubnet_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }) : null;
        Object object = collection != null ? DefaultGroovyMethods.each((Object)collection, (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class, desc2, subnet, subnetRange, netmask){
            private /* synthetic */ Reference desc;
            private /* synthetic */ Reference subnet;
            private /* synthetic */ Reference subnetRange;
            private /* synthetic */ Reference netmask;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.desc = reference4 = desc;
                this.subnet = reference3 = subnet;
                this.subnetRange = reference2 = subnetRange;
                this.netmask = reference = netmask;
            }

            public Object doCall(IPRange range) {
                if (!((IPRange)this.subnetRange.get()).contains(range)) {
                    throw (Throwable)new NetworkConfigurationException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{range, this.subnet.get(), this.netmask.get(), this.desc.get()}, new String[]{"Private IP range ", " not valid for subnet/netmask ", "/", "", ""}), String.class));
                }
                return null;
            }

            public Object call(IPRange range) {
                return this.doCall(range);
            }

            public String getDesc() {
                return (String)ScriptBytecodeAdapter.castToType((Object)this.desc.get(), String.class);
            }

            public String getSubnet() {
                return (String)ScriptBytecodeAdapter.castToType((Object)this.subnet.get(), String.class);
            }

            public IPRange getSubnetRange() {
                return (IPRange)ScriptBytecodeAdapter.castToType((Object)this.subnetRange.get(), IPRange.class);
            }

            public String getNetmask() {
                return (String)ScriptBytecodeAdapter.castToType((Object)this.netmask.get(), String.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateIPsForSubnet_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _validateIPsForSubnet_closure14.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_validateIPsForSubnet_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateIPsForSubnet_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }) : null;
    }

    static Properties loadEucalyptusConf() {
        Reference properties = new Reference((Object)new Properties());
        File eucalyptusConf = new File((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{System.getenv("EUCALYPTUS")}, new String[]{"", "/etc/eucalyptus/eucalyptus.conf"}), String.class));
        if (eucalyptusConf.canRead() && eucalyptusConf.isFile()) {
            IOGroovyMethods.withStream((InputStream)ResourceGroovyMethods.newInputStream((File)eucalyptusConf), (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class, properties){
                private /* synthetic */ Reference properties;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    this.properties = reference = properties;
                }

                public Object doCall(InputStream input) {
                    ((Properties)this.properties.get()).load(input);
                    return null;
                }

                public Object call(InputStream input) {
                    return this.doCall(input);
                }

                public Properties getProperties() {
                    return (Properties)ScriptBytecodeAdapter.castToType((Object)this.properties.get(), Properties.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadEucalyptusConf_closure15.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _loadEucalyptusConf_closure15.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_loadEucalyptusConf_closure15.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _loadEucalyptusConf_closure15.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        }
        return (Properties)properties.get();
    }

    static Optional<NetworkConfiguration> buildNetworkConfigurationFromProperties(List<String> primaryInstanceDnsServers, Map<String, String> properties) {
        Optional configuration = Optional.absent();
        if (ScriptBytecodeAdapter.compareEqual((Object)"EDGE", (Object)NetworkConfigurations.getTrimmedDequotedProperty(properties, "VNET_MODE"))) {
            Optional optional;
            NetworkConfiguration networkConfiguration = new NetworkConfiguration();
            networkConfiguration.setInstanceDnsDomain(NetworkConfigurations.getTrimmedDequotedProperty(properties, "VNET_DOMAINNAME"));
            networkConfiguration.setInstanceDnsServers((List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.plus(primaryInstanceDnsServers, (Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{NetworkConfigurations.getTrimmedDequotedProperty(properties, "VNET_DNS")})), List.class));
            networkConfiguration.setPublicIps(NetworkConfigurations.getFilteredDequotedPropertyList(properties, "VNET_PUBLICIPS", ScriptBytecodeAdapter.getMethodPointer(IPRange.class, (String)"isIPRange")));
            networkConfiguration.setPrivateIps(NetworkConfigurations.getFilteredDequotedPropertyList(properties, "VNET_PRIVATEIPS", ScriptBytecodeAdapter.getMethodPointer(IPRange.class, (String)"isIPRange")));
            Object[] objectArray = new Object[1];
            Subnet subnet = new Subnet();
            subnet.setSubnet(NetworkConfigurations.getTrimmedDequotedProperty(properties, "VNET_SUBNET"));
            subnet.setNetmask(NetworkConfigurations.getTrimmedDequotedProperty(properties, "VNET_NETMASK"));
            subnet.setGateway(NetworkConfigurations.getTrimmedDequotedProperty(properties, "VNET_ROUTER"));
            objectArray[0] = subnet;
            networkConfiguration.setSubnets(ScriptBytecodeAdapter.createList((Object[])objectArray));
            configuration = optional = Optional.of((Object)networkConfiguration);
        }
        return configuration;
    }

    private static String getTrimmedDequotedProperty(Map<String, String> properties, String name) {
        String string = ((String)DefaultGroovyMethods.with((Object)((String)DefaultGroovyMethods.get(properties, (Object)name, (Object)"")).trim(), (Closure)new GeneratedClosure(NetworkConfigurations.class, NetworkConfigurations.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Object it) {
                return ((String)this.getDelegate()).startsWith("\"") && ((String)this.getDelegate()).endsWith("\"") ? ((String)this.getDelegate()).substring(1, ((String)this.getDelegate()).length() - 1) : ((String)this.getDelegate()).toString();
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getTrimmedDequotedProperty_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _getTrimmedDequotedProperty_closure16.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_getTrimmedDequotedProperty_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getTrimmedDequotedProperty_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        })).trim();
        return (String)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : null), String.class);
    }

    private static List<String> getFilteredDequotedPropertyList(Map<String, String> properties, String name, Closure filter) {
        Splitter splitter = Splitter.on((String)" ").trimResults().omitEmptyStrings();
        String string = NetworkConfigurations.getTrimmedDequotedProperty(properties, name);
        return (List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.findAll((Collection)Lists.newArrayList((Iterable)splitter.split((CharSequence)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : ""))), (Closure)filter), List.class);
    }

    private static Iterable<Integer> iterateRanges(Iterable<String> rangeIterable) {
        return Iterables.concat((Iterable)Optional.presentInstances((Iterable)Iterables.transform(rangeIterable, IPRange.parse())));
    }

    private static Iterable<String> iterateRangesAsString(Iterable<String> rangeIterable) {
        return Iterables.transform(NetworkConfigurations.iterateRanges(rangeIterable), PrivateAddresses.fromInteger());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != NetworkConfigurations.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NetworkConfigurations.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, NetworkConfigurations.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectField(NetworkConfigurations.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public static /* synthetic */ void access$0(NetworkConfigurations $that, Subnet net, List<String> ipRanges, String desc) {
        Reference desc2 = new Reference((Object)desc);
        NetworkConfigurations.validateIPsForSubnet(net, ipRanges, (String)desc2.get());
    }

    public static NetworkConfiguration explode(NetworkConfiguration networkConfiguration) {
        return NetworkConfigurations.explode(networkConfiguration, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    private static void validateIPsForSubnet(Subnet net, List<String> ipRanges) {
        NetworkConfigurations.validateIPsForSubnet(net, ipRanges, "");
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        Supplier supplier;
        Logger logger;
        long l;
        long l2;
        NetworkConfigurations.__$swapInit();
        __timeStamp__239_neverHappen1453166323748 = l2 = 0L;
        __timeStamp = l = 1453166323748L;
        NetworkConfigurations.logger = logger = Logger.getLogger(NetworkConfigurations.class);
        networkConfigurationFromEnvironmentSupplier = supplier = Suppliers.memoizeWithExpiration((Supplier)((Supplier)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.getMethodPointer(NetworkConfigurations.class, (String)"loadNetworkConfigurationFromEnvironment"), Supplier.class)), (long)5, (TimeUnit)TimeUnit.MINUTES);
        Boolean bl = Boolean.valueOf(System.getProperty("com.eucalyptus.network.config.validateNetworkConfiguration", "true"));
        validateConfiguration = DefaultTypeTransformation.booleanUnbox((Object)bl);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(NetworkConfigurations.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = NetworkConfigurations.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NetworkConfigurationPropertyChangeListener
    implements PropertyChangeListener<String>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkConfigurationPropertyChangeListener() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void fireChange(ConfigurableProperty property, String newValue) throws ConfigurablePropertyException {
            if (!Strings.isNullOrEmpty((String)newValue)) {
                try {
                    NetworkConfigurations.validate(NetworkConfigurations.explode(NetworkConfigurations.parse(newValue)));
                }
                catch (NetworkConfigurationException e) {
                    throw (Throwable)e;
                }
                catch (Exception e) {
                    throw (Throwable)new ConfigurablePropertyException(((Throwable)e).getMessage(), (Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class));
                }
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkConfigurationPropertyChangeListener.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NetworkConfigurationPropertyChangeListener.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, NetworkConfigurationPropertyChangeListener.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(NetworkConfigurationPropertyChangeListener.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(NetworkConfigurationPropertyChangeListener.class, NetworkConfigurations.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, NetworkConfigurationPropertyChangeListener.class, NetworkConfigurations.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(NetworkConfigurationPropertyChangeListener.class, NetworkConfigurations.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            NetworkConfigurationPropertyChangeListener.__$swapInit();
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkConfigurationPropertyChangeListener.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkConfigurationPropertyChangeListener.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NetworkConfigurationEventListener
    implements EventListener<ClockTick>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkConfigurationEventListener() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new NetworkConfigurationEventListener());
        }

        public void fireEvent(ClockTick event) {
            if (Hosts.isCoordinator() && !DefaultTypeTransformation.booleanUnbox((Object)Bootstrap.isShuttingDown()) && !DefaultTypeTransformation.booleanUnbox((Object)Databases.isVolatile())) {
                try {
                    Optional<NetworkConfiguration> configurationOptional = NetworkConfigurations.getNetworkConfigurationFromProperty();
                    if (!configurationOptional.isPresent()) {
                        boolean bl = false;
                        ScriptBytecodeAdapter.setProperty((Object)bl, null, EdgeNetworking.class, (String)"configured");
                        if (EdgeNetworking.isEnabled()) {
                            Optional<NetworkConfiguration> optional = NetworkConfigurations.getNetworkConfigurationFromEnvironment();
                            configurationOptional = optional;
                        }
                    } else {
                        boolean bl = true;
                        ScriptBytecodeAdapter.setProperty((Object)bl, null, EdgeNetworking.class, (String)"configured");
                    }
                    if (EdgeNetworking.isEnabled()) {
                        Iterables.all((Iterable)configurationOptional.or((Optional)ScriptBytecodeAdapter.castToType((Object)networkConfigurationFromEnvironmentSupplier.get(), Optional.class)).asSet(), (Predicate)Entities.asTransaction(ClusterConfiguration.class, (Predicate)((Predicate)ScriptBytecodeAdapter.asType((Object)new GeneratedClosure(this, this){
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public Object doCall(NetworkConfiguration networkConfiguration) {
                                InvokerHelper.invokeStaticMethod(NetworkConfigurations.class, (String)"process", (Object)new Object[]{networkConfiguration});
                                return true;
                            }

                            public Object call(NetworkConfiguration networkConfiguration) {
                                return this.doCall(networkConfiguration);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _NetworkConfigurationEventListener_fireEvent_closure1.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public static /* synthetic */ void __$swapInit() {
                            }

                            static {
                                _NetworkConfigurationEventListener_fireEvent_closure1.__$swapInit();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[]{};
                                return new CallSiteArray(_NetworkConfigurationEventListener_fireEvent_closure1.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _NetworkConfigurationEventListener_fireEvent_closure1.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }

                            static /* synthetic */ Class class$(String string) {
                                try {
                                    return Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                        }, Predicate.class))));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Error updating network configuration", (Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class));
                }
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkConfigurationEventListener.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NetworkConfigurationEventListener.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, NetworkConfigurationEventListener.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(NetworkConfigurationEventListener.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(NetworkConfigurationEventListener.class, NetworkConfigurations.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, NetworkConfigurationEventListener.class, NetworkConfigurations.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(NetworkConfigurationEventListener.class, NetworkConfigurations.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            NetworkConfigurationEventListener.__$swapInit();
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkConfigurationEventListener.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkConfigurationEventListener.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

