/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network.config;

import com.eucalyptus.network.NetworkMode;
import com.eucalyptus.network.config.ClusterValidator;
import com.eucalyptus.network.config.DomainValidator;
import com.eucalyptus.network.config.IPRangeValidator;
import com.eucalyptus.network.config.IPValidator;
import com.eucalyptus.network.config.MidonetValidator;
import com.eucalyptus.network.config.NetworkConfiguration;
import com.eucalyptus.network.config.RegexValidator;
import com.eucalyptus.network.config.Subnet;
import com.eucalyptus.network.config.SubnetValidator;
import com.eucalyptus.network.config.TypedValidator;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NetworkConfigurationValidator
extends TypedValidator<NetworkConfiguration> {
    public static final Pattern MAC_PREFIX_PATTERN;
    public static final Pattern MODE_PATTERN;
    private Errors errors;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1453166324971;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public NetworkConfigurationValidator(Errors errors) {
        void errors2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var3_3 = errors2;
        this.errors = var3_3;
    }

    public NetworkConfigurationValidator() {
        this(null);
    }

    @Override
    public void validate(NetworkConfiguration configuration) {
        this.require(ScriptBytecodeAdapter.getMethodPointer((Object)configuration, (String)"getPublicIps"));
        this.validate(ScriptBytecodeAdapter.getMethodPointer((Object)configuration, (String)"getMode"), new RegexValidator(this.errors, MODE_PATTERN, "Invalid mode \"{0}\": \"{1}\""));
        this.validate(ScriptBytecodeAdapter.getMethodPointer((Object)configuration, (String)"getInstanceDnsDomain"), new DomainValidator(this.errors));
        this.validateAll(ScriptBytecodeAdapter.getMethodPointer((Object)configuration, (String)"getInstanceDnsServers"), new IPValidator(this.errors));
        this.validate(ScriptBytecodeAdapter.getMethodPointer((Object)configuration, (String)"getMacPrefix"), new RegexValidator(this.errors, MAC_PREFIX_PATTERN, "Invalid MAC prefix \"{0}\": \"{1}\""));
        if (ScriptBytecodeAdapter.compareEqual((Object)configuration.getMode(), (Object)"VPCMIDO")) {
            this.require(ScriptBytecodeAdapter.getMethodPointer((Object)configuration, (String)"getMido"));
            if (DefaultTypeTransformation.booleanUnbox((Object)configuration.getMido())) {
                this.validate(ScriptBytecodeAdapter.getMethodPointer((Object)configuration, (String)"getMido"), new MidonetValidator(this.errors));
            }
        }
        this.validateAll(ScriptBytecodeAdapter.getMethodPointer((Object)configuration, (String)"getPublicIps"), new IPRangeValidator(this.errors));
        this.validateAll(ScriptBytecodeAdapter.getMethodPointer((Object)configuration, (String)"getPrivateIps"), new IPRangeValidator(this.errors));
        this.validateAll(ScriptBytecodeAdapter.getMethodPointer((Object)configuration, (String)"getSubnets"), new SubnetValidator(this.errors));
        List<Subnet> list = configuration.getSubnets();
        List list2 = list != null ? DefaultGroovyMethods.collect(list, (Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Subnet subnet) {
                String string = subnet.getName();
                return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : subnet.getSubnet();
            }

            public Object call(Subnet subnet) {
                return this.doCall(subnet);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _validate_closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_validate_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validate_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }) : null;
        this.validateAll(ScriptBytecodeAdapter.getMethodPointer((Object)configuration, (String)"getClusters"), new ClusterValidator(this.errors, DefaultTypeTransformation.booleanUnbox(list2) ? list2 : ScriptBytecodeAdapter.createList((Object[])new Object[0])));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != NetworkConfigurationValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"errors"), (Object)this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"errors"));
        }
        return _result;
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof NetworkConfigurationValidator;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
        }
        if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }
        if (!(other instanceof NetworkConfigurationValidator)) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
        }
        if (1 == 0) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
        }
        NetworkConfigurationValidator otherTyped = (NetworkConfigurationValidator)ScriptBytecodeAdapter.castToType((Object)other, NetworkConfigurationValidator.class);
        if (!DefaultGroovyMethods.is((Object)((TypedValidator)this).getErrors(), (Object)((TypedValidator)otherTyped).getErrors())) {
            if (DefaultGroovyMethods.is((Object)((TypedValidator)this).getErrors(), (Object)this) && !DefaultGroovyMethods.is((Object)((TypedValidator)otherTyped).getErrors(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)((TypedValidator)this).getErrors(), (Object)this) && DefaultGroovyMethods.is((Object)((TypedValidator)otherTyped).getErrors(), (Object)otherTyped)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (!(DefaultGroovyMethods.is((Object)((TypedValidator)this).getErrors(), (Object)this) && DefaultGroovyMethods.is((Object)((TypedValidator)otherTyped).getErrors(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)((TypedValidator)this).getErrors(), (Object)((TypedValidator)otherTyped).getErrors())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
    }

    @Override
    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("com.eucalyptus.network.config.NetworkConfigurationValidator(");
        Boolean bl = $toStringFirst;
        if (bl == null ? false : bl) {
            Boolean bl2;
            $toStringFirst = bl2 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"errors"), (Object)this)) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"errors")));
        }
        _result.append(")");
        return _result.toString();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NetworkConfigurationValidator.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, NetworkConfigurationValidator.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectField(NetworkConfigurationValidator.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        Pattern pattern;
        Pattern pattern2;
        long l;
        long l2;
        NetworkConfigurationValidator.__$swapInit();
        __timeStamp__239_neverHappen1453166324971 = l2 = 0L;
        __timeStamp = l = 1453166324971L;
        MAC_PREFIX_PATTERN = pattern2 = Pattern.compile("[0-9a-fA-F]{2}:[0-9a-fA-F]{2}");
        MODE_PATTERN = pattern = Pattern.compile(Joiner.on((String)"|").join(Iterables.transform(Arrays.asList((Object[])ScriptBytecodeAdapter.castToType((Object)NetworkMode.values(), Object[].class)), (Function)Functions.toStringFunction())));
    }

    @Override
    public Errors getErrors() {
        return this.errors;
    }

    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    public /* synthetic */ void super$2$validate(Object object) {
        super.validate(object);
    }

    public /* synthetic */ Object super$2$getProperty(String string) {
        return super.getProperty(string);
    }

    public /* synthetic */ String super$2$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$2$setProperty(String string, Object object) {
        super.setProperty(string, object);
    }

    public /* synthetic */ String super$2$toPropertyName(String string) {
        return super.toPropertyName(string);
    }

    @Override
    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$2$require(Closure closure) {
        super.require(closure);
    }

    public /* synthetic */ String super$2$toFieldName(String string) {
        return super.toFieldName(string);
    }

    @Override
    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ void super$2$validateAll(Closure closure, Validator validator) {
        super.validateAll(closure, validator);
    }

    public /* synthetic */ Object super$2$this$dist$invoke$1(String string, Object object) {
        return super.this$dist$invoke$1(string, object);
    }

    public /* synthetic */ void super$2$validate(Object object, String string, Validator validator) {
        super.validate(object, string, validator);
    }

    public /* synthetic */ String super$2$pathTranslate(String string, String string2) {
        return super.pathTranslate(string, string2);
    }

    public /* synthetic */ Class super$2$getTargetClass() {
        return super.getTargetClass();
    }

    public /* synthetic */ void super$2$validate(Closure closure, Validator validator) {
        super.validate(closure, validator);
    }

    @Override
    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ MetaClass super$2$getMetaClass() {
        return super.getMetaClass();
    }

    public /* synthetic */ String super$2$pathTranslate(String string) {
        return super.pathTranslate(string);
    }

    @Override
    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$2$setMetaClass(MetaClass metaClass) {
        super.setMetaClass(metaClass);
    }

    public /* synthetic */ Object super$2$this$dist$get$1(String string) {
        return super.this$dist$get$1(string);
    }

    public /* synthetic */ boolean super$2$canEqual(Object object) {
        return super.canEqual(object);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ boolean super$2$supports(Class clazz) {
        return super.supports(clazz);
    }

    public /* synthetic */ void super$2$validate(Object object, Errors errors) {
        super.validate(object, errors);
    }

    public /* synthetic */ void super$2$this$dist$set$1(String string, Object object) {
        super.this$dist$set$1(string, object);
    }

    public /* synthetic */ boolean super$2$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ Object super$2$invokeMethod(String string, Object object) {
        return super.invokeMethod(string, object);
    }

    public /* synthetic */ int super$2$hashCode() {
        return super.hashCode();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(NetworkConfigurationValidator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = NetworkConfigurationValidator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

