/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network;

import com.eucalyptus.cloud.util.PersistentReference;
import com.eucalyptus.cloud.util.Reference;
import com.eucalyptus.cloud.util.ResourceAllocationException;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.entities.AccountMetadata;
import com.eucalyptus.network.ExtantNetwork;
import com.eucalyptus.util.FullName;
import com.eucalyptus.vm.VmInstance;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_network_indices")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class PrivateNetworkIndex
extends PersistentReference<PrivateNetworkIndex, VmInstance> {
    @Column(name="metadata_network_index")
    private final Long index;
    @Column(name="metadata_network_index_bogus_id", unique=true)
    private final String bogusId;
    @ManyToOne
    @JoinColumn(name="metadata_network_index_extant_network_fk")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private ExtantNetwork extantNetwork;
    @NotFound(action=NotFoundAction.IGNORE)
    @OneToOne(mappedBy="networkIndex", fetch=FetchType.LAZY, optional=true)
    private VmInstance instance;

    private PrivateNetworkIndex() {
        super(null, null);
        this.index = null;
        this.extantNetwork = null;
        this.bogusId = null;
    }

    private PrivateNetworkIndex(ExtantNetwork network) {
        super(null, null);
        this.extantNetwork = network;
        this.setState(Reference.State.FREE);
        this.bogusId = null;
        this.index = null;
    }

    private PrivateNetworkIndex(ExtantNetwork network, Long index) {
        super(network.getOwner(), network.getTag() + ":" + index);
        this.extantNetwork = network;
        this.setState(Reference.State.FREE);
        this.bogusId = network.getTag() + ":" + index;
        this.index = index;
    }

    private PrivateNetworkIndex(Integer tag, Long index) {
        super(null, null);
        this.bogusId = tag + ":" + index;
        this.extantNetwork = null;
        this.index = index;
    }

    public static PrivateNetworkIndex named(Integer vlan, Long networkIndex) {
        return new PrivateNetworkIndex(vlan, networkIndex);
    }

    public static PrivateNetworkIndex named(ExtantNetwork exNet, Long index) {
        return new PrivateNetworkIndex(exNet.getTag(), index);
    }

    public static PrivateNetworkIndex inState(Reference.State state) {
        PrivateNetworkIndex privateNetworkIndex = new PrivateNetworkIndex();
        privateNetworkIndex.setState(state);
        privateNetworkIndex.setStateChangeStack(null);
        privateNetworkIndex.setLastState(null);
        return privateNetworkIndex;
    }

    public static PrivateNetworkIndex create(ExtantNetwork exNet, Long index) {
        return new PrivateNetworkIndex(exNet, index);
    }

    public Long getIndex() {
        return this.index;
    }

    public void setExtantNetwork(ExtantNetwork exNet) {
        this.extantNetwork = exNet;
    }

    public ExtantNetwork getExtantNetwork() {
        return this.extantNetwork;
    }

    @Override
    protected void setReference(VmInstance referer) {
        this.setInstance(referer);
        if (referer != null) {
            referer.setNetworkIndex(this);
        }
    }

    @Override
    protected VmInstance getReference() {
        return this.getInstance();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrivateNetworkIndex other = (PrivateNetworkIndex)obj;
        return !(this.index == null ? other.index != null : !this.index.equals(other.index));
    }

    public int compareTo(AccountMetadata that) {
        if (that instanceof PrivateNetworkIndex) {
            PrivateNetworkIndex o = (PrivateNetworkIndex)that;
            if (this.getExtantNetwork() != null) {
                return this.getExtantNetwork().getTag().equals(o.getExtantNetwork().getTag()) ? this.getIndex().compareTo(o.getIndex()) : this.getExtantNetwork().compareTo((AccountMetadata)o.getExtantNetwork());
            }
            return o.getExtantNetwork() == null ? 0 : -1;
        }
        return super.compareTo(that);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PrivateNetworkIndex:");
        if (this.extantNetwork != null) {
            builder.append(this.extantNetwork.getName()).append(" tag=").append(this.extantNetwork.getTag());
        }
        if (this.index != null) {
            builder.append(" idx=").append(this.index);
        }
        return builder.toString();
    }

    private VmInstance getInstance() {
        return this.instance;
    }

    private void setInstance(VmInstance instance) {
        this.instance = instance;
    }

    public String getPartition() {
        return Eucalyptus.INSTANCE.getName();
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"security-group", this.getExtantNetwork().getNetworkGroup().getDisplayName(), "tag", this.getExtantNetwork().getTag().toString(), "index", this.getIndex().toString()});
    }

    @Override
    public PrivateNetworkIndex release() throws ResourceAllocationException {
        this.extantNetwork = null;
        return (PrivateNetworkIndex)super.release();
    }
}

