/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network;

import com.eucalyptus.cloud.util.NotEnoughResourcesException;
import com.eucalyptus.cloud.util.Reference;
import com.eucalyptus.cloud.util.ResourceAllocationException;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.network.PrivateAddress;
import com.eucalyptus.network.PrivateAddressAllocator;
import com.eucalyptus.network.PrivateAddressPersistence;
import com.eucalyptus.network.PrivateAddresses;
import com.eucalyptus.util.HasNaturalId;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.vm.VmInstance;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrivateAddressAllocatorSupport
implements PrivateAddressAllocator,
GroovyObject {
    private final Logger logger;
    private final PrivateAddressPersistence persistence;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1453166323333;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    protected PrivateAddressAllocatorSupport(Logger logger, PrivateAddressPersistence privateAddressPersistence) {
        void persistence;
        void logger2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var4_4 = logger2;
        this.logger = var4_4;
        void var5_5 = persistence;
        this.persistence = var5_5;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String allocate(String scope, String tag, Iterable<Integer> addresses) throws NotEnoughResourcesException {
        void var2_2;
        Reference scope2 = new Reference((Object)scope);
        Reference tag2 = new Reference((Object)var2_2);
        String string = this.allocate(addresses, (Closure<String>)new GeneratedClosure(this, this, scope2, tag2){
            private /* synthetic */ Reference scope;
            private /* synthetic */ Reference tag;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                this.scope = reference2 = scope;
                this.tag = reference = tag;
            }

            public Object doCall(Integer address) {
                return ((PrivateAddressAllocatorSupport)ScriptBytecodeAdapter.castToType((Object)this.getProperty("thisObject"), PrivateAddressAllocatorSupport.class)).getDistinctPersistence().tryCreate((String)ScriptBytecodeAdapter.castToType((Object)this.scope.get(), String.class), (String)ScriptBytecodeAdapter.castToType((Object)this.tag.get(), String.class), PrivateAddresses.fromInteger((int)address)).transform(RestrictedTypes.toDisplayName()).orNull();
            }

            public Object call(Integer address) {
                return this.doCall(address);
            }

            public String getScope() {
                return (String)ScriptBytecodeAdapter.castToType((Object)this.scope.get(), String.class);
            }

            public String getTag() {
                return (String)ScriptBytecodeAdapter.castToType((Object)this.tag.get(), String.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _allocate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _allocate_closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_allocate_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _allocate_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : (String)ScriptBytecodeAdapter.castToType((Object)PrivateAddressAllocatorSupport.typedThrow(String.class, new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Object it) {
                return new NotEnoughResourcesException("Insufficient addresses");
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _allocate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _allocate_closure2.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_allocate_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _allocate_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), String.class);
    }

    @Override
    public void associate(String address, VmInstance instance) throws ResourceAllocationException {
        Reference instance2 = new Reference((Object)instance);
        this.getPersistence().withFirstMatch(PrivateAddress.named(((VmInstance)((Object)instance2.get())).getVpcId(), address), (String)null, new GeneratedClosure(this, this, instance2){
            private /* synthetic */ Reference instance;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.instance = reference = instance;
            }

            public Object doCall(PrivateAddress privateAddress) {
                return privateAddress.set((HasNaturalId)ScriptBytecodeAdapter.castToType((Object)this.instance.get(), HasNaturalId.class));
            }

            public Object call(PrivateAddress privateAddress) {
                return this.doCall(privateAddress);
            }

            public VmInstance getInstance() {
                return (VmInstance)((Object)ScriptBytecodeAdapter.castToType((Object)this.instance.get(), VmInstance.class));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _associate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _associate_closure3.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_associate_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _associate_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    @Override
    public String release(String scope, String address, String ownerId) {
        return (String)ScriptBytecodeAdapter.castToType((Object)this.getDistinctPersistence().withFirstMatch(PrivateAddress.named(scope, address), ownerId, new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(PrivateAddress privateAddress) {
                if (Reference.State.EXTANT.apply(privateAddress) || !DefaultTypeTransformation.booleanUnbox((Object)privateAddress.getAssignedPartition())) {
                    ((PrivateAddressAllocatorSupport)ScriptBytecodeAdapter.castToType((Object)this.getProperty("thisObject"), PrivateAddressAllocatorSupport.class)).getPersistence().teardown(privateAddress);
                } else {
                    privateAddress.set(null);
                    privateAddress.releasing();
                }
                return privateAddress.getTag();
            }

            public Object call(PrivateAddress privateAddress) {
                return this.doCall(privateAddress);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _release_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _release_closure4.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_release_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _release_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }).orNull(), String.class);
    }

    @Override
    public boolean verify(String scope, String address, String ownerId) {
        Reference ownerId2 = new Reference((Object)ownerId);
        return DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.with(this.getPersistence().withFirstMatch(PrivateAddress.named(scope, address), (String)ownerId2.get(), new GeneratedClosure(this, this, ownerId2){
            private /* synthetic */ Reference ownerId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.ownerId = reference = ownerId;
            }

            public Object doCall(PrivateAddress privateAddress) {
                return this.ownerId.get() != null && ScriptBytecodeAdapter.compareEqual((Object)this.ownerId.get(), (Object)privateAddress.getInstanceId());
            }

            public Object call(PrivateAddress privateAddress) {
                return this.doCall(privateAddress);
            }

            public String getOwnerId() {
                return (String)ScriptBytecodeAdapter.castToType((Object)this.ownerId.get(), String.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _verify_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _verify_closure5.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_verify_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _verify_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Object it) {
                return DefaultTypeTransformation.booleanUnbox((Object)this.getProperty("present")) ? (Boolean)ScriptBytecodeAdapter.castToType((Object)((Optional)this.getDelegate()).get(), Boolean.class) : Boolean.valueOf(false);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _verify_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _verify_closure6.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_verify_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _verify_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }));
    }

    @Override
    public void releasing(Iterable<String> activeAddresses, String partition) {
        Reference activeAddresses2 = new Reference(activeAddresses);
        this.getPersistence().withMatching(PrivateAddress.inState(Reference.State.RELEASING, partition), (Closure<?>)new GeneratedClosure(this, this, activeAddresses2){
            private /* synthetic */ Reference activeAddresses;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.activeAddresses = reference = activeAddresses;
            }

            public Object doCall(PrivateAddress privateAddress) {
                if (!Iterables.contains((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)this.activeAddresses.get(), Iterable.class)), (Object)privateAddress.getName()) && privateAddress.getScope() == null) {
                    ((Category)this.getProperty("logger")).debug((Object)new GStringImpl(new Object[]{privateAddress.getName()}, new String[]{"Releasing private IP address ", ""}));
                    ((PrivateAddressAllocatorSupport)ScriptBytecodeAdapter.castToType((Object)this.getProperty("thisObject"), PrivateAddressAllocatorSupport.class)).getPersistence().teardown(privateAddress);
                    return null;
                }
                return null;
            }

            public Object call(PrivateAddress privateAddress) {
                return this.doCall(privateAddress);
            }

            public Iterable getActiveAddresses() {
                return (Iterable)ScriptBytecodeAdapter.castToType((Object)this.activeAddresses.get(), Iterable.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _releasing_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _releasing_closure7.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_releasing_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _releasing_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        this.getPersistence().withMatching(PrivateAddress.inState(Reference.State.PENDING), (Closure<?>)new GeneratedClosure(this, this, activeAddresses2){
            private /* synthetic */ Reference activeAddresses;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.activeAddresses = reference = activeAddresses;
            }

            public Object doCall(PrivateAddress privateAddress) {
                if (!Iterables.contains((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)this.activeAddresses.get(), Iterable.class)), (Object)privateAddress.getName()) && PrivateAddressAllocatorSupport.isTimedOut(privateAddress.lastUpdateMillis(), NetworkGroups.NETWORK_INDEX_PENDING_TIMEOUT)) {
                    ((Category)this.getProperty("logger")).warn((Object)new GStringImpl(new Object[]{privateAddress.getName()}, new String[]{"Timed out pending private IP address ", ""}));
                    ((PrivateAddressAllocatorSupport)ScriptBytecodeAdapter.castToType((Object)this.getProperty("thisObject"), PrivateAddressAllocatorSupport.class)).getPersistence().teardown(privateAddress);
                    return null;
                }
                return null;
            }

            public Object call(PrivateAddress privateAddress) {
                return this.doCall(privateAddress);
            }

            public Iterable getActiveAddresses() {
                return (Iterable)ScriptBytecodeAdapter.castToType((Object)this.activeAddresses.get(), Iterable.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _releasing_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _releasing_closure8.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_releasing_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _releasing_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    protected abstract String allocate(Iterable<Integer> var1, Closure<String> var2);

    protected PrivateAddressPersistence getPersistence() {
        return this.persistence;
    }

    protected PrivateAddressPersistence getDistinctPersistence() {
        return this.persistence.distinct();
    }

    protected static final <T, E extends Exception> T typedThrow(Class<T> type, Closure<E> closure) throws Exception {
        throw (Throwable)closure.call();
    }

    private static boolean isTimedOut(Long timeSinceUpdateMillis, Integer timeoutMinutes) {
        return timeSinceUpdateMillis != null && timeoutMinutes != null && ScriptBytecodeAdapter.compareGreaterThan((Object)timeSinceUpdateMillis, (Object)TimeUnit.MINUTES.toMillis(DefaultTypeTransformation.longUnbox((Object)timeoutMinutes)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PrivateAddressAllocatorSupport.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PrivateAddressAllocatorSupport.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, PrivateAddressAllocatorSupport.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectField(PrivateAddressAllocatorSupport.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public static /* synthetic */ Logger pfaccess$0(PrivateAddressAllocatorSupport $that) {
        return $that.logger;
    }

    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        long l;
        long l2;
        PrivateAddressAllocatorSupport.__$swapInit();
        __timeStamp__239_neverHappen1453166323333 = l2 = 0L;
        __timeStamp = l = 1453166323333L;
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(PrivateAddressAllocatorSupport.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PrivateAddressAllocatorSupport.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

