/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.cloud.util.PersistentReference;
import com.eucalyptus.cloud.util.Reference;
import com.eucalyptus.cloud.util.ResourceAllocationException;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.RestrictedType;
import com.eucalyptus.vm.VmInstance;
import com.google.common.base.Objects;
import groovy.sql.Sql;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_private_addresses")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class PrivateAddress
extends PersistentReference<PrivateAddress, VmInstance>
implements RestrictedType {
    private static final long serialVersionUID = 1L;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="metadata_instance_fk")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private VmInstance instance;
    @Column(name="metadata_address_scope")
    private String scope;
    @Column(name="metadata_address_tag")
    private String tag;
    @Column(name="metadata_partition_name")
    private String assignedPartition;

    private PrivateAddress() {
        super(null, null);
    }

    private PrivateAddress(String address) {
        super(null, address);
    }

    public static PrivateAddress named(String scope, String address) {
        PrivateAddress privateAddress = new PrivateAddress(address);
        privateAddress.setUniqueName(PrivateAddress.buildUniqueName(scope, privateAddress.getDisplayName()));
        return privateAddress;
    }

    public static PrivateAddress tagged(String tag) {
        PrivateAddress privateAddress = new PrivateAddress();
        privateAddress.setTag(tag);
        return privateAddress;
    }

    public static PrivateAddress inState(Reference.State state) {
        return PrivateAddress.inState(state, null);
    }

    public static PrivateAddress inState(Reference.State state, String partition) {
        PrivateAddress privateAddress = new PrivateAddress();
        privateAddress.setState(state);
        privateAddress.setStateChangeStack(null);
        privateAddress.setLastState(null);
        privateAddress.setAssignedPartition(partition);
        return privateAddress;
    }

    public static PrivateAddress create(String scope, String tag, String address) {
        PrivateAddress privateAddress = new PrivateAddress(address);
        privateAddress.setOwner(Principals.nobodyFullName());
        privateAddress.setState(Reference.State.FREE);
        privateAddress.setScope(scope);
        privateAddress.setTag(tag);
        return privateAddress;
    }

    protected String createUniqueName() {
        return PrivateAddress.buildUniqueName(this.getScope(), this.getDisplayName());
    }

    private static String buildUniqueName(String scope, String name) {
        return scope == null ? name : scope + ":" + name;
    }

    @Override
    protected void setReference(VmInstance referrer) {
        this.setInstance(referrer);
        this.setAssignedPartition(referrer == null ? null : referrer.getPartition());
    }

    @Override
    protected VmInstance getReference() {
        return this.getInstance();
    }

    public void releasing() throws ResourceAllocationException {
        this.doSetReferer(null, Reference.State.EXTANT, Reference.State.RELEASING);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PrivateAddress:");
        if (this.getDisplayName() != null) {
            builder.append(this.getDisplayName());
        }
        return builder.toString();
    }

    @Nullable
    public String getInstanceId() {
        return (String)CloudMetadatas.toDisplayName().apply((Object)this.instance);
    }

    private VmInstance getInstance() {
        return this.instance;
    }

    private void setInstance(VmInstance instance) {
        this.instance = instance;
    }

    public String getScope() {
        return this.scope;
    }

    private void setScope(String scope) {
        this.scope = scope;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getAssignedPartition() {
        return this.assignedPartition;
    }

    private void setAssignedPartition(String assignedPartition) {
        this.assignedPartition = assignedPartition;
    }

    public String getPartition() {
        return Eucalyptus.INSTANCE.getName();
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"scope", (String)Objects.firstNonNull((Object)this.getScope(), (Object)"global"), "private-address", this.getDisplayName()});
    }

    @Override
    protected void ensureTransaction() {
    }

    @Upgrades.PreUpgrade(value=Eucalyptus.class, since=Upgrades.Version.v4_1_0)
    public static class PrivateAddressPreUpgrade41
    implements Callable<Boolean> {
        private static final Logger logger = Logger.getLogger(PrivateAddressPreUpgrade41.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try (Sql sql = null;){
                sql = Upgrades.DatabaseFilters.NEWVERSION.getConnection("eucalyptus_cloud");
                sql.execute("alter table metadata_private_addresses drop column if exists metadata_address");
                Boolean bl = true;
                return bl;
            }
        }
    }
}

