/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.network.NetworkPeer;
import com.eucalyptus.util.Pair;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_network_rule")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class NetworkRule
extends AbstractPersistent {
    public static final Pattern PROTOCOL_PATTERN = Pattern.compile("icmp|tcp|udp|[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]|-1");
    public static final int RULE_MIN_PORT = 0;
    public static final int RULE_MAX_PORT = 65535;
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_network_rule_egress", updatable=false)
    private Boolean egress;
    @Enumerated(value=EnumType.STRING)
    @Column(name="metadata_network_rule_protocol", updatable=false)
    private Protocol protocol;
    @Column(name="metadata_network_rule_protocol_number", updatable=false)
    private Integer protocolNumber;
    @Column(name="metadata_network_rule_low_port", updatable=false)
    private Integer lowPort;
    @Column(name="metadata_network_rule_high_port", updatable=false)
    private Integer highPort;
    @ElementCollection
    @CollectionTable(name="metadata_network_rule_ip_ranges")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<String> ipRanges = Sets.newHashSet();
    @ElementCollection
    @CollectionTable(name="metadata_network_group_rule_peers")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<NetworkPeer> networkPeers = Sets.newHashSet();

    protected NetworkRule() {
    }

    protected NetworkRule(Protocol protocol, Integer protocolNumber, Integer lowPort, Integer highPort, Collection<String> ipRanges, Collection<NetworkPeer> peers) {
        this.egress = false;
        this.protocol = protocol;
        this.protocolNumber = protocolNumber;
        if (Protocol.tcp.equals((Object)protocol) || Protocol.udp.equals((Object)protocol)) {
            if (lowPort < 0 || highPort < 0) {
                throw new IllegalArgumentException("Provided ports must be greater than 0: lowPort=" + lowPort + " highPort=" + highPort);
            }
            if (lowPort > 65535 || highPort > 65535) {
                throw new IllegalArgumentException("Provided ports must be less than 65535: lowPort=" + lowPort + " highPort=" + highPort);
            }
            if (lowPort > highPort) {
                throw new IllegalArgumentException("Provided lowPort is greater than highPort: lowPort=" + lowPort + " highPort=" + highPort);
            }
        }
        this.lowPort = lowPort;
        this.highPort = highPort;
        if (ipRanges != null) {
            this.ipRanges.addAll(ipRanges);
        }
        if (peers != null) {
            this.networkPeers.addAll(peers);
        }
    }

    public static NetworkRule create(Protocol protocol, Integer lowPort, Integer highPort, Collection<NetworkPeer> peers, Collection<String> ipRanges) {
        return NetworkRule.create(protocol, protocol.number, lowPort, highPort, peers, ipRanges);
    }

    public static NetworkRule create(Protocol protocol, Integer protocolNumber, Integer lowPort, Integer highPort, Collection<NetworkPeer> peers, Collection<String> ipRanges) {
        return new NetworkRule(protocol, protocolNumber, lowPort, highPort, ipRanges, peers);
    }

    public static NetworkRule createEgress(Protocol protocol, Integer protocolNumber, Integer lowPort, Integer highPort, Collection<NetworkPeer> peers, Collection<String> ipRanges) {
        NetworkRule rule = new NetworkRule(protocol, protocolNumber, lowPort, highPort, ipRanges, peers);
        rule.setEgress(true);
        return rule;
    }

    public static NetworkRule create(String protocolText, boolean vpc, Integer lowPort, Integer highPort, Collection<NetworkPeer> peers, Collection<String> ipRanges) {
        Pair<Optional<Protocol>, Integer> protocolPair = NetworkRule.parseProtocol(protocolText, vpc);
        return NetworkRule.create((Protocol)((Object)((Optional)protocolPair.getLeft()).orNull()), (Integer)protocolPair.getRight(), lowPort, highPort, peers, ipRanges);
    }

    protected static Pair<Optional<Protocol>, Integer> parseProtocol(String protocolText, boolean vpc) {
        Protocol protocol;
        block2: {
            protocol = null;
            try {
                protocol = Protocol.fromString(protocolText);
            }
            catch (IllegalArgumentException e) {
                if (vpc) break block2;
                throw e;
            }
        }
        Integer protocolNumber = protocol != null ? protocol.getNumber() : Integer.parseInt(protocolText);
        return Pair.lopair((Object)((Object)protocol), (Object)protocolNumber);
    }

    public static NetworkRule named() {
        return new NetworkRule();
    }

    public boolean isEgress() {
        return this.egress == null ? false : this.egress;
    }

    @Nullable
    public Boolean getEgress() {
        return this.egress;
    }

    public void setEgress(Boolean egress) {
        this.egress = egress;
    }

    @Nullable
    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @Nullable
    public Integer getProtocolNumber() {
        return this.protocolNumber;
    }

    public void setProtocolNumber(Integer protocolNumber) {
        this.protocolNumber = protocolNumber;
    }

    public String getDisplayProtocol() {
        return this.protocol != null ? this.protocol.name() : Objects.toString(this.protocolNumber, "-1");
    }

    @Nullable
    public Integer getLowPort() {
        return this.lowPort;
    }

    public void setLowPort(Integer lowPort) {
        this.lowPort = lowPort;
    }

    @Nullable
    public Integer getHighPort() {
        return this.highPort;
    }

    public void setHighPort(Integer highPort) {
        this.highPort = highPort;
    }

    public Set<String> getIpRanges() {
        return this.ipRanges;
    }

    public void setIpRanges(Set<String> ipRanges) {
        this.ipRanges = ipRanges;
    }

    public Set<NetworkPeer> getNetworkPeers() {
        return this.networkPeers;
    }

    public void setNetworkPeers(Set<NetworkPeer> networkPeers) {
        this.networkPeers = networkPeers;
    }

    public boolean isVpcOnly() {
        return this.getLowPort() == null || this.getHighPort() == null || this.getProtocol() == null;
    }

    public static Predicate<NetworkRule> egress() {
        return NetworkRulePredicates.EGRESS;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.highPort == null ? 0 : this.highPort.hashCode());
        result = 31 * result + (this.ipRanges == null ? 0 : this.ipRanges.hashCode());
        result = 31 * result + (this.lowPort == null ? 0 : this.lowPort.hashCode());
        result = 31 * result + (this.networkPeers == null ? 0 : this.networkPeers.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.protocolNumber == null ? 0 : this.protocolNumber.hashCode());
        result = 31 * result + (this.egress == null || this.egress == false ? 0 : this.egress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        NetworkRule other = (NetworkRule)((Object)obj);
        if (this.highPort == null ? other.highPort != null : !this.highPort.equals(other.highPort)) {
            return false;
        }
        if (this.ipRanges == null ? other.ipRanges != null : !this.ipRanges.equals(other.ipRanges)) {
            return false;
        }
        if (this.lowPort == null ? other.lowPort != null : !this.lowPort.equals(other.lowPort)) {
            return false;
        }
        if (this.networkPeers == null ? other.networkPeers != null : !this.networkPeers.equals(other.networkPeers)) {
            return false;
        }
        if (this.protocol != other.protocol) {
            return false;
        }
        if (this.protocolNumber == null ? other.protocolNumber != null : !this.protocolNumber.equals(other.protocolNumber)) {
            return false;
        }
        return this.isEgress() == other.isEgress();
    }

    public String toString() {
        return String.format("NetworkRule:%s:%d:%d:ipRanges=%s:networkPeers=%s:", new Object[]{this.protocol, this.lowPort, this.highPort, this.ipRanges, this.networkPeers});
    }

    @PrePersist
    @PreUpdate
    protected void onUpdate() {
        if (this.protocol != null) {
            this.protocolNumber = this.protocol.getNumber();
        }
    }

    private static enum NetworkRulePredicates implements Predicate<NetworkRule>
    {
        EGRESS{

            public boolean apply(@Nullable NetworkRule networkRule) {
                return networkRule != null && networkRule.isEgress();
            }
        };

    }

    public static enum Protocol {
        icmp(1){

            @Override
            public Integer extractLowPort(NetworkRule rule) {
                return null;
            }

            @Override
            public Integer extractHighPort(NetworkRule rule) {
                return null;
            }

            @Override
            public Integer extractIcmpType(NetworkRule rule) {
                return rule.getLowPort();
            }

            @Override
            public Integer extractIcmpCode(NetworkRule rule) {
                return rule.getHighPort();
            }
        }
        ,
        tcp(6),
        udp(17);

        private final int number;

        private Protocol(int number) {
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }

        public static Protocol fromString(String value) {
            try {
                return Protocol.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                Integer protocolNumber = Ints.tryParse((String)value);
                if (protocolNumber != null) {
                    for (Protocol protocol : Protocol.values()) {
                        if (protocolNumber != protocol.number) continue;
                        return protocol;
                    }
                }
                throw e;
            }
        }

        public Integer extractLowPort(NetworkRule rule) {
            return rule.getLowPort();
        }

        public Integer extractHighPort(NetworkRule rule) {
            return rule.getHighPort();
        }

        public Integer extractIcmpType(NetworkRule rule) {
            return null;
        }

        public Integer extractIcmpCode(NetworkRule rule) {
            return null;
        }
    }
}

