/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network;

import com.eucalyptus.network.NetworkRule;
import java.io.Serializable;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import org.hibernate.annotations.Parent;

@Embeddable
public class NetworkPeer
implements Serializable {
    @Transient
    private static final long serialVersionUID = 1L;
    @Parent
    private NetworkRule networkRule;
    @Column(name="network_rule_peer_network_user_query_key")
    private String otherAccountId;
    @Column(name="network_rule_peer_network_user_group")
    private String groupName;
    @Column(name="network_rule_peer_network_group_id")
    private String groupId;

    NetworkPeer() {
    }

    NetworkPeer(String userQueryKey, String groupName, String groupId) {
        this(null, userQueryKey, groupName, groupId);
    }

    NetworkPeer(@Nullable NetworkRule networkRule, String userQueryKey, String groupName, String groupId) {
        this.networkRule = networkRule;
        this.otherAccountId = userQueryKey;
        this.groupName = groupName;
        this.groupId = groupId;
    }

    public static NetworkPeer create(String userQueryKey, String groupName, String groupId) {
        return new NetworkPeer(userQueryKey, groupName, groupId);
    }

    public String getUserQueryKey() {
        return this.otherAccountId;
    }

    public void setUserQueryKey(String userQueryKey) {
        this.otherAccountId = userQueryKey;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Nullable
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        NetworkPeer that = (NetworkPeer)o;
        if (this.groupId != null && that.groupId != null) {
            return this.groupId.equals(that.groupId);
        }
        if (!this.groupName.equals(that.groupName)) {
            return false;
        }
        return this.otherAccountId.equals(that.otherAccountId);
    }

    public int hashCode() {
        int result;
        if (this.groupId != null) {
            result = this.groupId.hashCode();
        } else {
            result = this.otherAccountId.hashCode();
            result = 31 * result + this.groupName.hashCode();
        }
        return result;
    }

    public String toString() {
        return String.format("NetworkPeer:userQueryKey=%s:groupName=%s:groupId=%s", this.otherAccountId, this.groupName, this.groupId);
    }

    private NetworkRule getNetworkRule() {
        return this.networkRule;
    }

    private void setNetworkRule(NetworkRule networkRule) {
        this.networkRule = networkRule;
    }
}

