/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.cluster.NICluster;
import com.eucalyptus.cluster.NIClusters;
import com.eucalyptus.cluster.NIConfiguration;
import com.eucalyptus.cluster.NIDhcpOptionSet;
import com.eucalyptus.cluster.NIInstance;
import com.eucalyptus.cluster.NIInternetGateway;
import com.eucalyptus.cluster.NIMidonet;
import com.eucalyptus.cluster.NINetworkAcl;
import com.eucalyptus.cluster.NINetworkAclEntry;
import com.eucalyptus.cluster.NINetworkInterface;
import com.eucalyptus.cluster.NINode;
import com.eucalyptus.cluster.NINodes;
import com.eucalyptus.cluster.NIProperty;
import com.eucalyptus.cluster.NIRoute;
import com.eucalyptus.cluster.NIRouteTable;
import com.eucalyptus.cluster.NISecurityGroup;
import com.eucalyptus.cluster.NISecurityGroupIpPermission;
import com.eucalyptus.cluster.NISubnet;
import com.eucalyptus.cluster.NISubnets;
import com.eucalyptus.cluster.NIVpc;
import com.eucalyptus.cluster.NIVpcSubnet;
import com.eucalyptus.cluster.NetworkInfo;
import com.eucalyptus.cluster.callback.BroadcastNetworkInfoCallback;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.vpc.DhcpOption;
import com.eucalyptus.compute.vpc.DhcpOptionSet;
import com.eucalyptus.compute.vpc.InternetGateway;
import com.eucalyptus.compute.vpc.NetworkAcl;
import com.eucalyptus.compute.vpc.NetworkAclEntry;
import com.eucalyptus.compute.vpc.NetworkAcls;
import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.compute.vpc.NetworkInterfaceAssociation;
import com.eucalyptus.compute.vpc.NetworkInterfaceAttachment;
import com.eucalyptus.compute.vpc.Route;
import com.eucalyptus.compute.vpc.RouteTable;
import com.eucalyptus.compute.vpc.RouteTableAssociation;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.EntityCache;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.network.EdgeNetworking;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.network.NetworkInfoBroadcaster;
import com.eucalyptus.network.NetworkPeer;
import com.eucalyptus.network.NetworkRule;
import com.eucalyptus.network.PublicAddresses;
import com.eucalyptus.network.config.Cluster;
import com.eucalyptus.network.config.Midonet;
import com.eucalyptus.network.config.NetworkConfiguration;
import com.eucalyptus.network.config.NetworkConfigurations;
import com.eucalyptus.network.config.Subnet;
import com.eucalyptus.system.BaseDirectory;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.UnconditionalCallback;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmNetworkConfig;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import edu.ucsb.eucalyptus.cloud.NodeInfo;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Immutable;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ReflectionMethodInvoker;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.util.HashCodeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkInfoBroadcaster
implements GroovyObject {
    private static final Logger logger;
    private static final AtomicLong lastBroadcastTime;
    private static final ConcurrentMap<String, Long> activeBroadcastMap;
    private static final EntityCache<VmInstance, VmInstanceNetworkView> instanceCache;
    private static final EntityCache<NetworkGroup, NetworkGroupNetworkView> securityGroupCache;
    private static final EntityCache<Vpc, VpcNetworkView> vpcCache;
    private static final EntityCache<com.eucalyptus.compute.vpc.Subnet, SubnetNetworkView> subnetCache;
    private static final EntityCache<DhcpOptionSet, DhcpOptionSetNetworkView> dhcpOptionsCache;
    private static final EntityCache<NetworkAcl, NetworkAclNetworkView> networkAclCache;
    private static final EntityCache<RouteTable, RouteTableNetworkView> routeTableCache;
    private static final EntityCache<InternetGateway, InternetGatewayNetworkView> internetGatewayCache;
    private static final EntityCache<NetworkInterface, NetworkInterfaceNetworkView> networkInterfaceCache;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final /* synthetic */ long $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1453166314227;
    private static /* synthetic */ SoftReference $callSiteArray;

    public NetworkInfoBroadcaster() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private static NetworkInfoSource cacheSource() {
        return new NetworkInfoSource(NetworkInfoBroadcaster.class){
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Class clazz;
                this.this$0 = clazz = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public Iterable<VmInstanceNetworkView> getInstances() {
                return instanceCache.get();
            }

            @Override
            public Iterable<NetworkGroupNetworkView> getSecurityGroups() {
                return securityGroupCache.get();
            }

            @Override
            public Iterable<VpcNetworkView> getVpcs() {
                return vpcCache.get();
            }

            @Override
            public Iterable<SubnetNetworkView> getSubnets() {
                return subnetCache.get();
            }

            @Override
            public Iterable<DhcpOptionSetNetworkView> getDhcpOptionSets() {
                return dhcpOptionsCache.get();
            }

            @Override
            public Iterable<NetworkAclNetworkView> getNetworkAcls() {
                return networkAclCache.get();
            }

            @Override
            public Iterable<RouteTableNetworkView> getRouteTables() {
                return routeTableCache.get();
            }

            @Override
            public Iterable<InternetGatewayNetworkView> getInternetGateways() {
                return internetGatewayCache.get();
            }

            @Override
            public Iterable<NetworkInterfaceNetworkView> getNetworkInterfaces() {
                return networkInterfaceCache.get();
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(1.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, 1.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                return ScriptBytecodeAdapter.getGroovyObjectField(1.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setField((Object)object, 1.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getField(1.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                1.__$swapInit();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
    }

    public static void requestNetworkInfoBroadcast() {
        Reference requestedTime = new Reference((Object)System.currentTimeMillis());
        Reference broadcastRequest = new Reference((Object)Closure.IDENTITY);
        GeneratedClosure generatedClosure = new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class, requestedTime, broadcastRequest){
            private /* synthetic */ Reference requestedTime;
            private /* synthetic */ Reference broadcastRequest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                this.requestedTime = reference2 = requestedTime;
                this.broadcastRequest = reference = broadcastRequest;
            }

            public Object doCall(Object it) {
                long currentTime = System.currentTimeMillis();
                long lastBroadcast = lastBroadcastTime.get();
                if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)this.requestedTime.get(), (Object)lastBroadcast) && lastBroadcast + TimeUnit.SECONDS.toMillis(DefaultTypeTransformation.longUnbox((Object)NetworkGroups.MIN_BROADCAST_INTERVAL)) < currentTime) {
                    if (lastBroadcastTime.compareAndSet(lastBroadcast, currentTime)) {
                        NetworkInfoBroadcaster.broadcastNetworkInfo();
                        Object var6_4 = null;
                        try {
                            return var6_4;
                        }
                        catch (Exception e) {
                            logger.error((Object)"Error broadcasting network information", (Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class));
                            Object var8_6 = null;
                            return var8_6;
                        }
                    }
                    NetworkInfoBroadcaster.broadcastTask((Callable)ScriptBytecodeAdapter.castToType((Object)this.broadcastRequest.get(), Callable.class));
                    return null;
                }
                if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)this.requestedTime.get(), (Object)lastBroadcastTime.get())) {
                    DefaultGroovyStaticMethods.sleep(null, (long)100);
                    NetworkInfoBroadcaster.broadcastTask((Callable)ScriptBytecodeAdapter.castToType((Object)this.broadcastRequest.get(), Callable.class));
                    return null;
                }
                return null;
            }

            public Long getRequestedTime() {
                return (Long)ScriptBytecodeAdapter.castToType((Object)this.requestedTime.get(), Long.class);
            }

            public Callable getBroadcastRequest() {
                return (Callable)ScriptBytecodeAdapter.castToType((Object)this.broadcastRequest.get(), Callable.class);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _requestNetworkInfoBroadcast_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _requestNetworkInfoBroadcast_closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_requestNetworkInfoBroadcast_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _requestNetworkInfoBroadcast_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
        broadcastRequest.set((Object)generatedClosure);
        NetworkInfoBroadcaster.broadcastTask((Callable)((Closure)broadcastRequest.get()));
    }

    private static void broadcastTask(Callable task) {
        Threads.enqueue(Eucalyptus.class, NetworkInfoBroadcaster.class, (Integer)5, (Callable)task);
    }

    public static void broadcastNetworkInfo() {
        Optional<NetworkConfiguration> networkConfiguration = NetworkConfigurations.getNetworkConfiguration();
        List clusters = Clusters.getInstance().listValues();
        NetworkInfo info = NetworkInfoBroadcaster.buildNetworkConfiguration(networkConfiguration, NetworkInfoBroadcaster.cacheSource(), (Supplier<List<com.eucalyptus.cluster.Cluster>>)Suppliers.ofInstance((Object)clusters), (Supplier<String>)((Supplier)ScriptBytecodeAdapter.asType((Object)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Object it) {
                return Topology.lookup(Eucalyptus.class, (Partition[])new Partition[0]).getInetAddress().getHostAddress();
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _broadcastNetworkInfo_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _broadcastNetworkInfo_closure2.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_broadcastNetworkInfo_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _broadcastNetworkInfo_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }, Supplier.class)), (Function<List<String>, List<String>>)((Function)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.getMethodPointer(NetworkConfigurations.class, (String)"loadSystemNameservers"), Function.class)));
        JAXBContext jc = JAXBContext.newInstance((String)"com.eucalyptus.cluster");
        StringWriter writer = new StringWriter(8192);
        jc.createMarshaller().marshal((Object)info, (Writer)writer);
        String networkInfo = writer.toString();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)new GStringImpl(new Object[]{networkInfo}, new String[]{"Broadcasting network information:\n", ""}));
        }
        File newView = BaseDirectory.RUN.getChildFile(new String[]{"global_network_info.xml.temp"});
        if (newView.exists() && !newView.delete()) {
            logger.warn((Object)new GStringImpl(new Object[]{newView.getAbsolutePath()}, new String[]{"Error deleting stale network view ", ""}));
        }
        Files.write((CharSequence)networkInfo, (File)newView, (Charset)Charsets.UTF_8);
        java.nio.file.Files.move(newView.toPath(), BaseDirectory.RUN.getChildFile(new String[]{"global_network_info.xml"}).toPath(), StandardCopyOption.REPLACE_EXISTING);
        Reference callback = new Reference((Object)new BroadcastNetworkInfoCallback(networkInfo));
        DefaultGroovyMethods.each((Object)clusters, (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class, callback){
            private /* synthetic */ Reference callback;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.callback = reference = callback;
            }

            public Object doCall(com.eucalyptus.cluster.Cluster cluster) {
                Reference cluster2 = new Reference((Object)cluster);
                Reference broadcastTime = new Reference((Object)System.currentTimeMillis());
                if (activeBroadcastMap.putIfAbsent(((com.eucalyptus.cluster.Cluster)cluster2.get()).getPartition(), (Long)broadcastTime.get()) == null) {
                    try {
                        AsyncRequests.newRequest(((BroadcastNetworkInfoCallback)((Object)this.callback.get())).newInstance()).then((UnconditionalCallback)new GroovyObject(NetworkInfoBroadcaster.class, cluster2, broadcastTime){
                            public /* synthetic */ Reference broadcastTime;
                            public /* synthetic */ Reference cluster;
                            public /* synthetic */ Class this$0;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private transient /* synthetic */ MetaClass metaClass;
                            private static /* synthetic */ SoftReference $callSiteArray;
                            {
                                MetaClass metaClass;
                                Reference reference;
                                Reference reference2;
                                Class clazz;
                                this.this$0 = clazz = p0;
                                this.broadcastTime = reference2 = p2;
                                this.cluster = reference = p1;
                                this.metaClass = metaClass = this.$getStaticMetaClass();
                            }

                            public void fire() {
                                activeBroadcastMap.remove(((com.eucalyptus.cluster.Cluster)this.cluster.get()).getPartition(), this.broadcastTime.get());
                            }

                            public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
                                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(2.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                            }

                            public /* synthetic */ void this$dist$set$2(String name, Object value) {
                                Object object = value;
                                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, 2.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
                            }

                            public /* synthetic */ Object this$dist$get$2(String name) {
                                return ScriptBytecodeAdapter.getGroovyObjectField(2.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
                            }

                            public /* synthetic */ Object methodMissing(String name, Object args) {
                                return ScriptBytecodeAdapter.invokeMethodN(2.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                            }

                            public /* synthetic */ void propertyMissing(String name, Object val) {
                                Object object = val;
                                ScriptBytecodeAdapter.setField((Object)object, 2.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
                            }

                            public /* synthetic */ Object propertyMissing(String name) {
                                return ScriptBytecodeAdapter.getField(2.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != 2.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MetaClass getMetaClass() {
                                MetaClass metaClass = this.metaClass;
                                if (metaClass != null) {
                                    return metaClass;
                                }
                                this.metaClass = this.$getStaticMetaClass();
                                return this.metaClass;
                            }

                            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                                this.metaClass = metaClass;
                            }

                            public /* synthetic */ Object invokeMethod(String string, Object object) {
                                return this.getMetaClass().invokeMethod((Object)this, string, object);
                            }

                            public /* synthetic */ Object getProperty(String string) {
                                return this.getMetaClass().getProperty((Object)this, string);
                            }

                            public /* synthetic */ void setProperty(String string, Object object) {
                                this.getMetaClass().setProperty((Object)this, string, object);
                            }

                            public static /* synthetic */ void __$swapInit() {
                            }

                            static {
                                2.__$swapInit();
                            }

                            public /* synthetic */ void super$1$wait() {
                                super.wait();
                            }

                            public /* synthetic */ String super$1$toString() {
                                return super.toString();
                            }

                            public /* synthetic */ void super$1$wait(long l, int n) {
                                super.wait(l, n);
                            }

                            public /* synthetic */ void super$1$notify() {
                                super.notify();
                            }

                            public /* synthetic */ Class super$1$getClass() {
                                return super.getClass();
                            }

                            public /* synthetic */ void super$1$notifyAll() {
                                super.notifyAll();
                            }

                            public /* synthetic */ void super$1$finalize() {
                                super.finalize();
                            }

                            public /* synthetic */ void super$1$wait(long l) {
                                super.wait(l);
                            }

                            public /* synthetic */ void super$2$fire(Object object) {
                                super.fire(object);
                            }

                            public /* synthetic */ boolean super$1$equals(Object object) {
                                return super.equals(object);
                            }

                            public /* synthetic */ Object super$1$clone() {
                                return super.clone();
                            }

                            public /* synthetic */ int super$1$hashCode() {
                                return super.hashCode();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[]{};
                                return new CallSiteArray(2.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = 2.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }

                            static /* synthetic */ Class class$(String string) {
                                try {
                                    return Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                        }).dispatch((ServiceConfiguration)((com.eucalyptus.cluster.Cluster)cluster2.get()).getConfiguration());
                    }
                    catch (Exception e) {
                        activeBroadcastMap.remove(((com.eucalyptus.cluster.Cluster)cluster2.get()).getPartition(), (Long)broadcastTime.get());
                        logger.error((Object)((String)ScriptBytecodeAdapter.asType((Object)new GStringImpl(new Object[]{((com.eucalyptus.cluster.Cluster)cluster2.get()).getPartition(), ((com.eucalyptus.cluster.Cluster)cluster2.get()).getName()}, new String[]{"Error broadcasting network information to cluster ", " (", ")"}), String.class)), (Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class));
                    }
                } else {
                    logger.warn((Object)new GStringImpl(new Object[]{((com.eucalyptus.cluster.Cluster)cluster2.get()).getPartition()}, new String[]{"Skipping network information broadcast for active partition ", ""}));
                }
                return Void.TYPE;
            }

            public Object call(com.eucalyptus.cluster.Cluster cluster) {
                Reference cluster2 = new Reference((Object)cluster);
                return this.doCall((com.eucalyptus.cluster.Cluster)cluster2.get());
            }

            public BroadcastNetworkInfoCallback getCallback() {
                return (BroadcastNetworkInfoCallback)((Object)ScriptBytecodeAdapter.castToType((Object)this.callback.get(), BroadcastNetworkInfoCallback.class));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _broadcastNetworkInfo_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _broadcastNetworkInfo_closure3.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_broadcastNetworkInfo_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _broadcastNetworkInfo_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    static NetworkInfo buildNetworkConfiguration(Optional<NetworkConfiguration> configuration, NetworkInfoSource networkInfoSource, Supplier<List<com.eucalyptus.cluster.Cluster>> clusterSupplier, Supplier<String> clcHostSupplier, Function<List<String>, List<String>> systemNameserverLookup) {
        List clusters = (List)ScriptBytecodeAdapter.castToType((Object)clusterSupplier.get(), List.class);
        Reference networkConfiguration = new Reference(configuration.isPresent() ? Optional.of((Object)NetworkConfigurations.explode((NetworkConfiguration)ScriptBytecodeAdapter.castToType((Object)configuration.get(), NetworkConfiguration.class), DefaultGroovyMethods.collect((Collection)clusters, (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(com.eucalyptus.cluster.Cluster cluster) {
                return cluster.getPartition();
            }

            public Object call(com.eucalyptus.cluster.Cluster cluster) {
                return this.doCall(cluster);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure4.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }))) : configuration);
        Reference info = new Reference((Object)((NetworkInfo)ScriptBytecodeAdapter.castToType((Object)((Optional)networkConfiguration.get()).transform(TypeMappers.lookup(NetworkConfiguration.class, NetworkInfo.class)).or((Object)new NetworkInfo()), NetworkInfo.class)));
        Object object = ((Optional)networkConfiguration.get()).orNull();
        Reference vpcmido = new Reference((Object)ScriptBytecodeAdapter.compareEqual((Object)"VPCMIDO", object != null ? ((NetworkConfiguration)object).getMode() : null));
        NIConfiguration nIConfiguration = ((NetworkInfo)info.get()).getConfiguration();
        NIClusters nIClusters = new NIClusters();
        nIClusters.setName("clusters");
        nIClusters.setClusters((List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.findResults((Iterable)clusters, (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class, networkConfiguration, vpcmido){
            private /* synthetic */ Reference networkConfiguration;
            private /* synthetic */ Reference vpcmido;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                this.networkConfiguration = reference2 = networkConfiguration;
                this.vpcmido = reference = vpcmido;
            }

            public Object doCall(com.eucalyptus.cluster.Cluster cluster) {
                NICluster nICluster;
                Reference cluster2 = new Reference((Object)cluster);
                Object object = ((Optional)this.networkConfiguration.get()).orNull();
                List<Cluster> list = object != null ? ((NetworkConfiguration)object).getClusters() : null;
                Cluster configCluster = (Cluster)ScriptBytecodeAdapter.castToType(list != null ? DefaultGroovyMethods.find(list, (Closure)new GeneratedClosure((Object)this, this.getThisObject(), cluster2){
                    private /* synthetic */ Reference cluster;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        this.cluster = reference = cluster;
                    }

                    public Object doCall(Cluster configCluster) {
                        return ScriptBytecodeAdapter.compareEqual((Object)((com.eucalyptus.cluster.Cluster)this.cluster.get()).getPartition(), (Object)configCluster.getName());
                    }

                    public Object call(Cluster configCluster) {
                        return this.doCall(configCluster);
                    }

                    public com.eucalyptus.cluster.Cluster getCluster() {
                        return (com.eucalyptus.cluster.Cluster)ScriptBytecodeAdapter.castToType((Object)this.cluster.get(), com.eucalyptus.cluster.Cluster.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure5_closure22.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure5_closure22.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure5_closure22.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure5_closure22.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }) : null, Cluster.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)configCluster) && (DefaultTypeTransformation.booleanUnbox((Object)this.vpcmido.get()) || DefaultTypeTransformation.booleanUnbox((Object)configCluster.getSubnet()))) {
                    List list2;
                    NISubnet nISubnet;
                    NICluster nICluster2 = new NICluster();
                    nICluster2.setName(configCluster.getName());
                    Object object2 = this.vpcmido.get();
                    if (object2 == null ? false : (Boolean)object2) {
                        NISubnet nISubnet2 = new NISubnet();
                        nISubnet2.setName("172.31.0.0");
                        Object[] objectArray = new Object[3];
                        NIProperty nIProperty = new NIProperty();
                        nIProperty.setName("subnet");
                        nIProperty.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{"172.31.0.0"}));
                        objectArray[0] = nIProperty;
                        NIProperty nIProperty2 = new NIProperty();
                        nIProperty2.setName("netmask");
                        nIProperty2.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{"255.255.0.0"}));
                        objectArray[1] = nIProperty2;
                        NIProperty nIProperty3 = new NIProperty();
                        nIProperty3.setName("gateway");
                        nIProperty3.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{"172.31.0.1"}));
                        objectArray[2] = nIProperty3;
                        nISubnet2.setProperties(ScriptBytecodeAdapter.createList((Object[])objectArray));
                        nISubnet = nISubnet2;
                    } else {
                        NISubnet nISubnet3 = new NISubnet();
                        nISubnet3.setName(configCluster.getSubnet().getSubnet());
                        Object[] objectArray = new Object[3];
                        NIProperty nIProperty = new NIProperty();
                        nIProperty.setName("subnet");
                        nIProperty.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{configCluster.getSubnet().getSubnet()}));
                        objectArray[0] = nIProperty;
                        NIProperty nIProperty4 = new NIProperty();
                        nIProperty4.setName("netmask");
                        nIProperty4.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{configCluster.getSubnet().getNetmask()}));
                        objectArray[1] = nIProperty4;
                        NIProperty nIProperty5 = new NIProperty();
                        nIProperty5.setName("gateway");
                        nIProperty5.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{configCluster.getSubnet().getGateway()}));
                        objectArray[2] = nIProperty5;
                        nISubnet3.setProperties(ScriptBytecodeAdapter.createList((Object[])objectArray));
                        nISubnet = nISubnet3;
                    }
                    nICluster2.setSubnet(nISubnet);
                    Object[] objectArray = new Object[2];
                    NIProperty nIProperty = new NIProperty();
                    nIProperty.setName("enabledCCIp");
                    nIProperty.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{InetAddress.getByName(((com.eucalyptus.cluster.Cluster)cluster2.get()).getHostName()).getHostAddress()}));
                    objectArray[0] = nIProperty;
                    NIProperty nIProperty6 = new NIProperty();
                    nIProperty6.setName("macPrefix");
                    Object[] objectArray2 = new Object[1];
                    String string = configCluster.getMacPrefix();
                    objectArray2[0] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : VmInstances.MAC_PREFIX;
                    nIProperty6.setValues(ScriptBytecodeAdapter.createList((Object[])objectArray2));
                    objectArray[1] = nIProperty6;
                    List list3 = ScriptBytecodeAdapter.createList((Object[])objectArray);
                    Object object3 = this.vpcmido.get();
                    if (object3 == null ? false : (Boolean)object3) {
                        Object[] objectArray3 = new Object[1];
                        NIProperty nIProperty7 = new NIProperty();
                        nIProperty7.setName("privateIps");
                        nIProperty7.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{"172.31.0.5"}));
                        objectArray3[0] = nIProperty7;
                        list2 = ScriptBytecodeAdapter.createList((Object[])objectArray3);
                    } else {
                        Object[] objectArray4 = new Object[1];
                        NIProperty nIProperty8 = new NIProperty();
                        nIProperty8.setName("privateIps");
                        nIProperty8.setValues(configCluster.getPrivateIps());
                        objectArray4[0] = nIProperty8;
                        list2 = ScriptBytecodeAdapter.createList((Object[])objectArray4);
                    }
                    nICluster2.setProperties((List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.plus((Collection)list3, (Collection)list2), List.class));
                    NINodes nINodes = new NINodes();
                    nINodes.setName("nodes");
                    nINodes.setNodes(DefaultGroovyMethods.collect(((com.eucalyptus.cluster.Cluster)cluster2.get()).getNodeMap().values(), (Closure)new GeneratedClosure((Object)this, this.getThisObject()){
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public Object doCall(NodeInfo nodeInfo) {
                            NINode nINode = new NINode();
                            nINode.setName(nodeInfo.getName());
                            return nINode;
                        }

                        public Object call(NodeInfo nodeInfo) {
                            return this.doCall(nodeInfo);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure5_closure23.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public static /* synthetic */ void __$swapInit() {
                        }

                        static {
                            _buildNetworkConfiguration_closure5_closure23.__$swapInit();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[]{};
                            return new CallSiteArray(_buildNetworkConfiguration_closure5_closure23.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _buildNetworkConfiguration_closure5_closure23.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }

                        static /* synthetic */ Class class$(String string) {
                            try {
                                return Class.forName(string);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                    }));
                    nICluster2.setNodes(nINodes);
                    nICluster = nICluster2;
                } else {
                    nICluster = null;
                }
                return nICluster;
            }

            public Object call(com.eucalyptus.cluster.Cluster cluster) {
                Reference cluster2 = new Reference((Object)cluster);
                return this.doCall((com.eucalyptus.cluster.Cluster)cluster2.get());
            }

            public Optional getNetworkConfiguration() {
                return (Optional)ScriptBytecodeAdapter.castToType((Object)this.networkConfiguration.get(), Optional.class);
            }

            public Boolean getVpcmido() {
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.vpcmido.get(), Boolean.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure5.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), List.class));
        nIConfiguration.setClusters(nIClusters);
        Object object2 = ((Optional)networkConfiguration.get()).orNull();
        List list = object2 != null ? ((NetworkConfiguration)object2).getInstanceDnsServers() : null;
        Reference dnsServers = new Reference(DefaultTypeTransformation.booleanUnbox(list) ? list : (List)ScriptBytecodeAdapter.castToType((Object)systemNameserverLookup.apply((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"127.0.0.1"})), List.class));
        List<NIProperty> list2 = ((NetworkInfo)info.get()).getConfiguration().getProperties();
        Object[] objectArray = new Object[3];
        NIProperty nIProperty = new NIProperty();
        nIProperty.setName("enabledCLCIp");
        nIProperty.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{clcHostSupplier.get()}));
        objectArray[0] = nIProperty;
        NIProperty nIProperty2 = new NIProperty();
        nIProperty2.setName("instanceDNSDomain");
        Object[] objectArray2 = new Object[1];
        Object object3 = ((Optional)networkConfiguration.get()).orNull();
        String string = object3 != null ? ((NetworkConfiguration)object3).getInstanceDnsDomain() : null;
        objectArray2[0] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : com.eucalyptus.util.Strings.trimPrefix((String)".", (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{VmInstances.INSTANCE_SUBDOMAIN}, new String[]{"", ".internal"}), String.class)));
        nIProperty2.setValues(ScriptBytecodeAdapter.createList((Object[])objectArray2));
        objectArray[1] = nIProperty2;
        NIProperty nIProperty3 = new NIProperty();
        nIProperty3.setName("instanceDNSServers");
        nIProperty3.setValues((List)dnsServers.get());
        objectArray[2] = nIProperty3;
        list2.addAll(ScriptBytecodeAdapter.createList((Object[])objectArray));
        Iterable instances = Iterables.filter(networkInfoSource.getInstances(), (Predicate)((Predicate)ScriptBytecodeAdapter.asType((Object)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(VmInstanceNetworkView instance) {
                return !VmInstance.VmStateSet.TORNDOWN.contains(instance.getState()) && !DefaultTypeTransformation.booleanUnbox((Object)instance.getOmit());
            }

            public Object call(VmInstanceNetworkView instance) {
                return this.doCall(instance);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure6.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }, Predicate.class)));
        DefaultGroovyMethods.each((Map)((Multimap)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.inject((Object)instances, (Object)HashMultimap.create(), (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Multimap<List<String>, String> map, VmInstanceNetworkView instance) {
                map.put((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{instance.getPartition(), instance.getNode()}), (Object)instance.getInstanceId());
                return map;
            }

            public Object call(Multimap<List<String>, String> map, VmInstanceNetworkView instance) {
                return this.doCall(map, instance);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure7.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), Multimap.class)).asMap(), (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class, info){
            private /* synthetic */ Reference info;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.info = reference = info;
            }

            public Object doCall(Map.Entry<List<String>, Collection<String>> entry) {
                Reference entry2 = new Reference(entry);
                Object object = DefaultGroovyMethods.find(((NetworkInfo)this.info.get()).getConfiguration().getClusters().getClusters(), (Closure)new GeneratedClosure((Object)this, this.getThisObject(), entry2){
                    private /* synthetic */ Reference entry;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        this.entry = reference = entry;
                    }

                    public Object doCall(NICluster cluster) {
                        return ScriptBytecodeAdapter.compareEqual((Object)cluster.getName(), (Object)DefaultGroovyMethods.getAt((List)((List)ScriptBytecodeAdapter.castToType(((Map.Entry)this.entry.get()).getKey(), List.class)), (int)0));
                    }

                    public Object call(NICluster cluster) {
                        return this.doCall(cluster);
                    }

                    public Map.Entry getEntry() {
                        return (Map.Entry)ScriptBytecodeAdapter.castToType((Object)this.entry.get(), Map.Entry.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure8_closure24.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure8_closure24.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure8_closure24.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure8_closure24.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
                return object != null ? DefaultGroovyMethods.with((Object)object, (Closure)new GeneratedClosure((Object)this, this.getThisObject(), entry2){
                    private /* synthetic */ Reference entry;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        this.entry = reference = entry;
                    }

                    public Object doCall(Object it) {
                        NINode node = (NINode)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find(((NINodes)this.getProperty("nodes")).getNodes(), (Closure)new GeneratedClosure((Object)((Object)this), this.getThisObject(), this.entry){
                            private /* synthetic */ Reference entry;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;
                            {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.entry = reference = entry;
                            }

                            public Object doCall(NINode node) {
                                return ScriptBytecodeAdapter.compareEqual((Object)node.getName(), (Object)DefaultGroovyMethods.getAt((List)((List)ScriptBytecodeAdapter.castToType(((Map.Entry)this.entry.get()).getKey(), List.class)), (int)1));
                            }

                            public Object call(NINode node) {
                                return this.doCall(node);
                            }

                            public Map.Entry getEntry() {
                                return (Map.Entry)ScriptBytecodeAdapter.castToType((Object)this.entry.get(), Map.Entry.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure8_closure25_closure26.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public static /* synthetic */ void __$swapInit() {
                            }

                            static {
                                _buildNetworkConfiguration_closure8_closure25_closure26.__$swapInit();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[]{};
                                return new CallSiteArray(_buildNetworkConfiguration_closure8_closure25_closure26.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _buildNetworkConfiguration_closure8_closure25_closure26.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }

                            static /* synthetic */ Class class$(String string) {
                                try {
                                    return Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                        }), NINode.class);
                        if (DefaultTypeTransformation.booleanUnbox((Object)node)) {
                            node.setInstanceIds((List)ScriptBytecodeAdapter.castToType(DefaultTypeTransformation.booleanUnbox(((Map.Entry)this.entry.get()).getValue()) ? (List)ScriptBytecodeAdapter.asType(((Map.Entry)this.entry.get()).getValue(), List.class) : null, List.class));
                            return null;
                        }
                        return null;
                    }

                    public Map.Entry getEntry() {
                        return (Map.Entry)ScriptBytecodeAdapter.castToType((Object)this.entry.get(), Map.Entry.class);
                    }

                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure8_closure25.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure8_closure25.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure8_closure25.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure8_closure25.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }) : null;
            }

            public Object call(Map.Entry<List<String>, Collection<String>> entry) {
                Reference entry2 = new Reference(entry);
                return this.doCall((Map.Entry)entry2.get());
            }

            public NetworkInfo getInfo() {
                return (NetworkInfo)ScriptBytecodeAdapter.castToType((Object)this.info.get(), NetworkInfo.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure8.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        Iterable<VpcNetworkView> vpcs = networkInfoSource.getVpcs();
        Reference subnets = new Reference(networkInfoSource.getSubnets());
        Reference networkAcls = new Reference(networkInfoSource.getNetworkAcls());
        Reference routeTables = new Reference(networkInfoSource.getRouteTables());
        Iterable<InternetGatewayNetworkView> internetGateways = networkInfoSource.getInternetGateways();
        Reference vpcIdToInternetGatewayIds = new Reference((Object)((ArrayListMultimap)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.inject(internetGateways, (Object)ArrayListMultimap.create(), (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(ListMultimap<String, String> map, InternetGatewayNetworkView internetGateway) {
                if (DefaultTypeTransformation.booleanUnbox((Object)internetGateway.getVpcId())) {
                    map.put((Object)internetGateway.getVpcId(), (Object)internetGateway.getInternetGatewayId());
                }
                return map;
            }

            public Object call(ListMultimap<String, String> map, InternetGatewayNetworkView internetGateway) {
                return this.doCall(map, internetGateway);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure9.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), ArrayListMultimap.class)).asMap());
        ((NetworkInfo)info.get()).getVpcs().addAll(DefaultGroovyMethods.collect(vpcs, (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class, networkAcls, routeTables, vpcIdToInternetGatewayIds, subnets){
            private /* synthetic */ Reference networkAcls;
            private /* synthetic */ Reference routeTables;
            private /* synthetic */ Reference vpcIdToInternetGatewayIds;
            private /* synthetic */ Reference subnets;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.networkAcls = reference4 = networkAcls;
                this.routeTables = reference3 = routeTables;
                this.vpcIdToInternetGatewayIds = reference2 = vpcIdToInternetGatewayIds;
                this.subnets = reference = subnets;
            }

            public Object doCall(VpcNetworkView vpc) {
                Reference vpc2 = new Reference((Object)vpc);
                Object v = ((Map)this.vpcIdToInternetGatewayIds.get()).get(((VpcNetworkView)vpc2.get()).getVpcId());
                List list = (List)ScriptBytecodeAdapter.castToType(v, List.class);
                return new NIVpc(((VpcNetworkView)vpc2.get()).getVpcId(), ((VpcNetworkView)vpc2.get()).getOwnerAccountNumber(), ((VpcNetworkView)vpc2.get()).getCidr(), ((VpcNetworkView)vpc2.get()).getDhcpOptionSetId(), DefaultGroovyMethods.collect((Collection)DefaultGroovyMethods.findAll((Object)this.subnets.get(), (Closure)new GeneratedClosure((Object)this, this.getThisObject(), vpc2){
                    private /* synthetic */ Reference vpc;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        this.vpc = reference = vpc;
                    }

                    public Object doCall(SubnetNetworkView subnet) {
                        return ScriptBytecodeAdapter.compareEqual((Object)subnet.getVpcId(), (Object)((VpcNetworkView)this.vpc.get()).getVpcId());
                    }

                    public Object call(SubnetNetworkView subnet) {
                        return this.doCall(subnet);
                    }

                    public VpcNetworkView getVpc() {
                        return (VpcNetworkView)ScriptBytecodeAdapter.castToType((Object)this.vpc.get(), VpcNetworkView.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure10_closure27.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure10_closure27.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure10_closure27.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure10_closure27.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }), (Closure)new GeneratedClosure((Object)this, this.getThisObject(), this.routeTables, vpc2){
                    private /* synthetic */ Reference routeTables;
                    private /* synthetic */ Reference vpc;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        Reference reference2;
                        this.routeTables = reference2 = routeTables;
                        this.vpc = reference = vpc;
                    }

                    public Object doCall(SubnetNetworkView subnet) {
                        Reference subnet2 = new Reference((Object)subnet);
                        NIVpcSubnet nIVpcSubnet = new NIVpcSubnet();
                        nIVpcSubnet.setName(((SubnetNetworkView)subnet2.get()).getSubnetId());
                        nIVpcSubnet.setOwnerId(((SubnetNetworkView)subnet2.get()).getOwnerAccountNumber());
                        nIVpcSubnet.setCidr(((SubnetNetworkView)subnet2.get()).getCidr());
                        nIVpcSubnet.setCluster(((SubnetNetworkView)subnet2.get()).getAvailabilityZone());
                        nIVpcSubnet.setNetworkAcl(((SubnetNetworkView)subnet2.get()).getNetworkAcl());
                        nIVpcSubnet.setRouteTable(((RouteTableNetworkView)Iterables.tryFind((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)this.routeTables.get(), Iterable.class)), (Predicate)((Predicate)ScriptBytecodeAdapter.asType((Object)new GeneratedClosure((Object)((Object)this), this.getThisObject(), subnet2){
                            private /* synthetic */ Reference subnet;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;
                            {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.subnet = reference = subnet;
                            }

                            public Object doCall(RouteTableNetworkView routeTable) {
                                return routeTable.getSubnetIds().contains(((SubnetNetworkView)this.subnet.get()).getSubnetId());
                            }

                            public Object call(RouteTableNetworkView routeTable) {
                                return this.doCall(routeTable);
                            }

                            public SubnetNetworkView getSubnet() {
                                return (SubnetNetworkView)ScriptBytecodeAdapter.castToType((Object)this.subnet.get(), SubnetNetworkView.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure10_closure28_closure33.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public static /* synthetic */ void __$swapInit() {
                            }

                            static {
                                _buildNetworkConfiguration_closure10_closure28_closure33.__$swapInit();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[]{};
                                return new CallSiteArray(_buildNetworkConfiguration_closure10_closure28_closure33.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _buildNetworkConfiguration_closure10_closure28_closure33.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }

                            static /* synthetic */ Class class$(String string) {
                                try {
                                    return Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                        }, Predicate.class))).or(Iterables.find((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)this.routeTables.get(), Iterable.class)), (Predicate)((Predicate)ScriptBytecodeAdapter.asType((Object)new GeneratedClosure((Object)((Object)this), this.getThisObject(), this.vpc){
                            private /* synthetic */ Reference vpc;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;
                            {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.vpc = reference = vpc;
                            }

                            public Object doCall(RouteTableNetworkView routeTable) {
                                return routeTable.isMain() && ScriptBytecodeAdapter.compareEqual((Object)routeTable.getVpcId(), (Object)((VpcNetworkView)this.vpc.get()).getVpcId());
                            }

                            public Object call(RouteTableNetworkView routeTable) {
                                return this.doCall(routeTable);
                            }

                            public VpcNetworkView getVpc() {
                                return (VpcNetworkView)ScriptBytecodeAdapter.castToType((Object)this.vpc.get(), VpcNetworkView.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure10_closure28_closure34.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public static /* synthetic */ void __$swapInit() {
                            }

                            static {
                                _buildNetworkConfiguration_closure10_closure28_closure34.__$swapInit();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[]{};
                                return new CallSiteArray(_buildNetworkConfiguration_closure10_closure28_closure34.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _buildNetworkConfiguration_closure10_closure28_closure34.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }

                            static /* synthetic */ Class class$(String string) {
                                try {
                                    return Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                        }, Predicate.class))))).getRouteTableId());
                        return nIVpcSubnet;
                    }

                    public Object call(SubnetNetworkView subnet) {
                        Reference subnet2 = new Reference((Object)subnet);
                        return this.doCall((SubnetNetworkView)subnet2.get());
                    }

                    public Iterable getRouteTables() {
                        return (Iterable)ScriptBytecodeAdapter.castToType((Object)this.routeTables.get(), Iterable.class);
                    }

                    public VpcNetworkView getVpc() {
                        return (VpcNetworkView)ScriptBytecodeAdapter.castToType((Object)this.vpc.get(), VpcNetworkView.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure10_closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure10_closure28.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure10_closure28.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure10_closure28.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }), DefaultGroovyMethods.collect((Collection)DefaultGroovyMethods.findAll((Object)this.networkAcls.get(), (Closure)new GeneratedClosure((Object)this, this.getThisObject(), vpc2){
                    private /* synthetic */ Reference vpc;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        this.vpc = reference = vpc;
                    }

                    public Object doCall(NetworkAclNetworkView networkAcl) {
                        return ScriptBytecodeAdapter.compareEqual((Object)networkAcl.getVpcId(), (Object)((VpcNetworkView)this.vpc.get()).getVpcId());
                    }

                    public Object call(NetworkAclNetworkView networkAcl) {
                        return this.doCall(networkAcl);
                    }

                    public VpcNetworkView getVpc() {
                        return (VpcNetworkView)ScriptBytecodeAdapter.castToType((Object)this.vpc.get(), VpcNetworkView.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure10_closure29.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure10_closure29.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure10_closure29.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure10_closure29.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }), (Closure)new GeneratedClosure((Object)this, this.getThisObject()){
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public Object doCall(NetworkAclNetworkView networkAcl) {
                        NINetworkAcl nINetworkAcl = new NINetworkAcl();
                        nINetworkAcl.setName(networkAcl.getNetworkAclId());
                        nINetworkAcl.setOwnerId(networkAcl.getOwnerAccountNumber());
                        nINetworkAcl.setIngressEntries(Lists.transform(networkAcl.getIngressRules(), (Function)TypeMappers.lookup(NetworkAclEntryNetworkView.class, NINetworkAclEntry.class)));
                        nINetworkAcl.setEgressEntries(Lists.transform(networkAcl.getEgressRules(), (Function)TypeMappers.lookup(NetworkAclEntryNetworkView.class, NINetworkAclEntry.class)));
                        return nINetworkAcl;
                    }

                    public Object call(NetworkAclNetworkView networkAcl) {
                        return this.doCall(networkAcl);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure10_closure30.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure10_closure30.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure10_closure30.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure10_closure30.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }), DefaultGroovyMethods.collect((Collection)DefaultGroovyMethods.findAll((Object)this.routeTables.get(), (Closure)new GeneratedClosure((Object)this, this.getThisObject(), vpc2){
                    private /* synthetic */ Reference vpc;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        this.vpc = reference = vpc;
                    }

                    public Object doCall(RouteTableNetworkView routeTable) {
                        return ScriptBytecodeAdapter.compareEqual((Object)routeTable.getVpcId(), (Object)((VpcNetworkView)this.vpc.get()).getVpcId());
                    }

                    public Object call(RouteTableNetworkView routeTable) {
                        return this.doCall(routeTable);
                    }

                    public VpcNetworkView getVpc() {
                        return (VpcNetworkView)ScriptBytecodeAdapter.castToType((Object)this.vpc.get(), VpcNetworkView.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure10_closure31.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure10_closure31.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure10_closure31.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure10_closure31.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }), (Closure)new GeneratedClosure((Object)this, this.getThisObject()){
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public Object doCall(RouteTableNetworkView routeTable) {
                        NIRouteTable nIRouteTable = new NIRouteTable();
                        nIRouteTable.setName(routeTable.getRouteTableId());
                        nIRouteTable.setOwnerId(routeTable.getOwnerAccountNumber());
                        nIRouteTable.setRoutes(Lists.transform(routeTable.getRoutes(), (Function)TypeMappers.lookup(RouteNetworkView.class, NIRoute.class)));
                        return nIRouteTable;
                    }

                    public Object call(RouteTableNetworkView routeTable) {
                        return this.doCall(routeTable);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure10_closure32.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure10_closure32.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure10_closure32.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure10_closure32.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }), DefaultTypeTransformation.booleanUnbox(v) ? list : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            }

            public Object call(VpcNetworkView vpc) {
                Reference vpc2 = new Reference((Object)vpc);
                return this.doCall((VpcNetworkView)vpc2.get());
            }

            public Iterable getNetworkAcls() {
                return (Iterable)ScriptBytecodeAdapter.castToType((Object)this.networkAcls.get(), Iterable.class);
            }

            public Iterable getRouteTables() {
                return (Iterable)ScriptBytecodeAdapter.castToType((Object)this.routeTables.get(), Iterable.class);
            }

            public Map getVpcIdToInternetGatewayIds() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.vpcIdToInternetGatewayIds.get(), Map.class);
            }

            public Iterable getSubnets() {
                return (Iterable)ScriptBytecodeAdapter.castToType((Object)this.subnets.get(), Iterable.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure10.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }));
        Iterable<NetworkInterfaceNetworkView> networkInterfaces = networkInfoSource.getNetworkInterfaces();
        Reference instanceIdToNetworkInterfaces = new Reference((Object)((ArrayListMultimap)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.inject(networkInterfaces, (Object)ArrayListMultimap.create(), (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(ListMultimap<String, NetworkInterfaceNetworkView> map, NetworkInterfaceNetworkView networkInterface) {
                if (DefaultTypeTransformation.booleanUnbox((Object)networkInterface.getInstanceId())) {
                    map.put((Object)networkInterface.getInstanceId(), (Object)networkInterface);
                }
                return map;
            }

            public Object call(ListMultimap<String, NetworkInterfaceNetworkView> map, NetworkInterfaceNetworkView networkInterface) {
                return this.doCall(map, networkInterface);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure11.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), ArrayListMultimap.class)).asMap());
        ((NetworkInfo)info.get()).getInstances().addAll(DefaultGroovyMethods.collect((Object)instances, (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class, instanceIdToNetworkInterfaces){
            private /* synthetic */ Reference instanceIdToNetworkInterfaces;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.instanceIdToNetworkInterfaces = reference = instanceIdToNetworkInterfaces;
            }

            public Object doCall(VmInstanceNetworkView instance) {
                NIInstance nIInstance = new NIInstance();
                nIInstance.setName(instance.getInstanceId());
                nIInstance.setOwnerId(instance.getOwnerAccountNumber());
                nIInstance.setVpc(instance.getVpcId());
                nIInstance.setSubnet(instance.getSubnetId());
                nIInstance.setMacAddress(Strings.emptyToNull((String)instance.getMacAddress()));
                nIInstance.setPublicIp((String)ScriptBytecodeAdapter.castToType((Object)(ScriptBytecodeAdapter.compareEqual((Object)VmNetworkConfig.DEFAULT_IP, (Object)instance.getPublicAddress()) || DefaultTypeTransformation.booleanUnbox((Object)InvokerHelper.invokeStaticMethod(PublicAddresses.class, (String)"isDirty", (Object)new Object[]{instance.getPublicAddress()})) ? null : instance.getPublicAddress()), String.class));
                nIInstance.setPrivateIp(instance.getPrivateAddress());
                nIInstance.setSecurityGroups(instance.getSecurityGroupIds());
                Object v = ((Map)this.instanceIdToNetworkInterfaces.get()).get(instance.getInstanceId());
                List list = v != null ? DefaultGroovyMethods.collect((Collection)((Collection)ScriptBytecodeAdapter.castToType(v, Collection.class)), (Closure)new GeneratedClosure((Object)this, this.getThisObject()){
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public Object doCall(NetworkInterfaceNetworkView networkInterface) {
                        NINetworkInterface nINetworkInterface = new NINetworkInterface();
                        nINetworkInterface.setName(networkInterface.getNetworkInterfaceId());
                        nINetworkInterface.setOwnerId(networkInterface.getOwnerAccountNumber());
                        nINetworkInterface.setDeviceIndex(networkInterface.getDeviceIndex());
                        nINetworkInterface.setMacAddress(networkInterface.getMacAddress());
                        nINetworkInterface.setPrivateIp(networkInterface.getPrivateIp());
                        nINetworkInterface.setPublicIp(networkInterface.getPublicIp());
                        nINetworkInterface.setSourceDestCheck(networkInterface.getSourceDestCheck());
                        nINetworkInterface.setSecurityGroups(networkInterface.getSecurityGroupIds());
                        return nINetworkInterface;
                    }

                    public Object call(NetworkInterfaceNetworkView networkInterface) {
                        return this.doCall(networkInterface);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure12_closure35.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure12_closure35.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure12_closure35.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure12_closure35.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }) : null;
                nIInstance.setNetworkInterfaces(DefaultTypeTransformation.booleanUnbox(list) ? list : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                return nIInstance;
            }

            public Object call(VmInstanceNetworkView instance) {
                return this.doCall(instance);
            }

            public Map getInstanceIdToNetworkInterfaces() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.instanceIdToNetworkInterfaces.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure12.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }));
        Iterable<DhcpOptionSetNetworkView> dhcpOptionSets = networkInfoSource.getDhcpOptionSets();
        ((NetworkInfo)info.get()).getDhcpOptionSets().addAll(DefaultGroovyMethods.collect(dhcpOptionSets, (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class, dnsServers){
            private /* synthetic */ Reference dnsServers;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.dnsServers = reference = dnsServers;
            }

            public Object doCall(DhcpOptionSetNetworkView dhcpOptionSet) {
                NIDhcpOptionSet nIDhcpOptionSet = new NIDhcpOptionSet();
                nIDhcpOptionSet.setName(dhcpOptionSet.getDhcpOptionSetId());
                nIDhcpOptionSet.setOwnerId(dhcpOptionSet.getOwnerAccountNumber());
                nIDhcpOptionSet.setProperties(DefaultGroovyMethods.collect(dhcpOptionSet.getOptions(), (Closure)new GeneratedClosure((Object)this, this.getThisObject(), this.dnsServers){
                    private /* synthetic */ Reference dnsServers;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        this.dnsServers = reference = dnsServers;
                    }

                    public Object doCall(DhcpOptionNetworkView option) {
                        List<String> list;
                        if (ScriptBytecodeAdapter.compareEqual((Object)"domain-name-servers", (Object)option.getKey()) && ScriptBytecodeAdapter.compareEqual((Object)"AmazonProvidedDNS", (list = option.getValues()) != null ? DefaultGroovyMethods.getAt(list, (int)0) : null)) {
                            return new NIProperty("domain-name-servers", (List)ScriptBytecodeAdapter.castToType((Object)this.dnsServers.get(), List.class));
                        }
                        return new NIProperty(option.getKey(), option.getValues());
                    }

                    public Object call(DhcpOptionNetworkView option) {
                        return this.doCall(option);
                    }

                    public List getDnsServers() {
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.dnsServers.get(), List.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure13_closure36.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure13_closure36.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure13_closure36.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure13_closure36.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }));
                return nIDhcpOptionSet;
            }

            public Object call(DhcpOptionSetNetworkView dhcpOptionSet) {
                return this.doCall(dhcpOptionSet);
            }

            public List getDnsServers() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.dnsServers.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure13.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }));
        ((NetworkInfo)info.get()).getInternetGateways().addAll(DefaultGroovyMethods.collect(internetGateways, (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(InternetGatewayNetworkView internetGateway) {
                NIInternetGateway nIInternetGateway = new NIInternetGateway();
                nIInternetGateway.setName(internetGateway.getInternetGatewayId());
                nIInternetGateway.setOwnerId(internetGateway.getOwnerAccountNumber());
                return nIInternetGateway;
            }

            public Object call(InternetGatewayNetworkView internetGateway) {
                return this.doCall(internetGateway);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure14.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }));
        Reference activeSecurityGroups = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.inject((Object)instances, (Object)Sets.newHashSetWithExpectedSize((int)1000), (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Set<String> groups, VmInstanceNetworkView instance) {
                groups.addAll(instance.getSecurityGroupIds());
                return groups;
            }

            public Object call(Set<String> groups, VmInstanceNetworkView instance) {
                return this.doCall(groups, instance);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure15.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), Set.class)));
        Iterable<NetworkGroupNetworkView> groups = networkInfoSource.getSecurityGroups();
        ((NetworkInfo)info.get()).getSecurityGroups().addAll(DefaultGroovyMethods.collect((Collection)DefaultGroovyMethods.findAll(groups, (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class, activeSecurityGroups){
            private /* synthetic */ Reference activeSecurityGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.activeSecurityGroups = reference = activeSecurityGroups;
            }

            public Object doCall(NetworkGroupNetworkView group) {
                return ((Set)this.activeSecurityGroups.get()).contains(group.getGroupId());
            }

            public Object call(NetworkGroupNetworkView group) {
                return this.doCall(group);
            }

            public Set getActiveSecurityGroups() {
                return (Set)ScriptBytecodeAdapter.castToType((Object)this.activeSecurityGroups.get(), Set.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure16.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(NetworkGroupNetworkView group) {
                NISecurityGroup nISecurityGroup = new NISecurityGroup();
                nISecurityGroup.setName(group.getGroupId());
                nISecurityGroup.setOwnerId(group.getOwnerAccountNumber());
                nISecurityGroup.setRules(group.getRules());
                nISecurityGroup.setIngressRules(DefaultGroovyMethods.collect(group.getIngressPermissions(), (Closure)new GeneratedClosure((Object)this, this.getThisObject()){
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public Object doCall(IPPermissionNetworkView ipPermission) {
                        return new NISecurityGroupIpPermission(ipPermission.getProtocol(), ipPermission.getFromPort(), ipPermission.getToPort(), ipPermission.getIcmpType(), ipPermission.getIcmpCode(), ipPermission.getGroupId(), ipPermission.getGroupOwnerAccountNumber(), ipPermission.getCidr());
                    }

                    public Object call(IPPermissionNetworkView ipPermission) {
                        return this.doCall(ipPermission);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure17_closure37.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure17_closure37.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure17_closure37.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure17_closure37.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }));
                nISecurityGroup.setEgressRules(DefaultGroovyMethods.collect(group.getEgressPermissions(), (Closure)new GeneratedClosure((Object)this, this.getThisObject()){
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public Object doCall(IPPermissionNetworkView ipPermission) {
                        return new NISecurityGroupIpPermission(ipPermission.getProtocol(), ipPermission.getFromPort(), ipPermission.getToPort(), ipPermission.getIcmpType(), ipPermission.getIcmpCode(), ipPermission.getGroupId(), ipPermission.getGroupOwnerAccountNumber(), ipPermission.getCidr());
                    }

                    public Object call(IPPermissionNetworkView ipPermission) {
                        return this.doCall(ipPermission);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure17_closure38.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _buildNetworkConfiguration_closure17_closure38.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_buildNetworkConfiguration_closure17_closure38.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _buildNetworkConfiguration_closure17_closure38.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }));
                return nISecurityGroup;
            }

            public Object call(NetworkGroupNetworkView group) {
                return this.doCall(group);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildNetworkConfiguration_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _buildNetworkConfiguration_closure17.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_buildNetworkConfiguration_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildNetworkConfiguration_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)new GStringImpl(new Object[]{Iterables.size((Iterable)instances), Iterables.size(groups)}, new String[]{"Constructed network information for ", " instance(s), ", " security group(s)"}));
        }
        return (NetworkInfo)info.get();
    }

    private static Set<String> explodeRules(NetworkRule networkRule) {
        LinkedHashSet rules = Sets.newLinkedHashSet();
        if (!networkRule.isVpcOnly()) {
            Reference rule = new Reference((Object)String.format("-P %s -%s %d%s%d ", new Object[]{networkRule.getProtocol(), ScriptBytecodeAdapter.compareEqual((Object)((Object)NetworkRule.Protocol.icmp), (Object)((Object)networkRule.getProtocol())) ? "t" : "p", networkRule.getLowPort(), ScriptBytecodeAdapter.compareEqual((Object)((Object)NetworkRule.Protocol.icmp), (Object)((Object)networkRule.getProtocol())) ? ":" : "-", networkRule.getHighPort()}));
            rules.addAll(DefaultGroovyMethods.collect(networkRule.getNetworkPeers(), (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class, rule){
                private /* synthetic */ Reference rule;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    this.rule = reference = rule;
                }

                public Object doCall(NetworkPeer peer) {
                    return String.format("%s -o %s -u %s", this.rule.get(), peer.getGroupId(), peer.getUserQueryKey());
                }

                public Object call(NetworkPeer peer) {
                    return this.doCall(peer);
                }

                public String getRule() {
                    return (String)ScriptBytecodeAdapter.castToType((Object)this.rule.get(), String.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _explodeRules_closure18.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _explodeRules_closure18.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_explodeRules_closure18.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _explodeRules_closure18.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }));
            rules.addAll(DefaultGroovyMethods.collect(networkRule.getIpRanges(), (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class, rule){
                private /* synthetic */ Reference rule;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    this.rule = reference = rule;
                }

                public Object doCall(String cidr) {
                    return String.format("%s -s %s", this.rule.get(), cidr);
                }

                public Object call(String cidr) {
                    return this.doCall(cidr);
                }

                public String getRule() {
                    return (String)ScriptBytecodeAdapter.castToType((Object)this.rule.get(), String.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _explodeRules_closure19.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _explodeRules_closure19.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_explodeRules_closure19.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _explodeRules_closure19.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }));
        }
        return rules;
    }

    private static Set<IPPermissionNetworkView> explodePermissions(NetworkRule networkRule) {
        LinkedHashSet rules = Sets.newLinkedHashSet();
        if (networkRule.getProtocolNumber() != null) {
            NetworkRule.Protocol protocol = networkRule.getProtocol();
            Reference protocolNumber = new Reference((Object)networkRule.getProtocolNumber());
            NetworkRule.Protocol protocol2 = protocol;
            Reference fromPort = new Reference((Object)(protocol2 != null ? protocol2.extractLowPort(networkRule) : null));
            NetworkRule.Protocol protocol3 = protocol;
            Reference toPort = new Reference((Object)(protocol3 != null ? protocol3.extractHighPort(networkRule) : null));
            NetworkRule.Protocol protocol4 = protocol;
            Reference icmpType = new Reference((Object)(protocol4 != null ? protocol4.extractIcmpType(networkRule) : null));
            NetworkRule.Protocol protocol5 = protocol;
            Reference icmpCode = new Reference((Object)(protocol5 != null ? protocol5.extractIcmpCode(networkRule) : null));
            rules.addAll(DefaultGroovyMethods.collect(networkRule.getNetworkPeers(), (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class, protocolNumber, icmpType, fromPort, toPort, icmpCode){
                private /* synthetic */ Reference protocolNumber;
                private /* synthetic */ Reference icmpType;
                private /* synthetic */ Reference fromPort;
                private /* synthetic */ Reference toPort;
                private /* synthetic */ Reference icmpCode;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    this.protocolNumber = reference5 = protocolNumber;
                    this.icmpType = reference4 = icmpType;
                    this.fromPort = reference3 = fromPort;
                    this.toPort = reference2 = toPort;
                    this.icmpCode = reference = icmpCode;
                }

                public Object doCall(NetworkPeer peer) {
                    return new IPPermissionNetworkView((Integer)ScriptBytecodeAdapter.castToType((Object)this.protocolNumber.get(), Integer.class), (Integer)ScriptBytecodeAdapter.castToType((Object)this.fromPort.get(), Integer.class), (Integer)ScriptBytecodeAdapter.castToType((Object)this.toPort.get(), Integer.class), (Integer)ScriptBytecodeAdapter.castToType((Object)this.icmpType.get(), Integer.class), (Integer)ScriptBytecodeAdapter.castToType((Object)this.icmpCode.get(), Integer.class), peer.getGroupId(), peer.getUserQueryKey(), null);
                }

                public Object call(NetworkPeer peer) {
                    return this.doCall(peer);
                }

                public Integer getProtocolNumber() {
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.protocolNumber.get(), Integer.class);
                }

                public Integer getIcmpType() {
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.icmpType.get(), Integer.class);
                }

                public Integer getFromPort() {
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.fromPort.get(), Integer.class);
                }

                public Integer getToPort() {
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.toPort.get(), Integer.class);
                }

                public Integer getIcmpCode() {
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.icmpCode.get(), Integer.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _explodePermissions_closure20.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _explodePermissions_closure20.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_explodePermissions_closure20.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _explodePermissions_closure20.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }));
            rules.addAll(DefaultGroovyMethods.collect(networkRule.getIpRanges(), (Closure)new GeneratedClosure(NetworkInfoBroadcaster.class, NetworkInfoBroadcaster.class, protocolNumber, icmpType, fromPort, toPort, icmpCode){
                private /* synthetic */ Reference protocolNumber;
                private /* synthetic */ Reference icmpType;
                private /* synthetic */ Reference fromPort;
                private /* synthetic */ Reference toPort;
                private /* synthetic */ Reference icmpCode;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    this.protocolNumber = reference5 = protocolNumber;
                    this.icmpType = reference4 = icmpType;
                    this.fromPort = reference3 = fromPort;
                    this.toPort = reference2 = toPort;
                    this.icmpCode = reference = icmpCode;
                }

                public Object doCall(String cidr) {
                    return new IPPermissionNetworkView((Integer)ScriptBytecodeAdapter.castToType((Object)this.protocolNumber.get(), Integer.class), (Integer)ScriptBytecodeAdapter.castToType((Object)this.fromPort.get(), Integer.class), (Integer)ScriptBytecodeAdapter.castToType((Object)this.toPort.get(), Integer.class), (Integer)ScriptBytecodeAdapter.castToType((Object)this.icmpType.get(), Integer.class), (Integer)ScriptBytecodeAdapter.castToType((Object)this.icmpCode.get(), Integer.class), null, null, cidr);
                }

                public Object call(String cidr) {
                    return this.doCall(cidr);
                }

                public Integer getProtocolNumber() {
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.protocolNumber.get(), Integer.class);
                }

                public Integer getIcmpType() {
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.icmpType.get(), Integer.class);
                }

                public Integer getFromPort() {
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.fromPort.get(), Integer.class);
                }

                public Integer getToPort() {
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.toPort.get(), Integer.class);
                }

                public Integer getIcmpCode() {
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.icmpCode.get(), Integer.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _explodePermissions_closure21.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _explodePermissions_closure21.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_explodePermissions_closure21.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _explodePermissions_closure21.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }));
        }
        return rules;
    }

    private static boolean validInstanceMetadata(VmInstance instance) {
        return !Strings.isNullOrEmpty((String)instance.getPrivateAddress()) && !VmNetworkConfig.DEFAULT_IP.equals(instance.getPrivateAddress()) && !instance.getNetworkGroups().isEmpty();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != NetworkInfoBroadcaster.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NetworkInfoBroadcaster.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, NetworkInfoBroadcaster.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectField(NetworkInfoBroadcaster.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public static /* synthetic */ Set<String> access$1(NetworkInfoBroadcaster $that, NetworkRule networkRule) {
        return NetworkInfoBroadcaster.explodeRules(networkRule);
    }

    public static /* synthetic */ Set<IPPermissionNetworkView> access$2(NetworkInfoBroadcaster $that, NetworkRule networkRule) {
        return NetworkInfoBroadcaster.explodePermissions(networkRule);
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        long l;
        $const$0 = l = 0L;
    }

    static {
        EntityCache entityCache;
        EntityCache entityCache2;
        EntityCache entityCache3;
        EntityCache entityCache4;
        EntityCache entityCache5;
        EntityCache entityCache6;
        EntityCache entityCache7;
        EntityCache entityCache8;
        EntityCache entityCache9;
        ConcurrentMap concurrentMap;
        AtomicLong atomicLong;
        Logger logger;
        long l;
        long l2;
        NetworkInfoBroadcaster.__$swapInit();
        __timeStamp__239_neverHappen1453166314227 = l2 = 0L;
        __timeStamp = l = 1453166314227L;
        NetworkInfoBroadcaster.logger = logger = Logger.getLogger(NetworkInfoBroadcaster.class);
        lastBroadcastTime = atomicLong = new AtomicLong(0L);
        activeBroadcastMap = concurrentMap = Maps.newConcurrentMap();
        instanceCache = entityCache9 = new EntityCache((AbstractPersistent)VmInstance.named(null), TypeMappers.lookup(VmInstance.class, VmInstanceNetworkView.class));
        securityGroupCache = entityCache8 = new EntityCache((AbstractPersistent)NetworkGroup.withNaturalId(null), TypeMappers.lookup(NetworkGroup.class, NetworkGroupNetworkView.class));
        vpcCache = entityCache7 = new EntityCache((AbstractPersistent)Vpc.exampleWithOwner(null), TypeMappers.lookup(Vpc.class, VpcNetworkView.class));
        subnetCache = entityCache6 = new EntityCache((AbstractPersistent)com.eucalyptus.compute.vpc.Subnet.exampleWithOwner(null), TypeMappers.lookup(com.eucalyptus.compute.vpc.Subnet.class, SubnetNetworkView.class));
        dhcpOptionsCache = entityCache5 = new EntityCache((AbstractPersistent)DhcpOptionSet.exampleWithOwner(null), TypeMappers.lookup(DhcpOptionSet.class, DhcpOptionSetNetworkView.class));
        networkAclCache = entityCache4 = new EntityCache((AbstractPersistent)NetworkAcl.exampleWithOwner(null), TypeMappers.lookup(NetworkAcl.class, NetworkAclNetworkView.class));
        routeTableCache = entityCache3 = new EntityCache((AbstractPersistent)RouteTable.exampleWithOwner(null), TypeMappers.lookup(RouteTable.class, RouteTableNetworkView.class));
        internetGatewayCache = entityCache2 = new EntityCache((AbstractPersistent)InternetGateway.exampleWithOwner(null), TypeMappers.lookup(InternetGateway.class, InternetGatewayNetworkView.class));
        networkInterfaceCache = entityCache = new EntityCache((AbstractPersistent)NetworkInterface.exampleWithOwner(null), TypeMappers.lookup(NetworkInterface.class, NetworkInterfaceNetworkView.class));
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(NetworkInfoBroadcaster.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = NetworkInfoBroadcaster.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public interface NetworkInfoSource {
        public Iterable<VmInstanceNetworkView> getInstances();

        public Iterable<NetworkGroupNetworkView> getSecurityGroups();

        public Iterable<VpcNetworkView> getVpcs();

        public Iterable<SubnetNetworkView> getSubnets();

        public Iterable<DhcpOptionSetNetworkView> getDhcpOptionSets();

        public Iterable<NetworkAclNetworkView> getNetworkAcls();

        public Iterable<RouteTableNetworkView> getRouteTables();

        public Iterable<InternetGatewayNetworkView> getInternetGateways();

        public Iterable<NetworkInterfaceNetworkView> getNetworkInterfaces();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class NetworkConfigurationToNetworkInfo
    extends Enum<NetworkConfigurationToNetworkInfo>
    implements Function<NetworkConfiguration, NetworkInfo>,
    GroovyObject {
        public static final /* enum */ NetworkConfigurationToNetworkInfo INSTANCE;
        public static final NetworkConfigurationToNetworkInfo MIN_VALUE;
        public static final NetworkConfigurationToNetworkInfo MAX_VALUE;
        private static final /* synthetic */ NetworkConfigurationToNetworkInfo[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkConfigurationToNetworkInfo(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$NetworkConfigurationToNetworkInfo was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public NetworkConfigurationToNetworkInfo() {
            this(new LinkedHashMap());
        }

        public NetworkInfo apply(NetworkConfiguration networkConfiguration) {
            NISubnets nISubnets;
            NIMidonet nIMidonet;
            NIProperty nIProperty;
            NetworkInfo networkInfo = new NetworkInfo();
            NIConfiguration nIConfiguration = new NIConfiguration();
            Object[] objectArray = new Object[1];
            if (DefaultTypeTransformation.booleanUnbox(networkConfiguration.getPublicIps())) {
                NIProperty nIProperty2 = new NIProperty();
                nIProperty2.setName("publicIps");
                nIProperty2.setValues(networkConfiguration.getPublicIps());
                nIProperty = nIProperty2;
            } else {
                nIProperty = null;
            }
            objectArray[0] = nIProperty;
            nIConfiguration.setProperties((List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.findAll((Collection)ScriptBytecodeAdapter.createList((Object[])objectArray)), List.class));
            NetworkConfiguration networkConfiguration2 = networkConfiguration;
            if (DefaultTypeTransformation.booleanUnbox((Object)(networkConfiguration2 != null ? networkConfiguration2.getMido() : null))) {
                NIProperty nIProperty3;
                NIProperty nIProperty4;
                NIProperty nIProperty5;
                NIProperty nIProperty6;
                NIProperty nIProperty7;
                NIProperty nIProperty8;
                NIMidonet nIMidonet2 = new NIMidonet();
                nIMidonet2.setName("mido");
                Object[] objectArray2 = new Object[6];
                NetworkConfiguration networkConfiguration3 = networkConfiguration;
                Midonet midonet = networkConfiguration3 != null ? networkConfiguration3.getMido() : null;
                if (DefaultTypeTransformation.booleanUnbox((Object)(midonet != null ? midonet.getEucanetdHost() : null))) {
                    NIProperty nIProperty9 = new NIProperty();
                    nIProperty9.setName("eucanetdHost");
                    nIProperty9.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{networkConfiguration.getMido().getEucanetdHost()}));
                    nIProperty8 = nIProperty9;
                } else {
                    nIProperty8 = null;
                }
                objectArray2[0] = nIProperty8;
                NetworkConfiguration networkConfiguration4 = networkConfiguration;
                Midonet midonet2 = networkConfiguration4 != null ? networkConfiguration4.getMido() : null;
                if (DefaultTypeTransformation.booleanUnbox((Object)(midonet2 != null ? midonet2.getGatewayHost() : null))) {
                    NIProperty nIProperty10 = new NIProperty();
                    nIProperty10.setName("gatewayHost");
                    nIProperty10.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{networkConfiguration.getMido().getGatewayHost()}));
                    nIProperty7 = nIProperty10;
                } else {
                    nIProperty7 = null;
                }
                objectArray2[1] = nIProperty7;
                NetworkConfiguration networkConfiguration5 = networkConfiguration;
                Midonet midonet3 = networkConfiguration5 != null ? networkConfiguration5.getMido() : null;
                if (DefaultTypeTransformation.booleanUnbox((Object)(midonet3 != null ? midonet3.getGatewayIP() : null))) {
                    NIProperty nIProperty11 = new NIProperty();
                    nIProperty11.setName("gatewayIP");
                    nIProperty11.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{networkConfiguration.getMido().getGatewayIP()}));
                    nIProperty6 = nIProperty11;
                } else {
                    nIProperty6 = null;
                }
                objectArray2[2] = nIProperty6;
                NetworkConfiguration networkConfiguration6 = networkConfiguration;
                Midonet midonet4 = networkConfiguration6 != null ? networkConfiguration6.getMido() : null;
                if (DefaultTypeTransformation.booleanUnbox((Object)(midonet4 != null ? midonet4.getGatewayInterface() : null))) {
                    NIProperty nIProperty12 = new NIProperty();
                    nIProperty12.setName("gatewayInterface");
                    nIProperty12.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{networkConfiguration.getMido().getGatewayInterface()}));
                    nIProperty5 = nIProperty12;
                } else {
                    nIProperty5 = null;
                }
                objectArray2[3] = nIProperty5;
                NetworkConfiguration networkConfiguration7 = networkConfiguration;
                Midonet midonet5 = networkConfiguration7 != null ? networkConfiguration7.getMido() : null;
                if (DefaultTypeTransformation.booleanUnbox((Object)(midonet5 != null ? midonet5.getPublicNetworkCidr() : null))) {
                    NIProperty nIProperty13 = new NIProperty();
                    nIProperty13.setName("publicNetworkCidr");
                    nIProperty13.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{networkConfiguration.getMido().getPublicNetworkCidr()}));
                    nIProperty4 = nIProperty13;
                } else {
                    nIProperty4 = null;
                }
                objectArray2[4] = nIProperty4;
                NetworkConfiguration networkConfiguration8 = networkConfiguration;
                Midonet midonet6 = networkConfiguration8 != null ? networkConfiguration8.getMido() : null;
                if (DefaultTypeTransformation.booleanUnbox((Object)(midonet6 != null ? midonet6.getPublicGatewayIP() : null))) {
                    NIProperty nIProperty14 = new NIProperty();
                    nIProperty14.setName("publicGatewayIP");
                    nIProperty14.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{networkConfiguration.getMido().getPublicGatewayIP()}));
                    nIProperty3 = nIProperty14;
                } else {
                    nIProperty3 = null;
                }
                objectArray2[5] = nIProperty3;
                nIMidonet2.setProperties((List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.findAll((Collection)ScriptBytecodeAdapter.createList((Object[])objectArray2)), List.class));
                nIMidonet = nIMidonet2;
            } else {
                nIMidonet = null;
            }
            nIConfiguration.setMidonet((NIMidonet)ScriptBytecodeAdapter.castToType(nIMidonet, NIMidonet.class));
            if (DefaultTypeTransformation.booleanUnbox(networkConfiguration.getSubnets())) {
                NISubnets nISubnets2 = new NISubnets();
                nISubnets2.setName("subnets");
                nISubnets2.setSubnets(DefaultGroovyMethods.collect(networkConfiguration.getSubnets(), (Closure)new GeneratedClosure((Object)this, (Object)this){
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public Object doCall(Subnet subnet) {
                        NISubnet nISubnet = new NISubnet();
                        nISubnet.setName(subnet.getSubnet());
                        Object[] objectArray = new Object[3];
                        NIProperty nIProperty = new NIProperty();
                        nIProperty.setName("subnet");
                        nIProperty.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{subnet.getSubnet()}));
                        objectArray[0] = nIProperty;
                        NIProperty nIProperty2 = new NIProperty();
                        nIProperty2.setName("netmask");
                        nIProperty2.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{subnet.getNetmask()}));
                        objectArray[1] = nIProperty2;
                        NIProperty nIProperty3 = new NIProperty();
                        nIProperty3.setName("gateway");
                        nIProperty3.setValues(ScriptBytecodeAdapter.createList((Object[])new Object[]{subnet.getGateway()}));
                        objectArray[2] = nIProperty3;
                        nISubnet.setProperties(ScriptBytecodeAdapter.createList((Object[])objectArray));
                        return nISubnet;
                    }

                    public Object call(Subnet subnet) {
                        return this.doCall(subnet);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _NetworkConfigurationToNetworkInfo_apply_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _NetworkConfigurationToNetworkInfo_apply_closure1.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_NetworkConfigurationToNetworkInfo_apply_closure1.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _NetworkConfigurationToNetworkInfo_apply_closure1.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }));
                nISubnets = nISubnets2;
            } else {
                nISubnets = null;
            }
            nIConfiguration.setSubnets((NISubnets)ScriptBytecodeAdapter.castToType(nISubnets, NISubnets.class));
            networkInfo.setConfiguration(nIConfiguration);
            return networkInfo;
        }

        public static final NetworkConfigurationToNetworkInfo[] values() {
            return (NetworkConfigurationToNetworkInfo[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), NetworkConfigurationToNetworkInfo[].class);
        }

        public /* synthetic */ NetworkConfigurationToNetworkInfo next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (NetworkConfigurationToNetworkInfo)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), NetworkConfigurationToNetworkInfo.class));
        }

        public /* synthetic */ NetworkConfigurationToNetworkInfo previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (NetworkConfigurationToNetworkInfo)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), NetworkConfigurationToNetworkInfo.class));
        }

        public static NetworkConfigurationToNetworkInfo valueOf(String name) {
            return (NetworkConfigurationToNetworkInfo)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(NetworkConfigurationToNetworkInfo.class, name)), NetworkConfigurationToNetworkInfo.class));
        }

        public static final /* synthetic */ NetworkConfigurationToNetworkInfo $INIT(Object ... para) {
            NetworkConfigurationToNetworkInfo networkConfigurationToNetworkInfo;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, NetworkConfigurationToNetworkInfo.class)) {
                case -1348271900: {
                    NetworkConfigurationToNetworkInfo networkConfigurationToNetworkInfo2;
                    networkConfigurationToNetworkInfo = networkConfigurationToNetworkInfo2;
                    Object[] objectArray2 = objectArray;
                    networkConfigurationToNetworkInfo2 = new NetworkConfigurationToNetworkInfo();
                    break;
                }
                case -242181752: {
                    NetworkConfigurationToNetworkInfo networkConfigurationToNetworkInfo2;
                    networkConfigurationToNetworkInfo = networkConfigurationToNetworkInfo2;
                    Object[] objectArray2 = objectArray;
                    networkConfigurationToNetworkInfo2 = new NetworkConfigurationToNetworkInfo((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return networkConfigurationToNetworkInfo;
        }

        static {
            NetworkConfigurationToNetworkInfo networkConfigurationToNetworkInfo;
            NetworkConfigurationToNetworkInfo networkConfigurationToNetworkInfo2;
            NetworkConfigurationToNetworkInfo networkConfigurationToNetworkInfo3;
            NetworkConfigurationToNetworkInfo.__$swapInit();
            INSTANCE = networkConfigurationToNetworkInfo3 = NetworkConfigurationToNetworkInfo.$INIT("INSTANCE", 0);
            MIN_VALUE = networkConfigurationToNetworkInfo2 = INSTANCE;
            MAX_VALUE = networkConfigurationToNetworkInfo = INSTANCE;
            NetworkConfigurationToNetworkInfo[] networkConfigurationToNetworkInfoArray = new NetworkConfigurationToNetworkInfo[]{INSTANCE};
            $VALUES = networkConfigurationToNetworkInfoArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != NetworkConfigurationToNetworkInfo.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkConfigurationToNetworkInfo.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkConfigurationToNetworkInfo.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static final class VmInstanceNetworkView
    implements Comparable<VmInstanceNetworkView>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final String instanceId;
        private final VmInstance.VmState state;
        private final Boolean omit;
        private final String ownerAccountNumber;
        private final String vpcId;
        private final String subnetId;
        private final String macAddress;
        private final String privateAddress;
        private final String publicAddress;
        private final String partition;
        private final String node;
        private final List<String> securityGroupIds;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public VmInstanceNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("instanceId") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.instanceId = (String)ScriptBytecodeAdapter.castToType(var3_3, String.class);
                    }
                } else {
                    Object v = args.get("instanceId");
                    this.instanceId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("state") == null) {
                    if (!(null == null)) {
                        Object var5_5 = null;
                        this.state = (VmInstance.VmState)((Object)ScriptBytecodeAdapter.castToType(var5_5, VmInstance.VmState.class));
                    }
                } else {
                    Object v = args.get("state");
                    this.state = (VmInstance.VmState)((Object)ScriptBytecodeAdapter.castToType(v, VmInstance.VmState.class));
                }
                if (args.get("omit") == null) {
                    if (!(null == null)) {
                        Object var7_7 = null;
                        this.omit = (Boolean)ScriptBytecodeAdapter.castToType(var7_7, Boolean.class);
                    }
                } else {
                    Object v = args.get("omit");
                    this.omit = (Boolean)ScriptBytecodeAdapter.castToType(v, Boolean.class);
                }
                if (args.get("ownerAccountNumber") == null) {
                    if (!(null == null)) {
                        Object var9_9 = null;
                        this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(var9_9, String.class);
                    }
                } else {
                    Object v = args.get("ownerAccountNumber");
                    this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("vpcId") == null) {
                    if (!(null == null)) {
                        Object var11_11 = null;
                        this.vpcId = (String)ScriptBytecodeAdapter.castToType(var11_11, String.class);
                    }
                } else {
                    Object v = args.get("vpcId");
                    this.vpcId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("subnetId") == null) {
                    if (!(null == null)) {
                        Object var13_13 = null;
                        this.subnetId = (String)ScriptBytecodeAdapter.castToType(var13_13, String.class);
                    }
                } else {
                    Object v = args.get("subnetId");
                    this.subnetId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("macAddress") == null) {
                    if (!(null == null)) {
                        Object var15_15 = null;
                        this.macAddress = (String)ScriptBytecodeAdapter.castToType(var15_15, String.class);
                    }
                } else {
                    Object v = args.get("macAddress");
                    this.macAddress = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("privateAddress") == null) {
                    if (!(null == null)) {
                        Object var17_17 = null;
                        this.privateAddress = (String)ScriptBytecodeAdapter.castToType(var17_17, String.class);
                    }
                } else {
                    Object v = args.get("privateAddress");
                    this.privateAddress = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("publicAddress") == null) {
                    if (!(null == null)) {
                        Object var19_19 = null;
                        this.publicAddress = (String)ScriptBytecodeAdapter.castToType(var19_19, String.class);
                    }
                } else {
                    Object v = args.get("publicAddress");
                    this.publicAddress = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("partition") == null) {
                    if (!(null == null)) {
                        Object var21_21 = null;
                        this.partition = (String)ScriptBytecodeAdapter.castToType(var21_21, String.class);
                    }
                } else {
                    Object v = args.get("partition");
                    this.partition = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("node") == null) {
                    if (!(null == null)) {
                        Object var23_23 = null;
                        this.node = (String)ScriptBytecodeAdapter.castToType(var23_23, String.class);
                    }
                } else {
                    Object v = args.get("node");
                    this.node = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("securityGroupIds") == null) {
                    if (!(null == null)) {
                        SortedSet sortedSet = null instanceof SortedSet ? DefaultGroovyMethods.asImmutable(null) : (null instanceof SortedMap ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Set ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Map ? DefaultGroovyMethods.asImmutable(null) : (null instanceof List ? DefaultGroovyMethods.asImmutable(null) : DefaultGroovyMethods.asImmutable(null)))));
                        this.securityGroupIds = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                    }
                } else if (args.get("securityGroupIds") instanceof Cloneable) {
                    SortedSet sortedSet = (List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedSet.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedMap.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Set.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Map.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)))))));
                    this.securityGroupIds = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                } else {
                    SortedSet sortedSet = args.get("securityGroupIds") instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType(args.get("securityGroupIds"), SortedSet.class))) : (args.get("securityGroupIds") instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType(args.get("securityGroupIds"), SortedMap.class))) : (args.get("securityGroupIds") instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType(args.get("securityGroupIds"), Set.class))) : (args.get("securityGroupIds") instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType(args.get("securityGroupIds"), Map.class))) : (args.get("securityGroupIds") instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType(args.get("securityGroupIds"), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((Collection)ScriptBytecodeAdapter.castToType(args.get("securityGroupIds"), Collection.class)))))));
                    this.securityGroupIds = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public VmInstanceNetworkView(String instanceId, VmInstance.VmState state, Boolean omit, String ownerAccountNumber, String vpcId, String subnetId, String macAddress, String privateAddress, String publicAddress, String partition, String node, List<String> securityGroupIds) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instanceId", instanceId, "state", state, "omit", omit, "ownerAccountNumber", ownerAccountNumber, "vpcId", vpcId, "subnetId", subnetId, "macAddress", macAddress, "privateAddress", privateAddress, "publicAddress", publicAddress, "partition", partition, "node", node, "securityGroupIds", securityGroupIds}), HashMap.class));
        }

        @Override
        public int compareTo(VmInstanceNetworkView o) {
            return this.instanceId == o.getInstanceId() ? 0 : (this.instanceId == null ? -1 : (o.getInstanceId() == null ? 1 : this.instanceId.compareTo(o.getInstanceId())));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != VmInstanceNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"instanceId"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"instanceId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"state"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"state"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"omit"), (Object)this)) {
                    int n4;
                    _result = n4 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"omit"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    int n5;
                    _result = n5 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"), (Object)this)) {
                    int n6;
                    _result = n6 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"subnetId"), (Object)this)) {
                    int n7;
                    _result = n7 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"subnetId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"macAddress"), (Object)this)) {
                    int n8;
                    _result = n8 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"macAddress"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"privateAddress"), (Object)this)) {
                    int n9;
                    _result = n9 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"privateAddress"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"publicAddress"), (Object)this)) {
                    int n10;
                    _result = n10 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"publicAddress"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"partition"), (Object)this)) {
                    int n11;
                    _result = n11 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"partition"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"node"), (Object)this)) {
                    int n12;
                    _result = n12 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"node"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"securityGroupIds"), (Object)this)) {
                    int n13;
                    _result = n13 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"securityGroupIds"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(VmInstanceNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            VmInstanceNetworkView otherTyped = (VmInstanceNetworkView)ScriptBytecodeAdapter.castToType((Object)other, VmInstanceNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getInstanceId(), (Object)otherTyped.getInstanceId())) {
                if (DefaultGroovyMethods.is((Object)this.getInstanceId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getInstanceId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getInstanceId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getInstanceId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getInstanceId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getInstanceId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getInstanceId(), (Object)otherTyped.getInstanceId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)((Object)this.getState()), (Object)((Object)otherTyped.getState()))) {
                if (DefaultGroovyMethods.is((Object)((Object)this.getState()), (Object)this) && !DefaultGroovyMethods.is((Object)((Object)otherTyped.getState()), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)((Object)this.getState()), (Object)this) && DefaultGroovyMethods.is((Object)((Object)otherTyped.getState()), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)((Object)this.getState()), (Object)this) && DefaultGroovyMethods.is((Object)((Object)otherTyped.getState()), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)((Object)this.getState()), (Object)((Object)otherTyped.getState()))) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getOmit(), (Object)otherTyped.getOmit())) {
                if (DefaultGroovyMethods.is((Object)this.getOmit(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getOmit(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getOmit(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOmit(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getOmit(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOmit(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getOmit(), (Object)otherTyped.getOmit())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                if (DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)otherTyped.getVpcId())) {
                if (DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getVpcId(), (Object)otherTyped.getVpcId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getSubnetId(), (Object)otherTyped.getSubnetId())) {
                if (DefaultGroovyMethods.is((Object)this.getSubnetId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getSubnetId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getSubnetId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getSubnetId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getSubnetId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getSubnetId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getSubnetId(), (Object)otherTyped.getSubnetId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getMacAddress(), (Object)otherTyped.getMacAddress())) {
                if (DefaultGroovyMethods.is((Object)this.getMacAddress(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getMacAddress(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getMacAddress(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getMacAddress(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getMacAddress(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getMacAddress(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getMacAddress(), (Object)otherTyped.getMacAddress())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getPrivateAddress(), (Object)otherTyped.getPrivateAddress())) {
                if (DefaultGroovyMethods.is((Object)this.getPrivateAddress(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getPrivateAddress(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getPrivateAddress(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPrivateAddress(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getPrivateAddress(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPrivateAddress(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getPrivateAddress(), (Object)otherTyped.getPrivateAddress())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getPublicAddress(), (Object)otherTyped.getPublicAddress())) {
                if (DefaultGroovyMethods.is((Object)this.getPublicAddress(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getPublicAddress(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getPublicAddress(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPublicAddress(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getPublicAddress(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPublicAddress(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getPublicAddress(), (Object)otherTyped.getPublicAddress())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getPartition(), (Object)otherTyped.getPartition())) {
                if (DefaultGroovyMethods.is((Object)this.getPartition(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getPartition(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getPartition(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPartition(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getPartition(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPartition(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getPartition(), (Object)otherTyped.getPartition())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getNode(), (Object)otherTyped.getNode())) {
                if (DefaultGroovyMethods.is((Object)this.getNode(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getNode(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getNode(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getNode(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getNode(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getNode(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getNode(), (Object)otherTyped.getNode())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is(this.getSecurityGroupIds(), otherTyped.getSecurityGroupIds())) {
                if (DefaultGroovyMethods.is(this.getSecurityGroupIds(), (Object)this) && !DefaultGroovyMethods.is(otherTyped.getSecurityGroupIds(), (Object)otherTyped) || !DefaultGroovyMethods.is(this.getSecurityGroupIds(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getSecurityGroupIds(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is(this.getSecurityGroupIds(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getSecurityGroupIds(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual(this.getSecurityGroupIds(), otherTyped.getSecurityGroupIds())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$VmInstanceNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"instanceId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"instanceId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"instanceId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"state") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"state"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"state")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"omit") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl4;
                    $toStringFirst = bl4 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"omit"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"omit")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl5;
                    $toStringFirst = bl5 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"vpcId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl6;
                    $toStringFirst = bl6 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"subnetId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl7;
                    $toStringFirst = bl7 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"subnetId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"subnetId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"macAddress") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl8;
                    $toStringFirst = bl8 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"macAddress"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"macAddress")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"privateAddress") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl9;
                    $toStringFirst = bl9 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"privateAddress"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"privateAddress")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"publicAddress") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl10;
                    $toStringFirst = bl10 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"publicAddress"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"publicAddress")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"partition") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl11;
                    $toStringFirst = bl11 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"partition"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"partition")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"node") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl12;
                    $toStringFirst = bl12 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"node"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"node")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"securityGroupIds") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl13;
                    $toStringFirst = bl13 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"securityGroupIds"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"securityGroupIds")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(VmInstanceNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, VmInstanceNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(VmInstanceNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(VmInstanceNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, VmInstanceNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(VmInstanceNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            VmInstanceNetworkView.__$swapInit();
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final VmInstance.VmState getState() {
            return this.state;
        }

        public final Boolean getOmit() {
            return this.omit;
        }

        public final String getOwnerAccountNumber() {
            return this.ownerAccountNumber;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final String getPrivateAddress() {
            return this.privateAddress;
        }

        public final String getPublicAddress() {
            return this.publicAddress;
        }

        public final String getPartition() {
            return this.partition;
        }

        public final String getNode() {
            return this.node;
        }

        public final List<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(VmInstanceNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = VmInstanceNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class VmInstanceToVmInstanceNetworkView
    extends Enum<VmInstanceToVmInstanceNetworkView>
    implements Function<VmInstance, VmInstanceNetworkView>,
    GroovyObject {
        public static final /* enum */ VmInstanceToVmInstanceNetworkView INSTANCE;
        public static final VmInstanceToVmInstanceNetworkView MIN_VALUE;
        public static final VmInstanceToVmInstanceNetworkView MAX_VALUE;
        private static final /* synthetic */ VmInstanceToVmInstanceNetworkView[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public VmInstanceToVmInstanceNetworkView(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$VmInstanceToVmInstanceNetworkView was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public VmInstanceToVmInstanceNetworkView() {
            this(new LinkedHashMap());
        }

        public VmInstanceNetworkView apply(VmInstance instance) {
            return new VmInstanceNetworkView(instance.getInstanceId(), (VmInstance.VmState)((Object)ScriptBytecodeAdapter.castToType((Object)instance.getState(), VmInstance.VmState.class)), DefaultTypeTransformation.booleanUnbox((Object)Objects.firstNonNull((Object)instance.getRuntimeState().getZombie(), (Object)false)) || !NetworkInfoBroadcaster.validInstanceMetadata(instance), instance.getOwnerAccountNumber(), instance.getBootRecord().getVpcId(), instance.getBootRecord().getSubnetId(), instance.getMacAddress(), instance.getPrivateAddress(), instance.getPublicAddress(), instance.getPartition(), Strings.nullToEmpty((String)((String)ScriptBytecodeAdapter.castToType((Object)VmInstances.toNodeHost().apply((Object)instance), String.class))), DefaultGroovyMethods.collect(instance.getNetworkGroups(), (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(NetworkGroup group) {
                    return group.getGroupId();
                }

                public Object call(NetworkGroup group) {
                    return this.doCall(group);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _VmInstanceToVmInstanceNetworkView_apply_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _VmInstanceToVmInstanceNetworkView_apply_closure1.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_VmInstanceToVmInstanceNetworkView_apply_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _VmInstanceToVmInstanceNetworkView_apply_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }));
        }

        public static final VmInstanceToVmInstanceNetworkView[] values() {
            return (VmInstanceToVmInstanceNetworkView[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), VmInstanceToVmInstanceNetworkView[].class);
        }

        public /* synthetic */ VmInstanceToVmInstanceNetworkView next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (VmInstanceToVmInstanceNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), VmInstanceToVmInstanceNetworkView.class));
        }

        public /* synthetic */ VmInstanceToVmInstanceNetworkView previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (VmInstanceToVmInstanceNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), VmInstanceToVmInstanceNetworkView.class));
        }

        public static VmInstanceToVmInstanceNetworkView valueOf(String name) {
            return (VmInstanceToVmInstanceNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(VmInstanceToVmInstanceNetworkView.class, name)), VmInstanceToVmInstanceNetworkView.class));
        }

        public static final /* synthetic */ VmInstanceToVmInstanceNetworkView $INIT(Object ... para) {
            VmInstanceToVmInstanceNetworkView vmInstanceToVmInstanceNetworkView;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, VmInstanceToVmInstanceNetworkView.class)) {
                case -1348271900: {
                    VmInstanceToVmInstanceNetworkView vmInstanceToVmInstanceNetworkView2;
                    vmInstanceToVmInstanceNetworkView = vmInstanceToVmInstanceNetworkView2;
                    Object[] objectArray2 = objectArray;
                    vmInstanceToVmInstanceNetworkView2 = new VmInstanceToVmInstanceNetworkView();
                    break;
                }
                case -242181752: {
                    VmInstanceToVmInstanceNetworkView vmInstanceToVmInstanceNetworkView2;
                    vmInstanceToVmInstanceNetworkView = vmInstanceToVmInstanceNetworkView2;
                    Object[] objectArray2 = objectArray;
                    vmInstanceToVmInstanceNetworkView2 = new VmInstanceToVmInstanceNetworkView((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return vmInstanceToVmInstanceNetworkView;
        }

        static {
            VmInstanceToVmInstanceNetworkView vmInstanceToVmInstanceNetworkView;
            VmInstanceToVmInstanceNetworkView vmInstanceToVmInstanceNetworkView2;
            VmInstanceToVmInstanceNetworkView vmInstanceToVmInstanceNetworkView3;
            VmInstanceToVmInstanceNetworkView.__$swapInit();
            INSTANCE = vmInstanceToVmInstanceNetworkView3 = VmInstanceToVmInstanceNetworkView.$INIT("INSTANCE", 0);
            MIN_VALUE = vmInstanceToVmInstanceNetworkView2 = INSTANCE;
            MAX_VALUE = vmInstanceToVmInstanceNetworkView = INSTANCE;
            VmInstanceToVmInstanceNetworkView[] vmInstanceToVmInstanceNetworkViewArray = new VmInstanceToVmInstanceNetworkView[]{INSTANCE};
            $VALUES = vmInstanceToVmInstanceNetworkViewArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != VmInstanceToVmInstanceNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(VmInstanceToVmInstanceNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = VmInstanceToVmInstanceNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    @Immutable
    public static final class IPPermissionNetworkView
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final Integer protocol;
        private final Integer fromPort;
        private final Integer toPort;
        private final Integer icmpType;
        private final Integer icmpCode;
        private final String groupId;
        private final String groupOwnerAccountNumber;
        private final String cidr;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public IPPermissionNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("protocol") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.protocol = (Integer)ScriptBytecodeAdapter.castToType(var3_3, Integer.class);
                    }
                } else {
                    Object v = args.get("protocol");
                    this.protocol = (Integer)ScriptBytecodeAdapter.castToType(v, Integer.class);
                }
                if (args.get("fromPort") == null) {
                    if (!(null == null)) {
                        Object var5_5 = null;
                        this.fromPort = (Integer)ScriptBytecodeAdapter.castToType(var5_5, Integer.class);
                    }
                } else {
                    Object v = args.get("fromPort");
                    this.fromPort = (Integer)ScriptBytecodeAdapter.castToType(v, Integer.class);
                }
                if (args.get("toPort") == null) {
                    if (!(null == null)) {
                        Object var7_7 = null;
                        this.toPort = (Integer)ScriptBytecodeAdapter.castToType(var7_7, Integer.class);
                    }
                } else {
                    Object v = args.get("toPort");
                    this.toPort = (Integer)ScriptBytecodeAdapter.castToType(v, Integer.class);
                }
                if (args.get("icmpType") == null) {
                    if (!(null == null)) {
                        Object var9_9 = null;
                        this.icmpType = (Integer)ScriptBytecodeAdapter.castToType(var9_9, Integer.class);
                    }
                } else {
                    Object v = args.get("icmpType");
                    this.icmpType = (Integer)ScriptBytecodeAdapter.castToType(v, Integer.class);
                }
                if (args.get("icmpCode") == null) {
                    if (!(null == null)) {
                        Object var11_11 = null;
                        this.icmpCode = (Integer)ScriptBytecodeAdapter.castToType(var11_11, Integer.class);
                    }
                } else {
                    Object v = args.get("icmpCode");
                    this.icmpCode = (Integer)ScriptBytecodeAdapter.castToType(v, Integer.class);
                }
                if (args.get("groupId") == null) {
                    if (!(null == null)) {
                        Object var13_13 = null;
                        this.groupId = (String)ScriptBytecodeAdapter.castToType(var13_13, String.class);
                    }
                } else {
                    Object v = args.get("groupId");
                    this.groupId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("groupOwnerAccountNumber") == null) {
                    if (!(null == null)) {
                        Object var15_15 = null;
                        this.groupOwnerAccountNumber = (String)ScriptBytecodeAdapter.castToType(var15_15, String.class);
                    }
                } else {
                    Object v = args.get("groupOwnerAccountNumber");
                    this.groupOwnerAccountNumber = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("cidr") == null) {
                    if (!(null == null)) {
                        Object var17_17 = null;
                        this.cidr = (String)ScriptBytecodeAdapter.castToType(var17_17, String.class);
                    }
                } else {
                    Object v = args.get("cidr");
                    this.cidr = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public IPPermissionNetworkView(Integer protocol, Integer fromPort, Integer toPort, Integer icmpType, Integer icmpCode, String groupId, String groupOwnerAccountNumber, String cidr) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"protocol", protocol, "fromPort", fromPort, "toPort", toPort, "icmpType", icmpType, "icmpCode", icmpCode, "groupId", groupId, "groupOwnerAccountNumber", groupOwnerAccountNumber, "cidr", cidr}), HashMap.class));
        }

        public boolean equals(Object o) {
            if (DefaultGroovyMethods.is((Object)this, (Object)o)) {
                return true;
            }
            if (ScriptBytecodeAdapter.compareNotEqual(this.getClass(), o.getClass())) {
                return false;
            }
            IPPermissionNetworkView that = (IPPermissionNetworkView)ScriptBytecodeAdapter.castToType((Object)o, IPPermissionNetworkView.class);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.cidr, (Object)that.getCidr())) {
                return false;
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.fromPort, (Object)that.getFromPort())) {
                return false;
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.groupId, (Object)that.getGroupId())) {
                return false;
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.groupOwnerAccountNumber, (Object)that.getGroupOwnerAccountNumber())) {
                return false;
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.icmpCode, (Object)that.getIcmpCode())) {
                return false;
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.icmpType, (Object)that.getIcmpType())) {
                return false;
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.protocol, (Object)that.getProtocol())) {
                return false;
            }
            return !ScriptBytecodeAdapter.compareNotEqual((Object)this.toPort, (Object)that.getToPort());
        }

        public int hashCode() {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int result = 0;
            result = n8 = this.protocol != null ? this.protocol.hashCode() : 0;
            result = n7 = 31 * result + (this.fromPort != null ? this.fromPort.hashCode() : 0);
            result = n6 = 31 * result + (this.toPort != null ? this.toPort.hashCode() : 0);
            result = n5 = 31 * result + (this.icmpType != null ? this.icmpType.hashCode() : 0);
            result = n4 = 31 * result + (this.icmpCode != null ? this.icmpCode.hashCode() : 0);
            result = n3 = 31 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
            result = n2 = 31 * result + (this.groupOwnerAccountNumber != null ? this.groupOwnerAccountNumber.hashCode() : 0);
            result = n = 31 * result + (this.cidr != null ? this.cidr.hashCode() : 0);
            return result;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != IPPermissionNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        private int _hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"protocol"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"protocol"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"fromPort"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"fromPort"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"toPort"), (Object)this)) {
                    int n4;
                    _result = n4 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"toPort"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"icmpType"), (Object)this)) {
                    int n5;
                    _result = n5 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"icmpType"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"icmpCode"), (Object)this)) {
                    int n6;
                    _result = n6 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"icmpCode"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"groupId"), (Object)this)) {
                    int n7;
                    _result = n7 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"groupId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"groupOwnerAccountNumber"), (Object)this)) {
                    int n8;
                    _result = n8 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"groupOwnerAccountNumber"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"cidr"), (Object)this)) {
                    int n9;
                    _result = n9 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"cidr"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        private boolean _equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(IPPermissionNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            IPPermissionNetworkView otherTyped = (IPPermissionNetworkView)ScriptBytecodeAdapter.castToType((Object)other, IPPermissionNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getProtocol(), (Object)otherTyped.getProtocol())) {
                if (DefaultGroovyMethods.is((Object)this.getProtocol(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getProtocol(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getProtocol(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getProtocol(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getProtocol(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getProtocol(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getProtocol(), (Object)otherTyped.getProtocol())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getFromPort(), (Object)otherTyped.getFromPort())) {
                if (DefaultGroovyMethods.is((Object)this.getFromPort(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getFromPort(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getFromPort(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getFromPort(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getFromPort(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getFromPort(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getFromPort(), (Object)otherTyped.getFromPort())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getToPort(), (Object)otherTyped.getToPort())) {
                if (DefaultGroovyMethods.is((Object)this.getToPort(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getToPort(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getToPort(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getToPort(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getToPort(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getToPort(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getToPort(), (Object)otherTyped.getToPort())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getIcmpType(), (Object)otherTyped.getIcmpType())) {
                if (DefaultGroovyMethods.is((Object)this.getIcmpType(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getIcmpType(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getIcmpType(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getIcmpType(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getIcmpType(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getIcmpType(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getIcmpType(), (Object)otherTyped.getIcmpType())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getIcmpCode(), (Object)otherTyped.getIcmpCode())) {
                if (DefaultGroovyMethods.is((Object)this.getIcmpCode(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getIcmpCode(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getIcmpCode(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getIcmpCode(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getIcmpCode(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getIcmpCode(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getIcmpCode(), (Object)otherTyped.getIcmpCode())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getGroupId(), (Object)otherTyped.getGroupId())) {
                if (DefaultGroovyMethods.is((Object)this.getGroupId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getGroupId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getGroupId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getGroupId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getGroupId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getGroupId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getGroupId(), (Object)otherTyped.getGroupId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getGroupOwnerAccountNumber(), (Object)otherTyped.getGroupOwnerAccountNumber())) {
                if (DefaultGroovyMethods.is((Object)this.getGroupOwnerAccountNumber(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getGroupOwnerAccountNumber(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getGroupOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getGroupOwnerAccountNumber(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getGroupOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getGroupOwnerAccountNumber(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getGroupOwnerAccountNumber(), (Object)otherTyped.getGroupOwnerAccountNumber())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getCidr(), (Object)otherTyped.getCidr())) {
                if (DefaultGroovyMethods.is((Object)this.getCidr(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getCidr(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getCidr(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getCidr(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getCidr(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getCidr(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getCidr(), (Object)otherTyped.getCidr())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$IPPermissionNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"protocol") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"protocol"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"protocol")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"fromPort") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"fromPort"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"fromPort")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"toPort") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl4;
                    $toStringFirst = bl4 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"toPort"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"toPort")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"icmpType") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl5;
                    $toStringFirst = bl5 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"icmpType"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"icmpType")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"icmpCode") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl6;
                    $toStringFirst = bl6 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"icmpCode"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"icmpCode")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"groupId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl7;
                    $toStringFirst = bl7 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"groupId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"groupId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"groupOwnerAccountNumber") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl8;
                    $toStringFirst = bl8 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"groupOwnerAccountNumber"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"groupOwnerAccountNumber")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"cidr") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl9;
                    $toStringFirst = bl9 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"cidr"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"cidr")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(IPPermissionNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, IPPermissionNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(IPPermissionNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(IPPermissionNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, IPPermissionNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(IPPermissionNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            IPPermissionNetworkView.__$swapInit();
        }

        public final Integer getProtocol() {
            return this.protocol;
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        public final Integer getIcmpType() {
            return this.icmpType;
        }

        public final Integer getIcmpCode() {
            return this.icmpCode;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final String getGroupOwnerAccountNumber() {
            return this.groupOwnerAccountNumber;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public /* synthetic */ int this$2$_hashCode() {
            return this._hashCode();
        }

        public /* synthetic */ boolean this$2$_equals(Object object) {
            return this._equals(object);
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(IPPermissionNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = IPPermissionNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static final class NetworkGroupNetworkView
    implements Comparable<NetworkGroupNetworkView>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final String groupId;
        private final String ownerAccountNumber;
        private final List<String> rules;
        private final List<IPPermissionNetworkView> ingressPermissions;
        private final List<IPPermissionNetworkView> egressPermissions;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public NetworkGroupNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("groupId") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.groupId = (String)ScriptBytecodeAdapter.castToType(var3_3, String.class);
                    }
                } else {
                    Object v = args.get("groupId");
                    this.groupId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("ownerAccountNumber") == null) {
                    if (!(null == null)) {
                        Object var5_5 = null;
                        this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(var5_5, String.class);
                    }
                } else {
                    Object v = args.get("ownerAccountNumber");
                    this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("rules") == null) {
                    if (!(null == null)) {
                        SortedSet sortedSet = null instanceof SortedSet ? DefaultGroovyMethods.asImmutable(null) : (null instanceof SortedMap ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Set ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Map ? DefaultGroovyMethods.asImmutable(null) : (null instanceof List ? DefaultGroovyMethods.asImmutable(null) : DefaultGroovyMethods.asImmutable(null)))));
                        this.rules = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                    }
                } else if (args.get("rules") instanceof Cloneable) {
                    SortedSet sortedSet = (List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("rules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("rules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedSet.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("rules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("rules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedMap.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("rules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("rules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Set.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("rules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("rules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Map.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("rules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("rules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("rules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)))))));
                    this.rules = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                } else {
                    SortedSet sortedSet = args.get("rules") instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType(args.get("rules"), SortedSet.class))) : (args.get("rules") instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType(args.get("rules"), SortedMap.class))) : (args.get("rules") instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType(args.get("rules"), Set.class))) : (args.get("rules") instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType(args.get("rules"), Map.class))) : (args.get("rules") instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType(args.get("rules"), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((Collection)ScriptBytecodeAdapter.castToType(args.get("rules"), Collection.class)))))));
                    this.rules = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                }
                if (args.get("ingressPermissions") == null) {
                    if (!(null == null)) {
                        SortedSet sortedSet = null instanceof SortedSet ? DefaultGroovyMethods.asImmutable(null) : (null instanceof SortedMap ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Set ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Map ? DefaultGroovyMethods.asImmutable(null) : (null instanceof List ? DefaultGroovyMethods.asImmutable(null) : DefaultGroovyMethods.asImmutable(null)))));
                        this.ingressPermissions = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                    }
                } else if (args.get("ingressPermissions") instanceof Cloneable) {
                    SortedSet sortedSet = (List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedSet.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedMap.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Set.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Map.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)))))));
                    this.ingressPermissions = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                } else {
                    SortedSet sortedSet = args.get("ingressPermissions") instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType(args.get("ingressPermissions"), SortedSet.class))) : (args.get("ingressPermissions") instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType(args.get("ingressPermissions"), SortedMap.class))) : (args.get("ingressPermissions") instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType(args.get("ingressPermissions"), Set.class))) : (args.get("ingressPermissions") instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType(args.get("ingressPermissions"), Map.class))) : (args.get("ingressPermissions") instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType(args.get("ingressPermissions"), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((Collection)ScriptBytecodeAdapter.castToType(args.get("ingressPermissions"), Collection.class)))))));
                    this.ingressPermissions = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                }
                if (args.get("egressPermissions") == null) {
                    if (!(null == null)) {
                        SortedSet sortedSet = null instanceof SortedSet ? DefaultGroovyMethods.asImmutable(null) : (null instanceof SortedMap ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Set ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Map ? DefaultGroovyMethods.asImmutable(null) : (null instanceof List ? DefaultGroovyMethods.asImmutable(null) : DefaultGroovyMethods.asImmutable(null)))));
                        this.egressPermissions = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                    }
                } else if (args.get("egressPermissions") instanceof Cloneable) {
                    SortedSet sortedSet = (List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedSet.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedMap.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Set.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Map.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressPermissions"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)))))));
                    this.egressPermissions = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                } else {
                    SortedSet sortedSet = args.get("egressPermissions") instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType(args.get("egressPermissions"), SortedSet.class))) : (args.get("egressPermissions") instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType(args.get("egressPermissions"), SortedMap.class))) : (args.get("egressPermissions") instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType(args.get("egressPermissions"), Set.class))) : (args.get("egressPermissions") instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType(args.get("egressPermissions"), Map.class))) : (args.get("egressPermissions") instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType(args.get("egressPermissions"), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((Collection)ScriptBytecodeAdapter.castToType(args.get("egressPermissions"), Collection.class)))))));
                    this.egressPermissions = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public NetworkGroupNetworkView(String groupId, String ownerAccountNumber, List<String> rules, List<IPPermissionNetworkView> ingressPermissions, List<IPPermissionNetworkView> egressPermissions) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", groupId, "ownerAccountNumber", ownerAccountNumber, "rules", rules, "ingressPermissions", ingressPermissions, "egressPermissions", egressPermissions}), HashMap.class));
        }

        @Override
        public int compareTo(NetworkGroupNetworkView o) {
            return this.groupId == o.getGroupId() ? 0 : (this.groupId == null ? -1 : (o.getGroupId() == null ? 1 : this.groupId.compareTo(o.getGroupId())));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkGroupNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"groupId"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"groupId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"rules"), (Object)this)) {
                    int n4;
                    _result = n4 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"rules"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ingressPermissions"), (Object)this)) {
                    int n5;
                    _result = n5 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"ingressPermissions"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"egressPermissions"), (Object)this)) {
                    int n6;
                    _result = n6 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"egressPermissions"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(NetworkGroupNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            NetworkGroupNetworkView otherTyped = (NetworkGroupNetworkView)ScriptBytecodeAdapter.castToType((Object)other, NetworkGroupNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getGroupId(), (Object)otherTyped.getGroupId())) {
                if (DefaultGroovyMethods.is((Object)this.getGroupId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getGroupId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getGroupId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getGroupId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getGroupId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getGroupId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getGroupId(), (Object)otherTyped.getGroupId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                if (DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is(this.getRules(), otherTyped.getRules())) {
                if (DefaultGroovyMethods.is(this.getRules(), (Object)this) && !DefaultGroovyMethods.is(otherTyped.getRules(), (Object)otherTyped) || !DefaultGroovyMethods.is(this.getRules(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getRules(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is(this.getRules(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getRules(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual(this.getRules(), otherTyped.getRules())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is(this.getIngressPermissions(), otherTyped.getIngressPermissions())) {
                if (DefaultGroovyMethods.is(this.getIngressPermissions(), (Object)this) && !DefaultGroovyMethods.is(otherTyped.getIngressPermissions(), (Object)otherTyped) || !DefaultGroovyMethods.is(this.getIngressPermissions(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getIngressPermissions(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is(this.getIngressPermissions(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getIngressPermissions(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual(this.getIngressPermissions(), otherTyped.getIngressPermissions())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is(this.getEgressPermissions(), otherTyped.getEgressPermissions())) {
                if (DefaultGroovyMethods.is(this.getEgressPermissions(), (Object)this) && !DefaultGroovyMethods.is(otherTyped.getEgressPermissions(), (Object)otherTyped) || !DefaultGroovyMethods.is(this.getEgressPermissions(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getEgressPermissions(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is(this.getEgressPermissions(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getEgressPermissions(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual(this.getEgressPermissions(), otherTyped.getEgressPermissions())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$NetworkGroupNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"groupId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"groupId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"groupId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"rules") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl4;
                    $toStringFirst = bl4 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"rules"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"rules")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"ingressPermissions") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl5;
                    $toStringFirst = bl5 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ingressPermissions"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"ingressPermissions")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"egressPermissions") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl6;
                    $toStringFirst = bl6 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"egressPermissions"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"egressPermissions")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NetworkGroupNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, NetworkGroupNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(NetworkGroupNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(NetworkGroupNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, NetworkGroupNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(NetworkGroupNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            NetworkGroupNetworkView.__$swapInit();
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final String getOwnerAccountNumber() {
            return this.ownerAccountNumber;
        }

        public final List<String> getRules() {
            return this.rules;
        }

        public final List<IPPermissionNetworkView> getIngressPermissions() {
            return this.ingressPermissions;
        }

        public final List<IPPermissionNetworkView> getEgressPermissions() {
            return this.egressPermissions;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkGroupNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkGroupNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class NetworkGroupToNetworkGroupNetworkView
    extends Enum<NetworkGroupToNetworkGroupNetworkView>
    implements Function<NetworkGroup, NetworkGroupNetworkView>,
    GroovyObject {
        public static final /* enum */ NetworkGroupToNetworkGroupNetworkView INSTANCE;
        public static final NetworkGroupToNetworkGroupNetworkView MIN_VALUE;
        public static final NetworkGroupToNetworkGroupNetworkView MAX_VALUE;
        private static final /* synthetic */ NetworkGroupToNetworkGroupNetworkView[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkGroupToNetworkGroupNetworkView(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$NetworkGroupToNetworkGroupNetworkView was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public NetworkGroupToNetworkGroupNetworkView() {
            this(new LinkedHashMap());
        }

        public NetworkGroupNetworkView apply(NetworkGroup group) {
            return new NetworkGroupNetworkView(group.getGroupId(), group.getOwnerAccountNumber(), (List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.flatten((Collection)DefaultGroovyMethods.collect(group.getIngressNetworkRules(), (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(NetworkRule networkRule) {
                    return NetworkInfoBroadcaster.access$1(null, networkRule);
                }

                public Object call(NetworkRule networkRule) {
                    return this.doCall(networkRule);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _NetworkGroupToNetworkGroupNetworkView_apply_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _NetworkGroupToNetworkGroupNetworkView_apply_closure1.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_NetworkGroupToNetworkGroupNetworkView_apply_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _NetworkGroupToNetworkGroupNetworkView_apply_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            })), List.class), (List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.flatten((Collection)DefaultGroovyMethods.collect(group.getIngressNetworkRules(), (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(NetworkRule networkRule) {
                    return NetworkInfoBroadcaster.access$2(null, networkRule);
                }

                public Object call(NetworkRule networkRule) {
                    return this.doCall(networkRule);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _NetworkGroupToNetworkGroupNetworkView_apply_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _NetworkGroupToNetworkGroupNetworkView_apply_closure2.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_NetworkGroupToNetworkGroupNetworkView_apply_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _NetworkGroupToNetworkGroupNetworkView_apply_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            })), List.class), (List)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.flatten((Collection)DefaultGroovyMethods.collect(group.getEgressNetworkRules(), (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(NetworkRule networkRule) {
                    return NetworkInfoBroadcaster.access$2(null, networkRule);
                }

                public Object call(NetworkRule networkRule) {
                    return this.doCall(networkRule);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _NetworkGroupToNetworkGroupNetworkView_apply_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _NetworkGroupToNetworkGroupNetworkView_apply_closure3.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_NetworkGroupToNetworkGroupNetworkView_apply_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _NetworkGroupToNetworkGroupNetworkView_apply_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            })), List.class));
        }

        public static final NetworkGroupToNetworkGroupNetworkView[] values() {
            return (NetworkGroupToNetworkGroupNetworkView[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), NetworkGroupToNetworkGroupNetworkView[].class);
        }

        public /* synthetic */ NetworkGroupToNetworkGroupNetworkView next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (NetworkGroupToNetworkGroupNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), NetworkGroupToNetworkGroupNetworkView.class));
        }

        public /* synthetic */ NetworkGroupToNetworkGroupNetworkView previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (NetworkGroupToNetworkGroupNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), NetworkGroupToNetworkGroupNetworkView.class));
        }

        public static NetworkGroupToNetworkGroupNetworkView valueOf(String name) {
            return (NetworkGroupToNetworkGroupNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(NetworkGroupToNetworkGroupNetworkView.class, name)), NetworkGroupToNetworkGroupNetworkView.class));
        }

        public static final /* synthetic */ NetworkGroupToNetworkGroupNetworkView $INIT(Object ... para) {
            NetworkGroupToNetworkGroupNetworkView networkGroupToNetworkGroupNetworkView;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, NetworkGroupToNetworkGroupNetworkView.class)) {
                case -1348271900: {
                    NetworkGroupToNetworkGroupNetworkView networkGroupToNetworkGroupNetworkView2;
                    networkGroupToNetworkGroupNetworkView = networkGroupToNetworkGroupNetworkView2;
                    Object[] objectArray2 = objectArray;
                    networkGroupToNetworkGroupNetworkView2 = new NetworkGroupToNetworkGroupNetworkView();
                    break;
                }
                case -242181752: {
                    NetworkGroupToNetworkGroupNetworkView networkGroupToNetworkGroupNetworkView2;
                    networkGroupToNetworkGroupNetworkView = networkGroupToNetworkGroupNetworkView2;
                    Object[] objectArray2 = objectArray;
                    networkGroupToNetworkGroupNetworkView2 = new NetworkGroupToNetworkGroupNetworkView((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return networkGroupToNetworkGroupNetworkView;
        }

        static {
            NetworkGroupToNetworkGroupNetworkView networkGroupToNetworkGroupNetworkView;
            NetworkGroupToNetworkGroupNetworkView networkGroupToNetworkGroupNetworkView2;
            NetworkGroupToNetworkGroupNetworkView networkGroupToNetworkGroupNetworkView3;
            NetworkGroupToNetworkGroupNetworkView.__$swapInit();
            INSTANCE = networkGroupToNetworkGroupNetworkView3 = NetworkGroupToNetworkGroupNetworkView.$INIT("INSTANCE", 0);
            MIN_VALUE = networkGroupToNetworkGroupNetworkView2 = INSTANCE;
            MAX_VALUE = networkGroupToNetworkGroupNetworkView = INSTANCE;
            NetworkGroupToNetworkGroupNetworkView[] networkGroupToNetworkGroupNetworkViewArray = new NetworkGroupToNetworkGroupNetworkView[]{INSTANCE};
            $VALUES = networkGroupToNetworkGroupNetworkViewArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != NetworkGroupToNetworkGroupNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkGroupToNetworkGroupNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkGroupToNetworkGroupNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static final class VpcNetworkView
    implements Comparable<VpcNetworkView>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final String vpcId;
        private final String ownerAccountNumber;
        private final String cidr;
        private final String dhcpOptionSetId;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public VpcNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("vpcId") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.vpcId = (String)ScriptBytecodeAdapter.castToType(var3_3, String.class);
                    }
                } else {
                    Object v = args.get("vpcId");
                    this.vpcId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("ownerAccountNumber") == null) {
                    if (!(null == null)) {
                        Object var5_5 = null;
                        this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(var5_5, String.class);
                    }
                } else {
                    Object v = args.get("ownerAccountNumber");
                    this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("cidr") == null) {
                    if (!(null == null)) {
                        Object var7_7 = null;
                        this.cidr = (String)ScriptBytecodeAdapter.castToType(var7_7, String.class);
                    }
                } else {
                    Object v = args.get("cidr");
                    this.cidr = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("dhcpOptionSetId") == null) {
                    if (!(null == null)) {
                        Object var9_9 = null;
                        this.dhcpOptionSetId = (String)ScriptBytecodeAdapter.castToType(var9_9, String.class);
                    }
                } else {
                    Object v = args.get("dhcpOptionSetId");
                    this.dhcpOptionSetId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public VpcNetworkView(String vpcId, String ownerAccountNumber, String cidr, String dhcpOptionSetId) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"vpcId", vpcId, "ownerAccountNumber", ownerAccountNumber, "cidr", cidr, "dhcpOptionSetId", dhcpOptionSetId}), HashMap.class));
        }

        @Override
        public int compareTo(VpcNetworkView o) {
            return this.vpcId == o.getVpcId() ? 0 : (this.vpcId == null ? -1 : (o.getVpcId() == null ? 1 : this.vpcId.compareTo(o.getVpcId())));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != VpcNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"cidr"), (Object)this)) {
                    int n4;
                    _result = n4 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"cidr"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"dhcpOptionSetId"), (Object)this)) {
                    int n5;
                    _result = n5 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"dhcpOptionSetId"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(VpcNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            VpcNetworkView otherTyped = (VpcNetworkView)ScriptBytecodeAdapter.castToType((Object)other, VpcNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)otherTyped.getVpcId())) {
                if (DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getVpcId(), (Object)otherTyped.getVpcId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                if (DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getCidr(), (Object)otherTyped.getCidr())) {
                if (DefaultGroovyMethods.is((Object)this.getCidr(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getCidr(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getCidr(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getCidr(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getCidr(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getCidr(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getCidr(), (Object)otherTyped.getCidr())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getDhcpOptionSetId(), (Object)otherTyped.getDhcpOptionSetId())) {
                if (DefaultGroovyMethods.is((Object)this.getDhcpOptionSetId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getDhcpOptionSetId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getDhcpOptionSetId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getDhcpOptionSetId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getDhcpOptionSetId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getDhcpOptionSetId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getDhcpOptionSetId(), (Object)otherTyped.getDhcpOptionSetId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$VpcNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"vpcId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"cidr") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl4;
                    $toStringFirst = bl4 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"cidr"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"cidr")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"dhcpOptionSetId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl5;
                    $toStringFirst = bl5 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"dhcpOptionSetId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"dhcpOptionSetId")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(VpcNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, VpcNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(VpcNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(VpcNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, VpcNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(VpcNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            VpcNetworkView.__$swapInit();
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final String getOwnerAccountNumber() {
            return this.ownerAccountNumber;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final String getDhcpOptionSetId() {
            return this.dhcpOptionSetId;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(VpcNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = VpcNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class VpcToVpcNetworkView
    extends Enum<VpcToVpcNetworkView>
    implements Function<Vpc, VpcNetworkView>,
    GroovyObject {
        public static final /* enum */ VpcToVpcNetworkView INSTANCE;
        public static final VpcToVpcNetworkView MIN_VALUE;
        public static final VpcToVpcNetworkView MAX_VALUE;
        private static final /* synthetic */ VpcToVpcNetworkView[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public VpcToVpcNetworkView(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$VpcToVpcNetworkView was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public VpcToVpcNetworkView() {
            this(new LinkedHashMap());
        }

        public VpcNetworkView apply(Vpc vpc) {
            return new VpcNetworkView(vpc.getDisplayName(), vpc.getOwnerAccountNumber(), vpc.getCidr(), vpc.getDhcpOptionSet().getDisplayName());
        }

        public static final VpcToVpcNetworkView[] values() {
            return (VpcToVpcNetworkView[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), VpcToVpcNetworkView[].class);
        }

        public /* synthetic */ VpcToVpcNetworkView next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (VpcToVpcNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), VpcToVpcNetworkView.class));
        }

        public /* synthetic */ VpcToVpcNetworkView previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (VpcToVpcNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), VpcToVpcNetworkView.class));
        }

        public static VpcToVpcNetworkView valueOf(String name) {
            return (VpcToVpcNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(VpcToVpcNetworkView.class, name)), VpcToVpcNetworkView.class));
        }

        public static final /* synthetic */ VpcToVpcNetworkView $INIT(Object ... para) {
            VpcToVpcNetworkView vpcToVpcNetworkView;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, VpcToVpcNetworkView.class)) {
                case -1348271900: {
                    VpcToVpcNetworkView vpcToVpcNetworkView2;
                    vpcToVpcNetworkView = vpcToVpcNetworkView2;
                    Object[] objectArray2 = objectArray;
                    vpcToVpcNetworkView2 = new VpcToVpcNetworkView();
                    break;
                }
                case -242181752: {
                    VpcToVpcNetworkView vpcToVpcNetworkView2;
                    vpcToVpcNetworkView = vpcToVpcNetworkView2;
                    Object[] objectArray2 = objectArray;
                    vpcToVpcNetworkView2 = new VpcToVpcNetworkView((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return vpcToVpcNetworkView;
        }

        static {
            VpcToVpcNetworkView vpcToVpcNetworkView;
            VpcToVpcNetworkView vpcToVpcNetworkView2;
            VpcToVpcNetworkView vpcToVpcNetworkView3;
            VpcToVpcNetworkView.__$swapInit();
            INSTANCE = vpcToVpcNetworkView3 = VpcToVpcNetworkView.$INIT("INSTANCE", 0);
            MIN_VALUE = vpcToVpcNetworkView2 = INSTANCE;
            MAX_VALUE = vpcToVpcNetworkView = INSTANCE;
            VpcToVpcNetworkView[] vpcToVpcNetworkViewArray = new VpcToVpcNetworkView[]{INSTANCE};
            $VALUES = vpcToVpcNetworkViewArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != VpcToVpcNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(VpcToVpcNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = VpcToVpcNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static final class SubnetNetworkView
    implements Comparable<SubnetNetworkView>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final String subnetId;
        private final String ownerAccountNumber;
        private final String vpcId;
        private final String cidr;
        private final String availabilityZone;
        private final String networkAcl;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public SubnetNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("subnetId") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.subnetId = (String)ScriptBytecodeAdapter.castToType(var3_3, String.class);
                    }
                } else {
                    Object v = args.get("subnetId");
                    this.subnetId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("ownerAccountNumber") == null) {
                    if (!(null == null)) {
                        Object var5_5 = null;
                        this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(var5_5, String.class);
                    }
                } else {
                    Object v = args.get("ownerAccountNumber");
                    this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("vpcId") == null) {
                    if (!(null == null)) {
                        Object var7_7 = null;
                        this.vpcId = (String)ScriptBytecodeAdapter.castToType(var7_7, String.class);
                    }
                } else {
                    Object v = args.get("vpcId");
                    this.vpcId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("cidr") == null) {
                    if (!(null == null)) {
                        Object var9_9 = null;
                        this.cidr = (String)ScriptBytecodeAdapter.castToType(var9_9, String.class);
                    }
                } else {
                    Object v = args.get("cidr");
                    this.cidr = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("availabilityZone") == null) {
                    if (!(null == null)) {
                        Object var11_11 = null;
                        this.availabilityZone = (String)ScriptBytecodeAdapter.castToType(var11_11, String.class);
                    }
                } else {
                    Object v = args.get("availabilityZone");
                    this.availabilityZone = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("networkAcl") == null) {
                    if (!(null == null)) {
                        Object var13_13 = null;
                        this.networkAcl = (String)ScriptBytecodeAdapter.castToType(var13_13, String.class);
                    }
                } else {
                    Object v = args.get("networkAcl");
                    this.networkAcl = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public SubnetNetworkView(String subnetId, String ownerAccountNumber, String vpcId, String cidr, String availabilityZone, String networkAcl) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"subnetId", subnetId, "ownerAccountNumber", ownerAccountNumber, "vpcId", vpcId, "cidr", cidr, "availabilityZone", availabilityZone, "networkAcl", networkAcl}), HashMap.class));
        }

        @Override
        public int compareTo(SubnetNetworkView o) {
            return this.subnetId == o.getSubnetId() ? 0 : (this.subnetId == null ? -1 : (o.getSubnetId() == null ? 1 : this.subnetId.compareTo(o.getSubnetId())));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != SubnetNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"subnetId"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"subnetId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"), (Object)this)) {
                    int n4;
                    _result = n4 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"cidr"), (Object)this)) {
                    int n5;
                    _result = n5 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"cidr"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"availabilityZone"), (Object)this)) {
                    int n6;
                    _result = n6 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"availabilityZone"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"networkAcl"), (Object)this)) {
                    int n7;
                    _result = n7 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"networkAcl"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(SubnetNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            SubnetNetworkView otherTyped = (SubnetNetworkView)ScriptBytecodeAdapter.castToType((Object)other, SubnetNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getSubnetId(), (Object)otherTyped.getSubnetId())) {
                if (DefaultGroovyMethods.is((Object)this.getSubnetId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getSubnetId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getSubnetId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getSubnetId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getSubnetId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getSubnetId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getSubnetId(), (Object)otherTyped.getSubnetId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                if (DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)otherTyped.getVpcId())) {
                if (DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getVpcId(), (Object)otherTyped.getVpcId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getCidr(), (Object)otherTyped.getCidr())) {
                if (DefaultGroovyMethods.is((Object)this.getCidr(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getCidr(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getCidr(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getCidr(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getCidr(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getCidr(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getCidr(), (Object)otherTyped.getCidr())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getAvailabilityZone(), (Object)otherTyped.getAvailabilityZone())) {
                if (DefaultGroovyMethods.is((Object)this.getAvailabilityZone(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getAvailabilityZone(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getAvailabilityZone(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getAvailabilityZone(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getAvailabilityZone(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getAvailabilityZone(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getAvailabilityZone(), (Object)otherTyped.getAvailabilityZone())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getNetworkAcl(), (Object)otherTyped.getNetworkAcl())) {
                if (DefaultGroovyMethods.is((Object)this.getNetworkAcl(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getNetworkAcl(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getNetworkAcl(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getNetworkAcl(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getNetworkAcl(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getNetworkAcl(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getNetworkAcl(), (Object)otherTyped.getNetworkAcl())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$SubnetNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"subnetId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"subnetId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"subnetId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"vpcId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl4;
                    $toStringFirst = bl4 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"cidr") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl5;
                    $toStringFirst = bl5 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"cidr"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"cidr")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"availabilityZone") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl6;
                    $toStringFirst = bl6 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"availabilityZone"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"availabilityZone")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"networkAcl") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl7;
                    $toStringFirst = bl7 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"networkAcl"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"networkAcl")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SubnetNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, SubnetNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(SubnetNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(SubnetNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, SubnetNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(SubnetNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            SubnetNetworkView.__$swapInit();
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final String getOwnerAccountNumber() {
            return this.ownerAccountNumber;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final String getNetworkAcl() {
            return this.networkAcl;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(SubnetNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = SubnetNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class SubnetToSubnetNetworkView
    extends Enum<SubnetToSubnetNetworkView>
    implements Function<com.eucalyptus.compute.vpc.Subnet, SubnetNetworkView>,
    GroovyObject {
        public static final /* enum */ SubnetToSubnetNetworkView INSTANCE;
        public static final SubnetToSubnetNetworkView MIN_VALUE;
        public static final SubnetToSubnetNetworkView MAX_VALUE;
        private static final /* synthetic */ SubnetToSubnetNetworkView[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public SubnetToSubnetNetworkView(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$SubnetToSubnetNetworkView was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public SubnetToSubnetNetworkView() {
            this(new LinkedHashMap());
        }

        public SubnetNetworkView apply(com.eucalyptus.compute.vpc.Subnet subnet) {
            return new SubnetNetworkView(subnet.getDisplayName(), subnet.getOwnerAccountNumber(), subnet.getVpc().getDisplayName(), subnet.getCidr(), subnet.getAvailabilityZone(), subnet.getNetworkAcl().getDisplayName());
        }

        public static final SubnetToSubnetNetworkView[] values() {
            return (SubnetToSubnetNetworkView[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), SubnetToSubnetNetworkView[].class);
        }

        public /* synthetic */ SubnetToSubnetNetworkView next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (SubnetToSubnetNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), SubnetToSubnetNetworkView.class));
        }

        public /* synthetic */ SubnetToSubnetNetworkView previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (SubnetToSubnetNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), SubnetToSubnetNetworkView.class));
        }

        public static SubnetToSubnetNetworkView valueOf(String name) {
            return (SubnetToSubnetNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(SubnetToSubnetNetworkView.class, name)), SubnetToSubnetNetworkView.class));
        }

        public static final /* synthetic */ SubnetToSubnetNetworkView $INIT(Object ... para) {
            SubnetToSubnetNetworkView subnetToSubnetNetworkView;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, SubnetToSubnetNetworkView.class)) {
                case -1348271900: {
                    SubnetToSubnetNetworkView subnetToSubnetNetworkView2;
                    subnetToSubnetNetworkView = subnetToSubnetNetworkView2;
                    Object[] objectArray2 = objectArray;
                    subnetToSubnetNetworkView2 = new SubnetToSubnetNetworkView();
                    break;
                }
                case -242181752: {
                    SubnetToSubnetNetworkView subnetToSubnetNetworkView2;
                    subnetToSubnetNetworkView = subnetToSubnetNetworkView2;
                    Object[] objectArray2 = objectArray;
                    subnetToSubnetNetworkView2 = new SubnetToSubnetNetworkView((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return subnetToSubnetNetworkView;
        }

        static {
            SubnetToSubnetNetworkView subnetToSubnetNetworkView;
            SubnetToSubnetNetworkView subnetToSubnetNetworkView2;
            SubnetToSubnetNetworkView subnetToSubnetNetworkView3;
            SubnetToSubnetNetworkView.__$swapInit();
            INSTANCE = subnetToSubnetNetworkView3 = SubnetToSubnetNetworkView.$INIT("INSTANCE", 0);
            MIN_VALUE = subnetToSubnetNetworkView2 = INSTANCE;
            MAX_VALUE = subnetToSubnetNetworkView = INSTANCE;
            SubnetToSubnetNetworkView[] subnetToSubnetNetworkViewArray = new SubnetToSubnetNetworkView[]{INSTANCE};
            $VALUES = subnetToSubnetNetworkViewArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != SubnetToSubnetNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(SubnetToSubnetNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = SubnetToSubnetNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static final class DhcpOptionSetNetworkView
    implements Comparable<DhcpOptionSetNetworkView>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final String dhcpOptionSetId;
        private final String ownerAccountNumber;
        private final List<DhcpOptionNetworkView> options;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public DhcpOptionSetNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("dhcpOptionSetId") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.dhcpOptionSetId = (String)ScriptBytecodeAdapter.castToType(var3_3, String.class);
                    }
                } else {
                    Object v = args.get("dhcpOptionSetId");
                    this.dhcpOptionSetId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("ownerAccountNumber") == null) {
                    if (!(null == null)) {
                        Object var5_5 = null;
                        this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(var5_5, String.class);
                    }
                } else {
                    Object v = args.get("ownerAccountNumber");
                    this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("options") == null) {
                    if (!(null == null)) {
                        SortedSet sortedSet = null instanceof SortedSet ? DefaultGroovyMethods.asImmutable(null) : (null instanceof SortedMap ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Set ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Map ? DefaultGroovyMethods.asImmutable(null) : (null instanceof List ? DefaultGroovyMethods.asImmutable(null) : DefaultGroovyMethods.asImmutable(null)))));
                        this.options = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                    }
                } else if (args.get("options") instanceof Cloneable) {
                    SortedSet sortedSet = (List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("options"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("options"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedSet.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("options"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("options"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedMap.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("options"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("options"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Set.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("options"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("options"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Map.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("options"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("options"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("options"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)))))));
                    this.options = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                } else {
                    SortedSet sortedSet = args.get("options") instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType(args.get("options"), SortedSet.class))) : (args.get("options") instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType(args.get("options"), SortedMap.class))) : (args.get("options") instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType(args.get("options"), Set.class))) : (args.get("options") instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType(args.get("options"), Map.class))) : (args.get("options") instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType(args.get("options"), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((Collection)ScriptBytecodeAdapter.castToType(args.get("options"), Collection.class)))))));
                    this.options = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public DhcpOptionSetNetworkView(String dhcpOptionSetId, String ownerAccountNumber, List<DhcpOptionNetworkView> options) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"dhcpOptionSetId", dhcpOptionSetId, "ownerAccountNumber", ownerAccountNumber, "options", options}), HashMap.class));
        }

        @Override
        public int compareTo(DhcpOptionSetNetworkView o) {
            return this.dhcpOptionSetId == o.getDhcpOptionSetId() ? 0 : (this.dhcpOptionSetId == null ? -1 : (o.getDhcpOptionSetId() == null ? 1 : this.dhcpOptionSetId.compareTo(o.getDhcpOptionSetId())));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != DhcpOptionSetNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"dhcpOptionSetId"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"dhcpOptionSetId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"options"), (Object)this)) {
                    int n4;
                    _result = n4 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"options"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(DhcpOptionSetNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            DhcpOptionSetNetworkView otherTyped = (DhcpOptionSetNetworkView)ScriptBytecodeAdapter.castToType((Object)other, DhcpOptionSetNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getDhcpOptionSetId(), (Object)otherTyped.getDhcpOptionSetId())) {
                if (DefaultGroovyMethods.is((Object)this.getDhcpOptionSetId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getDhcpOptionSetId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getDhcpOptionSetId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getDhcpOptionSetId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getDhcpOptionSetId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getDhcpOptionSetId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getDhcpOptionSetId(), (Object)otherTyped.getDhcpOptionSetId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                if (DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is(this.getOptions(), otherTyped.getOptions())) {
                if (DefaultGroovyMethods.is(this.getOptions(), (Object)this) && !DefaultGroovyMethods.is(otherTyped.getOptions(), (Object)otherTyped) || !DefaultGroovyMethods.is(this.getOptions(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getOptions(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is(this.getOptions(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getOptions(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual(this.getOptions(), otherTyped.getOptions())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$DhcpOptionSetNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"dhcpOptionSetId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"dhcpOptionSetId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"dhcpOptionSetId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"options") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl4;
                    $toStringFirst = bl4 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"options"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"options")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DhcpOptionSetNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, DhcpOptionSetNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(DhcpOptionSetNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DhcpOptionSetNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, DhcpOptionSetNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(DhcpOptionSetNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            DhcpOptionSetNetworkView.__$swapInit();
        }

        public final String getDhcpOptionSetId() {
            return this.dhcpOptionSetId;
        }

        public final String getOwnerAccountNumber() {
            return this.ownerAccountNumber;
        }

        public final List<DhcpOptionNetworkView> getOptions() {
            return this.options;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(DhcpOptionSetNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = DhcpOptionSetNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static final class DhcpOptionNetworkView
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final String key;
        private final List<String> values;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public DhcpOptionNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("key") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.key = (String)ScriptBytecodeAdapter.castToType(var3_3, String.class);
                    }
                } else {
                    Object v = args.get("key");
                    this.key = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("values") == null) {
                    if (!(null == null)) {
                        SortedSet sortedSet = null instanceof SortedSet ? DefaultGroovyMethods.asImmutable(null) : (null instanceof SortedMap ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Set ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Map ? DefaultGroovyMethods.asImmutable(null) : (null instanceof List ? DefaultGroovyMethods.asImmutable(null) : DefaultGroovyMethods.asImmutable(null)))));
                        this.values = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                    }
                } else if (args.get("values") instanceof Cloneable) {
                    SortedSet sortedSet = (List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("values"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("values"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedSet.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("values"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("values"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedMap.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("values"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("values"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Set.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("values"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("values"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Map.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("values"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("values"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("values"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)))))));
                    this.values = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                } else {
                    SortedSet sortedSet = args.get("values") instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType(args.get("values"), SortedSet.class))) : (args.get("values") instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType(args.get("values"), SortedMap.class))) : (args.get("values") instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType(args.get("values"), Set.class))) : (args.get("values") instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType(args.get("values"), Map.class))) : (args.get("values") instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType(args.get("values"), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((Collection)ScriptBytecodeAdapter.castToType(args.get("values"), Collection.class)))))));
                    this.values = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public DhcpOptionNetworkView(String key, List<String> values) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", key, "values", values}), HashMap.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != DhcpOptionNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"key"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"key"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"values"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"values"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(DhcpOptionNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            DhcpOptionNetworkView otherTyped = (DhcpOptionNetworkView)ScriptBytecodeAdapter.castToType((Object)other, DhcpOptionNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getKey(), (Object)otherTyped.getKey())) {
                if (DefaultGroovyMethods.is((Object)this.getKey(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getKey(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getKey(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getKey(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getKey(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getKey(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getKey(), (Object)otherTyped.getKey())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is(this.getValues(), otherTyped.getValues())) {
                if (DefaultGroovyMethods.is(this.getValues(), (Object)this) && !DefaultGroovyMethods.is(otherTyped.getValues(), (Object)otherTyped) || !DefaultGroovyMethods.is(this.getValues(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getValues(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is(this.getValues(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getValues(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual(this.getValues(), otherTyped.getValues())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$DhcpOptionNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"key") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"key"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"key")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"values") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"values"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"values")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DhcpOptionNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, DhcpOptionNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(DhcpOptionNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DhcpOptionNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, DhcpOptionNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(DhcpOptionNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            DhcpOptionNetworkView.__$swapInit();
        }

        public final String getKey() {
            return this.key;
        }

        public final List<String> getValues() {
            return this.values;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(DhcpOptionNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = DhcpOptionNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class DhcpOptionSetToDhcpOptionSetNetworkView
    extends Enum<DhcpOptionSetToDhcpOptionSetNetworkView>
    implements Function<DhcpOptionSet, DhcpOptionSetNetworkView>,
    GroovyObject {
        public static final /* enum */ DhcpOptionSetToDhcpOptionSetNetworkView INSTANCE;
        public static final DhcpOptionSetToDhcpOptionSetNetworkView MIN_VALUE;
        public static final DhcpOptionSetToDhcpOptionSetNetworkView MAX_VALUE;
        private static final /* synthetic */ DhcpOptionSetToDhcpOptionSetNetworkView[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public DhcpOptionSetToDhcpOptionSetNetworkView(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$DhcpOptionSetToDhcpOptionSetNetworkView was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public DhcpOptionSetToDhcpOptionSetNetworkView() {
            this(new LinkedHashMap());
        }

        public DhcpOptionSetNetworkView apply(DhcpOptionSet dhcpOptionSet) {
            return new DhcpOptionSetNetworkView(dhcpOptionSet.getDisplayName(), dhcpOptionSet.getOwnerAccountNumber(), (List<DhcpOptionNetworkView>)ImmutableList.copyOf((Collection)DefaultGroovyMethods.collect(dhcpOptionSet.getDhcpOptions(), (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(DhcpOption option) {
                    return new DhcpOptionNetworkView(option.getKey(), (List<String>)ImmutableList.copyOf(option.getValues()));
                }

                public Object call(DhcpOption option) {
                    return this.doCall(option);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _DhcpOptionSetToDhcpOptionSetNetworkView_apply_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _DhcpOptionSetToDhcpOptionSetNetworkView_apply_closure1.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_DhcpOptionSetToDhcpOptionSetNetworkView_apply_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _DhcpOptionSetToDhcpOptionSetNetworkView_apply_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            })));
        }

        public static final DhcpOptionSetToDhcpOptionSetNetworkView[] values() {
            return (DhcpOptionSetToDhcpOptionSetNetworkView[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), DhcpOptionSetToDhcpOptionSetNetworkView[].class);
        }

        public /* synthetic */ DhcpOptionSetToDhcpOptionSetNetworkView next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (DhcpOptionSetToDhcpOptionSetNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), DhcpOptionSetToDhcpOptionSetNetworkView.class));
        }

        public /* synthetic */ DhcpOptionSetToDhcpOptionSetNetworkView previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (DhcpOptionSetToDhcpOptionSetNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), DhcpOptionSetToDhcpOptionSetNetworkView.class));
        }

        public static DhcpOptionSetToDhcpOptionSetNetworkView valueOf(String name) {
            return (DhcpOptionSetToDhcpOptionSetNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(DhcpOptionSetToDhcpOptionSetNetworkView.class, name)), DhcpOptionSetToDhcpOptionSetNetworkView.class));
        }

        public static final /* synthetic */ DhcpOptionSetToDhcpOptionSetNetworkView $INIT(Object ... para) {
            DhcpOptionSetToDhcpOptionSetNetworkView dhcpOptionSetToDhcpOptionSetNetworkView;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, DhcpOptionSetToDhcpOptionSetNetworkView.class)) {
                case -1348271900: {
                    DhcpOptionSetToDhcpOptionSetNetworkView dhcpOptionSetToDhcpOptionSetNetworkView2;
                    dhcpOptionSetToDhcpOptionSetNetworkView = dhcpOptionSetToDhcpOptionSetNetworkView2;
                    Object[] objectArray2 = objectArray;
                    dhcpOptionSetToDhcpOptionSetNetworkView2 = new DhcpOptionSetToDhcpOptionSetNetworkView();
                    break;
                }
                case -242181752: {
                    DhcpOptionSetToDhcpOptionSetNetworkView dhcpOptionSetToDhcpOptionSetNetworkView2;
                    dhcpOptionSetToDhcpOptionSetNetworkView = dhcpOptionSetToDhcpOptionSetNetworkView2;
                    Object[] objectArray2 = objectArray;
                    dhcpOptionSetToDhcpOptionSetNetworkView2 = new DhcpOptionSetToDhcpOptionSetNetworkView((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return dhcpOptionSetToDhcpOptionSetNetworkView;
        }

        static {
            DhcpOptionSetToDhcpOptionSetNetworkView dhcpOptionSetToDhcpOptionSetNetworkView;
            DhcpOptionSetToDhcpOptionSetNetworkView dhcpOptionSetToDhcpOptionSetNetworkView2;
            DhcpOptionSetToDhcpOptionSetNetworkView dhcpOptionSetToDhcpOptionSetNetworkView3;
            DhcpOptionSetToDhcpOptionSetNetworkView.__$swapInit();
            INSTANCE = dhcpOptionSetToDhcpOptionSetNetworkView3 = DhcpOptionSetToDhcpOptionSetNetworkView.$INIT("INSTANCE", 0);
            MIN_VALUE = dhcpOptionSetToDhcpOptionSetNetworkView2 = INSTANCE;
            MAX_VALUE = dhcpOptionSetToDhcpOptionSetNetworkView = INSTANCE;
            DhcpOptionSetToDhcpOptionSetNetworkView[] dhcpOptionSetToDhcpOptionSetNetworkViewArray = new DhcpOptionSetToDhcpOptionSetNetworkView[]{INSTANCE};
            $VALUES = dhcpOptionSetToDhcpOptionSetNetworkViewArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != DhcpOptionSetToDhcpOptionSetNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(DhcpOptionSetToDhcpOptionSetNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = DhcpOptionSetToDhcpOptionSetNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static final class NetworkAclNetworkView
    implements Comparable<NetworkAclNetworkView>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final String networkAclId;
        private final String ownerAccountNumber;
        private final String vpcId;
        private final List<NetworkAclEntryNetworkView> ingressRules;
        private final List<NetworkAclEntryNetworkView> egressRules;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public NetworkAclNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("networkAclId") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.networkAclId = (String)ScriptBytecodeAdapter.castToType(var3_3, String.class);
                    }
                } else {
                    Object v = args.get("networkAclId");
                    this.networkAclId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("ownerAccountNumber") == null) {
                    if (!(null == null)) {
                        Object var5_5 = null;
                        this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(var5_5, String.class);
                    }
                } else {
                    Object v = args.get("ownerAccountNumber");
                    this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("vpcId") == null) {
                    if (!(null == null)) {
                        Object var7_7 = null;
                        this.vpcId = (String)ScriptBytecodeAdapter.castToType(var7_7, String.class);
                    }
                } else {
                    Object v = args.get("vpcId");
                    this.vpcId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("ingressRules") == null) {
                    if (!(null == null)) {
                        SortedSet sortedSet = null instanceof SortedSet ? DefaultGroovyMethods.asImmutable(null) : (null instanceof SortedMap ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Set ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Map ? DefaultGroovyMethods.asImmutable(null) : (null instanceof List ? DefaultGroovyMethods.asImmutable(null) : DefaultGroovyMethods.asImmutable(null)))));
                        this.ingressRules = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                    }
                } else if (args.get("ingressRules") instanceof Cloneable) {
                    SortedSet sortedSet = (List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedSet.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedMap.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Set.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Map.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("ingressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)))))));
                    this.ingressRules = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                } else {
                    SortedSet sortedSet = args.get("ingressRules") instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType(args.get("ingressRules"), SortedSet.class))) : (args.get("ingressRules") instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType(args.get("ingressRules"), SortedMap.class))) : (args.get("ingressRules") instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType(args.get("ingressRules"), Set.class))) : (args.get("ingressRules") instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType(args.get("ingressRules"), Map.class))) : (args.get("ingressRules") instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType(args.get("ingressRules"), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((Collection)ScriptBytecodeAdapter.castToType(args.get("ingressRules"), Collection.class)))))));
                    this.ingressRules = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                }
                if (args.get("egressRules") == null) {
                    if (!(null == null)) {
                        SortedSet sortedSet = null instanceof SortedSet ? DefaultGroovyMethods.asImmutable(null) : (null instanceof SortedMap ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Set ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Map ? DefaultGroovyMethods.asImmutable(null) : (null instanceof List ? DefaultGroovyMethods.asImmutable(null) : DefaultGroovyMethods.asImmutable(null)))));
                        this.egressRules = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                    }
                } else if (args.get("egressRules") instanceof Cloneable) {
                    SortedSet sortedSet = (List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedSet.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedMap.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Set.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Map.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("egressRules"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)))))));
                    this.egressRules = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                } else {
                    SortedSet sortedSet = args.get("egressRules") instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType(args.get("egressRules"), SortedSet.class))) : (args.get("egressRules") instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType(args.get("egressRules"), SortedMap.class))) : (args.get("egressRules") instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType(args.get("egressRules"), Set.class))) : (args.get("egressRules") instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType(args.get("egressRules"), Map.class))) : (args.get("egressRules") instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType(args.get("egressRules"), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((Collection)ScriptBytecodeAdapter.castToType(args.get("egressRules"), Collection.class)))))));
                    this.egressRules = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public NetworkAclNetworkView(String networkAclId, String ownerAccountNumber, String vpcId, List<NetworkAclEntryNetworkView> ingressRules, List<NetworkAclEntryNetworkView> egressRules) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"networkAclId", networkAclId, "ownerAccountNumber", ownerAccountNumber, "vpcId", vpcId, "ingressRules", ingressRules, "egressRules", egressRules}), HashMap.class));
        }

        @Override
        public int compareTo(NetworkAclNetworkView o) {
            return this.networkAclId == o.getNetworkAclId() ? 0 : (this.networkAclId == null ? -1 : (o.getNetworkAclId() == null ? 1 : this.networkAclId.compareTo(o.getNetworkAclId())));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkAclNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"networkAclId"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"networkAclId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"), (Object)this)) {
                    int n4;
                    _result = n4 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ingressRules"), (Object)this)) {
                    int n5;
                    _result = n5 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"ingressRules"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"egressRules"), (Object)this)) {
                    int n6;
                    _result = n6 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"egressRules"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(NetworkAclNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            NetworkAclNetworkView otherTyped = (NetworkAclNetworkView)ScriptBytecodeAdapter.castToType((Object)other, NetworkAclNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getNetworkAclId(), (Object)otherTyped.getNetworkAclId())) {
                if (DefaultGroovyMethods.is((Object)this.getNetworkAclId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getNetworkAclId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getNetworkAclId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getNetworkAclId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getNetworkAclId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getNetworkAclId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getNetworkAclId(), (Object)otherTyped.getNetworkAclId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                if (DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)otherTyped.getVpcId())) {
                if (DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getVpcId(), (Object)otherTyped.getVpcId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is(this.getIngressRules(), otherTyped.getIngressRules())) {
                if (DefaultGroovyMethods.is(this.getIngressRules(), (Object)this) && !DefaultGroovyMethods.is(otherTyped.getIngressRules(), (Object)otherTyped) || !DefaultGroovyMethods.is(this.getIngressRules(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getIngressRules(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is(this.getIngressRules(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getIngressRules(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual(this.getIngressRules(), otherTyped.getIngressRules())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is(this.getEgressRules(), otherTyped.getEgressRules())) {
                if (DefaultGroovyMethods.is(this.getEgressRules(), (Object)this) && !DefaultGroovyMethods.is(otherTyped.getEgressRules(), (Object)otherTyped) || !DefaultGroovyMethods.is(this.getEgressRules(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getEgressRules(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is(this.getEgressRules(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getEgressRules(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual(this.getEgressRules(), otherTyped.getEgressRules())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$NetworkAclNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"networkAclId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"networkAclId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"networkAclId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"vpcId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl4;
                    $toStringFirst = bl4 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"ingressRules") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl5;
                    $toStringFirst = bl5 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ingressRules"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"ingressRules")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"egressRules") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl6;
                    $toStringFirst = bl6 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"egressRules"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"egressRules")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NetworkAclNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, NetworkAclNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(NetworkAclNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(NetworkAclNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, NetworkAclNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(NetworkAclNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            NetworkAclNetworkView.__$swapInit();
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        public final String getOwnerAccountNumber() {
            return this.ownerAccountNumber;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final List<NetworkAclEntryNetworkView> getIngressRules() {
            return this.ingressRules;
        }

        public final List<NetworkAclEntryNetworkView> getEgressRules() {
            return this.egressRules;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkAclNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkAclNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    @Immutable
    public static final class NetworkAclEntryNetworkView
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final Integer number;
        private final Integer protocol;
        private final String action;
        private final String cidr;
        private final Integer icmpCode;
        private final Integer icmpType;
        private final Integer portRangeFrom;
        private final Integer portRangeTo;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public NetworkAclEntryNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("number") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.number = (Integer)ScriptBytecodeAdapter.castToType(var3_3, Integer.class);
                    }
                } else {
                    Object v = args.get("number");
                    this.number = (Integer)ScriptBytecodeAdapter.castToType(v, Integer.class);
                }
                if (args.get("protocol") == null) {
                    if (!(null == null)) {
                        Object var5_5 = null;
                        this.protocol = (Integer)ScriptBytecodeAdapter.castToType(var5_5, Integer.class);
                    }
                } else {
                    Object v = args.get("protocol");
                    this.protocol = (Integer)ScriptBytecodeAdapter.castToType(v, Integer.class);
                }
                if (args.get("action") == null) {
                    if (!(null == null)) {
                        Object var7_7 = null;
                        this.action = (String)ScriptBytecodeAdapter.castToType(var7_7, String.class);
                    }
                } else {
                    Object v = args.get("action");
                    this.action = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("cidr") == null) {
                    if (!(null == null)) {
                        Object var9_9 = null;
                        this.cidr = (String)ScriptBytecodeAdapter.castToType(var9_9, String.class);
                    }
                } else {
                    Object v = args.get("cidr");
                    this.cidr = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("icmpCode") == null) {
                    if (!(null == null)) {
                        Object var11_11 = null;
                        this.icmpCode = (Integer)ScriptBytecodeAdapter.castToType(var11_11, Integer.class);
                    }
                } else {
                    Object v = args.get("icmpCode");
                    this.icmpCode = (Integer)ScriptBytecodeAdapter.castToType(v, Integer.class);
                }
                if (args.get("icmpType") == null) {
                    if (!(null == null)) {
                        Object var13_13 = null;
                        this.icmpType = (Integer)ScriptBytecodeAdapter.castToType(var13_13, Integer.class);
                    }
                } else {
                    Object v = args.get("icmpType");
                    this.icmpType = (Integer)ScriptBytecodeAdapter.castToType(v, Integer.class);
                }
                if (args.get("portRangeFrom") == null) {
                    if (!(null == null)) {
                        Object var15_15 = null;
                        this.portRangeFrom = (Integer)ScriptBytecodeAdapter.castToType(var15_15, Integer.class);
                    }
                } else {
                    Object v = args.get("portRangeFrom");
                    this.portRangeFrom = (Integer)ScriptBytecodeAdapter.castToType(v, Integer.class);
                }
                if (args.get("portRangeTo") == null) {
                    if (!(null == null)) {
                        Object var17_17 = null;
                        this.portRangeTo = (Integer)ScriptBytecodeAdapter.castToType(var17_17, Integer.class);
                    }
                } else {
                    Object v = args.get("portRangeTo");
                    this.portRangeTo = (Integer)ScriptBytecodeAdapter.castToType(v, Integer.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public NetworkAclEntryNetworkView(Integer number, Integer protocol, String action, String cidr, Integer icmpCode, Integer icmpType, Integer portRangeFrom, Integer portRangeTo) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"number", number, "protocol", protocol, "action", action, "cidr", cidr, "icmpCode", icmpCode, "icmpType", icmpType, "portRangeFrom", portRangeFrom, "portRangeTo", portRangeTo}), HashMap.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkAclEntryNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"number"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"number"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"protocol"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"protocol"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"action"), (Object)this)) {
                    int n4;
                    _result = n4 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"action"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"cidr"), (Object)this)) {
                    int n5;
                    _result = n5 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"cidr"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"icmpCode"), (Object)this)) {
                    int n6;
                    _result = n6 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"icmpCode"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"icmpType"), (Object)this)) {
                    int n7;
                    _result = n7 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"icmpType"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"portRangeFrom"), (Object)this)) {
                    int n8;
                    _result = n8 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"portRangeFrom"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"portRangeTo"), (Object)this)) {
                    int n9;
                    _result = n9 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"portRangeTo"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(NetworkAclEntryNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            NetworkAclEntryNetworkView otherTyped = (NetworkAclEntryNetworkView)ScriptBytecodeAdapter.castToType((Object)other, NetworkAclEntryNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getNumber(), (Object)otherTyped.getNumber())) {
                if (DefaultGroovyMethods.is((Object)this.getNumber(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getNumber(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getNumber(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getNumber(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getNumber(), (Object)otherTyped.getNumber())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getProtocol(), (Object)otherTyped.getProtocol())) {
                if (DefaultGroovyMethods.is((Object)this.getProtocol(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getProtocol(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getProtocol(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getProtocol(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getProtocol(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getProtocol(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getProtocol(), (Object)otherTyped.getProtocol())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getAction(), (Object)otherTyped.getAction())) {
                if (DefaultGroovyMethods.is((Object)this.getAction(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getAction(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getAction(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getAction(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getAction(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getAction(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getAction(), (Object)otherTyped.getAction())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getCidr(), (Object)otherTyped.getCidr())) {
                if (DefaultGroovyMethods.is((Object)this.getCidr(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getCidr(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getCidr(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getCidr(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getCidr(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getCidr(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getCidr(), (Object)otherTyped.getCidr())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getIcmpCode(), (Object)otherTyped.getIcmpCode())) {
                if (DefaultGroovyMethods.is((Object)this.getIcmpCode(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getIcmpCode(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getIcmpCode(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getIcmpCode(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getIcmpCode(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getIcmpCode(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getIcmpCode(), (Object)otherTyped.getIcmpCode())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getIcmpType(), (Object)otherTyped.getIcmpType())) {
                if (DefaultGroovyMethods.is((Object)this.getIcmpType(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getIcmpType(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getIcmpType(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getIcmpType(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getIcmpType(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getIcmpType(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getIcmpType(), (Object)otherTyped.getIcmpType())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getPortRangeFrom(), (Object)otherTyped.getPortRangeFrom())) {
                if (DefaultGroovyMethods.is((Object)this.getPortRangeFrom(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getPortRangeFrom(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getPortRangeFrom(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPortRangeFrom(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getPortRangeFrom(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPortRangeFrom(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getPortRangeFrom(), (Object)otherTyped.getPortRangeFrom())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getPortRangeTo(), (Object)otherTyped.getPortRangeTo())) {
                if (DefaultGroovyMethods.is((Object)this.getPortRangeTo(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getPortRangeTo(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getPortRangeTo(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPortRangeTo(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getPortRangeTo(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPortRangeTo(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getPortRangeTo(), (Object)otherTyped.getPortRangeTo())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$NetworkAclEntryNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"number") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"number"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"number")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"protocol") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"protocol"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"protocol")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"action") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl4;
                    $toStringFirst = bl4 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"action"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"action")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"cidr") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl5;
                    $toStringFirst = bl5 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"cidr"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"cidr")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"icmpCode") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl6;
                    $toStringFirst = bl6 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"icmpCode"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"icmpCode")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"icmpType") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl7;
                    $toStringFirst = bl7 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"icmpType"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"icmpType")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"portRangeFrom") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl8;
                    $toStringFirst = bl8 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"portRangeFrom"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"portRangeFrom")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"portRangeTo") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl9;
                    $toStringFirst = bl9 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"portRangeTo"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"portRangeTo")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NetworkAclEntryNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, NetworkAclEntryNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(NetworkAclEntryNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(NetworkAclEntryNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, NetworkAclEntryNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(NetworkAclEntryNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            NetworkAclEntryNetworkView.__$swapInit();
        }

        public final Integer getNumber() {
            return this.number;
        }

        public final Integer getProtocol() {
            return this.protocol;
        }

        public final String getAction() {
            return this.action;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final Integer getIcmpCode() {
            return this.icmpCode;
        }

        public final Integer getIcmpType() {
            return this.icmpType;
        }

        public final Integer getPortRangeFrom() {
            return this.portRangeFrom;
        }

        public final Integer getPortRangeTo() {
            return this.portRangeTo;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkAclEntryNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkAclEntryNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class NetworkAclToNetworkAclNetworkView
    extends Enum<NetworkAclToNetworkAclNetworkView>
    implements Function<NetworkAcl, NetworkAclNetworkView>,
    GroovyObject {
        public static final /* enum */ NetworkAclToNetworkAclNetworkView INSTANCE;
        public static final NetworkAclToNetworkAclNetworkView MIN_VALUE;
        public static final NetworkAclToNetworkAclNetworkView MAX_VALUE;
        private static final /* synthetic */ NetworkAclToNetworkAclNetworkView[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkAclToNetworkAclNetworkView(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$NetworkAclToNetworkAclNetworkView was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public NetworkAclToNetworkAclNetworkView() {
            this(new LinkedHashMap());
        }

        public NetworkAclNetworkView apply(NetworkAcl networkAcl) {
            List orderedEntries = NetworkAcls.ENTRY_ORDERING.sortedCopy(networkAcl.getEntries());
            return new NetworkAclNetworkView(networkAcl.getDisplayName(), networkAcl.getOwnerAccountNumber(), networkAcl.getVpc().getDisplayName(), (List<NetworkAclEntryNetworkView>)ImmutableList.copyOf((Collection)DefaultGroovyMethods.collect((Collection)DefaultGroovyMethods.findAll((Collection)orderedEntries, (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(NetworkAclEntry entry) {
                    return !DefaultTypeTransformation.booleanUnbox((Object)entry.getEgress());
                }

                public Object call(NetworkAclEntry entry) {
                    return this.doCall(entry);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _NetworkAclToNetworkAclNetworkView_apply_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _NetworkAclToNetworkAclNetworkView_apply_closure1.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_NetworkAclToNetworkAclNetworkView_apply_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _NetworkAclToNetworkAclNetworkView_apply_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }), (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(NetworkAclEntry entry) {
                    return TypeMappers.transform((Object)((Object)entry), NetworkAclEntryNetworkView.class);
                }

                public Object call(NetworkAclEntry entry) {
                    return this.doCall(entry);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _NetworkAclToNetworkAclNetworkView_apply_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _NetworkAclToNetworkAclNetworkView_apply_closure2.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_NetworkAclToNetworkAclNetworkView_apply_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _NetworkAclToNetworkAclNetworkView_apply_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            })), (List<NetworkAclEntryNetworkView>)ImmutableList.copyOf((Collection)DefaultGroovyMethods.collect((Collection)DefaultGroovyMethods.findAll((Collection)orderedEntries, (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(NetworkAclEntry entry) {
                    return entry.getEgress();
                }

                public Object call(NetworkAclEntry entry) {
                    return this.doCall(entry);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _NetworkAclToNetworkAclNetworkView_apply_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _NetworkAclToNetworkAclNetworkView_apply_closure3.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_NetworkAclToNetworkAclNetworkView_apply_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _NetworkAclToNetworkAclNetworkView_apply_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }), (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(NetworkAclEntry entry) {
                    return TypeMappers.transform((Object)((Object)entry), NetworkAclEntryNetworkView.class);
                }

                public Object call(NetworkAclEntry entry) {
                    return this.doCall(entry);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _NetworkAclToNetworkAclNetworkView_apply_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _NetworkAclToNetworkAclNetworkView_apply_closure4.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_NetworkAclToNetworkAclNetworkView_apply_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _NetworkAclToNetworkAclNetworkView_apply_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            })));
        }

        public static final NetworkAclToNetworkAclNetworkView[] values() {
            return (NetworkAclToNetworkAclNetworkView[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), NetworkAclToNetworkAclNetworkView[].class);
        }

        public /* synthetic */ NetworkAclToNetworkAclNetworkView next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (NetworkAclToNetworkAclNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), NetworkAclToNetworkAclNetworkView.class));
        }

        public /* synthetic */ NetworkAclToNetworkAclNetworkView previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (NetworkAclToNetworkAclNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), NetworkAclToNetworkAclNetworkView.class));
        }

        public static NetworkAclToNetworkAclNetworkView valueOf(String name) {
            return (NetworkAclToNetworkAclNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(NetworkAclToNetworkAclNetworkView.class, name)), NetworkAclToNetworkAclNetworkView.class));
        }

        public static final /* synthetic */ NetworkAclToNetworkAclNetworkView $INIT(Object ... para) {
            NetworkAclToNetworkAclNetworkView networkAclToNetworkAclNetworkView;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, NetworkAclToNetworkAclNetworkView.class)) {
                case -1348271900: {
                    NetworkAclToNetworkAclNetworkView networkAclToNetworkAclNetworkView2;
                    networkAclToNetworkAclNetworkView = networkAclToNetworkAclNetworkView2;
                    Object[] objectArray2 = objectArray;
                    networkAclToNetworkAclNetworkView2 = new NetworkAclToNetworkAclNetworkView();
                    break;
                }
                case -242181752: {
                    NetworkAclToNetworkAclNetworkView networkAclToNetworkAclNetworkView2;
                    networkAclToNetworkAclNetworkView = networkAclToNetworkAclNetworkView2;
                    Object[] objectArray2 = objectArray;
                    networkAclToNetworkAclNetworkView2 = new NetworkAclToNetworkAclNetworkView((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return networkAclToNetworkAclNetworkView;
        }

        static {
            NetworkAclToNetworkAclNetworkView networkAclToNetworkAclNetworkView;
            NetworkAclToNetworkAclNetworkView networkAclToNetworkAclNetworkView2;
            NetworkAclToNetworkAclNetworkView networkAclToNetworkAclNetworkView3;
            NetworkAclToNetworkAclNetworkView.__$swapInit();
            INSTANCE = networkAclToNetworkAclNetworkView3 = NetworkAclToNetworkAclNetworkView.$INIT("INSTANCE", 0);
            MIN_VALUE = networkAclToNetworkAclNetworkView2 = INSTANCE;
            MAX_VALUE = networkAclToNetworkAclNetworkView = INSTANCE;
            NetworkAclToNetworkAclNetworkView[] networkAclToNetworkAclNetworkViewArray = new NetworkAclToNetworkAclNetworkView[]{INSTANCE};
            $VALUES = networkAclToNetworkAclNetworkViewArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != NetworkAclToNetworkAclNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkAclToNetworkAclNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkAclToNetworkAclNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class NetworkAclEntryToNetworkAclEntryNetworkView
    extends Enum<NetworkAclEntryToNetworkAclEntryNetworkView>
    implements Function<NetworkAclEntry, NetworkAclEntryNetworkView>,
    GroovyObject {
        public static final /* enum */ NetworkAclEntryToNetworkAclEntryNetworkView INSTANCE;
        public static final NetworkAclEntryToNetworkAclEntryNetworkView MIN_VALUE;
        public static final NetworkAclEntryToNetworkAclEntryNetworkView MAX_VALUE;
        private static final /* synthetic */ NetworkAclEntryToNetworkAclEntryNetworkView[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkAclEntryToNetworkAclEntryNetworkView(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$NetworkAclEntryToNetworkAclEntryNetworkView was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public NetworkAclEntryToNetworkAclEntryNetworkView() {
            this(new LinkedHashMap());
        }

        public NetworkAclEntryNetworkView apply(NetworkAclEntry networkAclEntry) {
            return new NetworkAclEntryNetworkView(networkAclEntry.getRuleNumber(), networkAclEntry.getProtocol(), String.valueOf((Object)networkAclEntry.getRuleAction()), networkAclEntry.getCidr(), networkAclEntry.getIcmpCode(), networkAclEntry.getIcmpType(), networkAclEntry.getPortRangeFrom(), networkAclEntry.getPortRangeTo());
        }

        public static final NetworkAclEntryToNetworkAclEntryNetworkView[] values() {
            return (NetworkAclEntryToNetworkAclEntryNetworkView[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), NetworkAclEntryToNetworkAclEntryNetworkView[].class);
        }

        public /* synthetic */ NetworkAclEntryToNetworkAclEntryNetworkView next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (NetworkAclEntryToNetworkAclEntryNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), NetworkAclEntryToNetworkAclEntryNetworkView.class));
        }

        public /* synthetic */ NetworkAclEntryToNetworkAclEntryNetworkView previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (NetworkAclEntryToNetworkAclEntryNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), NetworkAclEntryToNetworkAclEntryNetworkView.class));
        }

        public static NetworkAclEntryToNetworkAclEntryNetworkView valueOf(String name) {
            return (NetworkAclEntryToNetworkAclEntryNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(NetworkAclEntryToNetworkAclEntryNetworkView.class, name)), NetworkAclEntryToNetworkAclEntryNetworkView.class));
        }

        public static final /* synthetic */ NetworkAclEntryToNetworkAclEntryNetworkView $INIT(Object ... para) {
            NetworkAclEntryToNetworkAclEntryNetworkView networkAclEntryToNetworkAclEntryNetworkView;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, NetworkAclEntryToNetworkAclEntryNetworkView.class)) {
                case -1348271900: {
                    NetworkAclEntryToNetworkAclEntryNetworkView networkAclEntryToNetworkAclEntryNetworkView2;
                    networkAclEntryToNetworkAclEntryNetworkView = networkAclEntryToNetworkAclEntryNetworkView2;
                    Object[] objectArray2 = objectArray;
                    networkAclEntryToNetworkAclEntryNetworkView2 = new NetworkAclEntryToNetworkAclEntryNetworkView();
                    break;
                }
                case -242181752: {
                    NetworkAclEntryToNetworkAclEntryNetworkView networkAclEntryToNetworkAclEntryNetworkView2;
                    networkAclEntryToNetworkAclEntryNetworkView = networkAclEntryToNetworkAclEntryNetworkView2;
                    Object[] objectArray2 = objectArray;
                    networkAclEntryToNetworkAclEntryNetworkView2 = new NetworkAclEntryToNetworkAclEntryNetworkView((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return networkAclEntryToNetworkAclEntryNetworkView;
        }

        static {
            NetworkAclEntryToNetworkAclEntryNetworkView networkAclEntryToNetworkAclEntryNetworkView;
            NetworkAclEntryToNetworkAclEntryNetworkView networkAclEntryToNetworkAclEntryNetworkView2;
            NetworkAclEntryToNetworkAclEntryNetworkView networkAclEntryToNetworkAclEntryNetworkView3;
            NetworkAclEntryToNetworkAclEntryNetworkView.__$swapInit();
            INSTANCE = networkAclEntryToNetworkAclEntryNetworkView3 = NetworkAclEntryToNetworkAclEntryNetworkView.$INIT("INSTANCE", 0);
            MIN_VALUE = networkAclEntryToNetworkAclEntryNetworkView2 = INSTANCE;
            MAX_VALUE = networkAclEntryToNetworkAclEntryNetworkView = INSTANCE;
            NetworkAclEntryToNetworkAclEntryNetworkView[] networkAclEntryToNetworkAclEntryNetworkViewArray = new NetworkAclEntryToNetworkAclEntryNetworkView[]{INSTANCE};
            $VALUES = networkAclEntryToNetworkAclEntryNetworkViewArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != NetworkAclEntryToNetworkAclEntryNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkAclEntryToNetworkAclEntryNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkAclEntryToNetworkAclEntryNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class NetworkAclEntryNetworkViewToNINetworkAclRule
    extends Enum<NetworkAclEntryNetworkViewToNINetworkAclRule>
    implements Function<NetworkAclEntryNetworkView, NINetworkAclEntry>,
    GroovyObject {
        public static final /* enum */ NetworkAclEntryNetworkViewToNINetworkAclRule INSTANCE;
        public static final NetworkAclEntryNetworkViewToNINetworkAclRule MIN_VALUE;
        public static final NetworkAclEntryNetworkViewToNINetworkAclRule MAX_VALUE;
        private static final /* synthetic */ NetworkAclEntryNetworkViewToNINetworkAclRule[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkAclEntryNetworkViewToNINetworkAclRule(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$NetworkAclEntryNetworkViewToNINetworkAclRule was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public NetworkAclEntryNetworkViewToNINetworkAclRule() {
            this(new LinkedHashMap());
        }

        public NINetworkAclEntry apply(@Nullable NetworkAclEntryNetworkView networkAclEntry) {
            return new NINetworkAclEntry(networkAclEntry.getNumber(), networkAclEntry.getProtocol(), networkAclEntry.getAction(), networkAclEntry.getCidr(), networkAclEntry.getIcmpCode(), networkAclEntry.getIcmpType(), networkAclEntry.getPortRangeFrom(), networkAclEntry.getPortRangeTo());
        }

        public static final NetworkAclEntryNetworkViewToNINetworkAclRule[] values() {
            return (NetworkAclEntryNetworkViewToNINetworkAclRule[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), NetworkAclEntryNetworkViewToNINetworkAclRule[].class);
        }

        public /* synthetic */ NetworkAclEntryNetworkViewToNINetworkAclRule next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (NetworkAclEntryNetworkViewToNINetworkAclRule)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), NetworkAclEntryNetworkViewToNINetworkAclRule.class));
        }

        public /* synthetic */ NetworkAclEntryNetworkViewToNINetworkAclRule previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (NetworkAclEntryNetworkViewToNINetworkAclRule)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), NetworkAclEntryNetworkViewToNINetworkAclRule.class));
        }

        public static NetworkAclEntryNetworkViewToNINetworkAclRule valueOf(String name) {
            return (NetworkAclEntryNetworkViewToNINetworkAclRule)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(NetworkAclEntryNetworkViewToNINetworkAclRule.class, name)), NetworkAclEntryNetworkViewToNINetworkAclRule.class));
        }

        public static final /* synthetic */ NetworkAclEntryNetworkViewToNINetworkAclRule $INIT(Object ... para) {
            NetworkAclEntryNetworkViewToNINetworkAclRule networkAclEntryNetworkViewToNINetworkAclRule;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, NetworkAclEntryNetworkViewToNINetworkAclRule.class)) {
                case -1348271900: {
                    NetworkAclEntryNetworkViewToNINetworkAclRule networkAclEntryNetworkViewToNINetworkAclRule2;
                    networkAclEntryNetworkViewToNINetworkAclRule = networkAclEntryNetworkViewToNINetworkAclRule2;
                    Object[] objectArray2 = objectArray;
                    networkAclEntryNetworkViewToNINetworkAclRule2 = new NetworkAclEntryNetworkViewToNINetworkAclRule();
                    break;
                }
                case -242181752: {
                    NetworkAclEntryNetworkViewToNINetworkAclRule networkAclEntryNetworkViewToNINetworkAclRule2;
                    networkAclEntryNetworkViewToNINetworkAclRule = networkAclEntryNetworkViewToNINetworkAclRule2;
                    Object[] objectArray2 = objectArray;
                    networkAclEntryNetworkViewToNINetworkAclRule2 = new NetworkAclEntryNetworkViewToNINetworkAclRule((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return networkAclEntryNetworkViewToNINetworkAclRule;
        }

        static {
            NetworkAclEntryNetworkViewToNINetworkAclRule networkAclEntryNetworkViewToNINetworkAclRule;
            NetworkAclEntryNetworkViewToNINetworkAclRule networkAclEntryNetworkViewToNINetworkAclRule2;
            NetworkAclEntryNetworkViewToNINetworkAclRule networkAclEntryNetworkViewToNINetworkAclRule3;
            NetworkAclEntryNetworkViewToNINetworkAclRule.__$swapInit();
            INSTANCE = networkAclEntryNetworkViewToNINetworkAclRule3 = NetworkAclEntryNetworkViewToNINetworkAclRule.$INIT("INSTANCE", 0);
            MIN_VALUE = networkAclEntryNetworkViewToNINetworkAclRule2 = INSTANCE;
            MAX_VALUE = networkAclEntryNetworkViewToNINetworkAclRule = INSTANCE;
            NetworkAclEntryNetworkViewToNINetworkAclRule[] networkAclEntryNetworkViewToNINetworkAclRuleArray = new NetworkAclEntryNetworkViewToNINetworkAclRule[]{INSTANCE};
            $VALUES = networkAclEntryNetworkViewToNINetworkAclRuleArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != NetworkAclEntryNetworkViewToNINetworkAclRule.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkAclEntryNetworkViewToNINetworkAclRule.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkAclEntryNetworkViewToNINetworkAclRule.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static final class RouteTableNetworkView
    implements Comparable<RouteTableNetworkView>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final String routeTableId;
        private final String ownerAccountNumber;
        private final String vpcId;
        private final boolean main;
        private final List<String> subnetIds;
        private final List<RouteNetworkView> routes;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public RouteTableNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("routeTableId") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.routeTableId = (String)ScriptBytecodeAdapter.castToType(var3_3, String.class);
                    }
                } else {
                    Object v = args.get("routeTableId");
                    this.routeTableId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("ownerAccountNumber") == null) {
                    if (!(null == null)) {
                        Object var5_5 = null;
                        this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(var5_5, String.class);
                    }
                } else {
                    Object v = args.get("ownerAccountNumber");
                    this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("vpcId") == null) {
                    if (!(null == null)) {
                        Object var7_7 = null;
                        this.vpcId = (String)ScriptBytecodeAdapter.castToType(var7_7, String.class);
                    }
                } else {
                    Object v = args.get("vpcId");
                    this.vpcId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("main") == null) {
                    if (!(null == null)) {
                        Object var9_9 = null;
                        this.main = DefaultTypeTransformation.booleanUnbox(var9_9);
                    }
                } else {
                    Object v = args.get("main");
                    this.main = DefaultTypeTransformation.booleanUnbox(v);
                }
                if (args.get("subnetIds") == null) {
                    if (!(null == null)) {
                        SortedSet sortedSet = null instanceof SortedSet ? DefaultGroovyMethods.asImmutable(null) : (null instanceof SortedMap ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Set ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Map ? DefaultGroovyMethods.asImmutable(null) : (null instanceof List ? DefaultGroovyMethods.asImmutable(null) : DefaultGroovyMethods.asImmutable(null)))));
                        this.subnetIds = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                    }
                } else if (args.get("subnetIds") instanceof Cloneable) {
                    SortedSet sortedSet = (List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("subnetIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("subnetIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedSet.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("subnetIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("subnetIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedMap.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("subnetIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("subnetIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Set.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("subnetIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("subnetIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Map.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("subnetIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("subnetIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("subnetIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)))))));
                    this.subnetIds = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                } else {
                    SortedSet sortedSet = args.get("subnetIds") instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType(args.get("subnetIds"), SortedSet.class))) : (args.get("subnetIds") instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType(args.get("subnetIds"), SortedMap.class))) : (args.get("subnetIds") instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType(args.get("subnetIds"), Set.class))) : (args.get("subnetIds") instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType(args.get("subnetIds"), Map.class))) : (args.get("subnetIds") instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType(args.get("subnetIds"), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((Collection)ScriptBytecodeAdapter.castToType(args.get("subnetIds"), Collection.class)))))));
                    this.subnetIds = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                }
                if (args.get("routes") == null) {
                    if (!(null == null)) {
                        SortedSet sortedSet = null instanceof SortedSet ? DefaultGroovyMethods.asImmutable(null) : (null instanceof SortedMap ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Set ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Map ? DefaultGroovyMethods.asImmutable(null) : (null instanceof List ? DefaultGroovyMethods.asImmutable(null) : DefaultGroovyMethods.asImmutable(null)))));
                        this.routes = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                    }
                } else if (args.get("routes") instanceof Cloneable) {
                    SortedSet sortedSet = (List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("routes"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("routes"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedSet.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("routes"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("routes"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedMap.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("routes"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("routes"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Set.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("routes"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("routes"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Map.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("routes"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("routes"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("routes"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)))))));
                    this.routes = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                } else {
                    SortedSet sortedSet = args.get("routes") instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType(args.get("routes"), SortedSet.class))) : (args.get("routes") instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType(args.get("routes"), SortedMap.class))) : (args.get("routes") instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType(args.get("routes"), Set.class))) : (args.get("routes") instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType(args.get("routes"), Map.class))) : (args.get("routes") instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType(args.get("routes"), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((Collection)ScriptBytecodeAdapter.castToType(args.get("routes"), Collection.class)))))));
                    this.routes = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public RouteTableNetworkView(String routeTableId, String ownerAccountNumber, String vpcId, boolean main, List<String> subnetIds, List<RouteNetworkView> routes) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"routeTableId", routeTableId, "ownerAccountNumber", ownerAccountNumber, "vpcId", vpcId, "main", main, "subnetIds", subnetIds, "routes", routes}), HashMap.class));
        }

        @Override
        public int compareTo(RouteTableNetworkView o) {
            return this.routeTableId == o.getRouteTableId() ? 0 : (this.routeTableId == null ? -1 : (o.getRouteTableId() == null ? 1 : this.routeTableId.compareTo(o.getRouteTableId())));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != RouteTableNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"routeTableId"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"routeTableId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"), (Object)this)) {
                    int n4;
                    _result = n4 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"main"), (Object)this)) {
                    int n5;
                    _result = n5 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"main"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"subnetIds"), (Object)this)) {
                    int n6;
                    _result = n6 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"subnetIds"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"routes"), (Object)this)) {
                    int n7;
                    _result = n7 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"routes"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(RouteTableNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            RouteTableNetworkView otherTyped = (RouteTableNetworkView)ScriptBytecodeAdapter.castToType((Object)other, RouteTableNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getRouteTableId(), (Object)otherTyped.getRouteTableId())) {
                if (DefaultGroovyMethods.is((Object)this.getRouteTableId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getRouteTableId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getRouteTableId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getRouteTableId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getRouteTableId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getRouteTableId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getRouteTableId(), (Object)otherTyped.getRouteTableId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                if (DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)otherTyped.getVpcId())) {
                if (DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getVpcId(), (Object)otherTyped.getVpcId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getMain(), (Object)otherTyped.getMain())) {
                if (DefaultGroovyMethods.is((Object)this.getMain(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getMain(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getMain(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getMain(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getMain(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getMain(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getMain(), (Object)otherTyped.getMain())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is(this.getSubnetIds(), otherTyped.getSubnetIds())) {
                if (DefaultGroovyMethods.is(this.getSubnetIds(), (Object)this) && !DefaultGroovyMethods.is(otherTyped.getSubnetIds(), (Object)otherTyped) || !DefaultGroovyMethods.is(this.getSubnetIds(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getSubnetIds(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is(this.getSubnetIds(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getSubnetIds(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual(this.getSubnetIds(), otherTyped.getSubnetIds())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is(this.getRoutes(), otherTyped.getRoutes())) {
                if (DefaultGroovyMethods.is(this.getRoutes(), (Object)this) && !DefaultGroovyMethods.is(otherTyped.getRoutes(), (Object)otherTyped) || !DefaultGroovyMethods.is(this.getRoutes(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getRoutes(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is(this.getRoutes(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getRoutes(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual(this.getRoutes(), otherTyped.getRoutes())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$RouteTableNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"routeTableId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"routeTableId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"routeTableId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"vpcId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl4;
                    $toStringFirst = bl4 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"main") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl5;
                    $toStringFirst = bl5 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"main"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"main")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"subnetIds") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl6;
                    $toStringFirst = bl6 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"subnetIds"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"subnetIds")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"routes") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl7;
                    $toStringFirst = bl7 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"routes"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"routes")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RouteTableNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, RouteTableNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(RouteTableNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(RouteTableNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, RouteTableNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(RouteTableNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            RouteTableNetworkView.__$swapInit();
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        public final String getOwnerAccountNumber() {
            return this.ownerAccountNumber;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final boolean getMain() {
            return this.main;
        }

        public final boolean isMain() {
            return this.main;
        }

        public final List<String> getSubnetIds() {
            return this.subnetIds;
        }

        public final List<RouteNetworkView> getRoutes() {
            return this.routes;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(RouteTableNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = RouteTableNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    @Immutable
    public static final class RouteNetworkView
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final String destinationCidr;
        private final String gatewayId;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public RouteNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("destinationCidr") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.destinationCidr = (String)ScriptBytecodeAdapter.castToType(var3_3, String.class);
                    }
                } else {
                    Object v = args.get("destinationCidr");
                    this.destinationCidr = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("gatewayId") == null) {
                    if (!(null == null)) {
                        Object var5_5 = null;
                        this.gatewayId = (String)ScriptBytecodeAdapter.castToType(var5_5, String.class);
                    }
                } else {
                    Object v = args.get("gatewayId");
                    this.gatewayId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public RouteNetworkView(String destinationCidr, String gatewayId) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"destinationCidr", destinationCidr, "gatewayId", gatewayId}), HashMap.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != RouteNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"destinationCidr"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"destinationCidr"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"gatewayId"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"gatewayId"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(RouteNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            RouteNetworkView otherTyped = (RouteNetworkView)ScriptBytecodeAdapter.castToType((Object)other, RouteNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getDestinationCidr(), (Object)otherTyped.getDestinationCidr())) {
                if (DefaultGroovyMethods.is((Object)this.getDestinationCidr(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getDestinationCidr(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getDestinationCidr(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getDestinationCidr(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getDestinationCidr(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getDestinationCidr(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getDestinationCidr(), (Object)otherTyped.getDestinationCidr())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getGatewayId(), (Object)otherTyped.getGatewayId())) {
                if (DefaultGroovyMethods.is((Object)this.getGatewayId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getGatewayId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getGatewayId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getGatewayId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getGatewayId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getGatewayId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getGatewayId(), (Object)otherTyped.getGatewayId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$RouteNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"destinationCidr") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"destinationCidr"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"destinationCidr")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"gatewayId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"gatewayId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"gatewayId")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RouteNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, RouteNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(RouteNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(RouteNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, RouteNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(RouteNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            RouteNetworkView.__$swapInit();
        }

        public final String getDestinationCidr() {
            return this.destinationCidr;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(RouteNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = RouteNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class RouteTableToRouteTableNetworkView
    extends Enum<RouteTableToRouteTableNetworkView>
    implements Function<RouteTable, RouteTableNetworkView>,
    GroovyObject {
        public static final /* enum */ RouteTableToRouteTableNetworkView INSTANCE;
        public static final RouteTableToRouteTableNetworkView MIN_VALUE;
        public static final RouteTableToRouteTableNetworkView MAX_VALUE;
        private static final /* synthetic */ RouteTableToRouteTableNetworkView[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public RouteTableToRouteTableNetworkView(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$RouteTableToRouteTableNetworkView was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public RouteTableToRouteTableNetworkView() {
            this(new LinkedHashMap());
        }

        public RouteTableNetworkView apply(RouteTable routeTable) {
            return new RouteTableNetworkView(routeTable.getDisplayName(), routeTable.getOwnerAccountNumber(), routeTable.getVpc().getDisplayName(), DefaultTypeTransformation.booleanUnbox((Object)routeTable.getMain()), (List<String>)ImmutableList.copyOf((Collection)DefaultGroovyMethods.findResults(routeTable.getRouteTableAssociations(), (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(RouteTableAssociation association) {
                    return association.getSubnetId();
                }

                public Object call(RouteTableAssociation association) {
                    return this.doCall(association);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _RouteTableToRouteTableNetworkView_apply_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _RouteTableToRouteTableNetworkView_apply_closure1.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_RouteTableToRouteTableNetworkView_apply_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _RouteTableToRouteTableNetworkView_apply_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            })), (List<RouteNetworkView>)ImmutableList.copyOf((Collection)DefaultGroovyMethods.collect(routeTable.getRoutes(), (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(Route route) {
                    return TypeMappers.transform((Object)((Object)route), RouteNetworkView.class);
                }

                public Object call(Route route) {
                    return this.doCall(route);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _RouteTableToRouteTableNetworkView_apply_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _RouteTableToRouteTableNetworkView_apply_closure2.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_RouteTableToRouteTableNetworkView_apply_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _RouteTableToRouteTableNetworkView_apply_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            })));
        }

        public static final RouteTableToRouteTableNetworkView[] values() {
            return (RouteTableToRouteTableNetworkView[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), RouteTableToRouteTableNetworkView[].class);
        }

        public /* synthetic */ RouteTableToRouteTableNetworkView next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (RouteTableToRouteTableNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), RouteTableToRouteTableNetworkView.class));
        }

        public /* synthetic */ RouteTableToRouteTableNetworkView previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (RouteTableToRouteTableNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), RouteTableToRouteTableNetworkView.class));
        }

        public static RouteTableToRouteTableNetworkView valueOf(String name) {
            return (RouteTableToRouteTableNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(RouteTableToRouteTableNetworkView.class, name)), RouteTableToRouteTableNetworkView.class));
        }

        public static final /* synthetic */ RouteTableToRouteTableNetworkView $INIT(Object ... para) {
            RouteTableToRouteTableNetworkView routeTableToRouteTableNetworkView;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, RouteTableToRouteTableNetworkView.class)) {
                case -1348271900: {
                    RouteTableToRouteTableNetworkView routeTableToRouteTableNetworkView2;
                    routeTableToRouteTableNetworkView = routeTableToRouteTableNetworkView2;
                    Object[] objectArray2 = objectArray;
                    routeTableToRouteTableNetworkView2 = new RouteTableToRouteTableNetworkView();
                    break;
                }
                case -242181752: {
                    RouteTableToRouteTableNetworkView routeTableToRouteTableNetworkView2;
                    routeTableToRouteTableNetworkView = routeTableToRouteTableNetworkView2;
                    Object[] objectArray2 = objectArray;
                    routeTableToRouteTableNetworkView2 = new RouteTableToRouteTableNetworkView((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return routeTableToRouteTableNetworkView;
        }

        static {
            RouteTableToRouteTableNetworkView routeTableToRouteTableNetworkView;
            RouteTableToRouteTableNetworkView routeTableToRouteTableNetworkView2;
            RouteTableToRouteTableNetworkView routeTableToRouteTableNetworkView3;
            RouteTableToRouteTableNetworkView.__$swapInit();
            INSTANCE = routeTableToRouteTableNetworkView3 = RouteTableToRouteTableNetworkView.$INIT("INSTANCE", 0);
            MIN_VALUE = routeTableToRouteTableNetworkView2 = INSTANCE;
            MAX_VALUE = routeTableToRouteTableNetworkView = INSTANCE;
            RouteTableToRouteTableNetworkView[] routeTableToRouteTableNetworkViewArray = new RouteTableToRouteTableNetworkView[]{INSTANCE};
            $VALUES = routeTableToRouteTableNetworkViewArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != RouteTableToRouteTableNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(RouteTableToRouteTableNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = RouteTableToRouteTableNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class RouteToRouteNetworkView
    extends Enum<RouteToRouteNetworkView>
    implements Function<Route, RouteNetworkView>,
    GroovyObject {
        public static final /* enum */ RouteToRouteNetworkView INSTANCE;
        public static final RouteToRouteNetworkView MIN_VALUE;
        public static final RouteToRouteNetworkView MAX_VALUE;
        private static final /* synthetic */ RouteToRouteNetworkView[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public RouteToRouteNetworkView(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$RouteToRouteNetworkView was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public RouteToRouteNetworkView() {
            this(new LinkedHashMap());
        }

        public RouteNetworkView apply(@Nullable Route route) {
            InternetGateway internetGateway = route.getInternetGateway();
            String string = internetGateway != null ? internetGateway.getDisplayName() : null;
            return new RouteNetworkView(route.getDestinationCidr(), DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "local");
        }

        public static final RouteToRouteNetworkView[] values() {
            return (RouteToRouteNetworkView[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), RouteToRouteNetworkView[].class);
        }

        public /* synthetic */ RouteToRouteNetworkView next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (RouteToRouteNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), RouteToRouteNetworkView.class));
        }

        public /* synthetic */ RouteToRouteNetworkView previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (RouteToRouteNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), RouteToRouteNetworkView.class));
        }

        public static RouteToRouteNetworkView valueOf(String name) {
            return (RouteToRouteNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(RouteToRouteNetworkView.class, name)), RouteToRouteNetworkView.class));
        }

        public static final /* synthetic */ RouteToRouteNetworkView $INIT(Object ... para) {
            RouteToRouteNetworkView routeToRouteNetworkView;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, RouteToRouteNetworkView.class)) {
                case -1348271900: {
                    RouteToRouteNetworkView routeToRouteNetworkView2;
                    routeToRouteNetworkView = routeToRouteNetworkView2;
                    Object[] objectArray2 = objectArray;
                    routeToRouteNetworkView2 = new RouteToRouteNetworkView();
                    break;
                }
                case -242181752: {
                    RouteToRouteNetworkView routeToRouteNetworkView2;
                    routeToRouteNetworkView = routeToRouteNetworkView2;
                    Object[] objectArray2 = objectArray;
                    routeToRouteNetworkView2 = new RouteToRouteNetworkView((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return routeToRouteNetworkView;
        }

        static {
            RouteToRouteNetworkView routeToRouteNetworkView;
            RouteToRouteNetworkView routeToRouteNetworkView2;
            RouteToRouteNetworkView routeToRouteNetworkView3;
            RouteToRouteNetworkView.__$swapInit();
            INSTANCE = routeToRouteNetworkView3 = RouteToRouteNetworkView.$INIT("INSTANCE", 0);
            MIN_VALUE = routeToRouteNetworkView2 = INSTANCE;
            MAX_VALUE = routeToRouteNetworkView = INSTANCE;
            RouteToRouteNetworkView[] routeToRouteNetworkViewArray = new RouteToRouteNetworkView[]{INSTANCE};
            $VALUES = routeToRouteNetworkViewArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != RouteToRouteNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(RouteToRouteNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = RouteToRouteNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class RouteNetworkViewToNIRoute
    extends Enum<RouteNetworkViewToNIRoute>
    implements Function<RouteNetworkView, NIRoute>,
    GroovyObject {
        public static final /* enum */ RouteNetworkViewToNIRoute INSTANCE;
        public static final RouteNetworkViewToNIRoute MIN_VALUE;
        public static final RouteNetworkViewToNIRoute MAX_VALUE;
        private static final /* synthetic */ RouteNetworkViewToNIRoute[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public RouteNetworkViewToNIRoute(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$RouteNetworkViewToNIRoute was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public RouteNetworkViewToNIRoute() {
            this(new LinkedHashMap());
        }

        public NIRoute apply(@Nullable RouteNetworkView routeNetworkView) {
            return new NIRoute(routeNetworkView.getDestinationCidr(), routeNetworkView.getGatewayId());
        }

        public static final RouteNetworkViewToNIRoute[] values() {
            return (RouteNetworkViewToNIRoute[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), RouteNetworkViewToNIRoute[].class);
        }

        public /* synthetic */ RouteNetworkViewToNIRoute next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (RouteNetworkViewToNIRoute)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), RouteNetworkViewToNIRoute.class));
        }

        public /* synthetic */ RouteNetworkViewToNIRoute previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (RouteNetworkViewToNIRoute)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), RouteNetworkViewToNIRoute.class));
        }

        public static RouteNetworkViewToNIRoute valueOf(String name) {
            return (RouteNetworkViewToNIRoute)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(RouteNetworkViewToNIRoute.class, name)), RouteNetworkViewToNIRoute.class));
        }

        public static final /* synthetic */ RouteNetworkViewToNIRoute $INIT(Object ... para) {
            RouteNetworkViewToNIRoute routeNetworkViewToNIRoute;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, RouteNetworkViewToNIRoute.class)) {
                case -1348271900: {
                    RouteNetworkViewToNIRoute routeNetworkViewToNIRoute2;
                    routeNetworkViewToNIRoute = routeNetworkViewToNIRoute2;
                    Object[] objectArray2 = objectArray;
                    routeNetworkViewToNIRoute2 = new RouteNetworkViewToNIRoute();
                    break;
                }
                case -242181752: {
                    RouteNetworkViewToNIRoute routeNetworkViewToNIRoute2;
                    routeNetworkViewToNIRoute = routeNetworkViewToNIRoute2;
                    Object[] objectArray2 = objectArray;
                    routeNetworkViewToNIRoute2 = new RouteNetworkViewToNIRoute((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return routeNetworkViewToNIRoute;
        }

        static {
            RouteNetworkViewToNIRoute routeNetworkViewToNIRoute;
            RouteNetworkViewToNIRoute routeNetworkViewToNIRoute2;
            RouteNetworkViewToNIRoute routeNetworkViewToNIRoute3;
            RouteNetworkViewToNIRoute.__$swapInit();
            INSTANCE = routeNetworkViewToNIRoute3 = RouteNetworkViewToNIRoute.$INIT("INSTANCE", 0);
            MIN_VALUE = routeNetworkViewToNIRoute2 = INSTANCE;
            MAX_VALUE = routeNetworkViewToNIRoute = INSTANCE;
            RouteNetworkViewToNIRoute[] routeNetworkViewToNIRouteArray = new RouteNetworkViewToNIRoute[]{INSTANCE};
            $VALUES = routeNetworkViewToNIRouteArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != RouteNetworkViewToNIRoute.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(RouteNetworkViewToNIRoute.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = RouteNetworkViewToNIRoute.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static final class InternetGatewayNetworkView
    implements Comparable<InternetGatewayNetworkView>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final String internetGatewayId;
        private final String ownerAccountNumber;
        private final String vpcId;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public InternetGatewayNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("internetGatewayId") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.internetGatewayId = (String)ScriptBytecodeAdapter.castToType(var3_3, String.class);
                    }
                } else {
                    Object v = args.get("internetGatewayId");
                    this.internetGatewayId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("ownerAccountNumber") == null) {
                    if (!(null == null)) {
                        Object var5_5 = null;
                        this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(var5_5, String.class);
                    }
                } else {
                    Object v = args.get("ownerAccountNumber");
                    this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("vpcId") == null) {
                    if (!(null == null)) {
                        Object var7_7 = null;
                        this.vpcId = (String)ScriptBytecodeAdapter.castToType(var7_7, String.class);
                    }
                } else {
                    Object v = args.get("vpcId");
                    this.vpcId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public InternetGatewayNetworkView(String internetGatewayId, String ownerAccountNumber, String vpcId) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"internetGatewayId", internetGatewayId, "ownerAccountNumber", ownerAccountNumber, "vpcId", vpcId}), HashMap.class));
        }

        @Override
        public int compareTo(InternetGatewayNetworkView o) {
            return this.internetGatewayId == o.getInternetGatewayId() ? 0 : (this.internetGatewayId == null ? -1 : (o.getInternetGatewayId() == null ? 1 : this.internetGatewayId.compareTo(o.getInternetGatewayId())));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != InternetGatewayNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"internetGatewayId"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"internetGatewayId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"), (Object)this)) {
                    int n4;
                    _result = n4 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(InternetGatewayNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            InternetGatewayNetworkView otherTyped = (InternetGatewayNetworkView)ScriptBytecodeAdapter.castToType((Object)other, InternetGatewayNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getInternetGatewayId(), (Object)otherTyped.getInternetGatewayId())) {
                if (DefaultGroovyMethods.is((Object)this.getInternetGatewayId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getInternetGatewayId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getInternetGatewayId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getInternetGatewayId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getInternetGatewayId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getInternetGatewayId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getInternetGatewayId(), (Object)otherTyped.getInternetGatewayId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                if (DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)otherTyped.getVpcId())) {
                if (DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getVpcId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getVpcId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getVpcId(), (Object)otherTyped.getVpcId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$InternetGatewayNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"internetGatewayId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"internetGatewayId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"internetGatewayId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"vpcId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl4;
                    $toStringFirst = bl4 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"vpcId")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(InternetGatewayNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, InternetGatewayNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(InternetGatewayNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(InternetGatewayNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, InternetGatewayNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(InternetGatewayNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            InternetGatewayNetworkView.__$swapInit();
        }

        public final String getInternetGatewayId() {
            return this.internetGatewayId;
        }

        public final String getOwnerAccountNumber() {
            return this.ownerAccountNumber;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(InternetGatewayNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = InternetGatewayNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class InternetGatewayToInternetGatewayNetworkView
    extends Enum<InternetGatewayToInternetGatewayNetworkView>
    implements Function<InternetGateway, InternetGatewayNetworkView>,
    GroovyObject {
        public static final /* enum */ InternetGatewayToInternetGatewayNetworkView INSTANCE;
        public static final InternetGatewayToInternetGatewayNetworkView MIN_VALUE;
        public static final InternetGatewayToInternetGatewayNetworkView MAX_VALUE;
        private static final /* synthetic */ InternetGatewayToInternetGatewayNetworkView[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public InternetGatewayToInternetGatewayNetworkView(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$InternetGatewayToInternetGatewayNetworkView was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public InternetGatewayToInternetGatewayNetworkView() {
            this(new LinkedHashMap());
        }

        public InternetGatewayNetworkView apply(InternetGateway internetGateway) {
            Vpc vpc;
            return new InternetGatewayNetworkView(internetGateway.getDisplayName(), internetGateway.getOwnerAccountNumber(), (vpc = internetGateway.getVpc()) != null ? vpc.getDisplayName() : null);
        }

        public static final InternetGatewayToInternetGatewayNetworkView[] values() {
            return (InternetGatewayToInternetGatewayNetworkView[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), InternetGatewayToInternetGatewayNetworkView[].class);
        }

        public /* synthetic */ InternetGatewayToInternetGatewayNetworkView next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (InternetGatewayToInternetGatewayNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), InternetGatewayToInternetGatewayNetworkView.class));
        }

        public /* synthetic */ InternetGatewayToInternetGatewayNetworkView previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (InternetGatewayToInternetGatewayNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), InternetGatewayToInternetGatewayNetworkView.class));
        }

        public static InternetGatewayToInternetGatewayNetworkView valueOf(String name) {
            return (InternetGatewayToInternetGatewayNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(InternetGatewayToInternetGatewayNetworkView.class, name)), InternetGatewayToInternetGatewayNetworkView.class));
        }

        public static final /* synthetic */ InternetGatewayToInternetGatewayNetworkView $INIT(Object ... para) {
            InternetGatewayToInternetGatewayNetworkView internetGatewayToInternetGatewayNetworkView;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, InternetGatewayToInternetGatewayNetworkView.class)) {
                case -1348271900: {
                    InternetGatewayToInternetGatewayNetworkView internetGatewayToInternetGatewayNetworkView2;
                    internetGatewayToInternetGatewayNetworkView = internetGatewayToInternetGatewayNetworkView2;
                    Object[] objectArray2 = objectArray;
                    internetGatewayToInternetGatewayNetworkView2 = new InternetGatewayToInternetGatewayNetworkView();
                    break;
                }
                case -242181752: {
                    InternetGatewayToInternetGatewayNetworkView internetGatewayToInternetGatewayNetworkView2;
                    internetGatewayToInternetGatewayNetworkView = internetGatewayToInternetGatewayNetworkView2;
                    Object[] objectArray2 = objectArray;
                    internetGatewayToInternetGatewayNetworkView2 = new InternetGatewayToInternetGatewayNetworkView((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return internetGatewayToInternetGatewayNetworkView;
        }

        static {
            InternetGatewayToInternetGatewayNetworkView internetGatewayToInternetGatewayNetworkView;
            InternetGatewayToInternetGatewayNetworkView internetGatewayToInternetGatewayNetworkView2;
            InternetGatewayToInternetGatewayNetworkView internetGatewayToInternetGatewayNetworkView3;
            InternetGatewayToInternetGatewayNetworkView.__$swapInit();
            INSTANCE = internetGatewayToInternetGatewayNetworkView3 = InternetGatewayToInternetGatewayNetworkView.$INIT("INSTANCE", 0);
            MIN_VALUE = internetGatewayToInternetGatewayNetworkView2 = INSTANCE;
            MAX_VALUE = internetGatewayToInternetGatewayNetworkView = INSTANCE;
            InternetGatewayToInternetGatewayNetworkView[] internetGatewayToInternetGatewayNetworkViewArray = new InternetGatewayToInternetGatewayNetworkView[]{INSTANCE};
            $VALUES = internetGatewayToInternetGatewayNetworkViewArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != InternetGatewayToInternetGatewayNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(InternetGatewayToInternetGatewayNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = InternetGatewayToInternetGatewayNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static final class NetworkInterfaceNetworkView
    implements Comparable<NetworkInterfaceNetworkView>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private final String networkInterfaceId;
        private final String ownerAccountNumber;
        private final String instanceId;
        private final Integer deviceIndex;
        private final String macAddress;
        private final String privateIp;
        private final String publicIp;
        private final Boolean sourceDestCheck;
        private final List<String> securityGroupIds;
        private /* synthetic */ int $hash$code;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public NetworkInterfaceNetworkView(HashMap hashMap) {
            void args;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (!(args == null)) {
                if (args.get("networkInterfaceId") == null) {
                    if (!(null == null)) {
                        Object var3_3 = null;
                        this.networkInterfaceId = (String)ScriptBytecodeAdapter.castToType(var3_3, String.class);
                    }
                } else {
                    Object v = args.get("networkInterfaceId");
                    this.networkInterfaceId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("ownerAccountNumber") == null) {
                    if (!(null == null)) {
                        Object var5_5 = null;
                        this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(var5_5, String.class);
                    }
                } else {
                    Object v = args.get("ownerAccountNumber");
                    this.ownerAccountNumber = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("instanceId") == null) {
                    if (!(null == null)) {
                        Object var7_7 = null;
                        this.instanceId = (String)ScriptBytecodeAdapter.castToType(var7_7, String.class);
                    }
                } else {
                    Object v = args.get("instanceId");
                    this.instanceId = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("deviceIndex") == null) {
                    if (!(null == null)) {
                        Object var9_9 = null;
                        this.deviceIndex = (Integer)ScriptBytecodeAdapter.castToType(var9_9, Integer.class);
                    }
                } else {
                    Object v = args.get("deviceIndex");
                    this.deviceIndex = (Integer)ScriptBytecodeAdapter.castToType(v, Integer.class);
                }
                if (args.get("macAddress") == null) {
                    if (!(null == null)) {
                        Object var11_11 = null;
                        this.macAddress = (String)ScriptBytecodeAdapter.castToType(var11_11, String.class);
                    }
                } else {
                    Object v = args.get("macAddress");
                    this.macAddress = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("privateIp") == null) {
                    if (!(null == null)) {
                        Object var13_13 = null;
                        this.privateIp = (String)ScriptBytecodeAdapter.castToType(var13_13, String.class);
                    }
                } else {
                    Object v = args.get("privateIp");
                    this.privateIp = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("publicIp") == null) {
                    if (!(null == null)) {
                        Object var15_15 = null;
                        this.publicIp = (String)ScriptBytecodeAdapter.castToType(var15_15, String.class);
                    }
                } else {
                    Object v = args.get("publicIp");
                    this.publicIp = (String)ScriptBytecodeAdapter.castToType(v, String.class);
                }
                if (args.get("sourceDestCheck") == null) {
                    if (!(null == null)) {
                        Object var17_17 = null;
                        this.sourceDestCheck = (Boolean)ScriptBytecodeAdapter.castToType(var17_17, Boolean.class);
                    }
                } else {
                    Object v = args.get("sourceDestCheck");
                    this.sourceDestCheck = (Boolean)ScriptBytecodeAdapter.castToType(v, Boolean.class);
                }
                if (args.get("securityGroupIds") == null) {
                    if (!(null == null)) {
                        SortedSet sortedSet = null instanceof SortedSet ? DefaultGroovyMethods.asImmutable(null) : (null instanceof SortedMap ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Set ? DefaultGroovyMethods.asImmutable(null) : (null instanceof Map ? DefaultGroovyMethods.asImmutable(null) : (null instanceof List ? DefaultGroovyMethods.asImmutable(null) : DefaultGroovyMethods.asImmutable(null)))));
                        this.securityGroupIds = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                    }
                } else if (args.get("securityGroupIds") instanceof Cloneable) {
                    SortedSet sortedSet = (List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedSet.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), SortedMap.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Set.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType((Object)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)), Map.class))) : ((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class) instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((List)ScriptBytecodeAdapter.castToType((Object)ReflectionMethodInvoker.invoke(args.get("securityGroupIds"), (String)"clone", (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)new Object[0][], Object[].class))), List.class)))))));
                    this.securityGroupIds = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                } else {
                    SortedSet sortedSet = args.get("securityGroupIds") instanceof SortedSet ? DefaultGroovyMethods.asImmutable((SortedSet)((SortedSet)ScriptBytecodeAdapter.castToType(args.get("securityGroupIds"), SortedSet.class))) : (args.get("securityGroupIds") instanceof SortedMap ? DefaultGroovyMethods.asImmutable((SortedMap)((SortedMap)ScriptBytecodeAdapter.castToType(args.get("securityGroupIds"), SortedMap.class))) : (args.get("securityGroupIds") instanceof Set ? DefaultGroovyMethods.asImmutable((Set)((Set)ScriptBytecodeAdapter.castToType(args.get("securityGroupIds"), Set.class))) : (args.get("securityGroupIds") instanceof Map ? DefaultGroovyMethods.asImmutable((Map)((Map)ScriptBytecodeAdapter.castToType(args.get("securityGroupIds"), Map.class))) : (args.get("securityGroupIds") instanceof List ? DefaultGroovyMethods.asImmutable((List)((List)ScriptBytecodeAdapter.castToType(args.get("securityGroupIds"), List.class))) : DefaultGroovyMethods.asImmutable((Collection)((Collection)ScriptBytecodeAdapter.castToType(args.get("securityGroupIds"), Collection.class)))))));
                    this.securityGroupIds = (List)ScriptBytecodeAdapter.castToType((Object)sortedSet, List.class);
                }
                ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
                if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                    if (!(this.$getStaticMetaClass() == null)) {
                        MetaClass metaClass2;
                        this.metaClass = metaClass2 = this.$getStaticMetaClass();
                    }
                } else {
                    MetaClass metaClass3;
                    this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
                }
            }
        }

        public NetworkInterfaceNetworkView(String networkInterfaceId, String ownerAccountNumber, String instanceId, Integer deviceIndex, String macAddress, String privateIp, String publicIp, Boolean sourceDestCheck, List<String> securityGroupIds) {
            this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"networkInterfaceId", networkInterfaceId, "ownerAccountNumber", ownerAccountNumber, "instanceId", instanceId, "deviceIndex", deviceIndex, "macAddress", macAddress, "privateIp", privateIp, "publicIp", publicIp, "sourceDestCheck", sourceDestCheck, "securityGroupIds", securityGroupIds}), HashMap.class));
        }

        @Override
        public int compareTo(NetworkInterfaceNetworkView o) {
            return this.networkInterfaceId == o.getNetworkInterfaceId() ? 0 : (this.networkInterfaceId == null ? -1 : (o.getNetworkInterfaceId() == null ? 1 : this.networkInterfaceId.compareTo(o.getNetworkInterfaceId())));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkInterfaceNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"networkInterfaceId"), (Object)this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"networkInterfaceId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"instanceId"), (Object)this)) {
                    int n4;
                    _result = n4 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"instanceId"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"deviceIndex"), (Object)this)) {
                    int n5;
                    _result = n5 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"deviceIndex"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"macAddress"), (Object)this)) {
                    int n6;
                    _result = n6 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"macAddress"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"privateIp"), (Object)this)) {
                    int n7;
                    _result = n7 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"privateIp"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"publicIp"), (Object)this)) {
                    int n8;
                    _result = n8 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"publicIp"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"sourceDestCheck"), (Object)this)) {
                    int n9;
                    _result = n9 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"sourceDestCheck"));
                }
                if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"securityGroupIds"), (Object)this)) {
                    int n10;
                    _result = n10 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"securityGroupIds"));
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (ScriptBytecodeAdapter.compareNotEqual(NetworkInterfaceNetworkView.class, other.getClass())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            NetworkInterfaceNetworkView otherTyped = (NetworkInterfaceNetworkView)ScriptBytecodeAdapter.castToType((Object)other, NetworkInterfaceNetworkView.class);
            if (!DefaultGroovyMethods.is((Object)this.getNetworkInterfaceId(), (Object)otherTyped.getNetworkInterfaceId())) {
                if (DefaultGroovyMethods.is((Object)this.getNetworkInterfaceId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getNetworkInterfaceId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getNetworkInterfaceId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getNetworkInterfaceId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getNetworkInterfaceId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getNetworkInterfaceId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getNetworkInterfaceId(), (Object)otherTyped.getNetworkInterfaceId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                if (DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getOwnerAccountNumber(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getOwnerAccountNumber(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getOwnerAccountNumber(), (Object)otherTyped.getOwnerAccountNumber())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getInstanceId(), (Object)otherTyped.getInstanceId())) {
                if (DefaultGroovyMethods.is((Object)this.getInstanceId(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getInstanceId(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getInstanceId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getInstanceId(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getInstanceId(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getInstanceId(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getInstanceId(), (Object)otherTyped.getInstanceId())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getDeviceIndex(), (Object)otherTyped.getDeviceIndex())) {
                if (DefaultGroovyMethods.is((Object)this.getDeviceIndex(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getDeviceIndex(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getDeviceIndex(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getDeviceIndex(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getDeviceIndex(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getDeviceIndex(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getDeviceIndex(), (Object)otherTyped.getDeviceIndex())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getMacAddress(), (Object)otherTyped.getMacAddress())) {
                if (DefaultGroovyMethods.is((Object)this.getMacAddress(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getMacAddress(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getMacAddress(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getMacAddress(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getMacAddress(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getMacAddress(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getMacAddress(), (Object)otherTyped.getMacAddress())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getPrivateIp(), (Object)otherTyped.getPrivateIp())) {
                if (DefaultGroovyMethods.is((Object)this.getPrivateIp(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getPrivateIp(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getPrivateIp(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPrivateIp(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getPrivateIp(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPrivateIp(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getPrivateIp(), (Object)otherTyped.getPrivateIp())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getPublicIp(), (Object)otherTyped.getPublicIp())) {
                if (DefaultGroovyMethods.is((Object)this.getPublicIp(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getPublicIp(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getPublicIp(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPublicIp(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getPublicIp(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPublicIp(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getPublicIp(), (Object)otherTyped.getPublicIp())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getSourceDestCheck(), (Object)otherTyped.getSourceDestCheck())) {
                if (DefaultGroovyMethods.is((Object)this.getSourceDestCheck(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getSourceDestCheck(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getSourceDestCheck(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getSourceDestCheck(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getSourceDestCheck(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getSourceDestCheck(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual((Object)this.getSourceDestCheck(), (Object)otherTyped.getSourceDestCheck())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is(this.getSecurityGroupIds(), otherTyped.getSecurityGroupIds())) {
                if (DefaultGroovyMethods.is(this.getSecurityGroupIds(), (Object)this) && !DefaultGroovyMethods.is(otherTyped.getSecurityGroupIds(), (Object)otherTyped) || !DefaultGroovyMethods.is(this.getSecurityGroupIds(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getSecurityGroupIds(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is(this.getSecurityGroupIds(), (Object)this) && DefaultGroovyMethods.is(otherTyped.getSecurityGroupIds(), (Object)otherTyped)) && ScriptBytecodeAdapter.compareNotEqual(this.getSecurityGroupIds(), otherTyped.getSecurityGroupIds())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.eucalyptus.network.NetworkInfoBroadcaster$NetworkInterfaceNetworkView(");
            if (InvokerHelper.getProperty((Object)this, (String)"networkInterfaceId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl2;
                    $toStringFirst = bl2 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"networkInterfaceId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"networkInterfaceId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl3;
                    $toStringFirst = bl3 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"ownerAccountNumber")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"instanceId") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl4;
                    $toStringFirst = bl4 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"instanceId"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"instanceId")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"deviceIndex") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl5;
                    $toStringFirst = bl5 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"deviceIndex"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"deviceIndex")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"macAddress") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl6;
                    $toStringFirst = bl6 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"macAddress"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"macAddress")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"privateIp") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl7;
                    $toStringFirst = bl7 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"privateIp"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"privateIp")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"publicIp") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl8;
                    $toStringFirst = bl8 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"publicIp"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"publicIp")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"sourceDestCheck") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl9;
                    $toStringFirst = bl9 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"sourceDestCheck"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"sourceDestCheck")));
                }
            }
            if (InvokerHelper.getProperty((Object)this, (String)"securityGroupIds") != null) {
                Boolean bl = $toStringFirst;
                if (bl == null ? false : bl) {
                    Boolean bl10;
                    $toStringFirst = bl10 = Boolean.FALSE;
                } else {
                    _result.append(", ");
                }
                if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"securityGroupIds"), (Object)this)) {
                    _result.append("(this)");
                } else {
                    _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"securityGroupIds")));
                }
            }
            _result.append(")");
            return _result.toString();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NetworkInterfaceNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, NetworkInterfaceNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(NetworkInterfaceNetworkView.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(NetworkInterfaceNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, NetworkInterfaceNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(NetworkInterfaceNetworkView.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            NetworkInterfaceNetworkView.__$swapInit();
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final String getOwnerAccountNumber() {
            return this.ownerAccountNumber;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final String getPrivateIp() {
            return this.privateIp;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        public final List<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkInterfaceNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkInterfaceNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TypeMapper
    public final class VpcNetworkInterfaceToNetworkInterfaceNetworkView
    extends Enum<VpcNetworkInterfaceToNetworkInterfaceNetworkView>
    implements Function<NetworkInterface, NetworkInterfaceNetworkView>,
    GroovyObject {
        public static final /* enum */ VpcNetworkInterfaceToNetworkInterfaceNetworkView INSTANCE;
        public static final VpcNetworkInterfaceToNetworkInterfaceNetworkView MIN_VALUE;
        public static final VpcNetworkInterfaceToNetworkInterfaceNetworkView MAX_VALUE;
        private static final /* synthetic */ VpcNetworkInterfaceToNetworkInterfaceNetworkView[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public VpcNetworkInterfaceToNetworkInterfaceNetworkView(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.NetworkInfoBroadcaster$VpcNetworkInterfaceToNetworkInterfaceNetworkView was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public VpcNetworkInterfaceToNetworkInterfaceNetworkView() {
            this(new LinkedHashMap());
        }

        public NetworkInterfaceNetworkView apply(NetworkInterface networkInterface) {
            NetworkInterfaceAttachment networkInterfaceAttachment = networkInterface.getAttachment();
            String string = networkInterfaceAttachment != null ? networkInterfaceAttachment.getInstanceId() : null;
            NetworkInterfaceAttachment networkInterfaceAttachment2 = networkInterface.getAttachment();
            NetworkInterface networkInterface2 = networkInterface;
            NetworkInterfaceAssociation networkInterfaceAssociation = networkInterface2 != null ? networkInterface2.getAssociation() : null;
            return new NetworkInterfaceNetworkView(networkInterface.getDisplayName(), networkInterface.getOwnerAccountNumber(), string, networkInterfaceAttachment2 != null ? networkInterfaceAttachment2.getDeviceIndex() : null, networkInterface.getMacAddress(), networkInterface.getPrivateIpAddress(), networkInterfaceAssociation != null ? networkInterfaceAssociation.getPublicIp() : null, networkInterface.getSourceDestCheck(), DefaultGroovyMethods.collect(networkInterface.getNetworkGroups(), (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(NetworkGroup group) {
                    return group.getGroupId();
                }

                public Object call(NetworkGroup group) {
                    return this.doCall(group);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _VpcNetworkInterfaceToNetworkInterfaceNetworkView_apply_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _VpcNetworkInterfaceToNetworkInterfaceNetworkView_apply_closure1.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_VpcNetworkInterfaceToNetworkInterfaceNetworkView_apply_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _VpcNetworkInterfaceToNetworkInterfaceNetworkView_apply_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }));
        }

        public static final VpcNetworkInterfaceToNetworkInterfaceNetworkView[] values() {
            return (VpcNetworkInterfaceToNetworkInterfaceNetworkView[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), VpcNetworkInterfaceToNetworkInterfaceNetworkView[].class);
        }

        public /* synthetic */ VpcNetworkInterfaceToNetworkInterfaceNetworkView next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (VpcNetworkInterfaceToNetworkInterfaceNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), VpcNetworkInterfaceToNetworkInterfaceNetworkView.class));
        }

        public /* synthetic */ VpcNetworkInterfaceToNetworkInterfaceNetworkView previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (VpcNetworkInterfaceToNetworkInterfaceNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), VpcNetworkInterfaceToNetworkInterfaceNetworkView.class));
        }

        public static VpcNetworkInterfaceToNetworkInterfaceNetworkView valueOf(String name) {
            return (VpcNetworkInterfaceToNetworkInterfaceNetworkView)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(VpcNetworkInterfaceToNetworkInterfaceNetworkView.class, name)), VpcNetworkInterfaceToNetworkInterfaceNetworkView.class));
        }

        public static final /* synthetic */ VpcNetworkInterfaceToNetworkInterfaceNetworkView $INIT(Object ... para) {
            VpcNetworkInterfaceToNetworkInterfaceNetworkView vpcNetworkInterfaceToNetworkInterfaceNetworkView;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, VpcNetworkInterfaceToNetworkInterfaceNetworkView.class)) {
                case -1348271900: {
                    VpcNetworkInterfaceToNetworkInterfaceNetworkView vpcNetworkInterfaceToNetworkInterfaceNetworkView2;
                    vpcNetworkInterfaceToNetworkInterfaceNetworkView = vpcNetworkInterfaceToNetworkInterfaceNetworkView2;
                    Object[] objectArray2 = objectArray;
                    vpcNetworkInterfaceToNetworkInterfaceNetworkView2 = new VpcNetworkInterfaceToNetworkInterfaceNetworkView();
                    break;
                }
                case -242181752: {
                    VpcNetworkInterfaceToNetworkInterfaceNetworkView vpcNetworkInterfaceToNetworkInterfaceNetworkView2;
                    vpcNetworkInterfaceToNetworkInterfaceNetworkView = vpcNetworkInterfaceToNetworkInterfaceNetworkView2;
                    Object[] objectArray2 = objectArray;
                    vpcNetworkInterfaceToNetworkInterfaceNetworkView2 = new VpcNetworkInterfaceToNetworkInterfaceNetworkView((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return vpcNetworkInterfaceToNetworkInterfaceNetworkView;
        }

        static {
            VpcNetworkInterfaceToNetworkInterfaceNetworkView vpcNetworkInterfaceToNetworkInterfaceNetworkView;
            VpcNetworkInterfaceToNetworkInterfaceNetworkView vpcNetworkInterfaceToNetworkInterfaceNetworkView2;
            VpcNetworkInterfaceToNetworkInterfaceNetworkView vpcNetworkInterfaceToNetworkInterfaceNetworkView3;
            VpcNetworkInterfaceToNetworkInterfaceNetworkView.__$swapInit();
            INSTANCE = vpcNetworkInterfaceToNetworkInterfaceNetworkView3 = VpcNetworkInterfaceToNetworkInterfaceNetworkView.$INIT("INSTANCE", 0);
            MIN_VALUE = vpcNetworkInterfaceToNetworkInterfaceNetworkView2 = INSTANCE;
            MAX_VALUE = vpcNetworkInterfaceToNetworkInterfaceNetworkView = INSTANCE;
            VpcNetworkInterfaceToNetworkInterfaceNetworkView[] vpcNetworkInterfaceToNetworkInterfaceNetworkViewArray = new VpcNetworkInterfaceToNetworkInterfaceNetworkView[]{INSTANCE};
            $VALUES = vpcNetworkInterfaceToNetworkInterfaceNetworkViewArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != VpcNetworkInterfaceToNetworkInterfaceNetworkView.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(VpcNetworkInterfaceToNetworkInterfaceNetworkView.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = VpcNetworkInterfaceToNetworkInterfaceNetworkView.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NetworkInfoBroadcasterEventListener
    implements EventListener<ClockTick>,
    GroovyObject {
        private final int intervalTicks;
        private final int activeBroadcastTimeoutMins;
        private volatile int counter;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkInfoBroadcasterEventListener() {
            MetaClass metaClass;
            int n;
            int n2;
            int n3;
            this.intervalTicks = n3 = 3;
            this.activeBroadcastTimeoutMins = n2 = 3;
            this.counter = n = 0;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new NetworkInfoBroadcasterEventListener());
        }

        public void fireEvent(ClockTick event) {
            DefaultGroovyMethods.each(activeBroadcastMap, (Closure)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(Map.Entry<String, Long> entry) {
                    if (DefaultTypeTransformation.longUnbox((Object)NumberNumberPlus.plus((Number)((Number)ScriptBytecodeAdapter.castToType((Object)entry.getValue(), Number.class)), (Number)TimeUnit.MINUTES.toMillis(DefaultTypeTransformation.longUnbox((Object)this.getProperty("activeBroadcastTimeoutMins"))))) < System.currentTimeMillis() && NetworkInfoBroadcaster.pfaccess$2(null).remove(entry.getKey(), entry.getValue())) {
                        ((Category)this.getProperty("logger")).warn((Object)new GStringImpl(new Object[]{entry.getKey()}, new String[]{"Timed out active network information broadcast for partition ", ""}));
                        return null;
                    }
                    return null;
                }

                public Object call(Map.Entry<String, Long> entry) {
                    return this.doCall(entry);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _NetworkInfoBroadcasterEventListener_fireEvent_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _NetworkInfoBroadcasterEventListener_fireEvent_closure1.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_NetworkInfoBroadcasterEventListener_fireEvent_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _NetworkInfoBroadcasterEventListener_fireEvent_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
            int n = this.counter;
            this.counter = n + 1;
            if (n % this.intervalTicks == 0 && EdgeNetworking.isEnabled() && DefaultTypeTransformation.booleanUnbox((Object)Hosts.getCoordinator()) && !DefaultTypeTransformation.booleanUnbox((Object)Bootstrap.isShuttingDown()) && !DefaultTypeTransformation.booleanUnbox((Object)Databases.isVolatile())) {
                NetworkInfoBroadcaster.requestNetworkInfoBroadcast();
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkInfoBroadcasterEventListener.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NetworkInfoBroadcasterEventListener.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, NetworkInfoBroadcasterEventListener.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(NetworkInfoBroadcasterEventListener.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(NetworkInfoBroadcasterEventListener.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, NetworkInfoBroadcasterEventListener.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(NetworkInfoBroadcasterEventListener.class, NetworkInfoBroadcaster.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public static /* synthetic */ int pfaccess$0(NetworkInfoBroadcasterEventListener $that) {
            return $that.activeBroadcastTimeoutMins;
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            NetworkInfoBroadcasterEventListener.__$swapInit();
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkInfoBroadcasterEventListener.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkInfoBroadcasterEventListener.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

