/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.cloud.util.DuplicateMetadataException;
import com.eucalyptus.cloud.util.MetadataConstraintException;
import com.eucalyptus.cloud.util.MetadataException;
import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.cloud.util.Reference;
import com.eucalyptus.cluster.ClusterConfiguration;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.IpPermissionType;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.compute.common.UserIdGroupPairType;
import com.eucalyptus.compute.common.network.NetworkReportType;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.PersistenceExceptions;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.network.EdgeNetworking;
import com.eucalyptus.network.ExtantNetwork;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.network.NetworkGroupTag;
import com.eucalyptus.network.NetworkInfoBroadcaster;
import com.eucalyptus.network.NetworkPeer;
import com.eucalyptus.network.NetworkRule;
import com.eucalyptus.network.PrivateNetworkIndex;
import com.eucalyptus.network.config.NetworkConfigurations;
import com.eucalyptus.records.Logs;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.PersistenceException;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.ConstraintViolationException;

@ConfigurableClass(root="cloud.network", description="Default values used to bootstrap networking state discovery.")
public class NetworkGroups {
    private static final String DEFAULT_NETWORK_NAME = "default";
    public static final Pattern VPC_GROUP_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9 ._\\-:/()#,@\\[\\]+=&;{}!$*]{1,255}");
    public static final Pattern VPC_GROUP_DESC_PATTERN = Pattern.compile("[a-zA-Z0-9 ._\\-:/()#,@\\[\\]+=&;{}!$*]{0,255}");
    private static Logger LOG = Logger.getLogger(NetworkGroups.class);
    @ConfigurableField(description="Default max network index.")
    public static Long GLOBAL_MAX_NETWORK_INDEX = 4096L;
    @ConfigurableField(description="Default min network index.")
    public static Long GLOBAL_MIN_NETWORK_INDEX = 2L;
    @ConfigurableField(description="Default max vlan tag.")
    public static Integer GLOBAL_MAX_NETWORK_TAG = 4096;
    @ConfigurableField(description="Default min vlan tag.")
    public static Integer GLOBAL_MIN_NETWORK_TAG = 1;
    @ConfigurableField(description="Minutes before a pending tag allocation timesout and is released.")
    public static Integer NETWORK_TAG_PENDING_TIMEOUT = 35;
    @ConfigurableField(description="Minutes before a pending index allocation timesout and is released.")
    public static Integer NETWORK_INDEX_PENDING_TIMEOUT = 35;
    @ConfigurableField(description="Network configuration document.", changeListener=NetworkConfigurations.NetworkConfigurationPropertyChangeListener.class)
    public static String NETWORK_CONFIGURATION = "";
    @ConfigurableField(description="Minimum interval between broadcasts of network information (seconds).")
    public static Integer MIN_BROADCAST_INTERVAL = 5;
    static NetworkRangeConfiguration netConfig = new NetworkRangeConfiguration();

    public static void updateExtantNetworks(ServiceConfiguration cluster, List<NetworkReportType> activeNetworks) {
        ExtantNetwork exNet;
        ActiveTags.INSTANCE.update(cluster, activeNetworks);
        for (NetworkReportType activeNetReport : activeNetworks) {
            try {
                TransactionResource tx = Entities.transactionFor(NetworkGroup.class);
                Throwable throwable = null;
                try {
                    NetworkGroup net = NetworkGroups.lookupByNaturalId(activeNetReport.getUuid());
                    if (net.hasExtantNetwork()) {
                        exNet = net.extantNetwork();
                        if (Reference.State.PENDING.equals(exNet.getState())) {
                            LOG.debug((Object)("Found PENDING extant network for " + net.getFullName() + " updating to EXTANT."));
                            exNet.setState(Reference.State.EXTANT);
                        } else {
                            LOG.debug((Object)("Found " + exNet.getState() + " extant network for " + net.getFullName() + ": skipped."));
                        }
                    } else {
                        LOG.warn((Object)("Failed to find extant network for " + net.getFullName()));
                    }
                    tx.commit();
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            catch (Exception ex) {
                LOG.debug((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
        }
        try {
            List<NetworkGroup> groups = NetworkGroups.lookupExtant();
            for (NetworkGroup net : groups) {
                try {
                    TransactionResource tx = Entities.transactionFor(NetworkGroup.class);
                    Throwable x2 = null;
                    try {
                        Integer exNetTag;
                        net = (NetworkGroup)((Object)Entities.merge((Object)((Object)net)));
                        if (net.hasExtantNetwork() && !ActiveTags.INSTANCE.isActive(exNetTag = (exNet = net.getExtantNetwork()).getTag())) {
                            if (Reference.State.EXTANT.equals(exNet.getState())) {
                                exNet.setState(Reference.State.RELEASING);
                            } else if (Reference.State.PENDING.equals(exNet.getState()) && NetworkGroups.isTimedOut(exNet.lastUpdateMillis(), NETWORK_TAG_PENDING_TIMEOUT)) {
                                exNet.setState(Reference.State.RELEASING);
                            } else if (Reference.State.RELEASING.equals(exNet.getState())) {
                                exNet.teardown();
                                Entities.delete((Object)((Object)exNet));
                                net.setExtantNetwork(null);
                            }
                        }
                        tx.commit();
                    }
                    catch (Throwable throwable) {
                        x2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (tx == null) continue;
                        if (x2 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable x22) {
                                x2.addSuppressed(x22);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (Exception ex) {
                    LOG.debug((Object)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }
        }
        catch (MetadataException ex) {
            LOG.error((Object)ex);
        }
        HashSet taggedNetworkIndicies = Sets.newHashSet((Iterable)((Iterable)CollectionUtils.listJoin().apply((Object)Lists.transform(activeNetworks, (Function)NetworkIndexTransform.INSTANCE))));
        try (TransactionResource db = Entities.transactionFor(PrivateNetworkIndex.class);){
            for (PrivateNetworkIndex index : Entities.query((Object)PrivateNetworkIndex.inState(Reference.State.PENDING))) {
                if (!NetworkGroups.isTimedOut(index.lastUpdateMillis(), NETWORK_INDEX_PENDING_TIMEOUT)) continue;
                if (taggedNetworkIndicies.contains(index.getDisplayName())) {
                    LOG.warn((Object)String.format("Pending network index (%s) timed out, setting state to EXTANT", index.getDisplayName()));
                    index.setState(Reference.State.EXTANT);
                    continue;
                }
                LOG.warn((Object)String.format("Pending network index (%s) timed out, tearing down", index.getDisplayName()));
                index.release();
                index.teardown();
            }
            db.commit();
        }
        catch (Exception ex) {
            LOG.debug((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
    }

    private static boolean isTimedOut(Long timeSinceUpdateMillis, Integer timeoutMinutes) {
        return timeSinceUpdateMillis != null && timeoutMinutes != null && timeSinceUpdateMillis > TimeUnit.MINUTES.toMillis(timeoutMinutes.intValue());
    }

    public static synchronized void updateNetworkRangeConfiguration() {
        final AtomicReference<Object> equalityCheck = new AtomicReference<Object>(null);
        try {
            Transactions.each((Object)new ClusterConfiguration(), (Callback)new Callback<ClusterConfiguration>(){

                public void fire(ClusterConfiguration input) {
                    NetworkRangeConfiguration comparisonConfig = new NetworkRangeConfiguration();
                    comparisonConfig.setUseNetworkTags(input.getUseNetworkTags());
                    comparisonConfig.setMinNetworkTag(input.getMinNetworkTag());
                    comparisonConfig.setMaxNetworkTag(input.getMaxNetworkTag());
                    comparisonConfig.setMinNetworkIndex(input.getMinNetworkIndex());
                    comparisonConfig.setMaxNetworkIndex(input.getMaxNetworkIndex());
                    Logs.extreme().debug((Object)("Updating cluster config: " + input.getName() + " " + comparisonConfig.toString()));
                    if (equalityCheck.compareAndSet(null, comparisonConfig)) {
                        Logs.extreme().debug((Object)("Initialized cluster config check: " + equalityCheck.get()));
                    } else {
                        NetworkRangeConfiguration currentConfig = (NetworkRangeConfiguration)equalityCheck.get();
                        ArrayList errors = Lists.newArrayList();
                        if (!currentConfig.getUseNetworkTags().equals(comparisonConfig.getUseNetworkTags())) {
                            errors.add(input.getName() + " network config mismatch: vlan tagging  " + currentConfig.getUseNetworkTags() + " != " + comparisonConfig.getUseNetworkTags());
                        } else if (!currentConfig.getMinNetworkTag().equals(comparisonConfig.getMinNetworkTag())) {
                            errors.add(input.getName() + " network config mismatch: min vlan tag " + currentConfig.getMinNetworkTag() + " != " + comparisonConfig.getMinNetworkTag());
                        } else if (!currentConfig.getMaxNetworkTag().equals(comparisonConfig.getMaxNetworkTag())) {
                            errors.add(input.getName() + " network config mismatch: max vlan tag " + currentConfig.getMaxNetworkTag() + " != " + comparisonConfig.getMaxNetworkTag());
                        } else if (!currentConfig.getMinNetworkIndex().equals(comparisonConfig.getMinNetworkIndex())) {
                            errors.add(input.getName() + " network config mismatch: min net index " + currentConfig.getMinNetworkIndex() + " != " + comparisonConfig.getMinNetworkIndex());
                        } else if (!currentConfig.getMaxNetworkIndex().equals(comparisonConfig.getMaxNetworkIndex())) {
                            errors.add(input.getName() + " network config mismatch: max net index " + currentConfig.getMaxNetworkIndex() + " != " + comparisonConfig.getMaxNetworkIndex());
                        }
                    }
                }
            });
        }
        catch (RuntimeException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        catch (TransactionException ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
        netConfig = new NetworkRangeConfiguration();
        final AtomicBoolean netTagging = new AtomicBoolean(true);
        try {
            Transactions.each((Object)new ClusterConfiguration(), (Callback)new Callback<ClusterConfiguration>(){

                public void fire(ClusterConfiguration input) {
                    netTagging.compareAndSet(true, input.getUseNetworkTags());
                    netConfig.setMinNetworkTag(Ints.max((int[])new int[]{netConfig.getMinNetworkTag(), input.getMinNetworkTag()}));
                    netConfig.setMaxNetworkTag(Ints.min((int[])new int[]{netConfig.getMaxNetworkTag(), input.getMaxNetworkTag()}));
                    netConfig.setMinNetworkIndex(Longs.max((long[])new long[]{netConfig.getMinNetworkIndex(), input.getMinNetworkIndex()}));
                    netConfig.setMaxNetworkIndex(Longs.min((long[])new long[]{netConfig.getMaxNetworkIndex(), input.getMaxNetworkIndex()}));
                }
            });
            Logs.extreme().debug((Object)("Updated network configuration: " + netConfig.toString()));
        }
        catch (TransactionException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
        netConfig.setUseNetworkTags(netTagging.get());
        try (TransactionResource db = Entities.transactionFor(NetworkGroup.class);){
            List ret = Entities.query((Object)((Object)new NetworkGroup()));
            for (NetworkGroup group : ret) {
                ExtantNetwork exNet = group.getExtantNetwork();
                if (exNet == null || exNet.getTag() <= netConfig.getMaxNetworkTag() && exNet.getTag() >= netConfig.getMinNetworkTag()) continue;
                exNet.teardown();
                Entities.delete((Object)((Object)exNet));
                group.setExtantNetwork(null);
            }
            db.commit();
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            LOG.error((Object)ex);
        }
    }

    public static List<Long> networkIndexInterval() {
        ArrayList interval = Lists.newArrayList();
        Long i = NetworkGroups.networkingConfiguration().getMinNetworkIndex();
        while (i < NetworkGroups.networkingConfiguration().getMaxNetworkIndex()) {
            interval.add(i);
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
        }
        return interval;
    }

    public static List<Integer> networkTagInterval() {
        ArrayList interval = Lists.newArrayList();
        Integer i = NetworkGroups.networkingConfiguration().getMinNetworkTag();
        while (i < NetworkGroups.networkingConfiguration().getMaxNetworkTag()) {
            interval.add(i);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return interval;
    }

    public static synchronized NetworkRangeConfiguration networkingConfiguration() {
        return netConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NetworkGroup delete(String groupId) throws MetadataException {
        try (TransactionResource db = Entities.transactionFor(NetworkGroup.class);){
            NetworkGroup ret = (NetworkGroup)((Object)Entities.uniqueResult((Object)((Object)NetworkGroup.withGroupId(null, groupId))));
            Entities.delete((Object)((Object)ret));
            db.commit();
            NetworkGroup networkGroup = ret;
            return networkGroup;
        }
        catch (ConstraintViolationException ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new MetadataConstraintException("Failed to delete security group: " + groupId + " because of: " + Exceptions.causeString((Throwable)ex), ex);
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new NoSuchMetadataException("Failed to find security group: " + groupId, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NetworkGroup lookupByNaturalId(String uuid) throws NoSuchMetadataException {
        try (TransactionResource db = Entities.transactionFor(NetworkGroup.class);){
            NetworkGroup entity = (NetworkGroup)((Object)Entities.uniqueResult((Object)((Object)NetworkGroup.withNaturalId(uuid))));
            db.commit();
            NetworkGroup networkGroup = entity;
            return networkGroup;
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new NoSuchMetadataException("Failed to find security group: " + uuid, ex);
        }
    }

    public static NetworkGroup lookupByGroupId(String groupId) throws NoSuchMetadataException {
        return NetworkGroups.lookupByGroupId(null, groupId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NetworkGroup lookupByGroupId(@Nullable OwnerFullName ownerFullName, String groupId) throws NoSuchMetadataException {
        try (TransactionResource db = Entities.transactionFor(NetworkGroup.class);){
            NetworkGroup entity = (NetworkGroup)((Object)Entities.uniqueResult((Object)((Object)NetworkGroup.withGroupId(ownerFullName, groupId))));
            db.commit();
            NetworkGroup networkGroup = entity;
            return networkGroup;
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new NoSuchMetadataException("Failed to find security group: " + groupId, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NetworkGroup lookup(OwnerFullName ownerFullName, String groupName) throws MetadataException {
        if (NetworkGroups.defaultNetworkName().equals(groupName)) {
            NetworkGroups.createDefault(ownerFullName);
        }
        try (TransactionResource db = Entities.transactionFor(NetworkGroup.class);){
            NetworkGroup ret = (NetworkGroup)((Object)Entities.uniqueResult((Object)((Object)NetworkGroup.named(ownerFullName, groupName))));
            db.commit();
            NetworkGroup networkGroup = ret;
            return networkGroup;
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new NoSuchMetadataException("Failed to find security group: " + groupName + " for " + ownerFullName, ex);
        }
    }

    public static NetworkGroup lookupDefault(OwnerFullName ownerFullName, String vpcId) throws MetadataException {
        return NetworkGroups.lookup(ownerFullName, vpcId, NetworkGroups.defaultNetworkName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NetworkGroup lookup(OwnerFullName ownerFullName, String vpcId, String name) throws MetadataException {
        try (TransactionResource db = Entities.transactionFor(NetworkGroup.class);){
            NetworkGroup networkGroup = (NetworkGroup)((Object)Entities.uniqueResult((Object)((Object)(ownerFullName == null && vpcId != null ? NetworkGroup.namedForVpc(vpcId, name) : NetworkGroup.withUniqueName(ownerFullName, vpcId, name)))));
            return networkGroup;
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new NoSuchMetadataException("Failed to find security group: " + name + ", for vpc: " + vpcId + " for " + ownerFullName, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<NetworkGroup> lookupExtant() throws MetadataException {
        try (TransactionResource db = Entities.transactionFor(NetworkGroup.class);){
            List results = Entities.query((Object)((Object)NetworkGroup.withOwner(null)), (boolean)false, (Criterion)Restrictions.isNotNull((String)"extantNetwork.tag"), Collections.singletonMap("extantNetwork", "extantNetwork"));
            ArrayList ret = Lists.newArrayList((Iterable)results);
            db.commit();
            ArrayList arrayList = ret;
            return arrayList;
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new NoSuchMetadataException("Error looking up extant groups", ex);
        }
    }

    public static Function<NetworkGroup, String> groupId() {
        return FilterFunctions.GROUP_ID;
    }

    static void createDefault(OwnerFullName ownerFullName) throws MetadataException {
        try (TransactionResource tx = Entities.transactionFor(Vpc.class);){
            if (Iterables.tryFind((Iterable)Entities.query((Object)((Object)Vpc.exampleDefault(ownerFullName.getAccountNumber()))), (Predicate)Predicates.alwaysTrue()).isPresent()) {
                return;
            }
        }
        try {
            try {
                NetworkGroup net = (NetworkGroup)((Object)Transactions.find((Object)((Object)NetworkGroup.named((OwnerFullName)AccountFullName.getInstance((String)ownerFullName.getAccountNumber(), (String[])new String[0]), DEFAULT_NETWORK_NAME))));
                if (net == null) {
                    NetworkGroups.create(ownerFullName, DEFAULT_NETWORK_NAME, "default group");
                }
            }
            catch (TransactionException | NoSuchElementException ex) {
                try {
                    NetworkGroups.create(ownerFullName, DEFAULT_NETWORK_NAME, "default group");
                }
                catch (ConstraintViolationException constraintViolationException) {}
            }
        }
        catch (DuplicateMetadataException duplicateMetadataException) {
            // empty catch block
        }
    }

    public static String defaultNetworkName() {
        return DEFAULT_NETWORK_NAME;
    }

    public static NetworkGroup create(OwnerFullName ownerFullName, String groupName, String groupDescription) throws MetadataException {
        return NetworkGroups.create(ownerFullName, null, groupName, groupDescription);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NetworkGroup create(OwnerFullName ownerFullName, Vpc vpc, String groupName, String groupDescription) throws MetadataException {
        UserFullName userFullName = null;
        if (ownerFullName instanceof UserFullName) {
            userFullName = (UserFullName)ownerFullName;
        } else {
            try {
                User admin = Accounts.lookupAccountById((String)ownerFullName.getAccountNumber()).lookupAdmin();
                userFullName = UserFullName.getInstance((User)admin, (String[])new String[0]);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                throw new NoSuchMetadataException("Failed to create group because owning user could not be identified.", ex);
            }
        }
        String resourceDesc = groupName + (vpc != null ? " in " + vpc.getDisplayName() : "") + " for " + userFullName.toString();
        try (TransactionResource db = Entities.transactionFor(NetworkGroup.class);){
            try {
                Entities.uniqueResult((Object)((Object)NetworkGroup.withUniqueName((OwnerFullName)userFullName.asAccountFullName(), (String)CloudMetadatas.toDisplayName().apply((Object)vpc), groupName)));
                throw new DuplicateMetadataException("Failed to create group: " + resourceDesc);
            }
            catch (NoSuchElementException ex) {
                NetworkGroup entity = (NetworkGroup)((Object)Entities.persist((Object)((Object)NetworkGroup.create((OwnerFullName)userFullName, vpc, ResourceIdentifiers.generateString("sg"), groupName, groupDescription))));
                db.commit();
                NetworkGroup networkGroup = entity;
                return networkGroup;
            }
        }
        catch (ConstraintViolationException ex) {
            Logs.exhaust().error((Object)ex);
            throw new DuplicateMetadataException("Failed to create group: " + resourceDesc, ex);
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new MetadataException("Failed to create group: " + resourceDesc, PersistenceExceptions.transform((Throwable)ex));
        }
    }

    public static void resolvePermissions(Iterable<IpPermissionType> permissions, String defaultUserId, @Nullable String vpcId, boolean revoke) throws MetadataException {
        for (IpPermissionType ipPermission : permissions) {
            if (ipPermission.getGroups() == null) continue;
            for (UserIdGroupPairType groupInfo : ipPermission.getGroups()) {
                if (!Strings.isNullOrEmpty((String)groupInfo.getSourceGroupId())) {
                    try {
                        NetworkGroup networkGroup = NetworkGroups.lookupByGroupId(groupInfo.getSourceGroupId());
                        if (vpcId != null && !vpcId.equals(networkGroup.getVpcId())) {
                            throw new NoSuchMetadataException("Group (" + groupInfo.getSourceGroupId() + ") not found.");
                        }
                        groupInfo.setSourceUserId(networkGroup.getOwnerAccountNumber());
                        groupInfo.setSourceGroupName(networkGroup.getDisplayName());
                        continue;
                    }
                    catch (NoSuchMetadataException ex) {
                        if (revoke) continue;
                        throw ex;
                    }
                }
                if (Strings.isNullOrEmpty((String)groupInfo.getSourceGroupName())) {
                    throw new MetadataException("Group ID or Group Name required.");
                }
                try {
                    AccountFullName accountFullName = AccountFullName.getInstance((String)((String)Objects.firstNonNull((Object)Strings.emptyToNull((String)groupInfo.getSourceUserId()), (Object)defaultUserId)), (String[])new String[0]);
                    NetworkGroup networkGroup = vpcId == null ? NetworkGroups.lookup((OwnerFullName)accountFullName, groupInfo.getSourceGroupName()) : NetworkGroups.lookup((OwnerFullName)accountFullName, vpcId, groupInfo.getSourceGroupName());
                    groupInfo.setSourceGroupId(networkGroup.getGroupId());
                }
                catch (NoSuchMetadataException ex) {
                    if (revoke) continue;
                    throw ex;
                }
            }
        }
    }

    public static void flushRules() {
        if (EdgeNetworking.isEnabled()) {
            NetworkInfoBroadcaster.requestNetworkInfoBroadcast();
        }
    }

    static List<NetworkRule> ipPermissionAsNetworkRules(IpPermissionType ipPermission, boolean vpc) {
        return NetworkGroups.ipPermissionsAsNetworkRules(Collections.singletonList(ipPermission), vpc);
    }

    static List<NetworkRule> ipPermissionsAsNetworkRules(List<IpPermissionType> ipPermissions, boolean vpc) {
        ArrayList ruleList = Lists.newArrayList();
        for (IpPermissionType ipPerm : ipPermissions) {
            ruleList.addAll((vpc ? IpPermissionTypeAsNetworkRule.VPC : IpPermissionTypeAsNetworkRule.CLASSIC).apply(ipPerm));
        }
        return ruleList;
    }

    @RestrictedTypes.QuantityMetricFunction(value=CloudMetadata.NetworkGroupMetadata.class)
    public static enum CountNetworkGroups implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        public Long apply(@Nullable OwnerFullName input) {
            try (TransactionResource tx = Entities.transactionFor(NetworkGroup.class);){
                Long l = Entities.count((Object)((Object)NetworkGroup.withOwner(input)));
                return l;
            }
        }
    }

    private static enum FilterSetFunctions implements Function<NetworkGroup, Set<String>>
    {
        PERMISSION_CIDR{

            public Set<String> apply(NetworkGroup group) {
                HashSet result = Sets.newHashSet();
                for (NetworkRule rule : group.getNetworkRules()) {
                    result.addAll(rule.getIpRanges());
                }
                return result;
            }
        }
        ,
        PERMISSION_FROM_PORT{

            public Set<String> apply(NetworkGroup group) {
                HashSet result = Sets.newHashSet();
                for (NetworkRule rule : group.getNetworkRules()) {
                    result.addAll(Optional.fromNullable((Object)rule.getLowPort()).transform(Functions.toStringFunction()).asSet());
                }
                return result;
            }
        }
        ,
        PERMISSION_GROUP{

            public Set<String> apply(NetworkGroup group) {
                HashSet result = Sets.newHashSet();
                for (NetworkRule rule : group.getNetworkRules()) {
                    for (NetworkPeer peer : rule.getNetworkPeers()) {
                        if (peer.getGroupName() == null) continue;
                        result.add(peer.getGroupName());
                    }
                }
                return result;
            }
        }
        ,
        PERMISSION_GROUP_ID{

            public Set<String> apply(NetworkGroup group) {
                HashSet result = Sets.newHashSet();
                for (NetworkRule rule : group.getNetworkRules()) {
                    for (NetworkPeer peer : rule.getNetworkPeers()) {
                        if (peer.getGroupId() == null) continue;
                        result.add(peer.getGroupId());
                    }
                }
                return result;
            }
        }
        ,
        PERMISSION_PROTOCOL{

            public Set<String> apply(NetworkGroup group) {
                HashSet result = Sets.newHashSet();
                for (NetworkRule rule : group.getNetworkRules()) {
                    result.add(rule.getDisplayProtocol());
                }
                return result;
            }
        }
        ,
        PERMISSION_TO_PORT{

            public Set<String> apply(NetworkGroup group) {
                HashSet result = Sets.newHashSet();
                for (NetworkRule rule : group.getNetworkRules()) {
                    result.addAll(Optional.fromNullable((Object)rule.getHighPort()).transform(Functions.toStringFunction()).asSet());
                }
                return result;
            }
        }
        ,
        PERMISSION_ACCOUNT_ID{

            public Set<String> apply(NetworkGroup group) {
                HashSet result = Sets.newHashSet();
                for (NetworkRule rule : group.getNetworkRules()) {
                    for (NetworkPeer peer : rule.getNetworkPeers()) {
                        if (peer.getUserQueryKey() == null) continue;
                        result.add(peer.getUserQueryKey());
                    }
                }
                return result;
            }
        };

    }

    private static enum FilterFunctions implements Function<NetworkGroup, String>
    {
        ACCOUNT_ID{

            public String apply(NetworkGroup group) {
                return group.getOwnerAccountNumber();
            }
        }
        ,
        DESCRIPTION{

            public String apply(NetworkGroup group) {
                return group.getDescription();
            }
        }
        ,
        GROUP_ID{

            public String apply(NetworkGroup group) {
                return group.getGroupId();
            }
        }
        ,
        VPC_ID{

            public String apply(NetworkGroup group) {
                return group.getVpcId();
            }
        };

    }

    public static class NetworkGroupFilterSupport
    extends FilterSupport<NetworkGroup> {
        public NetworkGroupFilterSupport() {
            super(NetworkGroupFilterSupport.builderFor(NetworkGroup.class).withTagFiltering(NetworkGroupTag.class, "networkGroup").withStringProperty("description", FilterFunctions.DESCRIPTION).withStringProperty("group-id", FilterFunctions.GROUP_ID).withStringProperty("group-name", (Function<NetworkGroup, String>)CloudMetadatas.toDisplayName()).withStringSetProperty("ip-permission.cidr", FilterSetFunctions.PERMISSION_CIDR).withStringSetProperty("ip-permission.from-port", FilterSetFunctions.PERMISSION_FROM_PORT).withStringSetProperty("ip-permission.group-id", FilterSetFunctions.PERMISSION_GROUP_ID).withStringSetProperty("ip-permission.group-name", FilterSetFunctions.PERMISSION_GROUP).withStringSetProperty("ip-permission.protocol", FilterSetFunctions.PERMISSION_PROTOCOL).withStringSetProperty("ip-permission.to-port", FilterSetFunctions.PERMISSION_TO_PORT).withStringSetProperty("ip-permission.user-id", FilterSetFunctions.PERMISSION_ACCOUNT_ID).withStringProperty("owner-id", FilterFunctions.ACCOUNT_ID).withStringProperty("vpc-id", FilterFunctions.VPC_ID).withPersistenceAlias("networkRules", "networkRules").withPersistenceFilter("description").withPersistenceFilter("group-id", "groupId").withPersistenceFilter("group-name", "displayName").withPersistenceFilter("ip-permission.from-port", "networkRules.lowPort", FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("ip-permission.protocol", "networkRules.protocol", Enums.valueOfFunction(NetworkRule.Protocol.class)).withPersistenceFilter("ip-permission.to-port", "networkRules.highPort", FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("owner-id", "ownerAccountNumber").withPersistenceFilter("vpc-id", "vpcId"));
        }
    }

    @RestrictedTypes.Resolver(value=NetworkGroup.class)
    public static enum Lookup implements Function<String, NetworkGroup>
    {
        INSTANCE;


        public NetworkGroup apply(String identifier) {
            try {
                return NetworkGroups.lookupByGroupId(identifier);
            }
            catch (NoSuchMetadataException e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }

    public static enum IpPermissionTypeAsNetworkRule implements Function<IpPermissionType, List<NetworkRule>>
    {
        CLASSIC(false),
        VPC(true);

        private final boolean anyProtocolAllowed;

        private IpPermissionTypeAsNetworkRule(boolean anyProtocolAllowed) {
            this.anyProtocolAllowed = anyProtocolAllowed;
        }

        @Nonnull
        public List<NetworkRule> apply(IpPermissionType ipPerm) {
            ArrayList<NetworkRule> ruleList = new ArrayList<NetworkRule>();
            if (!ipPerm.getGroups().isEmpty()) {
                if (ipPerm.getFromPort() != null && ipPerm.getFromPort() == 0 && ipPerm.getToPort() != null && ipPerm.getToPort() == 0) {
                    ipPerm.setToPort(Integer.valueOf(65535));
                }
                ArrayList empty = Lists.newArrayList();
                if (ipPerm.getIpProtocol() == null) {
                    NetworkRule rule = NetworkRule.create(NetworkRule.Protocol.tcp, ipPerm.getFromPort(), ipPerm.getToPort(), IpPermissionTypeExtractNetworkPeers.INSTANCE.apply(ipPerm), empty);
                    ruleList.add(rule);
                    NetworkRule rule1 = NetworkRule.create(NetworkRule.Protocol.udp, ipPerm.getFromPort(), ipPerm.getToPort(), IpPermissionTypeExtractNetworkPeers.INSTANCE.apply(ipPerm), empty);
                    ruleList.add(rule1);
                    NetworkRule rule2 = NetworkRule.create(NetworkRule.Protocol.tcp, -1, -1, IpPermissionTypeExtractNetworkPeers.INSTANCE.apply(ipPerm), empty);
                    ruleList.add(rule2);
                } else {
                    NetworkRule rule = NetworkRule.create(ipPerm.getIpProtocol(), this.anyProtocolAllowed, ipPerm.getFromPort(), ipPerm.getToPort(), IpPermissionTypeExtractNetworkPeers.INSTANCE.apply(ipPerm), (Collection<String>)empty);
                    ruleList.add(rule);
                }
            } else if (!ipPerm.getCidrIpRanges().isEmpty()) {
                ArrayList ipRanges = Lists.newArrayList();
                for (String range : ipPerm.getCidrIpRanges()) {
                    String[] rangeParts = range.split("/");
                    try {
                        if (rangeParts.length != 2) {
                            throw new IllegalArgumentException();
                        }
                        if (Integer.parseInt(rangeParts[1]) > 32 || Integer.parseInt(rangeParts[1]) < 0) {
                            throw new IllegalArgumentException();
                        }
                        if (!(InetAddresses.forString((String)rangeParts[0]) instanceof Inet4Address)) continue;
                        ipRanges.add(range);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Invalid IP range: '" + range + "'");
                    }
                }
                NetworkRule rule = NetworkRule.create(ipPerm.getIpProtocol(), this.anyProtocolAllowed, ipPerm.getFromPort(), ipPerm.getToPort(), IpPermissionTypeExtractNetworkPeers.INSTANCE.apply(ipPerm), (Collection<String>)ipRanges);
                ruleList.add(rule);
            } else {
                throw new IllegalArgumentException("Invalid Ip Permissions:  must specify either a source cidr or user");
            }
            return ruleList;
        }
    }

    public static enum IpPermissionTypeExtractNetworkPeers implements Function<IpPermissionType, Collection<NetworkPeer>>
    {
        INSTANCE;


        public Collection<NetworkPeer> apply(IpPermissionType ipPerm) {
            ArrayList networkPeers = Lists.newArrayList();
            for (UserIdGroupPairType peerInfo : ipPerm.getGroups()) {
                networkPeers.add(new NetworkPeer(peerInfo.getSourceUserId(), peerInfo.getSourceGroupName(), peerInfo.getSourceGroupId()));
            }
            return networkPeers;
        }
    }

    @TypeMapper
    public static enum NetworkGroupAsSecurityGroupItem implements Function<NetworkGroup, SecurityGroupItemType>
    {
        INSTANCE;


        public SecurityGroupItemType apply(NetworkGroup input) {
            try (TransactionResource tx = Entities.transactionFor(NetworkGroup.class);){
                NetworkGroup netGroup = (NetworkGroup)((Object)Entities.merge((Object)((Object)input)));
                SecurityGroupItemType groupInfo = new SecurityGroupItemType(netGroup.getOwnerAccountNumber(), netGroup.getGroupId(), netGroup.getDisplayName(), netGroup.getDescription(), netGroup.getVpcId());
                Iterable ipPerms = Iterables.transform(netGroup.getIngressNetworkRules(), (Function)TypeMappers.lookup(NetworkRule.class, IpPermissionType.class));
                Iterables.addAll((Collection)groupInfo.getIpPermissions(), (Iterable)ipPerms);
                Iterable ipPermsEgress = Iterables.transform(netGroup.getEgressNetworkRules(), (Function)TypeMappers.lookup(NetworkRule.class, IpPermissionType.class));
                Iterables.addAll((Collection)groupInfo.getIpPermissionsEgress(), (Iterable)ipPermsEgress);
                SecurityGroupItemType securityGroupItemType = groupInfo;
                return securityGroupItemType;
            }
        }
    }

    @TypeMapper
    public static enum NetworkRuleAsIpPerm implements Function<NetworkRule, IpPermissionType>
    {
        INSTANCE;


        public IpPermissionType apply(NetworkRule rule) {
            IpPermissionType ipPerm = new IpPermissionType(rule.getDisplayProtocol(), rule.getLowPort(), rule.getHighPort());
            Iterable peers = Iterables.transform(rule.getNetworkPeers(), (Function)TypeMappers.lookup(NetworkPeer.class, UserIdGroupPairType.class));
            Iterables.addAll((Collection)ipPerm.getGroups(), (Iterable)peers);
            ipPerm.setCidrIpRanges(rule.getIpRanges());
            return ipPerm;
        }
    }

    @TypeMapper
    public static enum NetworkPeerAsUserIdGroupPairType implements Function<NetworkPeer, UserIdGroupPairType>
    {
        INSTANCE;


        public UserIdGroupPairType apply(NetworkPeer peer) {
            return new UserIdGroupPairType(peer.getUserQueryKey(), peer.getGroupName(), peer.getGroupId());
        }
    }

    private static enum NetworkIndexTransform implements Function<NetworkReportType, List<String>>
    {
        INSTANCE;


        public List<String> apply(@Nullable NetworkReportType networkReportType) {
            ArrayList taggedIndices = Lists.newArrayList();
            if (networkReportType != null && networkReportType.getAllocatedIndexes() != null) {
                for (String index : networkReportType.getAllocatedIndexes()) {
                    taggedIndices.add(networkReportType.getTag() + ":" + index);
                }
            }
            return taggedIndices;
        }
    }

    private static enum ActiveTags implements Function<NetworkReportType, Integer>
    {
        INSTANCE;

        private final SetMultimap<String, Integer> backingMap = HashMultimap.create();
        private final SetMultimap<String, Integer> activeTagsByPartition = Multimaps.synchronizedSetMultimap(this.backingMap);

        public Integer apply(NetworkReportType input) {
            return input.getTag();
        }

        private void update(ServiceConfiguration cluster, List<NetworkReportType> activeNetworks) {
            this.removeStalePartitions();
            HashSet activeTags = Sets.newHashSet((Iterable)Lists.transform(activeNetworks, (Function)INSTANCE));
            this.activeTagsByPartition.replaceValues((Object)cluster.getPartition(), (Iterable)activeTags);
        }

        private void removeStalePartitions() throws PersistenceException {
            HashSet partitions = Sets.newHashSet();
            for (ServiceConfiguration cc : ServiceConfigurations.list(ClusterController.class)) {
                partitions.add(cc.getPartition());
            }
            for (String stalePartition : Sets.difference((Set)this.activeTagsByPartition.keySet(), (Set)partitions)) {
                this.activeTagsByPartition.removeAll((Object)stalePartition);
            }
        }

        private boolean isActive(Integer tag) {
            return this.activeTagsByPartition.containsValue((Object)tag);
        }
    }

    public static class NetworkRangeConfiguration {
        private Boolean useNetworkTags = Boolean.TRUE;
        private Integer minNetworkTag = GLOBAL_MIN_NETWORK_TAG;
        private Integer maxNetworkTag = GLOBAL_MAX_NETWORK_TAG;
        private Long minNetworkIndex = GLOBAL_MIN_NETWORK_INDEX;
        private Long maxNetworkIndex = GLOBAL_MAX_NETWORK_INDEX;

        Boolean hasNetworking() {
            return this.useNetworkTags;
        }

        Boolean getUseNetworkTags() {
            return this.useNetworkTags;
        }

        void setUseNetworkTags(Boolean useNetworkTags) {
            this.useNetworkTags = useNetworkTags;
        }

        public Integer getMinNetworkTag() {
            return this.minNetworkTag;
        }

        public void setMinNetworkTag(Integer minNetworkTag) {
            this.minNetworkTag = minNetworkTag;
        }

        public Integer getMaxNetworkTag() {
            return this.maxNetworkTag;
        }

        public void setMaxNetworkTag(Integer maxNetworkTag) {
            this.maxNetworkTag = maxNetworkTag;
        }

        public Long getMaxNetworkIndex() {
            return this.maxNetworkIndex;
        }

        public void setMaxNetworkIndex(Long maxNetworkIndex) {
            this.maxNetworkIndex = maxNetworkIndex;
        }

        public Long getMinNetworkIndex() {
            return this.minNetworkIndex;
        }

        public void setMinNetworkIndex(Long minNetworkIndex) {
            this.minNetworkIndex = minNetworkIndex;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NetworkRangeConfiguration:");
            if (this.useNetworkTags != null) {
                builder.append("useNetworkTags=").append(this.useNetworkTags).append(":");
            }
            if (this.minNetworkTag != null) {
                builder.append("minNetworkTag=").append(this.minNetworkTag).append(":");
            }
            if (this.maxNetworkTag != null) {
                builder.append("maxNetworkTag=").append(this.maxNetworkTag).append(":");
            }
            if (this.minNetworkIndex != null) {
                builder.append("minNetworkIndex=").append(this.minNetworkIndex).append(":");
            }
            if (this.maxNetworkIndex != null) {
                builder.append("maxNetworkIndex=").append(this.maxNetworkIndex);
            }
            return builder.toString();
        }
    }
}

