/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_tags_network_groups")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="security-group")
public class NetworkGroupTag
extends Tag<NetworkGroupTag> {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="metadata_tag_resource_id", updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private NetworkGroup networkGroup;

    protected NetworkGroupTag() {
        super("security-group", ResourceIdFunction.INSTANCE);
    }

    public NetworkGroupTag(@Nonnull NetworkGroup networkGroup, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        super("security-group", ResourceIdFunction.INSTANCE, ownerFullName, key, value);
        this.setNetworkGroup(networkGroup);
        this.init();
    }

    public NetworkGroup getNetworkGroup() {
        return this.networkGroup;
    }

    public void setNetworkGroup(NetworkGroup networkGroup) {
        this.networkGroup = networkGroup;
    }

    @Nonnull
    public static Tag named(@Nonnull NetworkGroup networkGroup, @Nonnull OwnerFullName ownerFullName, @Nullable String key) {
        return NetworkGroupTag.namedWithValue(networkGroup, ownerFullName, key, null);
    }

    @Nonnull
    public static Tag namedWithValue(@Nonnull NetworkGroup networkGroup, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)((Object)networkGroup), (Object)"networkGroup");
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new NetworkGroupTag(networkGroup, ownerFullName, key, value);
    }

    public static final class NetworkGroupTagSupport
    extends TagSupport {
        public NetworkGroupTagSupport() {
            super(NetworkGroup.class, "sg", "groupId", "networkGroup", "InvalidGroup.NotFound", "The security group '%s' does not exist");
        }

        @Override
        public Tag createOrUpdate(CloudMetadata metadata, OwnerFullName ownerFullName, String key, String value) {
            return Tags.createOrUpdate(new NetworkGroupTag((NetworkGroup)metadata, ownerFullName, key, value));
        }

        @Override
        public Tag example(@Nonnull CloudMetadata metadata, @Nonnull OwnerFullName ownerFullName, String key, String value) {
            return NetworkGroupTag.namedWithValue((NetworkGroup)metadata, ownerFullName, key, value);
        }

        @Override
        public Tag example(@Nonnull OwnerFullName ownerFullName) {
            return this.example(new NetworkGroupTag(), ownerFullName);
        }

        @Override
        public CloudMetadata lookup(String identifier) throws TransactionException {
            return (CloudMetadata)Entities.uniqueResult((Object)((Object)NetworkGroup.withGroupId(null, identifier)));
        }
    }

    private static enum ResourceIdFunction implements Function<NetworkGroupTag, String>
    {
        INSTANCE{

            public String apply(NetworkGroupTag networkGroupTag) {
                return networkGroupTag.getNetworkGroup().getGroupId();
            }
        };

    }
}

