/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network;

import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.cloud.util.MetadataConstraintException;
import com.eucalyptus.cloud.util.MetadataException;
import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.compute.ClientComputeException;
import com.eucalyptus.compute.ClientUnauthorizedComputeException;
import com.eucalyptus.compute.ComputeException;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.IpPermissionType;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.compute.common.UserIdGroupPairType;
import com.eucalyptus.compute.common.backend.AuthorizeSecurityGroupEgressResponseType;
import com.eucalyptus.compute.common.backend.AuthorizeSecurityGroupEgressType;
import com.eucalyptus.compute.common.backend.AuthorizeSecurityGroupIngressResponseType;
import com.eucalyptus.compute.common.backend.AuthorizeSecurityGroupIngressType;
import com.eucalyptus.compute.common.backend.CreateSecurityGroupResponseType;
import com.eucalyptus.compute.common.backend.CreateSecurityGroupType;
import com.eucalyptus.compute.common.backend.DeleteSecurityGroupResponseType;
import com.eucalyptus.compute.common.backend.DeleteSecurityGroupType;
import com.eucalyptus.compute.common.backend.DescribeSecurityGroupsResponseType;
import com.eucalyptus.compute.common.backend.DescribeSecurityGroupsType;
import com.eucalyptus.compute.common.backend.RevokeSecurityGroupEgressResponseType;
import com.eucalyptus.compute.common.backend.RevokeSecurityGroupEgressType;
import com.eucalyptus.compute.common.backend.RevokeSecurityGroupIngressResponseType;
import com.eucalyptus.compute.common.backend.RevokeSecurityGroupIngressType;
import com.eucalyptus.compute.identifier.InvalidResourceIdentifier;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.compute.vpc.VpcConfiguration;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.network.NetworkRule;
import com.eucalyptus.records.Logs;
import com.eucalyptus.tags.Filter;
import com.eucalyptus.tags.Filters;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.Strings;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.ws.EucalyptusWebServiceException;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.persistence.EntityNotFoundException;
import org.hibernate.criterion.Criterion;

public class NetworkGroupManager {
    public CreateSecurityGroupResponseType create(CreateSecurityGroupType request) throws EucalyptusCloudException, MetadataException {
        final Context ctx = Contexts.lookup();
        final UserFullName userFullName = ctx.getUserFullName();
        AccountFullName accountFullName = userFullName.asAccountFullName();
        final String groupName = request.getGroupName();
        final String groupDescription = request.getGroupDescription();
        if (Strings.startsWith((String)"sg-").apply((Object)groupName)) {
            throw new ClientComputeException("InvalidParameterValue", "Value (" + groupName + ") for parameter GroupName is invalid. Group names may not be in the format sg-*");
        }
        final String vpcId = (String)Optional.fromNullable((Object)ResourceIdentifiers.tryNormalize().apply((Object)request.getVpcId())).or(Optional.fromNullable((Object)NetworkGroupManager.getDefaultVpcId(accountFullName))).orNull();
        if (vpcId == null && !CharMatcher.ASCII.matchesAllOf((CharSequence)groupName)) {
            throw new ClientComputeException("InvalidParameterValue", "Value (" + groupName + ") for parameter GroupName is invalid. Character sets beyond ASCII are not supported.");
        }
        if (vpcId != null && !NetworkGroups.VPC_GROUP_NAME_PATTERN.matcher(groupName).matches()) {
            throw new ClientComputeException("InvalidParameterValue", "Invalid security group name. Valid names are non-empty strings less than 256 characters from the following set:  a-zA-Z0-9. _-:/()#,@[]+=&;{}!$*");
        }
        if (vpcId == null && !CharMatcher.ASCII.matchesAllOf((CharSequence)groupDescription)) {
            throw new ClientComputeException("InvalidParameterValue", "Value (" + groupDescription + ") for parameter GroupDescription is invalid. Character sets beyond ASCII are not supported.");
        }
        if (vpcId != null && !NetworkGroups.VPC_GROUP_DESC_PATTERN.matcher(groupDescription).matches()) {
            throw new ClientComputeException("InvalidParameterValue", "Invalid security group description. Valid descriptions are strings less than 256 characters from the following set:  a-zA-Z0-9. _-:/()#,@[]+=&;{}!$*");
        }
        CreateSecurityGroupResponseType reply = (CreateSecurityGroupResponseType)request.getReply();
        try {
            Supplier<NetworkGroup> allocator = new Supplier<NetworkGroup>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public NetworkGroup get() {
                    try (TransactionResource tx = Entities.transactionFor(NetworkGroup.class);){
                        if (vpcId != null && Entities.count((Object)((Object)NetworkGroup.namedForVpc(vpcId, null))) >= (long)VpcConfiguration.getSecurityGroupsPerVpc()) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("SecurityGroupLimitExceeded", "Security group limit exceeded for " + vpcId)));
                        }
                        Vpc vpc = vpcId == null ? null : (Vpc)((Object)Entities.uniqueResult((Object)((Object)Vpc.exampleWithName((OwnerFullName)userFullName.asAccountFullName(), vpcId))));
                        NetworkGroup group = NetworkGroups.create((OwnerFullName)ctx.getUserFullName(), vpc, groupName, groupDescription);
                        if (vpc != null) {
                            group.getNetworkRules().addAll(Lists.newArrayList((Object[])new NetworkRule[]{NetworkRule.createEgress(null, -1, null, null, null, Collections.singleton("0.0.0.0/0"))}));
                        }
                        tx.commit();
                        NetworkGroup networkGroup = group;
                        return networkGroup;
                    }
                    catch (NoSuchElementException e) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidVpcID.NotFound", "The vpc ('" + vpcId + "') was not found")));
                    }
                    catch (MetadataException | TransactionException ex) {
                        throw Exceptions.toUndeclared((Throwable)ex);
                    }
                }
            };
            NetworkGroup group = (NetworkGroup)RestrictedTypes.allocateUnitlessResource((Supplier)allocator);
            reply.setGroupId(group.getGroupId());
            return reply;
        }
        catch (Exception ex) {
            Exceptions.findAndRethrow((Throwable)ex, ComputeException.class);
            String cause = Exceptions.causeString((Throwable)ex);
            if (cause.contains("DuplicateMetadataException")) {
                throw new ClientComputeException("InvalidGroup.Duplicate", "The security group '" + groupName + "' already exists");
            }
            throw new EucalyptusCloudException("CreateSecurityGroup failed because: " + cause, (Throwable)ex);
        }
    }

    public DeleteSecurityGroupResponseType delete(DeleteSecurityGroupType request) throws EucalyptusCloudException, MetadataException {
        Context ctx = Contexts.lookup();
        DeleteSecurityGroupResponseType reply = (DeleteSecurityGroupResponseType)request.getReply();
        NetworkGroup group = NetworkGroupManager.lookupGroup(request.getGroupId(), request.getGroupName());
        if (!RestrictedTypes.filterPrivileged().apply((Object)group)) {
            throw new ClientUnauthorizedComputeException("Not authorized to delete network group " + group.getDisplayName() + " for " + ctx.getUser().getName());
        }
        if (group.getVpcId() != null && NetworkGroups.defaultNetworkName().equals(group.getDisplayName())) {
            throw new ClientComputeException("CannotDelete", "Group (" + group.getGroupId() + ") cannot be deleted, it is the default group for " + group.getVpcId());
        }
        if (NetworkGroups.defaultNetworkName().equals(group.getDisplayName())) {
            NetworkGroups.createDefault((OwnerFullName)AccountFullName.getInstance((String)group.getOwnerAccountNumber(), (String[])new String[0]));
        }
        try {
            NetworkGroups.delete(group.getGroupId());
        }
        catch (MetadataConstraintException e) {
            throw new ClientComputeException(group.getVpcId() != null ? "DependencyViolation" : "InvalidGroup.InUse", "Specified group cannot be deleted because it is in use.");
        }
        return reply;
    }

    public DescribeSecurityGroupsResponseType describe(DescribeSecurityGroupsType request) throws EucalyptusCloudException, MetadataException, TransactionException {
        DescribeSecurityGroupsResponseType reply = (DescribeSecurityGroupsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        boolean showAll = request.getSecurityGroupSet().remove("verbose") || request.getSecurityGroupIdSet().remove("verbose");
        NetworkGroups.createDefault((OwnerFullName)ctx.getUserFullName());
        Filters.FiltersBuilder builder = Filters.generateFor(request.getFilterSet(), NetworkGroup.class);
        if (request.getSecurityGroupSet().isEmpty() && !request.getSecurityGroupIdSet().isEmpty() || !request.getSecurityGroupSet().isEmpty() && request.getSecurityGroupIdSet().isEmpty()) {
            builder.withOptionalInternalFilter("group-name", request.getSecurityGroupSet());
            builder.withOptionalInternalFilter("group-id", NetworkGroupManager.normalizeGroupIdentifiers(request.getSecurityGroupIdSet()));
        }
        Filter filter = builder.generate();
        Predicate requestedAndAccessible = CloudMetadatas.filteringFor(NetworkGroup.class).byPredicate(Predicates.or((Predicate[])new Predicate[]{request.getSecurityGroupSet().isEmpty() && request.getSecurityGroupIdSet().isEmpty() ? Predicates.alwaysTrue() : Predicates.alwaysFalse(), request.getSecurityGroupSet().isEmpty() ? Predicates.alwaysFalse() : CloudMetadatas.filterById((Collection)request.getSecurityGroupSet()), request.getSecurityGroupIdSet().isEmpty() ? Predicates.alwaysFalse() : CloudMetadatas.filterByProperty(NetworkGroupManager.normalizeGroupIdentifiers(request.getSecurityGroupIdSet()), NetworkGroups.groupId())})).byPredicate(filter.asPredicate()).byPrivileges().buildPredicate();
        AccountFullName ownerFn = Contexts.lookup().isAdministrator() && showAll ? null : AccountFullName.getInstance((Account)ctx.getAccount(), (String[])new String[0]);
        Iterable securityGroupItems = (Iterable)Entities.asDistinctTransaction(NetworkGroup.class, (Function)new Function<Void, Iterable<SecurityGroupItemType>>((OwnerFullName)ownerFn, filter, requestedAndAccessible){
            final /* synthetic */ OwnerFullName val$ownerFn;
            final /* synthetic */ Filter val$filter;
            final /* synthetic */ Predicate val$requestedAndAccessible;
            {
                this.val$ownerFn = ownerFullName;
                this.val$filter = filter;
                this.val$requestedAndAccessible = predicate;
            }

            @Nullable
            public Iterable<SecurityGroupItemType> apply(@Nullable Void aVoid) {
                try {
                    return Transactions.filteredTransform((Object)((Object)NetworkGroup.withOwner(this.val$ownerFn)), (Criterion)this.val$filter.asCriterion(), this.val$filter.getAliases(), (Predicate)this.val$requestedAndAccessible, (Function)TypeMappers.lookup(NetworkGroup.class, SecurityGroupItemType.class));
                }
                catch (TransactionException e) {
                    if (Exceptions.isCausedBy((Throwable)e, EntityNotFoundException.class)) {
                        throw new Entities.RetryTransactionException((Throwable)e, NetworkGroup.class);
                    }
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }
        }).apply(null);
        Map<String, List<Tag>> tagsMap = TagSupport.forResourceClass(NetworkGroup.class).getResourceTagMap((OwnerFullName)AccountFullName.getInstance((Account)ctx.getAccount(), (String[])new String[0]), Iterables.transform((Iterable)securityGroupItems, (Function)SecurityGroupItemToGroupId.INSTANCE));
        for (SecurityGroupItemType securityGroupItem : securityGroupItems) {
            Tags.addFromTags(securityGroupItem.getTagSet(), ResourceTag.class, (Iterable<Tag>)tagsMap.get(securityGroupItem.getGroupId()));
        }
        Iterables.addAll((Collection)reply.getSecurityGroupInfo(), (Iterable)securityGroupItems);
        return reply;
    }

    public RevokeSecurityGroupIngressResponseType revokeSecurityGroupIngress(final RevokeSecurityGroupIngressType request) throws EucalyptusCloudException {
        RevokeSecurityGroupIngressResponseType reply = (RevokeSecurityGroupIngressResponseType)request.getReply().markFailed();
        final Context ctx = Contexts.lookup();
        Predicate<Void> updateFunction = new Predicate<Void>(){

            public boolean apply(@Nullable Void aVoid) {
                block7: {
                    try {
                        NetworkGroup ruleGroup = NetworkGroupManager.lookupGroup(request.getGroupId(), request.getGroupName());
                        List ipPermissions = NetworkGroupManager.this.handleOldAndNewIpPermissions(ruleGroup.getVpcId() != null, request.getCidrIp(), request.getIpProtocol(), request.getFromPort(), request.getToPort(), request.getSourceSecurityGroupName(), request.getSourceSecurityGroupOwnerId(), request.getIpPermissions());
                        if (RestrictedTypes.filterPrivileged().apply((Object)ruleGroup)) {
                            try {
                                NetworkGroups.resolvePermissions(ipPermissions, ctx.getUser().getAccountNumber(), ruleGroup.getVpcId(), true);
                                Iterators.removeAll(ruleGroup.getNetworkRules().iterator(), NetworkGroups.ipPermissionsAsNetworkRules(ipPermissions, ruleGroup.getVpcId() != null));
                                break block7;
                            }
                            catch (IllegalArgumentException e) {
                                throw new ClientComputeException("InvalidPermission.Malformed", e.getMessage());
                            }
                            catch (NoSuchMetadataException e) {
                                throw new ClientComputeException("InvalidGroup.NotFound", e.getMessage());
                            }
                        }
                        throw new ClientUnauthorizedComputeException("Not authorized to revoke network group " + request.getGroupName() + " for " + ctx.getUser().getName());
                    }
                    catch (EntityNotFoundException e) {
                        throw new Entities.RetryTransactionException((Throwable)e);
                    }
                    catch (Exception e) {
                        throw Exceptions.toUndeclared((Throwable)e);
                    }
                }
                return true;
            }
        };
        try {
            reply.set_return(Boolean.valueOf(Entities.asDistinctTransaction(NetworkGroup.class, (Predicate)updateFunction).apply(null)));
            NetworkGroups.flushRules();
        }
        catch (Exception ex) {
            Exceptions.findAndRethrow((Throwable)ex, EucalyptusCloudException.class, EucalyptusWebServiceException.class);
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new EucalyptusCloudException("RevokeSecurityGroupIngress failed because: " + ex.getMessage(), (Throwable)ex);
        }
        return reply;
    }

    public AuthorizeSecurityGroupIngressResponseType authorizeSecurityGroupIngress(final AuthorizeSecurityGroupIngressType request) throws Exception {
        AuthorizeSecurityGroupIngressResponseType reply = (AuthorizeSecurityGroupIngressResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        Predicate<Void> updateFunction = new Predicate<Void>(){

            public boolean apply(@Nullable Void aVoid) {
                try {
                    NetworkGroup ruleGroup = NetworkGroupManager.lookupGroup(request.getGroupId(), request.getGroupName());
                    if (!RestrictedTypes.filterPrivileged().apply((Object)ruleGroup)) {
                        throw new ClientUnauthorizedComputeException("Not authorized to authorize network group " + ruleGroup.getDisplayName() + " for " + ctx.getUser().getName());
                    }
                    final ArrayList ruleList = Lists.newArrayList();
                    List ipPermissions = NetworkGroupManager.this.handleOldAndNewIpPermissions(ruleGroup.getVpcId() != null, request.getCidrIp(), request.getIpProtocol(), request.getFromPort(), request.getToPort(), request.getSourceSecurityGroupName(), request.getSourceSecurityGroupOwnerId(), request.getIpPermissions());
                    try {
                        NetworkGroups.resolvePermissions(ipPermissions, ctx.getUser().getAccountNumber(), ruleGroup.getVpcId(), false);
                    }
                    catch (NoSuchMetadataException e) {
                        throw new ClientComputeException("InvalidGroup.NotFound", e.getMessage());
                    }
                    for (IpPermissionType ipPerm : ipPermissions) {
                        if (ipPerm.getCidrIpRanges().isEmpty() && ipPerm.getGroups().isEmpty()) continue;
                        if (ipPerm.getIpProtocol() != null && !NetworkRule.PROTOCOL_PATTERN.matcher(ipPerm.getIpProtocol()).matches()) {
                            throw new ClientComputeException("InvalidPermission.Malformed", "Invalid protocol (" + ipPerm.getIpProtocol() + ")");
                        }
                        try {
                            List<NetworkRule> rules = NetworkGroups.ipPermissionAsNetworkRules(ipPerm, ruleGroup.getVpcId() != null);
                            ruleList.addAll(rules);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new ClientComputeException("InvalidPermission.Malformed", ex.getMessage());
                        }
                    }
                    if (Iterables.any(ruleGroup.getNetworkRules(), (Predicate)new Predicate<NetworkRule>(){

                        public boolean apply(NetworkRule rule) {
                            return Iterables.any((Iterable)ruleList, (Predicate)Predicates.equalTo((Object)((Object)rule)));
                        }
                    })) {
                        return false;
                    }
                    ruleGroup.getNetworkRules().addAll(ruleList);
                    if (ruleGroup.getVpcId() != null && ruleGroup.getNetworkRules().size() > VpcConfiguration.getRulesPerSecurityGroup()) {
                        throw new ClientComputeException("RulesPerSecurityGroupLimitExceeded", "Rules limit exceeded for " + request.getGroupId());
                    }
                }
                catch (Exception e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
                return true;
            }
        };
        try {
            reply.set_return(Boolean.valueOf(Entities.asDistinctTransaction(NetworkGroup.class, (Predicate)updateFunction).apply(null)));
            NetworkGroups.flushRules();
        }
        catch (Exception ex) {
            Exceptions.findAndRethrow((Throwable)ex, EucalyptusCloudException.class, EucalyptusWebServiceException.class);
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        return reply;
    }

    public AuthorizeSecurityGroupEgressResponseType authorizeSecurityGroupEgress(final AuthorizeSecurityGroupEgressType request) throws Exception {
        AuthorizeSecurityGroupEgressResponseType reply = (AuthorizeSecurityGroupEgressResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        Predicate<Void> updateFunction = new Predicate<Void>(){

            public boolean apply(@Nullable Void aVoid) {
                try {
                    NetworkGroup ruleGroup = NetworkGroupManager.lookupGroup(request.getGroupId(), null);
                    if (!RestrictedTypes.filterPrivileged().apply((Object)ruleGroup)) {
                        throw new ClientUnauthorizedComputeException("Not authorized to authorize network group " + ruleGroup.getDisplayName() + " for " + ctx.getUser().getName());
                    }
                    if (ruleGroup.getVpcId() == null) {
                        throw new ClientComputeException("InvalidGroup.NotFound", "VPC security group (" + request.getGroupId() + ") not found");
                    }
                    final ArrayList ruleList = Lists.newArrayList();
                    ArrayList ipPermissions = request.getIpPermissions();
                    try {
                        NetworkGroups.resolvePermissions(ipPermissions, ctx.getUser().getAccountNumber(), ruleGroup.getVpcId(), false);
                    }
                    catch (NoSuchMetadataException e) {
                        throw new ClientComputeException("InvalidGroup.NotFound", e.getMessage());
                    }
                    for (IpPermissionType ipPerm : ipPermissions) {
                        if (ipPerm.getCidrIpRanges().isEmpty() && ipPerm.getGroups().isEmpty()) continue;
                        if (ipPerm.getIpProtocol() == null || !NetworkRule.PROTOCOL_PATTERN.matcher(ipPerm.getIpProtocol()).matches()) {
                            throw new ClientComputeException("InvalidPermission.Malformed", "Invalid protocol (" + ipPerm.getIpProtocol() + ")");
                        }
                        try {
                            List<NetworkRule> rules = NetworkGroups.ipPermissionAsNetworkRules(ipPerm, ruleGroup.getVpcId() != null);
                            for (NetworkRule rule : rules) {
                                rule.setEgress(true);
                            }
                            ruleList.addAll(rules);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new ClientComputeException("InvalidPermission.Malformed", ex.getMessage());
                        }
                    }
                    if (Iterables.any(ruleGroup.getNetworkRules(), (Predicate)new Predicate<NetworkRule>(){

                        public boolean apply(NetworkRule rule) {
                            return Iterables.any((Iterable)ruleList, (Predicate)Predicates.equalTo((Object)((Object)rule)));
                        }
                    })) {
                        return false;
                    }
                    ruleGroup.getNetworkRules().addAll(ruleList);
                    if (ruleGroup.getVpcId() != null && ruleGroup.getNetworkRules().size() > VpcConfiguration.getRulesPerSecurityGroup()) {
                        throw new ClientComputeException("RulesPerSecurityGroupLimitExceeded", "Rules limit exceeded for " + request.getGroupId());
                    }
                }
                catch (Exception e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
                return true;
            }
        };
        try {
            reply.set_return(Boolean.valueOf(Entities.asDistinctTransaction(NetworkGroup.class, (Predicate)updateFunction).apply(null)));
            NetworkGroups.flushRules();
        }
        catch (Exception ex) {
            Exceptions.findAndRethrow((Throwable)ex, EucalyptusCloudException.class, EucalyptusWebServiceException.class);
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        return reply;
    }

    public RevokeSecurityGroupEgressResponseType revokeSecurityGroupEgress(final RevokeSecurityGroupEgressType request) throws EucalyptusCloudException {
        RevokeSecurityGroupEgressResponseType reply = (RevokeSecurityGroupEgressResponseType)request.getReply().markFailed();
        final Context ctx = Contexts.lookup();
        Predicate<Void> updateFunction = new Predicate<Void>(){

            public boolean apply(@Nullable Void aVoid) {
                block9: {
                    try {
                        NetworkGroup ruleGroup = NetworkGroupManager.lookupGroup(request.getGroupId(), null);
                        ArrayList ipPermissions = request.getIpPermissions();
                        if (RestrictedTypes.filterPrivileged().apply((Object)ruleGroup)) {
                            if (ruleGroup.getVpcId() == null) {
                                throw new ClientComputeException("InvalidGroup.NotFound", "VPC security group (" + request.getGroupId() + ") not found");
                            }
                            try {
                                List<NetworkRule> rules = NetworkGroups.ipPermissionsAsNetworkRules(ipPermissions, true);
                                for (NetworkRule rule : rules) {
                                    rule.setEgress(true);
                                }
                                NetworkGroups.resolvePermissions(ipPermissions, ctx.getUser().getAccountNumber(), ruleGroup.getVpcId(), true);
                                Iterators.removeAll(ruleGroup.getNetworkRules().iterator(), rules);
                                break block9;
                            }
                            catch (IllegalArgumentException e) {
                                throw new ClientComputeException("InvalidPermission.Malformed", e.getMessage());
                            }
                            catch (NoSuchMetadataException e) {
                                throw new ClientComputeException("InvalidGroup.NotFound", e.getMessage());
                            }
                        }
                        throw new ClientUnauthorizedComputeException("Not authorized to revoke network group " + request.getGroupId() + " for " + ctx.getUser().getName());
                    }
                    catch (EntityNotFoundException e) {
                        throw new Entities.RetryTransactionException((Throwable)e);
                    }
                    catch (Exception e) {
                        throw Exceptions.toUndeclared((Throwable)e);
                    }
                }
                return true;
            }
        };
        try {
            reply.set_return(Boolean.valueOf(Entities.asDistinctTransaction(NetworkGroup.class, (Predicate)updateFunction).apply(null)));
            NetworkGroups.flushRules();
        }
        catch (Exception ex) {
            Exceptions.findAndRethrow((Throwable)ex, EucalyptusCloudException.class, EucalyptusWebServiceException.class);
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new EucalyptusCloudException("RevokeSecurityGroupEgress failed because: " + ex.getMessage(), (Throwable)ex);
        }
        return reply;
    }

    private List<IpPermissionType> handleOldAndNewIpPermissions(boolean isVpcGroup, String cidrIp, String ipProtocol, Integer fromPort, Integer toPort, String sourceSecurityGroupName, String sourceSecurityGroupOwnerId, ArrayList<IpPermissionType> ipPermissions) throws MetadataException {
        Object value;
        HashMap condition1Params = Maps.newHashMap();
        condition1Params.put("cidrIp", cidrIp);
        condition1Params.put("ipProtocol", ipProtocol);
        if (!isVpcGroup) {
            condition1Params.put("fromPort", fromPort);
            condition1Params.put("toPort", toPort);
        }
        HashMap condition2Params = Maps.newHashMap();
        condition2Params.put("sourceSecurityGroupName", sourceSecurityGroupName);
        condition2Params.put("sourceSecurityGroupOwnerId", sourceSecurityGroupOwnerId);
        if (ipPermissions != null && ipPermissions.size() > 0) {
            Object value2;
            for (String key : condition1Params.keySet()) {
                value2 = condition1Params.get(key);
                if (value2 == null) continue;
                throw new MetadataException("InvalidParameterCombination: " + key + " and ipPermissions must not both be set");
            }
            for (String key : condition2Params.keySet()) {
                value2 = condition2Params.get(key);
                if (value2 == null) continue;
                throw new MetadataException("InvalidParameterCombination: " + key + " and ipPermissions must not both be set");
            }
            return ipPermissions;
        }
        String unsetCondition2Key = null;
        String setCondition2Key = null;
        for (String key : condition2Params.keySet()) {
            value = condition2Params.get(key);
            if (value == null && unsetCondition2Key == null) {
                unsetCondition2Key = key;
                continue;
            }
            if (value == null || setCondition2Key != null) continue;
            setCondition2Key = key;
        }
        if (setCondition2Key != null) {
            if (unsetCondition2Key != null) {
                throw new MetadataException("MissingParameter: " + unsetCondition2Key + " must be set if " + setCondition2Key + " is set.");
            }
            if (isVpcGroup) {
                throw new MetadataException("MissingParameter: IpProtocol");
            }
            for (String key : condition1Params.keySet()) {
                value = condition1Params.get(key);
                if (value == null) continue;
                throw new MetadataException("InvalidParameterCombination: " + key + " and " + setCondition2Key + " must not both be set");
            }
            IpPermissionType tcpPermission = new IpPermissionType("tcp", Integer.valueOf(1), Integer.valueOf(65535));
            tcpPermission.setGroups(Lists.newArrayList((Object[])new UserIdGroupPairType[]{new UserIdGroupPairType(sourceSecurityGroupOwnerId, sourceSecurityGroupName, null)}));
            IpPermissionType udpPermission = new IpPermissionType("udp", Integer.valueOf(1), Integer.valueOf(65535));
            udpPermission.setGroups(Lists.newArrayList((Object[])new UserIdGroupPairType[]{new UserIdGroupPairType(sourceSecurityGroupOwnerId, sourceSecurityGroupName, null)}));
            IpPermissionType icmpPermission = new IpPermissionType("icmp", Integer.valueOf(-1), Integer.valueOf(-1));
            icmpPermission.setGroups(Lists.newArrayList((Object[])new UserIdGroupPairType[]{new UserIdGroupPairType(sourceSecurityGroupOwnerId, sourceSecurityGroupName, null)}));
            return Lists.newArrayList((Object[])new IpPermissionType[]{tcpPermission, udpPermission, icmpPermission});
        }
        String unsetCondition1Key = null;
        String setCondition1Key = null;
        for (String key : condition1Params.keySet()) {
            Object value3 = condition1Params.get(key);
            if (value3 == null && unsetCondition1Key == null) {
                unsetCondition1Key = key;
                continue;
            }
            if (value3 == null || setCondition1Key != null) continue;
            setCondition1Key = key;
        }
        if (setCondition1Key != null) {
            if (unsetCondition1Key != null) {
                throw new MetadataException("MissingParameter: " + unsetCondition1Key + " must be set if " + setCondition1Key + " is set.");
            }
            IpPermissionType permission = new IpPermissionType(ipProtocol, fromPort, toPort);
            permission.setCidrIpRanges((Collection)Lists.newArrayList((Object[])new String[]{cidrIp}));
            return Lists.newArrayList((Object[])new IpPermissionType[]{permission});
        }
        throw new MetadataException("Missing source specification: include source security group or CIDR information");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NetworkGroup lookupGroup(String groupId, String groupName) throws EucalyptusCloudException, MetadataException {
        Context ctx = Contexts.lookup();
        AccountFullName lookUpGroupAccount = ctx.getUserFullName().asAccountFullName();
        try (TransactionResource tx = Entities.transactionFor(NetworkGroup.class);){
            if (groupName != null) {
                String defaultVpcId = NetworkGroupManager.getDefaultVpcId(lookUpGroupAccount);
                if (defaultVpcId != null) {
                    NetworkGroup networkGroup = NetworkGroups.lookup((OwnerFullName)lookUpGroupAccount, defaultVpcId, groupName);
                    return networkGroup;
                }
                NetworkGroup networkGroup = NetworkGroups.lookup((OwnerFullName)lookUpGroupAccount, groupName);
                return networkGroup;
            }
            if (groupId != null) {
                NetworkGroup networkGroup = NetworkGroups.lookupByGroupId((OwnerFullName)(ctx.isAdministrator() ? null : lookUpGroupAccount), NetworkGroupManager.normalizeGroupIdentifier(groupId));
                return networkGroup;
            }
            throw new EucalyptusCloudException("Group id or name required");
        }
        catch (NoSuchMetadataException e) {
            throw new ClientComputeException("InvalidGroup.NotFound", String.format("The security group '%s' does not exist", Objects.firstNonNull((Object)groupName, (Object)groupId)));
        }
    }

    private static String getDefaultVpcId(AccountFullName accountFullName) {
        try (TransactionResource tx = Entities.transactionFor(Vpc.class);){
            String string = (String)Iterables.tryFind((Iterable)Entities.query((Object)((Object)Vpc.exampleDefault((OwnerFullName)accountFullName))), (Predicate)Predicates.alwaysTrue()).transform(CloudMetadatas.toDisplayName()).orNull();
            return string;
        }
    }

    private static String normalizeIdentifier(String identifier, String prefix, boolean required, String message) throws ClientComputeException {
        try {
            return com.google.common.base.Strings.emptyToNull((String)identifier) == null && !required ? null : ResourceIdentifiers.parse(prefix, identifier).getIdentifier();
        }
        catch (InvalidResourceIdentifier e) {
            throw new ClientComputeException("InvalidGroupId.Malformed", String.format(message, e.getIdentifier()));
        }
    }

    private static String normalizeGroupIdentifier(String identifier) throws EucalyptusCloudException {
        return NetworkGroupManager.normalizeIdentifier(identifier, "sg", true, "Invalid id: \"%s\" (expecting \"sg-...\")");
    }

    private static List<String> normalizeGroupIdentifiers(List<String> identifiers) throws EucalyptusCloudException {
        try {
            return ResourceIdentifiers.normalize("sg", identifiers);
        }
        catch (InvalidResourceIdentifier e) {
            throw new ClientComputeException("InvalidGroupId.Malformed", "Invalid id: \"" + e.getIdentifier() + "\" (expecting \"sg-...\")");
        }
    }

    private static enum SecurityGroupItemToGroupId implements Function<SecurityGroupItemType, String>
    {
        INSTANCE{

            public String apply(SecurityGroupItemType securityGroupItemType) {
                return securityGroupItemType.getGroupId();
            }
        };

    }
}

