/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.DatabaseAuthProvider;
import com.eucalyptus.auth.api.AccountProvider;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.cloud.util.NotEnoughResourcesException;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransientEntityException;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.network.ExtantNetwork;
import com.eucalyptus.network.NetworkGroupTag;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.network.NetworkPeer;
import com.eucalyptus.network.NetworkRule;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.Numbers;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import groovy.sql.Sql;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_network_group")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class NetworkGroup
extends UserMetadata<State>
implements CloudMetadata.NetworkGroupMetadata {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(NetworkGroup.class);
    public static final String ID_PREFIX = "sg";
    @Column(name="metadata_network_group_id", unique=true)
    private String groupId;
    @Column(name="metadata_network_group_description")
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="metadata_vpc", updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Vpc vpc;
    @Column(name="metadata_vpc_id", updatable=false)
    private String vpcId;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="metadata_network_group_rule_fk")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<NetworkRule> networkRules = new HashSet<NetworkRule>();
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, optional=true, orphanRemoval=true, mappedBy="networkGroup")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private ExtantNetwork extantNetwork;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="networkGroup")
    private Collection<NetworkGroupTag> tags;

    protected NetworkGroup() {
    }

    protected NetworkGroup(OwnerFullName ownerFullName) {
        super(ownerFullName);
    }

    protected NetworkGroup(OwnerFullName ownerFullName, String groupName) {
        super(ownerFullName, groupName);
    }

    protected NetworkGroup(OwnerFullName ownerFullName, Vpc vpc, String groupId, String groupName, String groupDescription) {
        this(ownerFullName, groupName);
        Parameters.checkParam((Object)groupDescription, (Matcher)Matchers.notNullValue());
        this.vpc = vpc;
        this.vpcId = (String)CloudMetadatas.toDisplayName().apply((Object)vpc);
        this.description = groupDescription;
        this.groupId = groupId;
    }

    protected NetworkGroup(String naturalId) {
        this.setNaturalId(naturalId);
    }

    public static NetworkGroup create(OwnerFullName ownerFullName, Vpc vpc, String groupId, String groupName, String groupDescription) {
        return new NetworkGroup(ownerFullName, vpc, groupId, groupName, groupDescription);
    }

    public static NetworkGroup withOwner(OwnerFullName ownerFullName) {
        return new NetworkGroup(ownerFullName);
    }

    public static NetworkGroup named(@Nonnull OwnerFullName ownerFullName, String groupName) {
        return groupName == null ? NetworkGroup.withOwner(ownerFullName) : NetworkGroup.withUniqueName(ownerFullName, null, groupName);
    }

    public static NetworkGroup withNaturalId(String naturalId) {
        return new NetworkGroup(naturalId);
    }

    public static NetworkGroup withGroupId(OwnerFullName ownerFullName, String groupId) {
        return NetworkGroup.networkGroupWithGroupId(ownerFullName, groupId);
    }

    public static NetworkGroup withUniqueName(@Nonnull OwnerFullName ownerFullName, @Nullable String vpcId, String groupName) {
        NetworkGroup networkGroup = new NetworkGroup(ownerFullName);
        networkGroup.setUniqueName(NetworkGroup.createUniqueName(ownerFullName.getAccountNumber(), vpcId, groupName));
        return networkGroup;
    }

    public static NetworkGroup namedForVpc(String vpcId, String groupName) {
        NetworkGroup networkGroup = new NetworkGroup(null, groupName);
        networkGroup.setVpcId(vpcId);
        return networkGroup;
    }

    private static NetworkGroup networkGroupWithGroupId(OwnerFullName ownerFullName, String groupId) {
        NetworkGroup findGroupWithId = new NetworkGroup(ownerFullName);
        findGroupWithId.setGroupId(groupId);
        return findGroupWithId;
    }

    private static String createUniqueName(String accountNumber, String vpcId, String groupName) {
        return vpcId == null ? accountNumber + ":" + groupName : accountNumber + "\u05c3" + vpcId + "\u05c3" + groupName;
    }

    protected String createUniqueName() {
        return NetworkGroup.createUniqueName(this.getOwnerAccountNumber(), this.getVpcId(), this.getDisplayName());
    }

    @PreRemove
    private void preRemove() {
        if (this.extantNetwork != null && this.extantNetwork.teardown()) {
            Entities.delete((Object)((Object)this.extantNetwork));
            this.extantNetwork = null;
        }
    }

    @PrePersist
    @PreUpdate
    private void prePersist() {
        if (this.getState() == null) {
            this.setState(State.PENDING);
        }
    }

    @Nullable
    public Vpc getVpc() {
        return this.vpc;
    }

    protected void setVpc(Vpc vpc) {
        this.vpc = vpc;
    }

    @Nullable
    public String getVpcId() {
        return this.vpcId;
    }

    protected void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroupId() {
        return this.groupId;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public Set<NetworkRule> getNetworkRules() {
        return this.networkRules;
    }

    public Iterable<NetworkRule> getIngressNetworkRules() {
        return Iterables.filter(this.getNetworkRules(), (Predicate)Predicates.not(NetworkRule.egress()));
    }

    public Iterable<NetworkRule> getEgressNetworkRules() {
        return Iterables.filter(this.getNetworkRules(), NetworkRule.egress());
    }

    private void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    private void setNetworkRules(Set<NetworkRule> networkRules) {
        this.networkRules = networkRules;
    }

    public String getPartition() {
        return ((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name();
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"security-group", this.getDisplayName()});
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getUniqueName() == null ? 0 : this.getUniqueName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        NetworkGroup other = (NetworkGroup)((Object)obj);
        return !(this.getUniqueName() == null ? other.getUniqueName() != null : !this.getUniqueName().equals(other.getUniqueName()));
    }

    public String toString() {
        return String.format("NetworkRulesGroup:%s:description=%s:networkRules=%s", this.getUniqueName(), this.description, Entities.isReadable(this.networkRules) ? this.networkRules : "<Not loaded>");
    }

    public String getClusterNetworkName() {
        return this.getOwnerAccountNumber() + "-" + this.getNaturalId();
    }

    public ExtantNetwork reclaim(Integer i) throws NotEnoughResourcesException, TransientEntityException {
        if (!Entities.isPersistent((Object)((Object)this))) {
            throw new TransientEntityException(this.toString());
        }
        ExtantNetwork exNet = (ExtantNetwork)((Object)Entities.persist((Object)((Object)ExtantNetwork.create(this, i))));
        this.setExtantNetwork(exNet);
        return this.getExtantNetwork();
    }

    public ExtantNetwork extantNetwork() throws NotEnoughResourcesException, TransientEntityException {
        if (!Entities.isPersistent((Object)((Object)this))) {
            throw new TransientEntityException(this.toString());
        }
        ExtantNetwork exNet = this.getExtantNetwork();
        if (exNet == null) {
            for (Integer i : Numbers.shuffled(NetworkGroups.networkTagInterval())) {
                try {
                    Entities.uniqueResult((Object)((Object)ExtantNetwork.named(i)));
                }
                catch (Exception ex) {
                    exNet = ExtantNetwork.create(this, i);
                    Entities.persist((Object)((Object)exNet));
                    this.setExtantNetwork(exNet);
                    return this.getExtantNetwork();
                }
            }
            throw new NotEnoughResourcesException("Failed to allocate network tag for network: " + this.getFullName() + ": no network tags are free.");
        }
        return this.getExtantNetwork();
    }

    ExtantNetwork getExtantNetwork() {
        return this.extantNetwork;
    }

    void setExtantNetwork(ExtantNetwork extantNetwork) {
        this.extantNetwork = extantNetwork;
    }

    public boolean hasExtantNetwork() {
        return this.extantNetwork != null;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    @Upgrades.PreUpgrade(value=Eucalyptus.class, since=Upgrades.Version.v4_1_0)
    public static class NetworkGroupPreUpgrade34
    implements Callable<Boolean> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try (Sql sql = null;){
                sql = Upgrades.DatabaseFilters.NEWVERSION.getConnection("eucalyptus_cloud");
                sql.execute("alter table metadata_network_group drop column if exists vm_network_index");
                Boolean bl = true;
                return bl;
            }
        }
    }

    @Upgrades.EntityUpgrade(entities={NetworkGroup.class}, since=Upgrades.Version.v3_3_0, value=Eucalyptus.class)
    public static enum NetworkGroupUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(Class arg0) {
            this.addSecurityGroupIdentifiers();
            this.addSecurityGroupIdentifiersToRules();
            return true;
        }

        private void addSecurityGroupIdentifiers() {
            EntityTransaction db = Entities.get(NetworkGroup.class);
            try {
                List networkGroupList = Entities.query((Object)((Object)new NetworkGroup()));
                HashSet generatedIdentifiers = Sets.newHashSet((Iterable)Iterables.transform((Iterable)networkGroupList, (Function)RestrictedTypes.toDisplayName()));
                for (NetworkGroup networkGroup : networkGroupList) {
                    LOG.debug((Object)("Upgrading " + networkGroup.getDisplayName()));
                    if (networkGroup.getGroupId() != null) continue;
                    String networkGroupId = null;
                    while (networkGroupId == null || generatedIdentifiers.contains(networkGroupId)) {
                        networkGroupId = ResourceIdentifiers.generateString(NetworkGroup.ID_PREFIX);
                    }
                    generatedIdentifiers.add(networkGroupId);
                    networkGroup.setGroupId(networkGroupId);
                }
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
            finally {
                if (db.isActive()) {
                    db.rollback();
                }
            }
        }

        private void addSecurityGroupIdentifiersToRules() {
            EntityTransaction db = Entities.get(NetworkRule.class);
            try {
                List networkRuleList = Entities.query((Object)((Object)NetworkRule.named()));
                for (NetworkRule networkRule : networkRuleList) {
                    LOG.debug((Object)("Upgrading " + (Object)((Object)networkRule)));
                    if (networkRule.getNetworkPeers() == null || networkRule.getNetworkPeers().size() <= 0) continue;
                    HashSet updatedPeers = Sets.newHashSet();
                    for (NetworkPeer networkPeer : networkRule.getNetworkPeers()) {
                        if (networkPeer.getGroupId() == null) {
                            String groupId = null;
                            try {
                                if (Accounts.getAccountProvider() == null) {
                                    DatabaseAuthProvider dbAuth = new DatabaseAuthProvider();
                                    Accounts.setAccountProvider((AccountProvider)dbAuth);
                                }
                                NetworkGroup networkGroup = NetworkGroups.lookup((OwnerFullName)AccountFullName.getInstance((String)networkPeer.getUserQueryKey(), (String[])new String[0]), networkPeer.getGroupName());
                                groupId = networkGroup.getGroupId();
                            }
                            catch (NoSuchMetadataException ex) {
                                LOG.error((Object)String.format("unable to find the network group (%s-%s)", networkPeer.getUserQueryKey(), networkPeer.getGroupName()));
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"failed to query network group", (Throwable)ex);
                            }
                            if (groupId != null) {
                                networkPeer.setGroupId(groupId);
                                LOG.debug((Object)("network peer upgraded: " + networkPeer));
                            }
                        }
                        updatedPeers.add(networkPeer);
                    }
                    networkRule.getNetworkPeers().clear();
                    networkRule.setNetworkPeers(updatedPeers);
                }
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
            finally {
                if (db.isActive()) {
                    db.rollback();
                }
            }
        }

        static {
            LOG = Logger.getLogger(NetworkGroupUpgrade.class);
        }
    }

    public static enum State {
        DISABLED,
        PENDING,
        AWAITING_PEER,
        ACTIVE;

    }
}

